/*
 * Decompiled with CFR 0.152.
 */
package com.civfanatics.civ3.biqFile;

import com.civfanatics.civ3.biqFile.BIQSection;
import com.civfanatics.civ3.biqFile.BLDG;
import com.civfanatics.civ3.biqFile.IO;
import com.civfanatics.civ3.biqFile.RULE;
import com.civfanatics.civ3.biqFile.TERR;
import com.civfanatics.civ3.biqFile.TILE;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class CITY
extends BIQSection {
    public static final int OWNER_CIV = 2;
    public static final int OWNER_PLAYER = 3;
    public static final int OWNER_BARBARIANS = 1;
    public static final int OWNER_NONE = 0;
    public static final String[] ownerTypes = new String[]{"None", "Barbarians", "Civ", "Player"};
    public List<TILE> tilesInfluenced;
    private int dataLength = 66;
    private byte hasWalls;
    private byte hasPalace;
    private String name = "";
    private int ownerType = 2;
    private ArrayList<Integer> buildingIDs;
    private int culture = 0;
    private int owner = 1;
    private int size = 1;
    private int x;
    private int y;
    private int cityLevel;
    private int borderLevel = 1;
    private int useAutoName;
    private boolean wallStyleBuilding = false;
    public IO baselink;

    public CITY(IO baselink, String name, int x, int y) {
        this(baselink);
        this.name = name;
        this.x = x;
        this.y = y;
    }

    public CITY(IO baselink) {
        super(baselink);
        this.baselink = baselink;
        this.buildingIDs = new ArrayList();
        this.tilesInfluenced = new LinkedList<TILE>();
    }

    public void trim() {
        this.name = this.name.trim();
    }

    public int getDataLength() {
        return this.dataLength;
    }

    public byte getHasWalls() {
        return this.hasWalls;
    }

    public byte getHasPalace() {
        return this.hasPalace;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public int getOwnerType() {
        return this.ownerType;
    }

    public int getCulture() {
        return this.culture;
    }

    public int getOwner() {
        return this.owner;
    }

    public int getSize() {
        return this.size;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getCityLevel() {
        return this.cityLevel;
    }

    public int getBorderLevel() {
        return this.borderLevel;
    }

    public int getUseAutoName() {
        return this.useAutoName;
    }

    public void setHasWalls(byte hasWalls) {
        this.hasWalls = hasWalls;
    }

    public void setHasPalace(byte hasPalace) {
        this.hasPalace = hasPalace;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setOwnerType(int ownerType) {
        this.ownerType = ownerType;
    }

    public void setCulture(int culture) {
        this.culture = culture;
    }

    public void setOwner(int owner) {
        this.owner = owner;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public void setX(int x) {
        this.x = x;
    }

    public void setY(int y) {
        this.y = y;
    }

    public void setCityLevel(int cityLevel) {
        this.cityLevel = cityLevel;
    }

    public void setBorderLevel(int borderLevel) {
        this.borderLevel = borderLevel;
    }

    public void setUseAutoName(int useAutoName) {
        this.useAutoName = useAutoName;
    }

    public void addBuilding(int newBuildingID) {
        this.buildingIDs.add(newBuildingID);
        this.dataLength += 4;
        if (this.baselink.buildings.get(newBuildingID).getBombardDefence() > 0) {
            this.wallStyleBuilding = true;
        }
    }

    public int getBuildingID(int index) {
        return this.buildingIDs.get(index);
    }

    public int getNumBuildings() {
        return this.buildingIDs.size();
    }

    public void removeBuilding(int id) {
        int max = this.buildingIDs.size();
        for (int i = 0; i < max; ++i) {
            if (this.buildingIDs.get(i) != id) continue;
            this.buildingIDs.remove(i);
            this.dataLength -= 4;
            break;
        }
        this.updateWallStyleBuildingStatus();
    }

    public void removeAllBuildings() {
        this.dataLength -= this.buildingIDs.size() * 4;
        this.buildingIDs.clear();
        this.wallStyleBuilding = false;
    }

    public void handleDeletedBuilding(int buildingID) {
        if (this.buildingIDs.remove((Object)buildingID)) {
            this.dataLength -= 4;
        }
        for (int i = 0; i < this.buildingIDs.size(); ++i) {
            int currentID = this.buildingIDs.get(i);
            if (currentID <= buildingID) continue;
            this.buildingIDs.set(i, currentID - 1);
        }
        this.updateWallStyleBuildingStatus();
    }

    public boolean hasBuilding(int buildingID) {
        return this.buildingIDs.contains(buildingID);
    }

    public boolean hasWallStyleBuilding() {
        return this.wallStyleBuilding;
    }

    public boolean isCapital() {
        for (int buildingID : this.buildingIDs) {
            if (!this.baselink.buildings.get(buildingID).getCenterOfEmpire()) continue;
            return true;
        }
        return false;
    }

    public void updateWallStyleBuildingStatus() {
        for (int buildingID : this.buildingIDs) {
            if (this.baselink.buildings.get(buildingID).getBombardDefence() <= 0) continue;
            this.wallStyleBuilding = true;
            return;
        }
        this.wallStyleBuilding = false;
    }

    public int calculateDefensiveBonus() {
        int defenseBonus = 0;
        for (int i = 0; i < this.buildingIDs.size(); ++i) {
            BLDG building = this.baseLink.buildings.get(this.buildingIDs.get(i));
            defenseBonus += building.getDefenceBonus();
        }
        RULE rules = this.baseLink.rule.get(0);
        defenseBonus = this.size > rules.getMaxCity2Size() ? (defenseBonus += rules.getMetropolisDefenceBonus()) : (this.size > rules.getMaxCity1Size() ? (defenseBonus += rules.getCityDefenceBonus()) : (defenseBonus += rules.getTownDefenceBonus()));
        int tileIndex = this.baseLink.calculateTileIndex(this.x, this.y);
        TILE cityTile = this.baseLink.tile.get(tileIndex);
        TERR cityTerrain = this.baseLink.terrain.get(cityTile.getRealTerrain());
        defenseBonus = cityTile.isLandmark() ? (defenseBonus += cityTerrain.getLandmarkDefenceBonus()) : (defenseBonus += cityTerrain.getDefenceBonus());
        return defenseBonus;
    }

    public boolean isCoastal() {
        ArrayList<Integer> surroundingTiles = this.baselink.getSurroundingTiles(this.x, this.y);
        for (int tile : surroundingTiles) {
            if (!this.baselink.tile.get(tile).isWater()) continue;
            return true;
        }
        return false;
    }

    @Override
    public String toEnglish() {
        return this.toString();
    }

    @Override
    public String toString() {
        String lineReturn = System.getProperty("line.separator");
        String toReturn = "name: " + this.name + lineReturn;
        toReturn = toReturn + "dataLength: " + this.dataLength + lineReturn;
        toReturn = toReturn + "hasWalls: " + this.hasWalls + lineReturn;
        toReturn = toReturn + "hasPalace: " + this.hasPalace + lineReturn;
        toReturn = toReturn + "ownerType: " + this.ownerType + lineReturn;
        toReturn = toReturn + "numBuildings: " + this.getNumBuildings() + lineReturn;
        for (int j = 0; j < this.getNumBuildings(); ++j) {
            toReturn = toReturn + "  building:  " + this.buildingIDs.get(j) + lineReturn;
        }
        toReturn = toReturn + "culture: " + this.culture + lineReturn;
        toReturn = toReturn + "owner: " + this.owner + lineReturn;
        toReturn = toReturn + "size: " + this.size + lineReturn;
        toReturn = toReturn + "x: " + this.x + lineReturn;
        toReturn = toReturn + "y: " + this.y + lineReturn;
        toReturn = toReturn + "cityLevel: " + this.cityLevel + lineReturn;
        toReturn = toReturn + "borderLevel: " + this.borderLevel + lineReturn;
        toReturn = toReturn + "useAutoName: " + this.useAutoName + lineReturn;
        toReturn = toReturn + lineReturn;
        return toReturn;
    }

    @Override
    public String compareTo(BIQSection section, String separator) {
        if (!(section instanceof CITY)) {
            return null;
        }
        CITY two = (CITY)section;
        String toReturn = "";
        String lineReturn = System.getProperty("line.separator");
        if (this.dataLength != two.getDataLength()) {
            toReturn = toReturn + "DataLength: " + this.dataLength + separator + two.getDataLength() + lineReturn;
        }
        if (this.hasWalls != two.getHasWalls()) {
            toReturn = toReturn + "HasWalls: " + this.hasWalls + separator + two.getHasWalls() + lineReturn;
        }
        if (this.hasPalace != two.getHasPalace()) {
            toReturn = toReturn + "HasPalace: " + this.hasPalace + separator + two.getHasPalace() + lineReturn;
        }
        if (this.name.compareTo(two.getName()) != 0) {
            toReturn = toReturn + "Name: " + this.name + separator + two.getName() + lineReturn;
        }
        if (this.ownerType != two.getOwnerType()) {
            toReturn = toReturn + "OwnerType: " + this.ownerType + separator + two.getOwnerType() + lineReturn;
        }
        if (this.getNumBuildings() != two.getNumBuildings()) {
            toReturn = toReturn + "NumBuildings: " + this.getNumBuildings() + separator + two.getNumBuildings() + lineReturn;
        } else {
            for (int i = 0; i < this.getNumBuildings(); ++i) {
                if (this.buildingIDs.get(i) == two.buildingIDs.get(i)) continue;
                toReturn = toReturn + "  building " + i + ": " + this.buildingIDs.get(i) + separator + two.buildingIDs.get(i) + lineReturn;
            }
        }
        if (this.culture != two.getCulture()) {
            toReturn = toReturn + "Culture: " + this.culture + separator + two.getCulture() + lineReturn;
        }
        if (this.owner != two.getOwner()) {
            toReturn = toReturn + "Owner: " + this.owner + separator + two.getOwner() + lineReturn;
        }
        if (this.size != two.getSize()) {
            toReturn = toReturn + "Size: " + this.size + separator + two.getSize() + lineReturn;
        }
        if (this.x != two.getX()) {
            toReturn = toReturn + "X: " + this.x + separator + two.getX() + lineReturn;
        }
        if (this.y != two.getY()) {
            toReturn = toReturn + "Y: " + this.y + separator + two.getY() + lineReturn;
        }
        if (this.cityLevel != two.getCityLevel()) {
            toReturn = toReturn + "CityLevel: " + this.cityLevel + separator + two.getCityLevel() + lineReturn;
        }
        if (this.borderLevel != two.getBorderLevel()) {
            toReturn = toReturn + "BorderLevel: " + this.borderLevel + separator + two.getBorderLevel() + lineReturn;
        }
        if (this.useAutoName != two.getUseAutoName()) {
            toReturn = toReturn + "UseAutoName: " + this.useAutoName + separator + two.getUseAutoName() + lineReturn;
        }
        return toReturn;
    }

    @Override
    public Object getProperty(String string) throws UnsupportedOperationException {
        if (string.equals("Name")) {
            return this.name;
        }
        throw new UnsupportedOperationException();
    }
}

