/*
 * Decompiled with CFR 0.152.
 */
package com.civfanatics.civ3.biqFile;

import com.civfanatics.civ3.biqFile.CONT;
import com.civfanatics.civ3.biqFile.util.LittleEndianDataInputStream;
import java.io.IOException;
import java.util.List;

public class CONTThread
extends Thread {
    LittleEndianDataInputStream in;
    LittleEndianDataInputStream[] inputArray;
    List<CONT> cont;
    int numConts;
    int start;
    Integer cpus;
    Integer returnVal;

    public CONTThread(LittleEndianDataInputStream in, List<CONT> cont, int numConts, int start, Integer cpus) {
        this.in = in;
        this.cont = cont;
        this.numConts = numConts;
        this.start = start;
        this.cpus = cpus;
    }

    public CONTThread(LittleEndianDataInputStream[] inputArray, List<CONT> cont, int numConts) {
        this.inputArray = inputArray;
        this.cont = cont;
        this.numConts = numConts;
    }

    @Override
    public void run() {
        this.multiThreadInputCONT();
    }

    public Integer getReturnValue() {
        return this.returnVal;
    }

    private void multiThreadInputCONT() {
        int bytesOfInput = 0;
        try {
            for (int i = this.start; i < this.numConts; i += this.cpus.intValue()) {
                Integer integer = this.in.readInt();
                bytesOfInput += 4;
                integer = this.in.readInt();
                bytesOfInput += 4;
                this.cont.get(i).setContinentClass(integer);
                integer = this.in.readInt();
                bytesOfInput += 4;
                this.cont.get(i).setNumTiles(integer);
                if (i + this.cpus < this.numConts) {
                    this.in.skipBytes(12 * (this.cpus - 1));
                    continue;
                }
                int toJump = this.numConts - 1 - i;
                this.in.skipBytes(12 * toJump);
            }
        }
        catch (IOException e) {
            System.err.println(e + " in CONTThread");
        }
        this.returnVal = bytesOfInput;
    }
}

