/*
 * Decompiled with CFR 0.152.
 */
package com.civfanatics.civ3.biqFile;

import com.civfanatics.civ3.biqFile.BIQSection;
import com.civfanatics.civ3.biqFile.IO;
import com.civfanatics.civ3.biqFile.TECH;

public class CTZN
extends BIQSection {
    private int dataLength = 124;
    private int defaultCitizen;
    private String name = "";
    private String civilopediaEntry = "";
    private String pluralName = "";
    private int prerequisiteInt;
    private TECH prerequisite;
    private int luxuries;
    private int research;
    private int taxes;
    private int corruption;
    private int construction;

    public CTZN(IO baselink) {
        super(baselink);
    }

    public CTZN(String name, IO baselink) {
        super(baselink);
        this.name = name;
        this.prerequisiteInt = -1;
    }

    public void trim() {
        this.name = this.name.trim();
        this.civilopediaEntry = this.civilopediaEntry.trim();
        this.pluralName = this.pluralName.trim();
    }

    public int getDataLength() {
        return this.dataLength;
    }

    public void increaseDataLength(int change) {
        this.dataLength += change;
    }

    public int getDefaultCitizen() {
        return this.defaultCitizen;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getCivilopediaEntry() {
        return this.civilopediaEntry;
    }

    public String getPluralName() {
        return this.pluralName;
    }

    public int getPrerequisite() {
        return this.prerequisiteInt;
    }

    public int getLuxuries() {
        return this.luxuries;
    }

    public int getResearch() {
        return this.research;
    }

    public int getTaxes() {
        return this.taxes;
    }

    public int getCorruption() {
        return this.corruption;
    }

    public int getConstruction() {
        return this.construction;
    }

    public void setDefaultCitizen(int defaultCitizen) {
        this.defaultCitizen = defaultCitizen;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setCivilopediaEntry(String civilopediaEntry) {
        this.civilopediaEntry = civilopediaEntry;
    }

    public void setPluralName(String pluralName) {
        this.pluralName = pluralName;
    }

    public void setPrerequisite(int prerequisite) {
        this.prerequisiteInt = prerequisite;
        if (this.baseLink.technology != null && this.prerequisiteInt != -1 && this.baseLink.technology.size() > this.prerequisiteInt) {
            this.prerequisite = this.baseLink.technology.get(this.prerequisiteInt);
        }
    }

    public void setLuxuries(int luxuries) {
        this.luxuries = luxuries;
    }

    public void setResearch(int research) {
        this.research = research;
    }

    public void setTaxes(int taxes) {
        this.taxes = taxes;
    }

    public void setCorruption(int corruption) {
        this.corruption = corruption;
    }

    public void setConstruction(int construction) {
        this.construction = construction;
    }

    public void handleDeletedTech(int index) {
        if (this.prerequisiteInt == index) {
            this.prerequisiteInt = -1;
            this.prerequisite = null;
        } else if (this.prerequisiteInt > index) {
            --this.prerequisiteInt;
        }
    }

    public void handleSwappedTech() {
        if (this.prerequisiteInt != -1) {
            this.prerequisiteInt = this.prerequisite.getIndex();
        }
    }

    @Override
    public String toEnglish() {
        return this.toString();
    }

    @Override
    public String toString() {
        String lineReturn = System.getProperty("line.separator");
        String toReturn = "name: " + this.name + lineReturn;
        toReturn = toReturn + "civilopediaEntry: " + this.civilopediaEntry + lineReturn;
        toReturn = toReturn + "dataLength: " + this.dataLength + lineReturn;
        toReturn = toReturn + "defaultCitizen: " + this.defaultCitizen + lineReturn;
        toReturn = toReturn + "pluralName: " + this.pluralName + lineReturn;
        toReturn = toReturn + "prerequisite: " + this.prerequisiteInt + lineReturn;
        toReturn = toReturn + "luxuries: " + this.luxuries + lineReturn;
        toReturn = toReturn + "research: " + this.research + lineReturn;
        toReturn = toReturn + "taxes: " + this.taxes + lineReturn;
        toReturn = toReturn + "corruption: " + this.corruption + lineReturn;
        toReturn = toReturn + "construction: " + this.construction + lineReturn;
        toReturn = toReturn + lineReturn;
        return toReturn;
    }

    @Override
    public String compareTo(BIQSection section, String separator) {
        if (!(section instanceof CTZN)) {
            return null;
        }
        CTZN two = (CTZN)section;
        String lineReturn = System.getProperty("line.separator");
        String toReturn = "name: " + this.name + lineReturn;
        if (this.dataLength != two.getDataLength()) {
            toReturn = toReturn + "DataLength: " + this.dataLength + separator + two.getDataLength() + lineReturn;
        }
        if (this.defaultCitizen != two.getDefaultCitizen()) {
            toReturn = toReturn + "DefaultCitizen: " + this.defaultCitizen + separator + two.getDefaultCitizen() + lineReturn;
        }
        if (this.civilopediaEntry.compareTo(two.getCivilopediaEntry()) != 0) {
            toReturn = toReturn + "CivilopediaEntry: " + this.civilopediaEntry + separator + two.getCivilopediaEntry() + lineReturn;
        }
        if (this.pluralName.compareTo(two.getPluralName()) != 0) {
            toReturn = toReturn + "PluralName: " + this.pluralName + separator + two.getPluralName() + lineReturn;
        }
        if (this.prerequisiteInt != two.getPrerequisite()) {
            toReturn = toReturn + "Prerequisite: " + this.prerequisiteInt + separator + two.getPrerequisite() + lineReturn;
        }
        if (this.luxuries != two.getLuxuries()) {
            toReturn = toReturn + "Luxuries: " + this.luxuries + separator + two.getLuxuries() + lineReturn;
        }
        if (this.research != two.getResearch()) {
            toReturn = toReturn + "Research: " + this.research + separator + two.getResearch() + lineReturn;
        }
        if (this.taxes != two.getTaxes()) {
            toReturn = toReturn + "Taxes: " + this.taxes + separator + two.getTaxes() + lineReturn;
        }
        if (this.corruption != two.getCorruption()) {
            toReturn = toReturn + "Corruption: " + this.corruption + separator + two.getCorruption() + lineReturn;
        }
        if (this.construction != two.getConstruction()) {
            toReturn = toReturn + "Construction: " + this.construction + separator + two.getConstruction() + lineReturn;
        }
        if (toReturn.equals("name: " + this.name + lineReturn)) {
            toReturn = "";
        }
        return toReturn;
    }

    @Override
    public Object getProperty(String string) throws UnsupportedOperationException {
        if (string.equalsIgnoreCase("Name")) {
            return this.name;
        }
        throw new UnsupportedOperationException();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CTZN other = (CTZN)obj;
        if (this.dataLength != other.dataLength) {
            return false;
        }
        if (this.defaultCitizen != other.defaultCitizen) {
            return false;
        }
        if (this.prerequisiteInt != other.prerequisiteInt) {
            return false;
        }
        if (this.luxuries != other.luxuries) {
            return false;
        }
        if (this.research != other.research) {
            return false;
        }
        if (this.taxes != other.taxes) {
            return false;
        }
        if (this.corruption != other.corruption) {
            return false;
        }
        if (this.construction != other.construction) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.civilopediaEntry == null ? other.civilopediaEntry != null : !this.civilopediaEntry.equals(other.civilopediaEntry)) {
            return false;
        }
        if (this.pluralName == null ? other.pluralName != null : !this.pluralName.equals(other.pluralName)) {
            return false;
        }
        return this.prerequisite == other.prerequisite;
    }

    public Object clone() {
        CTZN clone = new CTZN(this.baseLink);
        clone.defaultCitizen = this.defaultCitizen;
        clone.name = this.name;
        clone.civilopediaEntry = this.civilopediaEntry;
        clone.pluralName = this.pluralName;
        clone.prerequisiteInt = this.prerequisiteInt;
        clone.prerequisite = this.prerequisite;
        clone.luxuries = this.luxuries;
        clone.research = this.research;
        clone.taxes = this.taxes;
        clone.corruption = this.corruption;
        clone.construction = this.construction;
        return clone;
    }
}

