/*
 * Decompiled with CFR 0.152.
 */
package com.civfanatics.civ3.biqFile;

import com.civfanatics.civ3.biqFile.BIQSection;
import com.civfanatics.civ3.biqFile.IO;
import com.civfanatics.civ3.biqFile.civ3Version;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class GAME
extends BIQSection {
    public int dataLength;
    public int useDefaultRules;
    public int defaultVictoryConditions;
    public int numberOfPlayableCivs;
    public ArrayList<Integer> idOfPlayableCivs;
    public int victoryConditionsAndRules;
    public boolean dominationEnabled;
    public boolean spaceRaceEnabled;
    public boolean diplomacticEnabled;
    public boolean conquestEnabled;
    public boolean culturalEnabled;
    public boolean civSpecificAbilitiesEnabled;
    public boolean culturallyLinkedStart;
    public boolean restartPlayersEnabled;
    public boolean preserveRandomSeed;
    public boolean acceleratedProduction;
    public boolean eliminationEnabled;
    public boolean regicideEnabled;
    public boolean massRegicideEnabled;
    public boolean victoryLocationsEnabled;
    public boolean captureTheFlag;
    public boolean allowCulturalConversions;
    public boolean wonderVictoryEnabled;
    public boolean reverseCaptureTheFlag;
    public boolean scientificLeaders;
    public int placeCaptureUnits = 1;
    public int autoPlaceKings = 1;
    public int autoPlaceVictoryLocations = 1;
    public int debugMode;
    public int useTimeLimit;
    public int baseTimeUnit;
    public int startMonth = 1;
    public int startWeek = 1;
    public int startYear = -4000;
    public int minuteTimeLimit;
    public int turnTimeLimit = 540;
    public int[] turnsPerTimescalePart;
    public int[] timeUnitsPerTurn;
    public String scenarioSearchFolders = "";
    private String[] searchFolder = new String[0];
    public int revealMap = 0;
    public ArrayList<Integer> civPartOfWhichAlliance;
    public int victoryPointLimit = 50000;
    public int cityEliminationCount = 1;
    public int oneCityCultureWinLimit = 20000;
    public int allCitiesCultureWinLimit = 100000;
    public int dominationTerrainPercent = 66;
    public int dominationPopulationPercent = 66;
    public int wonderVP = 10;
    public int defeatingOpposingUnitVP = 10;
    public int advancementVP = 5;
    public int cityConquestVP = 100;
    public int victoryPointVP = 25;
    public int captureSpecialUnitVP = 1000;
    public int questionMark1;
    byte questionMark2;
    public String alliance0 = "";
    public String alliance1 = "";
    public String alliance2 = "";
    public String alliance3 = "";
    public String alliance4 = "";
    public ArrayList<Integer> warWith0;
    public ArrayList<Integer> warWith1;
    public ArrayList<Integer> warWith2;
    public ArrayList<Integer> warWith3;
    public ArrayList<Integer> warWith4;
    public int allianceVictoryType;
    public String plaugeName = "Black Death";
    byte permitPlagues;
    public int plagueEarliestStart;
    public int plagueVariation;
    public int plagueDuration;
    public int plagueStrength;
    public int plagueGracePeriod = 1;
    public int plagueMaxOccurance = 1;
    public int questionMark3;
    public String unknown = "Unknown";
    public int respawnFlagUnits = 1;
    byte captureAnyFlag;
    public int goldForCapture = 0;
    byte mapVisible;
    byte retainCulture;
    public int questionMark4 = -1;
    public int eruptionPeriod = 5000;
    public int mpBaseTime = 24;
    public int mpCityTime = 3;
    public int mpUnitTime = 1;
    IO baselink;

    public GAME(IO baselink) {
        super(baselink);
        this.baselink = baselink;
        this.idOfPlayableCivs = new ArrayList();
        this.turnsPerTimescalePart = new int[7];
        this.timeUnitsPerTurn = new int[7];
        this.civPartOfWhichAlliance = new ArrayList();
        this.warWith0 = new ArrayList();
        this.warWith1 = new ArrayList();
        this.warWith2 = new ArrayList();
        this.warWith3 = new ArrayList();
        this.warWith4 = new ArrayList();
    }

    public void trim() {
        this.scenarioSearchFolders = this.scenarioSearchFolders.trim();
        if (this.baselink.version == civ3Version.CONQUESTS) {
            this.alliance0 = this.alliance0.trim();
            this.alliance1 = this.alliance1.trim();
            this.alliance2 = this.alliance2.trim();
            this.alliance3 = this.alliance3.trim();
            this.alliance4 = this.alliance4.trim();
            this.plaugeName = this.plaugeName.charAt(0) + this.plaugeName.substring(1).replace('\u00cd', '\u0000');
            this.plaugeName = this.plaugeName.trim();
            this.unknown = this.unknown.trim();
        }
    }

    public int getDataLength() {
        return this.dataLength;
    }

    public int getUseDefaultRules() {
        return this.useDefaultRules;
    }

    public int getDefaultVictoryConditions() {
        return this.defaultVictoryConditions;
    }

    public int getNumberOfPlayableCivs() {
        return this.numberOfPlayableCivs;
    }

    public int getVictoryConditionsAndRules() {
        return this.victoryConditionsAndRules;
    }

    public boolean getDominationEnabled() {
        return this.dominationEnabled;
    }

    public boolean getSpaceRaceEnabled() {
        return this.spaceRaceEnabled;
    }

    public boolean getDiplomacticEnabled() {
        return this.diplomacticEnabled;
    }

    public boolean getConquestEnabled() {
        return this.conquestEnabled;
    }

    public boolean getCulturalEnabled() {
        return this.culturalEnabled;
    }

    public boolean getCivSpecificAbilitiesEnabled() {
        return this.civSpecificAbilitiesEnabled;
    }

    public boolean getCulturallyLinkedStart() {
        return this.culturallyLinkedStart;
    }

    public boolean getRestartPlayersEnabled() {
        return this.restartPlayersEnabled;
    }

    public boolean getPreserveRandomSeed() {
        return this.preserveRandomSeed;
    }

    public boolean getAcceleratedProduction() {
        return this.acceleratedProduction;
    }

    public boolean getEliminationEnabled() {
        return this.eliminationEnabled;
    }

    public boolean getRegicideEnabled() {
        return this.regicideEnabled;
    }

    public boolean getMassRegicideEnabled() {
        return this.massRegicideEnabled;
    }

    public boolean getVictoryLocationsEnabled() {
        return this.victoryLocationsEnabled;
    }

    public boolean getCaptureTheFlag() {
        return this.captureTheFlag;
    }

    public boolean getAllowCulturalConversions() {
        return this.allowCulturalConversions;
    }

    public boolean getWonderVictoryEnabled() {
        return this.wonderVictoryEnabled;
    }

    public boolean getReverseCaptureTheFlag() {
        return this.reverseCaptureTheFlag;
    }

    public int getPlaceCaptureUnits() {
        return this.placeCaptureUnits;
    }

    public int getAutoPlaceKings() {
        return this.autoPlaceKings;
    }

    public int getAutoPlaceVictoryLocations() {
        return this.autoPlaceVictoryLocations;
    }

    public int getDebugMode() {
        return this.debugMode;
    }

    public int getUseTimeLimit() {
        return this.useTimeLimit;
    }

    public int getBaseTimeUnit() {
        return this.baseTimeUnit;
    }

    public int getStartMonth() {
        return this.startMonth;
    }

    public int getStartWeek() {
        return this.startWeek;
    }

    public int getStartYear() {
        return this.startYear;
    }

    public int getMinuteTimeLimit() {
        return this.minuteTimeLimit;
    }

    public int getTurnTimeLimit() {
        return this.turnTimeLimit;
    }

    public String getScenarioSearchFolders() {
        return this.scenarioSearchFolders;
    }

    public String getSearchFolder(int index) {
        return this.searchFolder[index];
    }

    public int getSearchFolderLength() {
        return this.searchFolder.length;
    }

    public int getVictoryPointLimit() {
        return this.victoryPointLimit;
    }

    public int getCityEliminationCount() {
        return this.cityEliminationCount;
    }

    public int getOneCityCultureWinLimit() {
        return this.oneCityCultureWinLimit;
    }

    public int getAllCitiesCultureWinLimit() {
        return this.allCitiesCultureWinLimit;
    }

    public int getDominationTerrainPercent() {
        return this.dominationTerrainPercent;
    }

    public int getDominationPopulationPercent() {
        return this.dominationPopulationPercent;
    }

    public int getWonderVP() {
        return this.wonderVP;
    }

    public int getDefeatingOpposingUnitVP() {
        return this.defeatingOpposingUnitVP;
    }

    public int getAdvancementVP() {
        return this.advancementVP;
    }

    public int getCityConquestVP() {
        return this.cityConquestVP;
    }

    public int getVictoryPointVP() {
        return this.victoryPointVP;
    }

    public int getCaptureSpecialUnitVP() {
        return this.captureSpecialUnitVP;
    }

    public int getQuestionMark1() {
        return this.questionMark1;
    }

    public byte getQuestionMark2() {
        return this.questionMark2;
    }

    public String getAlliance0() {
        return this.alliance0;
    }

    public String getAlliance1() {
        return this.alliance1;
    }

    public String getAlliance2() {
        return this.alliance2;
    }

    public String getAlliance3() {
        return this.alliance3;
    }

    public String getAlliance4() {
        return this.alliance4;
    }

    public int getAllianceVictoryType() {
        return this.allianceVictoryType;
    }

    public String getPlaugeName() {
        return this.plaugeName;
    }

    public byte getPermitPlagues() {
        return this.permitPlagues;
    }

    public int getPlagueEarliestStart() {
        return this.plagueEarliestStart;
    }

    public int getPlagueVariation() {
        return this.plagueVariation;
    }

    public int getPlagueDuration() {
        return this.plagueDuration;
    }

    public int getPlagueStrength() {
        return this.plagueStrength;
    }

    public int getPlagueGracePeriod() {
        return this.plagueGracePeriod;
    }

    public int getPlagueMaxOccurance() {
        return this.plagueMaxOccurance;
    }

    public int getQuestionMark3() {
        return this.questionMark3;
    }

    public String getUnknown() {
        return this.unknown;
    }

    public int getRespawnFlagUnits() {
        return this.respawnFlagUnits;
    }

    public byte getCaptureAnyFlag() {
        return this.captureAnyFlag;
    }

    public int getGoldForCapture() {
        return this.goldForCapture;
    }

    public byte getMapVisible() {
        return this.mapVisible;
    }

    public int getRevealMap() {
        return this.revealMap;
    }

    public byte getRetainCulture() {
        return this.retainCulture;
    }

    public int getQuestionMark4() {
        return this.questionMark4;
    }

    public int getEruptionPeriod() {
        return this.eruptionPeriod;
    }

    public int getMpBaseTime() {
        return this.mpBaseTime;
    }

    public int getMpCityTime() {
        return this.mpCityTime;
    }

    public int getMpUnitTime() {
        return this.mpUnitTime;
    }

    public void setDataLength(int dataLength) {
        this.dataLength = dataLength;
    }

    public void setUseDefaultRules(int useDefaultRules) {
        this.useDefaultRules = useDefaultRules;
    }

    public void setDefaultVictoryConditions(int defaultVictoryConditions) {
        this.defaultVictoryConditions = defaultVictoryConditions;
    }

    public void setNumberOfPlayableCivs(int numberOfPlayableCivs) {
        this.numberOfPlayableCivs = numberOfPlayableCivs;
    }

    public void setVictoryConditionsAndRules(int victoryConditionsAndRules) {
        this.victoryConditionsAndRules = victoryConditionsAndRules;
    }

    public void setPlaceCaptureUnits(int placeCaptureUnits) {
        this.placeCaptureUnits = placeCaptureUnits;
    }

    public void setAutoPlaceKings(int autoPlaceKings) {
        this.autoPlaceKings = autoPlaceKings;
    }

    public void setAutoPlaceVictoryLocations(int autoPlaceVictoryLocations) {
        this.autoPlaceVictoryLocations = autoPlaceVictoryLocations;
    }

    public void setDebugMode(int debugMode) {
        this.debugMode = debugMode;
    }

    public void setUseTimeLimit(int useTimeLimit) {
        this.useTimeLimit = useTimeLimit;
    }

    public void setBaseTimeUnit(int baseTimeUnit) {
        this.baseTimeUnit = baseTimeUnit;
    }

    public void setStartMonth(int startMonth) {
        this.startMonth = startMonth;
    }

    public void setStartWeek(int startWeek) {
        this.startWeek = startWeek;
    }

    public void setStartYear(int startYear) {
        this.startYear = startYear;
    }

    public void setMinuteTimeLimit(int minuteTimeLimit) {
        this.minuteTimeLimit = minuteTimeLimit;
    }

    public void setTurnTimeLimit(int turnTimeLimit) {
        this.turnTimeLimit = turnTimeLimit;
    }

    public void setScenarioSearchFolders(String scenarioSearchFolders) {
        this.scenarioSearchFolders = scenarioSearchFolders;
        StringTokenizer tokenizer = new StringTokenizer(scenarioSearchFolders, ";");
        this.searchFolder = new String[tokenizer.countTokens()];
        int count = 0;
        while (tokenizer.hasMoreTokens()) {
            this.searchFolder[count] = tokenizer.nextToken();
            ++count;
        }
    }

    public void setVictoryPointLimit(int victoryPointLimit) {
        this.victoryPointLimit = victoryPointLimit;
    }

    public void setCityEliminationCount(int cityEliminationCount) {
        this.cityEliminationCount = cityEliminationCount;
    }

    public void setOneCityCultureWinLimit(int oneCityCultureWinLimit) {
        this.oneCityCultureWinLimit = oneCityCultureWinLimit;
    }

    public void setAllCitiesCultureWinLimit(int allCitiesCultureWinLimit) {
        this.allCitiesCultureWinLimit = allCitiesCultureWinLimit;
    }

    public void setDominationTerrainPercent(int dominationTerrainPercent) {
        this.dominationTerrainPercent = dominationTerrainPercent;
    }

    public void setDominationPopulationPercent(int dominationPopulationPercent) {
        this.dominationPopulationPercent = dominationPopulationPercent;
    }

    public void setWonderVP(int wonderVP) {
        this.wonderVP = wonderVP;
    }

    public void setDefeatingOpposingUnitVP(int defeatingOpposingUnitVP) {
        this.defeatingOpposingUnitVP = defeatingOpposingUnitVP;
    }

    public void setAdvancementVP(int advancementVP) {
        this.advancementVP = advancementVP;
    }

    public void setCityConquestVP(int cityConquestVP) {
        this.cityConquestVP = cityConquestVP;
    }

    public void setVictoryPointVP(int victoryPointVP) {
        this.victoryPointVP = victoryPointVP;
    }

    public void setCaptureSpecialUnitVP(int captureSpecialUnitVP) {
        this.captureSpecialUnitVP = captureSpecialUnitVP;
    }

    public void setQuestionMark1(int questionMark1) {
        this.questionMark1 = questionMark1;
    }

    public void setQuestionMark2(byte questionMark2) {
        this.questionMark2 = questionMark2;
    }

    public void setRevealMap(int revealMap) {
        this.revealMap = revealMap;
    }

    public void setAlliance0(String alliance0) {
        this.alliance0 = alliance0;
    }

    public void setAlliance1(String alliance1) {
        this.alliance1 = alliance1;
    }

    public void setAlliance2(String alliance2) {
        this.alliance2 = alliance2;
    }

    public void setAlliance3(String alliance3) {
        this.alliance3 = alliance3;
    }

    public void setAlliance4(String alliance4) {
        this.alliance4 = alliance4;
    }

    public void setAllianceVictoryType(int allianceVictoryType) {
        this.allianceVictoryType = allianceVictoryType;
    }

    public void setPlaugeName(String plaugeName) {
        this.plaugeName = plaugeName;
    }

    public void setPermitPlagues(byte permitPlagues) {
        this.permitPlagues = permitPlagues;
    }

    public void setPlagueEarliestStart(int plagueEarliestStart) {
        this.plagueEarliestStart = plagueEarliestStart;
    }

    public void setPlagueVariation(int plagueVariation) {
        this.plagueVariation = plagueVariation;
    }

    public void setPlagueDuration(int plagueDuration) {
        this.plagueDuration = plagueDuration;
    }

    public void setPlagueStrength(int plagueStrength) {
        this.plagueStrength = plagueStrength;
    }

    public void setPlagueGracePeriod(int plagueGracePeriod) {
        this.plagueGracePeriod = plagueGracePeriod;
    }

    public void setPlagueMaxOccurance(int plagueMaxOccurance) {
        this.plagueMaxOccurance = plagueMaxOccurance;
    }

    public void setQuestionMark3(int questionMark3) {
        this.questionMark3 = questionMark3;
    }

    public void setUnknown(String unknown) {
        this.unknown = unknown;
    }

    public void setRespawnFlagUnits(int respawnFlagUnits) {
        this.respawnFlagUnits = respawnFlagUnits;
    }

    public void setCaptureAnyFlag(byte captureAnyFlag) {
        this.captureAnyFlag = captureAnyFlag;
    }

    public void setGoldForCapture(int goldForCapture) {
        this.goldForCapture = goldForCapture;
    }

    public void setMapVisible(byte mapVisible) {
        this.mapVisible = mapVisible;
    }

    public void setRetainCulture(byte retainCulture) {
        this.retainCulture = retainCulture;
    }

    public void setQuestionMark4(int questionMark4) {
        this.questionMark4 = questionMark4;
    }

    public void setEruptionPeriod(int eruptionPeriod) {
        this.eruptionPeriod = eruptionPeriod;
    }

    public void setMpBaseTime(int mpBaseTime) {
        this.mpBaseTime = mpBaseTime;
    }

    public void setMpCityTime(int mpCityTime) {
        this.mpCityTime = mpCityTime;
    }

    public void setMpUnitTime(int mpUnitTime) {
        this.mpUnitTime = mpUnitTime;
    }

    public void setTurnsPerTimescalePart(int part, int turns) {
        this.turnsPerTimescalePart[part] = turns;
    }

    public void setTimeUnitsPerTurn(int part, int timeUnits) {
        this.timeUnitsPerTurn[part] = timeUnits;
    }

    public void setWarWithAlliance(int alliance1, int alliance2, int war) {
    }

    public void convertFromVanillaToPTW() {
        this.dataLength += 44;
        this.dataLength += 56;
        this.dataLength += 5200;
    }

    public void convertFromPTWToConquests() {
        int c;
        this.dataLength += 2017;
        this.dataLength += this.getNumberOfPlayableCivs() * 4;
        if (this.numberOfPlayableCivs > 0) {
            for (c = 0; c < this.numberOfPlayableCivs; ++c) {
                this.civPartOfWhichAlliance.add(0);
            }
        } else {
            for (c = 0; c < this.baselink.civilization.size() - 1; ++c) {
                this.civPartOfWhichAlliance.add(0);
            }
        }
        for (int j = 0; j < 5; ++j) {
            this.warWith0.add(0);
            this.warWith1.add(0);
            this.warWith2.add(0);
            this.warWith3.add(0);
            this.warWith4.add(0);
        }
    }

    public void extractEnglish() {
        int victoryConditionCopy = this.victoryConditionsAndRules;
        int divBy = victoryConditionCopy / (int)Math.pow(2.0, 18.0);
        if (divBy == 1) {
            this.scientificLeaders = true;
        }
        if ((divBy = victoryConditionCopy / (int)Math.pow(2.0, 17.0)) == 1) {
            this.reverseCaptureTheFlag = true;
            victoryConditionCopy -= 131072;
        }
        if ((divBy = victoryConditionCopy / (int)Math.pow(2.0, 16.0)) == 1) {
            this.wonderVictoryEnabled = true;
            victoryConditionCopy -= 65536;
        }
        if ((divBy = victoryConditionCopy / (int)Math.pow(2.0, 15.0)) == 1) {
            this.allowCulturalConversions = true;
            victoryConditionCopy -= 32768;
        }
        if ((divBy = victoryConditionCopy / (int)Math.pow(2.0, 14.0)) == 1) {
            this.captureTheFlag = true;
            victoryConditionCopy -= 16384;
        }
        if ((divBy = victoryConditionCopy / (int)Math.pow(2.0, 13.0)) == 1) {
            this.victoryLocationsEnabled = true;
            victoryConditionCopy -= 8192;
        }
        if ((divBy = victoryConditionCopy / (int)Math.pow(2.0, 12.0)) == 1) {
            this.massRegicideEnabled = true;
            victoryConditionCopy -= 4096;
        }
        if ((divBy = victoryConditionCopy / (int)Math.pow(2.0, 11.0)) == 1) {
            this.regicideEnabled = true;
            victoryConditionCopy -= 2048;
        }
        if ((divBy = victoryConditionCopy / (int)Math.pow(2.0, 10.0)) == 1) {
            this.eliminationEnabled = true;
            victoryConditionCopy -= 1024;
        }
        if ((divBy = victoryConditionCopy / (int)Math.pow(2.0, 9.0)) == 1) {
            this.acceleratedProduction = true;
            victoryConditionCopy -= 512;
        }
        if ((divBy = victoryConditionCopy / (int)Math.pow(2.0, 8.0)) == 1) {
            this.preserveRandomSeed = true;
            victoryConditionCopy -= 256;
        }
        if ((divBy = victoryConditionCopy / (int)Math.pow(2.0, 7.0)) == 1) {
            this.restartPlayersEnabled = true;
            victoryConditionCopy -= 128;
        }
        if ((divBy = victoryConditionCopy / (int)Math.pow(2.0, 6.0)) == 1) {
            this.culturallyLinkedStart = true;
            victoryConditionCopy -= 64;
        }
        if ((divBy = victoryConditionCopy / (int)Math.pow(2.0, 5.0)) == 1) {
            this.civSpecificAbilitiesEnabled = true;
            victoryConditionCopy -= 32;
        }
        if ((divBy = victoryConditionCopy / (int)Math.pow(2.0, 4.0)) == 1) {
            this.culturalEnabled = true;
            victoryConditionCopy -= 16;
        }
        if ((divBy = victoryConditionCopy / (int)Math.pow(2.0, 3.0)) == 1) {
            this.conquestEnabled = true;
            victoryConditionCopy -= 8;
        }
        if ((divBy = victoryConditionCopy / (int)Math.pow(2.0, 2.0)) == 1) {
            this.diplomacticEnabled = true;
            victoryConditionCopy -= 4;
        }
        if ((divBy = victoryConditionCopy / (int)Math.pow(2.0, 1.0)) == 1) {
            this.spaceRaceEnabled = true;
            victoryConditionCopy -= 2;
        }
        if ((divBy = victoryConditionCopy / (int)Math.pow(2.0, 0.0)) == 1) {
            this.dominationEnabled = true;
            --victoryConditionCopy;
        }
        StringTokenizer tokenizer = new StringTokenizer(this.scenarioSearchFolders, ";");
        this.searchFolder = new String[tokenizer.countTokens()];
        int count = 0;
        while (tokenizer.hasMoreTokens()) {
            this.searchFolder[count] = tokenizer.nextToken();
            ++count;
        }
    }

    @Override
    public String toString() {
        int j;
        String lineReturn = System.getProperty("line.separator");
        String toReturn = "dataLength: " + this.dataLength + lineReturn;
        toReturn = toReturn + "useDefaultRules: " + this.useDefaultRules + lineReturn;
        toReturn = toReturn + "defaultVictoryConditions: " + this.defaultVictoryConditions + lineReturn;
        toReturn = toReturn + "numberOfPlayableCivs: " + this.numberOfPlayableCivs + lineReturn;
        for (j = 0; j < this.numberOfPlayableCivs; ++j) {
            toReturn = toReturn + "playable civ: " + this.idOfPlayableCivs.get(j) + lineReturn;
        }
        toReturn = toReturn + "victoryConditionsAndRules: " + this.victoryConditionsAndRules + lineReturn;
        toReturn = toReturn + "placeCaptureUnits: " + this.placeCaptureUnits + lineReturn;
        toReturn = toReturn + "autoPlaceKings: " + this.autoPlaceKings + lineReturn;
        toReturn = toReturn + "autoPlaceVictoryLocations: " + this.autoPlaceVictoryLocations + lineReturn;
        toReturn = toReturn + "debugMode: " + this.debugMode + lineReturn;
        toReturn = toReturn + "useTimeLimit: " + this.useTimeLimit + lineReturn;
        toReturn = toReturn + "baseTimeUnit: " + this.baseTimeUnit + lineReturn;
        toReturn = toReturn + "startMonth: " + this.startMonth + lineReturn;
        toReturn = toReturn + "startWeek: " + this.startWeek + lineReturn;
        toReturn = toReturn + "startYear: " + this.startYear + lineReturn;
        toReturn = toReturn + "minuteTimeLimit: " + this.minuteTimeLimit + lineReturn;
        toReturn = toReturn + "turnTimeLimit: " + this.turnTimeLimit + lineReturn;
        for (j = 0; j < 7; ++j) {
            toReturn = toReturn + "turns in time section " + j + ": " + this.turnsPerTimescalePart[j] + lineReturn;
            toReturn = toReturn + "time per turn in time section " + j + ": " + this.timeUnitsPerTurn[j] + lineReturn;
        }
        toReturn = toReturn + "scenarioSearchFolders: " + this.scenarioSearchFolders + lineReturn;
        for (j = 0; j < this.numberOfPlayableCivs; ++j) {
            toReturn = toReturn + "civ " + j + " is in alliance " + this.civPartOfWhichAlliance.get(j) + lineReturn;
        }
        toReturn = toReturn + "victoryPointLimit: " + this.victoryPointLimit + lineReturn;
        toReturn = toReturn + "cityEliminationCount: " + this.cityEliminationCount + lineReturn;
        toReturn = toReturn + "oneCityCultureWinLimit: " + this.oneCityCultureWinLimit + lineReturn;
        toReturn = toReturn + "allCitiesCultureWinLimit: " + this.allCitiesCultureWinLimit + lineReturn;
        toReturn = toReturn + "dominationTerrainPercent: " + this.dominationTerrainPercent + lineReturn;
        toReturn = toReturn + "dominationPopulationPercent: " + this.dominationPopulationPercent + lineReturn;
        toReturn = toReturn + "wonderVP: " + this.wonderVP + lineReturn;
        toReturn = toReturn + "defeatingOpposingUnitVP: " + this.defeatingOpposingUnitVP + lineReturn;
        toReturn = toReturn + "advancementVP: " + this.advancementVP + lineReturn;
        toReturn = toReturn + "cityConquestVP: " + this.cityConquestVP + lineReturn;
        toReturn = toReturn + "victoryPointVP: " + this.victoryPointVP + lineReturn;
        toReturn = toReturn + "captureSpecialUnitVP: " + this.captureSpecialUnitVP + lineReturn;
        toReturn = toReturn + "questionMark1: " + this.questionMark1 + lineReturn;
        toReturn = toReturn + "questionMark2: " + this.questionMark2 + lineReturn;
        toReturn = toReturn + "alliance0: " + this.alliance0 + lineReturn;
        toReturn = toReturn + "alliance1: " + this.alliance1 + lineReturn;
        toReturn = toReturn + "alliance2: " + this.alliance2 + lineReturn;
        toReturn = toReturn + "alliance3: " + this.alliance3 + lineReturn;
        toReturn = toReturn + "alliance4: " + this.alliance4 + lineReturn;
        for (j = 0; j < 5; ++j) {
            toReturn = toReturn + "alliance" + j + " is at war with alliance0?" + this.warWith0.get(j) + lineReturn;
            toReturn = toReturn + "alliance" + j + " is at war with alliance1?" + this.warWith1.get(j) + lineReturn;
            toReturn = toReturn + "alliance" + j + " is at war with alliance2?" + this.warWith2.get(j) + lineReturn;
            toReturn = toReturn + "alliance" + j + " is at war with alliance3?" + this.warWith3.get(j) + lineReturn;
            toReturn = toReturn + "alliance" + j + " is at war with alliance4?" + this.warWith4.get(j) + lineReturn;
        }
        toReturn = toReturn + "allianceVictoryType: " + this.allianceVictoryType + lineReturn;
        toReturn = toReturn + "plaugeName: " + this.plaugeName + lineReturn;
        toReturn = toReturn + "permitPlagues: " + this.permitPlagues + lineReturn;
        toReturn = toReturn + "plagueEarliestStart: " + this.plagueEarliestStart + lineReturn;
        toReturn = toReturn + "plagueVariation: " + this.plagueVariation + lineReturn;
        toReturn = toReturn + "plagueDuration: " + this.plagueDuration + lineReturn;
        toReturn = toReturn + "plagueStrength: " + this.plagueStrength + lineReturn;
        toReturn = toReturn + "plagueGracePeriod: " + this.plagueGracePeriod + lineReturn;
        toReturn = toReturn + "plagueMaxOccurance: " + this.plagueMaxOccurance + lineReturn;
        toReturn = toReturn + "questionMark3: " + this.questionMark3 + lineReturn;
        toReturn = toReturn + "unknown: " + this.unknown + lineReturn;
        toReturn = toReturn + "respawnFlagUnits: " + this.respawnFlagUnits + lineReturn;
        toReturn = toReturn + "captureAnyFlag: " + this.captureAnyFlag + lineReturn;
        toReturn = toReturn + "goldForCapture: " + this.goldForCapture + lineReturn;
        toReturn = toReturn + "mapVisible: " + this.mapVisible + lineReturn;
        toReturn = toReturn + "retainCulture: " + this.retainCulture + lineReturn;
        toReturn = toReturn + "questionMark4: " + this.questionMark4 + lineReturn;
        toReturn = toReturn + "eruptionPeriod: " + this.eruptionPeriod + lineReturn;
        toReturn = toReturn + "mpBaseTime: " + this.mpBaseTime + lineReturn;
        toReturn = toReturn + "mpCityTime: " + this.mpCityTime + lineReturn;
        toReturn = toReturn + "mpUnitTime: " + this.mpUnitTime + lineReturn;
        toReturn = toReturn + lineReturn;
        return toReturn;
    }

    @Override
    public String toEnglish() {
        int j;
        String lineReturn = System.getProperty("line.separator");
        String toReturn = "dataLength: " + this.dataLength + lineReturn;
        toReturn = toReturn + "useDefaultRules: " + this.useDefaultRules + lineReturn;
        toReturn = toReturn + "defaultVictoryConditions: " + this.defaultVictoryConditions + lineReturn;
        toReturn = toReturn + "numberOfPlayableCivs: " + this.numberOfPlayableCivs + lineReturn;
        for (j = 0; j < this.numberOfPlayableCivs; ++j) {
            toReturn = toReturn + "playable civ: " + this.idOfPlayableCivs.get(j) + lineReturn;
        }
        toReturn = toReturn + "victoryConditionsAndRules: " + this.victoryConditionsAndRules + lineReturn;
        toReturn = toReturn + "  dominationEnabled: " + this.dominationEnabled + lineReturn;
        toReturn = toReturn + "  spaceRaceEnabled: " + this.spaceRaceEnabled + lineReturn;
        toReturn = toReturn + "  diplomacticEnabled: " + this.diplomacticEnabled + lineReturn;
        toReturn = toReturn + "  conquestEnabled: " + this.conquestEnabled + lineReturn;
        toReturn = toReturn + "  culturalEnabled: " + this.culturalEnabled + lineReturn;
        toReturn = toReturn + "  civSpecificAbilitiesEnabled: " + this.civSpecificAbilitiesEnabled + lineReturn;
        toReturn = toReturn + "  culturallyLinkedStart: " + this.culturallyLinkedStart + lineReturn;
        toReturn = toReturn + "  restartPlayersEnabled: " + this.restartPlayersEnabled + lineReturn;
        toReturn = toReturn + "  preserveRandomSeed: " + this.preserveRandomSeed + lineReturn;
        toReturn = toReturn + "  acceleratedProduction: " + this.acceleratedProduction + lineReturn;
        toReturn = toReturn + "  eliminationEnabled: " + this.eliminationEnabled + lineReturn;
        toReturn = toReturn + "  regicideEnabled: " + this.regicideEnabled + lineReturn;
        toReturn = toReturn + "  massRegicideEnabled: " + this.massRegicideEnabled + lineReturn;
        toReturn = toReturn + "  victoryLocationsEnabled: " + this.victoryLocationsEnabled + lineReturn;
        toReturn = toReturn + "  captureTheFlag: " + this.captureTheFlag + lineReturn;
        toReturn = toReturn + "  allowCulturalConversions: " + this.allowCulturalConversions + lineReturn;
        toReturn = toReturn + "  wonderVictoryEnabled: " + this.wonderVictoryEnabled + lineReturn;
        toReturn = toReturn + "  reverseCaptureTheFlag: " + this.reverseCaptureTheFlag + lineReturn;
        toReturn = toReturn + "placeCaptureUnits: " + this.placeCaptureUnits + lineReturn;
        toReturn = toReturn + "autoPlaceKings: " + this.autoPlaceKings + lineReturn;
        toReturn = toReturn + "autoPlaceVictoryLocations: " + this.autoPlaceVictoryLocations + lineReturn;
        toReturn = toReturn + "debugMode: " + this.debugMode + lineReturn;
        toReturn = toReturn + "useTimeLimit: " + this.useTimeLimit + lineReturn;
        toReturn = toReturn + "baseTimeUnit: " + this.baseTimeUnit + lineReturn;
        toReturn = toReturn + "startMonth: " + this.startMonth + lineReturn;
        toReturn = toReturn + "startWeek: " + this.startWeek + lineReturn;
        toReturn = toReturn + "startYear: " + this.startYear + lineReturn;
        toReturn = toReturn + "minuteTimeLimit: " + this.minuteTimeLimit + lineReturn;
        toReturn = toReturn + "turnTimeLimit: " + this.turnTimeLimit + lineReturn;
        for (j = 0; j < 7; ++j) {
            toReturn = toReturn + "turns in time section " + j + ": " + this.turnsPerTimescalePart[j] + lineReturn;
            toReturn = toReturn + "time per turn in time section " + j + ": " + this.timeUnitsPerTurn[j] + lineReturn;
        }
        toReturn = toReturn + "scenarioSearchFolders: " + this.scenarioSearchFolders + lineReturn;
        for (j = 0; j < this.numberOfPlayableCivs; ++j) {
            toReturn = toReturn + "civ " + j + " is in alliance " + this.civPartOfWhichAlliance.get(j) + lineReturn;
        }
        toReturn = toReturn + "victoryPointLimit: " + this.victoryPointLimit + lineReturn;
        toReturn = toReturn + "cityEliminationCount: " + this.cityEliminationCount + lineReturn;
        toReturn = toReturn + "oneCityCultureWinLimit: " + this.oneCityCultureWinLimit + lineReturn;
        toReturn = toReturn + "allCitiesCultureWinLimit: " + this.allCitiesCultureWinLimit + lineReturn;
        toReturn = toReturn + "dominationTerrainPercent: " + this.dominationTerrainPercent + lineReturn;
        toReturn = toReturn + "dominationPopulationPercent: " + this.dominationPopulationPercent + lineReturn;
        toReturn = toReturn + "wonderVP: " + this.wonderVP + lineReturn;
        toReturn = toReturn + "defeatingOpposingUnitVP: " + this.defeatingOpposingUnitVP + lineReturn;
        toReturn = toReturn + "advancementVP: " + this.advancementVP + lineReturn;
        toReturn = toReturn + "cityConquestVP: " + this.cityConquestVP + lineReturn;
        toReturn = toReturn + "victoryPointVP: " + this.victoryPointVP + lineReturn;
        toReturn = toReturn + "captureSpecialUnitVP: " + this.captureSpecialUnitVP + lineReturn;
        toReturn = toReturn + "questionMark1: " + this.questionMark1 + lineReturn;
        toReturn = toReturn + "questionMark2: " + this.questionMark2 + lineReturn;
        toReturn = toReturn + "alliance0: " + this.alliance0 + lineReturn;
        toReturn = toReturn + "alliance1: " + this.alliance1 + lineReturn;
        toReturn = toReturn + "alliance2: " + this.alliance2 + lineReturn;
        toReturn = toReturn + "alliance3: " + this.alliance3 + lineReturn;
        toReturn = toReturn + "alliance4: " + this.alliance4 + lineReturn;
        for (j = 0; j < 5; ++j) {
            toReturn = toReturn + "alliance" + j + " is at war with alliance0?" + this.warWith0.get(j) + lineReturn;
            toReturn = toReturn + "alliance" + j + " is at war with alliance1?" + this.warWith1.get(j) + lineReturn;
            toReturn = toReturn + "alliance" + j + " is at war with alliance2?" + this.warWith2.get(j) + lineReturn;
            toReturn = toReturn + "alliance" + j + " is at war with alliance3?" + this.warWith3.get(j) + lineReturn;
            toReturn = toReturn + "alliance" + j + " is at war with alliance4?" + this.warWith4.get(j) + lineReturn;
        }
        toReturn = toReturn + "allianceVictoryType: " + this.allianceVictoryType + lineReturn;
        toReturn = toReturn + "plaugeName: " + this.plaugeName + lineReturn;
        toReturn = toReturn + "permitPlagues: " + this.permitPlagues + lineReturn;
        toReturn = toReturn + "plagueEarliestStart: " + this.plagueEarliestStart + lineReturn;
        toReturn = toReturn + "plagueVariation: " + this.plagueVariation + lineReturn;
        toReturn = toReturn + "plagueDuration: " + this.plagueDuration + lineReturn;
        toReturn = toReturn + "plagueStrength: " + this.plagueStrength + lineReturn;
        toReturn = toReturn + "plagueGracePeriod: " + this.plagueGracePeriod + lineReturn;
        toReturn = toReturn + "plagueMaxOccurance: " + this.plagueMaxOccurance + lineReturn;
        toReturn = toReturn + "questionMark3: " + this.questionMark3 + lineReturn;
        toReturn = toReturn + "unknown: " + this.unknown + lineReturn;
        toReturn = toReturn + "respawnFlagUnits: " + this.respawnFlagUnits + lineReturn;
        toReturn = toReturn + "captureAnyFlag: " + this.captureAnyFlag + lineReturn;
        toReturn = toReturn + "goldForCapture: " + this.goldForCapture + lineReturn;
        toReturn = toReturn + "mapVisible: " + this.mapVisible + lineReturn;
        toReturn = toReturn + "retainCulture: " + this.retainCulture + lineReturn;
        toReturn = toReturn + "questionMark4: " + this.questionMark4 + lineReturn;
        toReturn = toReturn + "eruptionPeriod: " + this.eruptionPeriod + lineReturn;
        toReturn = toReturn + "mpBaseTime: " + this.mpBaseTime + lineReturn;
        toReturn = toReturn + "mpCityTime: " + this.mpCityTime + lineReturn;
        toReturn = toReturn + "mpUnitTime: " + this.mpUnitTime + lineReturn;
        toReturn = toReturn + lineReturn;
        return toReturn;
    }

    @Override
    public String compareTo(BIQSection section, String separator) {
        if (!(section instanceof GAME)) {
            return null;
        }
        GAME two = (GAME)section;
        String lineReturn = System.getProperty("line.separator");
        String toReturn = "";
        if (this.dataLength != two.getDataLength()) {
            toReturn = toReturn + "DataLength: " + this.dataLength + separator + two.getDataLength() + lineReturn;
        }
        if (this.useDefaultRules != two.getUseDefaultRules()) {
            toReturn = toReturn + "UseDefaultRules: " + this.useDefaultRules + separator + two.getUseDefaultRules() + lineReturn;
        }
        if (this.defaultVictoryConditions != two.getDefaultVictoryConditions()) {
            toReturn = toReturn + "DefaultVictoryConditions: " + this.defaultVictoryConditions + separator + two.getDefaultVictoryConditions() + lineReturn;
        }
        if (this.numberOfPlayableCivs != two.getNumberOfPlayableCivs()) {
            toReturn = toReturn + "NumberOfPlayableCivs: " + this.numberOfPlayableCivs + separator + two.getNumberOfPlayableCivs() + lineReturn;
        }
        if (this.victoryConditionsAndRules != two.getVictoryConditionsAndRules()) {
            toReturn = toReturn + "VictoryConditionsAndRules: " + this.victoryConditionsAndRules + separator + two.getVictoryConditionsAndRules() + lineReturn;
        }
        if (this.dominationEnabled != two.getDominationEnabled()) {
            toReturn = toReturn + "DominationEnabled: " + this.dominationEnabled + separator + two.getDominationEnabled() + lineReturn;
        }
        if (this.spaceRaceEnabled != two.getSpaceRaceEnabled()) {
            toReturn = toReturn + "SpaceRaceEnabled: " + this.spaceRaceEnabled + separator + two.getSpaceRaceEnabled() + lineReturn;
        }
        if (this.diplomacticEnabled != two.getDiplomacticEnabled()) {
            toReturn = toReturn + "DiplomacticEnabled: " + this.diplomacticEnabled + separator + two.getDiplomacticEnabled() + lineReturn;
        }
        if (this.conquestEnabled != two.getConquestEnabled()) {
            toReturn = toReturn + "ConquestEnabled: " + this.conquestEnabled + separator + two.getConquestEnabled() + lineReturn;
        }
        if (this.culturalEnabled != two.getCulturalEnabled()) {
            toReturn = toReturn + "CulturalEnabled: " + this.culturalEnabled + separator + two.getCulturalEnabled() + lineReturn;
        }
        if (this.civSpecificAbilitiesEnabled != two.getCivSpecificAbilitiesEnabled()) {
            toReturn = toReturn + "CivSpecificAbilitiesEnabled: " + this.civSpecificAbilitiesEnabled + separator + two.getCivSpecificAbilitiesEnabled() + lineReturn;
        }
        if (this.culturallyLinkedStart != two.getCulturallyLinkedStart()) {
            toReturn = toReturn + "CulturallyLinkedStart: " + this.culturallyLinkedStart + separator + two.getCulturallyLinkedStart() + lineReturn;
        }
        if (this.restartPlayersEnabled != two.getRestartPlayersEnabled()) {
            toReturn = toReturn + "RestartPlayersEnabled: " + this.restartPlayersEnabled + separator + two.getRestartPlayersEnabled() + lineReturn;
        }
        if (this.preserveRandomSeed != two.getPreserveRandomSeed()) {
            toReturn = toReturn + "PreserveRandomSeed: " + this.preserveRandomSeed + separator + two.getPreserveRandomSeed() + lineReturn;
        }
        if (this.acceleratedProduction != two.getAcceleratedProduction()) {
            toReturn = toReturn + "AcceleratedProduction: " + this.acceleratedProduction + separator + two.getAcceleratedProduction() + lineReturn;
        }
        if (this.eliminationEnabled != two.getEliminationEnabled()) {
            toReturn = toReturn + "EliminationEnabled: " + this.eliminationEnabled + separator + two.getEliminationEnabled() + lineReturn;
        }
        if (this.regicideEnabled != two.getRegicideEnabled()) {
            toReturn = toReturn + "RegicideEnabled: " + this.regicideEnabled + separator + two.getRegicideEnabled() + lineReturn;
        }
        if (this.massRegicideEnabled != two.getMassRegicideEnabled()) {
            toReturn = toReturn + "MassRegicideEnabled: " + this.massRegicideEnabled + separator + two.getMassRegicideEnabled() + lineReturn;
        }
        if (this.victoryLocationsEnabled != two.getVictoryLocationsEnabled()) {
            toReturn = toReturn + "VictoryLocationsEnabled: " + this.victoryLocationsEnabled + separator + two.getVictoryLocationsEnabled() + lineReturn;
        }
        if (this.captureTheFlag != two.getCaptureTheFlag()) {
            toReturn = toReturn + "CaptureTheFlag: " + this.captureTheFlag + separator + two.getCaptureTheFlag() + lineReturn;
        }
        if (this.allowCulturalConversions != two.getAllowCulturalConversions()) {
            toReturn = toReturn + "AllowCulturalConversions: " + this.allowCulturalConversions + separator + two.getAllowCulturalConversions() + lineReturn;
        }
        if (this.wonderVictoryEnabled != two.getWonderVictoryEnabled()) {
            toReturn = toReturn + "WonderVictoryEnabled: " + this.wonderVictoryEnabled + separator + two.getWonderVictoryEnabled() + lineReturn;
        }
        if (this.reverseCaptureTheFlag != two.getReverseCaptureTheFlag()) {
            toReturn = toReturn + "ReverseCaptureTheFlag: " + this.reverseCaptureTheFlag + separator + two.getReverseCaptureTheFlag() + lineReturn;
        }
        if (this.placeCaptureUnits != two.getPlaceCaptureUnits()) {
            toReturn = toReturn + "PlaceCaptureUnits: " + this.placeCaptureUnits + separator + two.getPlaceCaptureUnits() + lineReturn;
        }
        if (this.autoPlaceKings != two.getAutoPlaceKings()) {
            toReturn = toReturn + "AutoPlaceKings: " + this.autoPlaceKings + separator + two.getAutoPlaceKings() + lineReturn;
        }
        if (this.autoPlaceVictoryLocations != two.getAutoPlaceVictoryLocations()) {
            toReturn = toReturn + "AutoPlaceVictoryLocations: " + this.autoPlaceVictoryLocations + separator + two.getAutoPlaceVictoryLocations() + lineReturn;
        }
        if (this.debugMode != two.getDebugMode()) {
            toReturn = toReturn + "DebugMode: " + this.debugMode + separator + two.getDebugMode() + lineReturn;
        }
        if (this.useTimeLimit != two.getUseTimeLimit()) {
            toReturn = toReturn + "UseTimeLimit: " + this.useTimeLimit + separator + two.getUseTimeLimit() + lineReturn;
        }
        if (this.baseTimeUnit != two.getBaseTimeUnit()) {
            toReturn = toReturn + "BaseTimeUnit: " + this.baseTimeUnit + separator + two.getBaseTimeUnit() + lineReturn;
        }
        if (this.startMonth != two.getStartMonth()) {
            toReturn = toReturn + "StartMonth: " + this.startMonth + separator + two.getStartMonth() + lineReturn;
        }
        if (this.startWeek != two.getStartWeek()) {
            toReturn = toReturn + "StartWeek: " + this.startWeek + separator + two.getStartWeek() + lineReturn;
        }
        if (this.startYear != two.getStartYear()) {
            toReturn = toReturn + "StartYear: " + this.startYear + separator + two.getStartYear() + lineReturn;
        }
        if (this.minuteTimeLimit != two.getMinuteTimeLimit()) {
            toReturn = toReturn + "MinuteTimeLimit: " + this.minuteTimeLimit + separator + two.getMinuteTimeLimit() + lineReturn;
        }
        if (this.turnTimeLimit != two.getTurnTimeLimit()) {
            toReturn = toReturn + "TurnTimeLimit: " + this.turnTimeLimit + separator + two.getTurnTimeLimit() + lineReturn;
        }
        if (this.scenarioSearchFolders.compareTo(two.getScenarioSearchFolders()) != 0) {
            toReturn = toReturn + "ScenarioSearchFolders: " + this.scenarioSearchFolders + separator + two.getScenarioSearchFolders() + lineReturn;
        }
        if (this.victoryPointLimit != two.getVictoryPointLimit()) {
            toReturn = toReturn + "VictoryPointLimit: " + this.victoryPointLimit + separator + two.getVictoryPointLimit() + lineReturn;
        }
        if (this.cityEliminationCount != two.getCityEliminationCount()) {
            toReturn = toReturn + "CityEliminationCount: " + this.cityEliminationCount + separator + two.getCityEliminationCount() + lineReturn;
        }
        if (this.oneCityCultureWinLimit != two.getOneCityCultureWinLimit()) {
            toReturn = toReturn + "OneCityCultureWinLimit: " + this.oneCityCultureWinLimit + separator + two.getOneCityCultureWinLimit() + lineReturn;
        }
        if (this.allCitiesCultureWinLimit != two.getAllCitiesCultureWinLimit()) {
            toReturn = toReturn + "AllCitiesCultureWinLimit: " + this.allCitiesCultureWinLimit + separator + two.getAllCitiesCultureWinLimit() + lineReturn;
        }
        if (this.dominationTerrainPercent != two.getDominationTerrainPercent()) {
            toReturn = toReturn + "DominationTerrainPercent: " + this.dominationTerrainPercent + separator + two.getDominationTerrainPercent() + lineReturn;
        }
        if (this.dominationPopulationPercent != two.getDominationPopulationPercent()) {
            toReturn = toReturn + "DominationPopulationPercent: " + this.dominationPopulationPercent + separator + two.getDominationPopulationPercent() + lineReturn;
        }
        if (this.wonderVP != two.getWonderVP()) {
            toReturn = toReturn + "WonderVP: " + this.wonderVP + separator + two.getWonderVP() + lineReturn;
        }
        if (this.defeatingOpposingUnitVP != two.getDefeatingOpposingUnitVP()) {
            toReturn = toReturn + "DefeatingOpposingUnitVP: " + this.defeatingOpposingUnitVP + separator + two.getDefeatingOpposingUnitVP() + lineReturn;
        }
        if (this.advancementVP != two.getAdvancementVP()) {
            toReturn = toReturn + "AdvancementVP: " + this.advancementVP + separator + two.getAdvancementVP() + lineReturn;
        }
        if (this.cityConquestVP != two.getCityConquestVP()) {
            toReturn = toReturn + "CityConquestVP: " + this.cityConquestVP + separator + two.getCityConquestVP() + lineReturn;
        }
        if (this.victoryPointVP != two.getVictoryPointVP()) {
            toReturn = toReturn + "VictoryPointVP: " + this.victoryPointVP + separator + two.getVictoryPointVP() + lineReturn;
        }
        if (this.captureSpecialUnitVP != two.getCaptureSpecialUnitVP()) {
            toReturn = toReturn + "CaptureSpecialUnitVP: " + this.captureSpecialUnitVP + separator + two.getCaptureSpecialUnitVP() + lineReturn;
        }
        if (this.questionMark1 != two.getQuestionMark1()) {
            toReturn = toReturn + "QuestionMark1: " + this.questionMark1 + separator + two.getQuestionMark1() + lineReturn;
        }
        if (this.questionMark2 != two.getQuestionMark2()) {
            toReturn = toReturn + "QuestionMark2: " + this.questionMark2 + separator + two.getQuestionMark2() + lineReturn;
        }
        if (this.alliance0.compareTo(two.getAlliance0()) != 0) {
            toReturn = toReturn + "Alliance0: " + this.alliance0 + separator + two.getAlliance0() + lineReturn;
        }
        if (this.alliance1.compareTo(two.getAlliance1()) != 0) {
            toReturn = toReturn + "Alliance1: " + this.alliance1 + separator + two.getAlliance1() + lineReturn;
        }
        if (this.alliance2.compareTo(two.getAlliance2()) != 0) {
            toReturn = toReturn + "Alliance2: " + this.alliance2 + separator + two.getAlliance2() + lineReturn;
        }
        if (this.alliance3.compareTo(two.getAlliance3()) != 0) {
            toReturn = toReturn + "Alliance3: " + this.alliance3 + separator + two.getAlliance3() + lineReturn;
        }
        if (this.alliance4.compareTo(two.getAlliance4()) != 0) {
            toReturn = toReturn + "Alliance4: " + this.alliance4 + separator + two.getAlliance4() + lineReturn;
        }
        if (this.allianceVictoryType != two.getAllianceVictoryType()) {
            toReturn = toReturn + "AllianceVictoryType: " + this.allianceVictoryType + separator + two.getAllianceVictoryType() + lineReturn;
        }
        if (this.plaugeName.compareTo(two.getPlaugeName()) != 0) {
            toReturn = toReturn + "PlaugeName: " + this.plaugeName + separator + two.getPlaugeName() + lineReturn;
        }
        if (this.permitPlagues != two.getPermitPlagues()) {
            toReturn = toReturn + "PermitPlagues: " + this.permitPlagues + separator + two.getPermitPlagues() + lineReturn;
        }
        if (this.plagueEarliestStart != two.getPlagueEarliestStart()) {
            toReturn = toReturn + "PlagueEarliestStart: " + this.plagueEarliestStart + separator + two.getPlagueEarliestStart() + lineReturn;
        }
        if (this.plagueVariation != two.getPlagueVariation()) {
            toReturn = toReturn + "PlagueVariation: " + this.plagueVariation + separator + two.getPlagueVariation() + lineReturn;
        }
        if (this.plagueDuration != two.getPlagueDuration()) {
            toReturn = toReturn + "PlagueDuration: " + this.plagueDuration + separator + two.getPlagueDuration() + lineReturn;
        }
        if (this.plagueStrength != two.getPlagueStrength()) {
            toReturn = toReturn + "PlagueStrength: " + this.plagueStrength + separator + two.getPlagueStrength() + lineReturn;
        }
        if (this.plagueGracePeriod != two.getPlagueGracePeriod()) {
            toReturn = toReturn + "PlagueGracePeriod: " + this.plagueGracePeriod + separator + two.getPlagueGracePeriod() + lineReturn;
        }
        if (this.plagueMaxOccurance != two.getPlagueMaxOccurance()) {
            toReturn = toReturn + "PlagueMaxOccurance: " + this.plagueMaxOccurance + separator + two.getPlagueMaxOccurance() + lineReturn;
        }
        if (this.questionMark3 != two.getQuestionMark3()) {
            toReturn = toReturn + "QuestionMark3: " + this.questionMark3 + separator + two.getQuestionMark3() + lineReturn;
        }
        if (this.unknown.compareTo(two.getUnknown()) != 0) {
            toReturn = toReturn + "Unknown: " + this.unknown + separator + two.getUnknown() + lineReturn;
        }
        if (this.respawnFlagUnits != two.getRespawnFlagUnits()) {
            toReturn = toReturn + "RespawnFlagUnits: " + this.respawnFlagUnits + separator + two.getRespawnFlagUnits() + lineReturn;
        }
        if (this.captureAnyFlag != two.getCaptureAnyFlag()) {
            toReturn = toReturn + "CaptureAnyFlag: " + this.captureAnyFlag + separator + two.getCaptureAnyFlag() + lineReturn;
        }
        if (this.goldForCapture != two.getGoldForCapture()) {
            toReturn = toReturn + "GoldForCapture: " + this.goldForCapture + separator + two.getGoldForCapture() + lineReturn;
        }
        if (this.mapVisible != two.getMapVisible()) {
            toReturn = toReturn + "MapVisible: " + this.mapVisible + separator + two.getMapVisible() + lineReturn;
        }
        if (this.retainCulture != two.getRetainCulture()) {
            toReturn = toReturn + "RetainCulture: " + this.retainCulture + separator + two.getRetainCulture() + lineReturn;
        }
        if (this.questionMark4 != two.getQuestionMark4()) {
            toReturn = toReturn + "QuestionMark4: " + this.questionMark4 + separator + two.getQuestionMark4() + lineReturn;
        }
        if (this.eruptionPeriod != two.getEruptionPeriod()) {
            toReturn = toReturn + "EruptionPeriod: " + this.eruptionPeriod + separator + two.getEruptionPeriod() + lineReturn;
        }
        if (this.mpBaseTime != two.getMpBaseTime()) {
            toReturn = toReturn + "MpBaseTime: " + this.mpBaseTime + separator + two.getMpBaseTime() + lineReturn;
        }
        if (this.mpCityTime != two.getMpCityTime()) {
            toReturn = toReturn + "MpCityTime: " + this.mpCityTime + separator + two.getMpCityTime() + lineReturn;
        }
        if (this.mpUnitTime != two.getMpUnitTime()) {
            toReturn = toReturn + "MpUnitTime: " + this.mpUnitTime + separator + two.getMpUnitTime() + lineReturn;
        }
        if (toReturn.equals("")) {
            toReturn = "";
        }
        return toReturn;
    }

    @Override
    public Object getProperty(String string) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }
}

