/*
 * Decompiled with CFR 0.152.
 */
package com.civfanatics.civ3.biqFile;

import com.civfanatics.civ3.biqFile.BIQSection;
import com.civfanatics.civ3.biqFile.GOVTGOVTRelations;
import com.civfanatics.civ3.biqFile.IO;
import com.civfanatics.civ3.biqFile.TECH;
import java.util.ArrayList;

public class GOVT
extends BIQSection {
    private char iWithAccent = (char)204;
    public int dataLength = 472;
    public int defaultType;
    public int transitionType;
    public int requiresMaintenance;
    public int questionMarkOne;
    public int tilePenalty;
    public int commerceBonus;
    public String name = "";
    public String civilopediaEntry = "";
    public String maleRulerTitle1 = "";
    public String femaleRulerTitle1 = "";
    public String maleRulerTitle2 = "";
    public String femaleRulerTitle2 = "";
    public String maleRulerTitle3 = "";
    public String femaleRulerTitle3 = "";
    public String maleRulerTitle4 = "";
    public String femaleRulerTitle4 = "";
    public int corruption;
    public int immuneTo;
    public int diplomatLevel;
    public int spyLevel;
    public int numberOfGovernments;
    public ArrayList<GOVTGOVTRelations> relations;
    public int hurrying;
    public int assimilationChance;
    public int draftLimit;
    public int militaryPoliceLimit;
    public int rulerTitlePairsUsed;
    public int prerequisiteInt;
    public TECH prerequisiteTechnology;
    public int scienceCap;
    public int workerRate;
    public int questionMarkTwo;
    public int questionMarkThree;
    public int questionMarkFour;
    public int freeUnits;
    public int freeUnitsPerTown;
    public int freeUnitsPerCity;
    public int freeUnitsPerMetropolis;
    public int costPerUnit;
    public int warWeariness;
    public int xenophobic;
    public int forceResettlement;

    public GOVT(IO baselink) {
        super(baselink);
        this.relations = new ArrayList();
    }

    public GOVT(String name, int numGovs, IO baselink) {
        super(baselink);
        this.name = name;
        this.prerequisiteInt = -1;
        this.immuneTo = -1;
        this.numberOfGovernments = numGovs;
        this.dataLength = 472 + numGovs * 12;
        this.relations = new ArrayList();
        for (int i = 0; i <= numGovs; ++i) {
            this.relations.add(new GOVTGOVTRelations());
        }
    }

    public void trim() {
        this.name = this.name.trim();
        this.civilopediaEntry = this.civilopediaEntry.trim();
        this.femaleRulerTitle1 = this.femaleRulerTitle1.charAt(0) + this.femaleRulerTitle1.substring(1).replace(this.iWithAccent, '\u0000');
        this.femaleRulerTitle2 = this.femaleRulerTitle2.charAt(0) + this.femaleRulerTitle2.substring(1).replace(this.iWithAccent, '\u0000');
        this.femaleRulerTitle3 = this.femaleRulerTitle3.charAt(0) + this.femaleRulerTitle3.substring(1).replace(this.iWithAccent, '\u0000');
        this.femaleRulerTitle4 = this.femaleRulerTitle4.charAt(0) + this.femaleRulerTitle4.substring(1).replace(this.iWithAccent, '\u0000');
        this.maleRulerTitle1 = this.maleRulerTitle1.charAt(0) + this.maleRulerTitle1.substring(1).replace(this.iWithAccent, '\u0000');
        this.maleRulerTitle2 = this.maleRulerTitle2.charAt(0) + this.maleRulerTitle2.substring(1).replace(this.iWithAccent, '\u0000');
        this.maleRulerTitle3 = this.maleRulerTitle3.charAt(0) + this.maleRulerTitle3.substring(1).replace(this.iWithAccent, '\u0000');
        this.maleRulerTitle4 = this.maleRulerTitle4.charAt(0) + this.maleRulerTitle4.substring(1).replace(this.iWithAccent, '\u0000');
        this.femaleRulerTitle1 = this.femaleRulerTitle1.charAt(0) + this.femaleRulerTitle1.substring(1).trim();
        this.femaleRulerTitle2 = this.femaleRulerTitle2.charAt(0) + this.femaleRulerTitle2.substring(1).trim();
        this.femaleRulerTitle3 = this.femaleRulerTitle3.charAt(0) + this.femaleRulerTitle3.substring(1).trim();
        this.femaleRulerTitle4 = this.femaleRulerTitle4.charAt(0) + this.femaleRulerTitle4.substring(1).trim();
        this.maleRulerTitle1 = this.maleRulerTitle1.charAt(0) + this.maleRulerTitle1.substring(1).trim();
        this.maleRulerTitle2 = this.maleRulerTitle2.charAt(0) + this.maleRulerTitle2.substring(1).trim();
        this.maleRulerTitle3 = this.maleRulerTitle3.charAt(0) + this.maleRulerTitle3.substring(1).trim();
        this.maleRulerTitle4 = this.maleRulerTitle4.charAt(0) + this.maleRulerTitle4.substring(1).trim();
    }

    public int getDataLength() {
        return this.dataLength;
    }

    public int getDefaultType() {
        return this.defaultType;
    }

    public int getTransitionType() {
        return this.transitionType;
    }

    public int getRequiresMaintenance() {
        return this.requiresMaintenance;
    }

    public int getQuestionMarkOne() {
        return this.questionMarkOne;
    }

    public int getTilePenalty() {
        return this.tilePenalty;
    }

    public int getCommerceBonus() {
        return this.commerceBonus;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getCivilopediaEntry() {
        return this.civilopediaEntry;
    }

    public String getMaleRulerTitle1() {
        return this.maleRulerTitle1;
    }

    public String getFemaleRulerTitle1() {
        return this.femaleRulerTitle1;
    }

    public String getMaleRulerTitle2() {
        return this.maleRulerTitle2;
    }

    public String getFemaleRulerTitle2() {
        return this.femaleRulerTitle2;
    }

    public String getMaleRulerTitle3() {
        return this.maleRulerTitle3;
    }

    public String getFemaleRulerTitle3() {
        return this.femaleRulerTitle3;
    }

    public String getMaleRulerTitle4() {
        return this.maleRulerTitle4;
    }

    public String getFemaleRulerTitle4() {
        return this.femaleRulerTitle4;
    }

    public int getCorruption() {
        return this.corruption;
    }

    public int getImmuneTo() {
        return this.immuneTo;
    }

    public int getDiplomatLevel() {
        return this.diplomatLevel;
    }

    public int getSpyLevel() {
        return this.spyLevel;
    }

    public int getNumberOfGovernments() {
        return this.numberOfGovernments;
    }

    public int getHurrying() {
        return this.hurrying;
    }

    public int getAssimilationChance() {
        return this.assimilationChance;
    }

    public int getDraftLimit() {
        return this.draftLimit;
    }

    public int getMilitaryPoliceLimit() {
        return this.militaryPoliceLimit;
    }

    public int getRulerTitlePairsUsed() {
        return this.rulerTitlePairsUsed;
    }

    public int getPrerequisiteTechnology() {
        return this.prerequisiteInt;
    }

    public int getScienceCap() {
        return this.scienceCap;
    }

    public int getWorkerRate() {
        return this.workerRate;
    }

    public int getQuestionMarkTwo() {
        return this.questionMarkTwo;
    }

    public int getQuestionMarkThree() {
        return this.questionMarkThree;
    }

    public int getQuestionMarkFour() {
        return this.questionMarkFour;
    }

    public int getFreeUnits() {
        return this.freeUnits;
    }

    public int getFreeUnitsPerTown() {
        return this.freeUnitsPerTown;
    }

    public int getFreeUnitsPerCity() {
        return this.freeUnitsPerCity;
    }

    public int getFreeUnitsPerMetropolis() {
        return this.freeUnitsPerMetropolis;
    }

    public int getCostPerUnit() {
        return this.costPerUnit;
    }

    public int getWarWeariness() {
        return this.warWeariness;
    }

    public int getXenophobic() {
        return this.xenophobic;
    }

    public int getForceResettlement() {
        return this.forceResettlement;
    }

    public void setDefaultType(int defaultType) {
        this.defaultType = defaultType;
    }

    public void setTransitionType(int transitionType) {
        this.transitionType = transitionType;
    }

    public void setRequiresMaintenance(int requiresMaintenance) {
        this.requiresMaintenance = requiresMaintenance;
    }

    public void setQuestionMarkOne(int questionMarkOne) {
        this.questionMarkOne = questionMarkOne;
    }

    public void setTilePenalty(int tilePenalty) {
        this.tilePenalty = tilePenalty;
    }

    public void setCommerceBonus(int commerceBonus) {
        this.commerceBonus = commerceBonus;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setCivilopediaEntry(String civilopediaEntry) {
        this.civilopediaEntry = civilopediaEntry;
    }

    public void setMaleRulerTitle1(String maleRulerTitle1) {
        this.maleRulerTitle1 = maleRulerTitle1;
    }

    public void setFemaleRulerTitle1(String femaleRulerTitle1) {
        this.femaleRulerTitle1 = femaleRulerTitle1;
    }

    public void setMaleRulerTitle2(String maleRulerTitle2) {
        this.maleRulerTitle2 = maleRulerTitle2;
    }

    public void setFemaleRulerTitle2(String femaleRulerTitle2) {
        this.femaleRulerTitle2 = femaleRulerTitle2;
    }

    public void setMaleRulerTitle3(String maleRulerTitle3) {
        this.maleRulerTitle3 = maleRulerTitle3;
    }

    public void setFemaleRulerTitle3(String femaleRulerTitle3) {
        this.femaleRulerTitle3 = femaleRulerTitle3;
    }

    public void setMaleRulerTitle4(String maleRulerTitle4) {
        this.maleRulerTitle4 = maleRulerTitle4;
    }

    public void setFemaleRulerTitle4(String femaleRulerTitle4) {
        this.femaleRulerTitle4 = femaleRulerTitle4;
    }

    public void setCorruption(int corruption) {
        this.corruption = corruption;
    }

    public void setImmuneTo(int immuneTo) {
        this.immuneTo = immuneTo;
    }

    public void setDiplomatLevel(int diplomatLevel) {
        this.diplomatLevel = diplomatLevel;
    }

    public void setSpyLevel(int spyLevel) {
        this.spyLevel = spyLevel;
    }

    public void setNumberOfGovernments(int numberOfGovernments) {
        this.dataLength += (numberOfGovernments - this.numberOfGovernments) * 12;
        this.numberOfGovernments = numberOfGovernments;
    }

    public void setHurrying(int hurrying) {
        this.hurrying = hurrying;
    }

    public void setAssimilationChance(int assimilationChance) {
        this.assimilationChance = assimilationChance;
    }

    public void setDraftLimit(int draftLimit) {
        this.draftLimit = draftLimit;
    }

    public void setMilitaryPoliceLimit(int militaryPoliceLimit) {
        this.militaryPoliceLimit = militaryPoliceLimit;
    }

    public void setRulerTitlePairsUsed(int rulerTitlePairsUsed) {
        this.rulerTitlePairsUsed = rulerTitlePairsUsed;
    }

    public void setPrerequisiteTechnology(int prerequisiteTechnology) {
        this.prerequisiteInt = prerequisiteTechnology;
        if (this.baseLink.technology != null && this.prerequisiteInt != -1 && this.baseLink.technology.size() > this.prerequisiteInt) {
            this.prerequisiteTechnology = this.baseLink.technology.get(this.prerequisiteInt);
        }
    }

    public void setScienceCap(int scienceCap) {
        this.scienceCap = scienceCap;
    }

    public void setWorkerRate(int workerRate) {
        this.workerRate = workerRate;
    }

    public void setQuestionMarkTwo(int questionMarkTwo) {
        this.questionMarkTwo = questionMarkTwo;
    }

    public void setQuestionMarkThree(int questionMarkThree) {
        this.questionMarkThree = questionMarkThree;
    }

    public void setQuestionMarkFour(int questionMarkFour) {
        this.questionMarkFour = questionMarkFour;
    }

    public void setFreeUnits(int freeUnits) {
        this.freeUnits = freeUnits;
    }

    public void setFreeUnitsPerTown(int freeUnitsPerTown) {
        this.freeUnitsPerTown = freeUnitsPerTown;
    }

    public void setFreeUnitsPerCity(int freeUnitsPerCity) {
        this.freeUnitsPerCity = freeUnitsPerCity;
    }

    public void setFreeUnitsPerMetropolis(int freeUnitsPerMetropolis) {
        this.freeUnitsPerMetropolis = freeUnitsPerMetropolis;
    }

    public void setCostPerUnit(int costPerUnit) {
        this.costPerUnit = costPerUnit;
    }

    public void setWarWeariness(int warWeariness) {
        this.warWeariness = warWeariness;
    }

    public void setXenophobic(int xenophobic) {
        this.xenophobic = xenophobic;
    }

    public void setForceResettlement(int forceResettlement) {
        this.forceResettlement = forceResettlement;
    }

    public void handleDeletedTech(int index) {
        if (this.prerequisiteInt == index) {
            this.prerequisiteInt = -1;
            this.prerequisiteTechnology = null;
        } else if (this.prerequisiteInt > index) {
            --this.prerequisiteInt;
        }
    }

    public void handleSwappedTech() {
        if (this.prerequisiteInt != -1) {
            this.prerequisiteInt = this.prerequisiteTechnology.getIndex();
        }
    }

    @Override
    public String toEnglish() {
        return this.toString();
    }

    @Override
    public String toString() {
        String lineReturn = System.getProperty("line.separator");
        String toReturn = "name: " + this.name + lineReturn;
        toReturn = toReturn + "civilopediaEntry: " + this.civilopediaEntry + lineReturn;
        toReturn = toReturn + "dataLength: " + this.dataLength + lineReturn;
        toReturn = toReturn + "defaultType: " + this.defaultType + lineReturn;
        toReturn = toReturn + "transitionType: " + this.transitionType + lineReturn;
        toReturn = toReturn + "requiresMaintenance: " + this.requiresMaintenance + lineReturn;
        toReturn = toReturn + "questionMarkOne: " + this.questionMarkOne + lineReturn;
        toReturn = toReturn + "tilePenalty: " + this.tilePenalty + lineReturn;
        toReturn = toReturn + "commerceBonus: " + this.commerceBonus + lineReturn;
        toReturn = toReturn + "maleRulerTitle1: " + this.maleRulerTitle1 + lineReturn;
        toReturn = toReturn + "femaleRulerTitle1: " + this.femaleRulerTitle1 + lineReturn;
        toReturn = toReturn + "maleRulerTitle2: " + this.maleRulerTitle2 + lineReturn;
        toReturn = toReturn + "femaleRulerTitle2: " + this.femaleRulerTitle2 + lineReturn;
        toReturn = toReturn + "maleRulerTitle3: " + this.maleRulerTitle3 + lineReturn;
        toReturn = toReturn + "femaleRulerTitle3: " + this.femaleRulerTitle3 + lineReturn;
        toReturn = toReturn + "maleRulerTitle4: " + this.maleRulerTitle4 + lineReturn;
        toReturn = toReturn + "femaleRulerTitle4: " + this.femaleRulerTitle4 + lineReturn;
        toReturn = toReturn + "corruption: " + this.corruption + lineReturn;
        toReturn = toReturn + "immuneTo: " + this.immuneTo + lineReturn;
        toReturn = toReturn + "diplomatLevel: " + this.diplomatLevel + lineReturn;
        toReturn = toReturn + "spyLevel: " + this.spyLevel + lineReturn;
        toReturn = toReturn + "numberOfGovernments: " + this.numberOfGovernments + lineReturn;
        for (int j = 0; j < this.numberOfGovernments; ++j) {
            toReturn = toReturn + "performance of this government versus government " + j + ": " + lineReturn + this.relations.get(j);
        }
        toReturn = toReturn + "hurrying: " + this.hurrying + lineReturn;
        toReturn = toReturn + "assimilationChance: " + this.assimilationChance + lineReturn;
        toReturn = toReturn + "draftLimit: " + this.draftLimit + lineReturn;
        toReturn = toReturn + "militaryPoliceLimit: " + this.militaryPoliceLimit + lineReturn;
        toReturn = toReturn + "rulerTitlePairsUsed: " + this.rulerTitlePairsUsed + lineReturn;
        toReturn = toReturn + "prerequisiteTechnology: " + this.prerequisiteInt + lineReturn;
        toReturn = toReturn + "scienceCap: " + this.scienceCap + lineReturn;
        toReturn = toReturn + "workerRate: " + this.workerRate + lineReturn;
        toReturn = toReturn + "questionMarkTwo: " + this.questionMarkTwo + lineReturn;
        toReturn = toReturn + "questionMarkThree: " + this.questionMarkThree + lineReturn;
        toReturn = toReturn + "questionMarkFour: " + this.questionMarkFour + lineReturn;
        toReturn = toReturn + "freeUnits: " + this.freeUnits + lineReturn;
        toReturn = toReturn + "freeUnitsPerTown: " + this.freeUnitsPerTown + lineReturn;
        toReturn = toReturn + "freeUnitsPerCity: " + this.freeUnitsPerCity + lineReturn;
        toReturn = toReturn + "freeUnitsPerMetropolis: " + this.freeUnitsPerMetropolis + lineReturn;
        toReturn = toReturn + "costPerUnit: " + this.costPerUnit + lineReturn;
        toReturn = toReturn + "warWeariness: " + this.warWeariness + lineReturn;
        toReturn = toReturn + "xenophobic: " + this.xenophobic + lineReturn;
        toReturn = toReturn + "forceResettlement: " + this.forceResettlement + lineReturn;
        toReturn = toReturn + lineReturn;
        return toReturn;
    }

    @Override
    public String compareTo(BIQSection section, String separator) {
        if (!(section instanceof GOVT)) {
            return null;
        }
        GOVT two = (GOVT)section;
        String lineReturn = System.getProperty("line.separator");
        String toReturn = "name: " + this.name + lineReturn;
        if (this.dataLength != two.getDataLength()) {
            toReturn = toReturn + "DataLength: " + this.dataLength + separator + two.getDataLength() + lineReturn;
        }
        if (this.defaultType != two.getDefaultType()) {
            toReturn = toReturn + "DefaultType: " + this.defaultType + separator + two.getDefaultType() + lineReturn;
        }
        if (this.transitionType != two.getTransitionType()) {
            toReturn = toReturn + "TransitionType: " + this.transitionType + separator + two.getTransitionType() + lineReturn;
        }
        if (this.requiresMaintenance != two.getRequiresMaintenance()) {
            toReturn = toReturn + "RequiresMaintenance: " + this.requiresMaintenance + separator + two.getRequiresMaintenance() + lineReturn;
        }
        if (this.questionMarkOne != two.getQuestionMarkOne()) {
            toReturn = toReturn + "QuestionMarkOne: " + this.questionMarkOne + separator + two.getQuestionMarkOne() + lineReturn;
        }
        if (this.tilePenalty != two.getTilePenalty()) {
            toReturn = toReturn + "TilePenalty: " + this.tilePenalty + separator + two.getTilePenalty() + lineReturn;
        }
        if (this.commerceBonus != two.getCommerceBonus()) {
            toReturn = toReturn + "CommerceBonus: " + this.commerceBonus + separator + two.getCommerceBonus() + lineReturn;
        }
        if (this.civilopediaEntry.compareTo(two.getCivilopediaEntry()) != 0) {
            toReturn = toReturn + "CivilopediaEntry: " + this.civilopediaEntry + separator + two.getCivilopediaEntry() + lineReturn;
        }
        if (this.maleRulerTitle1.compareTo(two.getMaleRulerTitle1()) != 0) {
            toReturn = toReturn + "MaleRulerTitle1: " + this.maleRulerTitle1 + separator + two.getMaleRulerTitle1() + lineReturn;
        }
        if (this.femaleRulerTitle1.compareTo(two.getFemaleRulerTitle1()) != 0) {
            toReturn = toReturn + "FemaleRulerTitle1: " + this.femaleRulerTitle1 + separator + two.getFemaleRulerTitle1() + lineReturn;
        }
        if (this.maleRulerTitle2.compareTo(two.getMaleRulerTitle2()) != 0) {
            toReturn = toReturn + "MaleRulerTitle2: " + this.maleRulerTitle2 + separator + two.getMaleRulerTitle2() + lineReturn;
        }
        if (this.femaleRulerTitle2.compareTo(two.getFemaleRulerTitle2()) != 0) {
            toReturn = toReturn + "FemaleRulerTitle2: " + this.femaleRulerTitle2 + separator + two.getFemaleRulerTitle2() + lineReturn;
        }
        if (this.maleRulerTitle3.compareTo(two.getMaleRulerTitle3()) != 0) {
            toReturn = toReturn + "MaleRulerTitle3: " + this.maleRulerTitle3 + separator + two.getMaleRulerTitle3() + lineReturn;
        }
        if (this.femaleRulerTitle3.compareTo(two.getFemaleRulerTitle3()) != 0) {
            toReturn = toReturn + "FemaleRulerTitle3: " + this.femaleRulerTitle3 + separator + two.getFemaleRulerTitle3() + lineReturn;
        }
        if (this.maleRulerTitle4.compareTo(two.getMaleRulerTitle4()) != 0) {
            toReturn = toReturn + "MaleRulerTitle4: " + this.maleRulerTitle4 + separator + two.getMaleRulerTitle4() + lineReturn;
        }
        if (this.femaleRulerTitle4.compareTo(two.getFemaleRulerTitle4()) != 0) {
            toReturn = toReturn + "FemaleRulerTitle4: " + this.femaleRulerTitle4 + separator + two.getFemaleRulerTitle4() + lineReturn;
        }
        if (this.corruption != two.getCorruption()) {
            toReturn = toReturn + "Corruption: " + this.corruption + separator + two.getCorruption() + lineReturn;
        }
        if (this.immuneTo != two.getImmuneTo()) {
            toReturn = toReturn + "ImmuneTo: " + this.immuneTo + separator + two.getImmuneTo() + lineReturn;
        }
        if (this.diplomatLevel != two.getDiplomatLevel()) {
            toReturn = toReturn + "DiplomatLevel: " + this.diplomatLevel + separator + two.getDiplomatLevel() + lineReturn;
        }
        if (this.spyLevel != two.getSpyLevel()) {
            toReturn = toReturn + "SpyLevel: " + this.spyLevel + separator + two.getSpyLevel() + lineReturn;
        }
        if (this.numberOfGovernments != two.getNumberOfGovernments()) {
            toReturn = toReturn + "NumberOfGovernments: " + this.numberOfGovernments + separator + two.getNumberOfGovernments() + lineReturn;
        }
        if (this.hurrying != two.getHurrying()) {
            toReturn = toReturn + "Hurrying: " + this.hurrying + separator + two.getHurrying() + lineReturn;
        }
        if (this.assimilationChance != two.getAssimilationChance()) {
            toReturn = toReturn + "AssimilationChance: " + this.assimilationChance + separator + two.getAssimilationChance() + lineReturn;
        }
        if (this.draftLimit != two.getDraftLimit()) {
            toReturn = toReturn + "DraftLimit: " + this.draftLimit + separator + two.getDraftLimit() + lineReturn;
        }
        if (this.militaryPoliceLimit != two.getMilitaryPoliceLimit()) {
            toReturn = toReturn + "MilitaryPoliceLimit: " + this.militaryPoliceLimit + separator + two.getMilitaryPoliceLimit() + lineReturn;
        }
        if (this.rulerTitlePairsUsed != two.getRulerTitlePairsUsed()) {
            toReturn = toReturn + "RulerTitlePairsUsed: " + this.rulerTitlePairsUsed + separator + two.getRulerTitlePairsUsed() + lineReturn;
        }
        if (this.prerequisiteInt != two.getPrerequisiteTechnology()) {
            toReturn = toReturn + "PrerequisiteTechnology: " + this.prerequisiteInt + separator + two.getPrerequisiteTechnology() + lineReturn;
        }
        if (this.scienceCap != two.getScienceCap()) {
            toReturn = toReturn + "ScienceCap: " + this.scienceCap + separator + two.getScienceCap() + lineReturn;
        }
        if (this.workerRate != two.getWorkerRate()) {
            toReturn = toReturn + "WorkerRate: " + this.workerRate + separator + two.getWorkerRate() + lineReturn;
        }
        if (this.questionMarkTwo != two.getQuestionMarkTwo()) {
            toReturn = toReturn + "QuestionMarkTwo: " + this.questionMarkTwo + separator + two.getQuestionMarkTwo() + lineReturn;
        }
        if (this.questionMarkThree != two.getQuestionMarkThree()) {
            toReturn = toReturn + "QuestionMarkThree: " + this.questionMarkThree + separator + two.getQuestionMarkThree() + lineReturn;
        }
        if (this.questionMarkFour != two.getQuestionMarkFour()) {
            toReturn = toReturn + "QuestionMarkFour: " + this.questionMarkFour + separator + two.getQuestionMarkFour() + lineReturn;
        }
        if (this.freeUnits != two.getFreeUnits()) {
            toReturn = toReturn + "FreeUnits: " + this.freeUnits + separator + two.getFreeUnits() + lineReturn;
        }
        if (this.freeUnitsPerTown != two.getFreeUnitsPerTown()) {
            toReturn = toReturn + "FreeUnitsPerTown: " + this.freeUnitsPerTown + separator + two.getFreeUnitsPerTown() + lineReturn;
        }
        if (this.freeUnitsPerCity != two.getFreeUnitsPerCity()) {
            toReturn = toReturn + "FreeUnitsPerCity: " + this.freeUnitsPerCity + separator + two.getFreeUnitsPerCity() + lineReturn;
        }
        if (this.freeUnitsPerMetropolis != two.getFreeUnitsPerMetropolis()) {
            toReturn = toReturn + "FreeUnitsPerMetropolis: " + this.freeUnitsPerMetropolis + separator + two.getFreeUnitsPerMetropolis() + lineReturn;
        }
        if (this.costPerUnit != two.getCostPerUnit()) {
            toReturn = toReturn + "CostPerUnit: " + this.costPerUnit + separator + two.getCostPerUnit() + lineReturn;
        }
        if (this.warWeariness != two.getWarWeariness()) {
            toReturn = toReturn + "WarWeariness: " + this.warWeariness + separator + two.getWarWeariness() + lineReturn;
        }
        if (this.xenophobic != two.getXenophobic()) {
            toReturn = toReturn + "Xenophobic: " + this.xenophobic + separator + two.getXenophobic() + lineReturn;
        }
        if (this.forceResettlement != two.getForceResettlement()) {
            toReturn = toReturn + "ForceResettlement: " + this.forceResettlement + separator + two.getForceResettlement() + lineReturn;
        }
        if (toReturn.equals("name: " + this.name + lineReturn)) {
            toReturn = "";
        }
        return toReturn;
    }

    @Override
    public Object getProperty(String string) throws UnsupportedOperationException {
        if (string.equals("Name")) {
            return this.name;
        }
        throw new UnsupportedOperationException();
    }
}

