/*
 * Decompiled with CFR 0.152.
 */
package com.civfanatics.civ3.biqFile;

import com.civfanatics.civ3.biqFile.BIQSection;
import com.civfanatics.civ3.biqFile.BLDG;
import com.civfanatics.civ3.biqFile.CITY;
import com.civfanatics.civ3.biqFile.CLNY;
import com.civfanatics.civ3.biqFile.CONT;
import com.civfanatics.civ3.biqFile.CONTThread;
import com.civfanatics.civ3.biqFile.CTZN;
import com.civfanatics.civ3.biqFile.CULT;
import com.civfanatics.civ3.biqFile.DIFF;
import com.civfanatics.civ3.biqFile.ERAS;
import com.civfanatics.civ3.biqFile.ESPN;
import com.civfanatics.civ3.biqFile.EXPR;
import com.civfanatics.civ3.biqFile.FLAV;
import com.civfanatics.civ3.biqFile.GAME;
import com.civfanatics.civ3.biqFile.GOOD;
import com.civfanatics.civ3.biqFile.GOVT;
import com.civfanatics.civ3.biqFile.GOVTGOVTRelations;
import com.civfanatics.civ3.biqFile.HeaderFailedException;
import com.civfanatics.civ3.biqFile.LEAD;
import com.civfanatics.civ3.biqFile.PRTO;
import com.civfanatics.civ3.biqFile.RACE;
import com.civfanatics.civ3.biqFile.RULE;
import com.civfanatics.civ3.biqFile.SLOC;
import com.civfanatics.civ3.biqFile.SLOCThread;
import com.civfanatics.civ3.biqFile.Section;
import com.civfanatics.civ3.biqFile.TECH;
import com.civfanatics.civ3.biqFile.TERR;
import com.civfanatics.civ3.biqFile.TILE;
import com.civfanatics.civ3.biqFile.TILEThread;
import com.civfanatics.civ3.biqFile.TRFM;
import com.civfanatics.civ3.biqFile.UNIT;
import com.civfanatics.civ3.biqFile.WCHR;
import com.civfanatics.civ3.biqFile.WMAP;
import com.civfanatics.civ3.biqFile.WSIZ;
import com.civfanatics.civ3.biqFile.civ3Version;
import com.civfanatics.civ3.biqFile.util.DefaultRulesLoader;
import com.civfanatics.civ3.biqFile.util.LittleEndianDataInputStream;
import com.civfanatics.civ3.biqFile.util.LittleEndianDataOutputStream;
import com.civfanatics.civ3.pediaIcons.PediaIconsFile;
import java.awt.Dimension;
import java.awt.HeadlessException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Logger;

public class IO {
    private String currentCharset = "Windows-1252";
    private static int numProcs = 1;
    public boolean exportEnglish = true;
    public static final int TILE_LENGTH = 49;
    public static final int PTW_TILE_LENGTH = 33;
    public static final int VANILLA_3_4_TILE_LENGTH = 27;
    public static final int VANILLA_2_TILE_LENGTH = 26;
    public static final int CONT_LENGTH = 12;
    public static final int SLOC_LENGTH = 20;
    private boolean hasCustomRules = false;
    private boolean hasCustomMap = false;
    private boolean hasCustomPlayerData = false;
    Logger logger = Logger.getLogger(this.getClass());
    public byte[] inputFour;
    public byte[] inputTwentyFour;
    public byte[] inputThirtyTwo;
    public byte[] inputForty;
    public byte[] inputFiftySeven;
    public byte[] inputSixtyFour;
    public byte[] inputOneHundredTwentyEight;
    public byte[] inputTwoFiftySix;
    public byte[] inputTwoSixty;
    public byte[] inputSixForty;
    public byte[] inputFiftyTwoHundred;
    public Byte inputByte;
    public Short inputShort;
    public String fileName;
    String verString;
    public civ3Version version;
    public int numHeaders = 1;
    public int majorVersionNumber = 12;
    public int minorVersionNumber = 8;
    public String description = "";
    public String title = "";
    public int numBuildings;
    public List<BLDG> buildings = new ArrayList<BLDG>();
    public int numCitizens;
    public List<CTZN> citizens = new ArrayList<CTZN>();
    public int numCulturalOpinions;
    public List<CULT> culture = new ArrayList<CULT>();
    public int numDifficulties;
    public List<DIFF> difficulties = new ArrayList<DIFF>();
    public int numEras;
    public List<ERAS> eras = new ArrayList<ERAS>();
    public int numEspionage;
    public List<ESPN> espionage = new ArrayList<ESPN>();
    public int numExprLevel;
    public List<EXPR> experience = new ArrayList<EXPR>();
    public int numGoods;
    public List<GOOD> resource = new ArrayList<GOOD>();
    public int numGovernments;
    public List<GOVT> government = new ArrayList<GOVT>();
    public int numRules;
    public List<RULE> rule = new ArrayList<RULE>();
    public int numUnits;
    public List<PRTO> unit = new ArrayList<PRTO>();
    public int numTechnologies;
    public List<TECH> technology = new ArrayList<TECH>();
    public int numWorkerJobs;
    public List<TRFM> workerJob = new ArrayList<TRFM>();
    public int numTerrains;
    public List<TERR> terrain = new ArrayList<TERR>();
    public int numWorldSizes;
    public List<WSIZ> worldSize = new ArrayList<WSIZ>();
    public int numFlavors;
    public List<FLAV> flavor = new ArrayList<FLAV>();
    public int numScenarioProperties;
    public List<GAME> scenarioProperty = new ArrayList<GAME>();
    public int numWorldCharacteristics;
    public List<WCHR> worldCharacteristic = new ArrayList<WCHR>();
    public int numWorldMaps;
    public List<WMAP> worldMap = new ArrayList<WMAP>();
    public int numTiles;
    public List<TILE> tile = new ArrayList<TILE>();
    public int numContinents;
    public List<CONT> continent = new ArrayList<CONT>();
    public int numStartingLocations;
    public List<SLOC> startingLocation = new ArrayList<SLOC>();
    public int numCities;
    public List<CITY> city = new ArrayList<CITY>();
    public int numMapUnits;
    public List<UNIT> mapUnit = new ArrayList<UNIT>();
    public int numColonies;
    public List<CLNY> colony = new ArrayList<CLNY>();
    public int numPlayers;
    public List<LEAD> player = new ArrayList<LEAD>();
    public int numCivilizations;
    public List<RACE> civilization = new ArrayList<RACE>();
    public int dataInputted;
    public int convertToConquests = 0;
    static final boolean convertDataLengthsForConquests = false;
    static final Map<String, String> languageToCharsetMap;
    public static String pathToBin;
    PediaIconsFile pediaIcons = new PediaIconsFile();

    public IO() {
        this.inputFour = new byte[4];
        this.inputTwentyFour = new byte[24];
        this.inputThirtyTwo = new byte[32];
        this.inputForty = new byte[40];
        this.inputFiftySeven = new byte[57];
        this.inputSixtyFour = new byte[64];
        this.inputOneHundredTwentyEight = new byte[128];
        this.inputTwoFiftySix = new byte[256];
        this.inputTwoSixty = new byte[260];
        this.inputSixForty = new byte[640];
        this.inputFiftyTwoHundred = new byte[5200];
    }

    public void resetLogConfig() {
        BasicConfigurator.resetConfiguration();
        BasicConfigurator.configure();
    }

    public static void setNumProcs(int processors) {
        numProcs = processors;
    }

    public boolean inputBIQ(File file) throws FileNotFoundException {
        return this.inputBIQ(file, false);
    }

    public boolean inputBIQ(File file, boolean fromSAV) throws FileNotFoundException {
        this.dataInputted = 0;
        try {
            LittleEndianDataInputStream inFile = new LittleEndianDataInputStream(new BufferedInputStream(new FileInputStream(file)));
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Size of file:     " + (int)file.length());
                long maxMem = Runtime.getRuntime().maxMemory();
                this.logger.debug("Max size of heap: " + maxMem);
            }
            byte[] buffer = new byte[(int)file.length()];
            inFile.readFully(buffer);
            inFile.close();
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Number of available processors: " + Runtime.getRuntime().availableProcessors() + "; using " + numProcs + " processors");
            }
            LittleEndianDataInputStream[] ins = new LittleEndianDataInputStream[numProcs];
            return this.inputBIQ(ins, buffer, file, fromSAV);
        }
        catch (IOException ex) {
            if (ex instanceof FileNotFoundException) {
                throw (FileNotFoundException)ex;
            }
            this.logger.error("Error when reading from file into buffer", ex);
            return false;
        }
    }

    public boolean inputBIQ(LittleEndianDataInputStream[] ins, byte[] buffer, File file, boolean fromSAV) {
        long start = System.nanoTime();
        long fileLength = file == null ? 42L : file.length();
        try {
            if (buffer != null) {
                for (int i = 0; i < ins.length; ++i) {
                    ins[i] = new LittleEndianDataInputStream(new ByteArrayInputStream(buffer));
                }
            }
            ins[0].read(this.inputFour, 0, 4);
            this.dataInputted += 4;
            String temp = new String(this.inputFour, this.currentCharset);
            if (!temp.contains("BIC")) {
                this.logger.info("Detected compressed file");
                this.logger.info("pathToBin: " + pathToBin);
                this.logger.info("Path to decompressor: " + pathToBin + "./bin/BIQDecompressor.jar");
                this.logger.info("Path to temp file: " + pathToBin + "._tmp.biq");
                String[] decomQuery = new String[]{"java", "-jar", pathToBin + "./bin/BIQDecompressor.jar", file.getCanonicalPath(), pathToBin + "._tmp.biq"};
                Process dcp = Runtime.getRuntime().exec(decomQuery);
                dcp.waitFor();
                return this.inputBIQ(new File(pathToBin + "._tmp.biq"), fromSAV);
            }
            this.verString = temp;
            ins[0].read(this.inputFour, 0, 4);
            this.dataInputted += 4;
            temp = new String(this.inputFour, this.currentCharset);
            Integer integer = ins[0].readInt();
            this.dataInputted += 4;
            integer = ins[0].readInt();
            this.dataInputted += 4;
            integer = ins[0].readInt();
            this.dataInputted += 4;
            integer = ins[0].readInt();
            this.dataInputted += 4;
            integer = ins[0].readInt();
            this.dataInputted += 4;
            this.majorVersionNumber = integer;
            integer = ins[0].readInt();
            this.dataInputted += 4;
            this.minorVersionNumber = integer;
            if (this.verString.equals("BICX") && this.majorVersionNumber == 12) {
                this.version = civ3Version.CONQUESTS;
            } else if (this.verString.equals("BICX")) {
                this.version = civ3Version.PTW;
            } else if (this.verString.equals("BIC ")) {
                this.version = civ3Version.VANILLA;
            } else if (this.verString.equals("BICQ") && this.majorVersionNumber == 12) {
                this.version = civ3Version.CONQUESTS;
            } else {
                this.logger.error("Invalid BIC version");
            }
            if (this.version != civ3Version.CONQUESTS) {
                this.convertToConquests = 1;
            }
            this.logger.info("major ver: " + this.majorVersionNumber + ", minorVer: " + this.minorVersionNumber);
            ins[0].read(this.inputSixForty, 0, 640);
            this.dataInputted += 640;
            this.description = new String(this.inputSixForty, this.currentCharset);
            ins[0].read(this.inputSixtyFour, 0, 64);
            this.dataInputted += 64;
            this.title = new String(this.inputSixtyFour, this.currentCharset);
            ins[0].read(this.inputFour, 0, 4);
            this.dataInputted += 4;
            temp = new String(this.inputFour, this.currentCharset);
            if (temp.equals("BLDG")) {
                this.hasCustomRules = true;
                long now = System.nanoTime();
                long upToNow = now - start;
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("About to go into the various input processors; has been " + upToNow / 1000000L + " milliseconds.");
                }
                this.inputBLDG(ins[0]);
                this.logger.info("BLDG Bytes read: " + this.dataInputted + "; input bytes read = " + ins[0].numBytesRead);
                this.inputCTZN(ins[0]);
                this.logger.info("CTZN Bytes read: " + this.dataInputted + "; input bytes read = " + ins[0].numBytesRead);
                this.inputCULT(ins[0]);
                this.logger.info("CULT Bytes read: " + this.dataInputted + "; input bytes read = " + ins[0].numBytesRead);
                this.inputDIFF(ins[0]);
                this.logger.info("DIFF Bytes read: " + this.dataInputted + "; input bytes read = " + ins[0].numBytesRead);
                this.inputERAS(ins[0]);
                this.logger.info("ERAS Bytes read: " + this.dataInputted + "; input bytes read = " + ins[0].numBytesRead);
                this.inputESPN(ins[0]);
                this.logger.info("ESPN Bytes read: " + this.dataInputted + "; input bytes read = " + ins[0].numBytesRead);
                this.inputEXPR(ins[0]);
                this.logger.info("EXPR Bytes read: " + this.dataInputted + "; input bytes read = " + ins[0].numBytesRead);
                if (fromSAV) {
                    ins[0].mark(4);
                    ins[0].read(this.inputFour, 0, 4);
                    this.dataInputted += 4;
                    String temp2 = new String(this.inputFour, this.currentCharset);
                    if (temp2.equals("FLAV")) {
                        ins[0].reset();
                        this.inputFLAV(ins[0]);
                    } else {
                        ins[0].reset();
                    }
                }
                this.inputGOOD(ins[0]);
                this.logger.info("GOOD Bytes read: " + this.dataInputted + "; input bytes read = " + ins[0].numBytesRead);
                this.inputGOVT(ins[0]);
                this.logger.info("GOVT Bytes read: " + this.dataInputted + "; input bytes read = " + ins[0].numBytesRead);
                this.inputRULE(ins[0]);
                this.logger.info("RULE Bytes read: " + this.dataInputted + "; input bytes read = " + ins[0].numBytesRead);
                this.inputPRTO(ins[0]);
                this.logger.info("PRTO Bytes read: " + this.dataInputted + "; input bytes read = " + ins[0].numBytesRead);
                this.inputRACE(ins[0]);
                this.logger.info("RACE Bytes read: " + this.dataInputted + "; input bytes read = " + ins[0].numBytesRead);
                this.inputTECH(ins[0]);
                this.logger.info("TECH Bytes read: " + this.dataInputted + "; input bytes read = " + ins[0].numBytesRead);
                this.inputTFRM(ins[0]);
                this.logger.info("TFRM Bytes read: " + this.dataInputted + "; input bytes read = " + ins[0].numBytesRead);
                if (this.convertToConquests == 1) {
                    TRFM airfield = new TRFM(this);
                    airfield.setName("Airfield");
                    airfield.setOrder("Build Airfield");
                    airfield.setCivilopediaEntry("TFRM_Airfield");
                    airfield.setRequiredAdvance(-1);
                    airfield.setTurnsToComplete(1);
                    airfield.setRequiredResource1(-1);
                    airfield.setRequiredResource2(-1);
                    this.workerJob.add(airfield);
                    TRFM radarTower = new TRFM(this);
                    radarTower.setName("Radar Tower");
                    radarTower.setOrder("Build Radar Tower");
                    radarTower.setCivilopediaEntry("TFRM_Radar_Tower");
                    radarTower.setRequiredAdvance(-1);
                    radarTower.setTurnsToComplete(1);
                    radarTower.setRequiredResource1(-1);
                    radarTower.setRequiredResource2(-1);
                    this.workerJob.add(radarTower);
                    TRFM outpost = new TRFM(this);
                    outpost.setName("Outpost");
                    outpost.setOrder("Build Outpost");
                    outpost.setCivilopediaEntry("TFRM_Outpost");
                    outpost.setRequiredAdvance(-1);
                    outpost.setTurnsToComplete(1);
                    outpost.setRequiredResource1(-1);
                    outpost.setRequiredResource2(-1);
                    this.workerJob.add(outpost);
                    TRFM barricade = new TRFM(this);
                    barricade.setName("Barricade");
                    barricade.setOrder("Build Barricade");
                    barricade.setCivilopediaEntry("TFRM_Barricades");
                    barricade.setRequiredAdvance(-1);
                    barricade.setTurnsToComplete(16);
                    barricade.setRequiredResource1(-1);
                    barricade.setRequiredResource2(-1);
                    this.workerJob.add(barricade);
                    for (int i = 0; i < this.technology.size(); ++i) {
                        String name = this.technology.get(i).getName();
                        if (name.equals("Flight")) {
                            airfield.setRequiredAdvance(i);
                            continue;
                        }
                        if (name.equals("Advanced Flight")) {
                            radarTower.setRequiredAdvance(i);
                            continue;
                        }
                        if (name.equals("Masonry")) {
                            outpost.setRequiredAdvance(i);
                            continue;
                        }
                        if (!name.equals("Construction")) continue;
                        barricade.setRequiredAdvance(i);
                    }
                }
                this.inputTERR(ins[0]);
                this.logger.info("TERR Bytes read: " + this.dataInputted + "; input bytes read = " + ins[0].numBytesRead);
                this.inputWSIZ(ins[0]);
                this.logger.info("WSIZ Bytes read: " + this.dataInputted + "; input bytes read = " + ins[0].numBytesRead);
                if (this.version == civ3Version.CONQUESTS && !fromSAV) {
                    this.inputFLAV(ins[0]);
                } else if (this.convertToConquests == 1) {
                    this.flavor = new ArrayList<FLAV>();
                    for (int i = 0; i < 7; ++i) {
                        FLAV flavour = new FLAV(this, "Flavor " + i);
                        flavour.setNumberOfFlavors(7);
                        for (int j = 0; j < 7; ++j) {
                            flavour.relationWithOtherFlavor.add(new Integer(0));
                        }
                        this.flavor.add(flavour);
                    }
                }
                try {
                    this.performRulePostProcessingFromBIQ();
                }
                catch (Exception e) {
                    this.logger.error("Exception while extracing binary data", e);
                    JOptionPane.showMessageDialog(null, "Could not input file - error extracting binary data on building/technology/civilization headers.", "File input failed.", 0);
                    return false;
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("at world map/game section; " + this.dataInputted + " bytes inputted.");
                }
                ins[0].read(this.inputFour, 0, 4);
                this.dataInputted += 4;
                temp = new String(this.inputFour, this.currentCharset);
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("At end of custom rules; time taken = " + (System.nanoTime() - start) / 1000000L + " ms");
                }
            } else {
                this.hasCustomRules = false;
                IO defaultRules = DefaultRulesLoader.getDefaultRules();
                this.buildings = defaultRules.buildings;
                this.citizens = defaultRules.citizens;
                this.culture = defaultRules.culture;
                this.difficulties = defaultRules.difficulties;
                this.eras = defaultRules.eras;
                this.espionage = defaultRules.espionage;
                this.experience = defaultRules.experience;
                this.resource = defaultRules.resource;
                this.government = defaultRules.government;
                this.rule = defaultRules.rule;
                this.unit = defaultRules.unit;
                this.numUnits = defaultRules.numUnits;
                this.civilization = defaultRules.civilization;
                this.technology = defaultRules.technology;
                this.workerJob = defaultRules.workerJob;
                this.terrain = defaultRules.terrain;
                this.worldSize = defaultRules.worldSize;
                this.flavor = defaultRules.flavor;
            }
            if (temp.equals("WCHR")) {
                this.hasCustomMap = true;
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("custom map");
                }
                this.inputWCHR(ins[0]);
                this.logger.info("WCHR Bytes read: " + this.dataInputted + "; input bytes read = " + ins[0].numBytesRead);
                this.inputWMAP(ins[0]);
                this.logger.info("WMAP Bytes read: " + this.dataInputted + "; input bytes read = " + ins[0].numBytesRead);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("at tile section; " + this.dataInputted + " bytes inputted.");
                }
                long beforeMapStuff = System.nanoTime();
                for (int i = 1; i < ins.length; ++i) {
                    ins[i].skipBytes(this.dataInputted);
                }
                this.inputTILE(ins);
                this.logger.info("TILE Bytes read: " + this.dataInputted + "; input bytes read = " + ins[0].numBytesRead);
                long afterMapStuff = System.nanoTime();
                this.inputCONT(ins);
                this.logger.info("CONT Bytes read: " + this.dataInputted + "; input bytes read = " + ins[0].numBytesRead);
                if (this.version.ordinal() >= civ3Version.PTW.ordinal() || this.majorVersionNumber >= 4 && this.minorVersionNumber >= 1) {
                    this.inputSLOC(ins);
                    this.logger.info("SLOC Bytes read: " + this.dataInputted + "; input bytes read = " + ins[0].numBytesRead);
                    int dataPriorToCity = this.dataInputted;
                    this.inputCITY(ins[0]);
                    this.logger.info("CITY Bytes read: " + this.dataInputted + "; input bytes read = " + ins[0].numBytesRead);
                    for (int i = 1; i < ins.length; ++i) {
                        ins[i].skipBytes(this.dataInputted - dataPriorToCity);
                    }
                    this.inputUNIT(ins[0]);
                    this.logger.info("UNIT Bytes read: " + this.dataInputted + "; input bytes read = " + ins[0].numBytesRead);
                    this.inputCLNY(ins[0]);
                    this.logger.info("CLNY Bytes read: " + this.dataInputted + "; input bytes read = " + ins[0].numBytesRead);
                }
                long mapStuff = afterMapStuff - beforeMapStuff;
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("Time to process tile stuff: " + mapStuff / 1000000L + " milliseconds; total time: " + (afterMapStuff - start) / 1000000L + " ms");
                }
                int width = this.worldMap.get((int)0).width;
                int height = this.worldMap.get((int)0).height;
                int y = 0;
                int x = 0;
                for (int i = 0; i < this.tile.size(); ++i) {
                    this.tile.get(i).calculateUnitWithBestDefence();
                    this.tile.get((int)i).xPos = x;
                    this.tile.get((int)i).yPos = y++;
                    if ((x += 2) >= width && x % 2 == 0) {
                        x = 1;
                        continue;
                    }
                    if (x < width || x % 2 != 1) continue;
                    ++y;
                    x = 0;
                }
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("finished map data");
                }
                ins[0].read(this.inputFour, 0, 4);
                this.dataInputted += 4;
                temp = new String(this.inputFour, this.currentCharset);
            }
            if (this.version.ordinal() >= civ3Version.PTW.ordinal() || this.majorVersionNumber >= 3 && this.minorVersionNumber >= 8 || this.majorVersionNumber >= 4) {
                if (!temp.equals("GAME")) {
                    this.logger.error("Failed to input at GAME header - header was " + temp);
                    return false;
                }
                this.inputGAME(ins[0]);
            } else if (this.convertToConquests == 1) {
                int i;
                this.scenarioProperty = new ArrayList<GAME>();
                GAME properties = new GAME(this);
                for (i = 0; i < 5; ++i) {
                    properties.warWith0.add(0);
                    properties.warWith1.add(0);
                    properties.warWith2.add(0);
                    properties.warWith3.add(0);
                    properties.warWith4.add(0);
                }
                for (i = 1; i < this.civilization.size(); ++i) {
                    properties.civPartOfWhichAlliance.add(0);
                }
                this.scenarioProperty.add(properties);
            }
            if (this.majorVersionNumber == 12 && this.minorVersionNumber == 6) {
                this.scenarioProperty.get((int)0).dataLength += 12;
            }
            if (this.logger.isInfoEnabled()) {
                this.logger.info("File length: " + fileLength);
                this.logger.info("data inputted: " + this.dataInputted);
            }
            boolean isDone = false;
            if (fromSAV) {
                ins[0].mark(4);
                ins[0].read(this.inputFour, 0, 4);
                this.dataInputted += 4;
                temp = new String(this.inputFour, this.currentCharset);
                if (!temp.equals("LEAD")) {
                    isDone = true;
                }
                ins[0].reset();
            }
            if (fileLength <= (long)this.dataInputted && !fromSAV || isDone) {
                long end = System.nanoTime();
                long duration = end - start;
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("Time to input BIQ: " + duration / 1000000L + " milliseconds");
                }
                if (this.convertToConquests > 0) {
                    this.version = civ3Version.CONQUESTS;
                }
                return true;
            }
            ins[0].read(this.inputFour, 0, 4);
            String tempLEAD = new String(this.inputFour, this.currentCharset);
            this.dataInputted += 4;
            if (!tempLEAD.equals("LEAD")) {
                this.logger.error("Could not input file - failed at LEAD header.  Header is " + temp + "; bytes inputted: " + this.dataInputted);
                return false;
            }
            this.inputLEAD(ins[0]);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("finished custom player data");
            }
            if (this.logger.isInfoEnabled()) {
                this.logger.info("final input:  " + this.dataInputted);
            }
            if (fileLength != (long)this.dataInputted && !fromSAV) {
                return false;
            }
            long end = System.nanoTime();
            long duration = end - start;
            this.logger.info("Time to input BIQ: " + duration / 1000000L + " milliseconds");
            if (this.convertToConquests > 0) {
                this.version = civ3Version.CONQUESTS;
            }
            if (!fromSAV && file.exists() && file.getName().equals("._tmp.biq")) {
                file.delete();
            }
            return true;
        }
        catch (EOFException e) {
            this.logger.error("file size: " + fileLength);
            this.logger.error("bytes read at time of crash: " + this.dataInputted);
            this.logger.error(e.getCause());
            this.logger.error(e.toString());
            this.logger.error(e.getClass());
            this.logger.error(e);
            return false;
        }
        catch (FileNotFoundException e) {
            this.logger.error("File not found: " + e.getMessage(), e);
            JOptionPane.showMessageDialog(null, "Could not find the file: " + e.getMessage());
            return false;
        }
        catch (OutOfMemoryError e) {
            this.logger.error("ERROR: ", e);
            JOptionPane.showMessageDialog(null, "Out of memory!", "No more RAM, dude!", 0);
        }
        catch (Exception e) {
            this.logger.error("ERROR:  ", e);
            return false;
        }
        this.logger.warn("Discrepancy in data inputted (" + this.dataInputted + ") and file size (" + fileLength + ")");
        return false;
    }

    private void performRulePostProcessingFromBIQ() {
        int i;
        for (BLDG building : this.buildings) {
            building.extractEnglish(this.numFlavors);
            building.setReqAdvance(building.getReqAdvance());
            building.setObsoleteBy(building.getObsoleteBy());
            building.setUnitProduced(building.getUnitProduced());
            building.setReqResource1(building.getReqResource1());
            building.setReqResource2(building.getReqResource2());
        }
        for (CTZN citizen : this.citizens) {
            citizen.setPrerequisite(citizen.getPrerequisite());
        }
        for (int i2 = 0; i2 < this.numTechnologies; ++i2) {
            this.technology.get(i2).extractEnglish(this.numFlavors);
            this.technology.get(i2).refreshPrerequisites();
        }
        for (RACE civ : this.civilization) {
            civ.extractEnglish(this.numFlavors);
            civ.refreshFreeTechs();
            civ.setKingUnit(civ.getKingUnit());
        }
        for (GOVT government : this.government) {
            government.setPrerequisiteTechnology(government.getPrerequisiteTechnology());
        }
        for (i = 0; i < this.resource.size(); ++i) {
            this.resource.get(i).setPrerequisite(this.resource.get(i).getPrerequisite());
        }
        for (i = 0; i < this.numTerrains; ++i) {
            this.terrain.get(i).simplifyGoods();
        }
        for (RULE ruleSet : this.rule) {
            ruleSet.setAdvancedBarbarian(ruleSet.getAdvancedBarbarian());
            ruleSet.setBasicBarbarian(ruleSet.getBasicBarbarian());
            ruleSet.setBarbarianSeaUnit(ruleSet.getBarbarianSeaUnit());
            ruleSet.setBattleCreatedUnit(ruleSet.getBattleCreatedUnit());
            ruleSet.setBuildArmyUnit(ruleSet.getBuildArmyUnit());
            ruleSet.setScout(ruleSet.getScout());
            ruleSet.setSlave(ruleSet.getSlave());
            ruleSet.setStartUnit1(ruleSet.getStartUnit1());
            ruleSet.setStartUnit2(ruleSet.getStartUnit2());
            ruleSet.setFlagUnit(ruleSet.getFlagUnit());
        }
        for (TRFM terraform : this.workerJob) {
            terraform.setRequiredAdvance(terraform.getRequiredAdvance());
        }
        for (PRTO prto : this.unit) {
            prto.setRequiredTech(prto.getRequiredTech());
            prto.setStealthTargetPRTOLinks();
            prto.setLegalUnitTelepadsPRTOLinks();
            prto.setEnslaveResultsIn(prto.getEnslaveResultsIn());
            prto.setUpgradeTo(prto.getUpgradeTo());
        }
    }

    private boolean inputBLDG(LittleEndianDataInputStream in) {
        try {
            Integer integer = in.readInt();
            this.dataInputted += 4;
            this.numBuildings = integer;
            for (int i = 0; i < this.numBuildings; ++i) {
                this.buildings.add(new BLDG(this));
                integer = in.readInt();
                this.dataInputted += 4;
                in.read(this.inputSixtyFour, 0, 64);
                this.dataInputted += 64;
                this.buildings.get(i).setDescription(new String(this.inputSixtyFour, this.currentCharset));
                in.read(this.inputThirtyTwo, 0, 32);
                this.dataInputted += 32;
                this.buildings.get(i).setName(new String(this.inputThirtyTwo, this.currentCharset));
                in.read(this.inputThirtyTwo, 0, 32);
                this.dataInputted += 32;
                this.buildings.get(i).setCivilopediaEntry(new String(this.inputThirtyTwo, this.currentCharset));
                integer = in.readInt();
                this.dataInputted += 4;
                this.buildings.get(i).setDoublesHappiness(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.buildings.get(i).setGainInEveryCity(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.buildings.get(i).setGainOnContinent(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.buildings.get(i).setReqImprovement(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.buildings.get(i).setCost(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.buildings.get(i).setCulture(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.buildings.get(i).setBombardDefence(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.buildings.get(i).setNavalBombardDefence(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.buildings.get(i).setDefenceBonus(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.buildings.get(i).setNavalDefenceBonus(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.buildings.get(i).setMaintenanceCost(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.buildings.get(i).setHappyAll(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.buildings.get(i).setHappy(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.buildings.get(i).setUnhappyAll(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.buildings.get(i).setUnhappy(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.buildings.get(i).setNumReqBuildings(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.buildings.get(i).setAirPower(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.buildings.get(i).setNavalPower(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.buildings.get(i).setPollution(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.buildings.get(i).setProduction(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.buildings.get(i).setReqGovernment(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.buildings.get(i).setSpaceshipPart(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.buildings.get(i).setReqAdvance(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.buildings.get(i).setObsoleteBy(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.buildings.get(i).setReqResource1(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.buildings.get(i).setReqResource2(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.buildings.get(i).setImprovements(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.buildings.get(i).setOtherChar(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.buildings.get(i).setSmallWonderCharacteristics(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.buildings.get(i).setWonderCharacteristics(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.buildings.get(i).setArmiesRequired(integer);
                if (this.version == civ3Version.CONQUESTS) {
                    integer = in.readInt();
                    this.dataInputted += 4;
                    this.buildings.get(i).setFlavors(integer);
                    integer = in.readInt();
                    this.dataInputted += 4;
                    this.buildings.get(i).setQuestionMark(integer);
                    integer = in.readInt();
                    this.dataInputted += 4;
                    this.buildings.get(i).setUnitProduced(integer);
                    integer = in.readInt();
                    this.dataInputted += 4;
                    this.buildings.get(i).setUnitFrequency(integer);
                }
                if (this.convertToConquests > 0) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Previous data length for " + this.buildings.get(i).getName() + " is " + this.buildings.get(i).getDataLength());
                    }
                    this.buildings.get(i).handleConvertToConquests();
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Increasing data length for " + this.buildings.get(i).getName() + " to " + this.buildings.get(i).getDataLength());
                    }
                } else if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Not converting to C3C");
                }
                this.buildings.get(i).trim();
            }
        }
        catch (Exception e) {
            this.logger.error("Error while inputting BLDG", e);
            return false;
        }
        return true;
    }

    private boolean inputCTZN(LittleEndianDataInputStream in) {
        try {
            in.read(this.inputFour, 0, 4);
            this.dataInputted += 4;
            String temp = new String(this.inputFour, this.currentCharset);
            if (!temp.equals("CTZN")) {
                this.logger.error("Could not input file - failed at CTZN header.  Header was " + temp);
                return false;
            }
            Integer integer = in.readInt();
            this.dataInputted += 4;
            this.numCitizens = integer;
            for (int i = 0; i < this.numCitizens; ++i) {
                this.citizens.add(new CTZN(this));
                integer = in.readInt();
                this.dataInputted += 4;
                integer = in.readInt();
                this.dataInputted += 4;
                this.citizens.get(i).setDefaultCitizen(integer);
                in.read(this.inputThirtyTwo, 0, 32);
                this.citizens.get(i).setName(new String(this.inputThirtyTwo, this.currentCharset));
                in.read(this.inputThirtyTwo, 0, 32);
                this.citizens.get(i).setCivilopediaEntry(new String(this.inputThirtyTwo, this.currentCharset));
                in.read(this.inputThirtyTwo, 0, 32);
                this.citizens.get(i).setPluralName(new String(this.inputThirtyTwo, this.currentCharset));
                this.dataInputted += 96;
                integer = in.readInt();
                this.dataInputted += 4;
                this.citizens.get(i).setPrerequisite(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.citizens.get(i).setLuxuries(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.citizens.get(i).setResearch(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.citizens.get(i).setTaxes(integer);
                if (this.version == civ3Version.CONQUESTS) {
                    integer = in.readInt();
                    this.dataInputted += 4;
                    this.citizens.get(i).setCorruption(integer);
                    integer = in.readInt();
                    this.dataInputted += 4;
                    this.citizens.get(i).setConstruction(integer);
                }
                if (this.convertToConquests > 0) {
                    // empty if block
                }
                this.citizens.get(i).trim();
            }
        }
        catch (Exception e) {
            this.logger.error("Error in CTZN header: ", e);
            return false;
        }
        return true;
    }

    private boolean inputCULT(LittleEndianDataInputStream in) {
        try {
            in.read(this.inputFour, 0, 4);
            this.dataInputted += 4;
            String temp = new String(this.inputFour, this.currentCharset);
            if (!temp.equals("CULT")) {
                this.logger.error("Could not input file - failed at CULT header.  Header is " + temp + "; bytes inputted: " + this.dataInputted);
                return false;
            }
            Integer integer = in.readInt();
            this.dataInputted += 4;
            this.numCulturalOpinions = integer;
            for (int i = 0; i < this.numCulturalOpinions; ++i) {
                this.culture.add(new CULT(this));
                integer = in.readInt();
                this.dataInputted += 4;
                in.read(this.inputSixtyFour, 0, 64);
                this.dataInputted += 64;
                this.culture.get(i).setName(new String(this.inputSixtyFour, this.currentCharset));
                integer = in.readInt();
                this.dataInputted += 4;
                this.culture.get(i).setPropagandaSuccess(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.culture.get(i).setCultRatioPercent(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.culture.get(i).setRatioDenominator(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.culture.get(i).setRatioNumerator(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.culture.get(i).setInitResistanceChance(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.culture.get(i).setContinuedResistanceChance(integer);
                this.culture.get(i).trim();
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Error in CULT section: " + e);
            return false;
        }
        return true;
    }

    private boolean inputDIFF(LittleEndianDataInputStream in) {
        try {
            in.read(this.inputFour, 0, 4);
            this.dataInputted += 4;
            String temp = new String(this.inputFour, this.currentCharset);
            if (!temp.equals("DIFF")) {
                this.logger.error("Failed at DIFF header - instead, read " + temp);
                return false;
            }
            Integer integer = in.readInt();
            this.dataInputted += 4;
            this.numDifficulties = integer;
            for (int i = 0; i < this.numDifficulties; ++i) {
                this.difficulties.add(new DIFF(this));
                integer = in.readInt();
                this.dataInputted += 4;
                in.read(this.inputSixtyFour, 0, 64);
                this.dataInputted += 64;
                this.difficulties.get(i).setName(new String(this.inputSixtyFour, this.currentCharset));
                integer = in.readInt();
                this.dataInputted += 4;
                this.difficulties.get(i).setContentCitizens(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.difficulties.get(i).setMaxGovtTransition(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.difficulties.get(i).setAIDefenceStart(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.difficulties.get(i).setAIOffenceStart(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.difficulties.get(i).setExtraStart1(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.difficulties.get(i).setExtraStart2(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.difficulties.get(i).setAdditionalFreeSupport(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.difficulties.get(i).setBonusPerCity(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.difficulties.get(i).setAttackBarbariansBonus(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.difficulties.get(i).setCostFactor(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.difficulties.get(i).setPercentOptimal(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.difficulties.get(i).setAIAITrade(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.difficulties.get(i).setCorruptionPercent(integer);
                if (this.version.ordinal() >= civ3Version.PTW.ordinal()) {
                    integer = in.readInt();
                    this.dataInputted += 4;
                    this.difficulties.get(i).setMilitaryLaw(integer);
                }
                this.difficulties.get(i).trim();
            }
        }
        catch (Exception e) {
            this.logger.error("Error in DIFF section: ", e);
            return false;
        }
        return true;
    }

    private boolean inputERAS(LittleEndianDataInputStream in) {
        try {
            in.read(this.inputFour, 0, 4);
            this.dataInputted += 4;
            String temp = new String(this.inputFour, this.currentCharset);
            if (!temp.equals("ERAS")) {
                this.logger.error("Could not input file - failed at ERAS header.  Header is " + temp + "; bytes inputted: " + this.dataInputted);
                return false;
            }
            Integer integer = in.readInt();
            this.dataInputted += 4;
            this.numEras = integer;
            for (int i = 0; i < this.numEras; ++i) {
                this.eras.add(new ERAS(this));
                integer = in.readInt();
                this.dataInputted += 4;
                in.read(this.inputSixtyFour, 0, 64);
                this.dataInputted += 64;
                this.eras.get(i).setEraName(new String(this.inputSixtyFour, this.currentCharset));
                in.read(this.inputThirtyTwo, 0, 32);
                this.dataInputted += 32;
                this.eras.get(i).setCivilopediaEntry(new String(this.inputThirtyTwo, this.currentCharset));
                in.read(this.inputThirtyTwo, 0, 32);
                this.dataInputted += 32;
                this.eras.get(i).setResearcher1(new String(this.inputThirtyTwo, this.currentCharset));
                in.read(this.inputThirtyTwo, 0, 32);
                this.dataInputted += 32;
                this.eras.get(i).setResearcher2(new String(this.inputThirtyTwo, this.currentCharset));
                in.read(this.inputThirtyTwo, 0, 32);
                this.dataInputted += 32;
                this.eras.get(i).setResearcher3(new String(this.inputThirtyTwo, this.currentCharset));
                in.read(this.inputThirtyTwo, 0, 32);
                this.dataInputted += 32;
                this.eras.get(i).setResearcher4(new String(this.inputThirtyTwo, this.currentCharset));
                in.read(this.inputThirtyTwo, 0, 32);
                this.dataInputted += 32;
                this.eras.get(i).setResearcher5(new String(this.inputThirtyTwo, this.currentCharset));
                integer = in.readInt();
                this.dataInputted += 4;
                this.eras.get(i).setUsedResearcherNames(integer);
                if (this.version == civ3Version.CONQUESTS) {
                    integer = in.readInt();
                    this.dataInputted += 4;
                    this.eras.get(i).setQuestionMark(integer);
                }
                if (this.convertToConquests > 0) {
                    // empty if block
                }
                this.eras.get(i).trim();
            }
        }
        catch (Exception e) {
            this.logger.error("Error in ERA section: ", e);
            return false;
        }
        return true;
    }

    private boolean inputESPN(LittleEndianDataInputStream in) {
        try {
            in.read(this.inputFour, 0, 4);
            this.dataInputted += 4;
            String temp = new String(this.inputFour, this.currentCharset);
            if (!temp.equals("ESPN")) {
                this.logger.error("Could not input file - failed at ESPN header.  Header is " + temp + "; bytes inputted: " + this.dataInputted);
                return false;
            }
            Integer integer = in.readInt();
            this.dataInputted += 4;
            this.numEspionage = integer;
            for (int i = 0; i < this.numEspionage; ++i) {
                this.espionage.add(new ESPN(this));
                integer = in.readInt();
                this.dataInputted += 4;
                in.read(this.inputOneHundredTwentyEight, 0, 128);
                this.dataInputted += 128;
                this.espionage.get(i).setDescription(new String(this.inputOneHundredTwentyEight, this.currentCharset));
                in.read(this.inputSixtyFour, 0, 64);
                this.dataInputted += 64;
                this.espionage.get(i).setName(new String(this.inputSixtyFour, this.currentCharset));
                in.read(this.inputThirtyTwo, 0, 32);
                this.dataInputted += 32;
                this.espionage.get(i).setCivilopediaEntry(new String(this.inputThirtyTwo, this.currentCharset));
                integer = in.readInt();
                this.dataInputted += 4;
                this.espionage.get(i).setMissionPerformedBy(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.espionage.get(i).setBaseCost(integer);
                this.espionage.get(i).trim();
            }
        }
        catch (Exception e) {
            this.logger.error("Error in ESPN : ", e);
            return false;
        }
        return true;
    }

    private boolean inputEXPR(LittleEndianDataInputStream in) {
        try {
            in.read(this.inputFour, 0, 4);
            this.dataInputted += 4;
            String temp = new String(this.inputFour, this.currentCharset);
            if (!temp.equals("EXPR")) {
                this.logger.error("Could not input file - failed at EXPR header.  Header is " + temp + "; bytes inputted: " + this.dataInputted);
                return false;
            }
            Integer integer = in.readInt();
            this.dataInputted += 4;
            this.numExprLevel = integer;
            for (int i = 0; i < this.numExprLevel; ++i) {
                this.experience.add(new EXPR(this));
                integer = in.readInt();
                this.dataInputted += 4;
                in.read(this.inputThirtyTwo, 0, 32);
                this.dataInputted += 32;
                this.experience.get(i).setName(new String(this.inputThirtyTwo, this.currentCharset));
                integer = in.readInt();
                this.dataInputted += 4;
                this.experience.get(i).setBaseHitPoints(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.experience.get(i).setRetreatBonus(integer);
                this.experience.get(i).trim();
            }
        }
        catch (Exception e) {
            this.logger.error("Error in EXPR: ", e);
            return false;
        }
        return true;
    }

    private boolean inputGOOD(LittleEndianDataInputStream in) {
        try {
            in.read(this.inputFour, 0, 4);
            this.dataInputted += 4;
            String temp = new String(this.inputFour, this.currentCharset);
            if (!temp.equals("GOOD")) {
                this.logger.error("Could not input file - failed at GOOD header.  Header is " + temp + "; bytes inputted: " + this.dataInputted);
                return false;
            }
            Integer integer = in.readInt();
            this.dataInputted += 4;
            this.numGoods = integer;
            for (int i = 0; i < this.numGoods; ++i) {
                this.resource.add(new GOOD(this));
                this.resource.get(i).setIndex(i);
                integer = in.readInt();
                this.dataInputted += 4;
                in.read(this.inputTwentyFour, 0, 24);
                this.dataInputted += 24;
                this.resource.get(i).setName(new String(this.inputTwentyFour, this.currentCharset));
                in.read(this.inputThirtyTwo, 0, 32);
                this.dataInputted += 32;
                this.resource.get(i).setCivilopediaEntry(new String(this.inputThirtyTwo, this.currentCharset));
                integer = in.readInt();
                this.dataInputted += 4;
                this.resource.get(i).setType(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.resource.get(i).setAppearanceRatio(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.resource.get(i).setDisapperanceProbability(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.resource.get(i).setIcon(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.resource.get(i).setPrerequisite(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.resource.get(i).setFoodBonus(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.resource.get(i).setShieldsBonus(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.resource.get(i).setCommerceBonus(integer);
                this.resource.get(i).trim();
            }
        }
        catch (Exception e) {
            this.logger.error("Error : ", e);
            return false;
        }
        return true;
    }

    private boolean inputGOVT(LittleEndianDataInputStream in) {
        try {
            in.read(this.inputFour, 0, 4);
            this.dataInputted += 4;
            String temp = new String(this.inputFour, this.currentCharset);
            if (!temp.equals("GOVT")) {
                this.logger.error("Could not input file - failed at GOVT header.  Header is " + temp + "; bytes inputted: " + this.dataInputted);
                return false;
            }
            Integer integer = in.readInt();
            this.dataInputted += 4;
            this.numGovernments = integer;
            for (int i = 0; i < this.numGovernments; ++i) {
                this.government.add(new GOVT(this));
                integer = in.readInt();
                this.dataInputted += 4;
                integer = in.readInt();
                this.dataInputted += 4;
                this.government.get(i).setDefaultType(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.government.get(i).setTransitionType(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.government.get(i).setRequiresMaintenance(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.government.get(i).setQuestionMarkOne(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.government.get(i).setTilePenalty(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.government.get(i).setCommerceBonus(integer);
                in.read(this.inputSixtyFour, 0, 64);
                this.dataInputted += 64;
                this.government.get(i).setName(new String(this.inputSixtyFour, this.currentCharset));
                in.read(this.inputThirtyTwo, 0, 32);
                this.dataInputted += 32;
                this.government.get(i).setCivilopediaEntry(new String(this.inputThirtyTwo, this.currentCharset));
                in.read(this.inputThirtyTwo, 0, 32);
                this.dataInputted += 32;
                this.government.get(i).setMaleRulerTitle1(new String(this.inputThirtyTwo, this.currentCharset));
                in.read(this.inputThirtyTwo, 0, 32);
                this.dataInputted += 32;
                this.government.get(i).setFemaleRulerTitle1(new String(this.inputThirtyTwo, this.currentCharset));
                in.read(this.inputThirtyTwo, 0, 32);
                this.dataInputted += 32;
                this.government.get(i).setMaleRulerTitle2(new String(this.inputThirtyTwo, this.currentCharset));
                in.read(this.inputThirtyTwo, 0, 32);
                this.dataInputted += 32;
                this.government.get(i).setFemaleRulerTitle2(new String(this.inputThirtyTwo, this.currentCharset));
                in.read(this.inputThirtyTwo, 0, 32);
                this.dataInputted += 32;
                this.government.get(i).setMaleRulerTitle3(new String(this.inputThirtyTwo, this.currentCharset));
                in.read(this.inputThirtyTwo, 0, 32);
                this.dataInputted += 32;
                this.government.get(i).setFemaleRulerTitle3(new String(this.inputThirtyTwo, this.currentCharset));
                in.read(this.inputThirtyTwo, 0, 32);
                this.dataInputted += 32;
                this.government.get(i).setMaleRulerTitle4(new String(this.inputThirtyTwo, this.currentCharset));
                in.read(this.inputThirtyTwo, 0, 32);
                this.dataInputted += 32;
                this.government.get(i).setFemaleRulerTitle4(new String(this.inputThirtyTwo, this.currentCharset));
                integer = in.readInt();
                this.dataInputted += 4;
                this.government.get(i).setCorruption(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.government.get(i).setImmuneTo(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.government.get(i).setDiplomatLevel(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.government.get(i).setSpyLevel(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.government.get(i).setNumberOfGovernments(integer);
                for (int j = 0; j < this.government.get(i).getNumberOfGovernments(); ++j) {
                    this.government.get((int)i).relations.add(new GOVTGOVTRelations());
                    integer = in.readInt();
                    this.dataInputted += 4;
                    this.government.get((int)i).relations.get(j).setCanBribe(integer);
                    integer = in.readInt();
                    this.dataInputted += 4;
                    this.government.get((int)i).relations.get(j).setBriberyModifier(integer);
                    integer = in.readInt();
                    this.dataInputted += 4;
                    this.government.get((int)i).relations.get(j).setResistanceModifier(integer);
                }
                integer = in.readInt();
                this.dataInputted += 4;
                this.government.get(i).setHurrying(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.government.get(i).setAssimilationChance(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.government.get(i).setDraftLimit(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.government.get(i).setMilitaryPoliceLimit(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.government.get(i).setRulerTitlePairsUsed(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.government.get(i).setPrerequisiteTechnology(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.government.get(i).setScienceCap(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.government.get(i).setWorkerRate(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.government.get(i).setQuestionMarkTwo(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.government.get(i).setQuestionMarkThree(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.government.get(i).setQuestionMarkFour(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.government.get(i).setFreeUnits(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.government.get(i).setFreeUnitsPerTown(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.government.get(i).setFreeUnitsPerCity(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.government.get(i).setFreeUnitsPerMetropolis(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.government.get(i).setCostPerUnit(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.government.get(i).setWarWeariness(integer);
                if (this.version == civ3Version.CONQUESTS) {
                    integer = in.readInt();
                    this.dataInputted += 4;
                    this.government.get(i).setXenophobic(integer);
                    integer = in.readInt();
                    this.dataInputted += 4;
                    this.government.get(i).setForceResettlement(integer);
                }
                if (this.convertToConquests > 0) {
                    // empty if block
                }
                this.government.get(i).trim();
            }
        }
        catch (Exception e) {
            this.logger.error("Error in GOVT: ", e);
            return false;
        }
        return true;
    }

    private boolean inputRULE(LittleEndianDataInputStream in) {
        try {
            in.read(this.inputFour, 0, 4);
            this.dataInputted += 4;
            String temp = new String(this.inputFour, this.currentCharset);
            if (!temp.equals("RULE")) {
                this.logger.error("Could not input file - failed at RULE header.  Header is " + temp + "; bytes inputted: " + this.dataInputted);
                return false;
            }
            Integer integer = in.readInt();
            this.dataInputted += 4;
            this.numRules = integer;
            for (int i = 0; i < this.numRules; ++i) {
                this.rule.add(new RULE(this));
                integer = in.readInt();
                this.dataInputted += 4;
                int ruleStartInputted = this.dataInputted;
                boolean convertedRules = false;
                this.rule.get(i).setDataLength(integer);
                in.read(this.inputThirtyTwo, 0, 32);
                this.dataInputted += 32;
                this.rule.get(i).setTownName(new String(this.inputThirtyTwo, this.currentCharset));
                in.read(this.inputThirtyTwo, 0, 32);
                this.dataInputted += 32;
                this.rule.get(i).setCityName(new String(this.inputThirtyTwo, this.currentCharset));
                in.read(this.inputThirtyTwo, 0, 32);
                this.dataInputted += 32;
                this.rule.get(i).setMetropolisName(new String(this.inputThirtyTwo, this.currentCharset));
                int numSpaceshipParts = in.readInt();
                this.dataInputted += 4;
                for (int j = 0; j < numSpaceshipParts; ++j) {
                    integer = in.readInt();
                    this.dataInputted += 4;
                    this.rule.get(i).addSpaceshipPart(integer, true);
                }
                integer = in.readInt();
                this.dataInputted += 4;
                this.rule.get(i).setAdvancedBarbarian(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.rule.get(i).setBasicBarbarian(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.rule.get(i).setBarbarianSeaUnit(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.rule.get(i).setCitiesForArmy(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.rule.get(i).setChanceOfRioting(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.rule.get(i).setDraftTurnPenalty(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.rule.get(i).setShieldCostInGold(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.rule.get(i).setFortressDefenceBonus(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.rule.get(i).setCitizensAffectedByHappyFace(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.rule.get(i).setQuestionMark1(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.rule.get(i).setQuestionMark2(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.rule.get(i).setForestValueInShields(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.rule.get(i).setShieldValueInGold(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.rule.get(i).setCitizenValueInShields(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.rule.get(i).setDefaultDifficultyLevel(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.rule.get(i).setBattleCreatedUnit(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.rule.get(i).setBuildArmyUnit(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.rule.get(i).setBuildingDefensiveBonus(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.rule.get(i).setCitizenDefensiveBonus(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.rule.get(i).setDefaultMoneyResource(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.rule.get(i).setChanceToInterceptAirMissions(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.rule.get(i).setChanceToInterceptStealthMissions(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.rule.get(i).setStartingTreasury(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.rule.get(i).setQuestionMark3(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.rule.get(i).setFoodConsumptionPerCitizen(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.rule.get(i).setRiverDefensiveBonus(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.rule.get(i).setTurnPenaltyForWhip(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.rule.get(i).setScout(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.rule.get(i).setSlave(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.rule.get(i).setRoadMovementRate(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.rule.get(i).setStartUnit1(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.rule.get(i).setStartUnit2(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.rule.get(i).setWLTKDMinimumPop(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.rule.get(i).setTownDefenceBonus(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.rule.get(i).setCityDefenceBonus(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.rule.get(i).setMetropolisDefenceBonus(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.rule.get(i).setMaxCity1Size(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.rule.get(i).setMaxCity2Size(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.rule.get(i).setQuestionMark4(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.rule.get(i).setFortificationsDefenceBonus(integer);
                int numCultureLevelNames = in.readInt();
                this.dataInputted += 4;
                for (int j = 0; j < numCultureLevelNames; ++j) {
                    in.read(this.inputSixtyFour, 0, 64);
                    this.dataInputted += 64;
                    this.rule.get(i).addCultureLevelName(new String(this.inputSixtyFour, this.currentCharset));
                }
                integer = in.readInt();
                this.dataInputted += 4;
                this.rule.get(i).setBorderExpansionMultiplier(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.rule.get(i).setBorderFactor(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.rule.get(i).setFutureTechCost(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.rule.get(i).setGoldenAgeDuration(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.rule.get(i).setMaximumResearchTime(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.rule.get(i).setMinimumResearchTime(integer);
                if (this.version.ordinal() >= civ3Version.PTW.ordinal()) {
                    integer = in.readInt();
                    this.dataInputted += 4;
                    this.rule.get(i).setFlagUnit(integer);
                    if (this.version == civ3Version.CONQUESTS) {
                        integer = in.readInt();
                        this.dataInputted += 4;
                        this.rule.get(i).setUpgradeCost(integer);
                    } else if (this.convertToConquests > 0) {
                        convertedRules = true;
                        this.rule.get(i).convertToConquestsFromPTW();
                    }
                } else if (this.convertToConquests > 0) {
                    this.rule.get(i).convertToPTWFromVanilla();
                    this.rule.get(i).convertToConquestsFromPTW();
                }
                if (!convertedRules) {
                    int dataForRules = this.dataInputted - ruleStartInputted;
                    if (this.rule.get(i).getDataLength() != dataForRules) {
                        this.rule.get(i).setDataLength(dataForRules);
                    }
                }
                this.rule.get(i).trim();
            }
        }
        catch (Exception e) {
            this.logger.error("Error in RULE:", e);
            return false;
        }
        return true;
    }

    private boolean inputPRTO(LittleEndianDataInputStream in) {
        int i = 0;
        try {
            in.read(this.inputFour, 0, 4);
            this.dataInputted += 4;
            String temp = new String(this.inputFour, this.currentCharset);
            if (!temp.equals("PRTO")) {
                this.logger.error("Could not input file - failed at PRTO header.  Header is " + temp + "; bytes inputted: " + this.dataInputted);
                return false;
            }
            Integer integer = in.readInt();
            this.dataInputted += 4;
            this.numUnits = integer;
            for (i = 0; i < this.numUnits; ++i) {
                int startData = this.dataInputted;
                PRTO newPRTO = new PRTO(this, i);
                integer = in.readInt();
                this.dataInputted += 4;
                integer = in.readInt();
                this.dataInputted += 4;
                newPRTO.setZoneOfControl(integer);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("At name: " + this.dataInputted + " bytes inputted");
                }
                in.read(this.inputThirtyTwo, 0, 32);
                this.dataInputted += 32;
                newPRTO.setName(new String(this.inputThirtyTwo, this.currentCharset));
                in.read(this.inputThirtyTwo, 0, 32);
                this.dataInputted += 32;
                newPRTO.setCivilopediaEntry(new String(this.inputThirtyTwo, this.currentCharset));
                integer = in.readInt();
                this.dataInputted += 4;
                newPRTO.setBombardStrength(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                newPRTO.setBombardRange(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                newPRTO.setCapacity(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                newPRTO.setShieldCost(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                newPRTO.setDefence(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                newPRTO.setIconIndex(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                newPRTO.setAttack(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                newPRTO.setOperationalRange(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                newPRTO.setPopulationCost(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                newPRTO.setRateOfFire(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                newPRTO.setMovement(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                newPRTO.setRequiredTech(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                newPRTO.setUpgradeTo(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                newPRTO.setRequiredResource1(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                newPRTO.setRequiredResource2(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                newPRTO.setRequiredResource3(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                newPRTO.setUnitAbilities(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                newPRTO.setAIStrategy(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                newPRTO.setAvailableToBinary(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                newPRTO.setStandardOrdersSpecialActions(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                newPRTO.setAirMissions(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                newPRTO.setUnitClass(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                newPRTO.setOtherStrategy(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                newPRTO.setHitPointBonus(integer);
                if (this.version.ordinal() >= civ3Version.PTW.ordinal()) {
                    integer = in.readInt();
                    this.dataInputted += 4;
                    newPRTO.setPTWStandardOrders(integer);
                    integer = in.readInt();
                    this.dataInputted += 4;
                    newPRTO.setPTWSpecialActions(integer);
                    integer = in.readInt();
                    this.dataInputted += 4;
                    newPRTO.setPTWWorkerActions(integer);
                    integer = in.readInt();
                    this.dataInputted += 4;
                    newPRTO.setPTWAirMissions(integer);
                    integer = in.readInt();
                    this.dataInputted += 4;
                    integer = integer - 65536;
                    newPRTO.setPTWActionsMix(integer);
                    integer = in.readInt();
                    this.dataInputted += 4;
                    newPRTO.setBombardEffects(integer);
                    int maxTerr = this.version == civ3Version.CONQUESTS ? 14 : 12;
                    for (int j = 0; j < maxTerr; ++j) {
                        this.inputByte = in.readByte();
                        ++this.dataInputted;
                        newPRTO.setIgnoredMovementCost(j, this.inputByte);
                    }
                    integer = in.readInt();
                    this.dataInputted += 4;
                    newPRTO.setRequiresSupport(integer);
                    if (this.version == civ3Version.CONQUESTS) {
                        integer = in.readInt();
                        this.dataInputted += 4;
                        newPRTO.setUseExactCost(integer);
                        integer = in.readInt();
                        this.dataInputted += 4;
                        newPRTO.setTelepadRange(integer);
                        integer = in.readInt();
                        this.dataInputted += 4;
                        newPRTO.setQuestionMark3(integer);
                        int numUnitTelepads = in.readInt();
                        this.dataInputted += 4;
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug(this.dataInputted + " and num unit telepads = " + integer);
                        }
                        for (int j = 0; j < numUnitTelepads; ++j) {
                            integer = in.readInt();
                            this.dataInputted += 4;
                            newPRTO.addUnitTelepad(integer);
                        }
                        integer = in.readInt();
                        this.dataInputted += 4;
                        newPRTO.setEnslaveResultsIn(integer);
                        integer = in.readInt();
                        this.dataInputted += 4;
                        newPRTO.setQuestionMark5(integer);
                        int numStealthTargets = in.readInt();
                        this.dataInputted += 4;
                        for (int j = 0; j < numStealthTargets; ++j) {
                            integer = in.readInt();
                            this.dataInputted += 4;
                            newPRTO.addStealthAttackTarget(integer);
                        }
                        integer = in.readInt();
                        this.dataInputted += 4;
                        newPRTO.setQuestionMark6(integer);
                        int numLegalBuildingTelepads = in.readInt();
                        this.dataInputted += 4;
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug(this.dataInputted + " and num bldg telepads = " + integer);
                        }
                        for (int j = 0; j < numLegalBuildingTelepads; ++j) {
                            integer = in.readInt();
                            this.dataInputted += 4;
                            newPRTO.addBuildingTelepad(integer);
                        }
                        this.inputByte = in.readByte();
                        ++this.dataInputted;
                        newPRTO.setCreatesCraters(this.inputByte);
                        float floatingPoint = in.readFloat();
                        this.dataInputted += 4;
                        newPRTO.setWorkerStrengthFloat(floatingPoint);
                        integer = in.readInt();
                        this.dataInputted += 4;
                        newPRTO.setQuestionMark8(integer);
                        integer = in.readInt();
                        this.dataInputted += 4;
                        newPRTO.setAirDefence(integer);
                    }
                }
                if (newPRTO.getOtherStrategy() != -1) {
                    this.unit.get((int)newPRTO.getOtherStrategy()).AIStrategy |= newPRTO.AIStrategy;
                    this.unit.get(newPRTO.getOtherStrategy()).extractAIStrategy();
                    continue;
                }
                newPRTO.trim();
                newPRTO.extractEnglish();
                this.unit.add(newPRTO);
                if (this.convertToConquests <= 0) continue;
                if (this.version == civ3Version.VANILLA) {
                    newPRTO.convertFromVanillaToConquests();
                    continue;
                }
                newPRTO.convertFromPTWToConquests();
            }
        }
        catch (Exception e) {
            this.logger.error("Error in PRTO: ", e);
            this.logger.error("Bytes inputted: " + this.dataInputted);
            try {
                this.logger.error("Unit affected: " + this.unit.get(this.unit.size() - 1).getName() + ", index: " + i);
                this.logger.error("num legal unit telepads: " + this.unit.get(this.unit.size() - 1).getNumLegalUnitTelepads());
                this.logger.error("num legal building telepads: " + this.unit.get(this.unit.size() - 1).getNumLegalBuildingTelepads());
            }
            catch (Exception f) {
                this.logger.error("Could not get unit name", f);
            }
            return false;
        }
        return true;
    }

    private boolean inputRACE(LittleEndianDataInputStream in) {
        try {
            in.read(this.inputFour, 0, 4);
            this.dataInputted += 4;
            String temp = new String(this.inputFour, this.currentCharset);
            if (!temp.equals("RACE")) {
                this.logger.error("Could not input file - failed at RACE header.  Header is " + temp + "; bytes inputted: " + this.dataInputted);
                return false;
            }
            Integer integer = in.readInt();
            this.dataInputted += 4;
            this.numCivilizations = integer;
            for (int i = 0; i < this.numCivilizations; ++i) {
                int j;
                this.civilization.add(new RACE(this));
                integer = in.readInt();
                this.dataInputted += 4;
                int numCities = in.readInt();
                this.dataInputted += 4;
                for (int j2 = 0; j2 < numCities; ++j2) {
                    in.read(this.inputTwentyFour, 0, 24);
                    this.dataInputted += 24;
                    this.civilization.get(i).addCityName(new String(this.inputTwentyFour, this.currentCharset));
                }
                int numMilitaryLeaders = in.readInt();
                this.dataInputted += 4;
                for (j = 0; j < numMilitaryLeaders; ++j) {
                    in.read(this.inputThirtyTwo, 0, 32);
                    this.dataInputted += 32;
                    this.civilization.get(i).addMilitaryLeader(new String(this.inputThirtyTwo, this.currentCharset));
                }
                in.read(this.inputThirtyTwo, 0, 32);
                this.dataInputted += 32;
                this.civilization.get(i).setLeaderName(new String(this.inputThirtyTwo, this.currentCharset));
                in.read(this.inputTwentyFour, 0, 24);
                this.dataInputted += 24;
                this.civilization.get(i).setLeaderTitle(new String(this.inputTwentyFour, this.currentCharset));
                in.read(this.inputThirtyTwo, 0, 32);
                this.dataInputted += 32;
                this.civilization.get(i).setCivilopediaEntry(new String(this.inputThirtyTwo, this.currentCharset));
                in.read(this.inputForty, 0, 40);
                this.dataInputted += 40;
                this.civilization.get(i).setAdjective(new String(this.inputForty, this.currentCharset));
                in.read(this.inputForty, 0, 40);
                this.dataInputted += 40;
                this.civilization.get(i).setCivilizationName(new String(this.inputForty, this.currentCharset));
                in.read(this.inputForty, 0, 40);
                this.dataInputted += 40;
                this.civilization.get(i).setNoun(new String(this.inputForty, this.currentCharset));
                for (j = 0; j < this.numEras; ++j) {
                    in.read(this.inputTwoSixty, 0, 260);
                    this.dataInputted += 260;
                    this.civilization.get(i).addForwardFilename(new String(this.inputTwoSixty, this.currentCharset));
                }
                for (j = 0; j < this.numEras; ++j) {
                    in.read(this.inputTwoSixty, 0, 260);
                    this.dataInputted += 260;
                    this.civilization.get(i).addReverseFilename(new String(this.inputTwoSixty, this.currentCharset));
                }
                integer = in.readInt();
                this.dataInputted += 4;
                this.civilization.get(i).setCultureGroup(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.civilization.get(i).setLeaderGender(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.civilization.get(i).setCivilizationGender(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.civilization.get(i).setAggressionLevel(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.civilization.get(i).setUniqueCivilizationCounter(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.civilization.get(i).setShunnedGovernment(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.civilization.get(i).setFavoriteGovernment(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.civilization.get(i).setDefaultColor(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.civilization.get(i).setUniqueColor(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.civilization.get(i).setFreeTech1Index(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.civilization.get(i).setFreeTech2Index(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.civilization.get(i).setFreeTech3Index(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.civilization.get(i).setFreeTech4Index(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.civilization.get(i).setBonuses(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.civilization.get(i).setGovernorSettings(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.civilization.get(i).setBuildNever(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.civilization.get(i).setBuildOften(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.civilization.get(i).setPlurality(integer);
                if (this.version.ordinal() >= civ3Version.PTW.ordinal()) {
                    integer = in.readInt();
                    this.dataInputted += 4;
                    this.civilization.get(i).setKingUnit(integer);
                    if (this.version == civ3Version.CONQUESTS) {
                        integer = in.readInt();
                        this.dataInputted += 4;
                        this.civilization.get(i).setFlavors(integer);
                        integer = in.readInt();
                        this.dataInputted += 4;
                        this.civilization.get(i).setQuestionMark(integer);
                        integer = in.readInt();
                        this.dataInputted += 4;
                        this.civilization.get(i).setDiplomacyTextIndex(integer);
                        int numScientificLeaders = in.readInt();
                        this.dataInputted += 4;
                        for (int j3 = 0; j3 < numScientificLeaders; ++j3) {
                            in.read(this.inputThirtyTwo, 0, 32);
                            this.dataInputted += 32;
                            this.civilization.get(i).addScientificLeader(new String(this.inputThirtyTwo, this.currentCharset));
                        }
                    }
                }
                if (this.convertToConquests > 0) {
                    this.civilization.get(i).handleConvertFromPTWToConquests();
                }
                this.civilization.get(i).trim();
            }
        }
        catch (Exception e) {
            this.logger.error("Error in RACE: ", e);
            return false;
        }
        return true;
    }

    private boolean inputTECH(LittleEndianDataInputStream in) {
        try {
            in.read(this.inputFour, 0, 4);
            this.dataInputted += 4;
            String temp = new String(this.inputFour, this.currentCharset);
            if (!temp.equals("TECH")) {
                this.logger.error("Could not input file - failed at TECH header.  Header is " + temp + "; bytes inputted: " + this.dataInputted);
                return false;
            }
            Integer integer = in.readInt();
            this.dataInputted += 4;
            this.numTechnologies = integer;
            for (int i = 0; i < this.numTechnologies; ++i) {
                this.technology.add(new TECH(this));
                this.technology.get(i).setIndex(i);
                integer = in.readInt();
                this.dataInputted += 4;
                in.read(this.inputThirtyTwo, 0, 32);
                this.dataInputted += 32;
                this.technology.get(i).setName(new String(this.inputThirtyTwo, this.currentCharset));
                in.read(this.inputThirtyTwo, 0, 32);
                this.dataInputted += 32;
                this.technology.get(i).setCivilopediaEntry(new String(this.inputThirtyTwo, this.currentCharset));
                integer = in.readInt();
                this.dataInputted += 4;
                this.technology.get(i).setCost(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.technology.get(i).setEra(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.technology.get(i).setAdvanceIcon(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.technology.get(i).setX(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.technology.get(i).setY(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.technology.get(i).setPrerequisite1(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.technology.get(i).setPrerequisite2(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.technology.get(i).setPrerequisite3(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.technology.get(i).setPrerequisite4(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.technology.get(i).setFlags(integer);
                if (this.version == civ3Version.CONQUESTS) {
                    integer = in.readInt();
                    this.dataInputted += 4;
                    this.technology.get(i).setFlavors(integer);
                    integer = in.readInt();
                    this.dataInputted += 4;
                    this.technology.get(i).setQuestionMark(integer);
                }
                if (this.convertToConquests > 0) {
                    this.technology.get(i).convertFromPTWToConquests();
                }
                this.technology.get(i).trim();
            }
        }
        catch (Exception e) {
            this.logger.error("Error in TECH: ", e);
            return false;
        }
        return true;
    }

    private boolean inputTFRM(LittleEndianDataInputStream in) {
        try {
            in.read(this.inputFour, 0, 4);
            this.dataInputted += 4;
            String temp = new String(this.inputFour, this.currentCharset);
            if (!temp.equals("TFRM")) {
                this.logger.error("Could not input file - failed at TFRM header.  Header is " + temp + "; bytes inputted: " + this.dataInputted);
                return false;
            }
            Integer integer = in.readInt();
            this.dataInputted += 4;
            this.numWorkerJobs = integer;
            for (int i = 0; i < this.numWorkerJobs; ++i) {
                this.workerJob.add(new TRFM(this));
                integer = in.readInt();
                this.dataInputted += 4;
                this.workerJob.get(i).setDataLength(integer);
                in.read(this.inputThirtyTwo, 0, 32);
                this.dataInputted += 32;
                this.workerJob.get(i).setName(new String(this.inputThirtyTwo, this.currentCharset));
                in.read(this.inputThirtyTwo, 0, 32);
                this.dataInputted += 32;
                this.workerJob.get(i).setCivilopediaEntry(new String(this.inputThirtyTwo, this.currentCharset));
                integer = in.readInt();
                this.dataInputted += 4;
                this.workerJob.get(i).setTurnsToComplete(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.workerJob.get(i).setRequiredAdvance(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.workerJob.get(i).setRequiredResource1(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.workerJob.get(i).setRequiredResource2(integer);
                in.read(this.inputThirtyTwo, 0, 32);
                this.dataInputted += 32;
                this.workerJob.get(i).setOrder(new String(this.inputThirtyTwo, this.currentCharset));
                this.workerJob.get(i).trim();
            }
        }
        catch (Exception e) {
            this.logger.error("Error in TFRM: " + e);
            return false;
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean inputTERR(LittleEndianDataInputStream in) {
        try {
            in.read(this.inputFour, 0, 4);
            this.dataInputted += 4;
            String temp = new String(this.inputFour, this.currentCharset);
            if (!temp.equals("TERR")) {
                this.logger.error("Could not input file - failed at TERR header.  Header is " + temp + "; bytes inputted: " + this.dataInputted);
                return false;
            }
            Integer integer = in.readInt();
            this.dataInputted += 4;
            this.numTerrains = integer;
            for (int i = 0; i < this.numTerrains; ++i) {
                this.terrain.add(new TERR(this));
                integer = in.readInt();
                this.dataInputted += 4;
                this.terrain.get(i).setDataLength(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.terrain.get(i).setNumTotalResources(integer);
                int bytesOfAllowedResourceDataToInput = (integer + 7) / 8;
                for (int j = 0; j < bytesOfAllowedResourceDataToInput; ++j) {
                    this.inputByte = in.readByte();
                    ++this.dataInputted;
                    this.terrain.get((int)i).possibleResources.add(this.inputByte);
                }
                in.read(this.inputThirtyTwo, 0, 32);
                this.dataInputted += 32;
                this.terrain.get(i).setName(new String(this.inputThirtyTwo, this.currentCharset));
                in.read(this.inputThirtyTwo, 0, 32);
                this.dataInputted += 32;
                this.terrain.get(i).setCivilopediaEntry(new String(this.inputThirtyTwo, this.currentCharset));
                integer = in.readInt();
                this.dataInputted += 4;
                this.terrain.get(i).setFoodBonus(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.terrain.get(i).setShieldsBonus(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.terrain.get(i).setCommerceBonus(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.terrain.get(i).setDefenceBonus(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.terrain.get(i).setMovementCost(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.terrain.get(i).setFood(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.terrain.get(i).setShields(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.terrain.get(i).setCommerce(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.terrain.get(i).setWorkerJob(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.terrain.get(i).setPollutionEffect(integer);
                this.inputByte = in.readByte();
                ++this.dataInputted;
                this.terrain.get(i).setAllowCities(this.inputByte);
                this.inputByte = in.readByte();
                ++this.dataInputted;
                this.terrain.get(i).setAllowColonies(this.inputByte);
                if (this.version.ordinal() >= civ3Version.PTW.ordinal()) {
                    this.inputByte = in.readByte();
                    ++this.dataInputted;
                    this.terrain.get(i).setImpassable(this.inputByte);
                    this.inputByte = in.readByte();
                    ++this.dataInputted;
                    this.terrain.get(i).setImpassableByWheeled(this.inputByte);
                    this.inputByte = in.readByte();
                    ++this.dataInputted;
                    this.terrain.get(i).setAllowAirfields(this.inputByte);
                    this.inputByte = in.readByte();
                    ++this.dataInputted;
                    this.terrain.get(i).setAllowForts(this.inputByte);
                    this.inputByte = in.readByte();
                    ++this.dataInputted;
                    this.terrain.get(i).setAllowOutposts(this.inputByte);
                    this.inputByte = in.readByte();
                    ++this.dataInputted;
                    this.terrain.get(i).setAllowRadarTowers(this.inputByte);
                    if (this.version == civ3Version.CONQUESTS) {
                        integer = in.readInt();
                        this.dataInputted += 4;
                        this.terrain.get(i).setQuestionMark(integer);
                        this.inputByte = in.readByte();
                        ++this.dataInputted;
                        this.terrain.get(i).setLandmarkEnabled(this.inputByte);
                        integer = in.readInt();
                        this.dataInputted += 4;
                        this.terrain.get(i).setLandmarkFood(integer);
                        integer = in.readInt();
                        this.dataInputted += 4;
                        this.terrain.get(i).setLandmarkShields(integer);
                        integer = in.readInt();
                        this.dataInputted += 4;
                        this.terrain.get(i).setLandmarkCommerce(integer);
                        integer = in.readInt();
                        this.dataInputted += 4;
                        this.terrain.get(i).setLandmarkFoodBonus(integer);
                        integer = in.readInt();
                        this.dataInputted += 4;
                        this.terrain.get(i).setLandmarkShieldsBonus(integer);
                        integer = in.readInt();
                        this.dataInputted += 4;
                        this.terrain.get(i).setLandmarkCommerceBonus(integer);
                        integer = in.readInt();
                        this.dataInputted += 4;
                        this.terrain.get(i).setLandmarkMovementCost(integer);
                        integer = in.readInt();
                        this.dataInputted += 4;
                        this.terrain.get(i).setLandmarkDefenceBonus(integer);
                        in.read(this.inputThirtyTwo, 0, 32);
                        this.dataInputted += 32;
                        this.terrain.get(i).setLandmarkName(new String(this.inputThirtyTwo, this.currentCharset));
                        in.read(this.inputThirtyTwo, 0, 32);
                        this.dataInputted += 32;
                        this.terrain.get(i).setLandmarkCivilopediaEntry(new String(this.inputThirtyTwo, this.currentCharset));
                        integer = in.readInt();
                        this.dataInputted += 4;
                        this.terrain.get(i).setQuestionMark2(integer);
                        integer = in.readInt();
                        this.dataInputted += 4;
                        this.terrain.get(i).setTerrainFlags(integer);
                        integer = in.readInt();
                        this.dataInputted += 4;
                        this.terrain.get(i).setDiseaseStrength(integer);
                    } else if (this.convertToConquests > 0) {
                        this.terrain.get((int)i).dataLength += 113;
                    }
                } else if (this.convertToConquests > 0) {
                    this.terrain.get((int)i).dataLength += 120;
                }
                this.terrain.get(i).trim();
            }
            if (this.convertToConquests <= 0) return true;
        }
        catch (Exception e) {
            this.logger.error("Error in TERR: ", e);
            return false;
        }
        return true;
    }

    private boolean inputWSIZ(LittleEndianDataInputStream in) {
        try {
            in.read(this.inputFour, 0, 4);
            this.dataInputted += 4;
            String temp = new String(this.inputFour, this.currentCharset);
            if (!temp.equals("WSIZ")) {
                this.logger.error("Could not input file - failed at WSIZ header.  Header is " + temp + "; bytes inputted: " + this.dataInputted);
                return false;
            }
            Integer integer = in.readInt();
            this.dataInputted += 4;
            this.numWorldSizes = integer;
            for (int i = 0; i < this.numWorldSizes; ++i) {
                this.worldSize.add(new WSIZ(this));
                integer = in.readInt();
                this.dataInputted += 4;
                this.worldSize.get(i).setDataLength(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.worldSize.get(i).setOptimalNumberOfCities(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.worldSize.get(i).setTechRate(integer);
                in.read(this.inputTwentyFour, 0, 24);
                this.dataInputted += 24;
                this.worldSize.get(i).setEmpty(new String(this.inputTwentyFour, this.currentCharset));
                in.read(this.inputThirtyTwo, 0, 32);
                this.dataInputted += 32;
                this.worldSize.get(i).setName(new String(this.inputThirtyTwo, this.currentCharset));
                integer = in.readInt();
                this.dataInputted += 4;
                this.worldSize.get(i).setHeight(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.worldSize.get(i).setDistanceBetweenCivs(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.worldSize.get(i).setNumberOfCivs(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.worldSize.get(i).setWidth(integer);
                this.worldSize.get(i).trim();
            }
        }
        catch (Exception e) {
            this.logger.error("Error in WSIZ: ", e);
            return false;
        }
        return true;
    }

    private boolean inputFLAV(LittleEndianDataInputStream in) {
        try {
            in.read(this.inputFour, 0, 4);
            this.dataInputted += 4;
            String temp = new String(this.inputFour, this.currentCharset);
            if (!temp.equals("FLAV")) {
                this.logger.error("Could not input file - failed at FLAV header.  Header is " + temp + "; bytes inputted: " + this.dataInputted);
                return false;
            }
            Integer integer = in.readInt();
            this.dataInputted += 4;
            integer = in.readInt();
            this.dataInputted += 4;
            this.numFlavors = integer;
            for (int i = 0; i < this.numFlavors; ++i) {
                this.flavor.add(new FLAV(this));
                integer = in.readInt();
                this.dataInputted += 4;
                this.flavor.get(i).setQuestionMark(integer);
                in.read(this.inputTwoFiftySix, 0, 256);
                this.dataInputted += 256;
                this.flavor.get(i).setName(new String(this.inputTwoFiftySix, this.currentCharset));
                integer = in.readInt();
                this.dataInputted += 4;
                this.flavor.get(i).setNumberOfFlavors(integer);
                for (int j = 0; j < this.flavor.get(i).getNumberOfFlavors(); ++j) {
                    integer = in.readInt();
                    this.dataInputted += 4;
                    this.flavor.get((int)i).relationWithOtherFlavor.add(new Integer(integer));
                }
                this.flavor.get(i).trim();
            }
        }
        catch (Exception e) {
            this.logger.error("Error in FLAV section: ", e);
            return false;
        }
        return true;
    }

    private boolean inputWMAP(LittleEndianDataInputStream in) {
        try {
            in.read(this.inputFour, 0, 4);
            this.dataInputted += 4;
            String temp = new String(this.inputFour, this.currentCharset);
            if (!temp.equals("WMAP")) {
                this.logger.error("Could not input file - failed at WMAP header.  Header is " + temp + "; bytes inputted: " + this.dataInputted);
                return false;
            }
            Integer integer = in.readInt();
            this.dataInputted += 4;
            this.numWorldMaps = integer;
            for (int i = 0; i < this.numWorldMaps; ++i) {
                this.worldMap.add(new WMAP(this));
                integer = in.readInt();
                this.dataInputted += 4;
                this.worldMap.get(i).setDataLength(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.worldMap.get(i).setNumResources(integer);
                for (int j = 0; j < this.worldMap.get(i).getNumResources(); ++j) {
                    integer = in.readInt();
                    this.dataInputted += 4;
                    this.worldMap.get((int)i).resourceOccurence.add(integer);
                }
                integer = in.readInt();
                this.dataInputted += 4;
                this.worldMap.get(i).setNumContinents(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.worldMap.get(i).setHeight(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.worldMap.get(i).setDistanceBetweenCivs(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.worldMap.get(i).setNumCivs(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.worldMap.get(i).setQuestionMark1(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.worldMap.get(i).setQuestionMark2(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.worldMap.get(i).setWidth(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.worldMap.get(i).setQuestionMark3(integer);
                byte[] oneTwoFour = new byte[124];
                in.read(oneTwoFour, 0, 124);
                this.dataInputted += 124;
                this.worldMap.get(i).setUnknown124(new String(oneTwoFour, this.currentCharset));
                integer = in.readInt();
                this.dataInputted += 4;
                this.worldMap.get(i).setMapSeed(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.worldMap.get(i).setFlags(integer);
                this.worldMap.get(i).extractEnglish();
            }
            return true;
        }
        catch (Exception e) {
            this.logger.error("Error inputting file - WMAP section", e);
            return false;
        }
    }

    private boolean inputTILE(LittleEndianDataInputStream[] ins) {
        try {
            int i;
            ins[0].read(this.inputFour, 0, 4);
            this.dataInputted += 4;
            String temp = new String(this.inputFour, this.currentCharset);
            if (!temp.equals("TILE")) {
                this.logger.error("Could not input file - failed at TILE header.  Header is " + temp + "; bytes inputted: " + this.dataInputted);
                return false;
            }
            Integer integer = ins[0].readInt();
            this.dataInputted += 4;
            this.numTiles = integer;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Num tiles: " + this.numTiles);
            }
            long preAdd = System.nanoTime();
            this.tile = new ArrayList<TILE>();
            for (int i2 = 0; i2 < this.numTiles; ++i2) {
                this.tile.add(new TILE(this));
            }
            long add = System.nanoTime() - preAdd;
            if (this.logger.isInfoEnabled()) {
                this.logger.info("It took " + add / 1000000L + " ms to add all the TILE objects");
            }
            TILEThread[] tileThreads = new TILEThread[numProcs];
            int skipBytesPerCPU = 49;
            if (this.version == civ3Version.CONQUESTS) {
                skipBytesPerCPU = 49;
            } else if (this.version == civ3Version.PTW) {
                skipBytesPerCPU = 33;
            } else if (this.version == civ3Version.VANILLA) {
                skipBytesPerCPU = this.majorVersionNumber == 2 ? 26 : 27;
            }
            for (int i3 = 0; i3 < numProcs; ++i3) {
                if (i3 != 0) {
                    ins[i3].skipBytes(8 + skipBytesPerCPU * i3);
                }
                tileThreads[i3] = new TILEThread(ins[i3], this.tile, this.numTiles, i3, numProcs, this);
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Size of tile array: " + this.tile.size());
            }
            Integer[] inputFromThread = new Integer[numProcs];
            long preCall = System.nanoTime();
            for (i = 0; i < numProcs; ++i) {
                tileThreads[i].start();
            }
            for (i = 0; i < numProcs; ++i) {
                tileThreads[i].join();
            }
            long postCall = System.nanoTime();
            long callTime = postCall - preCall;
            if (this.logger.isInfoEnabled()) {
                this.logger.info("It took " + callTime / 1000000L + " ms to run the " + numProcs + " threads");
            }
            for (int i4 = 0; i4 < numProcs; ++i4) {
                inputFromThread[i4] = tileThreads[i4].getReturnValue();
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("in from thread " + i4 + ": " + inputFromThread[i4]);
                }
                this.dataInputted += inputFromThread[i4].intValue();
            }
        }
        catch (IOException e) {
            this.logger.error("IOException in TILE section - multithreaded", e);
            return false;
        }
        catch (InterruptedException e) {
            this.logger.error("InterruptedException in TILE section - multithreaded", e);
            return false;
        }
        return true;
    }

    private boolean inputCONT(LittleEndianDataInputStream[] ins) {
        try {
            int i;
            this.numContinents = this.inputHeader(ins[0], "CONT");
            for (int i2 = 0; i2 < this.numContinents; ++i2) {
                this.continent.add(new CONT(this));
            }
            CONTThread[] contThreads = new CONTThread[numProcs];
            for (i = 0; i < numProcs; ++i) {
                if (i != 0) {
                    ins[i].skipBytes(8 + 12 * i);
                }
                contThreads[i] = new CONTThread(ins[i], this.continent, this.numContinents, i, numProcs);
                contThreads[i].start();
            }
            for (i = 0; i < numProcs; ++i) {
                contThreads[i].join();
                this.dataInputted += contThreads[i].getReturnValue().intValue();
            }
        }
        catch (HeaderFailedException e) {
            this.logger.error(e.getMessage(), e);
            return false;
        }
        catch (Exception e) {
            this.logger.error("Error inputting file in CONT: ", e);
            return false;
        }
        return true;
    }

    private boolean inputSLOC(LittleEndianDataInputStream[] ins) {
        try {
            int i;
            this.numStartingLocations = this.inputHeader(ins[0], "SLOC");
            for (int i2 = 0; i2 < this.numStartingLocations; ++i2) {
                this.startingLocation.add(new SLOC(this));
            }
            SLOCThread[] startingLocationThreads = new SLOCThread[numProcs];
            for (i = 0; i < numProcs; ++i) {
                if (i != 0) {
                    ins[i].skipBytes(8 + 20 * i);
                }
                startingLocationThreads[i] = new SLOCThread(ins[i], this.startingLocation, this.numStartingLocations, i, numProcs);
                startingLocationThreads[i].start();
            }
            for (i = 0; i < numProcs; ++i) {
                startingLocationThreads[i].join();
                this.dataInputted += startingLocationThreads[i].getReturnValue().intValue();
            }
        }
        catch (HeaderFailedException e) {
            this.logger.error(e.getMessage(), e);
            return false;
        }
        catch (Exception e) {
            this.logger.error("Error inputting file in SLOC: ", e);
            return false;
        }
        return true;
    }

    private boolean inputCITY(LittleEndianDataInputStream in) {
        try {
            this.numCities = this.inputHeader(in, "CITY");
            for (int i = 0; i < this.numCities; ++i) {
                this.city.add(new CITY(this));
                Integer integer = in.readInt();
                this.dataInputted += 4;
                this.inputByte = in.readByte();
                ++this.dataInputted;
                this.city.get(i).setHasWalls(this.inputByte);
                this.inputByte = in.readByte();
                ++this.dataInputted;
                this.city.get(i).setHasPalace(this.inputByte);
                in.read(this.inputTwentyFour, 0, 24);
                this.dataInputted += 24;
                this.city.get(i).setName(new String(this.inputTwentyFour, this.currentCharset));
                integer = in.readInt();
                this.dataInputted += 4;
                this.city.get(i).setOwnerType(integer);
                int numBuildings = in.readInt();
                this.dataInputted += 4;
                for (int j = 0; j < numBuildings; ++j) {
                    integer = in.readInt();
                    this.dataInputted += 4;
                    this.city.get(i).addBuilding(integer);
                }
                this.city.get(i).updateWallStyleBuildingStatus();
                integer = in.readInt();
                this.dataInputted += 4;
                this.city.get(i).setCulture(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.city.get(i).setOwner(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.city.get(i).setSize(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.city.get(i).setX(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.city.get(i).setY(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.city.get(i).setCityLevel(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.city.get(i).setBorderLevel(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.city.get(i).setUseAutoName(integer);
                this.city.get(i).trim();
            }
        }
        catch (Exception e) {
            this.logger.error("Error inputting file in CITY: ", e);
            return false;
        }
        return true;
    }

    private boolean inputUNIT(LittleEndianDataInputStream in) {
        try {
            in.read(this.inputFour, 0, 4);
            this.dataInputted += 4;
            String temp = new String(this.inputFour, this.currentCharset);
            if (!temp.equals("UNIT")) {
                this.logger.error("Could not input file - failed at UNIT header.  Header is " + temp + "; bytes inputted: " + this.dataInputted + ".  Data inputted: " + this.dataInputted);
                return false;
            }
            Integer integer = in.readInt();
            this.dataInputted += 4;
            this.numMapUnits = integer;
            for (int i = 0; i < this.numMapUnits; ++i) {
                this.mapUnit.add(new UNIT(this));
                this.mapUnit.get(i).setIndex(i);
                integer = in.readInt();
                this.dataInputted += 4;
                this.mapUnit.get(i).setDataLength(integer);
                in.read(this.inputThirtyTwo, 0, 32);
                this.dataInputted += 32;
                this.mapUnit.get(i).setName(new String(this.inputThirtyTwo, this.currentCharset));
                integer = in.readInt();
                this.dataInputted += 4;
                this.mapUnit.get(i).setOwnerType(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.mapUnit.get(i).setExperienceLevel(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.mapUnit.get(i).setOwner(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.mapUnit.get(i).setPRTONumber(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.mapUnit.get(i).setAIStrategy(integer);
                int x = in.readInt();
                this.dataInputted += 4;
                this.mapUnit.get(i).setX(x);
                int y = in.readInt();
                this.dataInputted += 4;
                this.mapUnit.get(i).setY(y);
                this.tile.get((int)this.calculateTileIndex((int)x, (int)y)).unitsOnTile.add(i);
                if (this.version.ordinal() < civ3Version.PTW.ordinal()) continue;
                in.read(this.inputFiftySeven, 0, 57);
                this.dataInputted += 57;
                this.mapUnit.get(i).setPTWCustomName(new String(this.inputFiftySeven, this.currentCharset));
                integer = in.readInt();
                this.dataInputted += 4;
                this.mapUnit.get(i).setUseCivilizationKing(integer);
                this.mapUnit.get(i).trim();
            }
            for (UNIT unit : this.mapUnit) {
                unit.setPRTONumber(unit.getPRTONumber());
            }
        }
        catch (Exception e) {
            this.logger.error("Error inputting file in UNIT: ", e);
            return false;
        }
        return true;
    }

    private boolean inputCLNY(LittleEndianDataInputStream in) {
        try {
            in.read(this.inputFour, 0, 4);
            this.dataInputted += 4;
            String temp = new String(this.inputFour, this.currentCharset);
            if (!temp.equals("CLNY")) {
                this.logger.error("Could not input file - failed at CLNY header.  Header is " + temp + "; bytes inputted: " + this.dataInputted);
                return false;
            }
            Integer integer = in.readInt();
            this.dataInputted += 4;
            this.numColonies = integer;
            for (int i = 0; i < this.numColonies; ++i) {
                this.colony.add(new CLNY(this));
                integer = in.readInt();
                this.dataInputted += 4;
                integer = in.readInt();
                this.dataInputted += 4;
                this.colony.get(i).setOwnerType(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.colony.get(i).setOwner(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.colony.get(i).setX(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.colony.get(i).setY(integer);
                if (this.version.ordinal() < civ3Version.PTW.ordinal()) continue;
                integer = in.readInt();
                this.dataInputted += 4;
                this.colony.get(i).setImprovementType(integer);
            }
        }
        catch (Exception e) {
            this.logger.error("Error in CLNY: ", e);
            return false;
        }
        return true;
    }

    private boolean inputWCHR(LittleEndianDataInputStream in) {
        try {
            Integer integer = in.readInt();
            this.dataInputted += 4;
            this.numWorldCharacteristics = integer;
            for (int i = 0; i < this.numWorldCharacteristics; ++i) {
                this.worldCharacteristic.add(new WCHR(this));
                integer = in.readInt();
                this.dataInputted += 4;
                this.worldCharacteristic.get(i).setDataLength(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.worldCharacteristic.get(i).setSelectedClimate(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.worldCharacteristic.get(i).setActualClimate(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.worldCharacteristic.get(i).setSelectedBarbarianActivity(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.worldCharacteristic.get(i).setActualBarbarianActivity(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.worldCharacteristic.get(i).setSelectedLandform(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.worldCharacteristic.get(i).setActualLandform(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.worldCharacteristic.get(i).setSelectedOceanCoverage(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.worldCharacteristic.get(i).setActualOceanCoverage(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.worldCharacteristic.get(i).setSelectedTemperature(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.worldCharacteristic.get(i).setActualTemperature(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.worldCharacteristic.get(i).setSelectedAge(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.worldCharacteristic.get(i).setActualAge(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.worldCharacteristic.get(i).setWorldSize(integer);
            }
        }
        catch (Exception e) {
            this.logger.error("Error in WCHR section: ", e);
            return false;
        }
        return true;
    }

    private boolean inputGAME(LittleEndianDataInputStream in) {
        try {
            Integer integer = in.readInt();
            this.dataInputted += 4;
            this.numScenarioProperties = integer;
            for (int i = 0; i < this.numScenarioProperties; ++i) {
                int j;
                this.scenarioProperty.add(new GAME(this));
                integer = in.readInt();
                this.dataInputted += 4;
                this.scenarioProperty.get(i).setDataLength(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.scenarioProperty.get(i).setUseDefaultRules(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.scenarioProperty.get(i).setDefaultVictoryConditions(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Num playable civs: " + integer);
                }
                this.scenarioProperty.get(i).setNumberOfPlayableCivs(integer);
                for (j = 0; j < this.scenarioProperty.get(i).getNumberOfPlayableCivs(); ++j) {
                    integer = in.readInt();
                    this.dataInputted += 4;
                    this.scenarioProperty.get((int)i).idOfPlayableCivs.add(integer);
                }
                integer = in.readInt();
                this.dataInputted += 4;
                this.scenarioProperty.get(i).setVictoryConditionsAndRules(integer);
                if (this.version.ordinal() >= civ3Version.PTW.ordinal()) {
                    integer = in.readInt();
                    this.dataInputted += 4;
                    this.scenarioProperty.get(i).setPlaceCaptureUnits(integer);
                    integer = in.readInt();
                    this.dataInputted += 4;
                    this.scenarioProperty.get(i).setAutoPlaceKings(integer);
                    integer = in.readInt();
                    this.dataInputted += 4;
                    this.scenarioProperty.get(i).setAutoPlaceVictoryLocations(integer);
                    integer = in.readInt();
                    this.dataInputted += 4;
                    this.scenarioProperty.get(i).setDebugMode(integer);
                    integer = in.readInt();
                    this.dataInputted += 4;
                    this.scenarioProperty.get(i).setUseTimeLimit(integer);
                    integer = in.readInt();
                    this.dataInputted += 4;
                    this.scenarioProperty.get(i).setBaseTimeUnit(integer);
                    integer = in.readInt();
                    this.dataInputted += 4;
                    this.scenarioProperty.get(i).setStartMonth(integer);
                    integer = in.readInt();
                    this.dataInputted += 4;
                    this.scenarioProperty.get(i).setStartWeek(integer);
                    integer = in.readInt();
                    this.dataInputted += 4;
                    this.scenarioProperty.get(i).setStartYear(integer);
                    integer = in.readInt();
                    this.dataInputted += 4;
                    this.scenarioProperty.get(i).setMinuteTimeLimit(integer);
                    integer = in.readInt();
                    this.dataInputted += 4;
                    this.scenarioProperty.get(i).setTurnTimeLimit(integer);
                    for (j = 0; j < 7; ++j) {
                        integer = in.readInt();
                        this.dataInputted += 4;
                        this.scenarioProperty.get(i).setTurnsPerTimescalePart(j, integer);
                    }
                    for (j = 0; j < 7; ++j) {
                        integer = in.readInt();
                        this.dataInputted += 4;
                        this.scenarioProperty.get(i).setTimeUnitsPerTurn(j, integer);
                    }
                    in.read(this.inputFiftyTwoHundred, 0, 5200);
                    this.dataInputted += 5200;
                    this.scenarioProperty.get(i).setScenarioSearchFolders(new String(this.inputFiftyTwoHundred, this.currentCharset));
                    if (this.version == civ3Version.CONQUESTS) {
                        for (j = 0; j < this.scenarioProperty.get(i).getNumberOfPlayableCivs(); ++j) {
                            integer = in.readInt();
                            this.dataInputted += 4;
                            this.scenarioProperty.get((int)i).civPartOfWhichAlliance.add(integer);
                        }
                        integer = in.readInt();
                        this.dataInputted += 4;
                        this.scenarioProperty.get(i).setVictoryPointLimit(integer);
                        integer = in.readInt();
                        this.dataInputted += 4;
                        this.scenarioProperty.get(i).setCityEliminationCount(integer);
                        integer = in.readInt();
                        this.dataInputted += 4;
                        this.scenarioProperty.get(i).setOneCityCultureWinLimit(integer);
                        integer = in.readInt();
                        this.dataInputted += 4;
                        this.scenarioProperty.get(i).setAllCitiesCultureWinLimit(integer);
                        integer = in.readInt();
                        this.dataInputted += 4;
                        this.scenarioProperty.get(i).setDominationTerrainPercent(integer);
                        integer = in.readInt();
                        this.dataInputted += 4;
                        this.scenarioProperty.get(i).setDominationPopulationPercent(integer);
                        integer = in.readInt();
                        this.dataInputted += 4;
                        this.scenarioProperty.get(i).setWonderVP(integer);
                        integer = in.readInt();
                        this.dataInputted += 4;
                        this.scenarioProperty.get(i).setDefeatingOpposingUnitVP(integer);
                        integer = in.readInt();
                        this.dataInputted += 4;
                        this.scenarioProperty.get(i).setAdvancementVP(integer);
                        integer = in.readInt();
                        this.dataInputted += 4;
                        this.scenarioProperty.get(i).setCityConquestVP(integer);
                        integer = in.readInt();
                        this.dataInputted += 4;
                        this.scenarioProperty.get(i).setVictoryPointVP(integer);
                        integer = in.readInt();
                        this.dataInputted += 4;
                        this.scenarioProperty.get(i).setCaptureSpecialUnitVP(integer);
                        integer = in.readInt();
                        this.dataInputted += 4;
                        this.scenarioProperty.get(i).setQuestionMark1(integer);
                        this.inputByte = in.readByte();
                        ++this.dataInputted;
                        this.scenarioProperty.get(i).setQuestionMark2(this.inputByte);
                        in.read(this.inputTwoFiftySix, 0, 256);
                        this.dataInputted += 256;
                        this.scenarioProperty.get(i).setAlliance0(new String(this.inputTwoFiftySix, this.currentCharset));
                        in.read(this.inputTwoFiftySix, 0, 256);
                        this.dataInputted += 256;
                        this.scenarioProperty.get(i).setAlliance1(new String(this.inputTwoFiftySix, this.currentCharset));
                        in.read(this.inputTwoFiftySix, 0, 256);
                        this.dataInputted += 256;
                        this.scenarioProperty.get(i).setAlliance2(new String(this.inputTwoFiftySix, this.currentCharset));
                        in.read(this.inputTwoFiftySix, 0, 256);
                        this.dataInputted += 256;
                        this.scenarioProperty.get(i).setAlliance3(new String(this.inputTwoFiftySix, this.currentCharset));
                        in.read(this.inputTwoFiftySix, 0, 256);
                        this.dataInputted += 256;
                        this.scenarioProperty.get(i).setAlliance4(new String(this.inputTwoFiftySix, this.currentCharset));
                        for (j = 0; j < 5; ++j) {
                            integer = in.readInt();
                            this.dataInputted += 4;
                            this.scenarioProperty.get((int)i).warWith0.add(integer);
                            integer = in.readInt();
                            this.dataInputted += 4;
                            this.scenarioProperty.get((int)i).warWith1.add(integer);
                            integer = in.readInt();
                            this.dataInputted += 4;
                            this.scenarioProperty.get((int)i).warWith2.add(integer);
                            integer = in.readInt();
                            this.dataInputted += 4;
                            this.scenarioProperty.get((int)i).warWith3.add(integer);
                            integer = in.readInt();
                            this.dataInputted += 4;
                            this.scenarioProperty.get((int)i).warWith4.add(integer);
                        }
                        integer = in.readInt();
                        this.dataInputted += 4;
                        this.scenarioProperty.get(i).setAllianceVictoryType(integer);
                        in.read(this.inputTwoSixty, 0, 260);
                        this.dataInputted += 260;
                        this.scenarioProperty.get(i).setPlaugeName(new String(this.inputTwoSixty, this.currentCharset));
                        this.inputByte = in.readByte();
                        ++this.dataInputted;
                        this.scenarioProperty.get(i).setPermitPlagues(this.inputByte);
                        integer = in.readInt();
                        this.dataInputted += 4;
                        this.scenarioProperty.get(i).setPlagueEarliestStart(integer);
                        integer = in.readInt();
                        this.dataInputted += 4;
                        this.scenarioProperty.get(i).setPlagueVariation(integer);
                        integer = in.readInt();
                        this.dataInputted += 4;
                        this.scenarioProperty.get(i).setPlagueDuration(integer);
                        integer = in.readInt();
                        this.dataInputted += 4;
                        this.scenarioProperty.get(i).setPlagueStrength(integer);
                        integer = in.readInt();
                        this.dataInputted += 4;
                        this.scenarioProperty.get(i).setPlagueGracePeriod(integer);
                        integer = in.readInt();
                        this.dataInputted += 4;
                        this.scenarioProperty.get(i).setPlagueMaxOccurance(integer);
                        integer = in.readInt();
                        this.dataInputted += 4;
                        this.scenarioProperty.get(i).setQuestionMark3(integer);
                        in.read(this.inputTwoSixty, 0, 260);
                        this.dataInputted += 260;
                        this.scenarioProperty.get(i).setUnknown(new String(this.inputTwoSixty, this.currentCharset));
                        integer = in.readInt();
                        this.dataInputted += 4;
                        this.scenarioProperty.get(i).setRespawnFlagUnits(integer);
                        this.inputByte = in.readByte();
                        ++this.dataInputted;
                        this.scenarioProperty.get(i).setCaptureAnyFlag(this.inputByte);
                        integer = in.readInt();
                        this.dataInputted += 4;
                        this.scenarioProperty.get(i).setGoldForCapture(integer);
                        this.inputByte = in.readByte();
                        ++this.dataInputted;
                        this.scenarioProperty.get(i).setMapVisible(this.inputByte);
                        this.inputByte = in.readByte();
                        ++this.dataInputted;
                        this.scenarioProperty.get(i).setRetainCulture(this.inputByte);
                        integer = in.readInt();
                        this.dataInputted += 4;
                        this.scenarioProperty.get(i).setQuestionMark4(integer);
                        integer = in.readInt();
                        this.dataInputted += 4;
                        this.scenarioProperty.get(i).setEruptionPeriod(integer);
                        if (this.majorVersionNumber == 12 && this.minorVersionNumber >= 7) {
                            integer = in.readInt();
                            this.dataInputted += 4;
                            this.scenarioProperty.get(i).setMpBaseTime(integer);
                            integer = in.readInt();
                            this.dataInputted += 4;
                            this.scenarioProperty.get(i).setMpCityTime(integer);
                            integer = in.readInt();
                            this.dataInputted += 4;
                            this.scenarioProperty.get(i).setMpUnitTime(integer);
                        } else {
                            this.scenarioProperty.get(i).setMpBaseTime(24);
                            this.scenarioProperty.get(i).setMpCityTime(1);
                            this.scenarioProperty.get(i).setMpUnitTime(3);
                        }
                    } else if (this.version == civ3Version.PTW) {
                        if (this.minorVersionNumber >= 19) {
                            integer = in.readInt();
                            this.dataInputted += 4;
                            this.scenarioProperty.get(i).setRevealMap(integer);
                        }
                        this.scenarioProperty.get(i).convertFromPTWToConquests();
                    }
                } else {
                    this.scenarioProperty.get(i).convertFromVanillaToPTW();
                    this.scenarioProperty.get(i).convertFromPTWToConquests();
                }
                this.scenarioProperty.get(i).trim();
                this.scenarioProperty.get(i).extractEnglish();
            }
        }
        catch (Exception e) {
            this.logger.error("Error in GAME header: ", e);
            return false;
        }
        return true;
    }

    private boolean inputLEAD(LittleEndianDataInputStream in) {
        try {
            this.hasCustomPlayerData = true;
            Integer integer = in.readInt();
            this.dataInputted += 4;
            this.numPlayers = integer;
            for (int i = 0; i < this.numPlayers; ++i) {
                this.player.add(new LEAD(this));
                integer = in.readInt();
                this.dataInputted += 4;
                integer = in.readInt();
                this.dataInputted += 4;
                this.player.get(i).setCustomCivData(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.player.get(i).setHumanPlayer(integer);
                in.read(this.inputThirtyTwo, 0, 32);
                this.dataInputted += 32;
                this.player.get(i).setLeaderName(new String(this.inputThirtyTwo, this.currentCharset));
                integer = in.readInt();
                this.dataInputted += 4;
                this.player.get(i).setQuestionMark1(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.player.get(i).setQuestionMark2(integer);
                int numStartUnits = in.readInt();
                this.dataInputted += 4;
                for (int j = 0; j < numStartUnits; ++j) {
                    int unitCount = in.readInt();
                    this.dataInputted += 4;
                    int unitType = in.readInt();
                    this.dataInputted += 4;
                    if (this.hasCustomRules) {
                        this.player.get(i).addStartingUnitType(this.unit.get(unitType), (Integer)unitCount);
                        continue;
                    }
                    this.player.get(i).addStartingUnitType(unitType, (Integer)unitCount);
                }
                integer = in.readInt();
                this.dataInputted += 4;
                this.player.get(i).setGenderOfLeaderName(integer);
                int numStartTechs = in.readInt();
                this.dataInputted += 4;
                for (int j = 0; j < numStartTechs; ++j) {
                    integer = in.readInt();
                    this.dataInputted += 4;
                    this.player.get((int)i).startingTechnologyInt.add(integer);
                }
                integer = in.readInt();
                this.dataInputted += 4;
                this.player.get(i).setDifficulty(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.player.get(i).setInitialEra(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.player.get(i).setStartCash(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.player.get(i).setGovernment(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.player.get(i).setCiv(integer);
                integer = in.readInt();
                this.dataInputted += 4;
                this.player.get(i).setColor(integer);
                if (this.version.ordinal() >= civ3Version.PTW.ordinal()) {
                    integer = in.readInt();
                    this.dataInputted += 4;
                    this.player.get(i).setSkipFirstTurn(integer);
                    integer = in.readInt();
                    this.dataInputted += 4;
                    this.player.get(i).setQuestionMark3(integer);
                    this.inputByte = in.readByte();
                    ++this.dataInputted;
                    this.player.get(i).setStartEmbassies(this.inputByte);
                } else if (this.convertToConquests == 1 && this.player.get(i).getDifficulty() >= this.difficulties.size()) {
                    this.player.get(i).setDifficulty(-2);
                }
                this.player.get(i).trim();
            }
            for (LEAD leader : this.player) {
                leader.setStartingTechLinks();
            }
        }
        catch (Exception e) {
            this.logger.error("Error in LEAD header: ", e);
            return false;
        }
        return true;
    }

    public void deletePlayer(int playerId) {
        this.deletePlayer(playerId, true);
    }

    public void deletePlayer(int playerId, boolean recalcTileOwners) {
        UNIT unitOnMap;
        int i;
        for (i = 0; i < this.startingLocation.size(); ++i) {
            SLOC sloc = this.startingLocation.get(i);
            if (sloc.getOwnerType() == 3 && sloc.getOwner() == playerId) {
                this.startingLocation.remove(i);
                --i;
                continue;
            }
            if (sloc.getOwnerType() != 3 || sloc.getOwner() <= playerId) continue;
            sloc.setOwner(sloc.getOwner() - 1);
        }
        for (i = 0; i < this.city.size(); ++i) {
            CITY theCity = this.city.get(i);
            if (theCity.getOwnerType() == 3 && theCity.getOwner() == playerId) {
                this.deleteCity(i, false);
                --i;
                continue;
            }
            if (theCity.getOwnerType() != 3 || theCity.getOwner() <= playerId) continue;
            theCity.setOwner(theCity.getOwner() - 1);
        }
        for (i = 0; i < this.mapUnit.size(); ++i) {
            unitOnMap = this.mapUnit.get(i);
            if (unitOnMap.getOwnerType() == 3 && unitOnMap.getOwner() == playerId) {
                this.mapUnit.remove(i);
                --i;
                continue;
            }
            if (unitOnMap.getOwnerType() != 3 || unitOnMap.getOwner() <= playerId) continue;
            unitOnMap.setOwner(unitOnMap.getOwner() - 1);
        }
        for (i = 0; i < this.tile.size(); ++i) {
            this.tile.get((int)i).unitsOnTile.clear();
        }
        for (i = 0; i < this.mapUnit.size(); ++i) {
            unitOnMap = this.mapUnit.get(i);
            this.tile.get((int)this.calculateTileIndex((int)unitOnMap.getX(), (int)unitOnMap.getY())).unitsOnTile.add(i);
        }
        for (i = 0; i < this.tile.size(); ++i) {
            this.tile.get(i).calculateUnitWithBestDefence();
        }
        for (i = 0; i < this.colony.size(); ++i) {
            CLNY theColony = this.colony.get(i);
            if (theColony.getOwnerType() == 3 && theColony.getOwner() == playerId) {
                this.colony.remove(i);
                --i;
                continue;
            }
            if (theColony.getOwnerType() != 3 || theColony.getOwner() <= playerId) continue;
            theColony.setOwner(theColony.getOwner() - 1);
        }
        this.player.remove(playerId);
        if (recalcTileOwners) {
            this.calculateTileOwners();
        }
    }

    public void deleteCity(int cityIndex) {
        this.deleteCity(cityIndex, true);
    }

    public void deleteCity(int cityIndex, boolean recalcTileOwners) {
        for (int t = 0; t < this.tile.size(); ++t) {
            TILE theTile = this.tile.get(t);
            int uIndex = 0;
            int numIterations = theTile.citiesWithInfluence.size();
            for (int u = 0; u < numIterations; ++u) {
                if (theTile.citiesWithInfluence.get(uIndex) > cityIndex) {
                    theTile.citiesWithInfluence.set(uIndex, theTile.citiesWithInfluence.get(uIndex) - 1);
                } else if (theTile.citiesWithInfluence.get(uIndex) == cityIndex) {
                    theTile.citiesWithInfluence.remove(uIndex);
                    --uIndex;
                }
                ++uIndex;
            }
        }
        short s = -1;
        this.city.remove(cityIndex);
        for (int i = 0; i < this.tile.size(); ++i) {
            if (this.tile.get(i).getCity() == cityIndex) {
                this.tile.get(i).setCity(s);
            }
            if (this.tile.get(i).getCity() <= cityIndex) continue;
            this.tile.get(i).setCity((short)(this.tile.get(i).getCity() - 1));
        }
        if (recalcTileOwners) {
            try {
                this.calculateTileOwners();
            }
            catch (IndexOutOfBoundsException e) {
                this.logger.error("Exception while deleting city!", e);
            }
        }
    }

    public boolean hasCustomRules() {
        return this.hasCustomRules;
    }

    public void setCustomRules(boolean customRules) {
        this.hasCustomRules = customRules;
    }

    public boolean hasCustomMap() {
        return this.hasCustomMap;
    }

    public void setCustomMap(boolean customMap) {
        this.hasCustomMap = customMap;
    }

    public boolean hasCustomPlayerData() {
        return this.hasCustomPlayerData;
    }

    public void setCustomPlayerData(boolean customPlayerData) {
        this.hasCustomPlayerData = customPlayerData;
    }

    public int findInstance(Section section, String name) {
        List list = this.getSection(section);
        for (int i = 0; i < this.numSection(section); ++i) {
            BIQSection instance = (BIQSection)list.get(i);
            if (!instance.getProperty("Name").equals(name)) continue;
            return i;
        }
        return -1;
    }

    public int findUnit(String name) {
        for (int i = 0; i < this.numUnits; ++i) {
            if (!this.unit.get(i).getName().equals(name)) continue;
            return i;
        }
        return -1;
    }

    public int findPlayer(int player) {
        for (int i = 0; i < this.numPlayers; ++i) {
            if (this.player.get(i).getCiv() != player) continue;
            return i;
        }
        return -1;
    }

    public boolean outputBIQ(File file) {
        try {
            LittleEndianDataOutputStream out = new LittleEndianDataOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
            boolean result = this.outputBIQ(out, false);
            out.close();
            return result;
        }
        catch (IOException ex) {
            this.logger.error("Exception opening file", ex);
            return false;
        }
    }

    public boolean outputBIQ(LittleEndianDataOutputStream out, boolean isEmbeddedInSAV) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("in outputBIQ");
        }
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("about to export BIQ file");
            }
            for (int i = 0; i < this.terrain.size(); ++i) {
                this.terrain.get(i).storeGoods();
            }
            if (isEmbeddedInSAV) {
                out.writeBytes("BICQ");
            } else {
                out.writeBytes("BICX");
            }
            out.writeBytes("VER#");
            this.writeInt(1, out);
            this.writeInt(720, out);
            this.writeInt(0, out);
            this.writeInt(0, out);
            this.majorVersionNumber = 12;
            this.minorVersionNumber = 8;
            this.version = civ3Version.CONQUESTS;
            this.writeInt(this.majorVersionNumber, out);
            this.writeInt(this.minorVersionNumber, out);
            this.writeString(this.description, 640, out);
            this.writeString(this.title, 64, out);
            if (this.hasCustomRules) {
                this.outputBLDG(out);
                this.outputCTZN(out);
                this.outputCULT(out);
                this.outputDIFF(out);
                this.outputERAS(out);
                this.outputESPN(out);
                this.outputEXPR(out);
                if (isEmbeddedInSAV) {
                    this.outputFLAV(out);
                }
                this.outputGOOD(out);
                this.outputGOVT(out);
                this.outputRULE(out);
                this.outputPRTO(out);
                this.outputRACE(out);
                this.outputTECH(out);
                this.outputTFRM(out);
                out.flush();
                this.outputTERR(out);
                this.outputWSIZ(out);
                if (!isEmbeddedInSAV) {
                    this.outputFLAV(out);
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Finished exporting FLAV section");
                }
            }
            if (this.hasCustomMap) {
                this.outputWCHR(out);
                this.outputWMAP(out);
                this.outputTILE(out);
                this.outputCONT(out);
                this.outputSLOC(out);
                this.outputCITY(out);
                this.outputUNIT(out);
                this.outputCLNY(out);
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("About to write GAME data");
            }
            this.outputGAME(out);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Finished exporting GAME section");
            }
            if (this.hasCustomPlayerData) {
                this.outputLEAD(out);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Finished exporting LEAD section");
                }
            }
        }
        catch (Exception e) {
            this.logger.error("Exception while outputting file", e);
            return false;
        }
        return true;
    }

    public void writeInt(int number, LittleEndianDataOutputStream out) {
        try {
            out.writeInt(number);
        }
        catch (Exception e) {
            this.logger.error("Error while writing an integer: " + e);
        }
    }

    public void writeShort(short number, LittleEndianDataOutputStream out) {
        try {
            out.writeShort(number);
        }
        catch (Exception e) {
            this.logger.error(e);
        }
    }

    public void writeString(String string, int length, LittleEndianDataOutputStream out) {
        if (string == null) {
            string = "";
        }
        int len = string.length();
        int numExtraBytes = length - len;
        try {
            out.writeBytes(string);
            for (int i = 0; i < numExtraBytes; ++i) {
                out.writeByte(0);
            }
        }
        catch (Exception e) {
            this.logger.error("Error while writing a string: " + e);
        }
    }

    private int inputHeader(LittleEndianDataInputStream in, String toMatch) throws HeaderFailedException {
        try {
            in.read(this.inputFour, 0, 4);
            this.dataInputted += 4;
            String temp = new String(this.inputFour, this.currentCharset);
            if (!temp.equals(toMatch)) {
                String f = "";
                for (int i = 0; i < 4; ++i) {
                    f = f + Integer.toHexString(Character.getNumericValue(temp.charAt(i))).substring(6);
                }
                String e = "Could not input file - failed at " + toMatch + " header.  Header is " + temp + "; bytes inputted: " + this.dataInputted + ", or " + f + " in hex.  Data inputted: " + this.dataInputted;
                this.logger.error(e);
                throw new HeaderFailedException(e);
            }
            Integer integer = in.readInt();
            this.dataInputted += 4;
            return integer;
        }
        catch (IOException e) {
            throw new HeaderFailedException("IOException in header for " + toMatch, e);
        }
    }

    public boolean inputBIQFromScenario(File file) {
        long fileLength = file.length();
        this.dataInputted = 0;
        try {
            String temp;
            LittleEndianDataInputStream inFile = new LittleEndianDataInputStream(new BufferedInputStream(new FileInputStream(file)));
            byte[] buffer = new byte[(int)file.length()];
            inFile.readFully(buffer);
            inFile.close();
            LittleEndianDataInputStream in = new LittleEndianDataInputStream(new ByteArrayInputStream(buffer));
            int bytesInput = 0;
            boolean bicqFound = false;
            boolean loopForI = false;
            byte[] input = new byte[4];
            while (!bicqFound) {
                in.read(input, 0, 1);
                ++bytesInput;
                temp = new String(input, this.currentCharset);
                if (temp.charAt(0) == 'B') {
                    in.read(input, 1, 1);
                    ++bytesInput;
                    temp = new String(input, this.currentCharset);
                    loopForI = true;
                    while (loopForI) {
                        in.read(input, 2, 1);
                        ++bytesInput;
                        temp = new String(input, this.currentCharset);
                        if (temp.charAt(1) == 'I') {
                            if (temp.charAt(2) == 'C') {
                                in.read(input, 3, 1);
                                ++bytesInput;
                                temp = new String(input, this.currentCharset);
                                if (temp.charAt(3) == 'Q') {
                                    bicqFound = true;
                                } else {
                                    input[0] = 0;
                                    input[1] = 0;
                                    input[2] = 0;
                                    input[3] = 0;
                                }
                            } else {
                                input[0] = 0;
                                input[1] = 0;
                                input[2] = 0;
                            }
                            loopForI = false;
                            continue;
                        }
                        if (temp.charAt(1) == 'B') {
                            input[0] = input[1];
                            input[1] = 0;
                            continue;
                        }
                        input[0] = 0;
                        input[1] = 0;
                        loopForI = false;
                    }
                    continue;
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Not B: " + temp);
                }
                if (bytesInput <= 1000) continue;
                this.logger.info("Detected compressed file");
                String[] decomQuery = new String[]{"java", "-jar", "./bin/BIQDecompressor.jar", file.getCanonicalPath(), "._tmp.biq"};
                Process dcp = Runtime.getRuntime().exec(decomQuery);
                dcp.waitFor();
                return this.inputBIQFromScenario(new File("._tmp.biq"));
            }
            this.version = civ3Version.CONQUESTS;
            in.read(this.inputFour, 0, 4);
            this.dataInputted += 4;
            temp = new String(this.inputFour, this.currentCharset);
            Integer integer = in.readInt();
            this.dataInputted += 4;
            integer = in.readInt();
            this.dataInputted += 4;
            integer = in.readInt();
            this.dataInputted += 4;
            integer = in.readInt();
            this.dataInputted += 4;
            integer = in.readInt();
            this.dataInputted += 4;
            this.majorVersionNumber = integer;
            integer = in.readInt();
            this.dataInputted += 4;
            this.minorVersionNumber = integer;
            in.read(this.inputSixForty, 0, 640);
            this.dataInputted += 640;
            this.description = new String(this.inputSixForty, this.currentCharset);
            in.read(this.inputSixtyFour, 0, 64);
            this.dataInputted += 64;
            this.title = new String(this.inputSixtyFour, this.currentCharset);
            in.read(this.inputFour, 0, 4);
            this.dataInputted += 4;
            temp = new String(this.inputFour, this.currentCharset);
            if (temp.equals("BLDG")) {
                this.hasCustomRules = true;
                this.inputBLDG(in);
                this.inputCTZN(in);
                this.inputCULT(in);
                this.inputDIFF(in);
                this.inputERAS(in);
                this.inputESPN(in);
                this.inputEXPR(in);
                this.inputFLAV(in);
                this.inputGOOD(in);
                this.inputGOVT(in);
                this.inputRULE(in);
                this.inputPRTO(in);
                this.inputRACE(in);
                this.inputTECH(in);
                this.inputTFRM(in);
                this.inputTERR(in);
                this.inputWSIZ(in);
                if (!this.performRulePostProcessingFromScenario()) {
                    return false;
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("at world map/game section; " + this.dataInputted + " bytes inputted.");
                }
                in.read(this.inputFour, 0, 4);
                this.dataInputted += 4;
                temp = new String(this.inputFour, this.currentCharset);
            } else {
                this.hasCustomRules = false;
            }
            if (temp.equals("WCHR")) {
                this.hasCustomMap = true;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("custom map");
                }
                this.inputWCHR(in);
                this.inputWMAP(in);
                this.inputTILE(new LittleEndianDataInputStream[]{in});
                this.inputCONT(new LittleEndianDataInputStream[]{in});
                this.inputSLOC(new LittleEndianDataInputStream[]{in});
                this.inputCITY(in);
                this.inputUNIT(in);
                this.inputCLNY(in);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("finished map data");
                }
                in.read(this.inputFour, 0, 4);
                this.dataInputted += 4;
                temp = new String(this.inputFour, this.currentCharset);
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Should be finished now");
            }
            if (!temp.equals("GAME")) {
                JOptionPane.showMessageDialog(null, "Could not input file - failed at GAME header.", "File input failed.", 0);
                return false;
            }
            this.inputGAME(in);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(fileLength);
                this.logger.debug(this.dataInputted);
            }
            if (fileLength == (long)this.dataInputted) {
                return true;
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("finished custom player data");
            }
            if (this.logger.isInfoEnabled()) {
                this.logger.info("final input:  " + this.dataInputted);
            }
            if (fileLength == (long)this.dataInputted) {
                return true;
            }
            return true;
        }
        catch (EOFException e) {
            this.logger.error("file size: " + fileLength);
            this.logger.error("bytes read at time of crash: " + this.dataInputted);
            this.logger.error(e.getCause());
            this.logger.error(e.toString());
            this.logger.error(e.getClass());
            this.logger.error(e);
            return false;
        }
        catch (Exception e) {
            this.logger.error("ERROR:  ", e);
            return false;
        }
    }

    private boolean performRulePostProcessingFromScenario() throws HeadlessException {
        try {
            int i;
            for (i = 0; i < this.numBuildings; ++i) {
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace("numFlavors: " + this.numFlavors);
                }
                this.buildings.get(i).extractEnglish(this.numFlavors);
            }
            for (i = 0; i < this.numTechnologies; ++i) {
                this.technology.get(i).extractEnglish(this.numFlavors);
            }
            for (i = 0; i < this.numCivilizations; ++i) {
                this.civilization.get(i).extractEnglish(this.numFlavors);
            }
            for (i = 0; i < this.numTerrains; ++i) {
                this.terrain.get(i).simplifyGoods();
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Could not input file - error extracting binary data on building/technology/civilization headers.", "File input failed.", 0);
            this.logger.error("Error on extract Englishes", e);
            return false;
        }
        return true;
    }

    private void outputBLDG(LittleEndianDataOutputStream out) {
        try {
            out.writeBytes("BLDG");
            this.writeInt(this.buildings.size(), out);
            for (int i = 0; i < this.buildings.size(); ++i) {
                this.buildings.get(i).createBinary();
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Building " + this.buildings.get(i).getName() + " data length : " + this.buildings.get(i).getDataLength());
                }
                this.writeInt(this.buildings.get(i).getDataLength(), out);
                this.writeString(this.buildings.get(i).getDescription(), 64, out);
                this.writeString(this.buildings.get(i).getName(), 32, out);
                this.writeString(this.buildings.get(i).getCivilopediaEntry(), 32, out);
                this.writeInt(this.buildings.get(i).getDoublesHappiness(), out);
                this.writeInt(this.buildings.get(i).getGainInEveryCity(), out);
                this.writeInt(this.buildings.get(i).getGainOnContinent(), out);
                this.writeInt(this.buildings.get(i).getReqImprovement(), out);
                this.writeInt(this.buildings.get(i).getCost(), out);
                this.writeInt(this.buildings.get(i).getCulture(), out);
                this.writeInt(this.buildings.get(i).getBombardDefence(), out);
                this.writeInt(this.buildings.get(i).getNavalBombardDefence(), out);
                this.writeInt(this.buildings.get(i).getDefenceBonus(), out);
                this.writeInt(this.buildings.get(i).getNavalDefenceBonus(), out);
                this.writeInt(this.buildings.get(i).getMaintenanceCost(), out);
                this.writeInt(this.buildings.get(i).getHappyAll(), out);
                this.writeInt(this.buildings.get(i).getHappy(), out);
                this.writeInt(this.buildings.get(i).getUnhappyAll(), out);
                this.writeInt(this.buildings.get(i).getUnhappy(), out);
                this.writeInt(this.buildings.get(i).getNumReqBuildings(), out);
                this.writeInt(this.buildings.get(i).getAirPower(), out);
                this.writeInt(this.buildings.get(i).getNavalPower(), out);
                this.writeInt(this.buildings.get(i).getPollution(), out);
                this.writeInt(this.buildings.get(i).getProduction(), out);
                this.writeInt(this.buildings.get(i).getReqGovernment(), out);
                this.writeInt(this.buildings.get(i).getSpaceshipPart(), out);
                this.writeInt(this.buildings.get(i).getReqAdvance(), out);
                this.writeInt(this.buildings.get(i).getObsoleteBy(), out);
                this.writeInt(this.buildings.get(i).getReqResource1(), out);
                this.writeInt(this.buildings.get(i).getReqResource2(), out);
                this.writeInt(this.buildings.get(i).getImprovements(), out);
                this.writeInt(this.buildings.get(i).getOtherChar(), out);
                this.writeInt(this.buildings.get(i).getSmallWonderCharacteristics(), out);
                this.writeInt(this.buildings.get(i).getWonderCharacteristics(), out);
                this.writeInt(this.buildings.get(i).getArmiesRequired(), out);
                this.writeInt(this.buildings.get(i).getFlavors(), out);
                this.writeInt(this.buildings.get(i).getQuestionMark(), out);
                this.writeInt(this.buildings.get(i).getUnitProduced(), out);
                this.writeInt(this.buildings.get(i).getUnitFrequency(), out);
            }
        }
        catch (IOException e) {
            this.logger.error("IOException", e);
        }
    }

    private void outputCTZN(LittleEndianDataOutputStream out) {
        try {
            out.writeBytes("CTZN");
            this.writeInt(this.citizens.size(), out);
            for (int i = 0; i < this.citizens.size(); ++i) {
                this.writeInt(this.citizens.get(i).getDataLength(), out);
                this.writeInt(this.citizens.get(i).getDefaultCitizen(), out);
                this.writeString(this.citizens.get(i).getName(), 32, out);
                this.writeString(this.citizens.get(i).getCivilopediaEntry(), 32, out);
                this.writeString(this.citizens.get(i).getPluralName(), 32, out);
                this.writeInt(this.citizens.get(i).getPrerequisite(), out);
                this.writeInt(this.citizens.get(i).getLuxuries(), out);
                this.writeInt(this.citizens.get(i).getResearch(), out);
                this.writeInt(this.citizens.get(i).getTaxes(), out);
                this.writeInt(this.citizens.get(i).getCorruption(), out);
                this.writeInt(this.citizens.get(i).getConstruction(), out);
            }
        }
        catch (IOException e) {
            this.logger.error("IOException", e);
        }
    }

    private void outputCULT(LittleEndianDataOutputStream out) {
        try {
            out.writeBytes("CULT");
            this.writeInt(this.culture.size(), out);
            for (int i = 0; i < this.culture.size(); ++i) {
                this.writeInt(this.culture.get(i).getDataLength(), out);
                this.writeString(this.culture.get(i).getName(), 64, out);
                this.writeInt(this.culture.get(i).getPropagandaSuccess(), out);
                this.writeInt(this.culture.get(i).getCultRatioPercent(), out);
                this.writeInt(this.culture.get(i).getRatioDenominator(), out);
                this.writeInt(this.culture.get(i).getRatioNumerator(), out);
                this.writeInt(this.culture.get(i).getInitResistanceChance(), out);
                this.writeInt(this.culture.get(i).getContinuedResistanceChance(), out);
            }
        }
        catch (IOException e) {
            this.logger.error("IOException", e);
        }
    }

    private void outputDIFF(LittleEndianDataOutputStream out) {
        try {
            out.writeBytes("DIFF");
            this.writeInt(this.difficulties.size(), out);
            for (int i = 0; i < this.difficulties.size(); ++i) {
                this.writeInt(this.difficulties.get(i).getDataLength(), out);
                this.writeString(this.difficulties.get(i).getName(), 64, out);
                this.writeInt(this.difficulties.get(i).getContentCitizens(), out);
                this.writeInt(this.difficulties.get(i).getMaxGovtTransition(), out);
                this.writeInt(this.difficulties.get(i).getAIDefenceStart(), out);
                this.writeInt(this.difficulties.get(i).getAIOffenceStart(), out);
                this.writeInt(this.difficulties.get(i).getExtraStart1(), out);
                this.writeInt(this.difficulties.get(i).getExtraStart2(), out);
                this.writeInt(this.difficulties.get(i).getAdditionalFreeSupport(), out);
                this.writeInt(this.difficulties.get(i).getBonusPerCity(), out);
                this.writeInt(this.difficulties.get(i).getAttackBarbariansBonus(), out);
                this.writeInt(this.difficulties.get(i).getCostFactor(), out);
                this.writeInt(this.difficulties.get(i).getPercentOptimal(), out);
                this.writeInt(this.difficulties.get(i).getAIAITrade(), out);
                this.writeInt(this.difficulties.get(i).getCorruptionPercent(), out);
                this.writeInt(this.difficulties.get(i).getMilitaryLaw(), out);
            }
        }
        catch (IOException e) {
            this.logger.error("IOException", e);
        }
    }

    private void outputERAS(LittleEndianDataOutputStream out) {
        try {
            out.writeBytes("ERAS");
            this.writeInt(this.eras.size(), out);
            for (int i = 0; i < this.eras.size(); ++i) {
                this.writeInt(this.eras.get(i).getDataLength(), out);
                this.writeString(this.eras.get(i).getName(), 64, out);
                this.writeString(this.eras.get(i).getCivilopediaEntry(), 32, out);
                this.writeString(this.eras.get(i).getResearcher1(), 32, out);
                this.writeString(this.eras.get(i).getResearcher2(), 32, out);
                this.writeString(this.eras.get(i).getResearcher3(), 32, out);
                this.writeString(this.eras.get(i).getResearcher4(), 32, out);
                this.writeString(this.eras.get(i).getResearcher5(), 32, out);
                this.writeInt(this.eras.get(i).getUsedResearcherNames(), out);
                this.writeInt(this.eras.get(i).getQuestionMark(), out);
            }
        }
        catch (IOException e) {
            this.logger.error("IOException", e);
        }
    }

    private void outputESPN(LittleEndianDataOutputStream out) {
        try {
            out.writeBytes("ESPN");
            this.writeInt(this.espionage.size(), out);
            for (int i = 0; i < this.espionage.size(); ++i) {
                this.writeInt(this.espionage.get(i).getDataLength(), out);
                this.writeString(this.espionage.get(i).getDescription(), 128, out);
                this.writeString(this.espionage.get(i).getName(), 64, out);
                this.writeString(this.espionage.get(i).getCivilopediaEntry(), 32, out);
                this.writeInt(this.espionage.get(i).getMissionPerformedBy(), out);
                this.writeInt(this.espionage.get(i).getBaseCost(), out);
            }
        }
        catch (IOException e) {
            this.logger.error("IOException", e);
        }
    }

    private void outputEXPR(LittleEndianDataOutputStream out) {
        try {
            out.writeBytes("EXPR");
            this.writeInt(this.experience.size(), out);
            for (int i = 0; i < this.experience.size(); ++i) {
                this.writeInt(this.experience.get(i).getDataLength(), out);
                this.writeString(this.experience.get(i).getName(), 32, out);
                this.writeInt(this.experience.get(i).getBaseHitPoints(), out);
                this.writeInt(this.experience.get(i).getRetreatBonus(), out);
            }
        }
        catch (IOException e) {
            this.logger.error("IOException", e);
        }
    }

    private void outputGOOD(LittleEndianDataOutputStream out) {
        try {
            out.writeBytes("GOOD");
            this.writeInt(this.resource.size(), out);
            for (int i = 0; i < this.resource.size(); ++i) {
                this.writeInt(this.resource.get(i).getDataLength(), out);
                this.writeString(this.resource.get(i).getName(), 24, out);
                this.writeString(this.resource.get(i).getCivilopediaEntry(), 32, out);
                this.writeInt(this.resource.get(i).getType(), out);
                this.writeInt(this.resource.get(i).getAppearanceRatio(), out);
                this.writeInt(this.resource.get(i).getDisapperanceProbability(), out);
                this.writeInt(this.resource.get(i).getIcon(), out);
                this.writeInt(this.resource.get(i).getPrerequisite(), out);
                this.writeInt(this.resource.get(i).getFoodBonus(), out);
                this.writeInt(this.resource.get(i).getShieldsBonus(), out);
                this.writeInt(this.resource.get(i).getCommerceBonus(), out);
            }
        }
        catch (IOException e) {
            this.logger.error("IOException", e);
        }
    }

    private void outputGOVT(LittleEndianDataOutputStream out) {
        try {
            out.writeBytes("GOVT");
            this.writeInt(this.government.size(), out);
            for (int i = 0; i < this.government.size(); ++i) {
                this.writeInt(this.government.get(i).getDataLength(), out);
                this.writeInt(this.government.get(i).getDefaultType(), out);
                this.writeInt(this.government.get(i).getTransitionType(), out);
                this.writeInt(this.government.get(i).getRequiresMaintenance(), out);
                this.writeInt(this.government.get(i).getQuestionMarkOne(), out);
                this.writeInt(this.government.get(i).getTilePenalty(), out);
                this.writeInt(this.government.get(i).getCommerceBonus(), out);
                this.writeString(this.government.get(i).getName(), 64, out);
                this.writeString(this.government.get(i).getCivilopediaEntry(), 32, out);
                this.writeString(this.government.get(i).getMaleRulerTitle1(), 32, out);
                this.writeString(this.government.get(i).getFemaleRulerTitle1(), 32, out);
                this.writeString(this.government.get(i).getMaleRulerTitle2(), 32, out);
                this.writeString(this.government.get(i).getFemaleRulerTitle2(), 32, out);
                this.writeString(this.government.get(i).getMaleRulerTitle3(), 32, out);
                this.writeString(this.government.get(i).getFemaleRulerTitle3(), 32, out);
                this.writeString(this.government.get(i).getMaleRulerTitle4(), 32, out);
                this.writeString(this.government.get(i).getFemaleRulerTitle4(), 32, out);
                this.writeInt(this.government.get(i).getCorruption(), out);
                this.writeInt(this.government.get(i).getImmuneTo(), out);
                this.writeInt(this.government.get(i).getDiplomatLevel(), out);
                this.writeInt(this.government.get(i).getSpyLevel(), out);
                this.writeInt(this.government.get(i).getNumberOfGovernments(), out);
                for (int j = 0; j < this.government.get(i).getNumberOfGovernments(); ++j) {
                    this.writeInt(this.government.get((int)i).relations.get(j).getCanBribe(), out);
                    this.writeInt(this.government.get((int)i).relations.get(j).getBriberyModifier(), out);
                    this.writeInt(this.government.get((int)i).relations.get(j).getResistanceModifier(), out);
                }
                this.writeInt(this.government.get(i).getHurrying(), out);
                this.writeInt(this.government.get(i).getAssimilationChance(), out);
                this.writeInt(this.government.get(i).getDraftLimit(), out);
                this.writeInt(this.government.get(i).getMilitaryPoliceLimit(), out);
                this.writeInt(this.government.get(i).getRulerTitlePairsUsed(), out);
                this.writeInt(this.government.get(i).getPrerequisiteTechnology(), out);
                this.writeInt(this.government.get(i).getScienceCap(), out);
                this.writeInt(this.government.get(i).getWorkerRate(), out);
                this.writeInt(this.government.get(i).getQuestionMarkTwo(), out);
                this.writeInt(this.government.get(i).getQuestionMarkThree(), out);
                this.writeInt(this.government.get(i).getQuestionMarkFour(), out);
                this.writeInt(this.government.get(i).getFreeUnits(), out);
                this.writeInt(this.government.get(i).getFreeUnitsPerTown(), out);
                this.writeInt(this.government.get(i).getFreeUnitsPerCity(), out);
                this.writeInt(this.government.get(i).getFreeUnitsPerMetropolis(), out);
                this.writeInt(this.government.get(i).getCostPerUnit(), out);
                this.writeInt(this.government.get(i).getWarWeariness(), out);
                this.writeInt(this.government.get(i).getXenophobic(), out);
                this.writeInt(this.government.get(i).getForceResettlement(), out);
            }
        }
        catch (IOException e) {
            this.logger.error("IOException", e);
        }
    }

    private void outputRULE(LittleEndianDataOutputStream out) {
        try {
            out.writeBytes("RULE");
            this.writeInt(this.rule.size(), out);
            for (int i = 0; i < this.rule.size(); ++i) {
                int j;
                this.writeInt(this.rule.get(i).getDataLength(), out);
                this.writeString(this.rule.get(i).getTownName(), 32, out);
                this.writeString(this.rule.get(i).getCityName(), 32, out);
                this.writeString(this.rule.get(i).getMetropolisName(), 32, out);
                this.writeInt(this.rule.get(i).getNumSpaceshipParts(), out);
                for (j = 0; j < this.rule.get(i).getNumSpaceshipParts(); ++j) {
                    this.writeInt(this.rule.get(i).getNumberOfSpaceshipPartsRequired(j), out);
                }
                this.writeInt(this.rule.get(i).getAdvancedBarbarian(), out);
                this.writeInt(this.rule.get(i).getBasicBarbarian(), out);
                this.writeInt(this.rule.get(i).getBarbarianSeaUnit(), out);
                this.writeInt(this.rule.get(i).getCitiesForArmy(), out);
                this.writeInt(this.rule.get(i).getChanceOfRioting(), out);
                this.writeInt(this.rule.get(i).getDraftTurnPenalty(), out);
                this.writeInt(this.rule.get(i).getShieldCostInGold(), out);
                this.writeInt(this.rule.get(i).getFortressDefenceBonus(), out);
                this.writeInt(this.rule.get(i).getCitizensAffectedByHappyFace(), out);
                this.writeInt(this.rule.get(i).getQuestionMark1(), out);
                this.writeInt(this.rule.get(i).getQuestionMark2(), out);
                this.writeInt(this.rule.get(i).getForestValueInShields(), out);
                this.writeInt(this.rule.get(i).getShieldValueInGold(), out);
                this.writeInt(this.rule.get(i).getCitizenValueInShields(), out);
                this.writeInt(this.rule.get(i).getDefaultDifficultyLevel(), out);
                this.writeInt(this.rule.get(i).getBattleCreatedUnit(), out);
                this.writeInt(this.rule.get(i).getBuildArmyUnit(), out);
                this.writeInt(this.rule.get(i).getBuildingDefensiveBonus(), out);
                this.writeInt(this.rule.get(i).getCitizenDefensiveBonus(), out);
                this.writeInt(this.rule.get(i).getDefaultMoneyResource(), out);
                this.writeInt(this.rule.get(i).getChanceToInterceptAirMissions(), out);
                this.writeInt(this.rule.get(i).getChanceToInterceptStealthMissions(), out);
                this.writeInt(this.rule.get(i).getStartingTreasury(), out);
                this.writeInt(this.rule.get(i).getQuestionMark3(), out);
                this.writeInt(this.rule.get(i).getFoodConsumptionPerCitizen(), out);
                this.writeInt(this.rule.get(i).getRiverDefensiveBonus(), out);
                this.writeInt(this.rule.get(i).getTurnPenaltyForWhip(), out);
                this.writeInt(this.rule.get(i).getScout(), out);
                this.writeInt(this.rule.get(i).getSlave(), out);
                this.writeInt(this.rule.get(i).getRoadMovementRate(), out);
                this.writeInt(this.rule.get(i).getStartUnit1(), out);
                this.writeInt(this.rule.get(i).getStartUnit2(), out);
                this.writeInt(this.rule.get(i).getWLTKDMinimumPop(), out);
                this.writeInt(this.rule.get(i).getTownDefenceBonus(), out);
                this.writeInt(this.rule.get(i).getCityDefenceBonus(), out);
                this.writeInt(this.rule.get(i).getMetropolisDefenceBonus(), out);
                this.writeInt(this.rule.get(i).getMaxCity1Size(), out);
                this.writeInt(this.rule.get(i).getMaxCity2Size(), out);
                this.writeInt(this.rule.get(i).getQuestionMark4(), out);
                this.writeInt(this.rule.get(i).getFortificationsDefenceBonus(), out);
                this.writeInt(this.rule.get(i).getNumCulturalLevels(), out);
                for (j = 0; j < this.rule.get(i).getNumCulturalLevels(); ++j) {
                    this.writeString(this.rule.get(i).getCultureLevelName(j), 64, out);
                }
                this.writeInt(this.rule.get(i).getBorderExpansionMultiplier(), out);
                this.writeInt(this.rule.get(i).getBorderFactor(), out);
                this.writeInt(this.rule.get(i).getFutureTechCost(), out);
                this.writeInt(this.rule.get(i).getGoldenAgeDuration(), out);
                this.writeInt(this.rule.get(i).getMaximumResearchTime(), out);
                this.writeInt(this.rule.get(i).getMinimumResearchTime(), out);
                this.writeInt(this.rule.get(i).getFlagUnit(), out);
                this.writeInt(this.rule.get(i).getUpgradeCost(), out);
            }
        }
        catch (IOException e) {
            this.logger.error("IOException", e);
        }
    }

    private void outputPRTO(LittleEndianDataOutputStream out) {
        ArrayList<PRTO> strategyMaps = new ArrayList<PRTO>();
        try {
            int i;
            out.writeBytes("PRTO");
            this.writeInt(this.getNumFiraxisUnits(), out);
            for (i = 0; i < this.unit.size(); ++i) {
                this.writeInt(this.unit.get(i).getDataLength(), out);
                this.writeInt(this.unit.get(i).getZoneOfControl(), out);
                this.writeString(this.unit.get(i).getName(), 32, out);
                this.writeString(this.unit.get(i).getCivilopediaEntry(), 32, out);
                this.writeInt(this.unit.get(i).getBombardStrength(), out);
                this.writeInt(this.unit.get(i).getBombardRange(), out);
                this.writeInt(this.unit.get(i).getCapacity(), out);
                this.writeInt(this.unit.get(i).getShieldCost(), out);
                this.writeInt(this.unit.get(i).getDefence(), out);
                this.writeInt(this.unit.get(i).getIconIndex(), out);
                this.writeInt(this.unit.get(i).getAttack(), out);
                this.writeInt(this.unit.get(i).getOperationalRange(), out);
                this.writeInt(this.unit.get(i).getPopulationCost(), out);
                this.writeInt(this.unit.get(i).getRateOfFire(), out);
                this.writeInt(this.unit.get(i).getMovement(), out);
                this.writeInt(this.unit.get(i).getRequiredTech(), out);
                this.writeInt(this.unit.get(i).getUpgradeTo(), out);
                this.writeInt(this.unit.get(i).getRequiredResource1(), out);
                this.writeInt(this.unit.get(i).getRequiredResource2(), out);
                this.writeInt(this.unit.get(i).getRequiredResource3(), out);
                this.writeInt(this.unit.get((int)i).unitAbilities, out);
                this.unit.get(i).writeXthStrategy(1, out);
                this.writeInt(this.unit.get((int)i).availableTo, out);
                this.writeInt(this.unit.get((int)i).standardOrdersSpecialActions, out);
                this.writeInt(this.unit.get((int)i).airMissions, out);
                this.writeInt(this.unit.get(i).getUnitClass(), out);
                assert (this.unit.get(i).getOtherStrategy() == -1);
                this.writeInt(this.unit.get(i).getOtherStrategy(), out);
                this.writeInt(this.unit.get(i).getHitPointBonus(), out);
                this.writeInt(this.unit.get((int)i).PTWStandardOrders, out);
                this.writeInt(this.unit.get((int)i).PTWSpecialActions, out);
                this.writeInt(this.unit.get((int)i).PTWWorkerActions, out);
                this.writeInt(this.unit.get((int)i).PTWAirMissions, out);
                this.writeInt(this.unit.get((int)i).PTWActionsMix + 65536, out);
                this.writeInt(this.unit.get(i).getBombardEffects(), out);
                for (int j = 0; j < this.unit.get(i).getNumIgnoreTerrains(); ++j) {
                    out.writeByte(this.unit.get(i).getIgnoredMovementCost(j));
                }
                this.writeInt(this.unit.get(i).getRequiresSupport(), out);
                this.writeInt(this.unit.get(i).getUseExactCost(), out);
                this.writeInt(this.unit.get(i).getTelepadRange(), out);
                this.writeInt(this.unit.get(i).getQuestionMark3(), out);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("NumLegalUnitTelepads: " + this.unit.get(i).getNumLegalUnitTelepads());
                }
                this.writeInt(this.unit.get(i).getNumLegalUnitTelepads(), out);
                List<Integer> unitTelepads = this.unit.get(i).getUnitTelepads();
                for (int j = 0; j < unitTelepads.size(); ++j) {
                    this.writeInt(unitTelepads.get(j), out);
                }
                this.writeInt(this.unit.get(i).getEnslaveResultsIn(), out);
                this.writeInt(this.unit.get(i).getQuestionMark5(), out);
                this.writeInt(this.unit.get(i).getNumStealthTargets(), out);
                List<Integer> stealthTargets = this.unit.get(i).getStealthTargets();
                for (int j = 0; j < stealthTargets.size(); ++j) {
                    this.writeInt(stealthTargets.get(j), out);
                }
                this.writeInt(this.unit.get(i).getQuestionMark6(), out);
                this.writeInt(this.unit.get(i).getNumLegalBuildingTelepads(), out);
                List<Integer> buildingTelepads = this.unit.get(i).getBuildingTelepads();
                for (int j = 0; j < buildingTelepads.size(); ++j) {
                    this.writeInt(buildingTelepads.get(j), out);
                }
                out.writeByte(this.unit.get(i).getCreatesCraters());
                out.writeFloat(this.unit.get(i).getWorkerStrength());
                this.writeInt(this.unit.get(i).getQuestionMark8(), out);
                this.writeInt(this.unit.get(i).getAirDefence(), out);
                if (this.unit.get(i).getNumStrategies() <= 1) continue;
                strategyMaps.add(this.unit.get(i));
            }
            for (i = 0; i < strategyMaps.size(); ++i) {
                for (int s = 2; s <= ((PRTO)strategyMaps.get(i)).getNumStrategies(); ++s) {
                    this.writeInt(((PRTO)strategyMaps.get(i)).getDataLength(), out);
                    this.writeInt(((PRTO)strategyMaps.get(i)).getZoneOfControl(), out);
                    this.writeString(((PRTO)strategyMaps.get(i)).getName(), 32, out);
                    this.writeString(((PRTO)strategyMaps.get(i)).getCivilopediaEntry(), 32, out);
                    this.writeInt(((PRTO)strategyMaps.get(i)).getBombardStrength(), out);
                    this.writeInt(((PRTO)strategyMaps.get(i)).getBombardRange(), out);
                    this.writeInt(((PRTO)strategyMaps.get(i)).getCapacity(), out);
                    this.writeInt(((PRTO)strategyMaps.get(i)).getShieldCost(), out);
                    this.writeInt(((PRTO)strategyMaps.get(i)).getDefence(), out);
                    this.writeInt(((PRTO)strategyMaps.get(i)).getIconIndex(), out);
                    this.writeInt(((PRTO)strategyMaps.get(i)).getAttack(), out);
                    this.writeInt(((PRTO)strategyMaps.get(i)).getOperationalRange(), out);
                    this.writeInt(((PRTO)strategyMaps.get(i)).getPopulationCost(), out);
                    this.writeInt(((PRTO)strategyMaps.get(i)).getRateOfFire(), out);
                    this.writeInt(((PRTO)strategyMaps.get(i)).getMovement(), out);
                    this.writeInt(((PRTO)strategyMaps.get(i)).getRequiredTech(), out);
                    this.writeInt(((PRTO)strategyMaps.get(i)).getUpgradeTo(), out);
                    this.writeInt(((PRTO)strategyMaps.get(i)).getRequiredResource1(), out);
                    this.writeInt(((PRTO)strategyMaps.get(i)).getRequiredResource2(), out);
                    this.writeInt(((PRTO)strategyMaps.get(i)).getRequiredResource3(), out);
                    this.writeInt(((PRTO)strategyMaps.get((int)i)).unitAbilities, out);
                    ((PRTO)strategyMaps.get(i)).writeXthStrategy(s, out);
                    this.writeInt(((PRTO)strategyMaps.get((int)i)).availableTo, out);
                    this.writeInt(((PRTO)strategyMaps.get((int)i)).standardOrdersSpecialActions, out);
                    this.writeInt(((PRTO)strategyMaps.get((int)i)).airMissions, out);
                    this.writeInt(((PRTO)strategyMaps.get(i)).getUnitClass(), out);
                    this.writeInt(((PRTO)strategyMaps.get((int)i)).index, out);
                    this.writeInt(((PRTO)strategyMaps.get(i)).getHitPointBonus(), out);
                    this.writeInt(((PRTO)strategyMaps.get((int)i)).PTWStandardOrders, out);
                    this.writeInt(((PRTO)strategyMaps.get((int)i)).PTWSpecialActions, out);
                    this.writeInt(((PRTO)strategyMaps.get((int)i)).PTWWorkerActions, out);
                    this.writeInt(((PRTO)strategyMaps.get((int)i)).PTWAirMissions, out);
                    this.writeInt(((PRTO)strategyMaps.get((int)i)).PTWActionsMix + 65536, out);
                    this.writeInt(((PRTO)strategyMaps.get(i)).getBombardEffects(), out);
                    for (int j = 0; j < ((PRTO)strategyMaps.get(i)).getNumIgnoreTerrains(); ++j) {
                        out.writeByte(((PRTO)strategyMaps.get(i)).getIgnoredMovementCost(j));
                    }
                    this.writeInt(((PRTO)strategyMaps.get(i)).getRequiresSupport(), out);
                    this.writeInt(((PRTO)strategyMaps.get(i)).getUseExactCost(), out);
                    this.writeInt(((PRTO)strategyMaps.get(i)).getTelepadRange(), out);
                    this.writeInt(((PRTO)strategyMaps.get(i)).getQuestionMark3(), out);
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("NumLegalUnitTelepads: " + ((PRTO)strategyMaps.get(i)).getNumLegalUnitTelepads());
                    }
                    this.writeInt(((PRTO)strategyMaps.get(i)).getNumLegalUnitTelepads(), out);
                    List<Integer> strategyMapTelepads = ((PRTO)strategyMaps.get(i)).getUnitTelepads();
                    for (int j = 0; j < strategyMapTelepads.size(); ++j) {
                        this.writeInt(strategyMapTelepads.get(j), out);
                    }
                    this.writeInt(((PRTO)strategyMaps.get(i)).getEnslaveResultsIn(), out);
                    this.writeInt(((PRTO)strategyMaps.get(i)).getQuestionMark5(), out);
                    this.writeInt(((PRTO)strategyMaps.get(i)).getNumStealthTargets(), out);
                    List<Integer> stealthTargets = ((PRTO)strategyMaps.get(i)).getStealthTargets();
                    for (int j = 0; j < stealthTargets.size(); ++j) {
                        this.writeInt(stealthTargets.get(j), out);
                    }
                    this.writeInt(((PRTO)strategyMaps.get(i)).getQuestionMark6(), out);
                    this.writeInt(((PRTO)strategyMaps.get(i)).getNumLegalBuildingTelepads(), out);
                    List<Integer> buildingTelepads = ((PRTO)strategyMaps.get(i)).getBuildingTelepads();
                    for (int j = 0; j < buildingTelepads.size(); ++j) {
                        this.writeInt(buildingTelepads.get(j), out);
                    }
                    out.writeByte(((PRTO)strategyMaps.get(i)).getCreatesCraters());
                    out.writeFloat(((PRTO)strategyMaps.get(i)).getWorkerStrength());
                    this.writeInt(((PRTO)strategyMaps.get(i)).getQuestionMark8(), out);
                    this.writeInt(((PRTO)strategyMaps.get(i)).getAirDefence(), out);
                }
            }
        }
        catch (IOException e) {
            this.logger.error("IOException", e);
        }
    }

    @Deprecated
    public int getNumFiraxisUnits() {
        int numFiraxisUnits = 0;
        for (PRTO prto : this.unit) {
            if (prto.getNumStrategies() > 1) {
                numFiraxisUnits += prto.getNumStrategies();
                continue;
            }
            ++numFiraxisUnits;
        }
        return numFiraxisUnits;
    }

    public List<TILE> getTilesInDiameter(int x, int y, int diameter) {
        ArrayList<TILE> tiles = new ArrayList<TILE>();
        int index = this.calculateTileIndex(x, y);
        if (index != -1) {
            TILE thisTile = this.tile.get(index);
            tiles.add(thisTile);
        }
        for (int i = 3; i <= diameter; i += 2) {
            int adjX = x;
            int adjY = y;
            int adjustment = i - 1;
            adjX = x - adjustment;
            boolean north = true;
            while (adjX <= x + adjustment) {
                index = this.calculateTileIndex(adjX, adjY);
                if (index != -1) {
                    TILE nextTile = this.tile.get(index);
                    tiles.add(nextTile);
                }
                if (north) {
                    --adjY;
                    if (++adjX != x) continue;
                    north = false;
                    continue;
                }
                ++adjX;
                ++adjY;
            }
            boolean south = true;
            adjX = x + adjustment - 1;
            adjY = y + 1;
            while (adjX > x - adjustment) {
                index = this.calculateTileIndex(adjX, adjY);
                if (index != -1) {
                    TILE nextTile = this.tile.get(index);
                    tiles.add(nextTile);
                }
                if (south) {
                    ++adjY;
                    if (--adjX != x) continue;
                    south = false;
                    continue;
                }
                --adjX;
                --adjY;
            }
        }
        return tiles;
    }

    /*
     * WARNING - void declaration
     */
    private void outputRACE(LittleEndianDataOutputStream out) {
        try {
            out.writeBytes("RACE");
            this.writeInt(this.civilization.size(), out);
            for (int i = 0; i < this.civilization.size(); ++i) {
                void var5_13;
                void var5_11;
                this.civilization.get(i).createBinary();
                this.writeInt(this.civilization.get(i).getDataLength(), out);
                this.writeInt(this.civilization.get(i).getNumCityNames(), out);
                List<String> cityNames = this.civilization.get(i).getCityNames();
                for (String string : cityNames) {
                    this.writeString(string, 24, out);
                }
                this.writeInt(this.civilization.get(i).getNumGreatLeaders(), out);
                List<String> militaryLeaders = this.civilization.get(i).getMilitaryLeaders();
                for (String militaryLeader : militaryLeaders) {
                    this.writeString(militaryLeader, 32, out);
                }
                this.writeString(this.civilization.get(i).getLeaderName(), 32, out);
                this.writeString(this.civilization.get(i).getLeaderTitle(), 24, out);
                this.writeString(this.civilization.get(i).getCivilopediaEntry(), 32, out);
                this.writeString(this.civilization.get(i).getAdjective(), 40, out);
                this.writeString(this.civilization.get(i).getCivilizationName(), 40, out);
                this.writeString(this.civilization.get(i).getNoun(), 40, out);
                boolean bl = false;
                while (var5_11 < this.numEras) {
                    this.writeString(this.civilization.get(i).getForwardFilename((int)var5_11), 260, out);
                    ++var5_11;
                }
                boolean bl2 = false;
                while (var5_13 < this.numEras) {
                    this.writeString(this.civilization.get(i).getReverseFilename((int)var5_13), 260, out);
                    ++var5_13;
                }
                this.writeInt(this.civilization.get(i).getCultureGroup(), out);
                this.writeInt(this.civilization.get(i).getLeaderGender(), out);
                this.writeInt(this.civilization.get(i).getCivilizationGender(), out);
                this.writeInt(this.civilization.get(i).getAggressionLevel(), out);
                this.writeInt(this.civilization.get(i).getUniqueCivilizationCounter(), out);
                this.writeInt(this.civilization.get(i).getShunnedGovernment(), out);
                this.writeInt(this.civilization.get(i).getFavoriteGovernment(), out);
                this.writeInt(this.civilization.get(i).getDefaultColor(), out);
                this.writeInt(this.civilization.get(i).getUniqueColor(), out);
                this.writeInt(this.civilization.get(i).getFreeTech1Index(), out);
                this.writeInt(this.civilization.get(i).getFreeTech2Index(), out);
                this.writeInt(this.civilization.get(i).getFreeTech3Index(), out);
                this.writeInt(this.civilization.get(i).getFreeTech4Index(), out);
                this.writeInt(this.civilization.get(i).getBonuses(), out);
                this.writeInt(this.civilization.get(i).getGovernorSettings(), out);
                this.writeInt(this.civilization.get(i).getBuildNever(), out);
                this.writeInt(this.civilization.get(i).getBuildOften(), out);
                this.writeInt(this.civilization.get(i).getPlurality(), out);
                this.writeInt(this.civilization.get(i).getKingUnit(), out);
                this.writeInt(this.civilization.get(i).getFlavors(), out);
                this.writeInt(this.civilization.get(i).getQuestionMark(), out);
                this.writeInt(this.civilization.get(i).getDiplomacyTextIndex(), out);
                this.writeInt(this.civilization.get(i).getNumScientificLeaders(), out);
                List<String> list = this.civilization.get(i).getScientificLeaders();
                for (String scientificLeader : list) {
                    this.writeString(scientificLeader, 32, out);
                }
            }
        }
        catch (IOException e) {
            this.logger.error("IOException", e);
        }
    }

    private void outputTECH(LittleEndianDataOutputStream out) {
        try {
            out.writeBytes("TECH");
            this.writeInt(this.technology.size(), out);
            for (int i = 0; i < this.technology.size(); ++i) {
                this.technology.get(i).createBinary();
                this.writeInt(this.technology.get(i).getDataLength(), out);
                this.writeString(this.technology.get(i).getName(), 32, out);
                this.writeString(this.technology.get(i).getCivilopediaEntry(), 32, out);
                this.writeInt(this.technology.get(i).getCost(), out);
                this.writeInt(this.technology.get(i).getEra(), out);
                this.writeInt(this.technology.get(i).getAdvanceIcon(), out);
                this.writeInt(this.technology.get(i).getX(), out);
                this.writeInt(this.technology.get(i).getY(), out);
                this.writeInt(this.technology.get(i).getPrerequisite1(), out);
                this.writeInt(this.technology.get(i).getPrerequisite2(), out);
                this.writeInt(this.technology.get(i).getPrerequisite3(), out);
                this.writeInt(this.technology.get(i).getPrerequisite4(), out);
                this.writeInt(this.technology.get(i).getFlags(), out);
                this.writeInt(this.technology.get(i).getFlavors(), out);
                this.writeInt(this.technology.get(i).getQuestionMark(), out);
            }
        }
        catch (IOException e) {
            this.logger.error("IOException", e);
        }
    }

    private void outputTFRM(LittleEndianDataOutputStream out) {
        try {
            out.writeBytes("TFRM");
            this.writeInt(this.workerJob.size(), out);
            for (int i = 0; i < this.workerJob.size(); ++i) {
                this.writeInt(this.workerJob.get(i).getDataLength(), out);
                this.writeString(this.workerJob.get(i).getName(), 32, out);
                this.writeString(this.workerJob.get(i).getCivilopediaEntry(), 32, out);
                this.writeInt(this.workerJob.get(i).getTurnsToComplete(), out);
                this.writeInt(this.workerJob.get(i).getRequiredAdvance(), out);
                this.writeInt(this.workerJob.get(i).getRequiredResource1(), out);
                this.writeInt(this.workerJob.get(i).getRequiredResource2(), out);
                this.writeString(this.workerJob.get(i).getOrder(), 32, out);
            }
        }
        catch (IOException e) {
            this.logger.error("IOException", e);
        }
    }

    private void outputTERR(LittleEndianDataOutputStream out) {
        try {
            out.writeBytes("TERR");
            this.writeInt(this.terrain.size(), out);
            for (int i = 0; i < this.terrain.size(); ++i) {
                this.writeInt(this.terrain.get(i).getDataLength(), out);
                this.writeInt(this.terrain.get(i).getNumPossibleResources(), out);
                for (int j = 0; j < (this.terrain.get(i).getNumPossibleResources() + 7) / 8; ++j) {
                    out.writeByte(this.terrain.get((int)i).possibleResources.get(j).byteValue());
                }
                this.writeString(this.terrain.get(i).getName(), 32, out);
                this.writeString(this.terrain.get(i).getCivilopediaEntry(), 32, out);
                this.writeInt(this.terrain.get(i).getFoodBonus(), out);
                this.writeInt(this.terrain.get(i).getShieldsBonus(), out);
                this.writeInt(this.terrain.get(i).getCommerceBonus(), out);
                this.writeInt(this.terrain.get(i).getDefenceBonus(), out);
                this.writeInt(this.terrain.get(i).getMovementCost(), out);
                this.writeInt(this.terrain.get(i).getFood(), out);
                this.writeInt(this.terrain.get(i).getShields(), out);
                this.writeInt(this.terrain.get(i).getCommerce(), out);
                this.writeInt(this.terrain.get(i).getWorkerJob(), out);
                this.writeInt(this.terrain.get(i).getPollutionEffect(), out);
                out.writeByte(this.terrain.get(i).getAllowCities());
                out.writeByte(this.terrain.get(i).getAllowColonies());
                out.writeByte(this.terrain.get(i).getImpassable());
                out.writeByte(this.terrain.get(i).getImpassableByWheeled());
                out.writeByte(this.terrain.get(i).getAllowAirfields());
                out.writeByte(this.terrain.get(i).getAllowForts());
                out.writeByte(this.terrain.get(i).getAllowOutposts());
                out.writeByte(this.terrain.get(i).getAllowRadarTowers());
                this.writeInt(this.terrain.get(i).getQuestionMark(), out);
                out.writeByte(this.terrain.get(i).getLandmarkEnabled());
                this.writeInt(this.terrain.get(i).getLandmarkFood(), out);
                this.writeInt(this.terrain.get(i).getLandmarkShields(), out);
                this.writeInt(this.terrain.get(i).getLandmarkCommerce(), out);
                this.writeInt(this.terrain.get(i).getLandmarkFoodBonus(), out);
                this.writeInt(this.terrain.get(i).getLandmarkShieldsBonus(), out);
                this.writeInt(this.terrain.get(i).getLandmarkCommerceBonus(), out);
                this.writeInt(this.terrain.get(i).getLandmarkMovementCost(), out);
                this.writeInt(this.terrain.get(i).getLandmarkDefenceBonus(), out);
                this.writeString(this.terrain.get(i).getLandmarkName(), 32, out);
                this.writeString(this.terrain.get(i).getLandmarkCivilopediaEntry(), 32, out);
                this.writeInt(this.terrain.get(i).getQuestionMark2(), out);
                this.writeInt(this.terrain.get(i).getTerrainFlags(), out);
                this.writeInt(this.terrain.get(i).getDiseaseStrength(), out);
            }
        }
        catch (IOException e) {
            this.logger.error("IOException", e);
        }
    }

    private void outputWSIZ(LittleEndianDataOutputStream out) {
        try {
            out.writeBytes("WSIZ");
            this.writeInt(this.worldSize.size(), out);
            for (int i = 0; i < this.worldSize.size(); ++i) {
                this.writeInt(this.worldSize.get(i).getDataLength(), out);
                this.writeInt(this.worldSize.get(i).getOptimalNumberOfCities(), out);
                this.writeInt(this.worldSize.get(i).getTechRate(), out);
                this.writeString(this.worldSize.get(i).getEmpty(), 24, out);
                this.writeString(this.worldSize.get(i).getName(), 32, out);
                this.writeInt(this.worldSize.get(i).getHeight(), out);
                this.writeInt(this.worldSize.get(i).getDistanceBetweenCivs(), out);
                this.writeInt(this.worldSize.get(i).getNumberOfCivs(), out);
                this.writeInt(this.worldSize.get(i).getWidth(), out);
            }
        }
        catch (IOException e) {
            this.logger.error("IOException", e);
        }
    }

    private void outputFLAV(LittleEndianDataOutputStream out) {
        try {
            out.writeBytes("FLAV");
            this.writeInt(1, out);
            if (this.flavor == null) {
                this.flavor = new ArrayList<FLAV>(0);
            }
            this.writeInt(this.flavor.size(), out);
            for (int i = 0; i < this.flavor.size(); ++i) {
                this.writeInt(this.flavor.get(i).getQuestionMark(), out);
                this.writeString(this.flavor.get(i).getName(), 256, out);
                this.writeInt(this.flavor.get(i).getNumberOfFlavors(), out);
                for (int j = 0; j < this.flavor.get(i).getNumberOfFlavors(); ++j) {
                    this.writeInt(this.flavor.get((int)i).relationWithOtherFlavor.get(j), out);
                }
            }
        }
        catch (IOException e) {
            this.logger.error("IOException", e);
        }
    }

    private void outputWCHR(LittleEndianDataOutputStream out) {
        try {
            out.writeBytes("WCHR");
            this.writeInt(this.worldCharacteristic.size(), out);
            for (int i = 0; i < this.worldCharacteristic.size(); ++i) {
                this.writeInt(this.worldCharacteristic.get(i).getDataLength(), out);
                this.writeInt(this.worldCharacteristic.get(i).getSelectedClimate(), out);
                this.writeInt(this.worldCharacteristic.get(i).getActualClimate(), out);
                this.writeInt(this.worldCharacteristic.get(i).getSelectedBarbarianActivity(), out);
                this.writeInt(this.worldCharacteristic.get(i).getActualBarbarianActivity(), out);
                this.writeInt(this.worldCharacteristic.get(i).getSelectedLandform(), out);
                this.writeInt(this.worldCharacteristic.get(i).getActualLandform(), out);
                this.writeInt(this.worldCharacteristic.get(i).getSelectedOceanCoverage(), out);
                this.writeInt(this.worldCharacteristic.get(i).getActualOceanCoverage(), out);
                this.writeInt(this.worldCharacteristic.get(i).getSelectedTemperature(), out);
                this.writeInt(this.worldCharacteristic.get(i).getActualTemperature(), out);
                this.writeInt(this.worldCharacteristic.get(i).getSelectedAge(), out);
                this.writeInt(this.worldCharacteristic.get(i).getActualAge(), out);
                this.writeInt(this.worldCharacteristic.get(i).getWorldSize(), out);
            }
        }
        catch (IOException e) {
            this.logger.error("IOException", e);
        }
    }

    private void outputWMAP(LittleEndianDataOutputStream out) {
        try {
            out.writeBytes("WMAP");
            this.writeInt(this.worldMap.size(), out);
            for (int i = 0; i < this.worldMap.size(); ++i) {
                this.writeInt(this.worldMap.get(i).getDataLength(), out);
                this.writeInt(this.worldMap.get(i).getNumResources(), out);
                for (int j = 0; j < this.worldMap.get(i).getNumResources(); ++j) {
                    this.writeInt(this.worldMap.get((int)i).resourceOccurence.get(j), out);
                }
                this.writeInt(this.worldMap.get(i).getNumContinents(), out);
                this.writeInt(this.worldMap.get(i).getHeight(), out);
                this.writeInt(this.worldMap.get(i).getDistanceBetweenCivs(), out);
                this.writeInt(this.worldMap.get(i).getNumCivs(), out);
                this.writeInt(this.worldMap.get(i).getQuestionMark1(), out);
                this.writeInt(this.worldMap.get(i).getQuestionMark2(), out);
                this.writeInt(this.worldMap.get(i).getWidth(), out);
                this.writeInt(this.worldMap.get(i).getQuestionMark3(), out);
                this.writeString(this.worldMap.get(i).getUnknown124(), 124, out);
                this.writeInt(this.worldMap.get(i).getMapSeed(), out);
                this.writeInt(this.worldMap.get(i).getFlags(), out);
            }
        }
        catch (IOException e) {
            this.logger.error("IOException", e);
        }
    }

    private void outputTILE(LittleEndianDataOutputStream out) {
        try {
            out.writeBytes("TILE");
            this.writeInt(this.tile.size(), out);
            for (int i = 0; i < this.tile.size(); ++i) {
                this.writeInt(this.tile.get(i).getDataLength(), out);
                out.writeByte(this.tile.get(i).getRiverConnectionInfo());
                out.writeByte(this.tile.get(i).getBorder());
                this.writeInt(this.tile.get(i).getResource(), out);
                out.writeByte(this.tile.get(i).getImage());
                out.writeByte(this.tile.get(i).getFile());
                this.writeShort(this.tile.get(i).getQuestionMark(), out);
                out.writeByte(this.tile.get(i).getOverlays());
                out.writeByte(this.tile.get(i).getBaseRealTerrain());
                out.writeByte(this.tile.get(i).getBonuses());
                out.writeByte(this.tile.get(i).getRiverCrossingData());
                this.writeShort(this.tile.get(i).getBarbarianTribe(), out);
                this.writeShort(this.tile.get(i).getCity(), out);
                this.writeShort(this.tile.get(i).getColony(), out);
                this.writeShort(this.tile.get(i).getContinent(), out);
                out.writeByte(this.tile.get(i).getQuestionMark2());
                this.writeShort(this.tile.get(i).getVictoryPointLocation(), out);
                this.writeInt(this.tile.get(i).getRuin(), out);
                this.writeInt(this.tile.get(i).getC3COverlays(), out);
                out.writeByte(this.tile.get(i).getQuestionMark3());
                out.writeByte(this.tile.get(i).getC3CBaseRealTerrain());
                this.writeShort(this.tile.get(i).getQuestionMark4(), out);
                this.writeShort(this.tile.get(i).getFogOfWar(), out);
                this.writeInt(this.tile.get(i).getC3CBonuses(), out);
                this.writeShort(this.tile.get(i).getQuestionMark5(), out);
            }
        }
        catch (IOException e) {
            this.logger.error("IOException", e);
        }
    }

    private void outputCONT(LittleEndianDataOutputStream out) {
        try {
            out.writeBytes("CONT");
            this.writeInt(this.continent.size(), out);
            for (int i = 0; i < this.continent.size(); ++i) {
                this.writeInt(this.continent.get(i).getDataLength(), out);
                this.writeInt(this.continent.get(i).getContinentClass(), out);
                this.writeInt(this.continent.get(i).getNumTiles(), out);
            }
        }
        catch (IOException e) {
            this.logger.error("IOException", e);
        }
    }

    private void outputSLOC(LittleEndianDataOutputStream out) {
        try {
            out.writeBytes("SLOC");
            this.writeInt(this.startingLocation.size(), out);
            for (int i = 0; i < this.startingLocation.size(); ++i) {
                this.writeInt(this.startingLocation.get(i).getDataLength(), out);
                this.writeInt(this.startingLocation.get(i).getOwnerType(), out);
                this.writeInt(this.startingLocation.get(i).getOwner(), out);
                this.writeInt(this.startingLocation.get(i).getX(), out);
                this.writeInt(this.startingLocation.get(i).getY(), out);
            }
        }
        catch (IOException e) {
            this.logger.error("IOException", e);
        }
    }

    private void outputCITY(LittleEndianDataOutputStream out) {
        try {
            out.writeBytes("CITY");
            this.writeInt(this.city.size(), out);
            for (int i = 0; i < this.city.size(); ++i) {
                this.writeInt(this.city.get(i).getDataLength(), out);
                out.writeByte(this.city.get(i).getHasWalls());
                out.writeByte(this.city.get(i).getHasPalace());
                this.writeString(this.city.get(i).getName(), 24, out);
                this.writeInt(this.city.get(i).getOwnerType(), out);
                this.writeInt(this.city.get(i).getNumBuildings(), out);
                for (int j = 0; j < this.city.get(i).getNumBuildings(); ++j) {
                    this.writeInt(this.city.get(i).getBuildingID(j), out);
                }
                this.writeInt(this.city.get(i).getCulture(), out);
                this.writeInt(this.city.get(i).getOwner(), out);
                this.writeInt(this.city.get(i).getSize(), out);
                this.writeInt(this.city.get(i).getX(), out);
                this.writeInt(this.city.get(i).getY(), out);
                this.writeInt(this.city.get(i).getCityLevel(), out);
                this.writeInt(this.city.get(i).getBorderLevel(), out);
                this.writeInt(this.city.get(i).getUseAutoName(), out);
            }
        }
        catch (IOException e) {
            this.logger.error("IOException", e);
        }
    }

    private void outputUNIT(LittleEndianDataOutputStream out) {
        try {
            out.writeBytes("UNIT");
            this.writeInt(this.mapUnit.size(), out);
            for (int i = 0; i < this.mapUnit.size(); ++i) {
                this.writeInt(this.mapUnit.get(i).getDataLength(), out);
                this.writeString(this.mapUnit.get(i).getName(), 32, out);
                this.writeInt(this.mapUnit.get(i).getOwnerType(), out);
                this.writeInt(this.mapUnit.get(i).getExperienceLevel(), out);
                this.writeInt(this.mapUnit.get(i).getOwner(), out);
                this.writeInt(this.mapUnit.get(i).getPRTONumber(), out);
                this.writeInt(this.mapUnit.get(i).getAIStrategy(), out);
                this.writeInt(this.mapUnit.get(i).getX(), out);
                this.writeInt(this.mapUnit.get(i).getY(), out);
                this.writeString(this.mapUnit.get(i).getPTWCustomName(), 57, out);
                this.writeInt(this.mapUnit.get(i).getUseCivilizationKing(), out);
            }
        }
        catch (IOException e) {
            this.logger.error("IOException", e);
        }
    }

    private void outputCLNY(LittleEndianDataOutputStream out) {
        try {
            out.writeBytes("CLNY");
            this.writeInt(this.colony.size(), out);
            for (int i = 0; i < this.colony.size(); ++i) {
                this.writeInt(this.colony.get(i).getDataLength(), out);
                this.writeInt(this.colony.get(i).getOwnerType(), out);
                this.writeInt(this.colony.get(i).getOwner(), out);
                this.writeInt(this.colony.get(i).getX(), out);
                this.writeInt(this.colony.get(i).getY(), out);
                this.writeInt(this.colony.get(i).getImprovementType(), out);
            }
        }
        catch (IOException e) {
            this.logger.error("IOException", e);
        }
    }

    private void outputGAME(LittleEndianDataOutputStream out) {
        try {
            out.writeBytes("GAME");
            this.writeInt(this.scenarioProperty.size(), out);
            for (int i = 0; i < this.scenarioProperty.size(); ++i) {
                int j;
                this.writeInt(this.scenarioProperty.get(i).getDataLength(), out);
                this.writeInt(this.scenarioProperty.get(i).getUseDefaultRules(), out);
                this.writeInt(this.scenarioProperty.get(i).getDefaultVictoryConditions(), out);
                this.writeInt(this.scenarioProperty.get(i).getNumberOfPlayableCivs(), out);
                for (j = 0; j < this.scenarioProperty.get(i).getNumberOfPlayableCivs(); ++j) {
                    this.writeInt(this.scenarioProperty.get((int)i).idOfPlayableCivs.get(j), out);
                }
                this.writeInt(this.scenarioProperty.get(i).getVictoryConditionsAndRules(), out);
                this.writeInt(this.scenarioProperty.get(i).getPlaceCaptureUnits(), out);
                this.writeInt(this.scenarioProperty.get(i).getAutoPlaceKings(), out);
                this.writeInt(this.scenarioProperty.get(i).getAutoPlaceVictoryLocations(), out);
                this.writeInt(this.scenarioProperty.get(i).getDebugMode(), out);
                this.writeInt(this.scenarioProperty.get(i).getUseTimeLimit(), out);
                this.writeInt(this.scenarioProperty.get(i).getBaseTimeUnit(), out);
                this.writeInt(this.scenarioProperty.get(i).getStartMonth(), out);
                this.writeInt(this.scenarioProperty.get(i).getStartWeek(), out);
                this.writeInt(this.scenarioProperty.get(i).getStartYear(), out);
                this.writeInt(this.scenarioProperty.get(i).getMinuteTimeLimit(), out);
                this.writeInt(this.scenarioProperty.get(i).getTurnTimeLimit(), out);
                for (j = 0; j < this.scenarioProperty.get((int)i).turnsPerTimescalePart.length; ++j) {
                    this.writeInt(this.scenarioProperty.get((int)i).turnsPerTimescalePart[j], out);
                }
                for (j = 0; j < this.scenarioProperty.get((int)i).timeUnitsPerTurn.length; ++j) {
                    this.writeInt(this.scenarioProperty.get((int)i).timeUnitsPerTurn[j], out);
                }
                this.writeString(this.scenarioProperty.get(i).getScenarioSearchFolders(), 5200, out);
                if (this.scenarioProperty.get((int)i).numberOfPlayableCivs > 0) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug(this.scenarioProperty.get((int)i).numberOfPlayableCivs + " civs checked as playable");
                    }
                    for (j = 0; j < this.scenarioProperty.get((int)i).numberOfPlayableCivs; ++j) {
                        if (this.version == civ3Version.CONQUESTS) {
                            this.writeInt(this.scenarioProperty.get((int)i).civPartOfWhichAlliance.get(j), out);
                            continue;
                        }
                        this.writeInt(0, out);
                    }
                } else {
                    this.logger.warn("Fewer than one civ checked as playable");
                    this.logger.warn("civilization.size() - 1: " + (this.civilization.size() - 1));
                    for (j = 0; j < this.civilization.size() - 1; ++j) {
                        if (this.version == civ3Version.CONQUESTS) {
                            this.writeInt(this.scenarioProperty.get((int)i).civPartOfWhichAlliance.get(j), out);
                            continue;
                        }
                        this.writeInt(0, out);
                    }
                }
                this.writeInt(this.scenarioProperty.get(i).getVictoryPointLimit(), out);
                this.writeInt(this.scenarioProperty.get(i).getCityEliminationCount(), out);
                this.writeInt(this.scenarioProperty.get(i).getOneCityCultureWinLimit(), out);
                this.writeInt(this.scenarioProperty.get(i).getAllCitiesCultureWinLimit(), out);
                this.writeInt(this.scenarioProperty.get(i).getDominationTerrainPercent(), out);
                this.writeInt(this.scenarioProperty.get(i).getDominationPopulationPercent(), out);
                this.writeInt(this.scenarioProperty.get(i).getWonderVP(), out);
                this.writeInt(this.scenarioProperty.get(i).getDefeatingOpposingUnitVP(), out);
                this.writeInt(this.scenarioProperty.get(i).getAdvancementVP(), out);
                this.writeInt(this.scenarioProperty.get(i).getCityConquestVP(), out);
                this.writeInt(this.scenarioProperty.get(i).getVictoryPointVP(), out);
                this.writeInt(this.scenarioProperty.get(i).getCaptureSpecialUnitVP(), out);
                this.writeInt(this.scenarioProperty.get(i).getQuestionMark1(), out);
                out.writeByte(this.scenarioProperty.get(i).getQuestionMark2());
                this.writeString(this.scenarioProperty.get(i).getAlliance0(), 256, out);
                this.writeString(this.scenarioProperty.get(i).getAlliance1(), 256, out);
                this.writeString(this.scenarioProperty.get(i).getAlliance2(), 256, out);
                this.writeString(this.scenarioProperty.get(i).getAlliance3(), 256, out);
                this.writeString(this.scenarioProperty.get(i).getAlliance4(), 256, out);
                for (j = 0; j < 5; ++j) {
                    if (this.version == civ3Version.CONQUESTS) {
                        this.writeInt(this.scenarioProperty.get((int)i).warWith0.get(j), out);
                        this.writeInt(this.scenarioProperty.get((int)i).warWith1.get(j), out);
                        this.writeInt(this.scenarioProperty.get((int)i).warWith2.get(j), out);
                        this.writeInt(this.scenarioProperty.get((int)i).warWith3.get(j), out);
                        this.writeInt(this.scenarioProperty.get((int)i).warWith4.get(j), out);
                        continue;
                    }
                    for (int k = 0; k < 5; ++k) {
                        this.writeInt(0, out);
                    }
                }
                this.writeInt(this.scenarioProperty.get(i).getAllianceVictoryType(), out);
                this.writeString(this.scenarioProperty.get(i).getPlaugeName(), 260, out);
                out.writeByte(this.scenarioProperty.get(i).getPermitPlagues());
                this.writeInt(this.scenarioProperty.get(i).getPlagueEarliestStart(), out);
                this.writeInt(this.scenarioProperty.get(i).getPlagueVariation(), out);
                this.writeInt(this.scenarioProperty.get(i).getPlagueDuration(), out);
                this.writeInt(this.scenarioProperty.get(i).getPlagueStrength(), out);
                this.writeInt(this.scenarioProperty.get(i).getPlagueGracePeriod(), out);
                this.writeInt(this.scenarioProperty.get(i).getPlagueMaxOccurance(), out);
                this.writeInt(this.scenarioProperty.get(i).getQuestionMark3(), out);
                this.writeString(this.scenarioProperty.get(i).getUnknown(), 260, out);
                this.writeInt(this.scenarioProperty.get(i).getRespawnFlagUnits(), out);
                out.writeByte(this.scenarioProperty.get(i).getCaptureAnyFlag());
                this.writeInt(this.scenarioProperty.get(i).getGoldForCapture(), out);
                out.writeByte(this.scenarioProperty.get(i).getMapVisible());
                out.writeByte(this.scenarioProperty.get(i).getRetainCulture());
                this.writeInt(this.scenarioProperty.get(i).getQuestionMark4(), out);
                this.writeInt(this.scenarioProperty.get(i).getEruptionPeriod(), out);
                this.writeInt(this.scenarioProperty.get(i).getMpBaseTime(), out);
                this.writeInt(this.scenarioProperty.get(i).getMpCityTime(), out);
                this.writeInt(this.scenarioProperty.get(i).getMpUnitTime(), out);
            }
        }
        catch (IOException e) {
            this.logger.error("IOException", e);
        }
    }

    private void outputLEAD(LittleEndianDataOutputStream out) {
        try {
            out.writeBytes("LEAD");
            this.writeInt(this.player.size(), out);
            for (int i = 0; i < this.player.size(); ++i) {
                this.writeInt(this.player.get(i).getDataLength(), out);
                this.writeInt(this.player.get(i).getCustomCivData(), out);
                this.writeInt(this.player.get(i).getHumanPlayer(), out);
                this.writeString(this.player.get(i).getLeaderName(), 32, out);
                this.writeInt(this.player.get(i).getQuestionMark1(), out);
                this.writeInt(this.player.get(i).getQuestionMark2(), out);
                Map<PRTO, Integer> playerStartUnits = this.player.get(i).getStartingUnits();
                this.writeInt(playerStartUnits.size(), out);
                for (Map.Entry<PRTO, Integer> entry : playerStartUnits.entrySet()) {
                    this.writeInt(entry.getValue(), out);
                    this.writeInt(entry.getKey().getIndex(), out);
                }
                this.writeInt(this.player.get(i).getGenderOfLeaderName(), out);
                this.writeInt(this.player.get(i).getNumberOfStartingTechnologies(), out);
                for (int j = 0; j < this.player.get(i).getNumberOfStartingTechnologies(); ++j) {
                    this.writeInt(this.player.get((int)i).startingTechnologyInt.get(j), out);
                }
                this.writeInt(this.player.get(i).getDifficulty(), out);
                this.writeInt(this.player.get(i).getInitialEra(), out);
                this.writeInt(this.player.get(i).getStartCash(), out);
                this.writeInt(this.player.get(i).getGovernment(), out);
                this.writeInt(this.player.get(i).getCiv(), out);
                this.writeInt(this.player.get(i).getColor(), out);
                this.writeInt(this.player.get(i).getSkipFirstTurn(), out);
                this.writeInt(this.player.get(i).getQuestionMark3(), out);
                out.writeByte(this.player.get(i).getStartEmbassies());
            }
        }
        catch (IOException e) {
            this.logger.error("IOException", e);
        }
    }

    public void trim() {
        this.description = this.description.trim();
        this.title = this.title.trim();
    }

    public int numSection(Section section) {
        switch (section) {
            case BLDG: {
                return this.numBuildings;
            }
            case CTZN: {
                return this.numCitizens;
            }
            case CULT: {
                return this.numCulturalOpinions;
            }
            case DIFF: {
                return this.numDifficulties;
            }
            case ERAS: {
                return this.numEras;
            }
            case ESPN: {
                return this.numEspionage;
            }
            case EXPR: {
                return this.numExprLevel;
            }
            case GOOD: {
                return this.numGoods;
            }
            case GOVT: {
                return this.numGovernments;
            }
            case RULE: {
                return this.numRules;
            }
            case PRTO: {
                return this.unit.size();
            }
            case RACE: {
                return this.numCivilizations;
            }
            case TECH: {
                return this.numTechnologies;
            }
            case TFRM: {
                return this.numWorkerJobs;
            }
            case TERR: {
                return this.terrain.size();
            }
            case WSIZ: {
                return this.worldSize.size();
            }
            case FLAV: {
                return this.flavor.size();
            }
            case WCHR: {
                return this.worldCharacteristic.size();
            }
            case WMAP: {
                return this.worldMap.size();
            }
            case TILE: {
                return this.tile.size();
            }
            case CONT: {
                return this.numContinents;
            }
            case SLOC: {
                return this.numStartingLocations;
            }
            case CITY: {
                return this.numCities;
            }
            case UNIT: {
                return this.numUnits;
            }
            case CLNY: {
                return this.numColonies;
            }
            case GAME: {
                return this.numScenarioProperties;
            }
            case LEAD: {
                return this.numPlayers;
            }
        }
        return 0;
    }

    public List getSection(Section section) {
        switch (section) {
            case BLDG: {
                return this.buildings;
            }
            case CTZN: {
                return this.citizens;
            }
            case CULT: {
                return this.culture;
            }
            case DIFF: {
                return this.difficulties;
            }
            case ERAS: {
                return this.eras;
            }
            case ESPN: {
                return this.espionage;
            }
            case EXPR: {
                return this.experience;
            }
            case GOOD: {
                return this.resource;
            }
            case GOVT: {
                return this.government;
            }
            case RULE: {
                return this.rule;
            }
            case PRTO: {
                return this.unit;
            }
            case RACE: {
                return this.civilization;
            }
            case TECH: {
                return this.technology;
            }
            case TFRM: {
                return this.workerJob;
            }
            case TERR: {
                return this.terrain;
            }
            case WSIZ: {
                return this.worldSize;
            }
            case FLAV: {
                return this.flavor;
            }
            case WCHR: {
                return this.worldCharacteristic;
            }
            case WMAP: {
                return this.worldMap;
            }
            case TILE: {
                return this.tile;
            }
            case CONT: {
                return this.continent;
            }
            case SLOC: {
                return this.startingLocation;
            }
            case CITY: {
                return this.city;
            }
            case UNIT: {
                return this.mapUnit;
            }
            case CLNY: {
                return this.colony;
            }
            case GAME: {
                return this.scenarioProperty;
            }
            case LEAD: {
                return this.player;
            }
        }
        return null;
    }

    public void calculateTileOwners(int x, int y, List<TILE> tilesToLookAt1) {
        if (!this.hasCustomMap) {
            return;
        }
        short cityID = this.tile.get((int)this.calculateTileIndex((int)x, (int)y)).city;
        if (cityID == -1) {
            return;
        }
        this.calculateInfluenceOfCity(cityID);
        List<TILE> tilesToLookAt2 = this.city.get((int)cityID).tilesInfluenced;
        if (tilesToLookAt1.size() > tilesToLookAt2.size()) {
            for (int i = 0; i < tilesToLookAt1.size(); ++i) {
                this.calculateTileOwner(tilesToLookAt1.get(i));
            }
        } else {
            for (int i = 0; i < tilesToLookAt2.size(); ++i) {
                this.calculateTileOwner(tilesToLookAt2.get(i));
            }
        }
    }

    public void calculateTileOwners() {
        if (!this.hasCustomMap) {
            return;
        }
        long preCity = System.nanoTime();
        this.calculateInfluenceOfCities();
        long postCity = System.nanoTime();
        long ms = (postCity - preCity) / 1000000L;
        if (this.logger.isInfoEnabled()) {
            this.logger.info("It took " + ms + " ms to calculate the city influence");
        }
        long nearby = 0L;
        for (int i = 0; i < this.tile.size(); ++i) {
            TILE curTile = this.tile.get(i);
            nearby += this.calculateTileOwner(curTile);
            if (!this.logger.isDebugEnabled()) continue;
            this.logger.debug("Found owner for tile " + i);
        }
        long postOwner = System.nanoTime();
        ms = (postOwner - postCity) / 1000000L;
        if (this.logger.isInfoEnabled()) {
            this.logger.info("It took " + ms + " ms to who owns tiles");
        }
        ms = nearby / 1000000L;
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Of that, it took " + ms + " ms to calculate the nearest city");
        }
    }

    private long calculateTileOwner(TILE curTile) {
        if (curTile.xPos == 5 && curTile.yPos == 43) {
            this.logger.info("debug");
        }
        long nearbyTime = 0L;
        if (curTile.citiesWithInfluence.isEmpty()) {
            curTile.owner = -1;
        } else {
            int j;
            long time;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(curTile.citiesWithInfluence + " cities influencing");
                for (int z = 0; z < curTile.citiesWithInfluence.size(); ++z) {
                    this.logger.debug(this.city.get(curTile.citiesWithInfluence.get(z)).getX() + ", " + this.city.get(curTile.citiesWithInfluence.get(z)).getY());
                }
                this.logger.debug("i: " + curTile.index);
            }
            long now = System.nanoTime();
            List<CITY> nearbyCities = this.findNearestCities(curTile.xPos, curTile.yPos);
            long later = System.nanoTime();
            nearbyTime = time = later - now;
            int maxCultureIndex = -1;
            if (nearbyCities.size() == 0) {
                curTile.owner = -1;
                return nearbyTime;
            }
            if (nearbyCities.size() == 1) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Only one nearby city");
                }
                curTile.owner = nearbyCities.get(0).getOwner();
                maxCultureIndex = 0;
            } else {
                int maxCulture = -1;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Nearby cities size: " + nearbyCities.size());
                }
                for (j = 0; j < nearbyCities.size(); ++j) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("City " + j + " culture: " + nearbyCities.get(j).getCulture());
                    }
                    if (nearbyCities.get(j).getCulture() <= maxCulture) continue;
                    maxCulture = nearbyCities.get(j).getCulture();
                    maxCultureIndex = j;
                }
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Max culture index: " + maxCultureIndex);
            }
            switch (nearbyCities.get(maxCultureIndex).getOwnerType()) {
                case 2: {
                    curTile.owner = nearbyCities.get(maxCultureIndex).getOwner();
                    boolean foundCustomColor = false;
                    if (this.hasCustomPlayerData) {
                        for (j = 0; j < this.player.size(); ++j) {
                            if (this.player.get((int)j).civ != curTile.owner || this.player.get((int)j).customCivData != 1) continue;
                            curTile.borderColor = this.player.get((int)j).color;
                            foundCustomColor = true;
                        }
                    }
                    if (!foundCustomColor) {
                        curTile.borderColor = this.civilization.get(curTile.owner).getDefaultColor();
                    }
                    curTile.definiteOwner = true;
                    curTile.ownerType = 2;
                    break;
                }
                case 3: {
                    boolean foundCustomColor;
                    if (nearbyCities.get(maxCultureIndex).getOwner() > -1) {
                        curTile.owner = nearbyCities.get(maxCultureIndex).getOwner();
                        if (this.hasCustomPlayerData) {
                            int civIndex = this.player.get((int)nearbyCities.get((int)maxCultureIndex).getOwner()).civ;
                            if (this.player.get((int)curTile.owner).customCivData == 1) {
                                curTile.borderColor = this.player.get((int)curTile.owner).color;
                                foundCustomColor = true;
                                break;
                            }
                            if (this.player.get((int)curTile.owner).civ > -1) {
                                curTile.borderColor = this.civilization.get(civIndex).getDefaultColor();
                            } else {
                                curTile.borderColor = 31 - nearbyCities.get(maxCultureIndex).getOwner();
                                break;
                            }
                        }
                        curTile.definiteOwner = true;
                        curTile.ownerType = 3;
                        break;
                    }
                    this.logger.warn("Warning! " + curTile.xPos + ", " + curTile.yPos);
                    curTile.owner = -1 * this.player.get((int)nearbyCities.get((int)maxCultureIndex).getOwner()).civ;
                    curTile.definiteOwner = false;
                    curTile.borderColor = 32 - nearbyCities.get(maxCultureIndex).getOwner();
                    break;
                }
                default: {
                    this.logger.warn("City of unrecognized ownership: " + curTile.xPos + ", " + curTile.yPos);
                }
            }
        }
        return nearbyTime;
    }

    private void calculateInfluenceOfCity(int i) {
        int j;
        List<TILE> oldTilesInfluenced = this.city.get((int)i).tilesInfluenced;
        this.city.get((int)i).tilesInfluenced = new ArrayList<TILE>();
        ArrayList<Integer> tileIndexes = new ArrayList<Integer>();
        int x = this.city.get(i).getX();
        int y = this.city.get(i).getY();
        int cityCulture = this.city.get(i).getCulture();
        if (cityCulture == 0) {
            ++cityCulture;
        }
        int[] levelX = new int[13];
        if (cityCulture > 0) {
            levelX[5] = levelX[5] + 3;
            levelX[6] = levelX[6] + 3;
            levelX[7] = levelX[7] + 3;
            cityCulture /= 10;
        }
        if (cityCulture > 0) {
            levelX[4] = levelX[4] + 3;
            levelX[5] = levelX[5] + 2;
            levelX[6] = levelX[6] + 2;
            levelX[7] = levelX[7] + 2;
            levelX[8] = levelX[8] + 3;
            cityCulture /= 10;
        }
        if (cityCulture > 0) {
            levelX[3] = levelX[3] + 3;
            levelX[4] = levelX[4] + 2;
            levelX[5] = levelX[5] + 2;
            levelX[6] = levelX[6] + 2;
            levelX[7] = levelX[7] + 2;
            levelX[8] = levelX[8] + 2;
            levelX[9] = levelX[9] + 3;
            cityCulture /= 10;
        }
        if (cityCulture > 0) {
            levelX[2] = levelX[2] + 3;
            levelX[3] = levelX[3] + 4;
            levelX[4] = levelX[4] + 2;
            levelX[5] = levelX[5] + 2;
            levelX[6] = levelX[6] + 2;
            levelX[7] = levelX[7] + 2;
            levelX[8] = levelX[8] + 2;
            levelX[9] = levelX[9] + 4;
            levelX[10] = levelX[10] + 3;
            cityCulture /= 10;
        }
        if (cityCulture > 0) {
            levelX[1] = levelX[1] + 3;
            levelX[2] = levelX[2] + 4;
            levelX[3] = levelX[3] + 2;
            levelX[4] = levelX[4] + 2;
            levelX[5] = levelX[5] + 2;
            levelX[6] = levelX[6] + 2;
            levelX[7] = levelX[7] + 2;
            levelX[8] = levelX[8] + 2;
            levelX[9] = levelX[9] + 2;
            levelX[10] = levelX[10] + 4;
            levelX[11] = levelX[11] + 3;
            cityCulture /= 10;
        }
        if (cityCulture > 0) {
            levelX[0] = levelX[0] + 5;
            levelX[1] = levelX[1] + 6;
            levelX[2] = levelX[2] + 4;
            levelX[3] = levelX[3] + 2;
            levelX[4] = levelX[4] + 4;
            levelX[5] = levelX[5] + 2;
            levelX[6] = levelX[6] + 2;
            levelX[7] = levelX[7] + 2;
            levelX[8] = levelX[8] + 4;
            levelX[9] = levelX[9] + 2;
            levelX[10] = levelX[10] + 4;
            levelX[11] = levelX[11] + 6;
            levelX[12] = levelX[12] + 5;
            cityCulture /= 10;
        }
        for (j = 0; j < 13; ++j) {
            int offset = 6 - j;
            int centerX = x - offset;
            int centerY = y - offset;
            if (levelX[j] != 0) {
                if (this.ok(centerX, centerY)) {
                    tileIndexes.add(this.calculateTileIndex(centerX, centerY));
                    this.city.get((int)i).tilesInfluenced.add(this.tile.get(this.calculateTileIndex(centerX, centerY)));
                }
                int n = j;
                levelX[n] = levelX[n] - 1;
            }
            int distOut = 1;
            while (levelX[j] > 0) {
                if (this.ok(centerX - distOut, centerY + distOut)) {
                    tileIndexes.add(this.calculateTileIndex(centerX - distOut, centerY + distOut));
                    this.city.get((int)i).tilesInfluenced.add(this.tile.get(this.calculateTileIndex(centerX - distOut, centerY + distOut)));
                }
                if (this.ok(centerX + distOut, centerY - distOut)) {
                    tileIndexes.add(this.calculateTileIndex(centerX + distOut, centerY - distOut));
                    this.city.get((int)i).tilesInfluenced.add(this.tile.get(this.calculateTileIndex(centerX + distOut, centerY - distOut)));
                }
                ++distOut;
                int n = j;
                levelX[n] = levelX[n] - 2;
            }
        }
        for (j = 0; j < oldTilesInfluenced.size(); ++j) {
            oldTilesInfluenced.get((int)j).citiesWithInfluence.remove((Object)i);
        }
        for (j = 0; j < tileIndexes.size(); ++j) {
            this.tile.get((int)((Integer)tileIndexes.get((int)j)).intValue()).citiesWithInfluence.add(i);
        }
    }

    private void calculateInfluenceOfCities() {
        for (int i = 0; i < this.city.size(); ++i) {
            this.calculateInfluenceOfCity(i);
        }
    }

    private void calculateInfluenceOfCitiez() {
        for (int i = 0; i < this.city.size(); ++i) {
            ArrayList<TILE> tilesInfluenced = new ArrayList<TILE>();
            ArrayList<Integer> tileIndexes = new ArrayList<Integer>();
            int x = this.city.get(i).getX();
            int y = this.city.get(i).getY();
            int cityCulture = this.city.get(i).getCulture();
            if (cityCulture == 0) {
                ++cityCulture;
            }
            this.tile.get((int)this.calculateTileIndex((int)x, (int)y)).citiesWithInfluence.add(i);
            tilesInfluenced.add(this.tile.get(this.calculateTileIndex(x, y)));
            tileIndexes.add(this.calculateTileIndex(x, y));
            if (this.okX(x - 2)) {
                this.tile.get((int)this.calculateTileIndex((int)(x - 2), (int)y)).citiesWithInfluence.add(i);
                tilesInfluenced.add(this.tile.get(this.calculateTileIndex(x - 2, y)));
                tileIndexes.add(this.calculateTileIndex(x - 2, y));
            }
            if (this.okX(x + 2)) {
                this.tile.get((int)this.calculateTileIndex((int)(x + 2), (int)y)).citiesWithInfluence.add(i);
                tilesInfluenced.add(this.tile.get(this.calculateTileIndex(x + 2, y)));
                tileIndexes.add(this.calculateTileIndex(x + 2, y));
            }
            if (this.okY(y - 2)) {
                this.tile.get((int)this.calculateTileIndex((int)x, (int)(y - 2))).citiesWithInfluence.add(i);
                tilesInfluenced.add(this.tile.get(this.calculateTileIndex(x, y - 2)));
                tileIndexes.add(this.calculateTileIndex(x, y - 2));
            }
            if (this.okY(y + 2)) {
                this.tile.get((int)this.calculateTileIndex((int)x, (int)(y + 2))).citiesWithInfluence.add(i);
                tilesInfluenced.add(this.tile.get(this.calculateTileIndex(x, y + 2)));
                tileIndexes.add(this.calculateTileIndex(x, y + 2));
            }
            if (this.ok(x + 1, y + 1)) {
                this.tile.get((int)this.calculateTileIndex((int)(x + 1), (int)(y + 1))).citiesWithInfluence.add(i);
                tilesInfluenced.add(this.tile.get(this.calculateTileIndex(x + 1, y + 1)));
                tileIndexes.add(this.calculateTileIndex(x + 1, y + 1));
            }
            if (this.ok(x - 1, y + 1)) {
                this.tile.get((int)this.calculateTileIndex((int)(x - 1), (int)(y + 1))).citiesWithInfluence.add(i);
                tilesInfluenced.add(this.tile.get(this.calculateTileIndex(x - 1, y + 1)));
                tileIndexes.add(this.calculateTileIndex(x - 1, y + 1));
            }
            if (this.ok(x + 1, y - 1)) {
                this.tile.get((int)this.calculateTileIndex((int)(x + 1), (int)(y - 1))).citiesWithInfluence.add(i);
                tilesInfluenced.add(this.tile.get(this.calculateTileIndex(x + 1, y - 1)));
                tileIndexes.add(this.calculateTileIndex(x + 1, y - 1));
            }
            if (this.ok(x - 1, y - 1)) {
                this.tile.get((int)this.calculateTileIndex((int)(x - 1), (int)(y - 1))).citiesWithInfluence.add(i);
                tilesInfluenced.add(this.tile.get(this.calculateTileIndex(x - 1, y - 1)));
                tileIndexes.add(this.calculateTileIndex(x - 1, y - 1));
            }
            cityCulture /= 10;
            while (cityCulture > 0) {
                int j;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Entering next stage of quest");
                }
                int max = tilesInfluenced.size();
                for (j = 0; j < max; ++j) {
                    TILE SW;
                    if (this.ok(this.calculateTilePosition((int)((Integer)tileIndexes.get((int)j)).intValue()).width - 1, this.calculateTilePosition((int)((Integer)tileIndexes.get((int)j)).intValue()).height - 1)) {
                        TILE NW;
                        if (this.logger.isTraceEnabled()) {
                            this.logger.trace("OK to explore NW from " + this.calculateTilePosition((int)((Integer)tileIndexes.get((int)j)).intValue()).width + ", " + this.calculateTilePosition((int)((Integer)tileIndexes.get((int)j)).intValue()).height);
                        }
                        if (!tilesInfluenced.contains(NW = this.tile.get(this.calculateTileIndex(this.calculateTilePosition((int)((Integer)tileIndexes.get((int)j)).intValue()).width - 1, this.calculateTilePosition((int)((Integer)tileIndexes.get((int)j)).intValue()).height - 1)))) {
                            tileIndexes.add(this.calculateTileIndex(this.calculateTilePosition((int)((Integer)tileIndexes.get((int)j)).intValue()).width - 1, this.calculateTilePosition((int)((Integer)tileIndexes.get((int)j)).intValue()).height - 1));
                            tilesInfluenced.add(NW);
                        }
                    }
                    if (this.ok(this.calculateTilePosition((int)((Integer)tileIndexes.get((int)j)).intValue()).width + 1, this.calculateTilePosition((int)((Integer)tileIndexes.get((int)j)).intValue()).height - 1)) {
                        TILE NE;
                        if (this.logger.isTraceEnabled()) {
                            this.logger.trace("OK to explore NE from " + this.calculateTilePosition((int)((Integer)tileIndexes.get((int)j)).intValue()).width + ", " + this.calculateTilePosition((int)((Integer)tileIndexes.get((int)j)).intValue()).height);
                        }
                        if (!tilesInfluenced.contains(NE = this.tile.get(this.calculateTileIndex(this.calculateTilePosition((int)((Integer)tileIndexes.get((int)j)).intValue()).width + 1, this.calculateTilePosition((int)((Integer)tileIndexes.get((int)j)).intValue()).height - 1)))) {
                            tileIndexes.add(this.calculateTileIndex(this.calculateTilePosition((int)((Integer)tileIndexes.get((int)j)).intValue()).width + 1, this.calculateTilePosition((int)((Integer)tileIndexes.get((int)j)).intValue()).height - 1));
                            tilesInfluenced.add(NE);
                        }
                    }
                    if (this.ok(this.calculateTilePosition((int)((Integer)tileIndexes.get((int)j)).intValue()).width + 1, this.calculateTilePosition((int)((Integer)tileIndexes.get((int)j)).intValue()).height + 1)) {
                        TILE SE;
                        if (this.logger.isTraceEnabled()) {
                            this.logger.trace("OK to explore SE from " + this.calculateTilePosition((int)((Integer)tileIndexes.get((int)j)).intValue()).width + ", " + this.calculateTilePosition((int)((Integer)tileIndexes.get((int)j)).intValue()).height);
                        }
                        if (!tilesInfluenced.contains(SE = this.tile.get(this.calculateTileIndex(this.calculateTilePosition((int)((Integer)tileIndexes.get((int)j)).intValue()).width + 1, this.calculateTilePosition((int)((Integer)tileIndexes.get((int)j)).intValue()).height + 1)))) {
                            tileIndexes.add(this.calculateTileIndex(this.calculateTilePosition((int)((Integer)tileIndexes.get((int)j)).intValue()).width + 1, this.calculateTilePosition((int)((Integer)tileIndexes.get((int)j)).intValue()).height + 1));
                            tilesInfluenced.add(SE);
                        }
                    }
                    if (!this.ok(this.calculateTilePosition((int)((Integer)tileIndexes.get((int)j)).intValue()).width - 1, this.calculateTilePosition((int)((Integer)tileIndexes.get((int)j)).intValue()).height + 1)) continue;
                    if (this.logger.isTraceEnabled()) {
                        this.logger.trace("OK to explore SW from " + this.calculateTilePosition((int)((Integer)tileIndexes.get((int)j)).intValue()).width + ", " + this.calculateTilePosition((int)((Integer)tileIndexes.get((int)j)).intValue()).height);
                    }
                    if (tilesInfluenced.contains(SW = this.tile.get(this.calculateTileIndex(this.calculateTilePosition((int)((Integer)tileIndexes.get((int)j)).intValue()).width - 1, this.calculateTilePosition((int)((Integer)tileIndexes.get((int)j)).intValue()).height + 1)))) continue;
                    tileIndexes.add(this.calculateTileIndex(this.calculateTilePosition((int)((Integer)tileIndexes.get((int)j)).intValue()).width - 1, this.calculateTilePosition((int)((Integer)tileIndexes.get((int)j)).intValue()).height + 1));
                    tilesInfluenced.add(SW);
                }
                for (j = 0; j < tilesInfluenced.size(); ++j) {
                    if (this.tile.get((int)((Integer)tileIndexes.get((int)j)).intValue()).citiesWithInfluence.contains(i)) continue;
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Influenced index: " + tileIndexes.get(j));
                        this.logger.debug("City " + this.city.get(i).getName() + " at " + this.city.get(i).getX() + ", " + this.city.get(i).getY() + " influences tile at " + this.calculateTilePosition((int)((Integer)tileIndexes.get((int)j)).intValue()).width + ", " + this.calculateTilePosition((int)((Integer)tileIndexes.get((int)j)).intValue()).height);
                    }
                    this.tile.get((int)((Integer)tileIndexes.get((int)j)).intValue()).citiesWithInfluence.add(i);
                }
                cityCulture /= 10;
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug("Culture remaining: " + cityCulture);
            }
        }
    }

    private List<CITY> findNearestCities(int x, int y) {
        ArrayList<CITY> influencingCities = new ArrayList<CITY>();
        TILE startTile = this.tile.get(this.calculateTileIndex(x, y));
        for (int i = 0; i < startTile.citiesWithInfluence.size(); ++i) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Tile at " + x + ", " + y + " is influenced by " + this.city.get(startTile.citiesWithInfluence.get(i)).getName());
            }
            if (this.city.get(startTile.citiesWithInfluence.get(i)).getX() != x || this.city.get(startTile.citiesWithInfluence.get(i)).getY() != y) continue;
            influencingCities.add(this.city.get(startTile.citiesWithInfluence.get(i)));
            return influencingCities;
        }
        ArrayList<TILE> tilesChecked = new ArrayList<TILE>();
        ArrayList<Integer> tileIndexes = new ArrayList<Integer>();
        tilesChecked.add(startTile);
        tileIndexes.add(this.calculateTileIndex(x, y));
        if (this.okX(x - 2)) {
            tilesChecked.add(this.tile.get(this.calculateTileIndex(x - 2, y)));
            tileIndexes.add(this.calculateTileIndex(x - 2, y));
        }
        if (this.okX(x + 2)) {
            tilesChecked.add(this.tile.get(this.calculateTileIndex(x + 2, y)));
            tileIndexes.add(this.calculateTileIndex(x + 2, y));
        }
        if (this.okY(y - 2)) {
            tilesChecked.add(this.tile.get(this.calculateTileIndex(x, y - 2)));
            tileIndexes.add(this.calculateTileIndex(x, y - 2));
        }
        if (this.okY(y + 2)) {
            tilesChecked.add(this.tile.get(this.calculateTileIndex(x, y + 2)));
            tileIndexes.add(this.calculateTileIndex(x, y + 2));
        }
        if (this.ok(x + 1, y + 1)) {
            tilesChecked.add(this.tile.get(this.calculateTileIndex(x + 1, y + 1)));
            tileIndexes.add(this.calculateTileIndex(x + 1, y + 1));
        }
        if (this.ok(x - 1, y + 1)) {
            tilesChecked.add(this.tile.get(this.calculateTileIndex(x - 1, y + 1)));
            tileIndexes.add(this.calculateTileIndex(x - 1, y + 1));
        }
        if (this.ok(x + 1, y - 1)) {
            tilesChecked.add(this.tile.get(this.calculateTileIndex(x + 1, y - 1)));
            tileIndexes.add(this.calculateTileIndex(x + 1, y - 1));
        }
        if (this.ok(x - 1, y - 1)) {
            tilesChecked.add(this.tile.get(this.calculateTileIndex(x - 1, y - 1)));
            tileIndexes.add(this.calculateTileIndex(x - 1, y - 1));
        }
        for (int j = 1; j < tilesChecked.size(); ++j) {
            for (int i = 0; i < ((TILE)tilesChecked.get((int)j)).citiesWithInfluence.size(); ++i) {
                CITY thisCity;
                Dimension location = this.calculateTilePosition((Integer)tileIndexes.get(j));
                int xPos = location.width;
                int yPos = location.height;
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace("j: " + j + "   i: " + i);
                }
                if ((thisCity = this.city.get(((TILE)tilesChecked.get((int)j)).citiesWithInfluence.get(i))).getX() != xPos || thisCity.getY() != yPos) continue;
                influencingCities.add(thisCity);
            }
        }
        if (influencingCities.size() > 0) {
            return influencingCities;
        }
        int radius = 2;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("x: " + x + "; y: " + y);
        }
        int startSearch = 1;
        while (true) {
            int j;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(radius);
            }
            int max = tilesChecked.size();
            for (j = startSearch; j < max; ++j) {
                TILE SW;
                TILE SE;
                TILE NE;
                int index;
                TILE NW;
                Dimension location = this.calculateTilePosition((Integer)tileIndexes.get(j));
                int tileX = location.width;
                int tileY = location.height;
                if (this.ok(tileX - 1, tileY - 1) && !tilesChecked.contains(NW = this.tile.get(index = this.calculateTileIndex(tileX - 1, tileY - 1)))) {
                    tileIndexes.add(index);
                    tilesChecked.add(NW);
                }
                if (this.ok(tileX + 1, tileY - 1) && !tilesChecked.contains(NE = this.tile.get(index = this.calculateTileIndex(tileX + 1, tileY - 1)))) {
                    tileIndexes.add(index);
                    tilesChecked.add(NE);
                }
                if (this.ok(tileX + 1, tileY + 1) && !tilesChecked.contains(SE = this.tile.get(index = this.calculateTileIndex(tileX + 1, tileY + 1)))) {
                    tileIndexes.add(index);
                    tilesChecked.add(SE);
                }
                if (!this.ok(tileX - 1, tileY + 1) || tilesChecked.contains(SW = this.tile.get(index = this.calculateTileIndex(tileX - 1, tileY + 1)))) continue;
                tileIndexes.add(index);
                tilesChecked.add(SW);
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Tiles checked: " + tilesChecked.size());
            }
            for (j = max; j < tilesChecked.size(); ++j) {
                for (int i = 0; i < ((TILE)tilesChecked.get((int)j)).citiesWithInfluence.size(); ++i) {
                    int xPos = this.calculateTilePosition((int)((Integer)tileIndexes.get((int)j)).intValue()).width;
                    int yPos = this.calculateTilePosition((int)((Integer)tileIndexes.get((int)j)).intValue()).height;
                    CITY thisCity = this.city.get(((TILE)tilesChecked.get((int)j)).citiesWithInfluence.get(i));
                    if (thisCity.getX() != xPos || thisCity.getY() != yPos || !startTile.citiesWithInfluence.contains(((TILE)tilesChecked.get((int)j)).citiesWithInfluence.get(i))) continue;
                    influencingCities.add(thisCity);
                }
            }
            if (influencingCities.size() > 0) {
                return influencingCities;
            }
            if (++radius > 7) {
                this.logger.warn("Hit max for " + x + ", " + y);
                return influencingCities;
            }
            startSearch = max;
        }
    }

    private int calculateTileIndex(Dimension dim) {
        return this.calculateTileIndex(dim.width, dim.height);
    }

    public int calculateTileIndex(int xPos, int yPos) {
        if (yPos >= this.worldMap.get((int)0).height || yPos < 0) {
            return -1;
        }
        if (xPos >= this.worldMap.get((int)0).width) {
            xPos -= this.worldMap.get((int)0).width;
        }
        if (xPos < 0) {
            xPos += this.worldMap.get((int)0).width;
        }
        int index = 0;
        index += yPos / 2 * this.worldMap.get((int)0).width;
        if (yPos % 2 == 1) {
            index += this.worldMap.get((int)0).width / 2;
        }
        return index += xPos / 2;
    }

    public ArrayList<Integer> getSurroundingTiles(int x, int y) {
        int northWest;
        int west;
        int southWest;
        int south;
        int southEast;
        int east;
        int northEast;
        ArrayList<Integer> tiles = new ArrayList<Integer>(0);
        int north = this.calculateTileIndex(x, y - 2);
        if (north != -1) {
            tiles.add(north);
        }
        if ((northEast = this.calculateTileIndex(x + 1, y - 1)) != -1) {
            tiles.add(northEast);
        }
        if ((east = this.calculateTileIndex(x + 2, y)) != -1) {
            tiles.add(east);
        }
        if ((southEast = this.calculateTileIndex(x + 1, y + 1)) != -1) {
            tiles.add(southEast);
        }
        if ((south = this.calculateTileIndex(x, y + 2)) != -1) {
            tiles.add(south);
        }
        if ((southWest = this.calculateTileIndex(x - 1, y + 1)) != -1) {
            tiles.add(southWest);
        }
        if ((west = this.calculateTileIndex(x - 2, y)) != -1) {
            tiles.add(west);
        }
        if ((northWest = this.calculateTileIndex(x - 1, y - 1)) != -1) {
            tiles.add(northWest);
        }
        return tiles;
    }

    public ArrayList<Integer> getNorthNENW(int x, int y) {
        int northWest;
        int northEast;
        ArrayList<Integer> tiles = new ArrayList<Integer>(0);
        int north = this.calculateTileIndex(x, y - 2);
        if (north != -1) {
            tiles.add(north);
        }
        if ((northEast = this.calculateTileIndex(x + 1, y - 1)) != -1) {
            tiles.add(northEast);
        }
        if ((northWest = this.calculateTileIndex(x - 1, y - 1)) != -1) {
            tiles.add(northWest);
        }
        return tiles;
    }

    public Dimension calculateTilePosition(int index) {
        int row = index / (this.worldMap.get((int)0).width / 2);
        int column = index % (this.worldMap.get((int)0).width / 2) * 2;
        if (row % 2 == 1) {
            ++column;
        }
        return new Dimension(column, row);
    }

    private boolean okX(int x) {
        return x < this.worldMap.get((int)0).width && x >= 0;
    }

    private boolean okY(int y) {
        return y < this.worldMap.get((int)0).height && y >= 0;
    }

    public boolean ok(int x, int y) {
        return this.okX(x) && this.okY(y);
    }

    public void createMap(int width, int height, int baseTerrId) {
        this.tile = new ArrayList<TILE>();
        this.logger.info("Adding " + width * height / 2 + " tiles");
        int tileIndex = 0;
        for (int y = 0; y < height; ++y) {
            int x;
            int n = x = y % 2 == 0 ? 0 : 1;
            while (x < width) {
                TILE newTile = new TILE(this, baseTerrId);
                newTile.xPos = x;
                newTile.yPos = y;
                newTile.index = tileIndex++;
                this.tile.add(newTile);
                x += 2;
            }
        }
        WMAP wmap = new WMAP(this);
        wmap.width = width;
        wmap.height = height;
        wmap.questionMark1 = (int)(0.7 * (double)height);
        wmap.numResources = this.resource.size();
        for (int i = 0; i < wmap.numResources; ++i) {
            wmap.resourceOccurence.add(0);
        }
        wmap.dataLength += wmap.numResources * 4;
        wmap.flags = 5;
        wmap.extractEnglish();
        wmap.numCivs = 8;
        this.continent = new ArrayList<CONT>();
        this.continent.add(new CONT(this));
        this.city = new ArrayList<CITY>();
        this.colony = new ArrayList<CLNY>();
        this.mapUnit = new ArrayList<UNIT>();
        this.worldCharacteristic = new ArrayList<WCHR>();
        this.worldCharacteristic.add(new WCHR(this));
        this.worldMap = new ArrayList<WMAP>();
        this.worldMap.add(wmap);
        this.startingLocation = new ArrayList<SLOC>();
        this.numWorldCharacteristics = 1;
        this.numWorldMaps = 1;
        this.numTiles = width * height / 2;
        this.hasCustomMap = true;
        this.logger.info("Added map");
    }

    private void setCurrentCharset(String currentCharset) {
        this.currentCharset = currentCharset;
    }

    public void setLanguage(String language) {
        if (languageToCharsetMap.containsKey(language)) {
            // empty if block
        }
        this.setCurrentCharset(languageToCharsetMap.get(language));
    }

    public PediaIconsFile getPediaIcons() {
        return this.pediaIcons;
    }

    public void setPediaIcons(PediaIconsFile file) {
        this.pediaIcons = file;
    }

    static {
        pathToBin = "";
        languageToCharsetMap = new HashMap<String, String>(4, 1.0f);
        languageToCharsetMap.put("English", "Windows-1252");
        languageToCharsetMap.put("Russian", "Windows-1251");
        languageToCharsetMap.put("Chinese", "GBK");
    }
}

