/*
 * Decompiled with CFR 0.152.
 */
package com.civfanatics.civ3.biqFile;

import com.civfanatics.civ3.biqFile.BIQSection;
import com.civfanatics.civ3.biqFile.IO;
import com.civfanatics.civ3.biqFile.PRTO;
import com.civfanatics.civ3.biqFile.TECH;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class LEAD
extends BIQSection {
    Logger logger = Logger.getLogger(this.getClass());
    public static final int CIV_ANY = -3;
    public static final int CIV_RANDOM = -2;
    public int customCivData;
    public int humanPlayer;
    public String leaderName = "";
    public int questionMark1;
    public int questionMark2;
    public int numberOfDifferentStartUnits;
    private Map<PRTO, Integer> startUnitsByType = new HashMap<PRTO, Integer>();
    private Map<Integer, Integer> startUnitsByTypeInt = new HashMap<Integer, Integer>();
    public int genderOfLeaderName;
    public int numberOfStartingTechnologies;
    ArrayList<Integer> startingTechnologyInt = new ArrayList();
    private ArrayList<TECH> startingTechnology = new ArrayList();
    public int difficulty = -1;
    public int initialEra;
    public int startCash = 10;
    public int government = 1;
    public int civ = -3;
    public int color;
    public int skipFirstTurn;
    public int questionMark3;
    byte startEmbassies;

    public LEAD(IO baselink) {
        super(baselink);
        this.startUnitsByType.put(this.baseLink.unit.get(0), 1);
        this.startUnitsByType.put(this.baseLink.unit.get(1), 1);
    }

    public void trim() {
        this.leaderName = this.leaderName.trim();
    }

    public int getDataLength() {
        return 93 + this.startUnitsByType.size() * 8 + this.startingTechnology.size() * 4;
    }

    public int getCustomCivData() {
        return this.customCivData;
    }

    public int getHumanPlayer() {
        return this.humanPlayer;
    }

    public String getLeaderName() {
        return this.leaderName;
    }

    public int getQuestionMark1() {
        return this.questionMark1;
    }

    public int getQuestionMark2() {
        return this.questionMark2;
    }

    public int getGenderOfLeaderName() {
        return this.genderOfLeaderName;
    }

    public int getNumberOfStartingTechnologies() {
        return this.startingTechnologyInt.size();
    }

    public void setStartingTechLinks() {
        this.startingTechnology.clear();
        for (int i = 0; i < this.startingTechnologyInt.size(); ++i) {
            this.startingTechnology.add(this.baseLink.technology.get(this.startingTechnologyInt.get(i)));
        }
    }

    public void updateStartingTechIndices() {
        this.startingTechnologyInt.clear();
        for (TECH tech : this.startingTechnology) {
            this.startingTechnologyInt.add(tech.getIndex());
        }
    }

    public void changeStartingTechnologies(int[] selectedTechs) {
        this.startingTechnologyInt.clear();
        for (int i = 0; i < selectedTechs.length; ++i) {
            this.startingTechnologyInt.add(selectedTechs[i]);
        }
        this.setStartingTechLinks();
    }

    public int[] getStartingTechs() {
        int[] startingTechs = new int[this.startingTechnologyInt.size()];
        for (int i = 0; i < this.startingTechnologyInt.size(); ++i) {
            startingTechs[i] = this.startingTechnologyInt.get(i);
        }
        return startingTechs;
    }

    public int getDifficulty() {
        return this.difficulty;
    }

    public int getInitialEra() {
        return this.initialEra;
    }

    public int getStartCash() {
        return this.startCash;
    }

    public int getGovernment() {
        return this.government;
    }

    public int getCiv() {
        return this.civ;
    }

    public int getColor() {
        return this.color;
    }

    public int getSkipFirstTurn() {
        return this.skipFirstTurn;
    }

    public int getQuestionMark3() {
        return this.questionMark3;
    }

    public byte getStartEmbassies() {
        return this.startEmbassies;
    }

    public void addStartingUnitType(PRTO type, Integer number) {
        this.startUnitsByType.put(type, number);
    }

    void addStartingUnitType(Integer type, Integer number) {
        this.startUnitsByTypeInt.put(type, number);
    }

    public Map<PRTO, Integer> getStartingUnits() {
        return Collections.unmodifiableMap(this.startUnitsByType);
    }

    public Integer getNumOfStartingUnitByType(PRTO type) {
        if (!this.startUnitsByType.containsKey(type)) {
            return 0;
        }
        return this.startUnitsByType.get(type);
    }

    public void updateStartUnitCount(PRTO type, Integer number) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Updating unit count for " + type.getName() + " to " + number);
        }
        if (number == 0) {
            this.startUnitsByType.remove(type);
        } else {
            this.startUnitsByType.put(type, number);
        }
    }

    public void handleDeletedTech(int index) {
        for (int i = 0; i < this.startingTechnology.size(); ++i) {
            if (this.startingTechnology.get(i).getIndex() != -1) continue;
            this.startingTechnology.remove(i);
            break;
        }
        this.updateStartingTechIndices();
    }

    public void handleDeletedUnit(PRTO prto) {
        this.startUnitsByType.remove(prto);
    }

    public void setCustomCivData(int customCivData) {
        this.customCivData = customCivData;
    }

    public void setHumanPlayer(int humanPlayer) {
        this.humanPlayer = humanPlayer;
    }

    public void setLeaderName(String leaderName) {
        this.leaderName = leaderName;
    }

    public void setQuestionMark1(int questionMark1) {
        this.questionMark1 = questionMark1;
    }

    public void setQuestionMark2(int questionMark2) {
        this.questionMark2 = questionMark2;
    }

    public void setGenderOfLeaderName(int genderOfLeaderName) {
        this.genderOfLeaderName = genderOfLeaderName;
    }

    public void setDifficulty(int difficulty) {
        this.difficulty = difficulty;
    }

    public void setInitialEra(int initialEra) {
        this.initialEra = initialEra;
    }

    public void setStartCash(int startCash) {
        this.startCash = startCash;
    }

    public void setGovernment(int government) {
        this.government = government;
    }

    public void setCiv(int civ) {
        this.civ = civ;
    }

    public void setColor(int color) {
        this.color = color;
    }

    public void setSkipFirstTurn(int skipFirstTurn) {
        this.skipFirstTurn = skipFirstTurn;
    }

    public void setQuestionMark3(int questionMark3) {
        this.questionMark3 = questionMark3;
    }

    public void setStartEmbassies(byte startEmbassies) {
        this.startEmbassies = startEmbassies;
    }

    @Override
    public String toEnglish() {
        String lineReturn = System.getProperty("line.separator");
        String toReturn = "dataLength: " + this.getDataLength() + lineReturn;
        toReturn = toReturn + "customCivData: " + this.trueOrFalse(this.customCivData) + lineReturn;
        toReturn = toReturn + "humanPlayer: " + this.trueOrFalse(this.humanPlayer) + lineReturn;
        toReturn = toReturn + "leaderName: " + this.leaderName + lineReturn;
        toReturn = toReturn + "questionMark1: " + this.questionMark1 + lineReturn;
        toReturn = toReturn + "questionMark2: " + this.questionMark2 + lineReturn;
        toReturn = toReturn + "numberOfDifferentStartUnits: " + this.numberOfDifferentStartUnits + lineReturn;
        for (Map.Entry<PRTO, Integer> entry : this.startUnitsByType.entrySet()) {
            toReturn = toReturn + "starting units of type " + entry.getKey().getName() + ": " + entry.getValue() + lineReturn;
        }
        if (this.genderOfLeaderName == 0) {
            toReturn = toReturn + "genderOfLeaderName: Male" + lineReturn;
        } else if (this.genderOfLeaderName == 1) {
            toReturn = toReturn + "genderOfLeaderName: Female" + lineReturn;
        }
        toReturn = toReturn + "numberOfStartingTechnologies: " + this.numberOfStartingTechnologies + lineReturn;
        for (int j = 0; j < this.numberOfStartingTechnologies; ++j) {
            toReturn = toReturn + "startingTechnology: " + this.baseLink.technology.get(this.startingTechnologyInt.get(j)).getName() + lineReturn;
        }
        toReturn = this.difficulty == -2 ? toReturn + "difficulty: Any" + lineReturn : toReturn + "difficulty: " + this.baseLink.difficulties.get(this.difficulty).getName() + lineReturn;
        toReturn = this.initialEra < 4 ? toReturn + "initialEra: " + this.baseLink.eras.get(this.initialEra).getName() + lineReturn : toReturn + "initialEra: Future Erea" + lineReturn;
        toReturn = toReturn + "startCash: " + this.startCash + lineReturn;
        toReturn = toReturn + "government: " + this.baseLink.government.get(this.government).getName() + lineReturn;
        if (this.civ > -1) {
            toReturn = toReturn + "civ: " + this.baseLink.civilization.get(this.civ).getName() + lineReturn;
        } else if (this.civ == -3) {
            toReturn = toReturn + "civ: Any" + lineReturn;
        } else if (this.civ == -2) {
            toReturn = toReturn + "civ: Random" + lineReturn;
        }
        toReturn = toReturn + "color: " + this.color + lineReturn;
        toReturn = toReturn + "skipFirstTurn: " + this.trueOrFalse(this.skipFirstTurn) + lineReturn;
        toReturn = toReturn + "questionMark3: " + this.questionMark3 + lineReturn;
        toReturn = toReturn + "startEmbassies: " + this.trueOrFalse(this.startEmbassies) + lineReturn;
        toReturn = toReturn + lineReturn;
        return toReturn;
    }

    @Override
    public String toString() {
        String lineReturn = System.getProperty("line.separator");
        String toReturn = "dataLength: " + this.getDataLength() + lineReturn;
        toReturn = toReturn + "customCivData: " + this.customCivData + lineReturn;
        toReturn = toReturn + "humanPlayer: " + this.humanPlayer + lineReturn;
        toReturn = toReturn + "leaderName: " + this.leaderName + lineReturn;
        toReturn = toReturn + "questionMark1: " + this.questionMark1 + lineReturn;
        toReturn = toReturn + "questionMark2: " + this.questionMark2 + lineReturn;
        toReturn = toReturn + "numberOfDifferentStartUnits: " + this.numberOfDifferentStartUnits + lineReturn;
        for (Map.Entry<PRTO, Integer> entry : this.startUnitsByType.entrySet()) {
            toReturn = toReturn + "starting units of type " + entry.getKey().getIndex() + ": " + entry.getValue() + lineReturn;
        }
        toReturn = toReturn + "genderOfLeaderName: " + this.genderOfLeaderName + lineReturn;
        toReturn = toReturn + "numberOfStartingTechnologies: " + this.numberOfStartingTechnologies + lineReturn;
        for (int j = 0; j < this.numberOfStartingTechnologies; ++j) {
            toReturn = toReturn + "startingTechnology: " + this.startingTechnologyInt.get(j) + lineReturn;
        }
        toReturn = toReturn + "difficulty: " + this.difficulty + lineReturn;
        toReturn = toReturn + "initialEra: " + this.initialEra + lineReturn;
        toReturn = toReturn + "startCash: " + this.startCash + lineReturn;
        toReturn = toReturn + "government: " + this.government + lineReturn;
        toReturn = toReturn + "civ: " + this.civ + lineReturn;
        toReturn = toReturn + "color: " + this.color + lineReturn;
        toReturn = toReturn + "skipFirstTurn: " + this.skipFirstTurn + lineReturn;
        toReturn = toReturn + "questionMark3: " + this.questionMark3 + lineReturn;
        toReturn = toReturn + "startEmbassies: " + this.startEmbassies + lineReturn;
        toReturn = toReturn + lineReturn;
        return toReturn;
    }

    @Override
    public String compareTo(BIQSection section, String separator) {
        if (!(section instanceof LEAD)) {
            return null;
        }
        LEAD two = (LEAD)section;
        String lineReturn = System.getProperty("line.separator");
        String toReturn = "civ: " + this.civ + lineReturn;
        if (this.getDataLength() != two.getDataLength()) {
            toReturn = toReturn + "DataLength: " + this.getDataLength() + separator + two.getDataLength() + lineReturn;
        }
        if (this.customCivData != two.getCustomCivData()) {
            toReturn = toReturn + "CustomCivData: " + this.customCivData + separator + two.getCustomCivData() + lineReturn;
        }
        if (this.humanPlayer != two.getHumanPlayer()) {
            toReturn = toReturn + "HumanPlayer: " + this.humanPlayer + separator + two.getHumanPlayer() + lineReturn;
        }
        if (this.leaderName.compareTo(two.getLeaderName()) != 0) {
            toReturn = toReturn + "LeaderName: " + this.leaderName + separator + two.getLeaderName() + lineReturn;
        }
        if (this.questionMark1 != two.getQuestionMark1()) {
            toReturn = toReturn + "QuestionMark1: " + this.questionMark1 + separator + two.getQuestionMark1() + lineReturn;
        }
        if (this.questionMark2 != two.getQuestionMark2()) {
            toReturn = toReturn + "QuestionMark2: " + this.questionMark2 + separator + two.getQuestionMark2() + lineReturn;
        }
        if (this.startUnitsByType.size() != two.startUnitsByType.size()) {
            toReturn = toReturn + "NumberOfDifferentStartUnits: " + this.numberOfDifferentStartUnits + separator + two.startUnitsByType.size() + lineReturn;
        }
        if (this.genderOfLeaderName != two.getGenderOfLeaderName()) {
            toReturn = toReturn + "GenderOfLeaderName: " + this.genderOfLeaderName + separator + two.getGenderOfLeaderName() + lineReturn;
        }
        if (this.numberOfStartingTechnologies != two.getNumberOfStartingTechnologies()) {
            toReturn = toReturn + "NumberOfStartingTechnologies: " + this.numberOfStartingTechnologies + separator + two.getNumberOfStartingTechnologies() + lineReturn;
        }
        if (this.difficulty != two.getDifficulty()) {
            toReturn = toReturn + "Difficulty: " + this.difficulty + separator + two.getDifficulty() + lineReturn;
        }
        if (this.initialEra != two.getInitialEra()) {
            toReturn = toReturn + "InitialEra: " + this.initialEra + separator + two.getInitialEra() + lineReturn;
        }
        if (this.startCash != two.getStartCash()) {
            toReturn = toReturn + "StartCash: " + this.startCash + separator + two.getStartCash() + lineReturn;
        }
        if (this.government != two.getGovernment()) {
            toReturn = toReturn + "Government: " + this.government + separator + two.getGovernment() + lineReturn;
        }
        if (this.color != two.getColor()) {
            toReturn = toReturn + "Color: " + this.color + separator + two.getColor() + lineReturn;
        }
        if (this.skipFirstTurn != two.getSkipFirstTurn()) {
            toReturn = toReturn + "SkipFirstTurn: " + this.skipFirstTurn + separator + two.getSkipFirstTurn() + lineReturn;
        }
        if (this.questionMark3 != two.getQuestionMark3()) {
            toReturn = toReturn + "QuestionMark3: " + this.questionMark3 + separator + two.getQuestionMark3() + lineReturn;
        }
        if (this.startEmbassies != two.getStartEmbassies()) {
            toReturn = toReturn + "StartEmbassies: " + this.startEmbassies + separator + two.getStartEmbassies() + lineReturn;
        }
        if (toReturn.equals("civ: " + this.civ + lineReturn)) {
            toReturn = "";
        }
        return toReturn;
    }

    @Override
    public Object getProperty(String string) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }
}

