/*
 * Decompiled with CFR 0.152.
 */
package com.civfanatics.civ3.biqFile;

import com.civfanatics.civ3.biqFile.BIQSection;
import com.civfanatics.civ3.biqFile.GOOD;
import com.civfanatics.civ3.biqFile.IO;
import com.civfanatics.civ3.biqFile.TECH;
import com.civfanatics.civ3.biqFile.civ3Version;
import com.civfanatics.civ3.biqFile.util.LittleEndianDataOutputStream;
import com.civfanatics.civ3.biqFile.util.Utils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;

public class PRTO
extends BIQSection {
    int index;
    Logger logger = Logger.getLogger(this.getClass());
    private int dataLength = 241;
    private int zoneOfControl;
    private String name = "";
    private String civilopediaEntry = "";
    private int bombardStrength;
    private int bombardRange;
    private int capacity;
    private int shieldCost;
    private int defence;
    private int iconIndex;
    private int attack;
    private int operationalRange;
    private int populationCost;
    private int rateOfFire;
    private int movement = 1;
    private int requiredTechInt = -1;
    private TECH requiredTech;
    private int upgradeToInt = -1;
    private PRTO upgradeTo;
    private int requiredResource1Int = -1;
    private int requiredResource2Int = -1;
    private int requiredResource3Int = -1;
    private GOOD requiredResource1;
    private GOOD requiredResource2;
    private GOOD requiredResource3;
    int unitAbilities;
    int AIStrategy;
    int availableTo;
    int standardOrdersSpecialActions;
    int airMissions;
    private int unitClass;
    public static int CLASS_LAND = 0;
    public static int CLASS_SEA = 1;
    public static int CLASS_AIR = 2;
    private int otherStrategy = -1;
    private int hitPointBonus;
    int PTWStandardOrders;
    int PTWSpecialActions;
    int PTWWorkerActions;
    int PTWAirMissions;
    int PTWActionsMix;
    private short unknown;
    private int bombardEffects;
    private byte[] ignoreMovementCost;
    private int requiresSupport;
    private int useExactCost = 7;
    private int telepadRange;
    private int questionMark3 = 1;
    private ArrayList<Integer> legalUnitTelepadsInt;
    private ArrayList<PRTO> legalUnitTelepads;
    private int enslaveResultsInInt = -1;
    private PRTO enslaveResultsIn;
    private int questionMark5 = 1;
    private ArrayList<Integer> stealthTargetsInt;
    private ArrayList<PRTO> stealthTargets;
    private int questionMark6 = 1;
    private ArrayList<Integer> legalBuildingTelepads;
    private byte createsCraters;
    private int workerStrength1;
    private float workerStrengthFloat;
    private int questionMark8 = 0;
    private int airDefence;
    private boolean wheeled;
    private boolean footSoldier;
    private boolean blitz;
    private boolean cruiseMissile;
    private boolean allTerrainAsRoads;
    private boolean radar;
    private boolean amphibiousUnit;
    private boolean invisible;
    private boolean transportsOnlyAirUnits;
    private boolean draftable;
    private boolean immobile;
    private boolean sinksInSea;
    private boolean sinksInOcean;
    private boolean flagUnit;
    private boolean transportsOnlyFootUnits;
    private boolean startsGoldenAge;
    private boolean nuclearWeapon;
    private boolean hiddenNationality;
    private boolean army;
    private boolean leader;
    private boolean infiniteBombardRange;
    private boolean stealth;
    private boolean detectInvisible;
    private boolean tacticalMissile;
    private boolean transportsOnlyTacticalMissiles;
    private boolean rangedAttackAnimations;
    private boolean rotateBeforeAttack;
    private boolean lethalLandBombardment;
    private boolean lethalSeaBombardment;
    private boolean king;
    private boolean requiresEscort;
    private Boolean offence = Boolean.FALSE;
    private Boolean defenceStrategy = false;
    private Boolean artillery = false;
    private Boolean exploreStrategy = false;
    private Boolean armyUnit = false;
    private Boolean cruiseMissileUnit = false;
    private Boolean airBombard = false;
    private Boolean airDefenceStrategy = false;
    private Boolean navalPower = false;
    private Boolean airTransport = false;
    private Boolean navalTransport = false;
    private Boolean navalCarrier = false;
    private Boolean terraform = false;
    private Boolean settle = false;
    private Boolean leaderUnit = false;
    private Boolean tacticalNuke = false;
    private Boolean ICBM = false;
    private Boolean navalMissileTransport = false;
    private Boolean flagStrategy = false;
    private Boolean kingStrategy = false;
    Boolean[] strategies = new Boolean[]{this.offence, this.defenceStrategy, this.artillery, this.exploreStrategy, this.armyUnit, this.cruiseMissileUnit, this.airBombard, this.airDefenceStrategy, this.navalPower, this.airTransport, this.navalTransport, this.navalCarrier, this.terraform, this.settle, this.leaderUnit, this.tacticalNuke, this.ICBM, this.navalMissileTransport, this.flagStrategy, this.kingStrategy};
    public static String[] strategyNames = new String[]{"Offence", "Defence", "Artillery", "Exploration", "Army", "Cruise Missile", "Air Bombard", "Air Defence", "Naval Power", "Air Transport", "Naval Transport", "Naval Carrier", "Terraform", "Settle", "Leader", "Tactical Nuke", "ICBM", "Naval Missile Transport", "Flag Unit", "King Unit"};
    private byte numStrategies;
    private boolean[] availableToArray;
    private boolean skipTurn;
    private boolean wait;
    private boolean fortify;
    private boolean disband;
    private boolean goTo;
    private boolean load;
    private boolean unload;
    private boolean airlift;
    private boolean pillage;
    private boolean bombard;
    private boolean airdrop;
    private boolean buildArmy;
    private boolean finishImprovement;
    private boolean upgrade;
    private boolean buildColony;
    private boolean buildCity;
    private boolean buildRoad;
    private boolean buildRailroad;
    private boolean buildFort;
    private boolean buildMine;
    private boolean irrigate;
    private boolean clearForest;
    private boolean clearJungle;
    private boolean plantForest;
    private boolean clearPollution;
    private boolean automate;
    private boolean joinCity;
    private boolean buildAirfield;
    private boolean buildRadarTower;
    private boolean buildOutpost;
    private boolean buildBarricade;
    private boolean bomb;
    private boolean recon;
    private boolean intercept;
    private boolean rebase;
    private boolean precisionBomb;
    private boolean PTWskipTurn;
    private boolean PTWwait;
    private boolean PTWfortify;
    private boolean PTWdisband;
    private boolean PTWgoTo;
    private boolean PTWexploreOrder;
    private boolean PTWsentry;
    private boolean PTWload;
    private boolean PTWunload;
    private boolean PTWairlift;
    private boolean PTWpillage;
    private boolean PTWbombard;
    private boolean PTWairdrop;
    private boolean PTWbuildArmy;
    private boolean PTWfinishImprovements;
    private boolean PTWupgradeUnit;
    private boolean PTWcapture;
    private boolean telepad;
    private boolean teleportable;
    private boolean stealthAttack;
    private boolean charm;
    private boolean enslave;
    private boolean collateralDamage;
    private boolean sacrifice;
    private boolean scienceAge;
    private boolean PTWbuildColony;
    private boolean PTWbuildCity;
    private boolean PTWbuildRoad;
    private boolean PTWbuildRailroad;
    private boolean PTWbuildFort;
    private boolean PTWbuildMine;
    private boolean PTWirrigate;
    private boolean PTWclearForest;
    private boolean PTWclearJungle;
    private boolean PTWplantForest;
    private boolean PTWclearPollution;
    private boolean PTWautomate;
    private boolean PTWjoinCity;
    private boolean PTWbuildAirfield;
    private boolean PTWbuildRadarTower;
    private boolean PTWbuildOutpost;
    private boolean PTWbuildBarricade;
    private boolean PTWbomb;
    private boolean PTWrecon;
    private boolean PTWintercept;
    private boolean PTWrebase;
    private boolean PTWprecisionBomb;
    private boolean sentryMix;
    private boolean bombardMix;
    private boolean colonyMix;
    private boolean roadMix;
    private boolean railroadMix;
    private boolean road2Mix;
    private boolean irrigateMix;
    private boolean clearForestMix;
    private boolean clearJungleMix;
    private boolean clearPollutionMix;
    private boolean automateMix;
    private boolean automate2Mix;
    private boolean bombingMix;
    private boolean precisionBombingMix;
    private boolean automate3;
    private boolean goToMix;

    public PRTO(IO baselink, int index) {
        this("", baselink, index);
    }

    public PRTO(String name, IO baselink, int index) {
        super(baselink);
        this.name = name;
        this.index = index;
        int numTerrains = baselink.version == civ3Version.CONQUESTS ? 14 : 12;
        this.ignoreMovementCost = new byte[14];
        this.stealthTargetsInt = new ArrayList();
        this.stealthTargets = new ArrayList();
        this.legalUnitTelepadsInt = new ArrayList();
        this.legalUnitTelepads = new ArrayList();
        this.legalBuildingTelepads = new ArrayList();
        this.availableToArray = new boolean[32];
        this.dataLength += numTerrains;
    }

    public PRTO clone() {
        PRTO other = new PRTO(this.baseLink, this.baseLink.unit.size());
        other.zoneOfControl = this.zoneOfControl;
        other.name = this.name;
        other.civilopediaEntry = this.civilopediaEntry;
        other.bombardStrength = this.bombardStrength;
        other.bombardRange = this.bombardRange;
        other.capacity = this.capacity;
        other.shieldCost = this.shieldCost;
        other.defence = this.defence;
        other.iconIndex = this.iconIndex;
        other.attack = this.attack;
        other.operationalRange = this.operationalRange;
        other.populationCost = this.populationCost;
        other.rateOfFire = this.rateOfFire;
        other.movement = this.movement;
        other.requiredTechInt = this.requiredTechInt;
        other.requiredTech = this.requiredTech;
        other.upgradeToInt = this.upgradeToInt;
        other.upgradeTo = this.upgradeTo;
        other.requiredResource1Int = this.requiredResource1Int;
        other.requiredResource2Int = this.requiredResource2Int;
        other.requiredResource3Int = this.requiredResource3Int;
        other.requiredResource1 = this.requiredResource1;
        other.requiredResource2 = this.requiredResource2;
        other.requiredResource3 = this.requiredResource3;
        other.unitAbilities = this.unitAbilities;
        other.AIStrategy = this.AIStrategy;
        other.availableTo = this.availableTo;
        other.standardOrdersSpecialActions = this.standardOrdersSpecialActions;
        other.airMissions = this.airMissions;
        other.unitClass = this.unitClass;
        other.otherStrategy = this.otherStrategy;
        other.hitPointBonus = this.hitPointBonus;
        other.PTWStandardOrders = this.PTWStandardOrders;
        other.PTWSpecialActions = this.PTWSpecialActions;
        other.PTWWorkerActions = this.PTWWorkerActions;
        other.PTWAirMissions = this.PTWAirMissions;
        other.PTWActionsMix = this.PTWActionsMix;
        other.unknown = this.unknown;
        other.bombardEffects = this.bombardEffects;
        other.ignoreMovementCost = new byte[this.ignoreMovementCost.length];
        System.arraycopy(this.ignoreMovementCost, 0, other.ignoreMovementCost, 0, other.ignoreMovementCost.length);
        other.requiresSupport = this.requiresSupport;
        other.useExactCost = this.useExactCost;
        other.telepadRange = this.telepadRange;
        other.questionMark3 = this.questionMark3;
        other.legalUnitTelepadsInt = new ArrayList();
        other.legalUnitTelepadsInt.addAll(this.legalUnitTelepadsInt);
        other.legalUnitTelepads = new ArrayList();
        other.legalUnitTelepads.addAll(this.legalUnitTelepads);
        other.enslaveResultsInInt = this.enslaveResultsInInt;
        other.enslaveResultsIn = this.enslaveResultsIn;
        other.questionMark5 = this.questionMark5;
        other.stealthTargetsInt = new ArrayList();
        other.stealthTargetsInt.addAll(this.stealthTargetsInt);
        other.stealthTargets = new ArrayList();
        other.stealthTargets.addAll(this.stealthTargets);
        other.questionMark6 = this.questionMark6;
        other.legalBuildingTelepads = new ArrayList();
        other.legalBuildingTelepads.addAll(this.legalBuildingTelepads);
        other.createsCraters = this.createsCraters;
        other.workerStrength1 = this.workerStrength1;
        other.workerStrengthFloat = this.workerStrengthFloat;
        other.questionMark8 = this.questionMark8;
        other.airDefence = this.airDefence;
        other.extractEnglish();
        other.dataLength = this.dataLength;
        return other;
    }

    public void trim() {
        this.name = this.name.trim();
        this.civilopediaEntry = this.civilopediaEntry.trim();
    }

    public void setNewUnitDefaults() {
        this.PTWskipTurn = true;
        this.PTWwait = true;
        this.PTWfortify = true;
        this.PTWdisband = true;
        this.PTWgoTo = true;
        this.PTWexploreOrder = true;
        this.PTWsentry = true;
        this.recalculatePTWStandardOrders();
        this.PTWload = true;
        this.PTWairlift = true;
        this.PTWpillage = true;
        this.PTWupgradeUnit = true;
        this.PTWcapture = true;
        this.recalculatePTWSpecialActions();
        this.offence = true;
        this.defenceStrategy = true;
        this.recalculateAIStrategies();
        for (int i = 1; i < 32; ++i) {
            this.availableToArray[i] = true;
        }
        this.recalculateAvailableTo();
    }

    public void setZoneOfControl(int zoneOfControl) {
        this.zoneOfControl = zoneOfControl;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setCivilopediaEntry(String civilopediaEntry) {
        this.civilopediaEntry = civilopediaEntry;
    }

    public void setBombardStrength(int bombardStrength) {
        this.bombardStrength = bombardStrength;
    }

    public void setBombardRange(int bombardRange) {
        this.bombardRange = bombardRange;
    }

    public void setCapacity(int capacity) {
        this.capacity = capacity;
    }

    public void setShieldCost(int shieldCost) {
        this.shieldCost = shieldCost;
    }

    public void setDefence(int defence) {
        this.defence = defence;
    }

    public void setIconIndex(int iconIndex) {
        this.iconIndex = iconIndex;
    }

    public void setAttack(int attack) {
        this.attack = attack;
    }

    public void setOperationalRange(int operationalRange) {
        this.operationalRange = operationalRange;
    }

    public void setPopulationCost(int populationCost) {
        this.populationCost = populationCost;
    }

    public void setRateOfFire(int rateOfFire) {
        this.rateOfFire = rateOfFire;
    }

    public void setMovement(int movement) {
        this.movement = movement;
    }

    public void setRequiredTech(int requiredTech) {
        this.requiredTechInt = requiredTech;
        if (this.baseLink.technology != null && this.requiredTechInt != -1 && this.baseLink.technology.size() > this.requiredTechInt) {
            this.requiredTech = this.baseLink.technology.get(this.requiredTechInt);
        }
    }

    public void setStealthTargetPRTOLinks() {
        this.stealthTargets.clear();
        for (int i = 0; i < this.stealthTargetsInt.size(); ++i) {
            this.stealthTargets.add(this.baseLink.unit.get(this.stealthTargetsInt.get(i)));
        }
    }

    public void setLegalUnitTelepadsPRTOLinks() {
        this.legalUnitTelepads.clear();
        for (int i = 0; i < this.legalUnitTelepadsInt.size(); ++i) {
            this.legalUnitTelepads.add(this.baseLink.unit.get(this.legalUnitTelepadsInt.get(i)));
        }
    }

    public void setUpgradeTo(int upgradeTo) {
        this.upgradeToInt = upgradeTo;
        if (this.baseLink.unit != null && this.upgradeToInt != -1 && this.baseLink.unit.size() > this.upgradeToInt) {
            this.upgradeTo = this.baseLink.unit.get(this.upgradeToInt);
        } else if (this.upgradeToInt == -1) {
            this.upgradeTo = null;
        }
    }

    public void setRequiredResource1(int requiredResource1Int) {
        this.requiredResource1Int = requiredResource1Int;
        if (this.baseLink.resource != null && requiredResource1Int != -1 && this.baseLink.resource.size() > requiredResource1Int) {
            this.requiredResource1 = this.baseLink.resource.get(requiredResource1Int);
        }
    }

    public void setRequiredResource2(int requiredResource2) {
        this.requiredResource2Int = requiredResource2;
        if (this.baseLink.resource != null && this.requiredResource2Int != -1 && this.baseLink.resource.size() > this.requiredResource2Int) {
            this.requiredResource2 = this.baseLink.resource.get(this.requiredResource2Int);
        }
    }

    public void setRequiredResource3(int requiredResource3) {
        this.requiredResource3Int = requiredResource3;
        if (this.baseLink.resource != null && this.requiredResource3Int != -1 && this.baseLink.resource.size() > this.requiredResource3Int) {
            this.requiredResource3 = this.baseLink.resource.get(this.requiredResource3Int);
        }
    }

    public void setUnitAbilities(int unitAbilities) {
        this.unitAbilities = unitAbilities;
    }

    void setAIStrategy(int AIStrategy) {
        this.AIStrategy = AIStrategy;
    }

    public int getAIStrategy() {
        return this.AIStrategy;
    }

    public Boolean[] getAIStrategySet() {
        return this.strategies;
    }

    public void handleSwappedPRTO() {
        this.updateStealthTargetIndices();
        this.updateUnitTelepadIndices();
        if (this.enslaveResultsInInt != -1) {
            this.enslaveResultsInInt = this.enslaveResultsIn.getIndex();
        }
        if (this.upgradeToInt != -1) {
            this.upgradeToInt = this.upgradeTo.getIndex();
        }
    }

    public void handleSwappedGOOD() {
        if (this.requiredResource1Int != -1) {
            this.requiredResource1Int = this.requiredResource1.getIndex();
        }
        if (this.requiredResource2Int != -1) {
            this.requiredResource2Int = this.requiredResource2.getIndex();
        }
        if (this.requiredResource3Int != -1) {
            this.requiredResource3Int = this.requiredResource3.getIndex();
        }
    }

    public void clearAvailableTo() {
        this.availableTo = 0;
    }

    public void setAvailableTo(int index) {
        int add = 1;
        this.availableTo |= (add <<= index);
    }

    public void setUnavailableTo(int index) {
        int add = 1;
        this.availableTo &= ~(add <<= index);
    }

    void setAvailableToBinary(int availableToBinary) {
        this.availableTo = availableToBinary;
    }

    public boolean isAvailableTo(int civIndex) {
        int value = 1;
        return (this.availableTo & (value <<= civIndex)) == value;
    }

    public boolean isUniqueUnit() {
        int trueCount = 0;
        for (int i = 0; i < this.availableToArray.length; ++i) {
            if (this.availableToArray[i]) {
                ++trueCount;
            }
            if (trueCount <= 1) continue;
            return false;
        }
        return trueCount == 1;
    }

    public void setStandardOrdersSpecialActions(int standardOrdersSpecialActions) {
        this.standardOrdersSpecialActions = standardOrdersSpecialActions;
    }

    public void setAirMissions(int airMissions) {
        this.airMissions = airMissions;
    }

    public void setUnitClass(int unitClass) {
        this.unitClass = unitClass;
    }

    public void setOtherStrategy(int otherStrategy) {
        this.otherStrategy = otherStrategy;
    }

    public void setHitPointBonus(int hitPointBonus) {
        this.hitPointBonus = hitPointBonus;
    }

    public void setPTWStandardOrders(int PTWStandardOrders) {
        this.PTWStandardOrders = PTWStandardOrders;
    }

    public void setPTWSpecialActions(int PTWSpecialActions) {
        this.PTWSpecialActions = PTWSpecialActions;
    }

    public void setPTWWorkerActions(int PTWWorkerActions) {
        this.PTWWorkerActions = PTWWorkerActions;
    }

    public void setPTWAirMissions(int PTWAirMissions) {
        this.PTWAirMissions = PTWAirMissions;
    }

    public void setPTWActionsMix(int PTWActionsMix) {
        this.PTWActionsMix = PTWActionsMix;
    }

    public void setUnknown(short unknown) {
        this.unknown = unknown;
    }

    public void setBombardEffects(int bombardEffects) {
        this.bombardEffects = bombardEffects;
    }

    public void setRequiresSupport(int requiresSupport) {
        this.requiresSupport = requiresSupport;
    }

    public void setUseExactCost(int useExactCost) {
        this.useExactCost = useExactCost;
    }

    public void setTelepadRange(int telepadRange) {
        this.telepadRange = telepadRange;
    }

    public void setQuestionMark3(int questionMark3) {
        this.questionMark3 = questionMark3;
    }

    public void setEnslaveResultsIn(int enslaveResultsIn) {
        this.enslaveResultsInInt = enslaveResultsIn;
        if (this.baseLink.unit != null && this.enslaveResultsInInt != -1 && this.baseLink.unit.size() > this.enslaveResultsInInt) {
            this.enslaveResultsIn = this.baseLink.unit.get(this.enslaveResultsInInt);
        }
    }

    public void setQuestionMark5(int questionMark5) {
        this.questionMark5 = questionMark5;
    }

    public void setQuestionMark6(int questionMark6) {
        this.questionMark6 = questionMark6;
    }

    public void setCreatesCraters(byte createsCraters) {
        this.createsCraters = createsCraters;
    }

    public void setWorkerStrength1(int workerStrength1) {
        this.workerStrength1 = workerStrength1;
    }

    public void setWorkerStrengthFloat(float workerStrengthFloat) {
        this.workerStrengthFloat = workerStrengthFloat;
    }

    public void setQuestionMark8(int questionMark8) {
        this.questionMark8 = questionMark8;
    }

    public void setAirDefence(int airDefence) {
        this.airDefence = airDefence;
    }

    public void setOffence(boolean offence) {
        this.offence = offence;
    }

    public void setDefenceStrategy(boolean defenceStrategy) {
        this.defenceStrategy = defenceStrategy;
    }

    public void setArtillery(boolean artillery) {
        this.artillery = artillery;
    }

    public boolean getExploreOrder() {
        if (this.isPTWOrConquests()) {
            return this.PTWexploreOrder;
        }
        return false;
    }

    public void setExploreOrder(boolean explore) {
        if (this.isPTWOrConquests()) {
            this.PTWexploreOrder = explore;
        }
    }

    public boolean getSentry() {
        if (this.isPTWOrConquests()) {
            return this.PTWsentry;
        }
        return false;
    }

    public void setSentry(boolean sentry) {
        if (this.isPTWOrConquests()) {
            this.PTWsentry = sentry;
            this.sentryMix = sentry;
        }
    }

    public void setArmyUnit(boolean armyUnit) {
        this.armyUnit = armyUnit;
    }

    public void setCruiseMissileUnit(boolean cruiseMissileUnit) {
        this.cruiseMissileUnit = cruiseMissileUnit;
    }

    public void setAirBombard(boolean airBombard) {
        this.airBombard = airBombard;
    }

    public void setAirDefenceStrategy(boolean airDefenceStrategy) {
        this.airDefenceStrategy = airDefenceStrategy;
    }

    public void setExploreStrategy(boolean exploreStrategy) {
        this.exploreStrategy = exploreStrategy;
    }

    public void setNavalPower(boolean navalPower) {
        this.navalPower = navalPower;
    }

    public void setAirTransport(boolean airTransport) {
        this.airTransport = airTransport;
    }

    public void setNavalTransport(boolean navalTransport) {
        this.navalTransport = navalTransport;
    }

    public void setNavalCarrier(boolean navalCarrier) {
        this.navalCarrier = navalCarrier;
    }

    public void setTerraform(boolean terraform) {
        this.terraform = terraform;
    }

    public void setSettle(boolean settle) {
        this.settle = settle;
    }

    public void setLeaderUnit(boolean leaderUnit) {
        this.leaderUnit = leaderUnit;
    }

    public void setTacticalNuke(boolean tacticalNuke) {
        this.tacticalNuke = tacticalNuke;
    }

    public void setICBM(boolean ICBM) {
        this.ICBM = ICBM;
    }

    public void setNavalMissileTransport(boolean navalMissileTransport) {
        this.navalMissileTransport = navalMissileTransport;
    }

    public void setFlagStrategy(boolean flagStrategy) {
        this.flagStrategy = flagStrategy;
    }

    public void setKingStrategy(boolean kingStrategy) {
        this.kingStrategy = kingStrategy;
    }

    public boolean getSkipTurn() {
        if (this.isPTWOrConquests()) {
            return this.PTWskipTurn;
        }
        return this.skipTurn;
    }

    public void setSkipTurn(boolean skipTurn) {
        if (this.isPTWOrConquests()) {
            this.PTWskipTurn = skipTurn;
        } else {
            this.skipTurn = skipTurn;
        }
    }

    public boolean getWait() {
        if (this.isPTWOrConquests()) {
            return this.PTWwait;
        }
        return this.wait;
    }

    public void setWait(boolean wait) {
        if (this.isPTWOrConquests()) {
            this.PTWwait = wait;
        } else {
            this.wait = wait;
        }
    }

    public boolean getFortify() {
        if (this.isPTWOrConquests()) {
            return this.PTWfortify;
        }
        return this.fortify;
    }

    public void setFortify(boolean fortify) {
        if (this.isPTWOrConquests()) {
            this.PTWfortify = fortify;
        } else {
            this.fortify = fortify;
        }
    }

    public boolean getDisband() {
        if (this.isPTWOrConquests()) {
            return this.PTWdisband;
        }
        return this.disband;
    }

    public void setDisband(boolean disband) {
        if (this.isPTWOrConquests()) {
            this.PTWdisband = disband;
        } else {
            this.disband = disband;
        }
    }

    public boolean getGoTo() {
        if (this.isPTWOrConquests()) {
            return this.PTWgoTo;
        }
        return this.goTo;
    }

    public void setGoTo(boolean goTo) {
        if (this.isPTWOrConquests()) {
            this.PTWgoTo = goTo;
            this.goToMix = goTo;
        } else {
            this.goTo = goTo;
        }
    }

    public boolean getLoad() {
        if (this.isPTWOrConquests()) {
            return this.PTWload;
        }
        return this.load;
    }

    public void setLoad(boolean load) {
        if (this.isPTWOrConquests()) {
            this.PTWload = load;
        } else {
            this.load = load;
        }
    }

    public boolean getUnload() {
        if (this.isPTWOrConquests()) {
            return this.PTWunload;
        }
        return this.unload;
    }

    public void setUnload(boolean unload) {
        if (this.isPTWOrConquests()) {
            this.PTWunload = unload;
        } else {
            this.unload = unload;
        }
    }

    public boolean getAirlift() {
        if (this.isPTWOrConquests()) {
            return this.PTWairlift;
        }
        return this.airlift;
    }

    public void setAirlift(boolean airlift) {
        if (this.isPTWOrConquests()) {
            this.PTWairlift = airlift;
        } else {
            this.airlift = airlift;
        }
    }

    public boolean getPillage() {
        if (this.isPTWOrConquests()) {
            return this.PTWpillage;
        }
        return this.pillage;
    }

    public void setPillage(boolean pillage) {
        if (this.isPTWOrConquests()) {
            this.PTWpillage = pillage;
        } else {
            this.pillage = pillage;
        }
    }

    public boolean getBombard() {
        if (this.isPTWOrConquests()) {
            return this.PTWbombard;
        }
        return this.bombard;
    }

    public void setBombard(boolean bombard) {
        if (this.isPTWOrConquests()) {
            this.PTWbombard = bombard;
        } else {
            this.bombard = bombard;
        }
    }

    public boolean getAirdrop() {
        if (this.isPTWOrConquests()) {
            return this.PTWairdrop;
        }
        return this.airdrop;
    }

    public void setAirdrop(boolean airdrop) {
        if (this.isPTWOrConquests()) {
            this.PTWairdrop = airdrop;
        } else {
            this.airdrop = airdrop;
        }
    }

    public boolean getBuildArmy() {
        if (this.isPTWOrConquests()) {
            return this.PTWbuildArmy;
        }
        return this.buildArmy;
    }

    public void setBuildArmy(boolean buildArmy) {
        if (this.isPTWOrConquests()) {
            this.PTWbuildArmy = buildArmy;
        } else {
            this.buildArmy = buildArmy;
        }
    }

    public boolean getFinishImprovement() {
        if (this.isPTWOrConquests()) {
            return this.PTWfinishImprovements;
        }
        return this.finishImprovement;
    }

    public void setFinishImprovement(boolean finishImprovement) {
        if (this.isPTWOrConquests()) {
            this.PTWfinishImprovements = finishImprovement;
        } else {
            this.finishImprovement = finishImprovement;
        }
    }

    public boolean getUpgrade() {
        if (this.isPTWOrConquests()) {
            return this.PTWupgradeUnit;
        }
        return this.upgrade;
    }

    public void setUpgrade(boolean upgrade) {
        if (this.isPTWOrConquests()) {
            this.PTWupgradeUnit = upgrade;
        } else {
            this.upgrade = upgrade;
        }
    }

    public boolean getCollateralDamage() {
        if (this.isPTWOrConquests()) {
            return this.collateralDamage;
        }
        return false;
    }

    public void setCollateralDamage(boolean collateralDamage) {
        this.collateralDamage = collateralDamage;
    }

    public boolean getScienceAge() {
        if (this.isPTWOrConquests()) {
            return this.scienceAge;
        }
        return false;
    }

    public void setScienceAge(boolean scienceAge) {
        this.scienceAge = scienceAge;
    }

    public boolean getCapture() {
        if (this.isPTWOrConquests()) {
            return this.PTWcapture;
        }
        return false;
    }

    public void setCapture(boolean capture) {
        if (this.isPTWOrConquests()) {
            this.PTWcapture = capture;
        }
    }

    public boolean getStealthAttack() {
        if (this.isPTWOrConquests()) {
            return this.stealthAttack;
        }
        return false;
    }

    public void setStealthAttack(boolean stealthAttack) {
        this.stealthAttack = stealthAttack;
    }

    public boolean getEnslave() {
        if (this.isPTWOrConquests()) {
            return this.enslave;
        }
        return false;
    }

    public void setEnslave(boolean enslave) {
        this.enslave = enslave;
    }

    public boolean getSacrifice() {
        if (this.isPTWOrConquests()) {
            return this.sacrifice;
        }
        return false;
    }

    public void setSacrifice(boolean sacrifice) {
        this.sacrifice = sacrifice;
    }

    public boolean getTelepad() {
        if (this.isPTWOrConquests()) {
            return this.telepad;
        }
        return false;
    }

    public void setTelepad(boolean telepad) {
        this.telepad = telepad;
    }

    public boolean getTeleportable() {
        if (this.isPTWOrConquests()) {
            return this.teleportable;
        }
        return false;
    }

    public boolean getCharm() {
        if (this.isPTWOrConquests()) {
            return this.charm;
        }
        return false;
    }

    public void setTeleportable(boolean teleportable) {
        this.teleportable = teleportable;
    }

    public void setCharm(boolean charm) {
        this.charm = charm;
    }

    public boolean getBuildColony() {
        if (this.isPTWOrConquests()) {
            return this.PTWbuildColony;
        }
        return this.buildColony;
    }

    public void setBuildColony(boolean buildColony) {
        if (this.isPTWOrConquests()) {
            this.PTWbuildColony = buildColony;
        } else {
            this.buildColony = buildColony;
        }
    }

    public boolean getBuildCity() {
        if (this.isPTWOrConquests()) {
            return this.PTWbuildCity;
        }
        return this.buildCity;
    }

    public void setBuildCity(boolean buildCity) {
        if (this.isPTWOrConquests()) {
            this.PTWbuildCity = buildCity;
        } else {
            this.buildCity = buildCity;
        }
    }

    public boolean getBuildRoad() {
        if (this.isPTWOrConquests()) {
            return this.PTWbuildRoad;
        }
        return this.buildRoad;
    }

    public void setBuildRoad(boolean buildRoad) {
        if (this.isPTWOrConquests()) {
            this.PTWbuildRoad = buildRoad;
        } else {
            this.buildRoad = buildRoad;
        }
    }

    public boolean getBuildRailroad() {
        if (this.isPTWOrConquests()) {
            return this.PTWbuildRailroad;
        }
        return this.buildRailroad;
    }

    public void setBuildRailroad(boolean buildRailroad) {
        if (this.isPTWOrConquests()) {
            this.PTWbuildRailroad = buildRailroad;
        } else {
            this.buildRailroad = buildRailroad;
        }
    }

    public boolean getBuildFort() {
        if (this.isPTWOrConquests()) {
            return this.PTWbuildFort;
        }
        return this.buildFort;
    }

    public void setBuildFort(boolean buildFort) {
        if (this.isPTWOrConquests()) {
            this.PTWbuildFort = buildFort;
        } else {
            this.buildFort = buildFort;
        }
    }

    public boolean getBuildMine() {
        if (this.isPTWOrConquests()) {
            return this.PTWbuildMine;
        }
        return this.buildMine;
    }

    public void setBuildMine(boolean buildMine) {
        if (this.isPTWOrConquests()) {
            this.PTWbuildMine = buildMine;
        } else {
            this.buildMine = buildMine;
        }
    }

    public boolean getIrrigate() {
        if (this.isPTWOrConquests()) {
            return this.PTWirrigate;
        }
        return this.irrigate;
    }

    public void setIrrigate(boolean irrigate) {
        if (this.isPTWOrConquests()) {
            this.PTWirrigate = irrigate;
        } else {
            this.irrigate = irrigate;
        }
    }

    public boolean getClearForest() {
        if (this.isPTWOrConquests()) {
            return this.PTWclearForest;
        }
        return this.clearForest;
    }

    public void setClearForest(boolean clearForest) {
        if (this.isPTWOrConquests()) {
            this.PTWclearForest = clearForest;
        } else {
            this.clearForest = clearForest;
        }
    }

    public boolean getClearJungle() {
        if (this.isPTWOrConquests()) {
            return this.PTWclearJungle;
        }
        return this.clearJungle;
    }

    public void setClearJungle(boolean clearJungle) {
        if (this.isPTWOrConquests()) {
            this.PTWclearJungle = clearJungle;
        } else {
            this.clearJungle = clearJungle;
        }
    }

    public boolean getPlantForest() {
        if (this.isPTWOrConquests()) {
            return this.PTWplantForest;
        }
        return this.plantForest;
    }

    public void setPlantForest(boolean plantForest) {
        if (this.isPTWOrConquests()) {
            this.PTWplantForest = plantForest;
        } else {
            this.plantForest = plantForest;
        }
    }

    public boolean getClearPollution() {
        if (this.isPTWOrConquests()) {
            return this.PTWclearPollution;
        }
        return this.clearPollution;
    }

    public void setClearPollution(boolean clearPollution) {
        if (this.isPTWOrConquests()) {
            this.PTWclearPollution = clearPollution;
        } else {
            this.clearPollution = clearPollution;
        }
    }

    public boolean getAutomate() {
        if (this.isPTWOrConquests()) {
            return this.PTWautomate;
        }
        return this.automate;
    }

    public void setAutomate(boolean automate) {
        if (this.isPTWOrConquests()) {
            this.PTWautomate = automate;
        } else {
            this.automate = automate;
        }
    }

    public boolean getJoinCity() {
        if (this.isPTWOrConquests()) {
            return this.PTWjoinCity;
        }
        return this.joinCity;
    }

    public void setJoinCity(boolean joinCity) {
        if (this.isPTWOrConquests()) {
            this.PTWjoinCity = joinCity;
        } else {
            this.joinCity = joinCity;
        }
    }

    public boolean getBuildAirfield() {
        if (this.isPTWOrConquests()) {
            return this.PTWbuildAirfield;
        }
        return false;
    }

    public void setBuildAirfield(boolean buildAirfield) {
        if (this.isPTWOrConquests()) {
            this.PTWbuildAirfield = buildAirfield;
        }
    }

    public boolean getBuildRadarTower() {
        if (this.isPTWOrConquests()) {
            return this.PTWbuildRadarTower;
        }
        return false;
    }

    public void setBuildRadarTower(boolean buildRadarTower) {
        if (this.isPTWOrConquests()) {
            this.PTWbuildRadarTower = buildRadarTower;
        }
    }

    public boolean getBuildOutpost() {
        if (this.isPTWOrConquests()) {
            return this.PTWbuildOutpost;
        }
        return false;
    }

    public void setBuildOutpost(boolean buildOutpost) {
        if (this.isPTWOrConquests()) {
            this.PTWbuildOutpost = buildOutpost;
        }
    }

    public boolean getBuildBarricade() {
        if (this.isPTWOrConquests()) {
            return this.PTWbuildBarricade;
        }
        return false;
    }

    public void setBuildBarricade(boolean buildBarricade) {
        if (this.isPTWOrConquests()) {
            this.PTWbuildBarricade = buildBarricade;
        }
    }

    public boolean getBomb() {
        if (this.isPTWOrConquests()) {
            return this.PTWbomb;
        }
        return this.bomb;
    }

    public void setBomb(boolean bomb) {
        if (this.isPTWOrConquests()) {
            this.PTWbomb = bomb;
        } else {
            this.bomb = bomb;
        }
    }

    public boolean getRecon() {
        if (this.isPTWOrConquests()) {
            return this.PTWrecon;
        }
        return this.recon;
    }

    public void setRecon(boolean recon) {
        if (this.isPTWOrConquests()) {
            this.PTWrecon = recon;
        } else {
            this.recon = recon;
        }
    }

    public boolean getIntercept() {
        if (this.isPTWOrConquests()) {
            return this.PTWintercept;
        }
        return this.intercept;
    }

    public void setIntercept(boolean intercept) {
        if (this.isPTWOrConquests()) {
            this.PTWintercept = intercept;
        } else {
            this.intercept = intercept;
        }
    }

    public boolean getRebase() {
        if (this.isPTWOrConquests()) {
            return this.PTWrebase;
        }
        return this.rebase;
    }

    public void setRebase(boolean rebase) {
        if (this.isPTWOrConquests()) {
            this.PTWrebase = rebase;
        } else {
            this.rebase = rebase;
        }
    }

    public boolean getPrecisionBomb() {
        if (this.isPTWOrConquests()) {
            return this.PTWprecisionBomb;
        }
        return this.precisionBomb;
    }

    public void setPrecisionBomb(boolean precisionBomb) {
        if (this.isPTWOrConquests()) {
            this.PTWprecisionBomb = precisionBomb;
        } else {
            this.precisionBomb = precisionBomb;
        }
    }

    public void setWheeled(boolean wheeled) {
        this.wheeled = wheeled;
    }

    public void setFootSoldier(boolean footSoldier) {
        this.footSoldier = footSoldier;
    }

    public void setBlitz(boolean blitz) {
        this.blitz = blitz;
    }

    public void setCruiseMissile(boolean cruiseMissile) {
        this.cruiseMissile = cruiseMissile;
    }

    public void setAllTerrainAsRoads(boolean allTerrainAsRoads) {
        this.allTerrainAsRoads = allTerrainAsRoads;
    }

    public void setRadar(boolean radar) {
        this.radar = radar;
    }

    public void setAmphibiousUnit(boolean amphibiousUnit) {
        this.amphibiousUnit = amphibiousUnit;
    }

    public void setInvisible(boolean invisible) {
        this.invisible = invisible;
    }

    public void setTransportsOnlyAirUnits(boolean transportsOnlyAirUnits) {
        this.transportsOnlyAirUnits = transportsOnlyAirUnits;
    }

    public void setDraftable(boolean draftable) {
        this.draftable = draftable;
    }

    public void setImmobile(boolean immobile) {
        this.immobile = immobile;
    }

    public void setSinksInSea(boolean sinksInSea) {
        this.sinksInSea = sinksInSea;
    }

    public void setSinksInOcean(boolean sinksInOcean) {
        this.sinksInOcean = sinksInOcean;
    }

    public void setFlagUnit(boolean flagUnit) {
        this.flagUnit = flagUnit;
    }

    public void setTransportsOnlyFootUnits(boolean transportsOnlyFootUnits) {
        this.transportsOnlyFootUnits = transportsOnlyFootUnits;
    }

    public void setStartsGoldenAge(boolean startsGoldenAge) {
        this.startsGoldenAge = startsGoldenAge;
    }

    public void setNuclearWeapon(boolean nuclearWeapon) {
        this.nuclearWeapon = nuclearWeapon;
    }

    public void setHiddenNationality(boolean hiddenNationality) {
        this.hiddenNationality = hiddenNationality;
    }

    public void setArmy(boolean army) {
        this.army = army;
    }

    public void setLeader(boolean leader) {
        this.leader = leader;
    }

    public void setInfiniteBombardRange(boolean infiniteBombardRange) {
        this.infiniteBombardRange = infiniteBombardRange;
    }

    public void setStealth(boolean stealth) {
        this.stealth = stealth;
    }

    public void setDetectInvisible(boolean detectInvisible) {
        this.detectInvisible = detectInvisible;
    }

    public void setTacticalMissile(boolean tacticalMissile) {
        this.tacticalMissile = tacticalMissile;
    }

    public void setTransportsOnlyTacticalMissiles(boolean transportsOnlyTacticalMissiles) {
        this.transportsOnlyTacticalMissiles = transportsOnlyTacticalMissiles;
    }

    public void setRangedAttackAnimations(boolean rangedAttackAnimations) {
        this.rangedAttackAnimations = rangedAttackAnimations;
    }

    public void setRotateBeforeAttack(boolean rotateBeforeAttack) {
        this.rotateBeforeAttack = rotateBeforeAttack;
    }

    public void setLethalLandBombardment(boolean lethalLandBombardment) {
        this.lethalLandBombardment = lethalLandBombardment;
    }

    public void setLethalSeaBombardment(boolean lethalSeaBombardment) {
        this.lethalSeaBombardment = lethalSeaBombardment;
    }

    public void setKing(boolean king) {
        this.king = king;
    }

    public void setRequiresEscort(boolean requiresEscort) {
        this.requiresEscort = requiresEscort;
    }

    public boolean hasOffenceStrategy() {
        return this.offence;
    }

    public boolean hasDefenceStrategy() {
        return this.defenceStrategy;
    }

    public boolean hasArtilleryStrategy() {
        return this.artillery;
    }

    public boolean hasExploreStrategy() {
        return this.exploreStrategy;
    }

    public boolean hasArmyStrategy() {
        return this.armyUnit;
    }

    public boolean hasCruiseMissileStrategy() {
        return this.cruiseMissileUnit;
    }

    public boolean hasAirBombardStrategy() {
        return this.airBombard;
    }

    public boolean hasAirDefenceStrategy() {
        return this.airDefenceStrategy;
    }

    public boolean hasNavalPowerStrategy() {
        return this.navalPower;
    }

    public boolean hasAirTransportStrategy() {
        return this.airTransport;
    }

    public boolean hasNavalTransportStrategy() {
        return this.navalTransport;
    }

    public boolean hasNavalCarrierStrategy() {
        return this.navalCarrier;
    }

    public boolean hasTerraformStrategy() {
        return this.terraform;
    }

    public boolean hasSettlerStrategy() {
        return this.settle;
    }

    public boolean hasLeaderUnitStrategy() {
        return this.leaderUnit;
    }

    public boolean hasKingStrategy() {
        return this.kingStrategy;
    }

    public boolean hasTacticalNukeStrategy() {
        return this.tacticalNuke;
    }

    public boolean hasICBMStrategy() {
        return this.ICBM;
    }

    public boolean hasNavalMissileTransportStrategy() {
        return this.navalMissileTransport;
    }

    public boolean hasFlagStrategy() {
        return this.flagStrategy;
    }

    public void setIgnoreTerrain(int terrainIndex, boolean value) {
        this.ignoreMovementCost[terrainIndex] = (byte)(value ? 1 : 0);
    }

    void setIgnoredMovementCost(int terrainIndex, byte value) {
        this.ignoreMovementCost[terrainIndex] = value;
    }

    byte getIgnoredMovementCost(int terrainIndex) {
        return this.ignoreMovementCost[terrainIndex];
    }

    public boolean ignoresTerrain(int terrainIndex) {
        return this.ignoreMovementCost[terrainIndex] > 0;
    }

    public int getNumIgnoreTerrains() {
        return this.ignoreMovementCost.length;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public int getIconIndex() {
        return this.iconIndex;
    }

    public int getZoneOfControl() {
        return this.zoneOfControl;
    }

    @Override
    public String getCivilopediaEntry() {
        return this.civilopediaEntry;
    }

    public int getBombardStrength() {
        return this.bombardStrength;
    }

    public int getBombardRange() {
        return this.bombardRange;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public int getShieldCost() {
        return this.shieldCost;
    }

    public int getDefence() {
        return this.defence;
    }

    public int getHitPointBonus() {
        return this.hitPointBonus;
    }

    public int getAttack() {
        return this.attack;
    }

    public int getOperationalRange() {
        return this.operationalRange;
    }

    public int getRateOfFire() {
        return this.rateOfFire;
    }

    public int getPopulationCost() {
        return this.populationCost;
    }

    public int getMovement() {
        return this.movement;
    }

    public int getRequiredTech() {
        return this.requiredTechInt;
    }

    public int getUpgradeTo() {
        return this.upgradeToInt;
    }

    public int getRequiredResource1() {
        return this.requiredResource1Int;
    }

    public int getRequiredResource2() {
        return this.requiredResource2Int;
    }

    public int getRequiredResource3() {
        return this.requiredResource3Int;
    }

    public int getUnitClass() {
        return this.unitClass;
    }

    public int getOtherStrategy() {
        return this.otherStrategy;
    }

    public int getBombardEffects() {
        return this.bombardEffects;
    }

    public int getRequiresSupport() {
        return this.requiresSupport;
    }

    public int getUseExactCost() {
        return this.useExactCost;
    }

    public int getTelepadRange() {
        return this.telepadRange;
    }

    public int getQuestionMark3() {
        return this.questionMark3;
    }

    public int getEnslaveResultsIn() {
        return this.enslaveResultsInInt;
    }

    public int getQuestionMark5() {
        return this.questionMark5;
    }

    public int getQuestionMark6() {
        return this.questionMark6;
    }

    public int getCreatesCraters() {
        return this.createsCraters;
    }

    public float getWorkerStrength() {
        return this.workerStrengthFloat;
    }

    public int getAirDefence() {
        return this.airDefence;
    }

    public int getQuestionMark8() {
        return this.questionMark8;
    }

    public int getNumStrategies() {
        return this.numStrategies;
    }

    public boolean isWheeled() {
        return this.wheeled;
    }

    public boolean isFootSoldier() {
        return this.footSoldier;
    }

    public boolean isBlitz() {
        return this.blitz;
    }

    public boolean isCruiseMissile() {
        return this.cruiseMissile;
    }

    public boolean treatsAllTerrainAsRoads() {
        return this.allTerrainAsRoads;
    }

    public boolean hasRadar() {
        return this.radar;
    }

    public boolean isAmphibious() {
        return this.amphibiousUnit;
    }

    public boolean isInvisible() {
        return this.invisible;
    }

    public boolean transportsOnlyAirUnits() {
        return this.transportsOnlyAirUnits;
    }

    public boolean isDraftable() {
        return this.draftable;
    }

    public boolean isImmobile() {
        return this.immobile;
    }

    public boolean sinksInSea() {
        return this.sinksInSea;
    }

    public boolean sinksInOcean() {
        return this.sinksInOcean;
    }

    public boolean isFlagUnit() {
        return this.flagUnit;
    }

    public boolean transportsOnlyFootUnits() {
        return this.transportsOnlyFootUnits;
    }

    public boolean startsGoldenAge() {
        return this.startsGoldenAge;
    }

    public boolean isNuclearWeapon() {
        return this.nuclearWeapon;
    }

    public boolean hasHiddenNationality() {
        return this.hiddenNationality;
    }

    public boolean isArmy() {
        return this.army;
    }

    public boolean isLeader() {
        return this.leader;
    }

    public boolean hasInfiniteBombardRange() {
        return this.infiniteBombardRange;
    }

    public boolean isStealth() {
        return this.stealth;
    }

    public boolean detectsInvisible() {
        return this.detectInvisible;
    }

    public boolean isTacticalMissile() {
        return this.tacticalMissile;
    }

    public boolean transportsOnlyTacticalMissiles() {
        return this.transportsOnlyTacticalMissiles;
    }

    public boolean hasRangedAttackAnimation() {
        return this.rangedAttackAnimations;
    }

    public boolean rotatesBeforeAttack() {
        return this.rotateBeforeAttack;
    }

    public boolean hasLethalLandBombardment() {
        return this.lethalLandBombardment;
    }

    public boolean hasLethalSeaBombardment() {
        return this.lethalSeaBombardment;
    }

    public boolean isKing() {
        return this.king;
    }

    public boolean requiresEscort() {
        return this.requiresEscort;
    }

    public int getDataLength() {
        return this.dataLength;
    }

    public int getNumLegalUnitTelepads() {
        return this.legalUnitTelepadsInt.size();
    }

    public int getNumLegalBuildingTelepads() {
        return this.legalBuildingTelepads.size();
    }

    public int getNumStealthTargets() {
        return this.stealthTargetsInt.size();
    }

    public void clearUnitTelepads() {
        this.dataLength -= 4 * this.legalUnitTelepadsInt.size();
        this.legalUnitTelepadsInt.clear();
    }

    public void addUnitTelepad(int unitID) {
        this.dataLength += 4;
        this.legalUnitTelepadsInt.add(unitID);
    }

    public void clearBuildingTelepads() {
        this.dataLength -= 4 * this.legalBuildingTelepads.size();
        this.legalBuildingTelepads.clear();
    }

    public void addBuildingTelepad(int buildingID) {
        this.dataLength += 4;
        this.legalBuildingTelepads.add(buildingID);
    }

    public void clearStealthAttackTargets() {
        this.dataLength -= 4 * this.stealthTargetsInt.size();
        this.stealthTargetsInt.clear();
    }

    public void addStealthAttackTarget(int unitID) {
        this.dataLength += 4;
        this.stealthTargetsInt.add(unitID);
    }

    public List<Integer> getUnitTelepads() {
        return Collections.unmodifiableList(this.legalUnitTelepadsInt);
    }

    public List<Integer> getBuildingTelepads() {
        return Collections.unmodifiableList(this.legalBuildingTelepads);
    }

    public List<Integer> getStealthTargets() {
        return Collections.unmodifiableList(this.stealthTargetsInt);
    }

    public void updateStealthTargetIndices() {
        this.stealthTargetsInt.clear();
        for (PRTO target : this.stealthTargets) {
            this.stealthTargetsInt.add(target.getIndex());
        }
    }

    public void updateUnitTelepadIndices() {
        this.legalUnitTelepadsInt.clear();
        for (PRTO target : this.legalUnitTelepads) {
            this.legalUnitTelepadsInt.add(target.getIndex());
        }
    }

    public void convertFromVanillaToConquests() {
        this.PTWAirMissions = this.airMissions;
        this.extractPTWAirMissions();
        this.PTWskipTurn = this.skipTurn;
        this.PTWwait = this.wait;
        this.PTWfortify = this.fortify;
        this.PTWdisband = this.disband;
        this.PTWgoTo = this.goTo;
        this.PTWexploreOrder = false;
        this.PTWsentry = false;
        this.recalculatePTWStandardOrders();
        this.PTWload = this.load;
        this.PTWunload = this.unload;
        this.PTWairlift = this.airlift;
        this.PTWpillage = this.pillage;
        this.PTWbombard = this.bombard;
        this.PTWairdrop = this.airdrop;
        this.PTWbuildArmy = this.buildArmy;
        this.PTWfinishImprovements = this.finishImprovement;
        this.PTWupgradeUnit = this.upgrade;
        this.PTWcapture = false;
        this.recalculatePTWSpecialActions();
        this.PTWbuildColony = this.buildColony;
        this.PTWbuildCity = this.buildCity;
        this.PTWbuildRoad = this.buildRoad;
        this.PTWbuildRailroad = this.buildRailroad;
        this.PTWbuildFort = this.buildFort;
        this.PTWbuildMine = this.buildMine;
        this.PTWirrigate = this.irrigate;
        this.PTWclearForest = this.clearForest;
        this.PTWclearJungle = this.clearJungle;
        this.PTWplantForest = this.plantForest;
        this.PTWclearPollution = this.clearPollution;
        this.PTWautomate = this.automate;
        this.PTWjoinCity = this.joinCity;
        this.PTWbuildAirfield = false;
        this.PTWbuildRadarTower = false;
        this.PTWbuildOutpost = false;
        this.recalculatePTWWorkerActions();
    }

    public void convertFromPTWToConquests() {
    }

    public void handleDeletedCivilization(int index, int civSize) {
        for (int i = index; i < civSize; ++i) {
            this.availableToArray[i] = this.availableToArray[i + 1];
        }
        this.availableToArray[civSize] = false;
        this.recalculateAvailableTo();
    }

    public void handleDeletedResource(int index) {
        if (this.requiredResource1Int == index) {
            this.requiredResource1Int = -1;
        } else if (this.requiredResource1Int > index) {
            --this.requiredResource1Int;
        }
        if (this.requiredResource2Int == index) {
            this.requiredResource2Int = -1;
        } else if (this.requiredResource2Int > index) {
            --this.requiredResource2Int;
        }
        if (this.requiredResource3Int == index) {
            this.requiredResource3Int = -1;
        } else if (this.requiredResource3Int > index) {
            --this.requiredResource3Int;
        }
    }

    public void handleDeletedTechnology(int index) {
        if (this.requiredTechInt == index) {
            this.requiredTechInt = -1;
            this.requiredTech = null;
        } else if (this.requiredTechInt > index) {
            --this.requiredTechInt;
        }
    }

    public void handleSwappedTech() {
        if (this.requiredTechInt != -1) {
            this.requiredTechInt = this.requiredTech.getIndex();
        }
    }

    public void handleDeletedUnit(int index) {
        if (this.upgradeToInt == index) {
            this.upgradeToInt = -1;
            this.upgradeTo = null;
        } else if (this.upgradeToInt > index) {
            --this.upgradeToInt;
        }
        if (this.enslaveResultsInInt == index) {
            this.enslaveResultsInInt = -1;
            this.enslaveResultsIn = null;
        } else if (this.enslaveResultsInInt > index) {
            --this.enslaveResultsInInt;
        }
        if (this.index > index) {
            --this.index;
        } else if (this.index == index) {
            this.index = -1;
        }
    }

    private boolean isPTWOrConquests() {
        return this.baseLink.version.ordinal() >= civ3Version.PTW.ordinal();
    }

    @Override
    public String toString() {
        int j;
        String lineReturn = System.getProperty("line.separator");
        String toReturn = "dataLength: " + this.dataLength + lineReturn;
        toReturn = toReturn + "index: " + this.index + lineReturn;
        toReturn = toReturn + "zoneOfControl: " + this.zoneOfControl + lineReturn;
        toReturn = toReturn + "name: " + this.name + lineReturn;
        toReturn = toReturn + "civilopediaEntry: " + this.civilopediaEntry + lineReturn;
        toReturn = toReturn + "bombardStrength: " + this.bombardStrength + lineReturn;
        toReturn = toReturn + "bombardRange: " + this.bombardRange + lineReturn;
        toReturn = toReturn + "capacity: " + this.capacity + lineReturn;
        toReturn = toReturn + "shieldCost: " + this.shieldCost + lineReturn;
        toReturn = toReturn + "defence: " + this.defence + lineReturn;
        toReturn = toReturn + "iconIndex: " + this.iconIndex + lineReturn;
        toReturn = toReturn + "attack: " + this.attack + lineReturn;
        toReturn = toReturn + "operationalRange: " + this.operationalRange + lineReturn;
        toReturn = toReturn + "populationCost: " + this.populationCost + lineReturn;
        toReturn = toReturn + "rateOfFire: " + this.rateOfFire + lineReturn;
        toReturn = toReturn + "movement: " + this.movement + lineReturn;
        toReturn = toReturn + "requiredTech: " + this.requiredTechInt + lineReturn;
        toReturn = toReturn + "upgradeTo: " + this.upgradeToInt + lineReturn;
        toReturn = toReturn + "requiredResource1: " + this.requiredResource1Int + lineReturn;
        toReturn = toReturn + "requiredResource2: " + this.requiredResource2Int + lineReturn;
        toReturn = toReturn + "requiredResource3: " + this.requiredResource3Int + lineReturn;
        toReturn = toReturn + "unitAbilities: " + this.unitAbilities + lineReturn;
        toReturn = toReturn + "AIStrategy: " + this.AIStrategy + lineReturn;
        toReturn = toReturn + "availableTo: " + this.availableTo + lineReturn;
        toReturn = toReturn + "standardOrdersSpecialActions: " + this.standardOrdersSpecialActions + lineReturn;
        toReturn = toReturn + "airMissions: " + this.airMissions + lineReturn;
        toReturn = toReturn + "unitClass: " + this.unitClass + lineReturn;
        toReturn = toReturn + "otherStrategy: " + this.otherStrategy + lineReturn;
        toReturn = toReturn + "hitPointBonus: " + this.hitPointBonus + lineReturn;
        toReturn = toReturn + "PTWStandardOrders: " + this.PTWStandardOrders + lineReturn;
        toReturn = toReturn + "PTWSpecialActions: " + this.PTWSpecialActions + lineReturn;
        toReturn = toReturn + "PTWWorkerActions: " + this.PTWWorkerActions + lineReturn;
        toReturn = toReturn + "PTWAirMissions: " + this.PTWAirMissions + lineReturn;
        toReturn = toReturn + "PTWActionsMix: " + this.PTWActionsMix + lineReturn;
        toReturn = toReturn + "bombardEffects: " + this.bombardEffects + lineReturn;
        for (j = 0; j < 14; ++j) {
            toReturn = toReturn + "ignore movement cost of terrain " + j + "?  " + this.ignoreMovementCost[j] + lineReturn;
        }
        toReturn = toReturn + "requiresSupport: " + this.requiresSupport + lineReturn;
        toReturn = toReturn + "useExactCost: " + this.useExactCost + lineReturn;
        toReturn = toReturn + "telepadRange: " + this.telepadRange + lineReturn;
        toReturn = toReturn + "questionMark3: " + this.questionMark3 + lineReturn;
        toReturn = toReturn + "numLegalUnitTelepads: " + this.getNumLegalUnitTelepads() + lineReturn;
        for (j = 0; j < this.getNumLegalUnitTelepads(); ++j) {
            toReturn = toReturn + "  legal unit telepad: " + this.legalUnitTelepadsInt.get(j) + lineReturn;
        }
        toReturn = toReturn + "enslaveResultsIn: " + this.enslaveResultsInInt + lineReturn;
        toReturn = toReturn + "questionMark5: " + this.questionMark5 + lineReturn;
        toReturn = toReturn + "numStealthTargets: " + this.stealthTargetsInt.size() + lineReturn;
        for (j = 0; j < this.stealthTargetsInt.size(); ++j) {
            toReturn = toReturn + "stealth target: " + this.stealthTargetsInt.get(j) + lineReturn;
        }
        toReturn = toReturn + "questionMark6: " + this.questionMark6 + lineReturn;
        toReturn = toReturn + "numLegalBuildingTelepads: " + this.getNumLegalBuildingTelepads() + lineReturn;
        for (j = 0; j < this.getNumLegalBuildingTelepads(); ++j) {
            toReturn = toReturn + "  legal building telepad: " + this.legalBuildingTelepads.get(j) + lineReturn;
        }
        toReturn = toReturn + "createsCraters: " + this.createsCraters + lineReturn;
        toReturn = toReturn + "workerStrength1: " + this.workerStrength1 + lineReturn;
        toReturn = toReturn + "workerStrengthFloat: " + this.workerStrengthFloat + lineReturn;
        toReturn = toReturn + "questionMark8: " + this.questionMark8 + lineReturn;
        toReturn = toReturn + "airDefence: " + this.airDefence + lineReturn;
        toReturn = toReturn + lineReturn;
        return toReturn;
    }

    public void extractEnglish() {
        this.extractUnitAbilities();
        this.extractAIStrategy();
        this.extractCivsAvailableTo();
        this.extractOrders();
        this.extractAirMissions();
        this.extractPTWStandardOrders();
        this.extractPTWSpecialActions();
        this.extractPTWWorkerActions();
        this.extractPTWAirMissions();
        this.extractPTWActionMix();
    }

    void writeXthStrategy(int x, LittleEndianDataOutputStream out) {
        int number = 1;
        int numStratsFound = 0;
        for (int i = 0; i < this.strategies.length; ++i) {
            if (this.strategies[i].booleanValue() && ++numStratsFound == x) {
                try {
                    out.writeInt(number);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return;
            }
            number <<= 1;
        }
        try {
            out.writeInt(0);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    void extractAIStrategy() {
        int AIStrategyCopy = this.AIStrategy;
        this.numStrategies = 0;
        int divBy = AIStrategyCopy / (int)Math.pow(2.0, 19.0);
        if (divBy == 1) {
            this.kingStrategy = true;
            AIStrategyCopy -= 524288;
            this.numStrategies = (byte)(this.numStrategies + 1);
        }
        if ((divBy = AIStrategyCopy / (int)Math.pow(2.0, 18.0)) == 1) {
            this.flagStrategy = true;
            AIStrategyCopy -= 262144;
            this.numStrategies = (byte)(this.numStrategies + 1);
        }
        if ((divBy = AIStrategyCopy / (int)Math.pow(2.0, 17.0)) == 1) {
            this.navalMissileTransport = true;
            AIStrategyCopy -= 131072;
            this.numStrategies = (byte)(this.numStrategies + 1);
        }
        if ((divBy = AIStrategyCopy / (int)Math.pow(2.0, 16.0)) == 1) {
            this.ICBM = true;
            AIStrategyCopy -= 65536;
            this.numStrategies = (byte)(this.numStrategies + 1);
        }
        if ((divBy = AIStrategyCopy / (int)Math.pow(2.0, 15.0)) == 1) {
            this.tacticalNuke = true;
            AIStrategyCopy -= 32768;
            this.numStrategies = (byte)(this.numStrategies + 1);
        }
        if ((divBy = AIStrategyCopy / (int)Math.pow(2.0, 14.0)) == 1) {
            this.leaderUnit = true;
            AIStrategyCopy -= 16384;
            this.numStrategies = (byte)(this.numStrategies + 1);
        }
        if ((divBy = AIStrategyCopy / (int)Math.pow(2.0, 13.0)) == 1) {
            this.settle = true;
            AIStrategyCopy -= 8192;
            this.numStrategies = (byte)(this.numStrategies + 1);
        }
        if ((divBy = AIStrategyCopy / (int)Math.pow(2.0, 12.0)) == 1) {
            this.terraform = true;
            AIStrategyCopy -= 4096;
            this.numStrategies = (byte)(this.numStrategies + 1);
        }
        if ((divBy = AIStrategyCopy / (int)Math.pow(2.0, 11.0)) == 1) {
            this.navalCarrier = true;
            AIStrategyCopy -= 2048;
            this.numStrategies = (byte)(this.numStrategies + 1);
        }
        if ((divBy = AIStrategyCopy / (int)Math.pow(2.0, 10.0)) == 1) {
            this.navalTransport = true;
            AIStrategyCopy -= 1024;
            this.numStrategies = (byte)(this.numStrategies + 1);
        }
        if ((divBy = AIStrategyCopy / (int)Math.pow(2.0, 9.0)) == 1) {
            this.airTransport = true;
            AIStrategyCopy -= 512;
            this.numStrategies = (byte)(this.numStrategies + 1);
        }
        if ((divBy = AIStrategyCopy / (int)Math.pow(2.0, 8.0)) == 1) {
            this.navalPower = true;
            AIStrategyCopy -= 256;
            this.numStrategies = (byte)(this.numStrategies + 1);
        }
        if ((divBy = AIStrategyCopy / (int)Math.pow(2.0, 7.0)) == 1) {
            this.airDefenceStrategy = true;
            AIStrategyCopy -= 128;
            this.numStrategies = (byte)(this.numStrategies + 1);
        }
        if ((divBy = AIStrategyCopy / (int)Math.pow(2.0, 6.0)) == 1) {
            this.airBombard = true;
            AIStrategyCopy -= 64;
            this.numStrategies = (byte)(this.numStrategies + 1);
        }
        if ((divBy = AIStrategyCopy / (int)Math.pow(2.0, 5.0)) == 1) {
            this.cruiseMissileUnit = true;
            AIStrategyCopy -= 32;
            this.numStrategies = (byte)(this.numStrategies + 1);
        }
        if ((divBy = AIStrategyCopy / (int)Math.pow(2.0, 4.0)) == 1) {
            this.armyUnit = true;
            AIStrategyCopy -= 16;
            this.numStrategies = (byte)(this.numStrategies + 1);
        }
        if ((divBy = AIStrategyCopy / (int)Math.pow(2.0, 3.0)) == 1) {
            this.exploreStrategy = true;
            AIStrategyCopy -= 8;
            this.numStrategies = (byte)(this.numStrategies + 1);
        }
        if ((divBy = AIStrategyCopy / (int)Math.pow(2.0, 2.0)) == 1) {
            this.artillery = true;
            AIStrategyCopy -= 4;
            this.numStrategies = (byte)(this.numStrategies + 1);
        }
        if ((divBy = AIStrategyCopy / (int)Math.pow(2.0, 1.0)) == 1) {
            this.defenceStrategy = true;
            AIStrategyCopy -= 2;
            this.numStrategies = (byte)(this.numStrategies + 1);
        }
        if ((divBy = AIStrategyCopy / (int)Math.pow(2.0, 0.0)) == 1) {
            this.offence = true;
            --AIStrategyCopy;
            this.numStrategies = (byte)(this.numStrategies + 1);
        }
        Boolean[] strategies2 = new Boolean[]{this.offence, this.defenceStrategy, this.artillery, this.exploreStrategy, this.armyUnit, this.cruiseMissileUnit, this.airBombard, this.airDefenceStrategy, this.navalPower, this.airTransport, this.navalTransport, this.navalCarrier, this.terraform, this.settle, this.leaderUnit, this.tacticalNuke, this.ICBM, this.navalMissileTransport, this.flagStrategy, this.kingStrategy};
        this.strategies = strategies2;
    }

    private void extractCivsAvailableTo() {
        long availableToCopy = this.availableTo;
        if (availableToCopy < 0L) {
            availableToCopy += (long)Math.pow(2.0, 32.0);
        }
        int divBy = (int)(availableToCopy / (long)Math.pow(2.0, 31.0));
        int availableToCount = 31;
        long subtractNum = 0x80000000L;
        int power = 30;
        if (divBy == 1) {
            this.availableToArray[availableToCount] = true;
            availableToCopy -= subtractNum;
        }
        subtractNum /= 2L;
        divBy = (int)(availableToCopy / (long)Math.pow(2.0, power));
        --power;
        --availableToCount;
        if (divBy == 1) {
            this.availableToArray[availableToCount] = true;
            availableToCopy -= subtractNum;
        }
        subtractNum /= 2L;
        divBy = (int)(availableToCopy / (long)Math.pow(2.0, power));
        --power;
        --availableToCount;
        if (divBy == 1) {
            this.availableToArray[availableToCount] = true;
            availableToCopy -= subtractNum;
        }
        subtractNum /= 2L;
        divBy = (int)(availableToCopy / (long)Math.pow(2.0, power));
        --power;
        --availableToCount;
        if (divBy == 1) {
            this.availableToArray[availableToCount] = true;
            availableToCopy -= subtractNum;
        }
        subtractNum /= 2L;
        divBy = (int)(availableToCopy / (long)Math.pow(2.0, power));
        --power;
        --availableToCount;
        if (divBy == 1) {
            this.availableToArray[availableToCount] = true;
            availableToCopy -= subtractNum;
        }
        subtractNum /= 2L;
        divBy = (int)(availableToCopy / (long)Math.pow(2.0, power));
        --power;
        --availableToCount;
        if (divBy == 1) {
            this.availableToArray[availableToCount] = true;
            availableToCopy -= subtractNum;
        }
        subtractNum /= 2L;
        divBy = (int)(availableToCopy / (long)Math.pow(2.0, power));
        --power;
        --availableToCount;
        if (divBy == 1) {
            this.availableToArray[availableToCount] = true;
            availableToCopy -= subtractNum;
        }
        subtractNum /= 2L;
        divBy = (int)(availableToCopy / (long)Math.pow(2.0, power));
        --power;
        --availableToCount;
        if (divBy == 1) {
            this.availableToArray[availableToCount] = true;
            availableToCopy -= subtractNum;
        }
        subtractNum /= 2L;
        divBy = (int)(availableToCopy / (long)Math.pow(2.0, power));
        --power;
        --availableToCount;
        if (divBy == 1) {
            this.availableToArray[availableToCount] = true;
            availableToCopy -= subtractNum;
        }
        subtractNum /= 2L;
        divBy = (int)(availableToCopy / (long)Math.pow(2.0, power));
        --power;
        --availableToCount;
        if (divBy == 1) {
            this.availableToArray[availableToCount] = true;
            availableToCopy -= subtractNum;
        }
        subtractNum /= 2L;
        divBy = (int)(availableToCopy / (long)Math.pow(2.0, power));
        --power;
        --availableToCount;
        if (divBy == 1) {
            this.availableToArray[availableToCount] = true;
            availableToCopy -= subtractNum;
        }
        subtractNum /= 2L;
        divBy = (int)(availableToCopy / (long)Math.pow(2.0, power));
        --power;
        --availableToCount;
        if (divBy == 1) {
            this.availableToArray[availableToCount] = true;
            availableToCopy -= subtractNum;
        }
        subtractNum /= 2L;
        divBy = (int)(availableToCopy / (long)Math.pow(2.0, power));
        --power;
        --availableToCount;
        if (divBy == 1) {
            this.availableToArray[availableToCount] = true;
            availableToCopy -= subtractNum;
        }
        subtractNum /= 2L;
        divBy = (int)(availableToCopy / (long)Math.pow(2.0, power));
        --power;
        --availableToCount;
        if (divBy == 1) {
            this.availableToArray[availableToCount] = true;
            availableToCopy -= subtractNum;
        }
        subtractNum /= 2L;
        divBy = (int)(availableToCopy / (long)Math.pow(2.0, power));
        --power;
        --availableToCount;
        if (divBy == 1) {
            this.availableToArray[availableToCount] = true;
            availableToCopy -= subtractNum;
        }
        subtractNum /= 2L;
        divBy = (int)(availableToCopy / (long)Math.pow(2.0, power));
        --power;
        --availableToCount;
        if (divBy == 1) {
            this.availableToArray[availableToCount] = true;
            availableToCopy -= subtractNum;
        }
        subtractNum /= 2L;
        divBy = (int)(availableToCopy / (long)Math.pow(2.0, power));
        --power;
        --availableToCount;
        if (divBy == 1) {
            this.availableToArray[availableToCount] = true;
            availableToCopy -= subtractNum;
        }
        subtractNum /= 2L;
        divBy = (int)(availableToCopy / (long)Math.pow(2.0, power));
        --power;
        --availableToCount;
        if (divBy == 1) {
            this.availableToArray[availableToCount] = true;
            availableToCopy -= subtractNum;
        }
        subtractNum /= 2L;
        divBy = (int)(availableToCopy / (long)Math.pow(2.0, power));
        --power;
        --availableToCount;
        if (divBy == 1) {
            this.availableToArray[availableToCount] = true;
            availableToCopy -= subtractNum;
        }
        subtractNum /= 2L;
        divBy = (int)(availableToCopy / (long)Math.pow(2.0, power));
        --power;
        --availableToCount;
        if (divBy == 1) {
            this.availableToArray[availableToCount] = true;
            availableToCopy -= subtractNum;
        }
        subtractNum /= 2L;
        divBy = (int)(availableToCopy / (long)Math.pow(2.0, power));
        --power;
        --availableToCount;
        if (divBy == 1) {
            this.availableToArray[availableToCount] = true;
            availableToCopy -= subtractNum;
        }
        subtractNum /= 2L;
        divBy = (int)(availableToCopy / (long)Math.pow(2.0, power));
        --power;
        --availableToCount;
        if (divBy == 1) {
            this.availableToArray[availableToCount] = true;
            availableToCopy -= subtractNum;
        }
        subtractNum /= 2L;
        divBy = (int)(availableToCopy / (long)Math.pow(2.0, power));
        --power;
        --availableToCount;
        if (divBy == 1) {
            this.availableToArray[availableToCount] = true;
            availableToCopy -= subtractNum;
        }
        subtractNum /= 2L;
        divBy = (int)(availableToCopy / (long)Math.pow(2.0, power));
        --power;
        --availableToCount;
        if (divBy == 1) {
            this.availableToArray[availableToCount] = true;
            availableToCopy -= subtractNum;
        }
        subtractNum /= 2L;
        divBy = (int)(availableToCopy / (long)Math.pow(2.0, power));
        --power;
        --availableToCount;
        if (divBy == 1) {
            this.availableToArray[availableToCount] = true;
            availableToCopy -= subtractNum;
        }
        subtractNum /= 2L;
        divBy = (int)(availableToCopy / (long)Math.pow(2.0, power));
        --power;
        --availableToCount;
        if (divBy == 1) {
            this.availableToArray[availableToCount] = true;
            availableToCopy -= subtractNum;
        }
        subtractNum /= 2L;
        divBy = (int)(availableToCopy / (long)Math.pow(2.0, power));
        --power;
        --availableToCount;
        if (divBy == 1) {
            this.availableToArray[availableToCount] = true;
            availableToCopy -= subtractNum;
        }
        subtractNum /= 2L;
        divBy = (int)(availableToCopy / (long)Math.pow(2.0, power));
        --power;
        --availableToCount;
        if (divBy == 1) {
            this.availableToArray[availableToCount] = true;
            availableToCopy -= subtractNum;
        }
        subtractNum /= 2L;
        divBy = (int)(availableToCopy / (long)Math.pow(2.0, power));
        --power;
        --availableToCount;
        if (divBy == 1) {
            this.availableToArray[availableToCount] = true;
            availableToCopy -= subtractNum;
        }
        subtractNum /= 2L;
        divBy = (int)(availableToCopy / (long)Math.pow(2.0, power));
        --power;
        --availableToCount;
        if (divBy == 1) {
            this.availableToArray[availableToCount] = true;
            availableToCopy -= subtractNum;
        }
        subtractNum /= 2L;
        divBy = (int)(availableToCopy / (long)Math.pow(2.0, power));
        --power;
        --availableToCount;
        if (divBy == 1) {
            this.availableToArray[availableToCount] = true;
            availableToCopy -= subtractNum;
        }
        --power;
        assert (--availableToCount == 0) : "Wrong number of iterations of unrolled loop";
    }

    private void extractOrders() {
        int ordersCopy = this.standardOrdersSpecialActions;
        int divBy = ordersCopy / (int)Math.pow(2.0, 26.0);
        if (divBy == 1) {
            this.joinCity = true;
            ordersCopy -= 0x4000000;
        }
        if ((divBy = ordersCopy / (int)Math.pow(2.0, 25.0)) == 1) {
            this.automate = true;
            ordersCopy -= 0x2000000;
        }
        if ((divBy = ordersCopy / (int)Math.pow(2.0, 24.0)) == 1) {
            this.clearPollution = true;
            ordersCopy -= 0x1000000;
        }
        if ((divBy = ordersCopy / (int)Math.pow(2.0, 23.0)) == 1) {
            this.plantForest = true;
            ordersCopy -= 0x800000;
        }
        if ((divBy = ordersCopy / (int)Math.pow(2.0, 22.0)) == 1) {
            this.clearJungle = true;
            ordersCopy -= 0x400000;
        }
        if ((divBy = ordersCopy / (int)Math.pow(2.0, 21.0)) == 1) {
            this.clearForest = true;
            ordersCopy -= 0x200000;
        }
        if ((divBy = ordersCopy / (int)Math.pow(2.0, 20.0)) == 1) {
            this.irrigate = true;
            ordersCopy -= 0x100000;
        }
        if ((divBy = ordersCopy / (int)Math.pow(2.0, 19.0)) == 1) {
            this.buildMine = true;
            ordersCopy -= 524288;
        }
        if ((divBy = ordersCopy / (int)Math.pow(2.0, 18.0)) == 1) {
            this.buildFort = true;
            ordersCopy -= 262144;
        }
        if ((divBy = ordersCopy / (int)Math.pow(2.0, 17.0)) == 1) {
            this.buildRailroad = true;
            ordersCopy -= 131072;
        }
        if ((divBy = ordersCopy / (int)Math.pow(2.0, 16.0)) == 1) {
            this.buildRoad = true;
            ordersCopy -= 65536;
        }
        if ((divBy = ordersCopy / (int)Math.pow(2.0, 15.0)) == 1) {
            this.buildCity = true;
            ordersCopy -= 32768;
        }
        if ((divBy = ordersCopy / (int)Math.pow(2.0, 14.0)) == 1) {
            this.buildColony = true;
            ordersCopy -= 16384;
        }
        if ((divBy = ordersCopy / (int)Math.pow(2.0, 13.0)) == 1) {
            this.upgrade = true;
            ordersCopy -= 8192;
        }
        if ((divBy = ordersCopy / (int)Math.pow(2.0, 12.0)) == 1) {
            this.finishImprovement = true;
            ordersCopy -= 4096;
        }
        if ((divBy = ordersCopy / (int)Math.pow(2.0, 11.0)) == 1) {
            this.buildArmy = true;
            ordersCopy -= 2048;
        }
        if ((divBy = ordersCopy / (int)Math.pow(2.0, 10.0)) == 1) {
            this.airdrop = true;
            ordersCopy -= 1024;
        }
        if ((divBy = ordersCopy / (int)Math.pow(2.0, 9.0)) == 1) {
            this.bombard = true;
            ordersCopy -= 512;
        }
        if ((divBy = ordersCopy / (int)Math.pow(2.0, 8.0)) == 1) {
            this.pillage = true;
            ordersCopy -= 256;
        }
        if ((divBy = ordersCopy / (int)Math.pow(2.0, 7.0)) == 1) {
            this.airlift = true;
            ordersCopy -= 128;
        }
        if ((divBy = ordersCopy / (int)Math.pow(2.0, 6.0)) == 1) {
            this.unload = true;
            ordersCopy -= 64;
        }
        if ((divBy = ordersCopy / (int)Math.pow(2.0, 5.0)) == 1) {
            this.load = true;
            ordersCopy -= 32;
        }
        if ((divBy = ordersCopy / (int)Math.pow(2.0, 4.0)) == 1) {
            this.goTo = true;
            ordersCopy -= 16;
        }
        if ((divBy = ordersCopy / (int)Math.pow(2.0, 3.0)) == 1) {
            this.disband = true;
            ordersCopy -= 8;
        }
        if ((divBy = ordersCopy / (int)Math.pow(2.0, 2.0)) == 1) {
            this.fortify = true;
            ordersCopy -= 4;
        }
        if ((divBy = ordersCopy / (int)Math.pow(2.0, 1.0)) == 1) {
            this.wait = true;
            ordersCopy -= 2;
        }
        if ((divBy = ordersCopy / (int)Math.pow(2.0, 0.0)) == 1) {
            this.skipTurn = true;
            --ordersCopy;
        }
    }

    private void extractAirMissions() {
        int airMissionCopy = this.airMissions;
        int divBy = airMissionCopy / (int)Math.pow(2.0, 4.0);
        if (divBy == 1) {
            this.precisionBomb = true;
            airMissionCopy -= 16;
        }
        if ((divBy = airMissionCopy / (int)Math.pow(2.0, 3.0)) == 1) {
            this.rebase = true;
            airMissionCopy -= 8;
        }
        if ((divBy = airMissionCopy / (int)Math.pow(2.0, 2.0)) == 1) {
            this.intercept = true;
            airMissionCopy -= 4;
        }
        if ((divBy = airMissionCopy / (int)Math.pow(2.0, 1.0)) == 1) {
            this.recon = true;
            airMissionCopy -= 2;
        }
        if ((divBy = airMissionCopy / (int)Math.pow(2.0, 0.0)) == 1) {
            this.bomb = true;
            --airMissionCopy;
        }
    }

    private void extractPTWStandardOrders() {
        int PTWStandardOdersCopy = this.PTWStandardOrders;
        int divBy = PTWStandardOdersCopy / (int)Math.pow(2.0, 6.0);
        if (divBy == 1) {
            this.PTWsentry = true;
            PTWStandardOdersCopy -= 64;
        }
        if ((divBy = PTWStandardOdersCopy / (int)Math.pow(2.0, 5.0)) == 1) {
            this.PTWexploreOrder = true;
            PTWStandardOdersCopy -= 32;
        }
        if ((divBy = PTWStandardOdersCopy / (int)Math.pow(2.0, 4.0)) == 1) {
            this.PTWgoTo = true;
            PTWStandardOdersCopy -= 16;
        }
        if ((divBy = PTWStandardOdersCopy / (int)Math.pow(2.0, 3.0)) == 1) {
            this.PTWdisband = true;
            PTWStandardOdersCopy -= 8;
        }
        if ((divBy = PTWStandardOdersCopy / (int)Math.pow(2.0, 2.0)) == 1) {
            this.PTWfortify = true;
            PTWStandardOdersCopy -= 4;
        }
        if ((divBy = PTWStandardOdersCopy / (int)Math.pow(2.0, 1.0)) == 1) {
            this.PTWwait = true;
            PTWStandardOdersCopy -= 2;
        }
        if ((divBy = PTWStandardOdersCopy / (int)Math.pow(2.0, 0.0)) == 1) {
            this.PTWskipTurn = true;
            --PTWStandardOdersCopy;
        }
    }

    private void extractPTWSpecialActions() {
        int PTWSpecialActionsCopy = this.PTWSpecialActions;
        int divBy = PTWSpecialActionsCopy / (int)Math.pow(2.0, 21.0);
        if (divBy == 1) {
            this.scienceAge = true;
            PTWSpecialActionsCopy -= 0x200000;
        }
        if ((divBy = PTWSpecialActionsCopy / (int)Math.pow(2.0, 20.0)) == 1) {
            this.sacrifice = true;
            PTWSpecialActionsCopy -= 0x100000;
        }
        if ((divBy = PTWSpecialActionsCopy / (int)Math.pow(2.0, 19.0)) == 1) {
            this.collateralDamage = true;
            PTWSpecialActionsCopy -= 524288;
        }
        if ((divBy = PTWSpecialActionsCopy / (int)Math.pow(2.0, 18.0)) == 1) {
            this.enslave = true;
            PTWSpecialActionsCopy -= 262144;
        }
        if ((divBy = PTWSpecialActionsCopy / (int)Math.pow(2.0, 17.0)) == 1) {
            this.charm = true;
            PTWSpecialActionsCopy -= 131072;
        }
        if ((divBy = PTWSpecialActionsCopy / (int)Math.pow(2.0, 16.0)) == 1) {
            this.stealthAttack = true;
            PTWSpecialActionsCopy -= 65536;
        }
        if ((divBy = PTWSpecialActionsCopy / (int)Math.pow(2.0, 15.0)) == 1) {
            this.teleportable = true;
            PTWSpecialActionsCopy -= 32768;
        }
        if ((divBy = PTWSpecialActionsCopy / (int)Math.pow(2.0, 14.0)) == 1) {
            this.telepad = true;
            PTWSpecialActionsCopy -= 16384;
        }
        if ((divBy = PTWSpecialActionsCopy / (int)Math.pow(2.0, 9.0)) == 1) {
            this.PTWcapture = true;
            PTWSpecialActionsCopy -= 512;
        }
        if ((divBy = PTWSpecialActionsCopy / (int)Math.pow(2.0, 8.0)) == 1) {
            this.PTWupgradeUnit = true;
            PTWSpecialActionsCopy -= 256;
        }
        if ((divBy = PTWSpecialActionsCopy / (int)Math.pow(2.0, 7.0)) == 1) {
            this.PTWfinishImprovements = true;
            PTWSpecialActionsCopy -= 128;
        }
        if ((divBy = PTWSpecialActionsCopy / (int)Math.pow(2.0, 6.0)) == 1) {
            this.PTWbuildArmy = true;
            PTWSpecialActionsCopy -= 64;
        }
        if ((divBy = PTWSpecialActionsCopy / (int)Math.pow(2.0, 5.0)) == 1) {
            this.PTWairdrop = true;
            PTWSpecialActionsCopy -= 32;
        }
        if ((divBy = PTWSpecialActionsCopy / (int)Math.pow(2.0, 4.0)) == 1) {
            this.PTWbombard = true;
            PTWSpecialActionsCopy -= 16;
        }
        if ((divBy = PTWSpecialActionsCopy / (int)Math.pow(2.0, 3.0)) == 1) {
            this.PTWpillage = true;
            PTWSpecialActionsCopy -= 8;
        }
        if ((divBy = PTWSpecialActionsCopy / (int)Math.pow(2.0, 2.0)) == 1) {
            this.PTWairlift = true;
            PTWSpecialActionsCopy -= 4;
        }
        if ((divBy = PTWSpecialActionsCopy / (int)Math.pow(2.0, 1.0)) == 1) {
            this.PTWunload = true;
            PTWSpecialActionsCopy -= 2;
        }
        if ((divBy = PTWSpecialActionsCopy / (int)Math.pow(2.0, 0.0)) == 1) {
            this.PTWload = true;
            --PTWSpecialActionsCopy;
        }
    }

    private void extractPTWWorkerActions() {
        int PTWWorkerActionsCopy = this.PTWWorkerActions;
        int divBy = PTWWorkerActionsCopy / (int)Math.pow(2.0, 16.0);
        if (divBy == 1) {
            this.PTWbuildBarricade = true;
            PTWWorkerActionsCopy -= 65536;
        }
        if ((divBy = PTWWorkerActionsCopy / (int)Math.pow(2.0, 15.0)) == 1) {
            this.PTWbuildOutpost = true;
            PTWWorkerActionsCopy -= 32768;
        }
        if ((divBy = PTWWorkerActionsCopy / (int)Math.pow(2.0, 14.0)) == 1) {
            this.PTWbuildRadarTower = true;
            PTWWorkerActionsCopy -= 16384;
        }
        if ((divBy = PTWWorkerActionsCopy / (int)Math.pow(2.0, 13.0)) == 1) {
            this.PTWbuildAirfield = true;
            PTWWorkerActionsCopy -= 8192;
        }
        if ((divBy = PTWWorkerActionsCopy / (int)Math.pow(2.0, 12.0)) == 1) {
            this.PTWjoinCity = true;
            PTWWorkerActionsCopy -= 4096;
        }
        if ((divBy = PTWWorkerActionsCopy / (int)Math.pow(2.0, 11.0)) == 1) {
            this.PTWautomate = true;
            PTWWorkerActionsCopy -= 2048;
        }
        if ((divBy = PTWWorkerActionsCopy / (int)Math.pow(2.0, 10.0)) == 1) {
            this.PTWclearPollution = true;
            PTWWorkerActionsCopy -= 1024;
        }
        if ((divBy = PTWWorkerActionsCopy / (int)Math.pow(2.0, 9.0)) == 1) {
            this.PTWplantForest = true;
            PTWWorkerActionsCopy -= 512;
        }
        if ((divBy = PTWWorkerActionsCopy / (int)Math.pow(2.0, 8.0)) == 1) {
            this.PTWclearJungle = true;
            PTWWorkerActionsCopy -= 256;
        }
        if ((divBy = PTWWorkerActionsCopy / (int)Math.pow(2.0, 7.0)) == 1) {
            this.PTWclearForest = true;
            PTWWorkerActionsCopy -= 128;
        }
        if ((divBy = PTWWorkerActionsCopy / (int)Math.pow(2.0, 6.0)) == 1) {
            this.PTWirrigate = true;
            PTWWorkerActionsCopy -= 64;
        }
        if ((divBy = PTWWorkerActionsCopy / (int)Math.pow(2.0, 5.0)) == 1) {
            this.PTWbuildMine = true;
            PTWWorkerActionsCopy -= 32;
        }
        if ((divBy = PTWWorkerActionsCopy / (int)Math.pow(2.0, 4.0)) == 1) {
            this.PTWbuildFort = true;
            PTWWorkerActionsCopy -= 16;
        }
        if ((divBy = PTWWorkerActionsCopy / (int)Math.pow(2.0, 3.0)) == 1) {
            this.PTWbuildRailroad = true;
            PTWWorkerActionsCopy -= 8;
        }
        if ((divBy = PTWWorkerActionsCopy / (int)Math.pow(2.0, 2.0)) == 1) {
            this.PTWbuildRoad = true;
            PTWWorkerActionsCopy -= 4;
        }
        if ((divBy = PTWWorkerActionsCopy / (int)Math.pow(2.0, 1.0)) == 1) {
            this.PTWbuildCity = true;
            PTWWorkerActionsCopy -= 2;
        }
        if ((divBy = PTWWorkerActionsCopy / (int)Math.pow(2.0, 0.0)) == 1) {
            this.PTWbuildColony = true;
            --PTWWorkerActionsCopy;
        }
    }

    private void extractPTWAirMissions() {
        int PTWairMissionCopy = this.PTWAirMissions;
        int divBy = PTWairMissionCopy / (int)Math.pow(2.0, 4.0);
        if (divBy == 1) {
            this.PTWprecisionBomb = true;
            PTWairMissionCopy -= 16;
        }
        if ((divBy = PTWairMissionCopy / (int)Math.pow(2.0, 3.0)) == 1) {
            this.PTWrebase = true;
            PTWairMissionCopy -= 8;
        }
        if ((divBy = PTWairMissionCopy / (int)Math.pow(2.0, 2.0)) == 1) {
            this.PTWintercept = true;
            PTWairMissionCopy -= 4;
        }
        if ((divBy = PTWairMissionCopy / (int)Math.pow(2.0, 1.0)) == 1) {
            this.PTWrecon = true;
            PTWairMissionCopy -= 2;
        }
        if ((divBy = PTWairMissionCopy / (int)Math.pow(2.0, 0.0)) == 1) {
            this.PTWbomb = true;
            --PTWairMissionCopy;
        }
    }

    private void extractPTWActionMix() {
        int PTWActionMixCopy = this.PTWActionsMix;
        int divBy = PTWActionMixCopy / (int)Math.pow(2.0, 15.0);
        if (divBy == 1) {
            this.goToMix = true;
            PTWActionMixCopy -= 32768;
        }
        if ((divBy = PTWActionMixCopy / (int)Math.pow(2.0, 14.0)) == 1) {
            this.automate3 = true;
            PTWActionMixCopy -= 16384;
        }
        if ((divBy = PTWActionMixCopy / (int)Math.pow(2.0, 13.0)) == 1) {
            this.precisionBombingMix = true;
            PTWActionMixCopy -= 8192;
        }
        if ((divBy = PTWActionMixCopy / (int)Math.pow(2.0, 12.0)) == 1) {
            this.bombingMix = true;
            PTWActionMixCopy -= 4096;
        }
        if ((divBy = PTWActionMixCopy / (int)Math.pow(2.0, 11.0)) == 1) {
            this.automate2Mix = true;
            PTWActionMixCopy -= 2048;
        }
        if ((divBy = PTWActionMixCopy / (int)Math.pow(2.0, 10.0)) == 1) {
            this.automateMix = true;
            PTWActionMixCopy -= 1024;
        }
        if ((divBy = PTWActionMixCopy / (int)Math.pow(2.0, 9.0)) == 1) {
            this.clearPollutionMix = true;
            PTWActionMixCopy -= 512;
        }
        if ((divBy = PTWActionMixCopy / (int)Math.pow(2.0, 8.0)) == 1) {
            this.clearJungleMix = true;
            PTWActionMixCopy -= 256;
        }
        if ((divBy = PTWActionMixCopy / (int)Math.pow(2.0, 7.0)) == 1) {
            this.clearForestMix = true;
            PTWActionMixCopy -= 128;
        }
        if ((divBy = PTWActionMixCopy / (int)Math.pow(2.0, 6.0)) == 1) {
            this.irrigateMix = true;
            PTWActionMixCopy -= 64;
        }
        if ((divBy = PTWActionMixCopy / (int)Math.pow(2.0, 5.0)) == 1) {
            this.road2Mix = true;
            PTWActionMixCopy -= 32;
        }
        if ((divBy = PTWActionMixCopy / (int)Math.pow(2.0, 4.0)) == 1) {
            this.railroadMix = true;
            PTWActionMixCopy -= 16;
        }
        if ((divBy = PTWActionMixCopy / (int)Math.pow(2.0, 3.0)) == 1) {
            this.roadMix = true;
            PTWActionMixCopy -= 8;
        }
        if ((divBy = PTWActionMixCopy / (int)Math.pow(2.0, 2.0)) == 1) {
            this.colonyMix = true;
            PTWActionMixCopy -= 4;
        }
        if ((divBy = PTWActionMixCopy / (int)Math.pow(2.0, 1.0)) == 1) {
            this.bombardMix = true;
            PTWActionMixCopy -= 2;
        }
        if ((divBy = PTWActionMixCopy / (int)Math.pow(2.0, 0.0)) == 1) {
            this.sentryMix = true;
            --PTWActionMixCopy;
        }
    }

    private void extractUnitAbilities() {
        int unitAbilityCopy = this.unitAbilities;
        int divBy = unitAbilityCopy / (int)Math.pow(2.0, 30.0);
        if (divBy == 1) {
            this.requiresEscort = true;
            unitAbilityCopy -= 0x40000000;
        }
        if ((divBy = unitAbilityCopy / (int)Math.pow(2.0, 29.0)) == 1) {
            this.king = true;
            unitAbilityCopy -= 0x20000000;
        }
        if ((divBy = unitAbilityCopy / (int)Math.pow(2.0, 28.0)) == 1) {
            this.lethalSeaBombardment = true;
            unitAbilityCopy -= 0x10000000;
        }
        if ((divBy = unitAbilityCopy / (int)Math.pow(2.0, 27.0)) == 1) {
            this.lethalLandBombardment = true;
            unitAbilityCopy -= 0x8000000;
        }
        if ((divBy = unitAbilityCopy / (int)Math.pow(2.0, 26.0)) == 1) {
            this.rotateBeforeAttack = true;
            unitAbilityCopy -= 0x4000000;
        }
        if ((divBy = unitAbilityCopy / (int)Math.pow(2.0, 25.0)) == 1) {
            this.rangedAttackAnimations = true;
            unitAbilityCopy -= 0x2000000;
        }
        if ((divBy = unitAbilityCopy / (int)Math.pow(2.0, 24.0)) == 1) {
            this.transportsOnlyTacticalMissiles = true;
            unitAbilityCopy -= 0x1000000;
        }
        if ((divBy = unitAbilityCopy / (int)Math.pow(2.0, 23.0)) == 1) {
            this.tacticalMissile = true;
            unitAbilityCopy -= 0x800000;
        }
        if ((divBy = unitAbilityCopy / (int)Math.pow(2.0, 22.0)) == 1) {
            this.detectInvisible = true;
            unitAbilityCopy -= 0x400000;
        }
        if ((divBy = unitAbilityCopy / (int)Math.pow(2.0, 21.0)) == 1) {
            this.stealth = true;
            unitAbilityCopy -= 0x200000;
        }
        if ((divBy = unitAbilityCopy / (int)Math.pow(2.0, 20.0)) == 1) {
            this.infiniteBombardRange = true;
            unitAbilityCopy -= 0x100000;
        }
        if ((divBy = unitAbilityCopy / (int)Math.pow(2.0, 19.0)) == 1) {
            this.leader = true;
            unitAbilityCopy -= 524288;
        }
        if ((divBy = unitAbilityCopy / (int)Math.pow(2.0, 18.0)) == 1) {
            this.army = true;
            unitAbilityCopy -= 262144;
        }
        if ((divBy = unitAbilityCopy / (int)Math.pow(2.0, 17.0)) == 1) {
            this.hiddenNationality = true;
            unitAbilityCopy -= 131072;
        }
        if ((divBy = unitAbilityCopy / (int)Math.pow(2.0, 16.0)) == 1) {
            this.nuclearWeapon = true;
            unitAbilityCopy -= 65536;
        }
        if ((divBy = unitAbilityCopy / (int)Math.pow(2.0, 15.0)) == 1) {
            this.startsGoldenAge = true;
            unitAbilityCopy -= 32768;
        }
        if ((divBy = unitAbilityCopy / (int)Math.pow(2.0, 14.0)) == 1) {
            this.transportsOnlyFootUnits = true;
            unitAbilityCopy -= 16384;
        }
        if ((divBy = unitAbilityCopy / (int)Math.pow(2.0, 13.0)) == 1) {
            this.flagUnit = true;
            unitAbilityCopy -= 8192;
        }
        if ((divBy = unitAbilityCopy / (int)Math.pow(2.0, 12.0)) == 1) {
            this.sinksInOcean = true;
            unitAbilityCopy -= 4096;
        }
        if ((divBy = unitAbilityCopy / (int)Math.pow(2.0, 11.0)) == 1) {
            this.sinksInSea = true;
            unitAbilityCopy -= 2048;
        }
        if ((divBy = unitAbilityCopy / (int)Math.pow(2.0, 10.0)) == 1) {
            this.immobile = true;
            unitAbilityCopy -= 1024;
        }
        if ((divBy = unitAbilityCopy / (int)Math.pow(2.0, 9.0)) == 1) {
            this.draftable = true;
            unitAbilityCopy -= 512;
        }
        if ((divBy = unitAbilityCopy / (int)Math.pow(2.0, 8.0)) == 1) {
            this.transportsOnlyAirUnits = true;
            unitAbilityCopy -= 256;
        }
        if ((divBy = unitAbilityCopy / (int)Math.pow(2.0, 7.0)) == 1) {
            this.invisible = true;
            unitAbilityCopy -= 128;
        }
        if ((divBy = unitAbilityCopy / (int)Math.pow(2.0, 6.0)) == 1) {
            this.amphibiousUnit = true;
            unitAbilityCopy -= 64;
        }
        if ((divBy = unitAbilityCopy / (int)Math.pow(2.0, 5.0)) == 1) {
            this.radar = true;
            unitAbilityCopy -= 32;
        }
        if ((divBy = unitAbilityCopy / (int)Math.pow(2.0, 4.0)) == 1) {
            this.allTerrainAsRoads = true;
            unitAbilityCopy -= 16;
        }
        if ((divBy = unitAbilityCopy / (int)Math.pow(2.0, 3.0)) == 1) {
            this.cruiseMissile = true;
            unitAbilityCopy -= 8;
        }
        if ((divBy = unitAbilityCopy / (int)Math.pow(2.0, 2.0)) == 1) {
            this.blitz = true;
            unitAbilityCopy -= 4;
        }
        if ((divBy = unitAbilityCopy / (int)Math.pow(2.0, 1.0)) == 1) {
            this.footSoldier = true;
            unitAbilityCopy -= 2;
        }
        if ((divBy = unitAbilityCopy / (int)Math.pow(2.0, 0.0)) == 1) {
            this.wheeled = true;
            --unitAbilityCopy;
        }
    }

    @Override
    public String toEnglish() {
        int j;
        String lineReturn = System.getProperty("line.separator");
        String toReturn = "name: " + this.name + lineReturn;
        toReturn = toReturn + "civilopediaEntry: " + this.civilopediaEntry + lineReturn;
        toReturn = toReturn + "index: " + this.index + lineReturn;
        toReturn = toReturn + "dataLength: " + this.dataLength + lineReturn;
        toReturn = toReturn + "zoneOfControl: " + this.zoneOfControl + lineReturn;
        toReturn = toReturn + "bombardStrength: " + this.bombardStrength + lineReturn;
        toReturn = toReturn + "bombardRange: " + this.bombardRange + lineReturn;
        toReturn = toReturn + "capacity: " + this.capacity + lineReturn;
        toReturn = toReturn + "shieldCost: " + this.shieldCost + lineReturn;
        toReturn = toReturn + "defence: " + this.defence + lineReturn;
        toReturn = toReturn + "iconIndex: " + this.iconIndex + lineReturn;
        toReturn = toReturn + "attack: " + this.attack + lineReturn;
        toReturn = toReturn + "operationalRange: " + this.operationalRange + lineReturn;
        toReturn = toReturn + "populationCost: " + this.populationCost + lineReturn;
        toReturn = toReturn + "rateOfFire: " + this.rateOfFire + lineReturn;
        toReturn = toReturn + "movement: " + this.movement + lineReturn;
        toReturn = toReturn + "requiredTech: " + this.requiredTechInt + lineReturn;
        toReturn = toReturn + "upgradeTo: " + this.upgradeToInt + lineReturn;
        toReturn = toReturn + "requiredResource1: " + this.requiredResource1Int + lineReturn;
        toReturn = toReturn + "requiredResource2: " + this.requiredResource2Int + lineReturn;
        toReturn = toReturn + "requiredResource3: " + this.requiredResource3Int + lineReturn;
        toReturn = toReturn + "unitAbilities: " + this.unitAbilities + lineReturn;
        toReturn = toReturn + "  wheeled: " + this.wheeled + lineReturn;
        toReturn = toReturn + "  footSoldier: " + this.footSoldier + lineReturn;
        toReturn = toReturn + "  blitz: " + this.blitz + lineReturn;
        toReturn = toReturn + "  cruiseMissile: " + this.cruiseMissile + lineReturn;
        toReturn = toReturn + "  allTerrainAsRoads: " + this.allTerrainAsRoads + lineReturn;
        toReturn = toReturn + "  radar: " + this.radar + lineReturn;
        toReturn = toReturn + "  amphibiousUnit: " + this.amphibiousUnit + lineReturn;
        toReturn = toReturn + "  invisible: " + this.invisible + lineReturn;
        toReturn = toReturn + "  transportsOnlyAirUnits: " + this.transportsOnlyAirUnits + lineReturn;
        toReturn = toReturn + "  draftable: " + this.draftable + lineReturn;
        toReturn = toReturn + "  immobile: " + this.immobile + lineReturn;
        toReturn = toReturn + "  sinksInSea: " + this.sinksInSea + lineReturn;
        toReturn = toReturn + "  sinksInOcean: " + this.sinksInOcean + lineReturn;
        toReturn = toReturn + "  flagUnit: " + this.flagUnit + lineReturn;
        toReturn = toReturn + "  transportsOnlyFootUnits: " + this.transportsOnlyFootUnits + lineReturn;
        toReturn = toReturn + "  startsGoldenAge: " + this.startsGoldenAge + lineReturn;
        toReturn = toReturn + "  nuclearWeapon: " + this.nuclearWeapon + lineReturn;
        toReturn = toReturn + "  hiddenNationality: " + this.hiddenNationality + lineReturn;
        toReturn = toReturn + "  army: " + this.army + lineReturn;
        toReturn = toReturn + "  leader: " + this.leader + lineReturn;
        toReturn = toReturn + "  infiniteBombardRange: " + this.infiniteBombardRange + lineReturn;
        toReturn = toReturn + "  stealth: " + this.stealth + lineReturn;
        toReturn = toReturn + "  detectInvisible: " + this.detectInvisible + lineReturn;
        toReturn = toReturn + "  tacticalMissile: " + this.tacticalMissile + lineReturn;
        toReturn = toReturn + "  transportsOnlyTacticalMissiles: " + this.transportsOnlyTacticalMissiles + lineReturn;
        toReturn = toReturn + "  rangedAttackAnimations: " + this.rangedAttackAnimations + lineReturn;
        toReturn = toReturn + "  rotateBeforeAttack: " + this.rotateBeforeAttack + lineReturn;
        toReturn = toReturn + "  lethalLandBombardment: " + this.lethalLandBombardment + lineReturn;
        toReturn = toReturn + "  lethalSeaBombardment: " + this.lethalSeaBombardment + lineReturn;
        toReturn = toReturn + "  king: " + this.king + lineReturn;
        toReturn = toReturn + "  requiresEscort: " + this.requiresEscort + lineReturn;
        toReturn = toReturn + "AIStrategy: " + this.AIStrategy + lineReturn;
        toReturn = toReturn + "  offence: " + this.offence + lineReturn;
        toReturn = toReturn + "  defenceStrategy: " + this.defenceStrategy + lineReturn;
        toReturn = toReturn + "  artillery: " + this.artillery + lineReturn;
        toReturn = toReturn + "  exploreStrategy: " + this.exploreStrategy + lineReturn;
        toReturn = toReturn + "  armyUnit: " + this.armyUnit + lineReturn;
        toReturn = toReturn + "  cruiseMissileUnit: " + this.cruiseMissileUnit + lineReturn;
        toReturn = toReturn + "  airBombard: " + this.airBombard + lineReturn;
        toReturn = toReturn + "  airDefenceStrategy: " + this.airDefenceStrategy + lineReturn;
        toReturn = toReturn + "  navalPower: " + this.navalPower + lineReturn;
        toReturn = toReturn + "  airTransport: " + this.airTransport + lineReturn;
        toReturn = toReturn + "  navalTransport: " + this.navalTransport + lineReturn;
        toReturn = toReturn + "  navalCarrier: " + this.navalCarrier + lineReturn;
        toReturn = toReturn + "  terraform: " + this.terraform + lineReturn;
        toReturn = toReturn + "  settle: " + this.settle + lineReturn;
        toReturn = toReturn + "  leaderUnit: " + this.leaderUnit + lineReturn;
        toReturn = toReturn + "  tacticalNuke: " + this.tacticalNuke + lineReturn;
        toReturn = toReturn + "  ICBM: " + this.ICBM + lineReturn;
        toReturn = toReturn + "  navalMissileTransport: " + this.navalMissileTransport + lineReturn;
        toReturn = toReturn + "availableTo: " + this.availableTo + lineReturn;
        toReturn = toReturn + "standardOrdersSpecialActions: " + this.standardOrdersSpecialActions + lineReturn;
        toReturn = toReturn + "  skipTurn: " + this.skipTurn + lineReturn;
        toReturn = toReturn + "  wait: " + this.wait + lineReturn;
        toReturn = toReturn + "  fortify: " + this.fortify + lineReturn;
        toReturn = toReturn + "  disband: " + this.disband + lineReturn;
        toReturn = toReturn + "  goTo: " + this.goTo + lineReturn;
        toReturn = toReturn + "  load: " + this.load + lineReturn;
        toReturn = toReturn + "  unload: " + this.unload + lineReturn;
        toReturn = toReturn + "  airlift: " + this.airlift + lineReturn;
        toReturn = toReturn + "  pillage: " + this.pillage + lineReturn;
        toReturn = toReturn + "  bombard: " + this.bombard + lineReturn;
        toReturn = toReturn + "  airdrop: " + this.airdrop + lineReturn;
        toReturn = toReturn + "  buildArmy: " + this.buildArmy + lineReturn;
        toReturn = toReturn + "  finishImprovement: " + this.finishImprovement + lineReturn;
        toReturn = toReturn + "  upgrade: " + this.upgrade + lineReturn;
        toReturn = toReturn + "  buildColony: " + this.buildColony + lineReturn;
        toReturn = toReturn + "  buildCity: " + this.buildCity + lineReturn;
        toReturn = toReturn + "  buildRoad: " + this.buildRoad + lineReturn;
        toReturn = toReturn + "  buildRailroad: " + this.buildRailroad + lineReturn;
        toReturn = toReturn + "  buildFort: " + this.buildFort + lineReturn;
        toReturn = toReturn + "  buildMine: " + this.buildMine + lineReturn;
        toReturn = toReturn + "  irrigate: " + this.irrigate + lineReturn;
        toReturn = toReturn + "  clearForest: " + this.clearForest + lineReturn;
        toReturn = toReturn + "  clearJungle: " + this.clearJungle + lineReturn;
        toReturn = toReturn + "  plantForest: " + this.plantForest + lineReturn;
        toReturn = toReturn + "  clearPollution: " + this.clearPollution + lineReturn;
        toReturn = toReturn + "  automate: " + this.automate + lineReturn;
        toReturn = toReturn + "  joinCity: " + this.joinCity + lineReturn;
        toReturn = toReturn + "airMissions: " + this.airMissions + lineReturn;
        toReturn = toReturn + "  bomb: " + this.bomb + lineReturn;
        toReturn = toReturn + "  recon: " + this.recon + lineReturn;
        toReturn = toReturn + "  intercept: " + this.intercept + lineReturn;
        toReturn = toReturn + "  rebase: " + this.rebase + lineReturn;
        toReturn = toReturn + "  precisionBombing: " + this.precisionBomb + lineReturn;
        toReturn = toReturn + "unitClass: " + this.unitClass + lineReturn;
        toReturn = toReturn + "otherStrategy: " + this.otherStrategy + lineReturn;
        toReturn = toReturn + "hitPointBonus: " + this.hitPointBonus + lineReturn;
        toReturn = toReturn + "PTWStandardOrders: " + this.PTWStandardOrders + lineReturn;
        toReturn = toReturn + "  PTWskipTurn: " + this.PTWskipTurn + lineReturn;
        toReturn = toReturn + "  PTWwait: " + this.PTWwait + lineReturn;
        toReturn = toReturn + "  PTWfortify: " + this.PTWfortify + lineReturn;
        toReturn = toReturn + "  PTWdisband: " + this.PTWdisband + lineReturn;
        toReturn = toReturn + "  PTWgoTo: " + this.PTWgoTo + lineReturn;
        toReturn = toReturn + "  PTWexplore: " + this.PTWexploreOrder + lineReturn;
        toReturn = toReturn + "  PTWsentry: " + this.PTWsentry + lineReturn;
        toReturn = toReturn + "PTWSpecialActions: " + this.PTWSpecialActions + lineReturn;
        toReturn = toReturn + "  PTWload: " + this.PTWload + lineReturn;
        toReturn = toReturn + "  PTWunload: " + this.PTWunload + lineReturn;
        toReturn = toReturn + "  PTWairlift: " + this.PTWairlift + lineReturn;
        toReturn = toReturn + "  PTWpillage: " + this.PTWpillage + lineReturn;
        toReturn = toReturn + "  PTWbombard: " + this.PTWbombard + lineReturn;
        toReturn = toReturn + "  PTWairdrop: " + this.PTWairdrop + lineReturn;
        toReturn = toReturn + "  PTWbuildArmy: " + this.PTWbuildArmy + lineReturn;
        toReturn = toReturn + "  PTWfinishImprovements: " + this.PTWfinishImprovements + lineReturn;
        toReturn = toReturn + "  PTWupgradeUnit: " + this.PTWupgradeUnit + lineReturn;
        toReturn = toReturn + "  PTWcapture: " + this.PTWcapture + lineReturn;
        toReturn = toReturn + "PTWWorkerActions: " + this.PTWWorkerActions + lineReturn;
        toReturn = toReturn + "  PTWbuildColony: " + this.PTWbuildColony + lineReturn;
        toReturn = toReturn + "  PTWbuildCity: " + this.PTWbuildCity + lineReturn;
        toReturn = toReturn + "  PTWbuildRoad: " + this.PTWbuildRoad + lineReturn;
        toReturn = toReturn + "  PTWbuildRailroad: " + this.PTWbuildRailroad + lineReturn;
        toReturn = toReturn + "  PTWbuildFort: " + this.PTWbuildFort + lineReturn;
        toReturn = toReturn + "  PTWbuildMine: " + this.PTWbuildMine + lineReturn;
        toReturn = toReturn + "  PTWirrigate: " + this.PTWirrigate + lineReturn;
        toReturn = toReturn + "  PTWclearForest: " + this.PTWclearForest + lineReturn;
        toReturn = toReturn + "  PTWclearJungle: " + this.PTWclearJungle + lineReturn;
        toReturn = toReturn + "  PTWplantForest: " + this.PTWplantForest + lineReturn;
        toReturn = toReturn + "  PTWclearPollution: " + this.PTWclearPollution + lineReturn;
        toReturn = toReturn + "  PTWautomate: " + this.PTWautomate + lineReturn;
        toReturn = toReturn + "  PTWjoinCity: " + this.PTWjoinCity + lineReturn;
        toReturn = toReturn + "  PTWbuildAirfield: " + this.PTWbuildAirfield + lineReturn;
        toReturn = toReturn + "  PTWbuildRadarTower: " + this.PTWbuildRadarTower + lineReturn;
        toReturn = toReturn + "  PTWbuildOutpost: " + this.PTWbuildOutpost + lineReturn;
        toReturn = toReturn + "PTWAirMissions: " + this.PTWAirMissions + lineReturn;
        toReturn = toReturn + "  PTWbomb: " + this.PTWbomb + lineReturn;
        toReturn = toReturn + "  PTWrecon: " + this.PTWrecon + lineReturn;
        toReturn = toReturn + "  PTWintercept: " + this.PTWintercept + lineReturn;
        toReturn = toReturn + "  PTWrebase: " + this.PTWrebase + lineReturn;
        toReturn = toReturn + "  PTWprecisionBomb: " + this.PTWprecisionBomb + lineReturn;
        toReturn = toReturn + "PTWActionsMix: " + this.PTWActionsMix + lineReturn;
        toReturn = toReturn + "  sentryMix: " + this.sentryMix + lineReturn;
        toReturn = toReturn + "  bombardMix: " + this.bombardMix + lineReturn;
        toReturn = toReturn + "  colonyMix: " + this.colonyMix + lineReturn;
        toReturn = toReturn + "  roadMix: " + this.roadMix + lineReturn;
        toReturn = toReturn + "  railroadMix: " + this.railroadMix + lineReturn;
        toReturn = toReturn + "  road2Mix: " + this.road2Mix + lineReturn;
        toReturn = toReturn + "  irrigateMix: " + this.irrigateMix + lineReturn;
        toReturn = toReturn + "  clearForestMix: " + this.clearForestMix + lineReturn;
        toReturn = toReturn + "  clearJungleMix: " + this.clearJungleMix + lineReturn;
        toReturn = toReturn + "  clearPollutionMix: " + this.clearPollutionMix + lineReturn;
        toReturn = toReturn + "  automateMix: " + this.automateMix + lineReturn;
        toReturn = toReturn + "  automate2Mix: " + this.automate2Mix + lineReturn;
        toReturn = toReturn + "  bombingMix: " + this.bombingMix + lineReturn;
        toReturn = toReturn + "  precisionBombingMix: " + this.precisionBombingMix + lineReturn;
        toReturn = toReturn + "  automate3: " + this.automate3 + lineReturn;
        toReturn = toReturn + "  goToMix: " + this.goToMix + lineReturn;
        toReturn = toReturn + "bombardEffects: " + this.bombardEffects + lineReturn;
        for (j = 0; j < 14; ++j) {
            toReturn = toReturn + "ignore movement cost of terrain " + j + "?  " + this.ignoreMovementCost[j] + lineReturn;
        }
        toReturn = toReturn + "requiresSupport: " + this.requiresSupport + lineReturn;
        toReturn = toReturn + "useExactCost: " + this.useExactCost + lineReturn;
        toReturn = toReturn + "telepadRange: " + this.telepadRange + lineReturn;
        toReturn = toReturn + "questionMark3: " + this.questionMark3 + lineReturn;
        toReturn = toReturn + "numLegalUnitTelepads: " + this.legalUnitTelepadsInt.size() + lineReturn;
        for (j = 0; j < this.legalUnitTelepadsInt.size(); ++j) {
            toReturn = toReturn + "  legal unit telepad: " + this.legalUnitTelepadsInt.get(j) + lineReturn;
        }
        toReturn = toReturn + "enslaveResultsIn: " + this.enslaveResultsInInt + lineReturn;
        toReturn = toReturn + "questionMark5: " + this.questionMark5 + lineReturn;
        toReturn = toReturn + "numStealthTargets: " + this.stealthTargetsInt.size() + lineReturn;
        for (j = 0; j < this.stealthTargets.size(); ++j) {
            toReturn = toReturn + "stealth target: " + this.stealthTargets.get(j).getName() + lineReturn;
        }
        toReturn = toReturn + "questionMark6: " + this.questionMark6 + lineReturn;
        toReturn = toReturn + "numLegalBuildingTelepads: " + this.legalBuildingTelepads.size() + lineReturn;
        for (j = 0; j < this.legalBuildingTelepads.size(); ++j) {
            toReturn = toReturn + "  legal building telepad: " + this.legalBuildingTelepads.get(j) + lineReturn;
        }
        toReturn = toReturn + "createsCraters: " + this.createsCraters + lineReturn;
        toReturn = toReturn + "workerStrength1: " + this.workerStrength1 + lineReturn;
        toReturn = toReturn + "workerStrengthFloat: " + this.workerStrengthFloat + lineReturn;
        toReturn = toReturn + "questionMark8: " + this.questionMark8 + lineReturn;
        toReturn = toReturn + "airDefence: " + this.airDefence + lineReturn;
        toReturn = toReturn + lineReturn;
        return toReturn;
    }

    @Override
    public String compareTo(BIQSection section, String separator) {
        if (!(section instanceof PRTO)) {
            return null;
        }
        PRTO two = (PRTO)section;
        String lineReturn = System.getProperty("line.separator");
        String toReturn = "name: " + this.name + lineReturn;
        if (this.dataLength != two.dataLength) {
            toReturn = toReturn + "DataLength: " + this.dataLength + separator + two.dataLength + lineReturn;
        }
        if (this.zoneOfControl != two.zoneOfControl) {
            toReturn = toReturn + "ZoneOfControl: " + this.zoneOfControl + separator + two.zoneOfControl + lineReturn;
        }
        if (this.name.compareTo(two.name) != 0) {
            toReturn = toReturn + "Name: " + this.name + separator + two.name + lineReturn;
        }
        if (this.civilopediaEntry.compareTo(two.civilopediaEntry) != 0) {
            toReturn = toReturn + "CivilopediaEntry: " + this.civilopediaEntry + separator + two.civilopediaEntry + lineReturn;
        }
        if (this.bombardStrength != two.bombardStrength) {
            toReturn = toReturn + "BombardStrength: " + this.bombardStrength + separator + two.bombardStrength + lineReturn;
        }
        if (this.bombardRange != two.bombardRange) {
            toReturn = toReturn + "BombardRange: " + this.bombardRange + separator + two.bombardRange + lineReturn;
        }
        if (this.capacity != two.capacity) {
            toReturn = toReturn + "Capacity: " + this.capacity + separator + two.capacity + lineReturn;
        }
        if (this.shieldCost != two.shieldCost) {
            toReturn = toReturn + "ShieldCost: " + this.shieldCost + separator + two.shieldCost + lineReturn;
        }
        if (this.defence != two.defence) {
            toReturn = toReturn + "Defence: " + this.defence + separator + two.defence + lineReturn;
        }
        if (this.iconIndex != two.iconIndex) {
            toReturn = toReturn + "IconIndex: " + this.iconIndex + separator + two.iconIndex + lineReturn;
        }
        if (this.attack != two.attack) {
            toReturn = toReturn + "Attack: " + this.attack + separator + two.attack + lineReturn;
        }
        if (this.operationalRange != two.operationalRange) {
            toReturn = toReturn + "OperationalRange: " + this.operationalRange + separator + two.operationalRange + lineReturn;
        }
        if (this.populationCost != two.populationCost) {
            toReturn = toReturn + "PopulationCost: " + this.populationCost + separator + two.populationCost + lineReturn;
        }
        if (this.rateOfFire != two.rateOfFire) {
            toReturn = toReturn + "RateOfFire: " + this.rateOfFire + separator + two.rateOfFire + lineReturn;
        }
        if (this.movement != two.movement) {
            toReturn = toReturn + "Movement: " + this.movement + separator + two.movement + lineReturn;
        }
        if (this.requiredTechInt != two.requiredTechInt) {
            toReturn = toReturn + "RequiredTech: " + this.requiredTechInt + separator + two.requiredTechInt + lineReturn;
        }
        if (this.upgradeToInt != two.upgradeToInt) {
            toReturn = toReturn + "UpgradeTo: " + this.upgradeToInt + separator + two.upgradeToInt + lineReturn;
        }
        if (this.requiredResource1Int != two.requiredResource1Int) {
            toReturn = toReturn + "RequiredResource1: " + this.requiredResource1Int + separator + two.requiredResource1Int + lineReturn;
        }
        if (this.requiredResource2Int != two.requiredResource2Int) {
            toReturn = toReturn + "RequiredResource2: " + this.requiredResource2Int + separator + two.requiredResource2Int + lineReturn;
        }
        if (this.requiredResource3Int != two.requiredResource3Int) {
            toReturn = toReturn + "RequiredResource3: " + this.requiredResource3Int + separator + two.requiredResource3Int + lineReturn;
        }
        if (this.unitAbilities != two.unitAbilities) {
            toReturn = toReturn + "UnitAbilities: " + this.unitAbilities + separator + two.unitAbilities + lineReturn;
        }
        if (this.wheeled != two.wheeled) {
            toReturn = toReturn + "Wheeled: " + this.wheeled + separator + two.wheeled + lineReturn;
        }
        if (this.footSoldier != two.footSoldier) {
            toReturn = toReturn + "FootSoldier: " + this.footSoldier + separator + two.footSoldier + lineReturn;
        }
        if (this.blitz != two.blitz) {
            toReturn = toReturn + "Blitz: " + this.blitz + separator + two.blitz + lineReturn;
        }
        if (this.cruiseMissile != two.cruiseMissile) {
            toReturn = toReturn + "CruiseMissile: " + this.cruiseMissile + separator + two.cruiseMissile + lineReturn;
        }
        if (this.allTerrainAsRoads != two.allTerrainAsRoads) {
            toReturn = toReturn + "AllTerrainAsRoads: " + this.allTerrainAsRoads + separator + two.allTerrainAsRoads + lineReturn;
        }
        if (this.radar != two.radar) {
            toReturn = toReturn + "Radar: " + this.radar + separator + two.radar + lineReturn;
        }
        if (this.amphibiousUnit != two.amphibiousUnit) {
            toReturn = toReturn + "AmphibiousUnit: " + this.amphibiousUnit + separator + two.amphibiousUnit + lineReturn;
        }
        if (this.invisible != two.invisible) {
            toReturn = toReturn + "Invisible: " + this.invisible + separator + two.invisible + lineReturn;
        }
        if (this.transportsOnlyAirUnits != two.transportsOnlyAirUnits) {
            toReturn = toReturn + "TransportsOnlyAirUnits: " + this.transportsOnlyAirUnits + separator + two.transportsOnlyAirUnits + lineReturn;
        }
        if (this.draftable != two.draftable) {
            toReturn = toReturn + "Draftable: " + this.draftable + separator + two.draftable + lineReturn;
        }
        if (this.immobile != two.immobile) {
            toReturn = toReturn + "Immobile: " + this.immobile + separator + two.immobile + lineReturn;
        }
        if (this.sinksInSea != two.sinksInSea) {
            toReturn = toReturn + "SinksInSea: " + this.sinksInSea + separator + two.sinksInSea + lineReturn;
        }
        if (this.sinksInOcean != two.sinksInOcean) {
            toReturn = toReturn + "SinksInOcean: " + this.sinksInOcean + separator + two.sinksInOcean + lineReturn;
        }
        if (this.flagUnit != two.flagUnit) {
            toReturn = toReturn + "FlagUnit: " + this.flagUnit + separator + two.flagUnit + lineReturn;
        }
        if (this.transportsOnlyFootUnits != two.transportsOnlyFootUnits) {
            toReturn = toReturn + "TransportsOnlyFootUnits: " + this.transportsOnlyFootUnits + separator + two.transportsOnlyFootUnits + lineReturn;
        }
        if (this.startsGoldenAge != two.startsGoldenAge) {
            toReturn = toReturn + "StartsGoldenAge: " + this.startsGoldenAge + separator + two.startsGoldenAge + lineReturn;
        }
        if (this.nuclearWeapon != two.nuclearWeapon) {
            toReturn = toReturn + "NuclearWeapon: " + this.nuclearWeapon + separator + two.nuclearWeapon + lineReturn;
        }
        if (this.hiddenNationality != two.hiddenNationality) {
            toReturn = toReturn + "HiddenNationality: " + this.hiddenNationality + separator + two.hiddenNationality + lineReturn;
        }
        if (this.army != two.army) {
            toReturn = toReturn + "Army: " + this.army + separator + two.army + lineReturn;
        }
        if (this.leader != two.leader) {
            toReturn = toReturn + "Leader: " + this.leader + separator + two.leader + lineReturn;
        }
        if (this.infiniteBombardRange != two.infiniteBombardRange) {
            toReturn = toReturn + "InfiniteBombardRange: " + this.infiniteBombardRange + separator + two.infiniteBombardRange + lineReturn;
        }
        if (this.stealth != two.stealth) {
            toReturn = toReturn + "Stealth: " + this.stealth + separator + two.stealth + lineReturn;
        }
        if (this.detectInvisible != two.detectInvisible) {
            toReturn = toReturn + "DetectInvisible: " + this.detectInvisible + separator + two.detectInvisible + lineReturn;
        }
        if (this.tacticalMissile != two.tacticalMissile) {
            toReturn = toReturn + "TacticalMissile: " + this.tacticalMissile + separator + two.tacticalMissile + lineReturn;
        }
        if (this.transportsOnlyTacticalMissiles != two.transportsOnlyTacticalMissiles) {
            toReturn = toReturn + "TransportsOnlyTacticalMissiles: " + this.transportsOnlyTacticalMissiles + separator + two.transportsOnlyTacticalMissiles + lineReturn;
        }
        if (this.rangedAttackAnimations != two.rangedAttackAnimations) {
            toReturn = toReturn + "RangedAttackAnimations: " + this.rangedAttackAnimations + separator + two.rangedAttackAnimations + lineReturn;
        }
        if (this.rotateBeforeAttack != two.rotateBeforeAttack) {
            toReturn = toReturn + "RotateBeforeAttack: " + this.rotateBeforeAttack + separator + two.rotateBeforeAttack + lineReturn;
        }
        if (this.lethalLandBombardment != two.lethalLandBombardment) {
            toReturn = toReturn + "LethalLandBombardment: " + this.lethalLandBombardment + separator + two.lethalLandBombardment + lineReturn;
        }
        if (this.lethalSeaBombardment != two.lethalSeaBombardment) {
            toReturn = toReturn + "LethalSeaBombardment: " + this.lethalSeaBombardment + separator + two.lethalSeaBombardment + lineReturn;
        }
        if (this.king != two.king) {
            toReturn = toReturn + "King: " + this.king + separator + two.king + lineReturn;
        }
        if (this.requiresEscort != two.requiresEscort) {
            toReturn = toReturn + "RequiresEscort: " + this.requiresEscort + separator + two.requiresEscort + lineReturn;
        }
        if (this.AIStrategy != two.AIStrategy) {
            toReturn = toReturn + "AIStrategy: " + this.AIStrategy + separator + two.AIStrategy + lineReturn;
        }
        if (this.offence != two.offence) {
            toReturn = toReturn + "Offence: " + this.offence + separator + two.offence + lineReturn;
        }
        if (this.defenceStrategy != two.defenceStrategy) {
            toReturn = toReturn + "DefenceStrategy: " + this.defenceStrategy + separator + two.defenceStrategy + lineReturn;
        }
        if (this.artillery != two.artillery) {
            toReturn = toReturn + "Artillery: " + this.artillery + separator + two.artillery + lineReturn;
        }
        if (this.exploreStrategy != two.exploreStrategy) {
            toReturn = toReturn + "ExploreStrategy: " + this.exploreStrategy + separator + two.exploreStrategy + lineReturn;
        }
        if (this.armyUnit != two.armyUnit) {
            toReturn = toReturn + "ArmyUnit: " + this.armyUnit + separator + two.armyUnit + lineReturn;
        }
        if (this.cruiseMissileUnit != two.cruiseMissileUnit) {
            toReturn = toReturn + "CruiseMissileUnit: " + this.cruiseMissileUnit + separator + two.cruiseMissileUnit + lineReturn;
        }
        if (this.airBombard != two.airBombard) {
            toReturn = toReturn + "AirBombard: " + this.airBombard + separator + two.airBombard + lineReturn;
        }
        if (this.airDefenceStrategy != two.airDefenceStrategy) {
            toReturn = toReturn + "AirDefenceStrategy: " + this.airDefenceStrategy + separator + two.airDefenceStrategy + lineReturn;
        }
        if (this.navalPower != two.navalPower) {
            toReturn = toReturn + "NavalPower: " + this.navalPower + separator + two.navalPower + lineReturn;
        }
        if (this.airTransport != two.airTransport) {
            toReturn = toReturn + "AirTransport: " + this.airTransport + separator + two.airTransport + lineReturn;
        }
        if (this.navalTransport != two.navalTransport) {
            toReturn = toReturn + "NavalTransport: " + this.navalTransport + separator + two.navalTransport + lineReturn;
        }
        if (this.navalCarrier != two.navalCarrier) {
            toReturn = toReturn + "NavalCarrier: " + this.navalCarrier + separator + two.navalCarrier + lineReturn;
        }
        if (this.terraform != two.terraform) {
            toReturn = toReturn + "Terraform: " + this.terraform + separator + two.terraform + lineReturn;
        }
        if (this.settle != two.settle) {
            toReturn = toReturn + "Settle: " + this.settle + separator + two.settle + lineReturn;
        }
        if (this.leaderUnit != two.leaderUnit) {
            toReturn = toReturn + "LeaderUnit: " + this.leaderUnit + separator + two.leaderUnit + lineReturn;
        }
        if (this.tacticalNuke != two.tacticalNuke) {
            toReturn = toReturn + "TacticalNuke: " + this.tacticalNuke + separator + two.tacticalNuke + lineReturn;
        }
        if (this.ICBM != two.ICBM) {
            toReturn = toReturn + "ICBM: " + this.ICBM + separator + two.ICBM + lineReturn;
        }
        if (this.navalMissileTransport != two.navalMissileTransport) {
            toReturn = toReturn + "NavalMissileTransport: " + this.navalMissileTransport + separator + two.navalMissileTransport + lineReturn;
        }
        if (this.availableTo != two.availableTo) {
            toReturn = toReturn + "AvailableTo: " + this.availableTo + separator + two.availableTo + lineReturn;
        }
        if (this.standardOrdersSpecialActions != two.standardOrdersSpecialActions) {
            toReturn = toReturn + "StandardOrdersSpecialActions: " + this.standardOrdersSpecialActions + separator + two.standardOrdersSpecialActions + lineReturn;
        }
        if (this.skipTurn != two.skipTurn) {
            toReturn = toReturn + "SkipTurn: " + this.skipTurn + separator + two.skipTurn + lineReturn;
        }
        if (this.wait != two.wait) {
            toReturn = toReturn + "Wait: " + this.wait + separator + two.wait + lineReturn;
        }
        if (this.fortify != two.fortify) {
            toReturn = toReturn + "Fortify: " + this.fortify + separator + two.fortify + lineReturn;
        }
        if (this.disband != two.disband) {
            toReturn = toReturn + "Disband: " + this.disband + separator + two.disband + lineReturn;
        }
        if (this.goTo != two.goTo) {
            toReturn = toReturn + "GoTo: " + this.goTo + separator + two.goTo + lineReturn;
        }
        if (this.load != two.load) {
            toReturn = toReturn + "Load: " + this.load + separator + two.load + lineReturn;
        }
        if (this.unload != two.unload) {
            toReturn = toReturn + "Unload: " + this.unload + separator + two.unload + lineReturn;
        }
        if (this.airlift != two.airlift) {
            toReturn = toReturn + "Airlift: " + this.airlift + separator + two.airlift + lineReturn;
        }
        if (this.pillage != two.pillage) {
            toReturn = toReturn + "Pillage: " + this.pillage + separator + two.pillage + lineReturn;
        }
        if (this.bombard != two.bombard) {
            toReturn = toReturn + "Bombard: " + this.bombard + separator + two.bombard + lineReturn;
        }
        if (this.airdrop != two.airdrop) {
            toReturn = toReturn + "Airdrop: " + this.airdrop + separator + two.airdrop + lineReturn;
        }
        if (this.buildArmy != two.buildArmy) {
            toReturn = toReturn + "BuildArmy: " + this.buildArmy + separator + two.buildArmy + lineReturn;
        }
        if (this.finishImprovement != two.finishImprovement) {
            toReturn = toReturn + "FinishImprovement: " + this.finishImprovement + separator + two.finishImprovement + lineReturn;
        }
        if (this.upgrade != two.upgrade) {
            toReturn = toReturn + "Upgrade: " + this.upgrade + separator + two.upgrade + lineReturn;
        }
        if (this.buildColony != two.buildColony) {
            toReturn = toReturn + "BuildColony: " + this.buildColony + separator + two.buildColony + lineReturn;
        }
        if (this.buildCity != two.buildCity) {
            toReturn = toReturn + "BuildCity: " + this.buildCity + separator + two.buildCity + lineReturn;
        }
        if (this.buildRoad != two.buildRoad) {
            toReturn = toReturn + "BuildRoad: " + this.buildRoad + separator + two.buildRoad + lineReturn;
        }
        if (this.buildRailroad != two.buildRailroad) {
            toReturn = toReturn + "BuildRailroad: " + this.buildRailroad + separator + two.buildRailroad + lineReturn;
        }
        if (this.buildFort != two.buildFort) {
            toReturn = toReturn + "BuildFort: " + this.buildFort + separator + two.buildFort + lineReturn;
        }
        if (this.buildMine != two.buildMine) {
            toReturn = toReturn + "BuildMine: " + this.buildMine + separator + two.buildMine + lineReturn;
        }
        if (this.irrigate != two.irrigate) {
            toReturn = toReturn + "Irrigate: " + this.irrigate + separator + two.irrigate + lineReturn;
        }
        if (this.clearForest != two.clearForest) {
            toReturn = toReturn + "ClearForest: " + this.clearForest + separator + two.clearForest + lineReturn;
        }
        if (this.clearJungle != two.clearJungle) {
            toReturn = toReturn + "ClearJungle: " + this.clearJungle + separator + two.clearJungle + lineReturn;
        }
        if (this.plantForest != two.plantForest) {
            toReturn = toReturn + "PlantForest: " + this.plantForest + separator + two.plantForest + lineReturn;
        }
        if (this.clearPollution != two.clearPollution) {
            toReturn = toReturn + "ClearPollution: " + this.clearPollution + separator + two.clearPollution + lineReturn;
        }
        if (this.automate != two.automate) {
            toReturn = toReturn + "Automate: " + this.automate + separator + two.automate + lineReturn;
        }
        if (this.joinCity != two.joinCity) {
            toReturn = toReturn + "JoinCity: " + this.joinCity + separator + two.joinCity + lineReturn;
        }
        if (this.airMissions != two.airMissions) {
            toReturn = toReturn + "AirMissions: " + this.airMissions + separator + two.airMissions + lineReturn;
        }
        if (this.bomb != two.bomb) {
            toReturn = toReturn + "Bomb: " + this.bomb + separator + two.bomb + lineReturn;
        }
        if (this.recon != two.recon) {
            toReturn = toReturn + "Recon: " + this.recon + separator + two.recon + lineReturn;
        }
        if (this.intercept != two.intercept) {
            toReturn = toReturn + "Intercept: " + this.intercept + separator + two.intercept + lineReturn;
        }
        if (this.rebase != two.rebase) {
            toReturn = toReturn + "Rebase: " + this.rebase + separator + two.rebase + lineReturn;
        }
        if (this.precisionBomb != two.precisionBomb) {
            toReturn = toReturn + "PrecisionBomb: " + this.precisionBomb + separator + two.precisionBomb + lineReturn;
        }
        if (this.unitClass != two.unitClass) {
            toReturn = toReturn + "UnitClass: " + this.unitClass + separator + two.unitClass + lineReturn;
        }
        if (this.otherStrategy != two.otherStrategy) {
            toReturn = toReturn + "OtherStrategy: " + this.otherStrategy + separator + two.otherStrategy + lineReturn;
        }
        if (this.hitPointBonus != two.hitPointBonus) {
            toReturn = toReturn + "HitPointBonus: " + this.hitPointBonus + separator + two.hitPointBonus + lineReturn;
        }
        if (this.PTWStandardOrders != two.PTWStandardOrders) {
            toReturn = toReturn + "PTWStandardOrders: " + this.PTWStandardOrders + separator + two.PTWStandardOrders + lineReturn;
        }
        if (this.PTWskipTurn != two.PTWskipTurn) {
            toReturn = toReturn + "PTWskipTurn: " + this.PTWskipTurn + separator + two.PTWskipTurn + lineReturn;
        }
        if (this.PTWwait != two.PTWwait) {
            toReturn = toReturn + "PTWwait: " + this.PTWwait + separator + two.PTWwait + lineReturn;
        }
        if (this.PTWfortify != two.PTWfortify) {
            toReturn = toReturn + "PTWfortify: " + this.PTWfortify + separator + two.PTWfortify + lineReturn;
        }
        if (this.PTWdisband != two.PTWdisband) {
            toReturn = toReturn + "PTWdisband: " + this.PTWdisband + separator + two.PTWdisband + lineReturn;
        }
        if (this.PTWgoTo != two.PTWgoTo) {
            toReturn = toReturn + "PTWgoTo: " + this.PTWgoTo + separator + two.PTWgoTo + lineReturn;
        }
        if (this.PTWexploreOrder != two.PTWexploreOrder) {
            toReturn = toReturn + "PTWexplore: " + this.PTWexploreOrder + separator + two.PTWexploreOrder + lineReturn;
        }
        if (this.PTWsentry != two.PTWsentry) {
            toReturn = toReturn + "PTWsentry: " + this.PTWsentry + separator + two.PTWsentry + lineReturn;
        }
        if (this.PTWSpecialActions != two.PTWSpecialActions) {
            toReturn = toReturn + "PTWSpecialActions: " + this.PTWSpecialActions + separator + two.PTWSpecialActions + lineReturn;
        }
        if (this.PTWload != two.PTWload) {
            toReturn = toReturn + "PTWload: " + this.PTWload + separator + two.PTWload + lineReturn;
        }
        if (this.PTWunload != two.PTWunload) {
            toReturn = toReturn + "PTWunload: " + this.PTWunload + separator + two.PTWunload + lineReturn;
        }
        if (this.PTWairlift != two.PTWairlift) {
            toReturn = toReturn + "PTWairlift: " + this.PTWairlift + separator + two.PTWairlift + lineReturn;
        }
        if (this.PTWpillage != two.PTWpillage) {
            toReturn = toReturn + "PTWpillage: " + this.PTWpillage + separator + two.PTWpillage + lineReturn;
        }
        if (this.PTWbombard != two.PTWbombard) {
            toReturn = toReturn + "PTWbombard: " + this.PTWbombard + separator + two.PTWbombard + lineReturn;
        }
        if (this.PTWairdrop != two.PTWairdrop) {
            toReturn = toReturn + "PTWairdrop: " + this.PTWairdrop + separator + two.PTWairdrop + lineReturn;
        }
        if (this.PTWbuildArmy != two.PTWbuildArmy) {
            toReturn = toReturn + "PTWbuildArmy: " + this.PTWbuildArmy + separator + two.PTWbuildArmy + lineReturn;
        }
        if (this.PTWfinishImprovements != two.PTWfinishImprovements) {
            toReturn = toReturn + "PTWfinishImprovements: " + this.PTWfinishImprovements + separator + two.PTWfinishImprovements + lineReturn;
        }
        if (this.PTWupgradeUnit != two.PTWupgradeUnit) {
            toReturn = toReturn + "PTWupgradeUnit: " + this.PTWupgradeUnit + separator + two.PTWupgradeUnit + lineReturn;
        }
        if (this.PTWcapture != two.PTWcapture) {
            toReturn = toReturn + "PTWcapture: " + this.PTWcapture + separator + two.PTWcapture + lineReturn;
        }
        if (this.PTWWorkerActions != two.PTWWorkerActions) {
            toReturn = toReturn + "PTWWorkerActions: " + this.PTWWorkerActions + separator + two.PTWWorkerActions + lineReturn;
        }
        if (this.PTWbuildColony != two.PTWbuildColony) {
            toReturn = toReturn + "PTWbuildColony: " + this.PTWbuildColony + separator + two.PTWbuildColony + lineReturn;
        }
        if (this.PTWbuildCity != two.PTWbuildCity) {
            toReturn = toReturn + "PTWbuildCity: " + this.PTWbuildCity + separator + two.PTWbuildCity + lineReturn;
        }
        if (this.PTWbuildRoad != two.PTWbuildRoad) {
            toReturn = toReturn + "PTWbuildRoad: " + this.PTWbuildRoad + separator + two.PTWbuildRoad + lineReturn;
        }
        if (this.PTWbuildRailroad != two.PTWbuildRailroad) {
            toReturn = toReturn + "PTWbuildRailroad: " + this.PTWbuildRailroad + separator + two.PTWbuildRailroad + lineReturn;
        }
        if (this.PTWbuildFort != two.PTWbuildFort) {
            toReturn = toReturn + "PTWbuildFort: " + this.PTWbuildFort + separator + two.PTWbuildFort + lineReturn;
        }
        if (this.PTWbuildMine != two.PTWbuildMine) {
            toReturn = toReturn + "PTWbuildMine: " + this.PTWbuildMine + separator + two.PTWbuildMine + lineReturn;
        }
        if (this.PTWirrigate != two.PTWirrigate) {
            toReturn = toReturn + "PTWirrigate: " + this.PTWirrigate + separator + two.PTWirrigate + lineReturn;
        }
        if (this.PTWclearForest != two.PTWclearForest) {
            toReturn = toReturn + "PTWclearForest: " + this.PTWclearForest + separator + two.PTWclearForest + lineReturn;
        }
        if (this.PTWclearJungle != two.PTWclearJungle) {
            toReturn = toReturn + "PTWclearJungle: " + this.PTWclearJungle + separator + two.PTWclearJungle + lineReturn;
        }
        if (this.PTWplantForest != two.PTWplantForest) {
            toReturn = toReturn + "PTWplantForest: " + this.PTWplantForest + separator + two.PTWplantForest + lineReturn;
        }
        if (this.PTWclearPollution != two.PTWclearPollution) {
            toReturn = toReturn + "PTWclearPollution: " + this.PTWclearPollution + separator + two.PTWclearPollution + lineReturn;
        }
        if (this.PTWautomate != two.PTWautomate) {
            toReturn = toReturn + "PTWautomate: " + this.PTWautomate + separator + two.PTWautomate + lineReturn;
        }
        if (this.PTWjoinCity != two.PTWjoinCity) {
            toReturn = toReturn + "PTWjoinCity: " + this.PTWjoinCity + separator + two.PTWjoinCity + lineReturn;
        }
        if (this.PTWbuildAirfield != two.PTWbuildAirfield) {
            toReturn = toReturn + "PTWbuildAirfield: " + this.PTWbuildAirfield + separator + two.PTWbuildAirfield + lineReturn;
        }
        if (this.PTWbuildRadarTower != two.PTWbuildRadarTower) {
            toReturn = toReturn + "PTWbuildRadarTower: " + this.PTWbuildRadarTower + separator + two.PTWbuildRadarTower + lineReturn;
        }
        if (this.PTWbuildOutpost != two.PTWbuildOutpost) {
            toReturn = toReturn + "PTWbuildOutpost: " + this.PTWbuildOutpost + separator + two.PTWbuildOutpost + lineReturn;
        }
        if (this.PTWAirMissions != two.PTWAirMissions) {
            toReturn = toReturn + "PTWAirMissions: " + this.PTWAirMissions + separator + two.PTWAirMissions + lineReturn;
        }
        if (this.PTWbomb != two.PTWbomb) {
            toReturn = toReturn + "PTWbomb: " + this.PTWbomb + separator + two.PTWbomb + lineReturn;
        }
        if (this.PTWrecon != two.PTWrecon) {
            toReturn = toReturn + "PTWrecon: " + this.PTWrecon + separator + two.PTWrecon + lineReturn;
        }
        if (this.PTWintercept != two.PTWintercept) {
            toReturn = toReturn + "PTWintercept: " + this.PTWintercept + separator + two.PTWintercept + lineReturn;
        }
        if (this.PTWrebase != two.PTWrebase) {
            toReturn = toReturn + "PTWrebase: " + this.PTWrebase + separator + two.PTWrebase + lineReturn;
        }
        if (this.PTWprecisionBomb != two.PTWprecisionBomb) {
            toReturn = toReturn + "PTWprecisionBomb: " + this.PTWprecisionBomb + separator + two.PTWprecisionBomb + lineReturn;
        }
        if (this.PTWActionsMix != two.PTWActionsMix) {
            toReturn = toReturn + "PTWActionsMix: " + this.PTWActionsMix + separator + two.PTWActionsMix + lineReturn;
        }
        if (this.sentryMix != two.sentryMix) {
            toReturn = toReturn + "SentryMix: " + this.sentryMix + separator + two.sentryMix + lineReturn;
        }
        if (this.bombardMix != two.bombardMix) {
            toReturn = toReturn + "BombardMix: " + this.bombardMix + separator + two.bombardMix + lineReturn;
        }
        if (this.colonyMix != two.colonyMix) {
            toReturn = toReturn + "ColonyMix: " + this.colonyMix + separator + two.colonyMix + lineReturn;
        }
        if (this.roadMix != two.roadMix) {
            toReturn = toReturn + "RoadMix: " + this.roadMix + separator + two.roadMix + lineReturn;
        }
        if (this.railroadMix != two.railroadMix) {
            toReturn = toReturn + "RailroadMix: " + this.railroadMix + separator + two.railroadMix + lineReturn;
        }
        if (this.road2Mix != two.road2Mix) {
            toReturn = toReturn + "Road2Mix: " + this.road2Mix + separator + two.road2Mix + lineReturn;
        }
        if (this.irrigateMix != two.irrigateMix) {
            toReturn = toReturn + "IrrigateMix: " + this.irrigateMix + separator + two.irrigateMix + lineReturn;
        }
        if (this.clearForestMix != two.clearForestMix) {
            toReturn = toReturn + "ClearForestMix: " + this.clearForestMix + separator + two.clearForestMix + lineReturn;
        }
        if (this.clearJungleMix != two.clearJungleMix) {
            toReturn = toReturn + "ClearJungleMix: " + this.clearJungleMix + separator + two.clearJungleMix + lineReturn;
        }
        if (this.clearPollutionMix != two.clearPollutionMix) {
            toReturn = toReturn + "ClearPollutionMix: " + this.clearPollutionMix + separator + two.clearPollutionMix + lineReturn;
        }
        if (this.automateMix != two.automateMix) {
            toReturn = toReturn + "AutomateMix: " + this.automateMix + separator + two.automateMix + lineReturn;
        }
        if (this.automate2Mix != two.automate2Mix) {
            toReturn = toReturn + "Automate2Mix: " + this.automate2Mix + separator + two.automate2Mix + lineReturn;
        }
        if (this.bombingMix != two.bombingMix) {
            toReturn = toReturn + "BombingMix: " + this.bombingMix + separator + two.bombingMix + lineReturn;
        }
        if (this.precisionBombingMix != two.precisionBombingMix) {
            toReturn = toReturn + "PrecisionBombingMix: " + this.precisionBombingMix + separator + two.precisionBombingMix + lineReturn;
        }
        if (this.automate3 != two.automate3) {
            toReturn = toReturn + "Automate3: " + this.automate3 + separator + two.automate3 + lineReturn;
        }
        if (this.goToMix != two.goToMix) {
            toReturn = toReturn + "GoToMix: " + this.goToMix + separator + two.goToMix + lineReturn;
        }
        if (this.bombardEffects != two.bombardEffects) {
            toReturn = toReturn + "BombardEffects: " + this.bombardEffects + separator + two.bombardEffects + lineReturn;
        }
        if (this.requiresSupport != two.requiresSupport) {
            toReturn = toReturn + "RequiresSupport: " + this.requiresSupport + separator + two.requiresSupport + lineReturn;
        }
        if (this.useExactCost != two.useExactCost) {
            toReturn = toReturn + "UseExactCost: " + this.useExactCost + separator + two.useExactCost + lineReturn;
        }
        if (this.telepadRange != two.telepadRange) {
            toReturn = toReturn + "TelepadRange: " + this.telepadRange + separator + two.telepadRange + lineReturn;
        }
        if (this.questionMark3 != two.questionMark3) {
            toReturn = toReturn + "QuestionMark3: " + this.questionMark3 + separator + two.questionMark3 + lineReturn;
        }
        if (this.legalUnitTelepadsInt.size() != two.getNumLegalUnitTelepads()) {
            toReturn = toReturn + "NumLegalUnitTelepads: " + this.getNumLegalUnitTelepads() + separator + two.getNumLegalUnitTelepads() + lineReturn;
        }
        if (this.enslaveResultsInInt != two.enslaveResultsInInt) {
            toReturn = toReturn + "EnslaveResultsIn: " + this.enslaveResultsInInt + separator + two.enslaveResultsInInt + lineReturn;
        }
        if (this.questionMark5 != two.questionMark5) {
            toReturn = toReturn + "QuestionMark5: " + this.questionMark5 + separator + two.questionMark5 + lineReturn;
        }
        if (this.stealthTargetsInt.size() != two.stealthTargetsInt.size()) {
            toReturn = toReturn + "NumStealthTargets: " + this.stealthTargetsInt.size() + separator + two.stealthTargetsInt.size() + lineReturn;
        }
        if (this.questionMark6 != two.questionMark6) {
            toReturn = toReturn + "QuestionMark6: " + this.questionMark6 + separator + two.questionMark6 + lineReturn;
        }
        if (this.getNumLegalBuildingTelepads() != two.getNumLegalBuildingTelepads()) {
            toReturn = toReturn + "NumLegalBuildingTelepads: " + this.getNumLegalBuildingTelepads() + separator + two.getNumLegalBuildingTelepads() + lineReturn;
        }
        if (this.createsCraters != two.createsCraters) {
            toReturn = toReturn + "CreatesCraters: " + this.createsCraters + separator + two.createsCraters + lineReturn;
        }
        if (this.workerStrength1 != two.workerStrength1) {
            toReturn = toReturn + "WorkerStrength1: " + this.workerStrength1 + separator + two.workerStrength1 + lineReturn;
        }
        if (this.questionMark8 != two.questionMark8) {
            toReturn = toReturn + "QuestionMark8: " + this.questionMark8 + separator + two.questionMark8 + lineReturn;
        }
        if (this.airDefence != two.airDefence) {
            toReturn = toReturn + "AirDefence: " + this.airDefence + separator + two.airDefence + lineReturn;
        }
        if (toReturn.equals("name: " + this.name + lineReturn)) {
            toReturn = "";
        }
        return toReturn;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public void setIndex(int index) {
        this.index = index;
    }

    public void recalculateUnitAbilities() {
        Boolean[] list = new Boolean[]{this.requiresEscort, this.king, this.lethalSeaBombardment, this.lethalLandBombardment, this.rotateBeforeAttack, this.rangedAttackAnimations, this.transportsOnlyTacticalMissiles, this.tacticalMissile, this.detectInvisible, this.stealth, this.infiniteBombardRange, this.leader, this.army, this.hiddenNationality, this.nuclearWeapon, this.startsGoldenAge, this.transportsOnlyFootUnits, this.flagUnit, this.sinksInOcean, this.sinksInSea, this.immobile, this.draftable, this.transportsOnlyAirUnits, this.invisible, this.amphibiousUnit, this.radar, this.allTerrainAsRoads, this.cruiseMissile, this.blitz, this.footSoldier, this.wheeled};
        this.unitAbilities = Utils.recalculateBitfield(list);
    }

    public void recalculateAIStrategies() {
        Boolean[] list = new Boolean[]{this.kingStrategy, this.flagStrategy, this.navalMissileTransport, this.ICBM, this.tacticalNuke, this.leaderUnit, this.settle, this.terraform, this.navalCarrier, this.navalTransport, this.airTransport, this.navalPower, this.airDefenceStrategy, this.airBombard, this.cruiseMissileUnit, this.armyUnit, this.exploreStrategy, this.artillery, this.defenceStrategy, this.offence};
        this.AIStrategy = Utils.recalculateBitfield(list);
        this.numStrategies = (byte)Utils.calcNumTrue(list);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("The " + this.name + " has " + this.numStrategies + " strategies.");
        }
        Boolean[] strategies2 = new Boolean[]{this.offence, this.defenceStrategy, this.artillery, this.exploreStrategy, this.armyUnit, this.cruiseMissileUnit, this.airBombard, this.airDefenceStrategy, this.navalPower, this.airTransport, this.navalTransport, this.navalCarrier, this.terraform, this.settle, this.leaderUnit, this.tacticalNuke, this.ICBM, this.navalMissileTransport, this.flagStrategy, this.kingStrategy};
        this.strategies = strategies2;
    }

    public void recalculateAvailableTo() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("initial available to for " + this.name + " " + this.availableTo);
        }
        this.availableTo = 0;
        long toAdd = 1L;
        for (int i = 0; i < 32; ++i) {
            if (this.availableToArray[i]) {
                this.availableTo = (int)((long)this.availableTo + toAdd);
            }
            toAdd *= 2L;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("final available to for " + this.name + " " + this.availableTo);
        }
    }

    public void recalculatePTWWorkerActions() {
        Boolean[] list = new Boolean[]{this.PTWbuildBarricade, this.PTWbuildOutpost, this.PTWbuildRadarTower, this.PTWbuildAirfield, this.PTWjoinCity, this.PTWautomate, this.PTWclearPollution, this.PTWplantForest, this.PTWclearJungle, this.PTWclearForest, this.PTWirrigate, this.PTWbuildMine, this.PTWbuildFort, this.PTWbuildRailroad, this.PTWbuildRoad, this.PTWbuildCity, this.PTWbuildColony};
        this.PTWWorkerActions = Utils.recalculateBitfield(list);
    }

    public void recalculatePTWSpecialActions() {
        Boolean[] list = new Boolean[]{this.scienceAge, this.sacrifice, this.collateralDamage, this.enslave, this.charm, this.stealthAttack, this.teleportable, this.telepad, false, false, false, false, this.PTWcapture, this.PTWupgradeUnit, this.PTWfinishImprovements, this.PTWbuildArmy, this.PTWairdrop, this.PTWbombard, this.PTWpillage, this.PTWairlift, this.PTWunload, this.PTWload};
        this.PTWSpecialActions = Utils.recalculateBitfield(list);
    }

    public void recalculatePTWAirMissions() {
        Boolean[] list = new Boolean[]{this.PTWprecisionBomb, this.PTWrebase, this.PTWintercept, this.PTWrecon, this.PTWbomb};
        this.PTWAirMissions = Utils.recalculateBitfield(list);
    }

    public void recalculatePTWActionsMix() {
        Boolean[] list = new Boolean[]{this.goToMix, this.automate3, this.precisionBombingMix, this.bombingMix, this.automate2Mix, this.automateMix, this.clearPollutionMix, this.clearJungleMix, this.clearForestMix, this.irrigateMix, this.road2Mix, this.railroadMix, this.roadMix, this.colonyMix, this.bombardMix, this.sentryMix};
        this.PTWActionsMix = Utils.recalculateBitfield(list);
    }

    public void recalculatePTWStandardOrders() {
        Boolean[] bits = new Boolean[]{this.PTWsentry, this.PTWexploreOrder, this.PTWgoTo, this.PTWdisband, this.PTWfortify, this.PTWwait, this.PTWskipTurn};
        this.PTWStandardOrders = Utils.recalculateBitfield(bits);
    }

    public boolean hasInfiniteUpgradePath() {
        if (this.upgradeTo == null) {
            return false;
        }
        ArrayList<PRTO> encounteredPRTOs = new ArrayList<PRTO>();
        encounteredPRTOs.add(this);
        PRTO unitBeingChecked = this;
        while (true) {
            unitBeingChecked = unitBeingChecked.upgradeTo;
            if (unitBeingChecked.upgradeTo == null) {
                return false;
            }
            if (encounteredPRTOs.contains(unitBeingChecked)) {
                return true;
            }
            encounteredPRTOs.add(unitBeingChecked);
        }
    }

    public String getUpgradePath() {
        if (this.upgradeTo == null) {
            return "None";
        }
        ArrayList<PRTO> encounteredPRTOs = new ArrayList<PRTO>();
        encounteredPRTOs.add(this);
        PRTO unitBeingChecked = this;
        String upgradePath = this.name + " --> ";
        int unitsCounted = 0;
        while (true) {
            unitBeingChecked = unitBeingChecked.upgradeTo;
            upgradePath = upgradePath + unitBeingChecked.name;
            if (unitBeingChecked.upgradeTo == null) {
                return upgradePath;
            }
            if (encounteredPRTOs.contains(unitBeingChecked)) {
                return upgradePath;
            }
            upgradePath = upgradePath + " --> ";
            encounteredPRTOs.add(unitBeingChecked);
            if (++unitsCounted % 5 != 0) continue;
            upgradePath = upgradePath + "<br/>";
        }
    }

    @Override
    public Object getProperty(String string) throws UnsupportedOperationException {
        if (string.equals("Name")) {
            return this.name;
        }
        throw new UnsupportedOperationException();
    }
}

