/*
 * Decompiled with CFR 0.152.
 */
package com.civfanatics.civ3.biqFile;

import com.civfanatics.civ3.biqFile.BIQSection;
import com.civfanatics.civ3.biqFile.IO;
import com.civfanatics.civ3.biqFile.PRTO;
import com.civfanatics.civ3.biqFile.TECH;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class RACE
extends BIQSection {
    private int dataLength = 2388;
    private int numCityNames;
    private ArrayList<String> cityName;
    private int numGreatLeaders;
    private ArrayList<String> greatLeader;
    private String leaderName = "";
    private String leaderTitle = "";
    private String civilopediaEntry = "";
    private String adjective = "";
    private String civilizationName = "";
    private String noun = "";
    private ArrayList<String> forwardFilename;
    private ArrayList<String> reverseFilename;
    private int cultureGroup;
    private int leaderGender;
    private int civilizationGender;
    private int aggressionLevel;
    private int uniqueCivilizationCounter;
    private int shunnedGovernment;
    private int favoriteGovernment;
    private int defaultColor;
    private int uniqueColor;
    private int freeTech1Index;
    private int freeTech2Index;
    private int freeTech3Index;
    private int freeTech4Index;
    private TECH freeTech1;
    private TECH freeTech2;
    private TECH freeTech3;
    private TECH freeTech4;
    private int bonuses;
    private int governorSettings;
    private int buildNever;
    private int buildOften;
    private int plurality;
    private int kingUnitInt;
    private PRTO kingUnit;
    private int flavors;
    private ArrayList<Boolean> flavours;
    private int numFlavors;
    private int questionMark;
    private int diplomacyTextIndex;
    private int numScientificLeaders;
    private boolean militaristic;
    private boolean commercial;
    private boolean expansionist;
    private boolean scientific;
    private boolean religious;
    private boolean industrious;
    private boolean agricultural;
    private boolean seafaring;
    private boolean manageCitizens;
    private boolean emphasizeFood;
    private boolean emphasizeShields;
    private boolean emphasizeTrade;
    private boolean manageProduction;
    private boolean noWonders;
    private boolean noSmallWonders;
    private boolean noOffensiveLandUnits;
    private boolean noDefensiveLandUnits;
    private boolean noArtillery;
    private boolean noSettlers;
    private boolean noWorkers;
    private boolean noShips;
    private boolean noAirUnits;
    private boolean noGrowth;
    private boolean noProduction;
    private boolean noHappiness;
    private boolean noScience;
    private boolean noWealth;
    private boolean noTrade;
    private boolean noExploration;
    private boolean noCulture;
    private boolean manyOffensiveLandUnits;
    private boolean manyDefensiveLandUnits;
    private boolean manyArtillery;
    private boolean manySettlers;
    private boolean manyWorkers;
    private boolean manyShips;
    private boolean manyAirUnits;
    private boolean manyGrowth;
    private boolean manyProduction;
    private boolean manyHappiness;
    private boolean manyScience;
    private boolean manyWealth;
    private boolean manyTrade;
    private boolean manyExploration;
    private boolean manyCulture;
    private ArrayList<String> scientificLeader;

    public RACE(IO baselink) {
        super(baselink);
        this.cityName = new ArrayList();
        this.greatLeader = new ArrayList();
        this.forwardFilename = new ArrayList();
        this.reverseFilename = new ArrayList();
        this.scientificLeader = new ArrayList();
        this.flavours = new ArrayList();
    }

    public RACE(String name, int numFlavors, IO baselink) {
        super(baselink);
        this.civilizationName = name;
        this.cityName = new ArrayList();
        this.greatLeader = new ArrayList();
        this.forwardFilename = new ArrayList();
        this.reverseFilename = new ArrayList();
        for (int i = 0; i < 4; ++i) {
            this.forwardFilename.add(new String(""));
            this.reverseFilename.add(new String(""));
        }
        this.scientificLeader = new ArrayList();
        this.flavours = new ArrayList(numFlavors);
        this.favoriteGovernment = -1;
        this.shunnedGovernment = -1;
        this.kingUnitInt = -1;
        this.freeTech1Index = -1;
        this.freeTech2Index = -1;
        this.freeTech3Index = -1;
        this.freeTech4Index = -1;
        this.cultureGroup = -1;
    }

    public void trim() {
        int j;
        for (j = 0; j < this.cityName.size(); ++j) {
            this.cityName.set(j, this.cityName.get(j).trim());
        }
        for (j = 0; j < this.greatLeader.size(); ++j) {
            this.greatLeader.set(j, this.greatLeader.get(j).trim());
        }
        for (j = 0; j < this.scientificLeader.size(); ++j) {
            this.scientificLeader.set(j, this.scientificLeader.get(j).trim());
        }
        this.leaderName = this.leaderName.trim();
        this.leaderTitle = this.leaderTitle.trim();
        this.civilopediaEntry = this.civilopediaEntry.trim();
        this.adjective = this.adjective.trim();
        this.civilizationName = this.civilizationName.trim();
        this.noun = this.noun.trim();
        for (j = 0; j < this.forwardFilename.size(); ++j) {
            this.forwardFilename.set(j, this.forwardFilename.get(j).trim());
        }
        for (j = 0; j < this.reverseFilename.size(); ++j) {
            this.reverseFilename.set(j, this.reverseFilename.get(j).trim());
        }
    }

    public int getDataLength() {
        return this.dataLength;
    }

    public int getNumCityNames() {
        return this.numCityNames;
    }

    public int getNumGreatLeaders() {
        return this.numGreatLeaders;
    }

    public String getLeaderName() {
        return this.leaderName;
    }

    public String getLeaderTitle() {
        return this.leaderTitle;
    }

    @Override
    public String getCivilopediaEntry() {
        return this.civilopediaEntry;
    }

    public String getAdjective() {
        return this.adjective;
    }

    @Override
    public String getName() {
        return this.civilizationName;
    }

    public String getCivilizationName() {
        return this.civilizationName;
    }

    public String getNoun() {
        return this.noun;
    }

    public int getCultureGroup() {
        return this.cultureGroup;
    }

    public int getLeaderGender() {
        return this.leaderGender;
    }

    public int getCivilizationGender() {
        return this.civilizationGender;
    }

    public int getAggressionLevel() {
        return this.aggressionLevel;
    }

    public int getUniqueCivilizationCounter() {
        return this.uniqueCivilizationCounter;
    }

    public int getShunnedGovernment() {
        return this.shunnedGovernment;
    }

    public int getFavoriteGovernment() {
        return this.favoriteGovernment;
    }

    public int getDefaultColor() {
        return this.defaultColor;
    }

    public int getUniqueColor() {
        return this.uniqueColor;
    }

    public int getFreeTech1Index() {
        return this.freeTech1Index;
    }

    public int getFreeTech2Index() {
        return this.freeTech2Index;
    }

    public int getFreeTech3Index() {
        return this.freeTech3Index;
    }

    public int getFreeTech4Index() {
        return this.freeTech4Index;
    }

    public int getBonuses() {
        return this.bonuses;
    }

    public int getGovernorSettings() {
        return this.governorSettings;
    }

    public int getBuildNever() {
        return this.buildNever;
    }

    public int getBuildOften() {
        return this.buildOften;
    }

    public int getPlurality() {
        return this.plurality;
    }

    public int getKingUnit() {
        return this.kingUnitInt;
    }

    public int getFlavors() {
        return this.flavors;
    }

    public int getQuestionMark() {
        return this.questionMark;
    }

    public int getDiplomacyTextIndex() {
        return this.diplomacyTextIndex;
    }

    public int getNumScientificLeaders() {
        return this.numScientificLeaders;
    }

    public boolean getMilitaristic() {
        return this.militaristic;
    }

    public boolean getCommercial() {
        return this.commercial;
    }

    public boolean getExpansionist() {
        return this.expansionist;
    }

    public boolean getScientific() {
        return this.scientific;
    }

    public boolean getReligious() {
        return this.religious;
    }

    public boolean getIndustrious() {
        return this.industrious;
    }

    public boolean getAgricultural() {
        return this.agricultural;
    }

    public boolean getSeafaring() {
        return this.seafaring;
    }

    public boolean getManageCitizens() {
        return this.manageCitizens;
    }

    public boolean getEmphasizeFood() {
        return this.emphasizeFood;
    }

    public boolean getEmphasizeShields() {
        return this.emphasizeShields;
    }

    public boolean getEmphasizeTrade() {
        return this.emphasizeTrade;
    }

    public boolean getManageProduction() {
        return this.manageProduction;
    }

    public boolean getNoWonders() {
        return this.noWonders;
    }

    public boolean getNoSmallWonders() {
        return this.noSmallWonders;
    }

    public boolean getNoOffensiveLandUnits() {
        return this.noOffensiveLandUnits;
    }

    public boolean getNoDefensiveLandUnits() {
        return this.noDefensiveLandUnits;
    }

    public boolean getNoArtillery() {
        return this.noArtillery;
    }

    public boolean getNoSettlers() {
        return this.noSettlers;
    }

    public boolean getNoWorkers() {
        return this.noWorkers;
    }

    public boolean getNoShips() {
        return this.noShips;
    }

    public boolean getNoAirUnits() {
        return this.noAirUnits;
    }

    public boolean getNoGrowth() {
        return this.noGrowth;
    }

    public boolean getNoProduction() {
        return this.noProduction;
    }

    public boolean getNoHappiness() {
        return this.noHappiness;
    }

    public boolean getNoScience() {
        return this.noScience;
    }

    public boolean getNoWealth() {
        return this.noWealth;
    }

    public boolean getNoTrade() {
        return this.noTrade;
    }

    public boolean getNoExploration() {
        return this.noExploration;
    }

    public boolean getNoCulture() {
        return this.noCulture;
    }

    public boolean getManyOffensiveLandUnits() {
        return this.manyOffensiveLandUnits;
    }

    public boolean getManyDefensiveLandUnits() {
        return this.manyDefensiveLandUnits;
    }

    public boolean getManyArtillery() {
        return this.manyArtillery;
    }

    public boolean getManySettlers() {
        return this.manySettlers;
    }

    public boolean getManyWorkers() {
        return this.manyWorkers;
    }

    public boolean getManyShips() {
        return this.manyShips;
    }

    public boolean getManyAirUnits() {
        return this.manyAirUnits;
    }

    public boolean getManyGrowth() {
        return this.manyGrowth;
    }

    public boolean getManyProduction() {
        return this.manyProduction;
    }

    public boolean getManyHappiness() {
        return this.manyHappiness;
    }

    public boolean getManyScience() {
        return this.manyScience;
    }

    public boolean getManyWealth() {
        return this.manyWealth;
    }

    public boolean getManyTrade() {
        return this.manyTrade;
    }

    public boolean getManyExploration() {
        return this.manyExploration;
    }

    public boolean getManyCulture() {
        return this.manyCulture;
    }

    public void setLeaderName(String leaderName) {
        this.leaderName = leaderName;
    }

    public void setLeaderTitle(String leaderTitle) {
        this.leaderTitle = leaderTitle;
    }

    public void setCivilopediaEntry(String civilopediaEntry) {
        this.civilopediaEntry = civilopediaEntry;
    }

    public void setAdjective(String adjective) {
        this.adjective = adjective;
    }

    public void setCivilizationName(String civilizationName) {
        this.civilizationName = civilizationName;
    }

    public void setNoun(String noun) {
        this.noun = noun;
    }

    public void setCultureGroup(int cultureGroup) {
        this.cultureGroup = cultureGroup;
    }

    public void setLeaderGender(int leaderGender) {
        this.leaderGender = leaderGender;
    }

    public void setCivilizationGender(int civilizationGender) {
        this.civilizationGender = civilizationGender;
    }

    public void setAggressionLevel(int aggressionLevel) {
        this.aggressionLevel = aggressionLevel;
    }

    public void setUniqueCivilizationCounter(int uniqueCivilizationCounter) {
        this.uniqueCivilizationCounter = uniqueCivilizationCounter;
    }

    public void setShunnedGovernment(int shunnedGovernment) {
        this.shunnedGovernment = shunnedGovernment;
    }

    public void setFavoriteGovernment(int favoriteGovernment) {
        this.favoriteGovernment = favoriteGovernment;
    }

    public void setDefaultColor(int defaultColor) {
        this.defaultColor = defaultColor;
    }

    public void setUniqueColor(int uniqueColor) {
        this.uniqueColor = uniqueColor;
    }

    public void refreshFreeTechs() {
        this.setFreeTech1Index(this.freeTech1Index);
        this.setFreeTech2Index(this.freeTech2Index);
        this.setFreeTech3Index(this.freeTech3Index);
        this.setFreeTech4Index(this.freeTech4Index);
    }

    public void setFreeTech1Index(int freeTech1Index) {
        this.freeTech1Index = freeTech1Index;
        if (this.baseLink.technology != null && freeTech1Index != -1 && this.baseLink.technology.size() > freeTech1Index) {
            this.freeTech1 = this.baseLink.technology.get(freeTech1Index);
        }
    }

    public void setFreeTech2Index(int freeTech2Index) {
        this.freeTech2Index = freeTech2Index;
        if (this.baseLink.technology != null && freeTech2Index != -1 && this.baseLink.technology.size() > freeTech2Index) {
            this.freeTech2 = this.baseLink.technology.get(freeTech2Index);
        }
    }

    public void setFreeTech3Index(int freeTech3Index) {
        this.freeTech3Index = freeTech3Index;
        if (this.baseLink.technology != null && freeTech3Index != -1 && this.baseLink.technology.size() > freeTech3Index) {
            this.freeTech3 = this.baseLink.technology.get(freeTech3Index);
        }
    }

    public void setFreeTech4Index(int freeTech4Index) {
        this.freeTech4Index = freeTech4Index;
        if (this.baseLink.technology != null && freeTech4Index != -1 && this.baseLink.technology.size() > freeTech4Index) {
            this.freeTech4 = this.baseLink.technology.get(freeTech4Index);
        }
    }

    public void setBonuses(int bonuses) {
        this.bonuses = bonuses;
    }

    public void setGovernorSettings(int governorSettings) {
        this.governorSettings = governorSettings;
    }

    public void setBuildNever(int buildNever) {
        this.buildNever = buildNever;
    }

    public void setBuildOften(int buildOften) {
        this.buildOften = buildOften;
    }

    public void setPlurality(int plurality) {
        this.plurality = plurality;
    }

    public void setKingUnit(int kingUnitInt) {
        this.kingUnitInt = kingUnitInt;
        if (this.baseLink.unit != null && kingUnitInt != -1 && this.baseLink.unit.size() > kingUnitInt) {
            this.kingUnit = this.baseLink.unit.get(kingUnitInt);
        }
    }

    public void setFlavors(int flavors) {
        this.flavors = flavors;
    }

    public void setQuestionMark(int questionMark) {
        this.questionMark = questionMark;
    }

    public void setDiplomacyTextIndex(int diplomacyTextIndex) {
        this.diplomacyTextIndex = diplomacyTextIndex;
    }

    public void setMilitaristic(boolean militaristic) {
        this.militaristic = militaristic;
    }

    public void setCommercial(boolean commercial) {
        this.commercial = commercial;
    }

    public void setExpansionist(boolean expansionist) {
        this.expansionist = expansionist;
    }

    public void setScientific(boolean scientific) {
        this.scientific = scientific;
    }

    public void setReligious(boolean religious) {
        this.religious = religious;
    }

    public void setIndustrious(boolean industrious) {
        this.industrious = industrious;
    }

    public void setAgricultural(boolean agricultural) {
        this.agricultural = agricultural;
    }

    public void setSeafaring(boolean seafaring) {
        this.seafaring = seafaring;
    }

    public void setManageCitizens(boolean manageCitizens) {
        this.manageCitizens = manageCitizens;
    }

    public void setEmphasizeFood(boolean emphasizeFood) {
        this.emphasizeFood = emphasizeFood;
    }

    public void setEmphasizeShields(boolean emphasizeShields) {
        this.emphasizeShields = emphasizeShields;
    }

    public void setEmphasizeTrade(boolean emphasizeTrade) {
        this.emphasizeTrade = emphasizeTrade;
    }

    public void setManageProduction(boolean manageProduction) {
        this.manageProduction = manageProduction;
    }

    public void setNoWonders(boolean noWonders) {
        this.noWonders = noWonders;
    }

    public void setNoSmallWonders(boolean noSmallWonders) {
        this.noSmallWonders = noSmallWonders;
    }

    public void setNoOffensiveLandUnits(boolean noOffensiveLandUnits) {
        this.noOffensiveLandUnits = noOffensiveLandUnits;
    }

    public void setNoDefensiveLandUnits(boolean noDefensiveLandUnits) {
        this.noDefensiveLandUnits = noDefensiveLandUnits;
    }

    public void setNoArtillery(boolean noArtillery) {
        this.noArtillery = noArtillery;
    }

    public void setNoSettlers(boolean noSettlers) {
        this.noSettlers = noSettlers;
    }

    public void setNoWorkers(boolean noWorkers) {
        this.noWorkers = noWorkers;
    }

    public void setNoShips(boolean noShips) {
        this.noShips = noShips;
    }

    public void setNoAirUnits(boolean noAirUnits) {
        this.noAirUnits = noAirUnits;
    }

    public void setNoGrowth(boolean noGrowth) {
        this.noGrowth = noGrowth;
    }

    public void setNoProduction(boolean noProduction) {
        this.noProduction = noProduction;
    }

    public void setNoHappiness(boolean noHappiness) {
        this.noHappiness = noHappiness;
    }

    public void setNoScience(boolean noScience) {
        this.noScience = noScience;
    }

    public void setNoWealth(boolean noWealth) {
        this.noWealth = noWealth;
    }

    public void setNoTrade(boolean noTrade) {
        this.noTrade = noTrade;
    }

    public void setNoExploration(boolean noExploration) {
        this.noExploration = noExploration;
    }

    public void setNoCulture(boolean noCulture) {
        this.noCulture = noCulture;
    }

    public void setManyOffensiveLandUnits(boolean manyOffensiveLandUnits) {
        this.manyOffensiveLandUnits = manyOffensiveLandUnits;
    }

    public void setManyDefensiveLandUnits(boolean manyDefensiveLandUnits) {
        this.manyDefensiveLandUnits = manyDefensiveLandUnits;
    }

    public void setManyArtillery(boolean manyArtillery) {
        this.manyArtillery = manyArtillery;
    }

    public void setManySettlers(boolean manySettlers) {
        this.manySettlers = manySettlers;
    }

    public void setManyWorkers(boolean manyWorkers) {
        this.manyWorkers = manyWorkers;
    }

    public void setManyShips(boolean manyShips) {
        this.manyShips = manyShips;
    }

    public void setManyAirUnits(boolean manyAirUnits) {
        this.manyAirUnits = manyAirUnits;
    }

    public void setManyGrowth(boolean manyGrowth) {
        this.manyGrowth = manyGrowth;
    }

    public void setManyProduction(boolean manyProduction) {
        this.manyProduction = manyProduction;
    }

    public void setManyHappiness(boolean manyHappiness) {
        this.manyHappiness = manyHappiness;
    }

    public void setManyScience(boolean manyScience) {
        this.manyScience = manyScience;
    }

    public void setManyWealth(boolean manyWealth) {
        this.manyWealth = manyWealth;
    }

    public void setManyTrade(boolean manyTrade) {
        this.manyTrade = manyTrade;
    }

    public void setManyExploration(boolean manyExploration) {
        this.manyExploration = manyExploration;
    }

    public void setManyCulture(boolean manyCulture) {
        this.manyCulture = manyCulture;
    }

    public void handleConvertFromPTWToConquests() {
    }

    public List<String> getMilitaryLeaders() {
        return Collections.unmodifiableList(this.greatLeader);
    }

    public void addMilitaryLeader(String name) {
        ++this.numGreatLeaders;
        this.greatLeader.add(name);
        this.dataLength += 32;
    }

    public void renameMilitaryLeader(int index, String newName) {
        this.greatLeader.set(index, newName);
    }

    public void removeMilitaryLeader(int index) {
        --this.numGreatLeaders;
        this.greatLeader.remove(index);
        this.dataLength -= 32;
    }

    public List<String> getScientificLeaders() {
        return Collections.unmodifiableList(this.scientificLeader);
    }

    public void addScientificLeader(String name) {
        ++this.numScientificLeaders;
        this.scientificLeader.add(name);
        this.dataLength += 32;
    }

    public void renameScientificLeader(int index, String newName) {
        this.scientificLeader.set(index, newName);
    }

    public void removeScientificLeader(int index) {
        --this.numScientificLeaders;
        this.scientificLeader.remove(index);
        this.dataLength -= 32;
    }

    public List<String> getCityNames() {
        return Collections.unmodifiableList(this.cityName);
    }

    public void addCityName(String name) {
        ++this.numCityNames;
        this.cityName.add(name);
        this.dataLength += 24;
    }

    public void renameCity(int index, String newName) {
        this.cityName.set(index, newName);
    }

    public void removeCityName(int index) {
        this.cityName.remove(index);
        --this.numCityNames;
        this.dataLength -= 24;
    }

    public void handleAddedFlavour() {
        this.flavours.add(false);
        ++this.numFlavors;
    }

    public void handleDeletedFlavour(int index) {
        this.flavours.remove(index);
        --this.numFlavors;
        this.createBinary();
    }

    public int getNumFlavours() {
        return this.numFlavors;
    }

    public void resetFlavours() {
        for (int i = 0; i < this.flavours.size(); ++i) {
            this.flavours.set(i, false);
        }
        this.createBinary();
    }

    public void setFlavour(int index, Boolean value) {
        this.flavours.set(index, value);
        this.createBinary();
    }

    public boolean getFlavour(int index) {
        return this.flavours.get(index);
    }

    public void handleDeletedUnit(int index) {
        if (this.kingUnitInt == index) {
            this.kingUnitInt = -1;
            this.kingUnit = null;
        } else if (this.kingUnitInt > index) {
            --this.kingUnitInt;
        }
    }

    public void handleSwappedUnit() {
        if (this.kingUnitInt != -1) {
            this.kingUnitInt = this.kingUnit.getIndex();
        }
    }

    public void handleDeletedTechnology(int index) {
        if (this.freeTech1Index == index) {
            this.freeTech1Index = -1;
            this.freeTech1 = null;
        } else if (this.freeTech1Index > index) {
            --this.freeTech1Index;
        }
        if (this.freeTech2Index == index) {
            this.freeTech2Index = -1;
            this.freeTech2 = null;
        } else if (this.freeTech2Index > index) {
            --this.freeTech2Index;
        }
        if (this.freeTech3Index == index) {
            this.freeTech3Index = -1;
            this.freeTech3 = null;
        } else if (this.freeTech3Index > index) {
            --this.freeTech3Index;
        }
        if (this.freeTech4Index == index) {
            this.freeTech4Index = -1;
            this.freeTech4 = null;
        } else if (this.freeTech4Index > index) {
            --this.freeTech4Index;
        }
    }

    public void handleSwappedTech() {
        if (this.freeTech1Index != -1) {
            this.freeTech1Index = this.freeTech1.getIndex();
        }
        if (this.freeTech2Index != -1) {
            this.freeTech2Index = this.freeTech2.getIndex();
        }
        if (this.freeTech3Index != -1) {
            this.freeTech3Index = this.freeTech3.getIndex();
        }
        if (this.freeTech4Index != -1) {
            this.freeTech4Index = this.freeTech4.getIndex();
        }
    }

    public void handleDeletedGovernment(int index) {
        if (this.favoriteGovernment == index) {
            this.favoriteGovernment = -1;
        } else if (this.favoriteGovernment > index) {
            --this.favoriteGovernment;
        }
        if (this.shunnedGovernment == index) {
            this.shunnedGovernment = -1;
        } else if (this.shunnedGovernment > index) {
            --this.shunnedGovernment;
        }
    }

    public void addForwardFilename(String filename) {
        this.forwardFilename.add(filename);
    }

    public void setForwardFilename(int index, String filename) {
        this.forwardFilename.set(index, filename);
    }

    public String getForwardFilename(int index) {
        return this.forwardFilename.get(index);
    }

    public void addReverseFilename(String filename) {
        this.reverseFilename.add(filename);
    }

    public void setReverseFilename(int index, String filename) {
        this.reverseFilename.set(index, filename);
    }

    public String getReverseFilename(int index) {
        return this.reverseFilename.get(index);
    }

    @Override
    public String toString() {
        int j;
        String lineReturn = System.getProperty("line.separator");
        String toReturn = "dataLength: " + this.dataLength + lineReturn;
        toReturn = toReturn + "numCityNames: " + this.numCityNames + lineReturn;
        for (j = 0; j < this.cityName.size(); ++j) {
            toReturn = toReturn + this.cityName.get(j) + lineReturn;
        }
        toReturn = toReturn + "numGreatLeaders: " + this.numGreatLeaders + lineReturn;
        for (j = 0; j < this.numGreatLeaders; ++j) {
            toReturn = toReturn + this.greatLeader.get(j) + lineReturn;
        }
        toReturn = toReturn + "leaderName: " + this.leaderName + lineReturn;
        toReturn = toReturn + "leaderTitle: " + this.leaderTitle + lineReturn;
        toReturn = toReturn + "civilopediaEntry: " + this.civilopediaEntry + lineReturn;
        toReturn = toReturn + "adjective: " + this.adjective + lineReturn;
        toReturn = toReturn + "civilizationName: " + this.civilizationName + lineReturn;
        toReturn = toReturn + "noun: " + this.noun + lineReturn;
        for (j = 0; j < this.forwardFilename.size(); ++j) {
            toReturn = toReturn + "forwardFilename for era " + j + ": " + this.forwardFilename.get(j) + lineReturn;
        }
        for (j = 0; j < this.reverseFilename.size(); ++j) {
            toReturn = toReturn + "reverseFilename for era " + j + ": " + this.reverseFilename.get(j) + lineReturn;
        }
        toReturn = toReturn + "cultureGroup: " + this.cultureGroup + lineReturn;
        toReturn = toReturn + "leaderGender: " + this.leaderGender + lineReturn;
        toReturn = toReturn + "civilizationGender: " + this.civilizationGender + lineReturn;
        toReturn = toReturn + "aggressionLevel: " + this.aggressionLevel + lineReturn;
        toReturn = toReturn + "uniqueCivilizationCounter: " + this.uniqueCivilizationCounter + lineReturn;
        toReturn = toReturn + "shunnedGovernment: " + this.shunnedGovernment + lineReturn;
        toReturn = toReturn + "favoriteGovernment: " + this.favoriteGovernment + lineReturn;
        toReturn = toReturn + "defaultColor: " + this.defaultColor + lineReturn;
        toReturn = toReturn + "uniqueColor: " + this.uniqueColor + lineReturn;
        toReturn = toReturn + "freeTech1Index: " + this.freeTech1Index + lineReturn;
        toReturn = toReturn + "freeTech2Index: " + this.freeTech2Index + lineReturn;
        toReturn = toReturn + "freeTech3Index: " + this.freeTech3Index + lineReturn;
        toReturn = toReturn + "freeTech4Index: " + this.freeTech4Index + lineReturn;
        toReturn = toReturn + "civilization traits: " + this.bonuses + lineReturn;
        toReturn = toReturn + "governorSettings: " + this.governorSettings + lineReturn;
        toReturn = toReturn + "buildNever: " + this.buildNever + lineReturn;
        toReturn = toReturn + "buildOften: " + this.buildOften + lineReturn;
        toReturn = toReturn + "plurality: " + this.plurality + lineReturn;
        toReturn = toReturn + "kingUnit: " + this.kingUnitInt + lineReturn;
        toReturn = toReturn + "flavors: " + this.flavors + lineReturn;
        toReturn = toReturn + "questionMark: " + this.questionMark + lineReturn;
        toReturn = toReturn + "diplomacyTextIndex: " + this.diplomacyTextIndex + lineReturn;
        toReturn = toReturn + "numScientificLeaders: " + this.numScientificLeaders + lineReturn;
        for (j = 0; j < this.numScientificLeaders; ++j) {
            toReturn = toReturn + this.scientificLeader.get(j) + lineReturn;
        }
        toReturn = toReturn + lineReturn;
        return toReturn;
    }

    public void createBinary() {
        this.bonuses = 0;
        if (this.militaristic) {
            ++this.bonuses;
        }
        if (this.commercial) {
            this.bonuses += 2;
        }
        if (this.expansionist) {
            this.bonuses += 4;
        }
        if (this.scientific) {
            this.bonuses += 8;
        }
        if (this.religious) {
            this.bonuses += 16;
        }
        if (this.industrious) {
            this.bonuses += 32;
        }
        if (this.agricultural) {
            this.bonuses += 64;
        }
        if (this.seafaring) {
            this.bonuses += 128;
        }
        this.governorSettings = 0;
        if (this.manageCitizens) {
            ++this.governorSettings;
        }
        if (this.emphasizeFood) {
            this.governorSettings += 2;
        }
        if (this.emphasizeShields) {
            this.governorSettings += 4;
        }
        if (this.emphasizeTrade) {
            this.governorSettings += 8;
        }
        if (this.manageProduction) {
            this.governorSettings += 16;
        }
        if (this.noWonders) {
            this.governorSettings += 32;
        }
        if (this.noSmallWonders) {
            this.governorSettings += 64;
        }
        this.buildOften = 0;
        if (this.manyOffensiveLandUnits) {
            ++this.buildOften;
        }
        if (this.manyDefensiveLandUnits) {
            this.buildOften += 2;
        }
        if (this.manyArtillery) {
            this.buildOften += 4;
        }
        if (this.manySettlers) {
            this.buildOften += 8;
        }
        if (this.manyWorkers) {
            this.buildOften += 16;
        }
        if (this.manyShips) {
            this.buildOften += 32;
        }
        if (this.manyAirUnits) {
            this.buildOften += 64;
        }
        if (this.manyGrowth) {
            this.buildOften += 128;
        }
        if (this.manyProduction) {
            this.buildOften += 256;
        }
        if (this.manyHappiness) {
            this.buildOften += 512;
        }
        if (this.manyScience) {
            this.buildOften += 1024;
        }
        if (this.manyWealth) {
            this.buildOften += 2048;
        }
        if (this.manyTrade) {
            this.buildOften += 4096;
        }
        if (this.manyExploration) {
            this.buildOften += 8192;
        }
        if (this.manyCulture) {
            this.buildOften += 16384;
        }
        this.buildNever = 0;
        if (this.noOffensiveLandUnits) {
            ++this.buildNever;
        }
        if (this.noDefensiveLandUnits) {
            this.buildNever += 2;
        }
        if (this.noArtillery) {
            this.buildNever += 4;
        }
        if (this.noSettlers) {
            this.buildNever += 8;
        }
        if (this.noWorkers) {
            this.buildNever += 16;
        }
        if (this.noShips) {
            this.buildNever += 32;
        }
        if (this.noAirUnits) {
            this.buildNever += 64;
        }
        if (this.noGrowth) {
            this.buildNever += 128;
        }
        if (this.noProduction) {
            this.buildNever += 256;
        }
        if (this.noHappiness) {
            this.buildNever += 512;
        }
        if (this.noScience) {
            this.buildNever += 1024;
        }
        if (this.noWealth) {
            this.buildNever += 2048;
        }
        if (this.noTrade) {
            this.buildNever += 4096;
        }
        if (this.noExploration) {
            this.buildNever += 8192;
        }
        if (this.noCulture) {
            this.buildNever += 16384;
        }
        long sum = 0L;
        for (int i = 0; i < this.flavours.size(); ++i) {
            if (!this.flavours.get(i).booleanValue()) continue;
            sum += (long)((int)Math.pow(2.0, i));
        }
        this.flavors = (int)sum;
    }

    public void extractEnglish(int numFlavours) {
        int i;
        int buildOftenCopy;
        int buildNeverCopy;
        int govCopy;
        int bonusCopy = this.bonuses;
        int divBy = 0;
        divBy = bonusCopy / (int)Math.pow(2.0, 7.0);
        if (divBy == 1) {
            this.seafaring = true;
            bonusCopy -= 128;
        }
        if ((divBy = bonusCopy / (int)Math.pow(2.0, 6.0)) == 1) {
            this.agricultural = true;
            bonusCopy -= 64;
        }
        if ((divBy = bonusCopy / (int)Math.pow(2.0, 5.0)) == 1) {
            this.industrious = true;
            bonusCopy -= 32;
        }
        if ((divBy = bonusCopy / (int)Math.pow(2.0, 4.0)) == 1) {
            this.religious = true;
            bonusCopy -= 16;
        }
        if ((divBy = bonusCopy / (int)Math.pow(2.0, 3.0)) == 1) {
            this.scientific = true;
            bonusCopy -= 8;
        }
        if ((divBy = bonusCopy / (int)Math.pow(2.0, 2.0)) == 1) {
            this.expansionist = true;
            bonusCopy -= 4;
        }
        if ((divBy = bonusCopy / (int)Math.pow(2.0, 1.0)) == 1) {
            this.commercial = true;
            bonusCopy -= 2;
        }
        if ((divBy = bonusCopy / (int)Math.pow(2.0, 0.0)) == 1) {
            this.militaristic = true;
            --bonusCopy;
        }
        if ((divBy = (govCopy = this.governorSettings) / (int)Math.pow(2.0, 6.0)) == 1) {
            this.noSmallWonders = true;
            govCopy -= 64;
        }
        if ((divBy = govCopy / (int)Math.pow(2.0, 5.0)) == 1) {
            this.noWonders = true;
            govCopy -= 32;
        }
        if ((divBy = govCopy / (int)Math.pow(2.0, 4.0)) == 1) {
            this.manageProduction = true;
            govCopy -= 16;
        }
        if ((divBy = govCopy / (int)Math.pow(2.0, 3.0)) == 1) {
            this.emphasizeTrade = true;
            govCopy -= 8;
        }
        if ((divBy = govCopy / (int)Math.pow(2.0, 2.0)) == 1) {
            this.emphasizeShields = true;
            govCopy -= 4;
        }
        if ((divBy = govCopy / (int)Math.pow(2.0, 1.0)) == 1) {
            this.emphasizeFood = true;
            govCopy -= 2;
        }
        if ((divBy = govCopy / (int)Math.pow(2.0, 0.0)) == 1) {
            this.manageCitizens = true;
            --govCopy;
        }
        if ((divBy = (buildNeverCopy = this.buildNever) / (int)Math.pow(2.0, 14.0)) == 1) {
            this.noCulture = true;
            buildNeverCopy -= 16384;
        }
        if ((divBy = buildNeverCopy / (int)Math.pow(2.0, 13.0)) == 1) {
            this.noExploration = true;
            buildNeverCopy -= 8192;
        }
        if ((divBy = buildNeverCopy / (int)Math.pow(2.0, 12.0)) == 1) {
            this.noTrade = true;
            buildNeverCopy -= 4096;
        }
        if ((divBy = buildNeverCopy / (int)Math.pow(2.0, 11.0)) == 1) {
            this.noWealth = true;
            buildNeverCopy -= 2048;
        }
        if ((divBy = buildNeverCopy / (int)Math.pow(2.0, 10.0)) == 1) {
            this.noScience = true;
            buildNeverCopy -= 1024;
        }
        if ((divBy = buildNeverCopy / (int)Math.pow(2.0, 9.0)) == 1) {
            this.noHappiness = true;
            buildNeverCopy -= 512;
        }
        if ((divBy = buildNeverCopy / (int)Math.pow(2.0, 8.0)) == 1) {
            this.noProduction = true;
            buildNeverCopy -= 256;
        }
        if ((divBy = buildNeverCopy / (int)Math.pow(2.0, 7.0)) == 1) {
            this.noGrowth = true;
            buildNeverCopy -= 128;
        }
        if ((divBy = buildNeverCopy / (int)Math.pow(2.0, 6.0)) == 1) {
            this.noAirUnits = true;
            buildNeverCopy -= 64;
        }
        if ((divBy = buildNeverCopy / (int)Math.pow(2.0, 5.0)) == 1) {
            this.noShips = true;
            buildNeverCopy -= 32;
        }
        if ((divBy = buildNeverCopy / (int)Math.pow(2.0, 4.0)) == 1) {
            this.noWorkers = true;
            buildNeverCopy -= 16;
        }
        if ((divBy = buildNeverCopy / (int)Math.pow(2.0, 3.0)) == 1) {
            this.noSettlers = true;
            buildNeverCopy -= 8;
        }
        if ((divBy = buildNeverCopy / (int)Math.pow(2.0, 2.0)) == 1) {
            this.noArtillery = true;
            buildNeverCopy -= 4;
        }
        if ((divBy = buildNeverCopy / (int)Math.pow(2.0, 1.0)) == 1) {
            this.noDefensiveLandUnits = true;
            buildNeverCopy -= 2;
        }
        if ((divBy = buildNeverCopy / (int)Math.pow(2.0, 0.0)) == 1) {
            this.noOffensiveLandUnits = true;
            --buildNeverCopy;
        }
        if ((divBy = (buildOftenCopy = this.buildOften) / (int)Math.pow(2.0, 14.0)) == 1) {
            this.manyCulture = true;
            buildOftenCopy -= 16384;
        }
        if ((divBy = buildOftenCopy / (int)Math.pow(2.0, 13.0)) == 1) {
            this.manyExploration = true;
            buildOftenCopy -= 8192;
        }
        if ((divBy = buildOftenCopy / (int)Math.pow(2.0, 12.0)) == 1) {
            this.manyTrade = true;
            buildOftenCopy -= 4096;
        }
        if ((divBy = buildOftenCopy / (int)Math.pow(2.0, 11.0)) == 1) {
            this.manyWealth = true;
            buildOftenCopy -= 2048;
        }
        if ((divBy = buildOftenCopy / (int)Math.pow(2.0, 10.0)) == 1) {
            this.manyScience = true;
            buildOftenCopy -= 1024;
        }
        if ((divBy = buildOftenCopy / (int)Math.pow(2.0, 9.0)) == 1) {
            this.manyHappiness = true;
            buildOftenCopy -= 512;
        }
        if ((divBy = buildOftenCopy / (int)Math.pow(2.0, 8.0)) == 1) {
            this.manyProduction = true;
            buildOftenCopy -= 256;
        }
        if ((divBy = buildOftenCopy / (int)Math.pow(2.0, 7.0)) == 1) {
            this.manyGrowth = true;
            buildOftenCopy -= 128;
        }
        if ((divBy = buildOftenCopy / (int)Math.pow(2.0, 6.0)) == 1) {
            this.manyAirUnits = true;
            buildOftenCopy -= 64;
        }
        if ((divBy = buildOftenCopy / (int)Math.pow(2.0, 5.0)) == 1) {
            this.manyShips = true;
            buildOftenCopy -= 32;
        }
        if ((divBy = buildOftenCopy / (int)Math.pow(2.0, 4.0)) == 1) {
            this.manyWorkers = true;
            buildOftenCopy -= 16;
        }
        if ((divBy = buildOftenCopy / (int)Math.pow(2.0, 3.0)) == 1) {
            this.manySettlers = true;
            buildOftenCopy -= 8;
        }
        if ((divBy = buildOftenCopy / (int)Math.pow(2.0, 2.0)) == 1) {
            this.manyArtillery = true;
            buildOftenCopy -= 4;
        }
        if ((divBy = buildOftenCopy / (int)Math.pow(2.0, 1.0)) == 1) {
            this.manyDefensiveLandUnits = true;
            buildOftenCopy -= 2;
        }
        if ((divBy = buildOftenCopy / (int)Math.pow(2.0, 0.0)) == 1) {
            this.manyOffensiveLandUnits = true;
            --buildOftenCopy;
        }
        int flavorCopy = this.flavors;
        for (i = 0; i < numFlavours; ++i) {
            this.flavours.add(false);
        }
        for (i = numFlavours - 1; i > -1; --i) {
            divBy = flavorCopy / (int)Math.pow(2.0, i);
            if (divBy != 1) continue;
            this.flavours.set(i, true);
            flavorCopy = (int)((double)flavorCopy - Math.pow(2.0, i));
        }
        this.numFlavors = numFlavours;
    }

    @Override
    public String toEnglish() {
        int j;
        String lineReturn = System.getProperty("line.separator");
        String toReturn = "name: " + this.civilizationName + lineReturn;
        toReturn = toReturn + "civilopediaEntry: " + this.civilopediaEntry + lineReturn;
        toReturn = toReturn + "dataLength: " + this.dataLength + lineReturn;
        toReturn = toReturn + "numCityNames: " + this.numCityNames + lineReturn;
        for (j = 0; j < this.cityName.size(); ++j) {
            toReturn = toReturn + "  " + this.cityName.get(j) + lineReturn;
        }
        toReturn = toReturn + "numGreatLeaders: " + this.numGreatLeaders + lineReturn;
        for (j = 0; j < this.numGreatLeaders; ++j) {
            toReturn = toReturn + "  " + this.greatLeader.get(j) + lineReturn;
        }
        toReturn = toReturn + "leaderName: " + this.leaderName + lineReturn;
        toReturn = toReturn + "leaderTitle: " + this.leaderTitle + lineReturn;
        toReturn = toReturn + "adjective: " + this.adjective + lineReturn;
        toReturn = toReturn + "noun: " + this.noun + lineReturn;
        for (j = 0; j < this.forwardFilename.size(); ++j) {
            toReturn = toReturn + "forwardFilename for era " + j + ": " + this.forwardFilename.get(j) + lineReturn;
        }
        for (j = 0; j < this.reverseFilename.size(); ++j) {
            toReturn = toReturn + "reverseFilename for era " + j + ": " + this.reverseFilename.get(j) + lineReturn;
        }
        toReturn = toReturn + "cultureGroup: " + this.cultureGroup + lineReturn;
        toReturn = toReturn + "leaderGender: " + this.leaderGender + lineReturn;
        toReturn = toReturn + "civilizationGender: " + this.civilizationGender + lineReturn;
        toReturn = toReturn + "aggressionLevel: " + this.aggressionLevel + lineReturn;
        toReturn = toReturn + "uniqueCivilizationCounter: " + this.uniqueCivilizationCounter + lineReturn;
        toReturn = toReturn + "shunnedGovernment: " + this.shunnedGovernment + lineReturn;
        toReturn = toReturn + "favoriteGovernment: " + this.favoriteGovernment + lineReturn;
        toReturn = toReturn + "defaultColor: " + this.defaultColor + lineReturn;
        toReturn = toReturn + "uniqueColor: " + this.uniqueColor + lineReturn;
        toReturn = toReturn + "freeTech1Index: " + this.freeTech1Index + lineReturn;
        toReturn = toReturn + "freeTech2Index: " + this.freeTech2Index + lineReturn;
        toReturn = toReturn + "freeTech3Index: " + this.freeTech3Index + lineReturn;
        toReturn = toReturn + "freeTech4Index: " + this.freeTech4Index + lineReturn;
        toReturn = toReturn + "civilization traits: " + this.bonuses + lineReturn;
        toReturn = toReturn + "  militaristic: " + this.militaristic + lineReturn;
        toReturn = toReturn + "  commercial: " + this.commercial + lineReturn;
        toReturn = toReturn + "  expansionist: " + this.expansionist + lineReturn;
        toReturn = toReturn + "  scientific: " + this.scientific + lineReturn;
        toReturn = toReturn + "  religious: " + this.religious + lineReturn;
        toReturn = toReturn + "  industrious: " + this.industrious + lineReturn;
        toReturn = toReturn + "  agricultural: " + this.agricultural + lineReturn;
        toReturn = toReturn + "  seafaring: " + this.seafaring + lineReturn;
        toReturn = toReturn + "governor settings: " + this.governorSettings + lineReturn;
        toReturn = toReturn + "  manageCitizens: " + this.manageCitizens + lineReturn;
        toReturn = toReturn + "  emphasizeFood: " + this.emphasizeFood + lineReturn;
        toReturn = toReturn + "  emphasizeShields: " + this.emphasizeShields + lineReturn;
        toReturn = toReturn + "  emphasizeTrade: " + this.emphasizeTrade + lineReturn;
        toReturn = toReturn + "  manageProduction: " + this.manageProduction + lineReturn;
        toReturn = toReturn + "  noWonders: " + this.noWonders + lineReturn;
        toReturn = toReturn + "  noSmallWonders: " + this.noSmallWonders + lineReturn;
        toReturn = toReturn + "never build: " + this.buildNever + lineReturn;
        toReturn = toReturn + "  noOffensiveLandUnits: " + this.noOffensiveLandUnits + lineReturn;
        toReturn = toReturn + "  noDefensiveLandUnits: " + this.noDefensiveLandUnits + lineReturn;
        toReturn = toReturn + "  noArtillery: " + this.noArtillery + lineReturn;
        toReturn = toReturn + "  noSettlers: " + this.noSettlers + lineReturn;
        toReturn = toReturn + "  noWorkers: " + this.noWorkers + lineReturn;
        toReturn = toReturn + "  noShips: " + this.noShips + lineReturn;
        toReturn = toReturn + "  noAirUnits: " + this.noAirUnits + lineReturn;
        toReturn = toReturn + "  noGrowth: " + this.noGrowth + lineReturn;
        toReturn = toReturn + "  noProduction: " + this.noProduction + lineReturn;
        toReturn = toReturn + "  noHappiness: " + this.noHappiness + lineReturn;
        toReturn = toReturn + "  noScience: " + this.noScience + lineReturn;
        toReturn = toReturn + "  noWealth: " + this.noWealth + lineReturn;
        toReturn = toReturn + "  noTrade: " + this.noTrade + lineReturn;
        toReturn = toReturn + "  noExploration: " + this.noExploration + lineReturn;
        toReturn = toReturn + "  noCulture: " + this.noCulture + lineReturn;
        toReturn = toReturn + "build often: " + this.buildOften + lineReturn;
        toReturn = toReturn + "  manyOffensiveLandUnits: " + this.manyOffensiveLandUnits + lineReturn;
        toReturn = toReturn + "  manyDefensiveLandUnits: " + this.manyDefensiveLandUnits + lineReturn;
        toReturn = toReturn + "  manyArtillery: " + this.manyArtillery + lineReturn;
        toReturn = toReturn + "  manySettlers: " + this.manySettlers + lineReturn;
        toReturn = toReturn + "  manyWorkers: " + this.manyWorkers + lineReturn;
        toReturn = toReturn + "  manyShips: " + this.manyShips + lineReturn;
        toReturn = toReturn + "  manyAirUnits: " + this.manyAirUnits + lineReturn;
        toReturn = toReturn + "  manyGrowth: " + this.manyGrowth + lineReturn;
        toReturn = toReturn + "  manyProduction: " + this.manyProduction + lineReturn;
        toReturn = toReturn + "  manyHappiness: " + this.manyHappiness + lineReturn;
        toReturn = toReturn + "  manyScience: " + this.manyScience + lineReturn;
        toReturn = toReturn + "  manyWealth: " + this.manyWealth + lineReturn;
        toReturn = toReturn + "  manyTrade: " + this.manyTrade + lineReturn;
        toReturn = toReturn + "  manyExploration: " + this.manyExploration + lineReturn;
        toReturn = toReturn + "  manyCulture: " + this.manyCulture + lineReturn;
        toReturn = toReturn + "plurality: " + this.plurality + lineReturn;
        toReturn = toReturn + "kingUnit: " + this.kingUnitInt + lineReturn;
        toReturn = toReturn + "flavors: " + this.flavors + lineReturn;
        for (int i = 0; i < this.numFlavors; ++i) {
            toReturn = toReturn + "  flavor " + (i + 1) + ": " + this.flavours.get(i) + lineReturn;
        }
        toReturn = toReturn + "questionMark: " + this.questionMark + lineReturn;
        toReturn = toReturn + "diplomacyTextIndex: " + this.diplomacyTextIndex + lineReturn;
        toReturn = toReturn + "numScientificLeaders: " + this.numScientificLeaders + lineReturn;
        for (j = 0; j < this.numScientificLeaders; ++j) {
            toReturn = toReturn + "  " + this.scientificLeader.get(j) + lineReturn;
        }
        toReturn = toReturn + lineReturn;
        return toReturn;
    }

    @Override
    public String compareTo(BIQSection section, String separator) {
        if (!(section instanceof RACE)) {
            return null;
        }
        RACE two = (RACE)section;
        String lineReturn = System.getProperty("line.separator");
        String toReturn = "name: " + this.civilizationName + lineReturn;
        if (this.dataLength != two.getDataLength()) {
            toReturn = toReturn + "DataLength: " + this.dataLength + separator + two.getDataLength() + lineReturn;
        }
        if (this.numCityNames != two.getNumCityNames()) {
            toReturn = toReturn + "NumCityNames: " + this.numCityNames + separator + two.getNumCityNames() + lineReturn;
        }
        if (this.numGreatLeaders != two.getNumGreatLeaders()) {
            toReturn = toReturn + "NumGreatLeaders: " + this.numGreatLeaders + separator + two.getNumGreatLeaders() + lineReturn;
        }
        if (this.leaderName.compareTo(two.getLeaderName()) != 0) {
            toReturn = toReturn + "LeaderName: " + this.leaderName + separator + two.getLeaderName() + lineReturn;
        }
        if (this.leaderTitle.compareTo(two.getLeaderTitle()) != 0) {
            toReturn = toReturn + "LeaderTitle: " + this.leaderTitle + separator + two.getLeaderTitle() + lineReturn;
        }
        if (this.civilopediaEntry.compareTo(two.getCivilopediaEntry()) != 0) {
            toReturn = toReturn + "CivilopediaEntry: " + this.civilopediaEntry + separator + two.getCivilopediaEntry() + lineReturn;
        }
        if (this.adjective.compareTo(two.getAdjective()) != 0) {
            toReturn = toReturn + "Adjective: " + this.adjective + separator + two.getAdjective() + lineReturn;
        }
        if (this.noun.compareTo(two.getNoun()) != 0) {
            toReturn = toReturn + "Noun: " + this.noun + separator + two.getNoun() + lineReturn;
        }
        if (this.cultureGroup != two.getCultureGroup()) {
            toReturn = toReturn + "CultureGroup: " + this.cultureGroup + separator + two.getCultureGroup() + lineReturn;
        }
        if (this.leaderGender != two.getLeaderGender()) {
            toReturn = toReturn + "LeaderGender: " + this.leaderGender + separator + two.getLeaderGender() + lineReturn;
        }
        if (this.civilizationGender != two.getCivilizationGender()) {
            toReturn = toReturn + "CivilizationGender: " + this.civilizationGender + separator + two.getCivilizationGender() + lineReturn;
        }
        if (this.aggressionLevel != two.getAggressionLevel()) {
            toReturn = toReturn + "AggressionLevel: " + this.aggressionLevel + separator + two.getAggressionLevel() + lineReturn;
        }
        if (this.uniqueCivilizationCounter != two.getUniqueCivilizationCounter()) {
            toReturn = toReturn + "UniqueCivilizationCounter: " + this.uniqueCivilizationCounter + separator + two.getUniqueCivilizationCounter() + lineReturn;
        }
        if (this.shunnedGovernment != two.getShunnedGovernment()) {
            toReturn = toReturn + "ShunnedGovernment: " + this.shunnedGovernment + separator + two.getShunnedGovernment() + lineReturn;
        }
        if (this.favoriteGovernment != two.getFavoriteGovernment()) {
            toReturn = toReturn + "FavoriteGovernment: " + this.favoriteGovernment + separator + two.getFavoriteGovernment() + lineReturn;
        }
        if (this.defaultColor != two.getDefaultColor()) {
            toReturn = toReturn + "DefaultColor: " + this.defaultColor + separator + two.getDefaultColor() + lineReturn;
        }
        if (this.uniqueColor != two.getUniqueColor()) {
            toReturn = toReturn + "UniqueColor: " + this.uniqueColor + separator + two.getUniqueColor() + lineReturn;
        }
        if (this.freeTech1Index != two.getFreeTech1Index()) {
            toReturn = toReturn + "FreeTech1Index: " + this.freeTech1Index + separator + two.getFreeTech1Index() + lineReturn;
        }
        if (this.freeTech2Index != two.getFreeTech2Index()) {
            toReturn = toReturn + "FreeTech2Index: " + this.freeTech2Index + separator + two.getFreeTech2Index() + lineReturn;
        }
        if (this.freeTech3Index != two.getFreeTech3Index()) {
            toReturn = toReturn + "FreeTech3Index: " + this.freeTech3Index + separator + two.getFreeTech3Index() + lineReturn;
        }
        if (this.freeTech4Index != two.getFreeTech4Index()) {
            toReturn = toReturn + "FreeTech4Index: " + this.freeTech4Index + separator + two.getFreeTech4Index() + lineReturn;
        }
        if (this.bonuses != two.getBonuses()) {
            toReturn = toReturn + "Civilization traits: " + this.bonuses + separator + two.getBonuses() + lineReturn;
        }
        if (this.militaristic != two.getMilitaristic()) {
            toReturn = toReturn + "  Militaristic: " + this.militaristic + separator + two.getMilitaristic() + lineReturn;
        }
        if (this.commercial != two.getCommercial()) {
            toReturn = toReturn + "  Commercial: " + this.commercial + separator + two.getCommercial() + lineReturn;
        }
        if (this.expansionist != two.getExpansionist()) {
            toReturn = toReturn + "  Expansionist: " + this.expansionist + separator + two.getExpansionist() + lineReturn;
        }
        if (this.scientific != two.getScientific()) {
            toReturn = toReturn + "  Scientific: " + this.scientific + separator + two.getScientific() + lineReturn;
        }
        if (this.religious != two.getReligious()) {
            toReturn = toReturn + "  Religious: " + this.religious + separator + two.getReligious() + lineReturn;
        }
        if (this.industrious != two.getIndustrious()) {
            toReturn = toReturn + "  Industrious: " + this.industrious + separator + two.getIndustrious() + lineReturn;
        }
        if (this.agricultural != two.getAgricultural()) {
            toReturn = toReturn + "  Agricultural: " + this.agricultural + separator + two.getAgricultural() + lineReturn;
        }
        if (this.seafaring != two.getSeafaring()) {
            toReturn = toReturn + "  Seafaring: " + this.seafaring + separator + two.getSeafaring() + lineReturn;
        }
        if (this.governorSettings != two.getGovernorSettings()) {
            toReturn = toReturn + "GovernorSettings: " + this.governorSettings + separator + two.getGovernorSettings() + lineReturn;
        }
        if (this.manageCitizens != two.getManageCitizens()) {
            toReturn = toReturn + "  ManageCitizens: " + this.manageCitizens + separator + two.getManageCitizens() + lineReturn;
        }
        if (this.emphasizeFood != two.getEmphasizeFood()) {
            toReturn = toReturn + "  EmphasizeFood: " + this.emphasizeFood + separator + two.getEmphasizeFood() + lineReturn;
        }
        if (this.emphasizeShields != two.getEmphasizeShields()) {
            toReturn = toReturn + "  EmphasizeShields: " + this.emphasizeShields + separator + two.getEmphasizeShields() + lineReturn;
        }
        if (this.emphasizeTrade != two.getEmphasizeTrade()) {
            toReturn = toReturn + "  EmphasizeTrade: " + this.emphasizeTrade + separator + two.getEmphasizeTrade() + lineReturn;
        }
        if (this.manageProduction != two.getManageProduction()) {
            toReturn = toReturn + "  ManageProduction: " + this.manageProduction + separator + two.getManageProduction() + lineReturn;
        }
        if (this.noWonders != two.getNoWonders()) {
            toReturn = toReturn + "NoWonders: " + this.noWonders + separator + two.getNoWonders() + lineReturn;
        }
        if (this.noSmallWonders != two.getNoSmallWonders()) {
            toReturn = toReturn + "  NoSmallWonders: " + this.noSmallWonders + separator + two.getNoSmallWonders() + lineReturn;
        }
        if (this.buildNever != two.getBuildNever()) {
            toReturn = toReturn + "BuildNever: " + this.buildNever + separator + two.getBuildNever() + lineReturn;
        }
        if (this.noOffensiveLandUnits != two.getNoOffensiveLandUnits()) {
            toReturn = toReturn + "  NoOffensiveLandUnits: " + this.noOffensiveLandUnits + separator + two.getNoOffensiveLandUnits() + lineReturn;
        }
        if (this.noDefensiveLandUnits != two.getNoDefensiveLandUnits()) {
            toReturn = toReturn + "  NoDefensiveLandUnits: " + this.noDefensiveLandUnits + separator + two.getNoDefensiveLandUnits() + lineReturn;
        }
        if (this.noArtillery != two.getNoArtillery()) {
            toReturn = toReturn + "  NoArtillery: " + this.noArtillery + separator + two.getNoArtillery() + lineReturn;
        }
        if (this.noSettlers != two.getNoSettlers()) {
            toReturn = toReturn + "  NoSettlers: " + this.noSettlers + separator + two.getNoSettlers() + lineReturn;
        }
        if (this.noWorkers != two.getNoWorkers()) {
            toReturn = toReturn + "  NoWorkers: " + this.noWorkers + separator + two.getNoWorkers() + lineReturn;
        }
        if (this.noShips != two.getNoShips()) {
            toReturn = toReturn + "  NoShips: " + this.noShips + separator + two.getNoShips() + lineReturn;
        }
        if (this.noAirUnits != two.getNoAirUnits()) {
            toReturn = toReturn + "  NoAirUnits: " + this.noAirUnits + separator + two.getNoAirUnits() + lineReturn;
        }
        if (this.noGrowth != two.getNoGrowth()) {
            toReturn = toReturn + "  NoGrowth: " + this.noGrowth + separator + two.getNoGrowth() + lineReturn;
        }
        if (this.noProduction != two.getNoProduction()) {
            toReturn = toReturn + "  NoProduction: " + this.noProduction + separator + two.getNoProduction() + lineReturn;
        }
        if (this.noHappiness != two.getNoHappiness()) {
            toReturn = toReturn + "  NoHappiness: " + this.noHappiness + separator + two.getNoHappiness() + lineReturn;
        }
        if (this.noScience != two.getNoScience()) {
            toReturn = toReturn + "  NoScience: " + this.noScience + separator + two.getNoScience() + lineReturn;
        }
        if (this.noWealth != two.getNoWealth()) {
            toReturn = toReturn + "  NoWealth: " + this.noWealth + separator + two.getNoWealth() + lineReturn;
        }
        if (this.noTrade != two.getNoTrade()) {
            toReturn = toReturn + "  NoTrade: " + this.noTrade + separator + two.getNoTrade() + lineReturn;
        }
        if (this.noExploration != two.getNoExploration()) {
            toReturn = toReturn + "  NoExploration: " + this.noExploration + separator + two.getNoExploration() + lineReturn;
        }
        if (this.noCulture != two.getNoCulture()) {
            toReturn = toReturn + "  NoCulture: " + this.noCulture + separator + two.getNoCulture() + lineReturn;
        }
        if (this.buildOften != two.getBuildOften()) {
            toReturn = toReturn + "BuildOften: " + this.buildOften + separator + two.getBuildOften() + lineReturn;
        }
        if (this.manyOffensiveLandUnits != two.getManyOffensiveLandUnits()) {
            toReturn = toReturn + "  ManyOffensiveLandUnits: " + this.manyOffensiveLandUnits + separator + two.getManyOffensiveLandUnits() + lineReturn;
        }
        if (this.manyDefensiveLandUnits != two.getManyDefensiveLandUnits()) {
            toReturn = toReturn + "  ManyDefensiveLandUnits: " + this.manyDefensiveLandUnits + separator + two.getManyDefensiveLandUnits() + lineReturn;
        }
        if (this.manyArtillery != two.getManyArtillery()) {
            toReturn = toReturn + "  ManyArtillery: " + this.manyArtillery + separator + two.getManyArtillery() + lineReturn;
        }
        if (this.manySettlers != two.getManySettlers()) {
            toReturn = toReturn + "  ManySettlers: " + this.manySettlers + separator + two.getManySettlers() + lineReturn;
        }
        if (this.manyWorkers != two.getManyWorkers()) {
            toReturn = toReturn + "  ManyWorkers: " + this.manyWorkers + separator + two.getManyWorkers() + lineReturn;
        }
        if (this.manyShips != two.getManyShips()) {
            toReturn = toReturn + "  ManyShips: " + this.manyShips + separator + two.getManyShips() + lineReturn;
        }
        if (this.manyAirUnits != two.getManyAirUnits()) {
            toReturn = toReturn + "  ManyAirUnits: " + this.manyAirUnits + separator + two.getManyAirUnits() + lineReturn;
        }
        if (this.manyGrowth != two.getManyGrowth()) {
            toReturn = toReturn + "  ManyGrowth: " + this.manyGrowth + separator + two.getManyGrowth() + lineReturn;
        }
        if (this.manyProduction != two.getManyProduction()) {
            toReturn = toReturn + "  ManyProduction: " + this.manyProduction + separator + two.getManyProduction() + lineReturn;
        }
        if (this.manyHappiness != two.getManyHappiness()) {
            toReturn = toReturn + "  ManyHappiness: " + this.manyHappiness + separator + two.getManyHappiness() + lineReturn;
        }
        if (this.manyScience != two.getManyScience()) {
            toReturn = toReturn + "  ManyScience: " + this.manyScience + separator + two.getManyScience() + lineReturn;
        }
        if (this.manyWealth != two.getManyWealth()) {
            toReturn = toReturn + "  ManyWealth: " + this.manyWealth + separator + two.getManyWealth() + lineReturn;
        }
        if (this.manyTrade != two.getManyTrade()) {
            toReturn = toReturn + "  ManyTrade: " + this.manyTrade + separator + two.getManyTrade() + lineReturn;
        }
        if (this.manyExploration != two.getManyExploration()) {
            toReturn = toReturn + "  ManyExploration: " + this.manyExploration + separator + two.getManyExploration() + lineReturn;
        }
        if (this.manyCulture != two.getManyCulture()) {
            toReturn = toReturn + "  ManyCulture: " + this.manyCulture + separator + two.getManyCulture() + lineReturn;
        }
        if (this.plurality != two.getPlurality()) {
            toReturn = toReturn + "Plurality: " + this.plurality + separator + two.getPlurality() + lineReturn;
        }
        if (this.kingUnitInt != two.getKingUnit()) {
            toReturn = toReturn + "KingUnit: " + this.kingUnitInt + separator + two.getKingUnit() + lineReturn;
        }
        if (this.flavors != two.getFlavors()) {
            toReturn = toReturn + "Flavors: " + this.flavors + separator + two.getFlavors() + lineReturn;
        } else {
            for (int i = 0; i < this.numFlavors; ++i) {
                if (this.flavours.get(i) == two.flavours.get(i)) continue;
                toReturn = toReturn + "  flavor " + i + ": " + this.flavours.get(i) + separator + two.flavours.get(i) + lineReturn;
            }
        }
        if (this.questionMark != two.getQuestionMark()) {
            toReturn = toReturn + "QuestionMark: " + this.questionMark + separator + two.getQuestionMark() + lineReturn;
        }
        if (this.diplomacyTextIndex != two.getDiplomacyTextIndex()) {
            toReturn = toReturn + "DiplomacyTextIndex: " + this.diplomacyTextIndex + separator + two.getDiplomacyTextIndex() + lineReturn;
        }
        if (this.numScientificLeaders != two.getNumScientificLeaders()) {
            toReturn = toReturn + "numScientificLeaders: " + this.numScientificLeaders + separator + two.getNumScientificLeaders() + lineReturn;
        }
        if (toReturn.equals("name: " + this.civilizationName + lineReturn)) {
            toReturn = "";
        }
        return toReturn;
    }

    @Override
    public Object getProperty(String string) throws UnsupportedOperationException {
        if (string.equals("Name") || string.equals("CivilizationName")) {
            return this.civilizationName;
        }
        throw new UnsupportedOperationException();
    }
}

