/*
 * Decompiled with CFR 0.152.
 */
package com.civfanatics.civ3.biqFile;

import com.civfanatics.civ3.biqFile.SLOC;
import com.civfanatics.civ3.biqFile.util.LittleEndianDataInputStream;
import java.io.IOException;
import java.util.List;
import org.apache.log4j.Logger;

public class SLOCThread
extends Thread {
    LittleEndianDataInputStream in;
    LittleEndianDataInputStream[] inputArray;
    List<SLOC> startingLocation;
    int numStartingLocations;
    int start;
    Integer cpus;
    Integer returnVal;
    Logger logger = Logger.getLogger(this.getClass());

    public SLOCThread(LittleEndianDataInputStream in, List<SLOC> startingLocation, int numStartingLocations, int start, Integer cpus) {
        this.in = in;
        this.startingLocation = startingLocation;
        this.numStartingLocations = numStartingLocations;
        this.start = start;
        this.cpus = cpus;
    }

    public SLOCThread(LittleEndianDataInputStream[] inputArray, List<SLOC> startingLocation, int numStartingLocations) {
        this.inputArray = inputArray;
        this.startingLocation = startingLocation;
        this.numStartingLocations = numStartingLocations;
    }

    @Override
    public void run() {
        this.multiThreadInputSLOC();
    }

    public Integer getReturnValue() {
        return this.returnVal;
    }

    private void multiThreadInputSLOC() {
        int bytesOfInput = 0;
        try {
            for (int i = this.start; i < this.numStartingLocations; i += this.cpus.intValue()) {
                Integer integer = this.in.readInt();
                bytesOfInput += 4;
                integer = this.in.readInt();
                bytesOfInput += 4;
                this.startingLocation.get(i).setOwnerType(integer);
                integer = this.in.readInt();
                bytesOfInput += 4;
                this.startingLocation.get(i).setOwner(integer);
                integer = this.in.readInt();
                bytesOfInput += 4;
                this.startingLocation.get(i).setX(integer);
                integer = this.in.readInt();
                bytesOfInput += 4;
                this.startingLocation.get(i).setY(integer);
                if (i + this.cpus < this.numStartingLocations) {
                    this.in.skipBytes(20 * (this.cpus - 1));
                    continue;
                }
                int toJump = this.numStartingLocations - 1 - i;
                this.in.skipBytes(20 * toJump);
            }
        }
        catch (IOException e) {
            this.logger.error("IO Exception in SLOCThread", e);
            System.err.println(e + " in SLOCThread");
        }
        this.returnVal = bytesOfInput;
    }
}

