/*
 * Decompiled with CFR 0.152.
 */
package com.civfanatics.civ3.biqFile;

import com.civfanatics.civ3.biqFile.BIQSection;
import com.civfanatics.civ3.biqFile.IO;
import com.civfanatics.civ3.biqFile.civ3Version;
import java.io.Serializable;
import java.util.ArrayList;

public class TECH
extends BIQSection
implements Serializable {
    private int dataLength = 112;
    private String name = "";
    private String civilopediaEntry = "";
    private int cost;
    private int era;
    private int advanceIcon;
    private int x;
    private int y;
    private int prerequisite1Int;
    private int prerequisite2Int;
    private int prerequisite3Int;
    private int prerequisite4Int;
    private TECH prerequisite1;
    private TECH prerequisite2;
    private TECH prerequisite3;
    private TECH prerequisite4;
    private int flags;
    private boolean enablesDiplomats;
    private boolean enablesIrrigationWithoutFreshWater;
    private boolean enablesBridges;
    private boolean disablesFloodPlainDisease;
    private boolean enablesConscription;
    private boolean enablesMobilizationLevels;
    private boolean enablesRecycling;
    private boolean enablesPrecisionBombing;
    private boolean enablesMPP;
    private boolean enablesROP;
    private boolean enablesAlliances;
    private boolean enablesTradeEmbargoes;
    private boolean doublesWealth;
    private boolean enablesSeaTrade;
    private boolean enablesOceanTrade;
    private boolean enablesMapTrading;
    private boolean enablesCommunicationTrading;
    private boolean notRequiredForAdvancement;
    private boolean doublesWorkRate;
    private boolean cannotBeTraded;
    private boolean permitsSacrifice;
    private boolean bonusTech;
    private boolean revealMap;
    private int flavors;
    private int numFlavors;
    private ArrayList<Boolean> flavours;
    private int questionMark = 1;

    public TECH() {
    }

    public TECH(IO baselink) {
        super(baselink);
        if (baselink.version != civ3Version.CONQUESTS) {
            this.dataLength -= 8;
        }
        this.flavours = new ArrayList();
    }

    public TECH(String name, int numFlavors, IO baselink) {
        super(baselink);
        if (baselink.version != civ3Version.CONQUESTS) {
            this.dataLength -= 8;
        }
        this.name = name;
        this.era = -1;
        this.prerequisite1Int = -1;
        this.prerequisite2Int = -1;
        this.prerequisite3Int = -1;
        this.prerequisite4Int = -1;
        this.flavours = new ArrayList();
        for (int i = 0; i < numFlavors; ++i) {
            this.flavours.add(false);
        }
    }

    public TECH clone() {
        TECH other = new TECH(this.baseLink);
        other.name = this.name;
        other.civilopediaEntry = this.civilopediaEntry;
        other.cost = this.cost;
        other.era = this.era;
        other.advanceIcon = this.advanceIcon;
        other.x = this.x;
        other.y = this.y;
        other.prerequisite1Int = this.prerequisite1Int;
        other.prerequisite2Int = this.prerequisite2Int;
        other.prerequisite3Int = this.prerequisite3Int;
        other.prerequisite4Int = this.prerequisite4Int;
        other.prerequisite1 = this.prerequisite1;
        other.prerequisite2 = this.prerequisite2;
        other.prerequisite3 = this.prerequisite3;
        other.prerequisite4 = this.prerequisite4;
        other.flags = this.flags;
        other.flavors = this.flavors;
        other.numFlavors = this.numFlavors;
        other.questionMark = this.questionMark;
        other.extractEnglish(other.numFlavors);
        return other;
    }

    public void trim() {
        this.name = this.name.trim();
        this.civilopediaEntry = this.civilopediaEntry.trim();
    }

    public int getDataLength() {
        return this.dataLength;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getCivilopediaEntry() {
        return this.civilopediaEntry;
    }

    public int getCost() {
        return this.cost;
    }

    public int getEra() {
        return this.era;
    }

    public int getAdvanceIcon() {
        return this.advanceIcon;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getPrerequisite1() {
        return this.prerequisite1Int;
    }

    public int getPrerequisite2() {
        return this.prerequisite2Int;
    }

    public int getPrerequisite3() {
        return this.prerequisite3Int;
    }

    public int getPrerequisite4() {
        return this.prerequisite4Int;
    }

    public int getFlags() {
        return this.flags;
    }

    public int getFlavors() {
        return this.flavors;
    }

    public int getQuestionMark() {
        return this.questionMark;
    }

    public boolean getEnablesDiplomats() {
        return this.enablesDiplomats;
    }

    public boolean getEnablesIrrigationWithoutFreshWater() {
        return this.enablesIrrigationWithoutFreshWater;
    }

    public boolean getEnablesBridges() {
        return this.enablesBridges;
    }

    public boolean getDisablesFloodPlainDisease() {
        return this.disablesFloodPlainDisease;
    }

    public boolean getEnablesConscription() {
        return this.enablesConscription;
    }

    public boolean getEnablesMobilizationLevels() {
        return this.enablesMobilizationLevels;
    }

    public boolean getEnablesRecycling() {
        return this.enablesRecycling;
    }

    public boolean getEnablesPrecisionBombing() {
        return this.enablesPrecisionBombing;
    }

    public boolean getEnablesMPP() {
        return this.enablesMPP;
    }

    public boolean getEnablesROP() {
        return this.enablesROP;
    }

    public boolean getEnablesAlliances() {
        return this.enablesAlliances;
    }

    public boolean getEnablesTradeEmbargoes() {
        return this.enablesTradeEmbargoes;
    }

    public boolean getDoublesWealth() {
        return this.doublesWealth;
    }

    public boolean getEnablesSeaTrade() {
        return this.enablesSeaTrade;
    }

    public boolean getEnablesOceanTrade() {
        return this.enablesOceanTrade;
    }

    public boolean getEnablesMapTrading() {
        return this.enablesMapTrading;
    }

    public boolean getEnablesCommunicationTrading() {
        return this.enablesCommunicationTrading;
    }

    public boolean getNotRequiredForAdvancement() {
        return this.notRequiredForAdvancement;
    }

    public boolean getDoublesWorkRate() {
        return this.doublesWorkRate;
    }

    public boolean getCannotBeTraded() {
        return this.cannotBeTraded;
    }

    public boolean getPermitsSacrifice() {
        return this.permitsSacrifice;
    }

    public boolean getBonusTech() {
        return this.bonusTech;
    }

    public boolean getRevealMap() {
        return this.revealMap;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setCivilopediaEntry(String civilopediaEntry) {
        this.civilopediaEntry = civilopediaEntry;
    }

    public void setCost(int cost) {
        this.cost = cost;
    }

    public void setEra(int era) {
        this.era = era;
    }

    public void setAdvanceIcon(int advanceIcon) {
        this.advanceIcon = advanceIcon;
    }

    public void setX(int x) {
        this.x = x;
    }

    public void setY(int y) {
        this.y = y;
    }

    void refreshPrerequisites() {
        this.setPrerequisite1(this.prerequisite1Int);
        this.setPrerequisite2(this.prerequisite2Int);
        this.setPrerequisite3(this.prerequisite3Int);
        this.setPrerequisite4(this.prerequisite4Int);
    }

    public void setPrerequisite1(int prerequisite1) {
        this.prerequisite1Int = prerequisite1;
        if (this.baseLink.technology != null && this.prerequisite1Int != -1 && this.baseLink.technology.size() > this.prerequisite1Int) {
            this.prerequisite1 = this.baseLink.technology.get(this.prerequisite1Int);
        }
    }

    public void setPrerequisite2(int prerequisite2) {
        this.prerequisite2Int = prerequisite2;
        if (this.baseLink.technology != null && this.prerequisite2Int != -1 && this.baseLink.technology.size() > this.prerequisite2Int) {
            this.prerequisite2 = this.baseLink.technology.get(this.prerequisite2Int);
        }
    }

    public void setPrerequisite3(int prerequisite3) {
        this.prerequisite3Int = prerequisite3;
        if (this.baseLink.technology != null && this.prerequisite3Int != -1 && this.baseLink.technology.size() > this.prerequisite3Int) {
            this.prerequisite3 = this.baseLink.technology.get(this.prerequisite3Int);
        }
    }

    public void setPrerequisite4(int prerequisite4) {
        this.prerequisite4Int = prerequisite4;
        if (this.baseLink.technology != null && this.prerequisite4Int != -1 && this.baseLink.technology.size() > this.prerequisite4Int) {
            this.prerequisite4 = this.baseLink.technology.get(this.prerequisite4Int);
        }
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    public void setFlavors(int flavors) {
        this.flavors = flavors;
    }

    public void setQuestionMark(int questionMark) {
        this.questionMark = questionMark;
    }

    public void setEnablesDiplomats(boolean enablesDiplomats) {
        this.enablesDiplomats = enablesDiplomats;
    }

    public void setEnablesIrrigationWithoutFreshWater(boolean enablesIrrigationWithoutFreshWater) {
        this.enablesIrrigationWithoutFreshWater = enablesIrrigationWithoutFreshWater;
    }

    public void setEnablesBridges(boolean enablesBridges) {
        this.enablesBridges = enablesBridges;
    }

    public void setDisablesFloodPlainDisease(boolean disablesFloodPlainDisease) {
        this.disablesFloodPlainDisease = disablesFloodPlainDisease;
    }

    public void setEnablesConscription(boolean enablesConscription) {
        this.enablesConscription = enablesConscription;
    }

    public void setEnablesMobilizationLevels(boolean enablesMobilizationLevels) {
        this.enablesMobilizationLevels = enablesMobilizationLevels;
    }

    public void setEnablesRecycling(boolean enablesRecycling) {
        this.enablesRecycling = enablesRecycling;
    }

    public void setEnablesPrecisionBombing(boolean enablesPrecisionBombing) {
        this.enablesPrecisionBombing = enablesPrecisionBombing;
    }

    public void setEnablesMPP(boolean enablesMPP) {
        this.enablesMPP = enablesMPP;
    }

    public void setEnablesROP(boolean enablesROP) {
        this.enablesROP = enablesROP;
    }

    public void setEnablesAlliances(boolean enablesAlliances) {
        this.enablesAlliances = enablesAlliances;
    }

    public void setEnablesTradeEmbargoes(boolean enablesTradeEmbargoes) {
        this.enablesTradeEmbargoes = enablesTradeEmbargoes;
    }

    public void setDoublesWealth(boolean doublesWealth) {
        this.doublesWealth = doublesWealth;
    }

    public void setEnablesSeaTrade(boolean enablesSeaTrade) {
        this.enablesSeaTrade = enablesSeaTrade;
    }

    public void setEnablesOceanTrade(boolean enablesOceanTrade) {
        this.enablesOceanTrade = enablesOceanTrade;
    }

    public void setEnablesMapTrading(boolean enablesMapTrading) {
        this.enablesMapTrading = enablesMapTrading;
    }

    public void setEnablesCommunicationTrading(boolean enablesCommunicationTrading) {
        this.enablesCommunicationTrading = enablesCommunicationTrading;
    }

    public void setNotRequiredForAdvancement(boolean notRequiredForAdvancement) {
        this.notRequiredForAdvancement = notRequiredForAdvancement;
    }

    public void setDoublesWorkRate(boolean doublesWorkRate) {
        this.doublesWorkRate = doublesWorkRate;
    }

    public void setCannotBeTraded(boolean cannotBeTraded) {
        this.cannotBeTraded = cannotBeTraded;
    }

    public void setPermitsSacrifice(boolean permitsSacrifice) {
        this.permitsSacrifice = permitsSacrifice;
    }

    public void setBonusTech(boolean bonusTech) {
        this.bonusTech = bonusTech;
    }

    public void setRevealMap(boolean revealMap) {
        this.revealMap = revealMap;
    }

    public int getNumFlavours() {
        return this.flavours.size();
    }

    public void setFlavour(int index, boolean value) {
        this.flavours.set(index, value);
    }

    public boolean getFlavour(int index) {
        return this.flavours.get(index);
    }

    public void handleAddedFlavour() {
        this.flavours.add(false);
        ++this.numFlavors;
    }

    public void handleDeletedFlavour(int index) {
        this.flavours.remove(index);
        --this.numFlavors;
        this.createBinary();
    }

    public void handleDeletedTechnology(int deletedTechIndex) {
        if (this.prerequisite1Int == deletedTechIndex) {
            this.prerequisite1Int = -1;
            this.prerequisite1 = null;
        } else if (this.prerequisite1Int > deletedTechIndex) {
            --this.prerequisite1Int;
        }
        if (this.prerequisite2Int == deletedTechIndex) {
            this.prerequisite2Int = -1;
            this.prerequisite2 = null;
        } else if (this.prerequisite2Int > deletedTechIndex) {
            --this.prerequisite2Int;
        }
        if (this.prerequisite3Int == deletedTechIndex) {
            this.prerequisite3Int = -1;
            this.prerequisite3 = null;
        } else if (this.prerequisite3Int > deletedTechIndex) {
            --this.prerequisite3Int;
        }
        if (this.prerequisite4Int == deletedTechIndex) {
            this.prerequisite4Int = -1;
            this.prerequisite4 = null;
        } else if (this.prerequisite4Int > deletedTechIndex) {
            --this.prerequisite4Int;
        }
        if (this.index > deletedTechIndex) {
            --this.index;
        } else if (this.index == deletedTechIndex) {
            this.index = -1;
        }
    }

    public void handleSwappedTech() {
        if (this.prerequisite1Int != -1) {
            this.prerequisite1Int = this.prerequisite1.getIndex();
        }
        if (this.prerequisite2Int != -1) {
            this.prerequisite2Int = this.prerequisite2.getIndex();
        }
        if (this.prerequisite3Int != -1) {
            this.prerequisite3Int = this.prerequisite3.getIndex();
        }
        if (this.prerequisite4Int != -1) {
            this.prerequisite4Int = this.prerequisite4.getIndex();
        }
    }

    public void convertFromPTWToConquests() {
        this.dataLength += 8;
    }

    public void extractEnglish(int numFlavours) {
        int i;
        int flagCopy = this.flags;
        int divBy = 0;
        divBy = flagCopy / (int)Math.pow(2.0, 22.0);
        if (divBy == 1) {
            this.revealMap = true;
            flagCopy -= 0x400000;
        }
        if ((divBy = flagCopy / (int)Math.pow(2.0, 21.0)) == 1) {
            this.bonusTech = true;
            flagCopy -= 0x200000;
        }
        if ((divBy = flagCopy / (int)Math.pow(2.0, 20.0)) == 1) {
            this.permitsSacrifice = true;
            flagCopy -= 0x100000;
        }
        if ((divBy = flagCopy / (int)Math.pow(2.0, 19.0)) == 1) {
            this.cannotBeTraded = true;
            flagCopy -= 524288;
        }
        if ((divBy = flagCopy / (int)Math.pow(2.0, 18.0)) == 1) {
            this.doublesWorkRate = true;
            flagCopy -= 262144;
        }
        if ((divBy = flagCopy / (int)Math.pow(2.0, 17.0)) == 1) {
            this.notRequiredForAdvancement = true;
            flagCopy -= 131072;
        }
        if ((divBy = flagCopy / (int)Math.pow(2.0, 16.0)) == 1) {
            this.enablesCommunicationTrading = true;
            flagCopy -= 65536;
        }
        if ((divBy = flagCopy / (int)Math.pow(2.0, 15.0)) == 1) {
            this.enablesMapTrading = true;
            flagCopy -= 32768;
        }
        if ((divBy = flagCopy / (int)Math.pow(2.0, 14.0)) == 1) {
            this.enablesOceanTrade = true;
            flagCopy -= 16384;
        }
        if ((divBy = flagCopy / (int)Math.pow(2.0, 13.0)) == 1) {
            this.enablesSeaTrade = true;
            flagCopy -= 8192;
        }
        if ((divBy = flagCopy / (int)Math.pow(2.0, 12.0)) == 1) {
            this.doublesWealth = true;
            flagCopy -= 4096;
        }
        if ((divBy = flagCopy / (int)Math.pow(2.0, 11.0)) == 1) {
            this.enablesTradeEmbargoes = true;
            flagCopy -= 2048;
        }
        if ((divBy = flagCopy / (int)Math.pow(2.0, 10.0)) == 1) {
            this.enablesAlliances = true;
            flagCopy -= 1024;
        }
        if ((divBy = flagCopy / (int)Math.pow(2.0, 9.0)) == 1) {
            this.enablesROP = true;
            flagCopy -= 512;
        }
        if ((divBy = flagCopy / (int)Math.pow(2.0, 8.0)) == 1) {
            this.enablesMPP = true;
            flagCopy -= 256;
        }
        if ((divBy = flagCopy / (int)Math.pow(2.0, 7.0)) == 1) {
            this.enablesPrecisionBombing = true;
            flagCopy -= 128;
        }
        if ((divBy = flagCopy / (int)Math.pow(2.0, 6.0)) == 1) {
            this.enablesRecycling = true;
            flagCopy -= 64;
        }
        if ((divBy = flagCopy / (int)Math.pow(2.0, 5.0)) == 1) {
            this.enablesMobilizationLevels = true;
            flagCopy -= 32;
        }
        if ((divBy = flagCopy / (int)Math.pow(2.0, 4.0)) == 1) {
            this.enablesConscription = true;
            flagCopy -= 16;
        }
        if ((divBy = flagCopy / (int)Math.pow(2.0, 3.0)) == 1) {
            this.disablesFloodPlainDisease = true;
            flagCopy -= 8;
        }
        if ((divBy = flagCopy / (int)Math.pow(2.0, 2.0)) == 1) {
            this.enablesBridges = true;
            flagCopy -= 4;
        }
        if ((divBy = flagCopy / (int)Math.pow(2.0, 1.0)) == 1) {
            this.enablesIrrigationWithoutFreshWater = true;
            flagCopy -= 2;
        }
        if ((divBy = flagCopy / (int)Math.pow(2.0, 0.0)) == 1) {
            this.enablesDiplomats = true;
            --flagCopy;
        }
        int flavorCopy = this.flavors;
        for (i = 0; i < numFlavours; ++i) {
            this.flavours.add(false);
        }
        for (i = numFlavours - 1; i > -1; --i) {
            divBy = flavorCopy / (int)Math.pow(2.0, i);
            if (divBy != 1) continue;
            this.flavours.set(i, true);
            flavorCopy = (int)((double)flavorCopy - Math.pow(2.0, i));
        }
        this.numFlavors = numFlavours;
    }

    public void createBinary() {
        long sum = 0L;
        if (this.enablesDiplomats) {
            ++sum;
        }
        if (this.enablesIrrigationWithoutFreshWater) {
            sum += 2L;
        }
        if (this.enablesBridges) {
            sum += 4L;
        }
        if (this.disablesFloodPlainDisease) {
            sum += 8L;
        }
        if (this.enablesConscription) {
            sum += 16L;
        }
        if (this.enablesMobilizationLevels) {
            sum += 32L;
        }
        if (this.enablesRecycling) {
            sum += 64L;
        }
        if (this.enablesPrecisionBombing) {
            sum += 128L;
        }
        if (this.enablesMPP) {
            sum += 256L;
        }
        if (this.enablesROP) {
            sum += 512L;
        }
        if (this.enablesAlliances) {
            sum += 1024L;
        }
        if (this.enablesTradeEmbargoes) {
            sum += 2048L;
        }
        if (this.doublesWealth) {
            sum += 4096L;
        }
        if (this.enablesSeaTrade) {
            sum += 8192L;
        }
        if (this.enablesOceanTrade) {
            sum += 16384L;
        }
        if (this.enablesMapTrading) {
            sum += 32768L;
        }
        if (this.enablesCommunicationTrading) {
            sum += 65536L;
        }
        if (this.notRequiredForAdvancement) {
            sum += 131072L;
        }
        if (this.doublesWorkRate) {
            sum += 262144L;
        }
        if (this.cannotBeTraded) {
            sum += 524288L;
        }
        if (this.permitsSacrifice) {
            sum += 0x100000L;
        }
        if (this.bonusTech) {
            sum += 0x200000L;
        }
        if (this.revealMap) {
            sum += 0x400000L;
        }
        this.flags = (int)sum;
        sum = 0L;
        for (int i = 0; i < this.flavours.size(); ++i) {
            if (!this.flavours.get(i).booleanValue()) continue;
            sum += (long)((int)Math.pow(2.0, i));
        }
        this.flavors = (int)sum;
    }

    @Override
    public String toString() {
        String lineReturn = System.getProperty("line.separator");
        String toReturn = "name: " + this.name + lineReturn;
        toReturn = toReturn + "index: " + this.index + lineReturn;
        toReturn = toReturn + "civilopediaEntry: " + this.civilopediaEntry + lineReturn;
        toReturn = toReturn + "dataLength: " + this.dataLength + lineReturn;
        toReturn = toReturn + "cost: " + this.cost + lineReturn;
        toReturn = toReturn + "era: " + this.era + lineReturn;
        toReturn = toReturn + "advanceIcon: " + this.advanceIcon + lineReturn;
        toReturn = toReturn + "x: " + this.x + lineReturn;
        toReturn = toReturn + "y: " + this.y + lineReturn;
        toReturn = toReturn + "prerequisite1: " + this.prerequisite1Int + lineReturn;
        toReturn = toReturn + "prerequisite2: " + this.prerequisite2Int + lineReturn;
        toReturn = toReturn + "prerequisite3: " + this.prerequisite3Int + lineReturn;
        toReturn = toReturn + "prerequisite4: " + this.prerequisite4Int + lineReturn;
        toReturn = toReturn + "flags: " + this.flags + lineReturn;
        toReturn = toReturn + "flavors: " + this.flavors + lineReturn;
        toReturn = toReturn + "questionMark: " + this.questionMark + lineReturn;
        toReturn = toReturn + lineReturn;
        return toReturn;
    }

    @Override
    public String toEnglish() {
        String lineReturn = System.getProperty("line.separator");
        String toReturn = "name: " + this.name + lineReturn;
        toReturn = toReturn + "index: " + this.index + lineReturn;
        toReturn = toReturn + "civilopediaEntry: " + this.civilopediaEntry + lineReturn;
        toReturn = toReturn + "dataLength: " + this.dataLength + lineReturn;
        toReturn = toReturn + "cost: " + this.cost + lineReturn;
        toReturn = toReturn + "era: " + this.era + lineReturn;
        toReturn = toReturn + "advanceIcon: " + this.advanceIcon + lineReturn;
        toReturn = toReturn + "x: " + this.x + lineReturn;
        toReturn = toReturn + "y: " + this.y + lineReturn;
        String prereq1Eng = this.prerequisite1Int == -1 ? "None" : this.baseLink.technology.get(this.prerequisite1Int).getName();
        String prereq2Eng = this.prerequisite2Int == -1 ? "None" : this.baseLink.technology.get(this.prerequisite2Int).getName();
        String prereq3Eng = this.prerequisite3Int == -1 ? "None" : this.baseLink.technology.get(this.prerequisite3Int).getName();
        String prereq4Eng = this.prerequisite4Int == -1 ? "None" : this.baseLink.technology.get(this.prerequisite4Int).getName();
        toReturn = toReturn + "prerequisite1: " + prereq1Eng + lineReturn;
        toReturn = toReturn + "prerequisite2: " + prereq2Eng + lineReturn;
        toReturn = toReturn + "prerequisite3: " + prereq3Eng + lineReturn;
        toReturn = toReturn + "prerequisite4: " + prereq4Eng + lineReturn;
        toReturn = toReturn + "flags: " + this.flags + lineReturn;
        toReturn = toReturn + "  enablesDiplomats: " + this.enablesDiplomats + lineReturn;
        toReturn = toReturn + "  enablesIrrigationWithoutFreshWater: " + this.enablesIrrigationWithoutFreshWater + lineReturn;
        toReturn = toReturn + "  enablesBridges: " + this.enablesBridges + lineReturn;
        toReturn = toReturn + "  disablesFloodPlainDisease: " + this.disablesFloodPlainDisease + lineReturn;
        toReturn = toReturn + "  enablesConscription: " + this.enablesConscription + lineReturn;
        toReturn = toReturn + "  enablesMobilizationLevels: " + this.enablesMobilizationLevels + lineReturn;
        toReturn = toReturn + "  enablesRecycling: " + this.enablesRecycling + lineReturn;
        toReturn = toReturn + "  enablesPrecisionBombing: " + this.enablesPrecisionBombing + lineReturn;
        toReturn = toReturn + "  enablesMPP: " + this.enablesMPP + lineReturn;
        toReturn = toReturn + "  enablesROP: " + this.enablesROP + lineReturn;
        toReturn = toReturn + "  enablesAlliances: " + this.enablesAlliances + lineReturn;
        toReturn = toReturn + "  enablesTradeEmbargoes: " + this.enablesTradeEmbargoes + lineReturn;
        toReturn = toReturn + "  doublesWealth: " + this.doublesWealth + lineReturn;
        toReturn = toReturn + "  enablesSeaTrade: " + this.enablesSeaTrade + lineReturn;
        toReturn = toReturn + "  enablesOceanTrade: " + this.enablesOceanTrade + lineReturn;
        toReturn = toReturn + "  enablesMapTrading: " + this.enablesMapTrading + lineReturn;
        toReturn = toReturn + "  enablesCommunicationTrading: " + this.enablesCommunicationTrading + lineReturn;
        toReturn = toReturn + "  notRequiredForAdvancement: " + this.notRequiredForAdvancement + lineReturn;
        toReturn = toReturn + "  doublesWorkRate: " + this.doublesWorkRate + lineReturn;
        toReturn = toReturn + "  cannotBeTraded: " + this.cannotBeTraded + lineReturn;
        toReturn = toReturn + "  permitsSacrifice: " + this.permitsSacrifice + lineReturn;
        toReturn = toReturn + "  bonusTech: " + this.bonusTech + lineReturn;
        toReturn = toReturn + "  revealMap: " + this.revealMap + lineReturn;
        toReturn = toReturn + "flavors: " + this.flavors + lineReturn;
        for (int i = 0; i < this.numFlavors; ++i) {
            toReturn = toReturn + "  flavor " + (i + 1) + ": " + this.flavours.get(i) + lineReturn;
        }
        toReturn = toReturn + lineReturn;
        return toReturn;
    }

    @Override
    public String compareTo(BIQSection section, String separator) {
        if (!(section instanceof TECH)) {
            return null;
        }
        TECH two = (TECH)section;
        String lineReturn = System.getProperty("line.separator");
        String toReturn = "name: " + this.name + lineReturn;
        if (this.dataLength != two.getDataLength()) {
            toReturn = toReturn + "DataLength: " + this.dataLength + separator + two.getDataLength() + lineReturn;
        }
        if (this.index != two.getIndex()) {
            toReturn = "index: " + this.index + separator + two.getIndex() + lineReturn;
        }
        if (this.civilopediaEntry.compareTo(two.getCivilopediaEntry()) != 0) {
            toReturn = toReturn + "CivilopediaEntry: " + this.civilopediaEntry + separator + two.getCivilopediaEntry() + lineReturn;
        }
        if (this.cost != two.getCost()) {
            toReturn = toReturn + "Cost: " + this.cost + separator + two.getCost() + lineReturn;
        }
        if (this.era != two.getEra()) {
            toReturn = toReturn + "Era: " + this.era + separator + two.getEra() + lineReturn;
        }
        if (this.advanceIcon != two.getAdvanceIcon()) {
            toReturn = toReturn + "AdvanceIcon: " + this.advanceIcon + separator + two.getAdvanceIcon() + lineReturn;
        }
        if (this.x != two.getX()) {
            toReturn = toReturn + "X: " + this.x + separator + two.getX() + lineReturn;
        }
        if (this.y != two.getY()) {
            toReturn = toReturn + "Y: " + this.y + separator + two.getY() + lineReturn;
        }
        if (this.prerequisite1Int != two.getPrerequisite1()) {
            toReturn = toReturn + "Prerequisite1: " + this.prerequisite1Int + separator + two.getPrerequisite1() + lineReturn;
        }
        if (this.prerequisite2Int != two.getPrerequisite2()) {
            toReturn = toReturn + "Prerequisite2: " + this.prerequisite2Int + separator + two.getPrerequisite2() + lineReturn;
        }
        if (this.prerequisite3Int != two.getPrerequisite3()) {
            toReturn = toReturn + "Prerequisite3: " + this.prerequisite3Int + separator + two.getPrerequisite3() + lineReturn;
        }
        if (this.prerequisite4Int != two.getPrerequisite4()) {
            toReturn = toReturn + "Prerequisite4: " + this.prerequisite4Int + separator + two.getPrerequisite4() + lineReturn;
        }
        if (this.flags != two.getFlags()) {
            toReturn = toReturn + "Flags: " + this.flags + separator + two.getFlags() + lineReturn;
        }
        if (this.enablesDiplomats != two.getEnablesDiplomats()) {
            toReturn = toReturn + "  EnablesDiplomats: " + this.enablesDiplomats + separator + two.getEnablesDiplomats() + lineReturn;
        }
        if (this.enablesIrrigationWithoutFreshWater != two.getEnablesIrrigationWithoutFreshWater()) {
            toReturn = toReturn + "  EnablesIrrigationWithoutFreshWater: " + this.enablesIrrigationWithoutFreshWater + separator + two.getEnablesIrrigationWithoutFreshWater() + lineReturn;
        }
        if (this.enablesBridges != two.getEnablesBridges()) {
            toReturn = toReturn + "  EnablesBridges: " + this.enablesBridges + separator + two.getEnablesBridges() + lineReturn;
        }
        if (this.disablesFloodPlainDisease != two.getDisablesFloodPlainDisease()) {
            toReturn = toReturn + "  DisablesFloodPlainDisease: " + this.disablesFloodPlainDisease + separator + two.getDisablesFloodPlainDisease() + lineReturn;
        }
        if (this.enablesConscription != two.getEnablesConscription()) {
            toReturn = toReturn + "  EnablesConscription: " + this.enablesConscription + separator + two.getEnablesConscription() + lineReturn;
        }
        if (this.enablesMobilizationLevels != two.getEnablesMobilizationLevels()) {
            toReturn = toReturn + "  EnablesMobilizationLevels: " + this.enablesMobilizationLevels + separator + two.getEnablesMobilizationLevels() + lineReturn;
        }
        if (this.enablesRecycling != two.getEnablesRecycling()) {
            toReturn = toReturn + "  EnablesRecycling: " + this.enablesRecycling + separator + two.getEnablesRecycling() + lineReturn;
        }
        if (this.enablesPrecisionBombing != two.getEnablesPrecisionBombing()) {
            toReturn = toReturn + "  EnablesPrecisionBombing: " + this.enablesPrecisionBombing + separator + two.getEnablesPrecisionBombing() + lineReturn;
        }
        if (this.enablesMPP != two.getEnablesMPP()) {
            toReturn = toReturn + "  EnablesMPP: " + this.enablesMPP + separator + two.getEnablesMPP() + lineReturn;
        }
        if (this.enablesROP != two.getEnablesROP()) {
            toReturn = toReturn + "  EnablesROP: " + this.enablesROP + separator + two.getEnablesROP() + lineReturn;
        }
        if (this.enablesAlliances != two.getEnablesAlliances()) {
            toReturn = toReturn + "  EnablesAlliances: " + this.enablesAlliances + separator + two.getEnablesAlliances() + lineReturn;
        }
        if (this.enablesTradeEmbargoes != two.getEnablesTradeEmbargoes()) {
            toReturn = toReturn + "  EnablesTradeEmbargoes: " + this.enablesTradeEmbargoes + separator + two.getEnablesTradeEmbargoes() + lineReturn;
        }
        if (this.doublesWealth != two.getDoublesWealth()) {
            toReturn = toReturn + "  DoublesWealth: " + this.doublesWealth + separator + two.getDoublesWealth() + lineReturn;
        }
        if (this.enablesSeaTrade != two.getEnablesSeaTrade()) {
            toReturn = toReturn + "  EnablesSeaTrade: " + this.enablesSeaTrade + separator + two.getEnablesSeaTrade() + lineReturn;
        }
        if (this.enablesOceanTrade != two.getEnablesOceanTrade()) {
            toReturn = toReturn + "  EnablesOceanTrade: " + this.enablesOceanTrade + separator + two.getEnablesOceanTrade() + lineReturn;
        }
        if (this.enablesMapTrading != two.getEnablesMapTrading()) {
            toReturn = toReturn + "  EnablesMapTrading: " + this.enablesMapTrading + separator + two.getEnablesMapTrading() + lineReturn;
        }
        if (this.enablesCommunicationTrading != two.getEnablesCommunicationTrading()) {
            toReturn = toReturn + "  EnablesCommunicationTrading: " + this.enablesCommunicationTrading + separator + two.getEnablesCommunicationTrading() + lineReturn;
        }
        if (this.notRequiredForAdvancement != two.getNotRequiredForAdvancement()) {
            toReturn = toReturn + "  NotRequiredForAdvancement: " + this.notRequiredForAdvancement + separator + two.getNotRequiredForAdvancement() + lineReturn;
        }
        if (this.doublesWorkRate != two.getDoublesWorkRate()) {
            toReturn = toReturn + "  DoublesWorkRate: " + this.doublesWorkRate + separator + two.getDoublesWorkRate() + lineReturn;
        }
        if (this.cannotBeTraded != two.getCannotBeTraded()) {
            toReturn = toReturn + "  CannotBeTraded: " + this.cannotBeTraded + separator + two.getCannotBeTraded() + lineReturn;
        }
        if (this.permitsSacrifice != two.getPermitsSacrifice()) {
            toReturn = toReturn + "  PermitsSacrifice: " + this.permitsSacrifice + separator + two.getPermitsSacrifice() + lineReturn;
        }
        if (this.bonusTech != two.getBonusTech()) {
            toReturn = toReturn + "  BonusTech: " + this.bonusTech + separator + two.getBonusTech() + lineReturn;
        }
        if (this.revealMap != two.getRevealMap()) {
            toReturn = toReturn + "  RevealMap: " + this.revealMap + separator + two.getRevealMap() + lineReturn;
        }
        if (this.flavors != two.getFlavors()) {
            toReturn = toReturn + "Flavors: " + this.flavors + separator + two.getFlavors() + lineReturn;
        } else {
            for (int i = 0; i < this.numFlavors; ++i) {
                if (this.flavours.get(i) == two.flavours.get(i)) continue;
                toReturn = toReturn + "  flavor " + i + ": " + this.flavours.get(i) + separator + two.flavours.get(i) + lineReturn;
            }
        }
        if (this.questionMark != two.getQuestionMark()) {
            toReturn = toReturn + "QuestionMark: " + this.questionMark + separator + two.getQuestionMark() + lineReturn;
        }
        if (toReturn.equals("name: " + this.name + lineReturn)) {
            toReturn = "";
        }
        return toReturn;
    }

    @Override
    public Object getProperty(String string) throws UnsupportedOperationException {
        if (string.equals("Name")) {
            return this.name;
        }
        throw new UnsupportedOperationException();
    }

    public int getNumFlavors() {
        return this.numFlavors;
    }

    public void setNumFlavors(int numFlavors) {
        this.numFlavors = numFlavors;
    }

    public ArrayList<Boolean> getFlavours() {
        return this.flavours;
    }

    public void setFlavours(ArrayList<Boolean> flavours) {
        this.flavours = flavours;
    }
}

