/*
 * Decompiled with CFR 0.152.
 */
package com.civfanatics.civ3.biqFile;

import com.civfanatics.civ3.biqFile.BIQSection;
import com.civfanatics.civ3.biqFile.IO;
import com.civfanatics.civ3.biqFile.civ3Version;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class TERR
extends BIQSection {
    Logger logger = Logger.getLogger(this.getClass());
    public int dataLength;
    public int numPossibleResources;
    public ArrayList<Byte> possibleResources;
    public ArrayList<Boolean> allowedResources;
    public String name = "";
    public String civilopediaEntry = "";
    public int foodBonus;
    public int shieldsBonus;
    public int commerceBonus;
    public int defenceBonus;
    public int movementCost;
    public int food;
    public int shields;
    public int commerce;
    public int workerJob;
    public int pollutionEffect;
    byte allowCities;
    byte allowColonies;
    byte impassable;
    byte impassableByWheeled;
    byte allowAirfields;
    byte allowForts;
    byte allowOutposts;
    byte allowRadarTowers;
    public int questionMark;
    byte landmarkEnabled;
    public int landmarkFood;
    public int landmarkShields;
    public int landmarkCommerce;
    public int landmarkFoodBonus;
    public int landmarkShieldsBonus;
    public int landmarkCommerceBonus;
    public int landmarkMovementCost;
    public int landmarkDefenceBonus;
    public String landmarkName = "";
    public String landmarkCivilopediaEntry = "";
    public int questionMark2;
    public int terrainFlags;
    public boolean causesDisease;
    public boolean diseaseCanBeCured;
    public int diseaseStrength;
    IO baselink;
    public static final byte DESERT = 0;
    public static final byte PLAINS = 1;
    public static final byte GRASSLAND = 2;
    public static final byte TUNDRA = 3;
    public static final byte FLOODPLAIN = 4;
    public static final byte HILLS = 5;
    public static final byte MOUNTAIN = 6;
    public static final byte FOREST = 7;
    public static final byte JUNGLE = 8;
    public static final byte MARSH = 9;
    public static final byte VOLCANO = 10;
    public static final byte COAST = 11;
    public static final byte SEA = 12;
    public static final byte OCEAN = 13;

    public TERR(IO baselink) {
        super(baselink);
        this.baselink = baselink;
        this.possibleResources = new ArrayList();
        this.allowedResources = new ArrayList();
    }

    public void trim() {
        this.name = this.name.trim();
        this.civilopediaEntry = this.civilopediaEntry.trim();
        if (this.baselink.version == civ3Version.CONQUESTS) {
            int civilopediaLength;
            int lmLength = this.landmarkName.length();
            if (this.landmarkName.charAt(lmLength - 1) == '\u00cc') {
                this.landmarkName = this.landmarkName.substring(0, 31);
            }
            if (this.landmarkCivilopediaEntry.charAt((civilopediaLength = this.landmarkCivilopediaEntry.length()) - 1) == '\u00cc') {
                this.landmarkCivilopediaEntry = this.landmarkCivilopediaEntry.substring(0, 31);
            }
            this.landmarkName = this.landmarkName.trim();
            this.landmarkCivilopediaEntry = this.landmarkCivilopediaEntry.trim();
        }
    }

    public void extractEnglish() {
        int terrainCopy = this.terrainFlags >>> 26;
        this.causesDisease = terrainCopy % 2 == 0;
        terrainCopy = this.terrainFlags >>> 27;
        this.diseaseCanBeCured = terrainCopy % 2 == 0;
    }

    public int getDataLength() {
        return this.dataLength;
    }

    public int getNumPossibleResources() {
        return this.numPossibleResources;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getCivilopediaEntry() {
        return this.civilopediaEntry;
    }

    public int getFoodBonus() {
        return this.foodBonus;
    }

    public int getShieldsBonus() {
        return this.shieldsBonus;
    }

    public int getCommerceBonus() {
        return this.commerceBonus;
    }

    public int getDefenceBonus() {
        return this.defenceBonus;
    }

    public int getMovementCost() {
        return this.movementCost;
    }

    public int getFood() {
        return this.food;
    }

    public int getShields() {
        return this.shields;
    }

    public int getCommerce() {
        return this.commerce;
    }

    public int getWorkerJob() {
        return this.workerJob;
    }

    public int getPollutionEffect() {
        return this.pollutionEffect;
    }

    public byte getAllowCities() {
        return this.allowCities;
    }

    public boolean allowsColonies() {
        return this.allowColonies == 1;
    }

    public byte getAllowColonies() {
        return this.allowColonies;
    }

    public byte getImpassable() {
        return this.impassable;
    }

    public byte getImpassableByWheeled() {
        return this.impassableByWheeled;
    }

    public boolean allowsAirfields() {
        return this.allowAirfields == 1;
    }

    public byte getAllowAirfields() {
        return this.allowAirfields;
    }

    public byte getAllowForts() {
        return this.allowForts;
    }

    public boolean allowsOutposts() {
        return this.allowOutposts == 1;
    }

    public byte getAllowOutposts() {
        return this.allowOutposts;
    }

    public boolean allowsRadarTowers() {
        return this.allowRadarTowers == 1;
    }

    public byte getAllowRadarTowers() {
        return this.allowRadarTowers;
    }

    public int getQuestionMark() {
        return this.questionMark;
    }

    public byte getLandmarkEnabled() {
        return this.landmarkEnabled;
    }

    public int getLandmarkFood() {
        return this.landmarkFood;
    }

    public int getLandmarkShields() {
        return this.landmarkShields;
    }

    public int getLandmarkCommerce() {
        return this.landmarkCommerce;
    }

    public int getLandmarkFoodBonus() {
        return this.landmarkFoodBonus;
    }

    public int getLandmarkShieldsBonus() {
        return this.landmarkShieldsBonus;
    }

    public int getLandmarkCommerceBonus() {
        return this.landmarkCommerceBonus;
    }

    public int getLandmarkMovementCost() {
        return this.landmarkMovementCost;
    }

    public int getLandmarkDefenceBonus() {
        return this.landmarkDefenceBonus;
    }

    public String getLandmarkName() {
        return this.landmarkName;
    }

    public String getLandmarkCivilopediaEntry() {
        return this.landmarkCivilopediaEntry;
    }

    public int getQuestionMark2() {
        return this.questionMark2;
    }

    public int getTerrainFlags() {
        return this.terrainFlags;
    }

    public int getDiseaseStrength() {
        return this.diseaseStrength;
    }

    public void setDataLength(int dataLength) {
        this.dataLength = dataLength;
    }

    public void setNumTotalResources(int numPossibleResources) {
        this.numPossibleResources = numPossibleResources;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setCivilopediaEntry(String civilopediaEntry) {
        this.civilopediaEntry = civilopediaEntry;
    }

    public void setFoodBonus(int foodBonus) {
        this.foodBonus = foodBonus;
    }

    public void setShieldsBonus(int shieldsBonus) {
        this.shieldsBonus = shieldsBonus;
    }

    public void setCommerceBonus(int commerceBonus) {
        this.commerceBonus = commerceBonus;
    }

    public void setDefenceBonus(int defenceBonus) {
        this.defenceBonus = defenceBonus;
    }

    public void setMovementCost(int movementCost) {
        this.movementCost = movementCost;
    }

    public void setFood(int food) {
        this.food = food;
    }

    public void setShields(int shields) {
        this.shields = shields;
    }

    public void setCommerce(int commerce) {
        this.commerce = commerce;
    }

    public void setWorkerJob(int workerJob) {
        this.workerJob = workerJob;
    }

    public void setPollutionEffect(int pollutionEffect) {
        this.pollutionEffect = pollutionEffect;
    }

    public void setAllowCities(byte allowCities) {
        this.allowCities = allowCities;
    }

    public void setAllowColonies(byte allowColonies) {
        this.allowColonies = allowColonies;
    }

    public void setImpassable(byte impassable) {
        this.impassable = impassable;
    }

    public void setImpassableByWheeled(byte impassableByWheeled) {
        this.impassableByWheeled = impassableByWheeled;
    }

    public void setAllowAirfields(byte allowAirfields) {
        this.allowAirfields = allowAirfields;
    }

    public void setAllowForts(byte allowForts) {
        this.allowForts = allowForts;
    }

    public void setAllowOutposts(byte allowOutposts) {
        this.allowOutposts = allowOutposts;
    }

    public void setAllowRadarTowers(byte allowRadarTowers) {
        this.allowRadarTowers = allowRadarTowers;
    }

    public void setQuestionMark(int questionMark) {
        this.questionMark = questionMark;
    }

    public void setLandmarkEnabled(byte landmarkEnabled) {
        this.landmarkEnabled = landmarkEnabled;
    }

    public void setLandmarkFood(int landmarkFood) {
        this.landmarkFood = landmarkFood;
    }

    public void setLandmarkShields(int landmarkShields) {
        this.landmarkShields = landmarkShields;
    }

    public void setLandmarkCommerce(int landmarkCommerce) {
        this.landmarkCommerce = landmarkCommerce;
    }

    public void setLandmarkFoodBonus(int landmarkFoodBonus) {
        this.landmarkFoodBonus = landmarkFoodBonus;
    }

    public void setLandmarkShieldsBonus(int landmarkShieldsBonus) {
        this.landmarkShieldsBonus = landmarkShieldsBonus;
    }

    public void setLandmarkCommerceBonus(int landmarkCommerceBonus) {
        this.landmarkCommerceBonus = landmarkCommerceBonus;
    }

    public void setLandmarkMovementCost(int landmarkMovementCost) {
        this.landmarkMovementCost = landmarkMovementCost;
    }

    public void setLandmarkDefenceBonus(int landmarkDefenceBonus) {
        this.landmarkDefenceBonus = landmarkDefenceBonus;
    }

    public void setLandmarkName(String landmarkName) {
        this.landmarkName = landmarkName;
    }

    public void setLandmarkCivilopediaEntry(String landmarkCivilopediaEntry) {
        this.landmarkCivilopediaEntry = landmarkCivilopediaEntry;
    }

    public void setQuestionMark2(int questionMark2) {
        this.questionMark2 = questionMark2;
    }

    public void setTerrainFlags(int terrainFlags) {
        this.terrainFlags = terrainFlags;
    }

    public void setDiseaseStrength(int diseaseStrength) {
        this.diseaseStrength = diseaseStrength;
    }

    public void simplifyGoods() {
        this.allowedResources.clear();
        int maxVal = this.numPossibleResources;
        int curByte = -1;
        byte tempVal = 0;
        for (int i = 0; i < maxVal; ++i) {
            if (i % 8 == 0) {
                if (i != 0) {
                    this.possibleResources.set(curByte, tempVal);
                }
                curByte = (short)(curByte + 1);
                tempVal = this.possibleResources.get(curByte);
            }
            if (Math.abs(tempVal % 2) == 1) {
                this.allowedResources.add(true);
            } else {
                this.allowedResources.add(false);
            }
            tempVal = (byte)(tempVal >>> 1);
        }
        this.possibleResources.set(curByte, tempVal);
    }

    public void storeGoods() {
        this.possibleResources.clear();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Size of allowed resources: " + this.allowedResources.size());
        }
        for (int i = 0; i < (this.allowedResources.size() - 1) / 8 + 1; ++i) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("Byte: " + i);
            }
            byte temp = 0;
            this.possibleResources.add(temp);
            int bitIndex = 0;
            byte toSet = 0;
            int toAdd = 1;
            if (this.allowedResources.get(i * 8 + bitIndex).booleanValue()) {
                toSet = (byte)(this.possibleResources.get(i) + toAdd);
                this.possibleResources.set(i, toSet);
            }
            toAdd = (byte)(toAdd * 2);
            if (this.numPossibleResources < i * 8 + 1 + ++bitIndex) break;
            if (this.allowedResources.get(i * 8 + bitIndex).booleanValue()) {
                toSet = (byte)(this.possibleResources.get(i) + toAdd);
                this.possibleResources.set(i, toSet);
            }
            toAdd = (byte)(toAdd * 2);
            if (this.numPossibleResources < i * 8 + 1 + ++bitIndex) break;
            if (this.allowedResources.get(i * 8 + bitIndex).booleanValue()) {
                toSet = (byte)(this.possibleResources.get(i) + toAdd);
                this.possibleResources.set(i, toSet);
            }
            toAdd = (byte)(toAdd * 2);
            if (this.numPossibleResources < i * 8 + 1 + ++bitIndex) break;
            if (this.allowedResources.get(i * 8 + bitIndex).booleanValue()) {
                toSet = (byte)(this.possibleResources.get(i) + toAdd);
                this.possibleResources.set(i, toSet);
            }
            toAdd = (byte)(toAdd * 2);
            if (this.numPossibleResources < i * 8 + 1 + ++bitIndex) break;
            if (this.allowedResources.get(i * 8 + bitIndex).booleanValue()) {
                toSet = (byte)(this.possibleResources.get(i) + toAdd);
                this.possibleResources.set(i, toSet);
            }
            toAdd = (byte)(toAdd * 2);
            if (this.numPossibleResources < i * 8 + 1 + ++bitIndex) break;
            if (this.allowedResources.get(i * 8 + bitIndex).booleanValue()) {
                toSet = (byte)(this.possibleResources.get(i) + toAdd);
                this.possibleResources.set(i, toSet);
            }
            toAdd = (byte)(toAdd * 2);
            if (this.numPossibleResources < i * 8 + 1 + ++bitIndex) break;
            if (this.allowedResources.get(i * 8 + bitIndex).booleanValue()) {
                toSet = (byte)(this.possibleResources.get(i) + toAdd);
                this.possibleResources.set(i, toSet);
            }
            toAdd = (byte)(toAdd * 2);
            if (this.numPossibleResources < i * 8 + 1 + ++bitIndex) break;
            if (!this.allowedResources.get(i * 8 + bitIndex).booleanValue()) continue;
            toSet = (byte)(this.possibleResources.get(i) - 128);
            this.possibleResources.set(i, toSet);
        }
    }

    public void handleSwappedGOOD(int source, int dest) {
        boolean oldSourceSelection = this.allowedResources.get(source);
        if (source < dest) {
            for (int i = source; i < dest; ++i) {
                this.allowedResources.set(i, this.allowedResources.get(i + 1));
            }
            this.allowedResources.set(dest, oldSourceSelection);
            this.storeGoods();
        } else {
            for (int i = source; i > dest; --i) {
                this.allowedResources.set(i, this.allowedResources.get(i - 1));
            }
            this.allowedResources.set(dest, oldSourceSelection);
            this.storeGoods();
        }
    }

    @Override
    public String toEnglish() {
        return this.toString();
    }

    @Override
    public String toString() {
        String lineReturn = System.getProperty("line.separator");
        String toReturn = "name: " + this.name + lineReturn;
        toReturn = toReturn + "civilopediaEntry: " + this.civilopediaEntry + lineReturn;
        toReturn = toReturn + "dataLength: " + this.dataLength + lineReturn;
        toReturn = toReturn + "numPossibleResources: " + this.numPossibleResources + lineReturn;
        for (int j = 0; j < (this.numPossibleResources + 7) / 8; ++j) {
            toReturn = toReturn + "  " + this.possibleResources.get(j) + lineReturn;
        }
        toReturn = toReturn + lineReturn;
        toReturn = toReturn + "foodBonus: " + this.foodBonus + lineReturn;
        toReturn = toReturn + "shieldsBonus: " + this.shieldsBonus + lineReturn;
        toReturn = toReturn + "commerceBonus: " + this.commerceBonus + lineReturn;
        toReturn = toReturn + "defenceBonus: " + this.defenceBonus + lineReturn;
        toReturn = toReturn + "movementCost: " + this.movementCost + lineReturn;
        toReturn = toReturn + "food: " + this.food + lineReturn;
        toReturn = toReturn + "shields: " + this.shields + lineReturn;
        toReturn = toReturn + "commerce: " + this.commerce + lineReturn;
        toReturn = toReturn + "workerJob: " + this.workerJob + lineReturn;
        toReturn = toReturn + "pollutionEffect: " + this.pollutionEffect + lineReturn;
        toReturn = toReturn + "allowCities: " + this.allowCities + lineReturn;
        toReturn = toReturn + "allowColonies: " + this.allowColonies + lineReturn;
        toReturn = toReturn + "impassable: " + this.impassable + lineReturn;
        toReturn = toReturn + "impassableByWheeled: " + this.impassableByWheeled + lineReturn;
        toReturn = toReturn + "allowAirfields: " + this.allowAirfields + lineReturn;
        toReturn = toReturn + "allowForts: " + this.allowForts + lineReturn;
        toReturn = toReturn + "allowOutposts: " + this.allowOutposts + lineReturn;
        toReturn = toReturn + "allowRadarTowers: " + this.allowRadarTowers + lineReturn;
        toReturn = toReturn + "questionMark: " + this.questionMark + lineReturn;
        toReturn = toReturn + "landmarkEnabled: " + this.landmarkEnabled + lineReturn;
        toReturn = toReturn + "landmarkFood: " + this.landmarkFood + lineReturn;
        toReturn = toReturn + "landmarkShields: " + this.landmarkShields + lineReturn;
        toReturn = toReturn + "landmarkCommerce: " + this.landmarkCommerce + lineReturn;
        toReturn = toReturn + "landmarkFoodBonus: " + this.landmarkFoodBonus + lineReturn;
        toReturn = toReturn + "landmarkShieldsBonus: " + this.landmarkShieldsBonus + lineReturn;
        toReturn = toReturn + "landmarkCommerceBonus: " + this.landmarkCommerceBonus + lineReturn;
        toReturn = toReturn + "landmarkMovementCost: " + this.landmarkMovementCost + lineReturn;
        toReturn = toReturn + "landmarkDefenceBonus: " + this.landmarkDefenceBonus + lineReturn;
        toReturn = toReturn + "landmarkName: " + this.landmarkName + lineReturn;
        toReturn = toReturn + "landmarkCivilopediaEntry: " + this.landmarkCivilopediaEntry + lineReturn;
        toReturn = toReturn + "questionMark2: " + this.questionMark2 + lineReturn;
        toReturn = toReturn + "terrainFlags: " + this.terrainFlags + lineReturn;
        toReturn = toReturn + "diseaseStrength: " + this.diseaseStrength + lineReturn;
        toReturn = toReturn + lineReturn;
        return toReturn;
    }

    @Override
    public String compareTo(BIQSection section, String separator) {
        if (!(section instanceof TERR)) {
            return null;
        }
        TERR two = (TERR)section;
        String lineReturn = System.getProperty("line.separator");
        String toReturn = "name: " + this.name + lineReturn;
        if (this.dataLength != two.getDataLength()) {
            toReturn = toReturn + "DataLength: " + this.dataLength + separator + two.getDataLength() + lineReturn;
        }
        if (this.numPossibleResources != two.getNumPossibleResources()) {
            toReturn = toReturn + "NumPossibleResources: " + this.numPossibleResources + separator + two.getNumPossibleResources() + lineReturn;
        }
        if (this.civilopediaEntry.compareTo(two.getCivilopediaEntry()) != 0) {
            toReturn = toReturn + "CivilopediaEntry: " + this.civilopediaEntry + separator + two.getCivilopediaEntry() + lineReturn;
        }
        if (this.foodBonus != two.getFoodBonus()) {
            toReturn = toReturn + "FoodBonus: " + this.foodBonus + separator + two.getFoodBonus() + lineReturn;
        }
        if (this.shieldsBonus != two.getShieldsBonus()) {
            toReturn = toReturn + "ShieldsBonus: " + this.shieldsBonus + separator + two.getShieldsBonus() + lineReturn;
        }
        if (this.commerceBonus != two.getCommerceBonus()) {
            toReturn = toReturn + "CommerceBonus: " + this.commerceBonus + separator + two.getCommerceBonus() + lineReturn;
        }
        if (this.defenceBonus != two.getDefenceBonus()) {
            toReturn = toReturn + "DefenceBonus: " + this.defenceBonus + separator + two.getDefenceBonus() + lineReturn;
        }
        if (this.movementCost != two.getMovementCost()) {
            toReturn = toReturn + "MovementCost: " + this.movementCost + separator + two.getMovementCost() + lineReturn;
        }
        if (this.food != two.getFood()) {
            toReturn = toReturn + "Food: " + this.food + separator + two.getFood() + lineReturn;
        }
        if (this.shields != two.getShields()) {
            toReturn = toReturn + "Shields: " + this.shields + separator + two.getShields() + lineReturn;
        }
        if (this.commerce != two.getCommerce()) {
            toReturn = toReturn + "Commerce: " + this.commerce + separator + two.getCommerce() + lineReturn;
        }
        if (this.workerJob != two.getWorkerJob()) {
            toReturn = toReturn + "WorkerJob: " + this.workerJob + separator + two.getWorkerJob() + lineReturn;
        }
        if (this.pollutionEffect != two.getPollutionEffect()) {
            toReturn = toReturn + "PollutionEffect: " + this.pollutionEffect + separator + two.getPollutionEffect() + lineReturn;
        }
        if (this.allowCities != two.getAllowCities()) {
            toReturn = toReturn + "AllowCities: " + this.allowCities + separator + two.getAllowCities() + lineReturn;
        }
        if (this.allowColonies != two.getAllowColonies()) {
            toReturn = toReturn + "AllowColonies: " + this.allowColonies + separator + two.getAllowColonies() + lineReturn;
        }
        if (this.impassable != two.getImpassable()) {
            toReturn = toReturn + "Impassable: " + this.impassable + separator + two.getImpassable() + lineReturn;
        }
        if (this.impassableByWheeled != two.getImpassableByWheeled()) {
            toReturn = toReturn + "ImpassableByWheeled: " + this.impassableByWheeled + separator + two.getImpassableByWheeled() + lineReturn;
        }
        if (this.allowAirfields != two.getAllowAirfields()) {
            toReturn = toReturn + "AllowAirfields: " + this.allowAirfields + separator + two.getAllowAirfields() + lineReturn;
        }
        if (this.allowForts != two.getAllowForts()) {
            toReturn = toReturn + "AllowForts: " + this.allowForts + separator + two.getAllowForts() + lineReturn;
        }
        if (this.allowOutposts != two.getAllowOutposts()) {
            toReturn = toReturn + "AllowOutposts: " + this.allowOutposts + separator + two.getAllowOutposts() + lineReturn;
        }
        if (this.allowRadarTowers != two.getAllowRadarTowers()) {
            toReturn = toReturn + "AllowRadarTowers: " + this.allowRadarTowers + separator + two.getAllowRadarTowers() + lineReturn;
        }
        if (this.questionMark != two.getQuestionMark()) {
            toReturn = toReturn + "QuestionMark: " + this.questionMark + separator + two.getQuestionMark() + lineReturn;
        }
        if (this.landmarkEnabled != two.getLandmarkEnabled()) {
            toReturn = toReturn + "LandmarkEnabled: " + this.landmarkEnabled + separator + two.getLandmarkEnabled() + lineReturn;
        }
        if (this.landmarkFood != two.getLandmarkFood()) {
            toReturn = toReturn + "LandmarkFood: " + this.landmarkFood + separator + two.getLandmarkFood() + lineReturn;
        }
        if (this.landmarkShields != two.getLandmarkShields()) {
            toReturn = toReturn + "LandmarkShields: " + this.landmarkShields + separator + two.getLandmarkShields() + lineReturn;
        }
        if (this.landmarkCommerce != two.getLandmarkCommerce()) {
            toReturn = toReturn + "LandmarkCommerce: " + this.landmarkCommerce + separator + two.getLandmarkCommerce() + lineReturn;
        }
        if (this.landmarkFoodBonus != two.getLandmarkFoodBonus()) {
            toReturn = toReturn + "LandmarkFoodBonus: " + this.landmarkFoodBonus + separator + two.getLandmarkFoodBonus() + lineReturn;
        }
        if (this.landmarkShieldsBonus != two.getLandmarkShieldsBonus()) {
            toReturn = toReturn + "LandmarkShieldsBonus: " + this.landmarkShieldsBonus + separator + two.getLandmarkShieldsBonus() + lineReturn;
        }
        if (this.landmarkCommerceBonus != two.getLandmarkCommerceBonus()) {
            toReturn = toReturn + "LandmarkCommerceBonus: " + this.landmarkCommerceBonus + separator + two.getLandmarkCommerceBonus() + lineReturn;
        }
        if (this.landmarkMovementCost != two.getLandmarkMovementCost()) {
            toReturn = toReturn + "LandmarkMovementCost: " + this.landmarkMovementCost + separator + two.getLandmarkMovementCost() + lineReturn;
        }
        if (this.landmarkDefenceBonus != two.getLandmarkDefenceBonus()) {
            toReturn = toReturn + "LandmarkDefenceBonus: " + this.landmarkDefenceBonus + separator + two.getLandmarkDefenceBonus() + lineReturn;
        }
        if (this.landmarkName.compareTo(two.getLandmarkName()) != 0) {
            toReturn = toReturn + "LandmarkName: " + this.landmarkName + separator + two.getLandmarkName() + lineReturn;
        }
        if (this.landmarkCivilopediaEntry.compareTo(two.getLandmarkCivilopediaEntry()) != 0) {
            toReturn = toReturn + "LandmarkCivilopediaEntry: " + this.landmarkCivilopediaEntry + separator + two.getLandmarkCivilopediaEntry() + lineReturn;
        }
        if (this.questionMark2 != two.getQuestionMark2()) {
            toReturn = toReturn + "QuestionMark2: " + this.questionMark2 + separator + two.getQuestionMark2() + lineReturn;
        }
        if (this.terrainFlags != two.getTerrainFlags()) {
            toReturn = toReturn + "TerrainFlags: " + this.terrainFlags + separator + two.getTerrainFlags() + lineReturn;
        }
        if (this.diseaseStrength != two.getDiseaseStrength()) {
            toReturn = toReturn + "DiseaseStrength: " + this.diseaseStrength + separator + two.getDiseaseStrength() + lineReturn;
        }
        if (toReturn.equals("name: " + this.name + lineReturn)) {
            toReturn = "";
        }
        return toReturn;
    }

    @Override
    public Object getProperty(String string) throws UnsupportedOperationException {
        if (string.equals("Name")) {
            return this.name;
        }
        throw new UnsupportedOperationException();
    }
}

