/*
 * Decompiled with CFR 0.152.
 */
package com.civfanatics.civ3.biqFile;

import com.civfanatics.civ3.biqFile.BIQSection;
import com.civfanatics.civ3.biqFile.EXPR;
import com.civfanatics.civ3.biqFile.GOOD;
import com.civfanatics.civ3.biqFile.IO;
import com.civfanatics.civ3.biqFile.PRTO;
import com.civfanatics.civ3.biqFile.UNIT;
import com.civfanatics.civ3.biqFile.civ3Version;
import com.civfanatics.civ3.biqFile.util.MapDirection;
import java.util.ArrayList;
import java.util.List;

public class TILE
extends BIQSection {
    public int dataLength = 45;
    byte riverConnectionInfo;
    byte border;
    public static final int ROAD_MASK = 1;
    public static final int RAILROAD_MASK = 2;
    public static final int MINE_MASK = 4;
    public static final int IRRIGATION_MASK = 8;
    public static final int FORT_MASK = 16;
    public static final int GOODY_HUT_MASK = 32;
    public static final int POLLUTION_MASK = 64;
    public static final int BARBARIAN_CAMP_MASK = 128;
    public static final int CRATER_MASK = 256;
    public static final int BARRICADE_MASK = 0x10000000;
    public static final int AIRFIELD_MASK = 0x20000000;
    public static final int RADAR_TOWER_MASK = 0x40000000;
    public static final int OUTPOST_MASK = Integer.MIN_VALUE;
    public static final int RUINS_PRESENT = 1;
    public static final int RUINS_NOT_PRESENT = 0;
    public static final short VICTORY_POINT_LOCATION_PRESENT = 0;
    public static final short VICTORY_POINT_LOCATION_NOT_PRESENT = -1;
    public static final int PLAYER_START_MASK = 8;
    public static final byte RIVER_NORTHEAST = 2;
    public static final byte RIVER_SOUTHEAST = 8;
    public static final byte RIVER_SOUTHWEST = 32;
    public static final byte RIVER_NORTHWEST = -128;
    public static final byte XTGC = 0;
    public static final byte XPGC = 1;
    public static final byte XDGC = 2;
    public static final byte XDPC = 3;
    public static final byte XDGP = 4;
    public static final byte XGGC = 5;
    public static final byte WCSO = 6;
    public static final byte WSSS = 7;
    public static final byte WOOO = 8;
    public static final int[] c3cOverlayMasks = new int[]{1, 2, 4, 8, 16, 32, 64, 128, 256, 0x10000000};
    public static final int RANDOM_BARBARIAN_TRIBE = 75;
    private GOOD resource;
    public int resourceInt = -1;
    byte image;
    byte file;
    short questionMark;
    byte overlays;
    byte realBaseTerrain;
    byte realTerrain;
    byte baseTerrain;
    byte bonuses;
    byte riverCrossingData;
    short barbarianTribe = (short)-1;
    short colony = (short)-1;
    short city = (short)-1;
    short continent;
    byte questionMark2 = (byte)6;
    short victoryPointLocation = (short)-1;
    public int ruin;
    public int C3COverlays;
    byte questionMark3;
    private byte C3CRealBaseTerrain;
    private byte c3cRealTerrain;
    private byte c3cBaseTerrain;
    short questionMark4;
    short fogOfWar;
    public int C3CBonuses;
    public static final byte PINE_FOREST = 32;
    public static final byte SNOW_CAPPED_MOUNTAIN = 16;
    public static final byte BONUS_GRASSLAND = 1;
    short questionMark5;
    int extraInt;
    public List<Integer> citiesWithInfluence = new ArrayList<Integer>();
    public int owner;
    public int ownerType;
    boolean definiteOwner = false;
    public int borderColor;
    public int tileID;
    public int xPos;
    public int yPos;
    public int index;
    public List<Integer> unitsOnTile = new ArrayList<Integer>();
    public int unitWithBestDefence = -1;

    public TILE(IO baselink) {
        super(baselink);
        this.citiesWithInfluence = new ArrayList<Integer>();
        this.unitsOnTile = new ArrayList<Integer>();
    }

    public TILE(civ3Version version) {
        super(version);
    }

    public TILE(IO baselink, int terrain) {
        this(baselink);
        if (terrain == 0) {
            this.file = (byte)2;
        } else if (terrain == 1) {
            this.file = 1;
        } else if (terrain == 2) {
            this.file = (byte)5;
        } else if (terrain == 13) {
            this.file = (byte)8;
        } else if (terrain == 12) {
            this.file = (byte)7;
        } else if (terrain == 11) {
            this.file = (byte)6;
        }
        this.c3cRealTerrain = (byte)terrain;
        this.c3cBaseTerrain = (byte)terrain;
        this.C3CRealBaseTerrain = (byte)(this.c3cRealTerrain << 4 | this.c3cBaseTerrain);
    }

    public int getDataLength() {
        return this.dataLength;
    }

    public byte getRiverConnectionInfo() {
        return this.riverConnectionInfo;
    }

    public byte getBorder() {
        return this.border;
    }

    public int getResource() {
        return this.resourceInt;
    }

    public byte getImage() {
        return this.image;
    }

    public byte getFile() {
        return this.file;
    }

    public short getQuestionMark() {
        return this.questionMark;
    }

    public byte getOverlays() {
        return this.overlays;
    }

    public byte getBaseRealTerrain() {
        return this.realBaseTerrain;
    }

    public byte getBonuses() {
        return this.bonuses;
    }

    public byte getRiverCrossingData() {
        return this.riverCrossingData;
    }

    public short getBarbarianTribe() {
        return this.barbarianTribe;
    }

    public short getColony() {
        return this.colony;
    }

    public short getCity() {
        return this.city;
    }

    public short getContinent() {
        return this.continent;
    }

    public byte getQuestionMark2() {
        return this.questionMark2;
    }

    public short getVictoryPointLocation() {
        return this.victoryPointLocation;
    }

    public int getRuin() {
        return this.ruin;
    }

    public int getC3COverlays() {
        return this.C3COverlays;
    }

    public byte getQuestionMark3() {
        return this.questionMark3;
    }

    public byte getC3CBaseRealTerrain() {
        return this.C3CRealBaseTerrain;
    }

    public short getQuestionMark4() {
        return this.questionMark4;
    }

    public short getFogOfWar() {
        return this.fogOfWar;
    }

    public int getC3CBonuses() {
        return this.C3CBonuses;
    }

    public short getQuestionMark5() {
        return this.questionMark5;
    }

    public void setUpNibbles() {
        this.c3cRealTerrain = (byte)((this.C3CRealBaseTerrain & 0xF0) >>> 4);
        this.c3cBaseTerrain = (byte)(this.C3CRealBaseTerrain & 0xF);
    }

    public byte getBaseTerrain() {
        return this.c3cBaseTerrain;
    }

    public byte getRealTerrain() {
        return this.c3cRealTerrain;
    }

    public int getXPos() {
        return this.xPos;
    }

    public int getYPos() {
        return this.yPos;
    }

    public void setDataLength(int dataLength) {
        this.dataLength = dataLength;
    }

    public void setRiverConnectionInfo(byte riverConnectionInfo) {
        this.riverConnectionInfo = riverConnectionInfo;
    }

    public void setRiverAtBorder(boolean isRiver, byte direction) {
        this.riverConnectionInfo = isRiver ? (byte)(this.riverConnectionInfo | direction) : (byte)(this.riverConnectionInfo & ~direction);
    }

    public void setBorder(byte border) {
        this.border = border;
    }

    public void setResource(int resource) {
        this.resourceInt = resource;
        if (this.baseLink.resource != null && resource != -1 && this.baseLink.resource.size() > resource) {
            this.resource = this.baseLink.resource.get(resource);
        }
    }

    public void setImage(byte image) {
        this.image = image;
    }

    public void setFile(byte file) {
        this.file = file;
    }

    public void setQuestionMark(short questionMark) {
        this.questionMark = questionMark;
    }

    public void setOverlays(byte overlays) {
        this.overlays = overlays;
    }

    @Deprecated
    public void setBaseRealTerrain(byte baseRealTerrain) {
        this.realBaseTerrain = baseRealTerrain;
    }

    public void setBonuses(byte bonuses) {
        this.bonuses = bonuses;
    }

    public void setRiverCrossingData(byte riverCrossingData) {
        this.riverCrossingData = riverCrossingData;
    }

    public void setColony(short colony) {
        this.colony = colony;
    }

    public void setCity(short city) {
        this.city = city;
    }

    public void setContinent(short continent) {
        this.continent = continent;
    }

    public void setQuestionMark2(byte questionMark2) {
        this.questionMark2 = questionMark2;
    }

    public void setVictoryPointLocation(short victoryPointLocation) {
        this.victoryPointLocation = victoryPointLocation;
    }

    public void setRuin(int ruin) {
        this.ruin = ruin;
    }

    public void setC3COverlays(int C3COverlays) {
        this.C3COverlays = C3COverlays;
    }

    public void setQuestionMark3(byte questionMark3) {
        this.questionMark3 = questionMark3;
    }

    public void setC3CBaseRealTerrain(byte C3CRealBaseTerrain) {
        this.C3CRealBaseTerrain = C3CRealBaseTerrain;
        this.c3cRealTerrain = (byte)((C3CRealBaseTerrain & 0xF0) >>> 4);
        this.c3cBaseTerrain = (byte)(C3CRealBaseTerrain & 0xF);
    }

    public void setQuestionMark4(short questionMark4) {
        this.questionMark4 = questionMark4;
    }

    public void setFogOfWar(short fogOfWar) {
        this.fogOfWar = fogOfWar;
    }

    public void setC3CBonuses(int C3CBonuses) {
        this.C3CBonuses = C3CBonuses;
    }

    public void setQuestionMark5(short questionMark5) {
        this.questionMark5 = questionMark5;
    }

    public void setExtraInt(int extraInt) {
        this.extraInt = extraInt;
    }

    @Override
    public String toEnglish() {
        return this.toString();
    }

    public boolean isWater() {
        return this.c3cBaseTerrain >= 11;
    }

    public boolean isLandmark() {
        return (this.C3CBonuses & 0x2000) == 8192;
    }

    public boolean isPineForest() {
        return (this.C3CBonuses & 0x20) == 32;
    }

    public boolean isSnowCappedMountain() {
        return (this.C3CBonuses & 0x10) == 16;
    }

    public boolean riverSouth() {
        return (this.C3CBonuses & 0x800) == 2048;
    }

    public boolean riverEast() {
        return (this.C3CBonuses & 0x400) == 1024;
    }

    public boolean riverWest() {
        return (this.C3CBonuses & 0x200) == 512;
    }

    public boolean riverNorth() {
        return (this.C3CBonuses & 0x100) == 256;
    }

    public void setBonusGrassland(boolean flag) {
        this.C3CBonuses = flag ? (this.C3CBonuses |= 1) : (this.C3CBonuses &= 0xFFFFFFFE);
    }

    public boolean hasBonusGrassland() {
        return (this.C3CBonuses & 1) == 1;
    }

    public void setBaseTerrain(int newBaseTerrain) {
        byte newByte = (byte)newBaseTerrain;
        if (this.baseLink.version == civ3Version.CONQUESTS || this.baseLink.convertToConquests == 1) {
            this.c3cBaseTerrain = newByte;
            this.C3CRealBaseTerrain = (byte)((0xF0 & this.C3CRealBaseTerrain) + newByte);
        } else {
            this.baseTerrain = newByte;
            this.realBaseTerrain = (byte)((0xF0 & this.realBaseTerrain) + newByte);
        }
    }

    public void setRealTerrain(int newRealTerrain) {
        byte newByte = (byte)newRealTerrain;
        if (this.baseLink.version == civ3Version.CONQUESTS || this.baseLink.convertToConquests == 1) {
            this.c3cRealTerrain = newByte;
            this.C3CRealBaseTerrain = (byte)((0xF & this.C3CRealBaseTerrain) + (newByte << 4));
        } else {
            this.realTerrain = newByte;
            this.realBaseTerrain = (byte)((0xF & this.realBaseTerrain) + (newByte << 4));
        }
    }

    public void setTerrain(int newTerrain) {
    }

    @Override
    public String toString() {
        int i;
        String lineReturn = System.getProperty("line.separator");
        String toReturn = "Tile at " + this.xPos + ", " + this.yPos + lineReturn;
        toReturn = toReturn + "tileID: " + this.tileID + lineReturn;
        toReturn = toReturn + "dataLength: " + this.dataLength + lineReturn;
        toReturn = toReturn + "riverConnectionInfo: " + this.riverConnectionInfo + lineReturn;
        toReturn = toReturn + "border: " + this.border + lineReturn;
        toReturn = toReturn + "resource: " + this.resourceInt + lineReturn;
        toReturn = toReturn + "image: " + this.image + lineReturn;
        toReturn = toReturn + "file: " + this.file + lineReturn;
        toReturn = toReturn + "questionMark: " + this.questionMark + lineReturn;
        toReturn = toReturn + "overlays: " + this.overlays + lineReturn;
        toReturn = toReturn + "baseRealTerrain: " + this.realBaseTerrain + lineReturn;
        toReturn = toReturn + "bonuses: " + this.bonuses + lineReturn;
        toReturn = toReturn + "riverCrossingData: " + this.riverCrossingData + lineReturn;
        toReturn = toReturn + "barbarianTribe: " + this.barbarianTribe + lineReturn;
        toReturn = toReturn + "colony: " + this.colony + lineReturn;
        toReturn = toReturn + "city: " + this.city + lineReturn;
        toReturn = toReturn + "continent: " + this.continent + lineReturn;
        toReturn = toReturn + "questionMark2: " + this.questionMark2 + lineReturn;
        toReturn = toReturn + "victoryPointLocation: " + this.victoryPointLocation + lineReturn;
        toReturn = toReturn + "ruin: " + this.ruin + lineReturn;
        toReturn = toReturn + "C3COverlays: " + this.C3COverlays + lineReturn;
        toReturn = toReturn + "questionMark3: " + this.questionMark3 + lineReturn;
        toReturn = toReturn + "C3CBaseRealTerrain: " + this.C3CRealBaseTerrain + lineReturn;
        toReturn = toReturn + "questionMark4: " + this.questionMark4 + lineReturn;
        toReturn = toReturn + "fogOfWar: " + this.fogOfWar + lineReturn;
        toReturn = toReturn + "C3CBonuses: " + this.C3CBonuses + lineReturn;
        toReturn = toReturn + "questionMark5: " + this.questionMark5 + lineReturn;
        toReturn = toReturn + "owner: " + this.owner + lineReturn;
        toReturn = toReturn + "borderColor: " + this.borderColor + lineReturn;
        toReturn = toReturn + "definiteOwner? " + this.definiteOwner + lineReturn;
        for (i = 0; i < this.citiesWithInfluence.size(); ++i) {
            toReturn = toReturn + "influenced by city: " + this.citiesWithInfluence.get(i) + lineReturn;
        }
        for (i = 0; i < this.unitsOnTile.size(); ++i) {
            toReturn = toReturn + "unit on tile: " + this.baseLink.unit.get(this.baseLink.mapUnit.get(this.unitsOnTile.get(i)).getPRTONumber()).getName() + lineReturn;
        }
        toReturn = toReturn + lineReturn;
        return toReturn;
    }

    @Override
    public String compareTo(BIQSection section, String separator) {
        if (!(section instanceof TILE)) {
            return null;
        }
        TILE two = (TILE)section;
        String toReturn = "";
        String lineReturn = System.getProperty("line.separator");
        if (this.dataLength != two.getDataLength()) {
            toReturn = toReturn + "DataLength: " + this.dataLength + separator + two.getDataLength() + lineReturn;
        }
        if (this.riverConnectionInfo != two.getRiverConnectionInfo()) {
            toReturn = toReturn + "RiverConnectionInfo: " + this.riverConnectionInfo + separator + two.getRiverConnectionInfo() + lineReturn;
        }
        if (this.border != two.getBorder()) {
            toReturn = toReturn + "Border: " + this.border + separator + two.getBorder() + lineReturn;
        }
        if (this.resourceInt != two.getResource()) {
            toReturn = toReturn + "Resource: " + this.resourceInt + separator + two.getResource() + lineReturn;
        }
        if (this.image != two.getImage()) {
            toReturn = toReturn + "Image: " + this.image + separator + two.getImage() + lineReturn;
        }
        if (this.file != two.getFile()) {
            toReturn = toReturn + "File: " + this.file + separator + two.getFile() + lineReturn;
        }
        if (this.questionMark != two.getQuestionMark()) {
            toReturn = toReturn + "QuestionMark: " + this.questionMark + separator + two.getQuestionMark() + lineReturn;
        }
        if (this.overlays != two.getOverlays()) {
            toReturn = toReturn + "Overlays: " + this.overlays + separator + two.getOverlays() + lineReturn;
        }
        if (this.realBaseTerrain != two.getBaseRealTerrain()) {
            toReturn = toReturn + "BaseRealTerrain: " + this.realBaseTerrain + separator + two.getBaseRealTerrain() + lineReturn;
        }
        if (this.bonuses != two.getBonuses()) {
            toReturn = toReturn + "Bonuses: " + this.bonuses + separator + two.getBonuses() + lineReturn;
        }
        if (this.riverCrossingData != two.getRiverCrossingData()) {
            toReturn = toReturn + "RiverCrossingData: " + this.riverCrossingData + separator + two.getRiverCrossingData() + lineReturn;
        }
        if (this.barbarianTribe != two.getBarbarianTribe()) {
            toReturn = toReturn + "BarbarianTribe: " + this.barbarianTribe + separator + two.getBarbarianTribe() + lineReturn;
        }
        if (this.colony != two.getColony()) {
            toReturn = toReturn + "Colony: " + this.colony + separator + two.getColony() + lineReturn;
        }
        if (this.city != two.getCity()) {
            toReturn = toReturn + "City: " + this.city + separator + two.getCity() + lineReturn;
        }
        if (this.continent != two.getContinent()) {
            toReturn = toReturn + "Continent: " + this.continent + separator + two.getContinent() + lineReturn;
        }
        if (this.questionMark2 != two.getQuestionMark2()) {
            toReturn = toReturn + "QuestionMark2: " + this.questionMark2 + separator + two.getQuestionMark2() + lineReturn;
        }
        if (this.victoryPointLocation != two.getVictoryPointLocation()) {
            toReturn = toReturn + "VictoryPointLocation: " + this.victoryPointLocation + separator + two.getVictoryPointLocation() + lineReturn;
        }
        if (this.ruin != two.getRuin()) {
            toReturn = toReturn + "Ruin: " + this.ruin + separator + two.getRuin() + lineReturn;
        }
        if (this.C3COverlays != two.getC3COverlays()) {
            toReturn = toReturn + "C3COverlays: " + this.C3COverlays + separator + two.getC3COverlays() + lineReturn;
        }
        if (this.questionMark3 != two.getQuestionMark3()) {
            toReturn = toReturn + "QuestionMark3: " + this.questionMark3 + separator + two.getQuestionMark3() + lineReturn;
        }
        if (this.C3CRealBaseTerrain != two.getC3CBaseRealTerrain()) {
            toReturn = toReturn + "C3CBaseRealTerrain: " + this.C3CRealBaseTerrain + separator + two.getC3CBaseRealTerrain() + lineReturn;
        }
        if (this.c3cRealTerrain != two.c3cRealTerrain) {
            toReturn = toReturn + "c3cRealTerrain: " + this.c3cRealTerrain + separator + two.c3cRealTerrain + lineReturn;
        }
        if (this.c3cBaseTerrain != two.c3cBaseTerrain) {
            toReturn = toReturn + "c3cBaseTerrain: " + this.c3cBaseTerrain + separator + two.c3cBaseTerrain + lineReturn;
        }
        if (this.questionMark4 != two.getQuestionMark4()) {
            toReturn = toReturn + "QuestionMark4: " + this.questionMark4 + separator + two.getQuestionMark4() + lineReturn;
        }
        if (this.fogOfWar != two.getFogOfWar()) {
            toReturn = toReturn + "FogOfWar: " + this.fogOfWar + separator + two.getFogOfWar() + lineReturn;
        }
        if (this.C3CBonuses != two.getC3CBonuses()) {
            toReturn = toReturn + "C3CBonuses: " + this.C3CBonuses + separator + two.getC3CBonuses() + lineReturn;
        }
        if (this.isLandmark() != two.isLandmark()) {
            toReturn = toReturn + "  isLandmark: " + this.isLandmark() + separator + two.isLandmark() + lineReturn;
        }
        if (this.isPineForest() != two.isPineForest()) {
            toReturn = toReturn + "  isPineForest: " + this.isPineForest() + separator + two.isPineForest() + lineReturn;
        }
        if (this.isSnowCappedMountain() != two.isSnowCappedMountain()) {
            toReturn = toReturn + "  snowCappedMountain: " + this.isSnowCappedMountain() + separator + two.isSnowCappedMountain() + lineReturn;
        }
        if (this.hasBonusGrassland() != two.hasBonusGrassland()) {
            toReturn = toReturn + "  bonusGrassland: " + this.hasBonusGrassland() + separator + two.hasBonusGrassland() + lineReturn;
        }
        if (this.riverSouth() != two.riverSouth()) {
            toReturn = toReturn + "  riverSouth: " + this.riverSouth() + separator + two.riverSouth() + lineReturn;
        }
        if (this.riverEast() != two.riverEast()) {
            toReturn = toReturn + "  riverEast: " + this.riverEast() + separator + two.riverEast() + lineReturn;
        }
        if (this.riverWest() != two.riverWest()) {
            toReturn = toReturn + "  riverWest: " + this.riverWest() + separator + two.riverWest() + lineReturn;
        }
        if (this.riverNorth() != two.riverNorth()) {
            toReturn = toReturn + "  riverNorth: " + this.riverNorth() + separator + two.riverNorth() + lineReturn;
        }
        if (this.questionMark5 != two.getQuestionMark5()) {
            toReturn = toReturn + "QuestionMark5: " + this.questionMark5 + separator + two.getQuestionMark5() + lineReturn;
        }
        if (!toReturn.equals("")) {
            toReturn = this.xPos + ", " + this.yPos + lineReturn + toReturn;
        }
        return toReturn;
    }

    @Override
    public Object getProperty(String string) throws UnsupportedOperationException {
        if (string.equals("Name")) {
            return this.xPos + ", " + this.yPos;
        }
        throw new UnsupportedOperationException();
    }

    public void calculateUnitWithBestDefence() {
        if (this.unitsOnTile.size() == 0) {
            this.unitWithBestDefence = -1;
            return;
        }
        int bestDefenceValue = -1;
        this.unitWithBestDefence = -1;
        for (int i = 0; i < this.unitsOnTile.size(); ++i) {
            UNIT unit = this.baseLink.mapUnit.get(this.unitsOnTile.get(i));
            PRTO unitType = this.baseLink.unit.get(unit.getPRTONumber());
            EXPR exprLevel = this.baseLink.experience.get(unit.getExperienceLevel());
            int numHitpoints = exprLevel.baseHitPoints + unitType.getHitPointBonus();
            int unitDefence = unitType.getDefence() * numHitpoints;
            if (unitDefence <= bestDefenceValue) continue;
            bestDefenceValue = unitDefence;
            this.unitWithBestDefence = i;
        }
    }

    public void setTerrain(int base, int real) {
        byte compositeTerrain;
        this.c3cBaseTerrain = (byte)(base & 0xFF);
        this.c3cRealTerrain = (byte)(real & 0xFF);
        this.C3CRealBaseTerrain = compositeTerrain = (byte)(real << 4 | base & 0xFF);
    }

    public void setPine(boolean pine) {
        this.C3CBonuses = pine ? (this.C3CBonuses |= 0x20) : (this.C3CBonuses &= 0xFFFFFFDF);
    }

    public void setSnow(boolean snow) {
        this.C3CBonuses = snow ? (this.C3CBonuses |= 0x10) : (this.C3CBonuses &= 0xFFFFFFEF);
    }

    public void setLandmark(boolean landmark) {
        this.C3CBonuses = landmark ? (this.C3CBonuses |= 0x2000) : (this.C3CBonuses &= 0xFFFFDFFF);
    }

    public void setIrrigated(boolean irrigated) {
        this.setOverlay(irrigated, 8);
    }

    public void setMined(boolean mined) {
        this.setOverlay(mined, 4);
    }

    public void setRoad(boolean road) {
        this.setOverlay(road, 1);
    }

    public void setRailroad(boolean railroad) {
        this.setOverlay(railroad, 2);
    }

    public void setFort(boolean fort) {
        this.setOverlay(fort, 16);
    }

    public void setBarricade(boolean barricade) {
        this.setOverlay(barricade, 0x10000000);
    }

    public void setBarbarianCamp(boolean barbarianCamp) {
        if (barbarianCamp) {
            this.addBarbarianCamp();
        } else {
            this.removeBarbarianCamp();
        }
    }

    public void setGoodyHut(boolean goodyHut) {
        this.setOverlay(goodyHut, 32);
    }

    public void setPollution(boolean pollution) {
        this.setOverlay(pollution, 64);
    }

    public void setCrater(boolean crater) {
        this.setOverlay(crater, 256);
    }

    private void addBarbarianCamp() {
        this.C3COverlays |= 0x80;
        this.barbarianTribe = (short)75;
    }

    public void setBarbarianTribe(short tribe) {
        this.C3COverlays |= 0x80;
        this.barbarianTribe = tribe;
    }

    private void removeBarbarianCamp() {
        this.C3COverlays &= 0xFFFFFF7F;
        this.barbarianTribe = (short)-1;
    }

    private void setOverlay(boolean present, int MASK) {
        this.C3COverlays = present ? (this.C3COverlays |= MASK) : (this.C3COverlays &= ~MASK);
    }

    public void handleSwappedGood() {
        if (this.resourceInt != -1) {
            this.resourceInt = this.resource.getIndex();
        }
    }

    public TILE neighbor(MapDirection direction) {
        switch (direction) {
            case NORTHWEST: {
                return this.getTile(this.xPos - 1, this.yPos - 1);
            }
            case NORTH: {
                return this.getTile(this.xPos, this.yPos - 1);
            }
            case NORTHEAST: {
                return this.getTile(this.xPos + 1, this.yPos - 1);
            }
            case EAST: {
                return this.getTile(this.xPos + 1, this.yPos);
            }
            case SOUTHEAST: {
                return this.getTile(this.xPos + 1, this.yPos + 1);
            }
            case SOUTH: {
                return this.getTile(this.xPos, this.yPos + 1);
            }
            case SOUTHWEST: {
                return this.getTile(this.xPos - 1, this.yPos + 1);
            }
            case WEST: {
                return this.getTile(this.xPos - 1, this.yPos);
            }
        }
        return null;
    }

    private TILE getTile(int xPos, int yPos) {
        int index = 0;
        index += yPos / 2 * this.baseLink.worldMap.get((int)0).width;
        if (yPos % 2 == 1) {
            index += this.baseLink.worldMap.get((int)0).width / 2;
        }
        index += xPos / 2;
        try {
            return this.baseLink.tile.get(index);
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }
}

