/*
 * Decompiled with CFR 0.152.
 */
package com.civfanatics.civ3.biqFile;

import com.civfanatics.civ3.biqFile.IO;
import com.civfanatics.civ3.biqFile.TILE;
import com.civfanatics.civ3.biqFile.civ3Version;
import com.civfanatics.civ3.biqFile.util.LittleEndianDataInputStream;
import java.io.IOException;
import java.util.List;
import org.apache.log4j.Logger;

public class TILEThread
extends Thread {
    LittleEndianDataInputStream in;
    LittleEndianDataInputStream[] inputArray;
    List<TILE> tile;
    int numTiles;
    int start;
    Integer cpus;
    Integer returnVal;
    Logger logger = Logger.getLogger(this.getClass());
    IO baselink;

    public TILEThread(LittleEndianDataInputStream in, List<TILE> tile, int numTiles, int start, Integer cpus, IO baselink) {
        this.in = in;
        this.tile = tile;
        this.numTiles = numTiles;
        this.start = start;
        this.cpus = cpus;
        this.baselink = baselink;
    }

    public TILEThread(LittleEndianDataInputStream[] inputArray, List<TILE> tile, int numTiles) {
        this.inputArray = inputArray;
        this.tile = tile;
        this.numTiles = numTiles;
        this.baselink = this.baselink;
    }

    @Override
    public void run() {
        this.multiThreadInputTILE();
    }

    public Integer getReturnValue() {
        return this.returnVal;
    }

    private void multiThreadInputTILE() {
        int bytesOfInput = 0;
        try {
            for (int i = this.start; i < this.numTiles; i += this.cpus.intValue()) {
                this.tile.get((int)i).index = i;
                Integer integer = this.in.readInt();
                bytesOfInput += 4;
                this.tile.get(i).setDataLength(integer);
                byte inputByte = this.in.readByte();
                ++bytesOfInput;
                this.tile.get(i).setRiverConnectionInfo(inputByte);
                inputByte = this.in.readByte();
                ++bytesOfInput;
                this.tile.get(i).setBorder(inputByte);
                integer = this.in.readInt();
                bytesOfInput += 4;
                this.tile.get(i).setResource(integer);
                inputByte = this.in.readByte();
                ++bytesOfInput;
                this.tile.get(i).setImage(inputByte);
                inputByte = this.in.readByte();
                ++bytesOfInput;
                if (inputByte == -1) {
                    System.err.println("This should not happen");
                }
                this.tile.get(i).setFile(inputByte);
                Short inputShort = this.in.readShort();
                bytesOfInput += 2;
                this.tile.get(i).setQuestionMark(inputShort);
                inputByte = this.in.readByte();
                ++bytesOfInput;
                this.tile.get(i).setOverlays(inputByte);
                inputByte = this.in.readByte();
                ++bytesOfInput;
                this.tile.get(i).setBaseRealTerrain(inputByte);
                inputByte = this.in.readByte();
                ++bytesOfInput;
                this.tile.get(i).setBonuses(inputByte);
                inputByte = this.in.readByte();
                ++bytesOfInput;
                this.tile.get(i).setRiverCrossingData(inputByte);
                inputShort = this.in.readShort();
                bytesOfInput += 2;
                this.tile.get(i).setBarbarianTribe(inputShort);
                inputShort = this.in.readShort();
                bytesOfInput += 2;
                this.tile.get(i).setCity(inputShort);
                inputShort = this.in.readShort();
                bytesOfInput += 2;
                this.tile.get(i).setColony(inputShort);
                inputShort = this.in.readShort();
                bytesOfInput += 2;
                this.tile.get(i).setContinent(inputShort);
                if (this.tile.get(i).getDataLength() >= 23) {
                    inputByte = this.in.readByte();
                    ++bytesOfInput;
                    this.tile.get(i).setQuestionMark2(inputByte);
                    if (this.baselink.version.ordinal() >= civ3Version.PTW.ordinal()) {
                        inputShort = this.in.readShort();
                        bytesOfInput += 2;
                        this.tile.get(i).setVictoryPointLocation(inputShort);
                        integer = this.in.readInt();
                        bytesOfInput += 4;
                        this.tile.get(i).setRuin(integer);
                        if (this.baselink.version == civ3Version.CONQUESTS) {
                            integer = this.in.readInt();
                            bytesOfInput += 4;
                            this.tile.get(i).setC3COverlays(integer);
                            inputByte = this.in.readByte();
                            ++bytesOfInput;
                            this.tile.get(i).setQuestionMark3(inputByte);
                            inputByte = this.in.readByte();
                            ++bytesOfInput;
                            this.tile.get(i).setC3CBaseRealTerrain(inputByte);
                            inputShort = this.in.readShort();
                            bytesOfInput += 2;
                            this.tile.get(i).setQuestionMark4(inputShort);
                            inputShort = this.in.readShort();
                            bytesOfInput += 2;
                            this.tile.get(i).setFogOfWar(inputShort);
                            integer = this.in.readInt();
                            bytesOfInput += 4;
                            this.tile.get(i).setC3CBonuses(integer);
                            inputShort = this.in.readShort();
                            bytesOfInput += 2;
                            this.tile.get(i).setQuestionMark5(inputShort);
                            this.tile.get(i).setUpNibbles();
                            if (this.tile.get((int)i).dataLength == 49) {
                                integer = this.in.readInt();
                                bytesOfInput += 4;
                                this.tile.get(i).setExtraInt(integer);
                            }
                        }
                    }
                }
                if (this.baselink.convertToConquests == 1) {
                    byte realTerrain;
                    this.tile.get(i).setDataLength(45);
                    this.tile.get(i).setQuestionMark2((byte)6);
                    this.tile.get(i).setC3CBaseRealTerrain(this.tile.get(i).getBaseRealTerrain());
                    this.tile.get(i).setC3COverlays(this.tile.get(i).getOverlays());
                    this.tile.get(i).setC3CBonuses(this.tile.get(i).getBonuses());
                    byte baseTerrain = this.tile.get(i).getBaseTerrain();
                    if (baseTerrain >= 9) {
                        this.tile.get(i).setBaseTerrain(baseTerrain + 2);
                    }
                    if ((realTerrain = this.tile.get(i).getRealTerrain()) >= 9) {
                        this.tile.get(i).setRealTerrain(realTerrain + 2);
                    }
                    if (this.baselink.version == civ3Version.VANILLA) {
                        this.tile.get(i).setCrater(false);
                        this.tile.get(i).setBarricade(false);
                    }
                }
                this.tile.get((int)i).tileID = i;
                if (i + this.cpus < this.numTiles) {
                    if (this.baselink.version == civ3Version.CONQUESTS) {
                        this.in.skipBytes(49 * (this.cpus - 1));
                        continue;
                    }
                    if (this.baselink.version == civ3Version.PTW) {
                        this.in.skipBytes(33 * (this.cpus - 1));
                        continue;
                    }
                    if (this.baselink.version != civ3Version.VANILLA) continue;
                    if (this.baselink.majorVersionNumber == 2) {
                        this.in.skipBytes(26 * (this.cpus - 1));
                        continue;
                    }
                    this.in.skipBytes(27 * (this.cpus - 1));
                    continue;
                }
                int toJump = this.numTiles - 1 - i;
                if (this.baselink.version == civ3Version.CONQUESTS) {
                    this.in.skipBytes(49 * toJump);
                    continue;
                }
                if (this.baselink.version == civ3Version.PTW) {
                    this.in.skipBytes(33 * toJump);
                    continue;
                }
                if (this.baselink.version != civ3Version.VANILLA) continue;
                if (this.baselink.majorVersionNumber == 2) {
                    this.in.skipBytes(26 * toJump);
                    continue;
                }
                this.in.skipBytes(27 * toJump);
            }
        }
        catch (IOException e) {
            this.logger.error("IOException", e);
            System.err.println(e + " in TILEThread");
        }
        this.returnVal = bytesOfInput;
    }
}

