/*
 * Decompiled with CFR 0.152.
 */
package com.civfanatics.civ3.biqFile;

import com.civfanatics.civ3.biqFile.BIQSection;
import com.civfanatics.civ3.biqFile.GOOD;
import com.civfanatics.civ3.biqFile.IO;
import com.civfanatics.civ3.biqFile.TECH;

public class TRFM
extends BIQSection {
    private int dataLength = 112;
    private String name = "";
    private String civilopediaEntry = "";
    private int turnsToComplete;
    private int requiredAdvanceInt;
    private TECH requiredAdvance;
    private int requiredResourceInt;
    private int requiredResource2Int;
    private GOOD requiredResource1;
    private GOOD requiredResource2;
    private String order = "";

    public TRFM(IO baselink) {
        super(baselink);
    }

    public void trim() {
        this.name = this.name.trim();
        this.civilopediaEntry = this.civilopediaEntry.trim();
        this.order = this.order.trim();
    }

    public int getDataLength() {
        return this.dataLength;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getCivilopediaEntry() {
        return this.civilopediaEntry;
    }

    public int getTurnsToComplete() {
        return this.turnsToComplete;
    }

    public int getRequiredAdvance() {
        return this.requiredAdvanceInt;
    }

    public int getRequiredResource1() {
        return this.requiredResourceInt;
    }

    public int getRequiredResource2() {
        return this.requiredResource2Int;
    }

    public String getOrder() {
        return this.order;
    }

    public void setDataLength(int dataLength) {
        this.dataLength = dataLength;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setCivilopediaEntry(String civilopediaEntry) {
        this.civilopediaEntry = civilopediaEntry;
    }

    public void setTurnsToComplete(int turnsToComplete) {
        this.turnsToComplete = turnsToComplete;
    }

    public void setRequiredAdvance(int requiredAdvance) {
        this.requiredAdvanceInt = requiredAdvance;
        if (this.baseLink.technology != null && this.requiredAdvanceInt != -1 && this.baseLink.technology.size() > this.requiredAdvanceInt) {
            this.requiredAdvance = this.baseLink.technology.get(this.requiredAdvanceInt);
        }
    }

    public void handleSwappedTech() {
        if (this.requiredAdvanceInt != -1) {
            this.requiredAdvanceInt = this.requiredAdvance.getIndex();
        }
    }

    public void handleSwappedGood() {
        if (this.requiredResourceInt != -1) {
            this.requiredResourceInt = this.requiredResource1.getIndex();
        }
        if (this.requiredResource2Int != -1) {
            this.requiredResource2Int = this.requiredResource2.getIndex();
        }
    }

    public void setRequiredResource1(int requiredResource1) {
        this.requiredResourceInt = requiredResource1;
        if (this.baseLink.resource != null && this.requiredResourceInt != -1 && this.baseLink.resource.size() > requiredResource1) {
            this.requiredResource1 = this.baseLink.resource.get(this.requiredResourceInt);
        }
    }

    public void setRequiredResource2(int requiredResource2) {
        this.requiredResource2Int = requiredResource2;
        if (this.baseLink.resource != null && this.requiredResource2Int != -1 && this.baseLink.resource.size() > requiredResource2) {
            this.requiredResource2 = this.baseLink.resource.get(this.requiredResource2Int);
        }
    }

    public void setOrder(String order) {
        this.order = order;
    }

    public void handleDeletedTech(int techID) {
        if (this.requiredAdvanceInt == techID) {
            this.requiredAdvanceInt = -1;
            this.requiredAdvance = null;
        } else if (this.requiredAdvanceInt > techID) {
            --this.requiredAdvanceInt;
        }
    }

    public void handleDeletedGood(int goodID) {
        if (this.requiredResourceInt == goodID) {
            this.requiredResourceInt = -1;
        } else if (this.requiredResourceInt > goodID) {
            --this.requiredResourceInt;
        }
        if (this.requiredResource2Int == goodID) {
            this.requiredResourceInt = -1;
        } else if (this.requiredResource2Int > goodID) {
            --this.requiredResource2Int;
        }
    }

    @Override
    public String toEnglish() {
        return this.toString();
    }

    @Override
    public String toString() {
        String lineReturn = System.getProperty("line.separator");
        String toReturn = "name: " + this.name + lineReturn;
        toReturn = toReturn + "civilopediaEntry: " + this.civilopediaEntry + lineReturn;
        toReturn = toReturn + "dataLength: " + this.dataLength + lineReturn;
        toReturn = toReturn + "turnsToComplete: " + this.turnsToComplete + lineReturn;
        toReturn = toReturn + "requiredAdvance: " + this.requiredAdvanceInt + lineReturn;
        toReturn = toReturn + "requiredResource1: " + this.requiredResourceInt + lineReturn;
        toReturn = toReturn + "requiredResource2: " + this.requiredResource2Int + lineReturn;
        toReturn = toReturn + "order: " + this.order + lineReturn;
        toReturn = toReturn + lineReturn;
        return toReturn;
    }

    @Override
    public String compareTo(BIQSection section, String separator) {
        if (!(section instanceof TRFM)) {
            return null;
        }
        TRFM two = (TRFM)section;
        String lineReturn = System.getProperty("line.separator");
        String toReturn = "name: " + this.name + lineReturn;
        if (this.dataLength != two.getDataLength()) {
            toReturn = toReturn + "DataLength: " + this.dataLength + separator + two.getDataLength() + lineReturn;
        }
        if (this.civilopediaEntry.compareTo(two.getCivilopediaEntry()) != 0) {
            toReturn = toReturn + "CivilopediaEntry: " + this.civilopediaEntry + separator + two.getCivilopediaEntry() + lineReturn;
        }
        if (this.turnsToComplete != two.getTurnsToComplete()) {
            toReturn = toReturn + "TurnsToComplete: " + this.turnsToComplete + separator + two.getTurnsToComplete() + lineReturn;
        }
        if (this.requiredAdvanceInt != two.getRequiredAdvance()) {
            toReturn = toReturn + "RequiredAdvance: " + this.requiredAdvanceInt + separator + two.getRequiredAdvance() + lineReturn;
        }
        if (this.requiredResourceInt != two.getRequiredResource1()) {
            toReturn = toReturn + "RequiredResource1: " + this.requiredResourceInt + separator + two.getRequiredResource1() + lineReturn;
        }
        if (this.requiredResource2Int != two.getRequiredResource2()) {
            toReturn = toReturn + "RequiredResource2: " + this.requiredResource2Int + separator + two.getRequiredResource2() + lineReturn;
        }
        if (this.order.compareTo(two.getOrder()) != 0) {
            toReturn = toReturn + "Order: " + this.order + separator + two.getOrder() + lineReturn;
        }
        if (toReturn.equals("name: " + this.name + lineReturn)) {
            toReturn = "";
        }
        return toReturn;
    }

    @Override
    public Object getProperty(String string) throws UnsupportedOperationException {
        if (string.equals("Name")) {
            return this.name;
        }
        throw new UnsupportedOperationException();
    }
}

