/*
 * Decompiled with CFR 0.152.
 */
package com.civfanatics.civ3.biqFile;

import com.civfanatics.civ3.biqFile.BIQSection;
import com.civfanatics.civ3.biqFile.CITY;
import com.civfanatics.civ3.biqFile.IO;
import com.civfanatics.civ3.biqFile.PRTO;

public class UNIT
extends BIQSection {
    private int index = 0;
    private int dataLength = 121;
    private String name = "";
    private int ownerType;
    private int experienceLevel;
    private int owner;
    private int PRTONumber;
    private PRTO prto;
    private int AIStrategy;
    private int x;
    private int y;
    private String PTWCustomName = "";
    private int useCivilizationKing;

    public UNIT(IO baselink) {
        super(baselink);
    }

    public void trim() {
        this.name = this.name.trim();
        this.PTWCustomName = this.PTWCustomName.trim();
    }

    public int getDataLength() {
        return this.dataLength;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public int getOwnerType() {
        return this.ownerType;
    }

    public int getExperienceLevel() {
        return this.experienceLevel;
    }

    public int getOwner() {
        return this.owner;
    }

    public int getPRTONumber() {
        return this.PRTONumber;
    }

    public int getAIStrategy() {
        return this.AIStrategy;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public String getPTWCustomName() {
        return this.PTWCustomName;
    }

    public int getUseCivilizationKing() {
        return this.useCivilizationKing;
    }

    public void setDataLength(int dataLength) {
        this.dataLength = dataLength;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setOwnerType(int ownerType) {
        this.ownerType = ownerType;
    }

    public void setExperienceLevel(int experienceLevel) {
        this.experienceLevel = experienceLevel;
    }

    public void setOwner(int owner) {
        this.owner = owner;
    }

    public void setPRTONumber(int PRTONumber) {
        this.PRTONumber = PRTONumber;
        if (this.baseLink != null && this.baseLink.unit != null && PRTONumber != -1 && this.baseLink.unit.size() > PRTONumber) {
            this.prto = this.baseLink.unit.get(PRTONumber);
        }
    }

    public void setAIStrategy(int AIStrategy) {
        this.AIStrategy = AIStrategy;
    }

    public void setX(int x) {
        this.x = x;
    }

    public void setY(int y) {
        this.y = y;
    }

    public void setPTWCustomName(String PTWCustomName) {
        this.PTWCustomName = PTWCustomName;
    }

    public void setUseCivilizationKing(int useCivilizationKing) {
        this.useCivilizationKing = useCivilizationKing;
    }

    @Override
    public void setIndex(int index) {
        this.index = index;
    }

    public void handleSwappedUnit() {
        if (this.prto != null) {
            this.PRTONumber = this.prto.getIndex();
        }
    }

    public void handleDeletedUnit(int index) {
        if (this.PRTONumber == index) {
            this.PRTONumber = -1;
            this.prto = null;
        }
    }

    @Override
    public String toEnglish() {
        String lineReturn = System.getProperty("line.separator");
        String toReturn = "unit index: " + this.index + lineReturn;
        toReturn = toReturn + "dataLength: " + this.dataLength + lineReturn;
        toReturn = toReturn + "name: " + this.name + lineReturn;
        toReturn = toReturn + "ownerType: " + CITY.ownerTypes[this.ownerType] + lineReturn;
        toReturn = toReturn + "experienceLevel: " + this.baseLink.experience.get(this.experienceLevel).getName() + lineReturn;
        toReturn = this.ownerType == 2 ? toReturn + "owner: " + this.baseLink.civilization.get(this.owner).getName() + lineReturn : toReturn + "owner: " + this.owner + lineReturn;
        toReturn = toReturn + "Unit Type: " + this.baseLink.unit.get(this.PRTONumber).getName() + lineReturn;
        toReturn = this.AIStrategy == -1 ? toReturn + "AIStrategy: Random" + lineReturn : toReturn + "AIStrategy: " + PRTO.strategyNames[this.AIStrategy] + lineReturn;
        toReturn = toReturn + "x: " + this.x + lineReturn;
        toReturn = toReturn + "y: " + this.y + lineReturn;
        toReturn = toReturn + "PTWCustomName: " + this.PTWCustomName + lineReturn;
        toReturn = toReturn + "useCivilizationKing: " + this.useCivilizationKing + lineReturn;
        toReturn = toReturn + lineReturn;
        return toReturn;
    }

    @Override
    public String toString() {
        String lineReturn = System.getProperty("line.separator");
        String toReturn = "dataLength: " + this.dataLength + lineReturn;
        toReturn = toReturn + "name: " + this.name + lineReturn;
        toReturn = toReturn + "ownerType: " + this.ownerType + lineReturn;
        toReturn = toReturn + "experienceLevel: " + this.experienceLevel + lineReturn;
        toReturn = toReturn + "owner: " + this.owner + lineReturn;
        toReturn = toReturn + "PRTONumber: " + this.PRTONumber + lineReturn;
        toReturn = toReturn + "AIStrategy: " + this.AIStrategy + lineReturn;
        toReturn = toReturn + "x: " + this.x + lineReturn;
        toReturn = toReturn + "y: " + this.y + lineReturn;
        toReturn = toReturn + "PTWCustomName: " + this.PTWCustomName + lineReturn;
        toReturn = toReturn + "useCivilizationKing: " + this.useCivilizationKing + lineReturn;
        toReturn = toReturn + lineReturn;
        return toReturn;
    }

    @Override
    public String compareTo(BIQSection section, String separator) {
        if (!(section instanceof UNIT)) {
            return null;
        }
        UNIT two = (UNIT)section;
        String lineReturn = System.getProperty("line.separator");
        String toReturn = "name: " + this.name + lineReturn;
        if (this.dataLength != two.getDataLength()) {
            toReturn = toReturn + "DataLength: " + this.dataLength + separator + two.getDataLength() + lineReturn;
        }
        if (this.name.compareTo(two.getName()) != 0) {
            toReturn = toReturn + "Name: " + this.name + separator + two.getName() + lineReturn;
        }
        if (this.ownerType != two.getOwnerType()) {
            toReturn = toReturn + "OwnerType: " + this.ownerType + separator + two.getOwnerType() + lineReturn;
        }
        if (this.experienceLevel != two.getExperienceLevel()) {
            toReturn = toReturn + "ExperienceLevel: " + this.experienceLevel + separator + two.getExperienceLevel() + lineReturn;
        }
        if (this.owner != two.getOwner()) {
            toReturn = toReturn + "Owner: " + this.owner + separator + two.getOwner() + lineReturn;
        }
        if (this.PRTONumber != two.getPRTONumber()) {
            toReturn = toReturn + "PRTONumber: " + this.PRTONumber + separator + two.getPRTONumber() + lineReturn;
        }
        if (this.AIStrategy != two.getAIStrategy()) {
            toReturn = toReturn + "AIStrategy: " + this.AIStrategy + separator + two.getAIStrategy() + lineReturn;
        }
        if (this.x != two.getX()) {
            toReturn = toReturn + "X: " + this.x + separator + two.getX() + lineReturn;
        }
        if (this.y != two.getY()) {
            toReturn = toReturn + "Y: " + this.y + separator + two.getY() + lineReturn;
        }
        if (this.PTWCustomName.compareTo(two.getPTWCustomName()) != 0) {
            toReturn = toReturn + "PTWCustomName: " + this.PTWCustomName + separator + two.getPTWCustomName() + lineReturn;
        }
        if (this.useCivilizationKing != two.getUseCivilizationKing()) {
            toReturn = toReturn + "UseCivilizationKing: " + this.useCivilizationKing + separator + two.getUseCivilizationKing() + lineReturn;
        }
        return toReturn;
    }

    @Override
    public Object getProperty(String string) throws UnsupportedOperationException {
        if (string.equals("Name")) {
            return this.name;
        }
        throw new UnsupportedOperationException();
    }

    public UNIT clone() {
        UNIT other = new UNIT(this.baseLink);
        other.setAIStrategy(this.AIStrategy);
        other.setPRTONumber(this.PRTONumber);
        other.setPTWCustomName(new String(this.PTWCustomName));
        other.setDataLength(this.dataLength);
        other.setExperienceLevel(this.experienceLevel);
        other.setName(new String(this.name));
        other.setOwner(this.owner);
        other.setOwnerType(this.ownerType);
        other.setUseCivilizationKing(this.useCivilizationKing);
        other.setX(this.x);
        other.setY(this.y);
        return other;
    }
}

