/*
 * Decompiled with CFR 0.152.
 */
package com.civfanatics.civ3.pediaIcons;

import com.civfanatics.civ3.pediaIcons.PediaFileSection;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;

public class PediaIconsFile {
    List<PediaFileSection> fileSections = new ArrayList<PediaFileSection>();
    Map<String, String> smallIcons = new HashMap<String, String>();
    Map<String, String> largeIcons = new HashMap<String, String>();

    public void parseFile(String fileName) throws FileNotFoundException {
        Scanner s = new Scanner(new File(fileName));
        block0: while (s.hasNextLine()) {
            String nextLine = s.nextLine();
            if (nextLine.startsWith("#TECH")) {
                String techEntry = s.nextLine();
                if (nextLine.endsWith("_LARGE")) {
                    this.largeIcons.put(nextLine.substring(1, nextLine.length() - 6), techEntry);
                    continue;
                }
                this.smallIcons.put(nextLine.substring(1), techEntry);
                continue;
            }
            if (!nextLine.startsWith("#start resources")) continue;
            while (true) {
                String key = s.nextLine();
                while (key.isEmpty()) {
                    key = s.nextLine();
                }
                if (key.equals("#End Resources")) continue block0;
                String largeLine = s.nextLine();
                String smallLine = s.nextLine();
                this.largeIcons.put(key.substring(6), largeLine);
                this.smallIcons.put(key.substring(6), smallLine);
            }
        }
    }

    public String getIconFileName(String entryName, boolean large) {
        if (large) {
            return this.largeIcons.get(entryName);
        }
        return this.smallIcons.get(entryName);
    }

    static enum NextLineMode {
        REGULAR,
        TECH;

    }
}

