/*
 * Decompiled with CFR 0.152.
 */
package com.civfanatics.civ3.ruleModifier.ui;

import com.civfanatics.civ3.xplatformeditor.FileExtensionFilter;
import com.civfanatics.civ3.xplatformeditor.FileIO;
import com.civfanatics.civ3.xplatformeditor.Main;
import com.civfanatics.civ3.xplatformeditor.savFunctionality.SavPatcher;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import org.apache.log4j.Logger;

public class RuleChangeApplierController
implements Initializable {
    static Logger logger = Logger.getLogger(RuleChangeApplierController.class);
    FileExtensionFilter savFilter = null;
    FileExtensionFilter[] saveFilters = null;
    FileExtensionFilter scenarioFileFilter = null;
    FileExtensionFilter bicFilter = null;
    FileExtensionFilter biqFilter = null;
    String[] acceptedExtensions = new String[]{"biq"};
    @FXML
    private Button cmdApplyNewRules;
    @FXML
    private Button cmdSelectSAV;
    @FXML
    private Button cmdSelectBIQ;
    @FXML
    private Label lblInstructions;
    @FXML
    private Label lblRulesApplied;
    @FXML
    private TextField txtSelectedSAV;
    @FXML
    private TextField txtSelectedBIQ;
    @FXML
    private CheckBox chkReplaceCitizens;
    @FXML
    private CheckBox chkReplaceRules;
    @FXML
    private CheckBox chkReplaceCivs;
    @FXML
    private CheckBox chkReplaceTerrains;
    private final String instructions = "This functionality allows you to replace sections of the rules in a SAV with rules from an updated BIQ.  This can be used in a scenario to allow, for example, barbarians to become more advanced over time, or the output of tiles to change over time.  \nThis functionality is not yet 'smart', meaning it should only be used with BIQs that do not add or remove items from BIQ sections.\nYou should also only use this functionality as advised by the scenario designer - combining random BIQs and SAVs is likely to produce unusable results.\nThis operation will render the .sav ineligible for the Hall of Fame, due to the change in rules.";

    public void initialize(URL url, ResourceBundle rb) {
        this.lblInstructions.setText("This functionality allows you to replace sections of the rules in a SAV with rules from an updated BIQ.  This can be used in a scenario to allow, for example, barbarians to become more advanced over time, or the output of tiles to change over time.  \nThis functionality is not yet 'smart', meaning it should only be used with BIQs that do not add or remove items from BIQ sections.\nYou should also only use this functionality as advised by the scenario designer - combining random BIQs and SAVs is likely to produce unusable results.\nThis operation will render the .sav ineligible for the Hall of Fame, due to the change in rules.");
    }

    @FXML
    private void selectSAVFile() {
        String[] biqExtension = new String[]{"sav", "SAV"};
        if (this.savFilter == null) {
            this.savFilter = new FileExtensionFilter(biqExtension, "SAV files");
            this.saveFilters = new FileExtensionFilter[1];
            this.saveFilters[0] = this.savFilter;
        }
        try {
            File savFile = FileIO.getFile(0, false, this.saveFilters, null, true);
            if (savFile != null) {
                this.txtSelectedSAV.setText(savFile.getCanonicalPath());
            }
        }
        catch (IOException ex) {
            logger.error("IOException for selecting SAV file");
        }
    }

    @FXML
    private void selectBIQFile() {
        if (this.bicFilter == null) {
            String[] bic = new String[]{"bic"};
            String[] biq = new String[]{"biq"};
            this.bicFilter = new FileExtensionFilter(bic, Main.i18n("save.bicFiles"));
            this.biqFilter = new FileExtensionFilter(biq, Main.i18n("save.biqFiles"));
            this.scenarioFileFilter = new FileExtensionFilter(this.acceptedExtensions, Main.i18n("save.allScenarioFiles"));
        }
        FileExtensionFilter[] filters = new FileExtensionFilter[]{this.bicFilter, this.biqFilter, this.scenarioFileFilter};
        try {
            File file = FileIO.getFile(0, false, filters, null, true);
            if (file != null) {
                this.txtSelectedBIQ.setText(file.getCanonicalPath());
            }
        }
        catch (IOException ex) {
            logger.error("IOException", ex);
        }
    }

    @FXML
    private void applyNewRules() {
        logger.info("Applying new rules");
        try {
            File savFile = new File(this.txtSelectedSAV.getText());
            File biqFile = new File(this.txtSelectedBIQ.getText());
            ArrayList<String> sectionsToReplace = new ArrayList<String>();
            if (this.chkReplaceCivs.isSelected()) {
                sectionsToReplace.add("RACE");
            }
            if (this.chkReplaceRules.isSelected()) {
                sectionsToReplace.add("RULE");
            }
            if (this.chkReplaceTerrains.isSelected()) {
                sectionsToReplace.add("TERR");
            }
            if (this.chkReplaceCitizens.isSelected()) {
                sectionsToReplace.add("CTZN");
            }
            SavPatcher.patchSAVWithNewRuleData(savFile, biqFile, sectionsToReplace);
            this.lblRulesApplied.setVisible(true);
            this.cmdApplyNewRules.setDisable(true);
            logger.info("New rules applied");
        }
        catch (IOException ex) {
            this.lblRulesApplied.setText("An error occurred while patching.  Please check the logs.");
            this.lblRulesApplied.setVisible(true);
        }
    }
}

