/*
 * Decompiled with CFR 0.152.
 */
package com.civfanatics.civ3.savFile;

import com.civfanatics.civ3.biqFile.IO;
import com.civfanatics.civ3.biqFile.util.LittleEndianDataInputStream;
import com.civfanatics.civ3.biqFile.util.LittleEndianDataOutputStream;
import java.io.IOException;

public class EmbeddedRules {
    private String currentCharset = "Windows-1252";
    byte[] header = new byte[4];
    int sectionHeaderLength;
    int biqDataLength;
    byte[] embeddedRulesInfo;
    String searchPath;
    String saveFileName;
    IO embeddedRules;

    public void readEmbeddedRules(LittleEndianDataInputStream in) {
        try {
            in.read(this.header, 0, 4);
            this.sectionHeaderLength = in.readInt();
            this.biqDataLength = in.readInt();
            int embeddedRulesInfoLength = this.sectionHeaderLength - 4;
            this.embeddedRulesInfo = new byte[embeddedRulesInfoLength];
            in.read(this.embeddedRulesInfo, 0, embeddedRulesInfoLength);
            if (embeddedRulesInfoLength == 520) {
                byte[] buffer = new byte[260];
                System.arraycopy(this.embeddedRulesInfo, 0, buffer, 0, 260);
                this.searchPath = new String(buffer, this.currentCharset);
                System.arraycopy(this.embeddedRulesInfo, 260, buffer, 0, 260);
                this.saveFileName = new String(buffer, this.currentCharset);
            }
            LittleEndianDataInputStream[] ins = new LittleEndianDataInputStream[]{in};
            this.embeddedRules = new IO();
            this.embeddedRules.inputBIQ(ins, null, null, true);
        }
        catch (IOException ex) {
            System.err.println("IOException - add improved handling" + ex.getMessage());
        }
    }

    public void outputEmbeddedRules(LittleEndianDataOutputStream out) {
        try {
            out.write(this.header);
            out.writeInt(this.sectionHeaderLength);
            out.writeInt(this.biqDataLength);
            out.write(this.embeddedRulesInfo);
            this.embeddedRules.outputBIQ(out, true);
        }
        catch (IOException ex) {
            System.err.println("IOException - add improved handling" + ex.getMessage());
        }
    }

    public IO getEmbeddedRules() {
        return this.embeddedRules;
    }
}

