/*
 * Decompiled with CFR 0.152.
 */
package com.civfanatics.civ3.savFile;

import com.civfanatics.civ3.biqFile.IO;
import com.civfanatics.civ3.biqFile.util.LittleEndianDataInputStream;
import com.civfanatics.civ3.savFile.IOUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class GameData {
    private String currentCharset = "Windows-1252";
    private int dataLength;
    private int unknown1;
    private int preferences;
    private int rules;
    private int unknown2;
    private int difficulty;
    private int unknown3;
    private int numberOfUnits;
    private int numberOfCities;
    private int numberOfColonies;
    private int nukesUsed;
    private int globalWarmingState;
    private int victoryType;
    private int winner;
    private int unknown4;
    private int turnNumber;
    private int gameYear;
    private int randomSeed;
    private int unknown5;
    private int humanPlayers;
    private int remainingPlayers;
    private int remainingRaces;
    private String unknownString1;
    private byte powerbarCheck;
    private byte megaTrainerXLCheck;
    private String unknownString2;
    private int[] civRanking;
    private int numConts;
    private int numPlayers;
    private int numAirbases;
    private int numVictoryLocations;
    private int numRadarTowers;
    private int numOutposts;
    private int nextPlayerID;
    private byte unknownByte1;
    private String adminPassword;
    private String unknownString3;
    private int victoryPointLimit;
    private int turnLimit;
    private int timePlayed;
    private String unknownString4;
    private int cityEliminationCount;
    private int oneCityCultureWin;
    private int allCitiesCultureWin;
    private int dominationTerrain;
    private int dominationPopulation;
    private int wonderCost;
    private int defeatingOpposingUnitCost;
    private int advancementCost;
    private int cityConquestPopulation;
    private int victoryPointScoring;
    private int capturingSpecialUnit;
    List<Integer> citiesPerContinent;
    List<Integer> knownTechs;
    List<Integer> greatWonderCities;
    List<Byte> greatWonderBuild;
    List<Integer> buildingData1;
    List<Integer> buildingData2;
    List<Integer> prototypeStrategy1;
    List<Integer> prototypeStrategy2;
    List<Integer> techData;
    private IO biqRules;
    static final String lineReturn = System.getProperty("line.separator");

    public void readGameDataSection(LittleEndianDataInputStream in, int majorVersion, int minorVersion, IO biqRules) throws IOException {
        int u;
        int b;
        int t;
        int i;
        this.biqRules = biqRules;
        this.dataLength = in.readInt();
        this.unknown1 = in.readInt();
        this.preferences = in.readInt();
        this.rules = in.readInt();
        this.unknown2 = in.readInt();
        this.difficulty = in.readInt();
        this.unknown3 = in.readInt();
        this.numberOfUnits = in.readInt();
        this.numberOfCities = in.readInt();
        this.numberOfColonies = in.readInt();
        this.nukesUsed = in.readInt();
        this.globalWarmingState = in.readInt();
        this.victoryType = in.readInt();
        this.winner = in.readInt();
        this.unknown4 = in.readInt();
        this.turnNumber = in.readInt();
        this.gameYear = in.readInt();
        this.randomSeed = in.readInt();
        this.unknown5 = in.readInt();
        this.humanPlayers = in.readInt();
        this.remainingPlayers = in.readInt();
        this.remainingRaces = in.readInt();
        this.unknownString1 = IOUtils.importString(in, 24, this.currentCharset);
        this.powerbarCheck = in.readByte();
        this.megaTrainerXLCheck = in.readByte();
        this.unknownString2 = IOUtils.importString(in, 54, this.currentCharset);
        this.civRanking = new int[32];
        for (i = 0; i < 32; ++i) {
            this.civRanking[i] = in.readInt();
        }
        this.numConts = in.readInt();
        this.numPlayers = in.readInt();
        if (majorVersion >= 18) {
            this.numAirbases = in.readInt();
            this.numVictoryLocations = in.readInt();
            this.numRadarTowers = in.readInt();
            this.numOutposts = in.readInt();
            this.nextPlayerID = in.readInt();
            this.unknownByte1 = in.readByte();
            if (minorVersion >= 6 || majorVersion > 18) {
                this.adminPassword = IOUtils.importString(in, 228, this.currentCharset);
                this.unknownString3 = IOUtils.importString(in, 39, this.currentCharset);
                this.victoryPointLimit = in.readInt();
                this.turnLimit = in.readInt();
                this.timePlayed = in.readInt();
            }
        }
        if (majorVersion >= 24 && (minorVersion >= 8 || majorVersion > 25)) {
            this.unknownString4 = IOUtils.importString(in, 204, this.currentCharset);
            this.cityEliminationCount = in.readInt();
            this.oneCityCultureWin = in.readInt();
            this.allCitiesCultureWin = in.readInt();
            this.dominationTerrain = in.readInt();
            this.dominationPopulation = in.readInt();
            this.wonderCost = in.readInt();
            this.defeatingOpposingUnitCost = in.readInt();
            this.advancementCost = in.readInt();
            this.cityConquestPopulation = in.readInt();
            this.victoryPointScoring = in.readInt();
            this.capturingSpecialUnit = in.readInt();
        }
        this.citiesPerContinent = new ArrayList<Integer>(this.numConts);
        for (i = 0; i < this.numConts; ++i) {
            this.citiesPerContinent.add(in.readInt());
        }
        this.knownTechs = new ArrayList<Integer>(biqRules.technology.size());
        for (t = 0; t < biqRules.technology.size(); ++t) {
            this.knownTechs.add(in.readInt());
        }
        this.greatWonderCities = new ArrayList<Integer>(biqRules.buildings.size());
        for (b = 0; b < biqRules.buildings.size(); ++b) {
            this.greatWonderCities.add(in.readInt());
        }
        this.greatWonderBuild = new ArrayList<Byte>(biqRules.buildings.size());
        for (b = 0; b < biqRules.buildings.size(); ++b) {
            this.greatWonderBuild.add(in.readByte());
        }
        this.buildingData1 = new ArrayList<Integer>(biqRules.buildings.size());
        for (b = 0; b < biqRules.buildings.size(); ++b) {
            this.buildingData1.add(in.readInt());
        }
        this.buildingData2 = new ArrayList<Integer>(biqRules.buildings.size());
        for (b = 0; b < biqRules.buildings.size(); ++b) {
            this.buildingData2.add(in.readInt());
        }
        this.prototypeStrategy1 = new ArrayList<Integer>(biqRules.getNumFiraxisUnits());
        for (u = 0; u < biqRules.getNumFiraxisUnits(); ++u) {
            this.prototypeStrategy1.add(in.readInt());
        }
        this.prototypeStrategy2 = new ArrayList<Integer>(biqRules.getNumFiraxisUnits());
        for (u = 0; u < biqRules.getNumFiraxisUnits(); ++u) {
            this.prototypeStrategy2.add(in.readInt());
        }
        this.techData = new ArrayList<Integer>(biqRules.technology.size());
        for (t = 0; t < biqRules.technology.size(); ++t) {
            this.techData.add(in.readInt());
        }
    }

    public String toEnglish() {
        int i;
        StringBuilder sb = new StringBuilder();
        this.sbAppend(sb, "Number of CONTs: " + this.numConts);
        this.sbAppend(sb, "Number of players: " + this.numPlayers);
        this.sbAppend(sb, "Begin save version 18 items");
        this.sbAppend(sb, "Number of airbases: " + this.numAirbases);
        this.sbAppend(sb, "Number of VP Locations: " + this.numVictoryLocations);
        this.sbAppend(sb, "Number of radar towers: " + this.numRadarTowers);
        this.sbAppend(sb, "Number of outposts: " + this.numOutposts);
        this.sbAppend(sb, "ID of next player (MP): " + this.nextPlayerID);
        this.sbAppend(sb, "Unknown byte: " + this.unknownByte1);
        this.sbAppend(sb, "Begin save version 18.06 items");
        this.sbAppend(sb, "Admin password: " + this.adminPassword);
        this.sbAppend(sb, "Unknown string (39): " + this.unknownString3);
        this.sbAppend(sb, "VP Limit: " + this.victoryPointLimit);
        this.sbAppend(sb, "Turn limit: " + this.turnLimit);
        this.sbAppend(sb, "Time played: " + this.timePlayed / 60000 + " minutes");
        this.sbAppend(sb, "Begin save version 24.8 items");
        this.sbAppend(sb, "Unknown String (204): " + this.unknownString4);
        this.sbAppend(sb, "City elimination count: " + this.cityEliminationCount);
        this.sbAppend(sb, "One-city culture win: " + this.oneCityCultureWin);
        this.sbAppend(sb, "All cities culture win: " + this.allCitiesCultureWin);
        this.sbAppend(sb, "Domination terrain: " + this.dominationTerrain);
        this.sbAppend(sb, "Wonder cost: " + this.wonderCost);
        this.sbAppend(sb, "Defeat opposing unit cost: " + this.defeatingOpposingUnitCost);
        this.sbAppend(sb, "Advancement cost: " + this.advancementCost);
        this.sbAppend(sb, "City conquest population: " + this.cityConquestPopulation);
        this.sbAppend(sb, "Victory point scoring: " + this.victoryPointScoring);
        this.sbAppend(sb, "Capturing special unit: " + this.capturingSpecialUnit);
        this.sbAppend(sb, "---- DATA AREA ---");
        this.sbAppend(sb, "-> Cities per continent");
        for (i = 0; i < this.citiesPerContinent.size(); ++i) {
            this.sbAppend(sb, this.citiesPerContinent.get(i).toString());
        }
        this.sbAppend(sb, "-> Known techs");
        for (i = 0; i < this.knownTechs.size(); ++i) {
            this.sbAppend(sb, this.biqRules.technology.get(i).getName() + ": " + this.knownTechs.get(i));
        }
        this.sbAppend(sb, "-> Great Wonder Cities");
        for (i = 0; i < this.greatWonderCities.size(); ++i) {
            this.sbAppend(sb, this.biqRules.buildings.get(i).getName() + ": " + this.greatWonderCities.get(i));
        }
        this.sbAppend(sb, "-> Great Wonder Built");
        for (i = 0; i < this.greatWonderBuild.size(); ++i) {
            this.sbAppend(sb, this.biqRules.buildings.get(i).getName() + ": " + this.greatWonderBuild.get(i));
        }
        this.sbAppend(sb, "-> Building Data 1");
        for (i = 0; i < this.buildingData1.size(); ++i) {
            this.sbAppend(sb, this.biqRules.buildings.get(i).getName() + ": " + this.buildingData1.get(i));
        }
        this.sbAppend(sb, "-> Building Data 2");
        for (i = 0; i < this.buildingData2.size(); ++i) {
            this.sbAppend(sb, this.biqRules.buildings.get(i).getName() + ": " + this.buildingData2.get(i));
        }
        this.sbAppend(sb, "-> Prototype Strategy 1");
        for (i = 0; i < this.prototypeStrategy1.size(); ++i) {
            this.sbAppend(sb, this.prototypeStrategy1.get(i).toString());
        }
        this.sbAppend(sb, "-> Prototype Strategy 2");
        for (i = 0; i < this.prototypeStrategy2.size(); ++i) {
            this.sbAppend(sb, this.prototypeStrategy2.get(i).toString());
        }
        this.sbAppend(sb, "-> Tech Data");
        for (i = 0; i < this.techData.size(); ++i) {
            this.sbAppend(sb, this.biqRules.technology.get(i).getName() + ": " + this.techData.get(i));
        }
        return sb.toString();
    }

    private void sbAppend(StringBuilder sb, String string) {
        sb.append(string).append(lineReturn);
    }

    public int getDataLength() {
        return this.dataLength;
    }

    public void setDataLength(int dataLength) {
        this.dataLength = dataLength;
    }

    public int getUnknown1() {
        return this.unknown1;
    }

    public void setUnknown1(int unknown1) {
        this.unknown1 = unknown1;
    }

    public int getPreferences() {
        return this.preferences;
    }

    public void setPreferences(int preferences) {
        this.preferences = preferences;
    }

    public int getRules() {
        return this.rules;
    }

    public void setRules(int rules) {
        this.rules = rules;
    }

    public int getUnknown2() {
        return this.unknown2;
    }

    public void setUnknown2(int unknown2) {
        this.unknown2 = unknown2;
    }

    public int getDifficulty() {
        return this.difficulty;
    }

    public void setDifficulty(int difficulty) {
        this.difficulty = difficulty;
    }

    public int getUnknown3() {
        return this.unknown3;
    }

    public void setUnknown3(int unknown3) {
        this.unknown3 = unknown3;
    }

    public int getNumberOfUnits() {
        return this.numberOfUnits;
    }

    public void setNumberOfUnits(int numberOfUnits) {
        this.numberOfUnits = numberOfUnits;
    }

    public int getNumberOfCities() {
        return this.numberOfCities;
    }

    public void setNumberOfCities(int numberOfCities) {
        this.numberOfCities = numberOfCities;
    }

    public int getNumberOfColonies() {
        return this.numberOfColonies;
    }

    public void setNumberOfColonies(int numberOfColonies) {
        this.numberOfColonies = numberOfColonies;
    }

    public int getNukesUsed() {
        return this.nukesUsed;
    }

    public void setNukesUsed(int nukesUsed) {
        this.nukesUsed = nukesUsed;
    }

    public int getGlobalWarmingState() {
        return this.globalWarmingState;
    }

    public void setGlobalWarmingState(int globalWarmingState) {
        this.globalWarmingState = globalWarmingState;
    }

    public int getVictoryType() {
        return this.victoryType;
    }

    public void setVictoryType(int victoryType) {
        this.victoryType = victoryType;
    }

    public int getWinner() {
        return this.winner;
    }

    public void setWinner(int winner) {
        this.winner = winner;
    }

    public int getUnknown4() {
        return this.unknown4;
    }

    public void setUnknown4(int unknown4) {
        this.unknown4 = unknown4;
    }

    public int getTurnNumber() {
        return this.turnNumber;
    }

    public void setTurnNumber(int turnNumber) {
        this.turnNumber = turnNumber;
    }

    public int getGameYear() {
        return this.gameYear;
    }

    public void setGameYear(int gameYear) {
        this.gameYear = gameYear;
    }

    public int getRandomSeed() {
        return this.randomSeed;
    }

    public void setRandomSeed(int randomSeed) {
        this.randomSeed = randomSeed;
    }

    public int getUnknown5() {
        return this.unknown5;
    }

    public void setUnknown5(int unknown5) {
        this.unknown5 = unknown5;
    }

    public int getHumanPlayers() {
        return this.humanPlayers;
    }

    public void setHumanPlayers(int humanPlayers) {
        this.humanPlayers = humanPlayers;
    }

    public int getRemainingPlayers() {
        return this.remainingPlayers;
    }

    public void setRemainingPlayers(int remainingPlayers) {
        this.remainingPlayers = remainingPlayers;
    }

    public int getRemainingRaces() {
        return this.remainingRaces;
    }

    public void setRemainingRaces(int remainingRaces) {
        this.remainingRaces = remainingRaces;
    }

    public String getUnknownString1() {
        return this.unknownString1;
    }

    public void setUnknownString1(String unknownString1) {
        this.unknownString1 = unknownString1;
    }

    public byte getPowerbarCheck() {
        return this.powerbarCheck;
    }

    public void setPowerbarCheck(byte powerbarCheck) {
        this.powerbarCheck = powerbarCheck;
    }

    public byte getMegaTrainerXLCheck() {
        return this.megaTrainerXLCheck;
    }

    public void setMegaTrainerXLCheck(byte megaTrainerXLCheck) {
        this.megaTrainerXLCheck = megaTrainerXLCheck;
    }

    public String getUnknownString2() {
        return this.unknownString2;
    }

    public void setUnknownString2(String unknownString2) {
        this.unknownString2 = unknownString2;
    }

    public int[] getCivRanking() {
        return this.civRanking;
    }

    public void setCivRanking(int[] civRanking) {
        this.civRanking = civRanking;
    }

    public int getNumConts() {
        return this.numConts;
    }

    public void setNumConts(int numConts) {
        this.numConts = numConts;
    }

    public int getNumPlayers() {
        return this.numPlayers;
    }

    public void setNumPlayers(int numPlayers) {
        this.numPlayers = numPlayers;
    }

    public int getNumAirbases() {
        return this.numAirbases;
    }

    public void setNumAirbases(int numAirbases) {
        this.numAirbases = numAirbases;
    }

    public int getNumVictoryLocations() {
        return this.numVictoryLocations;
    }

    public void setNumVictoryLocations(int numVictoryLocations) {
        this.numVictoryLocations = numVictoryLocations;
    }

    public int getNumRadarTowers() {
        return this.numRadarTowers;
    }

    public void setNumRadarTowers(int numRadarTowers) {
        this.numRadarTowers = numRadarTowers;
    }

    public int getNumOutposts() {
        return this.numOutposts;
    }

    public void setNumOutposts(int numOutposts) {
        this.numOutposts = numOutposts;
    }

    public int getNextPlayerID() {
        return this.nextPlayerID;
    }

    public void setNextPlayerID(int nextPlayerID) {
        this.nextPlayerID = nextPlayerID;
    }

    public byte getUnknownByte1() {
        return this.unknownByte1;
    }

    public void setUnknownByte1(byte unknownByte1) {
        this.unknownByte1 = unknownByte1;
    }

    public String getAdminPassword() {
        return this.adminPassword;
    }

    public void setAdminPassword(String adminPassword) {
        this.adminPassword = adminPassword;
    }

    public String getUnknownString3() {
        return this.unknownString3;
    }

    public void setUnknownString3(String unknownString3) {
        this.unknownString3 = unknownString3;
    }

    public int getVictoryPointLimit() {
        return this.victoryPointLimit;
    }

    public void setVictoryPointLimit(int victoryPointLimit) {
        this.victoryPointLimit = victoryPointLimit;
    }

    public int getTurnLimit() {
        return this.turnLimit;
    }

    public void setTurnLimit(int turnLimit) {
        this.turnLimit = turnLimit;
    }

    public int getTimePlayed() {
        return this.timePlayed;
    }

    public void setTimePlayed(int timePlayed) {
        this.timePlayed = timePlayed;
    }

    public String getUnknownString4() {
        return this.unknownString4;
    }

    public void setUnknownString4(String unknownString4) {
        this.unknownString4 = unknownString4;
    }

    public int getCityEliminationCount() {
        return this.cityEliminationCount;
    }

    public void setCityEliminationCount(int cityEliminationCount) {
        this.cityEliminationCount = cityEliminationCount;
    }

    public int getOneCityCultureWin() {
        return this.oneCityCultureWin;
    }

    public void setOneCityCultureWin(int oneCityCultureWin) {
        this.oneCityCultureWin = oneCityCultureWin;
    }

    public int getAllCitiesCultureWin() {
        return this.allCitiesCultureWin;
    }

    public void setAllCitiesCultureWin(int allCitiesCultureWin) {
        this.allCitiesCultureWin = allCitiesCultureWin;
    }

    public int getDominationTerrain() {
        return this.dominationTerrain;
    }

    public void setDominationTerrain(int dominationTerrain) {
        this.dominationTerrain = dominationTerrain;
    }

    public int getDominationPopulation() {
        return this.dominationPopulation;
    }

    public void setDominationPopulation(int dominationPopulation) {
        this.dominationPopulation = dominationPopulation;
    }

    public int getWonderCost() {
        return this.wonderCost;
    }

    public void setWonderCost(int wonderCost) {
        this.wonderCost = wonderCost;
    }

    public int getDefeatingOpposingUnitCost() {
        return this.defeatingOpposingUnitCost;
    }

    public void setDefeatingOpposingUnitCost(int defeatingOpposingUnitCost) {
        this.defeatingOpposingUnitCost = defeatingOpposingUnitCost;
    }

    public int getAdvancementCost() {
        return this.advancementCost;
    }

    public void setAdvancementCost(int advancementCost) {
        this.advancementCost = advancementCost;
    }

    public int getCityConquestPopulation() {
        return this.cityConquestPopulation;
    }

    public void setCityConquestPopulation(int cityConquestPopulation) {
        this.cityConquestPopulation = cityConquestPopulation;
    }

    public int getVictoryPointScoring() {
        return this.victoryPointScoring;
    }

    public void setVictoryPointScoring(int victoryPointScoring) {
        this.victoryPointScoring = victoryPointScoring;
    }

    public int getCapturingSpecialUnit() {
        return this.capturingSpecialUnit;
    }

    public void setCapturingSpecialUnit(int capturingSpecialUnit) {
        this.capturingSpecialUnit = capturingSpecialUnit;
    }

    public List<Integer> getCitiesPerContinent() {
        return this.citiesPerContinent;
    }

    public void setCitiesPerContinent(List<Integer> citiesPerContinent) {
        this.citiesPerContinent = citiesPerContinent;
    }

    public List<Integer> getKnownTechs() {
        return this.knownTechs;
    }

    public void setKnownTechs(List<Integer> knownTechs) {
        this.knownTechs = knownTechs;
    }

    public List<Integer> getGreatWonderCities() {
        return this.greatWonderCities;
    }

    public void setGreatWonderCities(List<Integer> greatWonderCities) {
        this.greatWonderCities = greatWonderCities;
    }

    public List<Byte> getGreatWonderBuild() {
        return this.greatWonderBuild;
    }

    public void setGreatWonderBuild(List<Byte> greatWonderBuild) {
        this.greatWonderBuild = greatWonderBuild;
    }

    public List<Integer> getBuildingData1() {
        return this.buildingData1;
    }

    public void setBuildingData1(List<Integer> buildingData1) {
        this.buildingData1 = buildingData1;
    }

    public List<Integer> getBuildingData2() {
        return this.buildingData2;
    }

    public void setBuildingData2(List<Integer> buildingData2) {
        this.buildingData2 = buildingData2;
    }

    public List<Integer> getPrototypeStrategy1() {
        return this.prototypeStrategy1;
    }

    public void setPrototypeStrategy1(List<Integer> prototypeStrategy1) {
        this.prototypeStrategy1 = prototypeStrategy1;
    }

    public List<Integer> getPrototypeStrategy2() {
        return this.prototypeStrategy2;
    }

    public void setPrototypeStrategy2(List<Integer> prototypeStrategy2) {
        this.prototypeStrategy2 = prototypeStrategy2;
    }

    public List<Integer> getTechData() {
        return this.techData;
    }

    public void setTechData(List<Integer> techData) {
        this.techData = techData;
    }
}

