/*
 * Decompiled with CFR 0.152.
 */
package com.civfanatics.civ3.savFile;

import com.civfanatics.civ3.biqFile.TILE;
import com.civfanatics.civ3.biqFile.civ3Version;
import com.civfanatics.civ3.biqFile.util.LittleEndianDataInputStream;
import java.io.IOException;

public class GameTILE {
    private String header1;
    private int dataLength;
    private byte riverInfo;
    private byte owner;
    private short unknown;
    private int resources;
    private int topUnitID;
    private byte image;
    private byte file;
    private short unknown2;
    private byte overlayBits;
    private byte terrainBits;
    private byte bonusBits;
    private byte riverData;
    private short barbCampID;
    private short cityID;
    private short colonyID;
    private short continent;
    private short unknown3;
    private short unknown4;
    private int hasRuins;
    private String header2;
    private int dataLength2;
    private int overlayBitsC3C;
    private byte unknown5;
    private byte terrainBitsC3C;
    private short unknown6;
    private int bonusBitsC3C;
    private String header3;
    private int dataLength3;
    private int unknown7;
    private String header4;
    private int dataLength4;
    private int exploredBy;
    private int visibleToByUnits;
    private int visibleTo2;
    private int visibleToByCities;
    private int unknown8;
    private short cityWithWorkers;
    private short[] tradeRoutes = new short[32];
    private byte[] bonusBitsArray = new byte[32];
    byte[] unknownBytes = new byte[10];
    byte[] inputFour = new byte[4];

    public TILE toBIQTile() {
        TILE t = new TILE(civ3Version.CONQUESTS);
        t.setRiverConnectionInfo(this.riverInfo);
        t.setBorder(this.riverData);
        t.setImage(this.image);
        t.setFile(this.file);
        t.setQuestionMark(this.unknown);
        t.setOverlays(this.overlayBits);
        t.setBaseRealTerrain(this.terrainBits);
        t.setBonuses(this.bonusBits);
        t.setRiverCrossingData((byte)0);
        t.setBarbarianTribe(this.barbCampID);
        t.setColony(this.colonyID);
        t.setCity(this.cityID);
        t.setContinent(this.continent);
        t.setRuin(this.hasRuins);
        t.setC3COverlays(this.overlayBitsC3C);
        t.setQuestionMark3((byte)(this.unknown3 & 0xFF));
        t.setC3CBaseRealTerrain(this.terrainBitsC3C);
        t.setQuestionMark4(this.unknown4);
        t.setC3CBonuses(this.bonusBitsC3C);
        t.setQuestionMark5(this.unknown5);
        return t;
    }

    public void readDataSection(LittleEndianDataInputStream in) throws IOException {
        int i;
        in.read(this.inputFour, 0, 4);
        this.header1 = new String(this.inputFour, "Windows-1252");
        assert ("TILE".equals(this.header1));
        this.dataLength = in.readInt();
        this.riverInfo = in.readByte();
        this.owner = in.readByte();
        this.unknown = in.readShort();
        this.resources = in.readInt();
        this.topUnitID = in.readInt();
        this.image = in.readByte();
        this.file = in.readByte();
        this.unknown2 = in.readShort();
        this.overlayBits = in.readByte();
        this.terrainBits = in.readByte();
        this.bonusBits = in.readByte();
        this.riverData = in.readByte();
        this.barbCampID = in.readShort();
        this.cityID = in.readShort();
        this.colonyID = in.readShort();
        this.continent = in.readShort();
        this.unknown3 = in.readShort();
        this.unknown4 = in.readShort();
        this.hasRuins = in.readInt();
        in.read(this.inputFour, 0, 4);
        this.header2 = new String(this.inputFour, "Windows-1252");
        assert ("TILE".equals(this.header2));
        this.dataLength2 = in.readInt();
        this.overlayBitsC3C = in.readInt();
        this.unknown5 = in.readByte();
        this.terrainBitsC3C = in.readByte();
        this.unknown6 = in.readShort();
        this.bonusBitsC3C = in.readInt();
        in.read(this.inputFour, 0, 4);
        this.header3 = new String(this.inputFour, "Windows-1252");
        assert ("TILE".equals(this.header3));
        this.dataLength3 = in.readInt();
        this.unknown7 = in.readInt();
        in.read(this.inputFour, 0, 4);
        this.header4 = new String(this.inputFour, "Windows-1252");
        assert ("TILE".equals(this.header4));
        this.dataLength4 = in.readInt();
        this.exploredBy = in.readInt();
        this.visibleToByUnits = in.readInt();
        this.visibleTo2 = in.readInt();
        this.visibleToByCities = in.readInt();
        this.unknown8 = in.readInt();
        this.cityID = in.readShort();
        for (i = 0; i < 32; ++i) {
            this.tradeRoutes[i] = in.readShort();
        }
        for (i = 0; i < 32; ++i) {
            this.bonusBitsArray[i] = in.readByte();
        }
        for (i = 0; i < 10; ++i) {
            this.unknownBytes[i] = in.readByte();
        }
    }
}

