/*
 * Decompiled with CFR 0.152.
 */
package com.civfanatics.civ3.savFile;

import com.civfanatics.civ3.biqFile.util.LittleEndianDataInputStream;
import com.civfanatics.civ3.savFile.HistTurn;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;

public class HIST {
    private String header;
    private int turnCount;
    private int dataLengthOrWhichLeadsArePresent;
    private List<HistTurn> turns;
    byte[] inputFour = new byte[4];

    public void readDataSection(LittleEndianDataInputStream in) throws IOException {
        in.read(this.inputFour, 0, 4);
        this.header = new String(this.inputFour, "Windows-1252");
        this.turnCount = in.readInt();
        this.dataLengthOrWhichLeadsArePresent = in.readInt();
        this.turns = new ArrayList<HistTurn>(this.turnCount);
        for (int i = 0; i < this.turnCount; ++i) {
            HistTurn newTurn = new HistTurn();
            newTurn.setTurnNumber(in.readInt());
            newTurn.setDate(in.readInt());
            int remainingCivCount = in.readInt();
            newTurn.setRemainingCivs(remainingCivCount);
            ArrayList<Integer> civIDs = new ArrayList<Integer>();
            for (int c = 0; c < remainingCivCount; ++c) {
                civIDs.add(in.readInt());
            }
            newTurn.setCivIds(civIDs);
            ArrayList<Integer> power = new ArrayList<Integer>();
            for (int c = 0; c < remainingCivCount; ++c) {
                power.add(in.readInt());
            }
            newTurn.setPower(power);
            ArrayList<Integer> score = new ArrayList<Integer>();
            for (int c = 0; c < remainingCivCount; ++c) {
                score.add(in.readInt());
            }
            newTurn.setScore(score);
            ArrayList<Integer> culture = new ArrayList<Integer>();
            for (int c = 0; c < remainingCivCount; ++c) {
                culture.add(in.readInt());
            }
            newTurn.setCulture(culture);
            this.turns.add(newTurn);
        }
    }

    public List<Integer> getHistographScoresForPlayer(int playerID, BiFunction<HistTurn, Integer, Integer> scoreComponentFunction) {
        ArrayList<Integer> power = new ArrayList<Integer>(this.turns.size());
        for (HistTurn turn : this.turns) {
            int playerIdInTurn = 0;
            boolean foundPlayer = false;
            for (playerIdInTurn = 0; playerIdInTurn < turn.getCivIds().size(); ++playerIdInTurn) {
                if (turn.getCivIds().get(playerIdInTurn) != playerID) continue;
                foundPlayer = true;
                break;
            }
            if (foundPlayer) {
                power.add(scoreComponentFunction.apply(turn, playerIdInTurn));
                continue;
            }
            power.add(0);
        }
        return power;
    }

    public int getNumTurns() {
        return this.turns.size();
    }
}

