/*
 * Decompiled with CFR 0.152.
 */
package com.civfanatics.civ3.savFile;

import com.civfanatics.civ3.biqFile.CITY;
import com.civfanatics.civ3.biqFile.IO;
import com.civfanatics.civ3.biqFile.util.LittleEndianDataInputStream;
import com.civfanatics.civ3.biqFile.util.LittleEndianDataOutputStream;
import com.civfanatics.civ3.savFile.CNSL;
import com.civfanatics.civ3.savFile.CONT;
import com.civfanatics.civ3.savFile.DATE;
import com.civfanatics.civ3.savFile.EmbeddedRules;
import com.civfanatics.civ3.savFile.EndOfCITYException;
import com.civfanatics.civ3.savFile.GameData;
import com.civfanatics.civ3.savFile.GameTILE;
import com.civfanatics.civ3.savFile.HIST;
import com.civfanatics.civ3.savFile.HeaderException;
import com.civfanatics.civ3.savFile.PALV;
import com.civfanatics.civ3.savFile.PLGI;
import com.civfanatics.civ3.savFile.SavCITY;
import com.civfanatics.civ3.savFile.SavCLNY;
import com.civfanatics.civ3.savFile.SavLEAD;
import com.civfanatics.civ3.savFile.SavUNIT;
import com.civfanatics.civ3.savFile.SavVERSION;
import com.civfanatics.civ3.savFile.WRLD;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;

public class SAV {
    private String currentCharset = "Windows-1252";
    String header;
    short magicShort;
    int majorVersion;
    int minorVersion;
    byte[] random16Bytes = new byte[16];
    String random16;
    EmbeddedRules embeddedRules = new EmbeddedRules();
    GameData gameData = new GameData();
    DATE[] dates = new DATE[3];
    PLGI[] plgis = new PLGI[2];
    CNSL cnsl = new CNSL();
    WRLD world = new WRLD();
    GameTILE[] tiles;
    CONT[] continents;
    private int[] goodCounts;
    public SavLEAD[] players;
    SavUNIT[] savUnits;
    List<SavCITY> firaxisCities = new ArrayList<SavCITY>();
    List<SavCITY> realCities = new ArrayList<SavCITY>();
    byte[] zerosBeforePALV = new byte[256];
    List<PALV> palaceViews = new ArrayList<PALV>();
    public HIST histograph = new HIST();
    int lengthOfRemainingBytes = 0;
    byte[] allTheThings;
    public byte[] inputFour = new byte[4];
    public byte[] inputSixteen = new byte[16];
    public byte[] inputTwentyFour = new byte[24];
    public byte[] inputThirtyTwo = new byte[32];
    public byte[] inputForty = new byte[40];
    public byte[] inputFiftySeven;
    public byte[] inputSixtyFour;
    public byte[] inputOneHundredTwentyEight;
    public byte[] inputTwoFiftySix;
    public byte[] inputTwoSixty;
    public byte[] inputSixForty;
    public byte[] inputFiftyTwoHundred;
    Logger logger = Logger.getLogger(this.getClass());
    int NUM_PALV_PLAYERS = 32;
    static int numProcs = 1;
    int dataInputted;

    public boolean inputSAV(File file) {
        return this.inputSAV(file, false);
    }

    public boolean inputSAV(File file, boolean alreadyDecompressed) {
        this.dataInputted = 0;
        try {
            LittleEndianDataInputStream inFile = new LittleEndianDataInputStream(new BufferedInputStream(new FileInputStream(file)));
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Size of file:     " + (int)file.length());
                long maxMem = Runtime.getRuntime().maxMemory();
                this.logger.debug("Max size of heap: " + maxMem);
            }
            byte[] buffer = new byte[(int)file.length()];
            inFile.readFully(buffer);
            inFile.close();
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Number of available processors: " + Runtime.getRuntime().availableProcessors() + "; using " + numProcs + " processors");
            }
            LittleEndianDataInputStream[] ins = new LittleEndianDataInputStream[numProcs];
            return this.inputSAV(ins, buffer, file, alreadyDecompressed);
        }
        catch (IOException ex) {
            this.logger.error("Error when reading from file into buffer", ex);
            return false;
        }
    }

    private boolean inputSAV(LittleEndianDataInputStream[] ins, byte[] buffer, File file, boolean alreadyDecompressed) {
        long start = System.nanoTime();
        long fileLength = file.length();
        try {
            int i;
            int i2;
            int i3;
            for (int i4 = 0; i4 < ins.length; ++i4) {
                ins[i4] = new LittleEndianDataInputStream(new ByteArrayInputStream(buffer));
            }
            ins[0].read(this.inputFour, 0, 4);
            this.dataInputted += 4;
            String temp = new String(this.inputFour, this.currentCharset);
            if (!temp.contains("CIV3")) {
                if (alreadyDecompressed) {
                    this.logger.error("Cannot read decompressed file " + file.getName());
                    return false;
                }
                this.logger.info("Detected compressed file");
                String[] decomQuery = new String[]{"java", "-jar", "./bin/BIQDecompressor.jar", file.getCanonicalPath(), "._tmp.sav"};
                Process dcp = Runtime.getRuntime().exec(decomQuery);
                dcp.waitFor();
                return this.inputSAV(new File("._tmp.sav"), true);
            }
            this.header = temp;
            this.magicShort = ins[0].readShort();
            this.dataInputted += 2;
            this.majorVersion = ins[0].readInt();
            this.dataInputted += 4;
            if (this.majorVersion >= 17) {
                this.minorVersion = ins[0].readInt();
                if (this.minorVersion >= 7) {
                    ins[0].read(this.inputSixteen, 0, 16);
                    this.dataInputted += 16;
                    this.random16 = new String(this.inputSixteen, this.currentCharset);
                }
            }
            int bytesBeforeBICs = this.dataInputted;
            for (int i5 = 1; i5 < ins.length; ++i5) {
                ins[i5].skipBytes(this.dataInputted);
            }
            this.embeddedRules.readEmbeddedRules(ins[0]);
            ins[0].read(this.inputFour, 0, 4);
            String sectionHeader = new String(this.inputFour, this.currentCharset);
            if (sectionHeader.equals("GAME")) {
                try {
                    this.gameData.readGameDataSection(ins[0], this.majorVersion, this.minorVersion, this.embeddedRules.embeddedRules);
                }
                catch (IOException ex) {
                    this.logger.error("IOException during GAME", ex);
                }
            } else {
                this.logger.error("GAME header is missing; instead read " + sectionHeader);
            }
            ins[0].read(this.inputFour, 0, 4);
            sectionHeader = new String(this.inputFour, this.currentCharset);
            if (sectionHeader.equals("DATE")) {
                try {
                    this.dates[0] = new DATE();
                    this.dates[0].readDataSection(ins[0]);
                }
                catch (IOException ex) {
                    this.logger.error("IOException during DATE", ex);
                    this.logger.error("Bytes read: " + ins[0].numBytesRead);
                }
            } else {
                this.logger.error("DATE header is missing; instead read " + sectionHeader);
            }
            ins[0].read(this.inputFour, 0, 4);
            sectionHeader = new String(this.inputFour, this.currentCharset);
            if (sectionHeader.equals("PLGI")) {
                try {
                    this.plgis[0] = new PLGI();
                    this.plgis[0].readDataSection(ins[0]);
                }
                catch (IOException ex) {
                    this.logger.error("IOException during PLGI", ex);
                }
            } else {
                this.logger.error("PLGI header is missing; instead read " + sectionHeader);
            }
            ins[0].read(this.inputFour, 0, 4);
            sectionHeader = new String(this.inputFour, this.currentCharset);
            if (sectionHeader.equals("PLGI")) {
                try {
                    this.plgis[1] = new PLGI();
                    this.plgis[1].readDataSection(ins[0]);
                }
                catch (IOException ex) {
                    this.logger.error("IOException during PLGI", ex);
                }
            } else {
                this.logger.error("PLGI header is missing; instead read " + sectionHeader);
            }
            ins[0].read(this.inputFour, 0, 4);
            sectionHeader = new String(this.inputFour, this.currentCharset);
            if (sectionHeader.equals("DATE")) {
                try {
                    this.dates[1] = new DATE();
                    this.dates[1].readDataSection(ins[0]);
                }
                catch (IOException ex) {
                    this.logger.error("IOException during DATE", ex);
                }
            } else {
                this.logger.error("DATE header is missing; instead read " + sectionHeader);
            }
            ins[0].read(this.inputFour, 0, 4);
            sectionHeader = new String(this.inputFour, this.currentCharset);
            if (sectionHeader.equals("DATE")) {
                try {
                    this.dates[2] = new DATE();
                    this.dates[2].readDataSection(ins[0]);
                }
                catch (IOException ex) {
                    this.logger.error("IOException during DATE", ex);
                }
            } else {
                this.logger.error("DATE header is missing; instead read " + sectionHeader);
            }
            ins[0].read(this.inputFour, 0, 4);
            sectionHeader = new String(this.inputFour, this.currentCharset);
            for (int maxSkipCount = 2; maxSkipCount > 0 && !sectionHeader.equals("CNSL"); --maxSkipCount) {
                ins[0].read(this.inputFour, 0, 4);
                sectionHeader = new String(this.inputFour, this.currentCharset);
            }
            if (sectionHeader.equals("CNSL")) {
                try {
                    this.cnsl.readDataSection(ins[0]);
                }
                catch (IOException ex) {
                    this.logger.error("IOException during DATE", ex);
                }
            } else {
                this.logger.error("CNSL header is missing; instead read " + sectionHeader);
            }
            ins[0].read(this.inputFour, 0, 4);
            sectionHeader = new String(this.inputFour, this.currentCharset);
            if (sectionHeader.equals("WRLD")) {
                try {
                    this.world.readDataSection(ins[0]);
                }
                catch (IOException ex) {
                    this.logger.error("IOException during CNSL", ex);
                }
            } else {
                this.logger.error("WRLD header is missing; instead read " + sectionHeader);
            }
            ins[0].mark(5);
            ins[0].read(this.inputFour, 0, 4);
            ins[0].reset();
            sectionHeader = new String(this.inputFour, this.currentCharset);
            if (sectionHeader.equals("TILE")) {
                int numTiles = 0;
                numTiles = this.hasTiles(this.embeddedRules) ? this.embeddedRules.embeddedRules.tile.size() : this.world.getWidth() * this.world.getHeight() / 2;
                this.tiles = new GameTILE[numTiles];
                try {
                    for (i3 = 0; i3 < numTiles; ++i3) {
                        this.tiles[i3] = new GameTILE();
                        this.tiles[i3].readDataSection(ins[0]);
                    }
                }
                catch (IOException ex) {
                    this.logger.error("IOException during GameTILE; i = " + i3, ex);
                }
            } else {
                this.logger.error("TILE header is missing; instead read " + sectionHeader);
            }
            ins[0].mark(5);
            ins[0].read(this.inputFour, 0, 4);
            ins[0].reset();
            sectionHeader = new String(this.inputFour, this.currentCharset);
            if (sectionHeader.equals("CONT")) {
                int numConts = this.gameData.getNumConts();
                this.continents = new CONT[numConts];
                try {
                    for (i3 = 0; i3 < numConts; ++i3) {
                        this.continents[i3] = new CONT();
                        this.continents[i3].readDataSection(ins[0], this.embeddedRules.embeddedRules.resource.size());
                    }
                }
                catch (IOException ex) {
                    this.logger.error("IOException during CONT; i = " + i3, ex);
                }
            } else {
                this.logger.error("CONT header is missing; instead read " + sectionHeader);
            }
            this.goodCounts = new int[this.embeddedRules.embeddedRules.resource.size()];
            for (i2 = 0; i2 < this.embeddedRules.embeddedRules.resource.size(); ++i2) {
                this.goodCounts[i2] = ins[0].readInt();
            }
            ins[0].mark(5);
            ins[0].read(this.inputFour, 0, 4);
            ins[0].reset();
            sectionHeader = new String(this.inputFour, this.currentCharset);
            if (sectionHeader.equals("LEAD")) {
                ins[0].mark(5);
                ins[0].read(this.inputFour, 0, 4);
                ins[0].reset();
                sectionHeader = new String(this.inputFour, this.currentCharset);
                this.players = new SavLEAD[32];
                int numBuildings = this.embeddedRules.embeddedRules.buildings.size();
                int numGoods = this.embeddedRules.embeddedRules.resource.size();
                int numSSParts = this.embeddedRules.embeddedRules.rule.get(0).getNumSpaceshipParts();
                int numPrtos = this.embeddedRules.embeddedRules.getNumFiraxisUnits();
                try {
                    for (i2 = 0; i2 < 32; ++i2) {
                        this.logger.info("Processing player " + i2);
                        this.players[i2] = new SavLEAD();
                        this.players[i2].readDataSection(ins[0], numPrtos, numBuildings, numSSParts, numGoods, this.gameData.getNumPlayers());
                    }
                }
                catch (IOException ex) {
                    this.logger.error("IOException during LEAD; i = " + i2, ex);
                }
            } else {
                this.logger.error("LEAD header is missing; instead read " + sectionHeader);
            }
            ins[0].mark(5);
            ins[0].read(this.inputFour, 0, 4);
            ins[0].reset();
            sectionHeader = new String(this.inputFour, this.currentCharset);
            if ("UNIT".equals(sectionHeader)) {
                int numUnits = this.gameData.getNumberOfUnits();
                this.savUnits = new SavUNIT[numUnits];
                try {
                    for (i3 = 0; i3 < numUnits; ++i3) {
                        this.savUnits[i3] = new SavUNIT(this);
                        this.savUnits[i3].readDataSection(ins[0]);
                        if (!this.logger.isDebugEnabled()) continue;
                        this.logger.debug("New unit: " + this.savUnits[i3]);
                        this.logger.debug("Bytes read: " + ins[0].numBytesRead);
                    }
                }
                catch (IOException ex) {
                    this.logger.error("IOException during UNIT; i = " + i3, ex);
                }
            } else {
                this.logger.error("UNIT header is missing; instead read " + sectionHeader);
            }
            ins[0].mark(5);
            ins[0].read(this.inputFour, 0, 4);
            ins[0].reset();
            sectionHeader = new String(this.inputFour, this.currentCharset);
            this.logger.info("Bytes read: " + ins[0].numBytesRead);
            if ("CITY".equals(sectionHeader)) {
                i2 = 0;
                try {
                    while (true) {
                        SavCITY newCity = new SavCITY(this);
                        newCity.readDataSection(ins[0]);
                        this.firaxisCities.add(newCity);
                        if (newCity.isRealCity()) {
                            this.realCities.add(newCity);
                        }
                        ++i2;
                    }
                }
                catch (EndOfCITYException ex) {
                    this.logger.info("Reached end of SAV CITY section successfully; have " + this.firaxisCities.size() + " Firaxis cities and " + this.realCities.size() + " real cities");
                }
                catch (HeaderException ex) {
                    this.logger.error("Header exception during CITY; i = " + i2 + ".  # of real cities = " + this.realCities.size(), ex);
                }
                catch (IOException ex) {
                    this.logger.error("IOException during CITY; i = " + i2 + ".  # of real cities = " + this.realCities.size(), ex);
                }
            } else {
                this.logger.error("CITY header is missing; instead read " + sectionHeader);
                return false;
            }
            ins[0].mark(5);
            ins[0].read(this.inputFour, 0, 4);
            ins[0].reset();
            sectionHeader = new String(this.inputFour, this.currentCharset);
            this.logger.info("Bytes read: " + ins[0].numBytesRead);
            if ("CLNY".equals(sectionHeader)) {
                for (i2 = 0; i2 < this.gameData.getNumberOfColonies(); ++i2) {
                    SavCLNY colony = new SavCLNY();
                    colony.readDataSection(ins[0]);
                }
            }
            ins[0].read(this.zerosBeforePALV, 0, 256);
            boolean allZero = true;
            for (i = 0; i < 256; ++i) {
                if (this.zerosBeforePALV[i] == 0) continue;
                allZero = false;
            }
            if (!allZero) {
                this.logger.warn("Non-zero values present before PALV");
            }
            ins[0].mark(5);
            ins[0].read(this.inputFour, 0, 4);
            ins[0].reset();
            sectionHeader = new String(this.inputFour, this.currentCharset);
            this.logger.info("Bytes read: " + ins[0].numBytesRead);
            if ("PALV".equals(sectionHeader)) {
                try {
                    for (i = 0; i < this.NUM_PALV_PLAYERS; ++i) {
                        PALV newPALV = new PALV(this);
                        newPALV.readDataSection(ins[0]);
                        this.palaceViews.add(newPALV);
                    }
                }
                catch (IOException ex) {
                    this.logger.error("IOException during PALV; i = " + i, ex);
                }
            } else {
                this.logger.error("PALV header is missing; instead read " + sectionHeader);
                return false;
            }
            ins[0].mark(5);
            ins[0].read(this.inputFour, 0, 4);
            ins[0].reset();
            sectionHeader = new String(this.inputFour, this.currentCharset);
            this.logger.info("Bytes read: " + ins[0].numBytesRead);
            if ("HIST".equals(sectionHeader)) {
                try {
                    this.histograph.readDataSection(ins[0]);
                }
                catch (IOException ex) {
                    this.logger.error("IOException during HIST", ex);
                    return false;
                }
            } else {
                this.logger.error("HIST header is missing; instead read " + sectionHeader);
                return false;
            }
            this.logger.info("Reached current end of processing");
        }
        catch (IOException ex) {
            this.logger.error("IOException during input", ex);
            return false;
        }
        catch (InterruptedException ex) {
            this.logger.error("File decompression interrupted", ex);
            return false;
        }
        return true;
    }

    public boolean readSAVThroughEmbeddedRules(File file, boolean alreadyDecompressed) {
        this.dataInputted = 0;
        try {
            LittleEndianDataInputStream inFile = new LittleEndianDataInputStream(new BufferedInputStream(new FileInputStream(file)));
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Size of file:     " + (int)file.length());
                long maxMem = Runtime.getRuntime().maxMemory();
                this.logger.debug("Max size of heap: " + maxMem);
            }
            byte[] buffer = new byte[(int)file.length()];
            inFile.readFully(buffer);
            inFile.close();
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Number of available processors: " + Runtime.getRuntime().availableProcessors() + "; using " + numProcs + " processors");
            }
            LittleEndianDataInputStream[] ins = new LittleEndianDataInputStream[numProcs];
            return this.readSAVThroughEmbeddedRules(ins, buffer, file, alreadyDecompressed);
        }
        catch (IOException ex) {
            this.logger.error("Error when reading from file into buffer", ex);
            return false;
        }
    }

    private boolean readSAVThroughEmbeddedRules(LittleEndianDataInputStream[] ins, byte[] buffer, File file, boolean alreadyDecompressed) {
        long fileLength = file.length();
        try {
            for (int i = 0; i < ins.length; ++i) {
                ins[i] = new LittleEndianDataInputStream(new ByteArrayInputStream(buffer));
            }
            ins[0].read(this.inputFour, 0, 4);
            this.dataInputted += 4;
            String temp = new String(this.inputFour, this.currentCharset);
            if (!temp.contains("CIV3")) {
                if (alreadyDecompressed) {
                    this.logger.error("Cannot read decompressed file " + file.getName());
                    return false;
                }
                this.logger.info("Detected compressed file");
                String[] decomQuery = new String[]{"java", "-jar", "./bin/BIQDecompressor.jar", file.getCanonicalPath(), "._tmp.sav"};
                Process dcp = Runtime.getRuntime().exec(decomQuery);
                dcp.waitFor();
                return this.readSAVThroughEmbeddedRules(new File("._tmp.sav"), true);
            }
            this.header = temp;
            this.magicShort = ins[0].readShort();
            this.dataInputted += 2;
            this.majorVersion = ins[0].readInt();
            this.dataInputted += 4;
            if (this.majorVersion >= SavVERSION.SAV_VANILLA_121) {
                this.minorVersion = ins[0].readInt();
                if (this.minorVersion >= 7) {
                    ins[0].read(this.random16Bytes, 0, 16);
                    this.dataInputted += 16;
                }
            }
            int bytesBeforeBICs = this.dataInputted;
            for (int i = 1; i < ins.length; ++i) {
                ins[i].skipBytes(this.dataInputted);
            }
            this.embeddedRules.readEmbeddedRules(ins[0]);
            try {
                this.allTheThings = new byte[buffer.length];
                this.lengthOfRemainingBytes = ins[0].read(this.allTheThings);
            }
            catch (EOFException eof) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Reached EOF when scanning SAV.  This is expected");
                }
            }
            catch (IOException ex) {
                this.logger.error("Unexpected IOException when reading SAV");
            }
            ins[0].close();
            return true;
        }
        catch (IOException ex) {
            this.logger.error("IOException during input", ex);
            return false;
        }
        catch (InterruptedException ex) {
            this.logger.error("File decompression interrupted", ex);
            return false;
        }
    }

    public EmbeddedRules getEmbeddedRules() {
        return this.embeddedRules;
    }

    public boolean hasTiles(EmbeddedRules embeddedRules) {
        return embeddedRules.embeddedRules.tile != null && embeddedRules.embeddedRules.tile.size() > 0;
    }

    public void writeRulePatchedSAV(File file) throws IOException {
        try {
            LittleEndianDataOutputStream out = new LittleEndianDataOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
            out.writeBytes("CIV3");
            out.writeShort(this.magicShort);
            out.writeInt(this.majorVersion);
            out.writeInt(this.minorVersion);
            out.write(this.random16Bytes);
            this.embeddedRules.outputEmbeddedRules(out);
            out.write(this.allTheThings, 0, 117);
            out.writeByte(1);
            out.write(this.allTheThings, 118, this.lengthOfRemainingBytes - 118);
            out.close();
        }
        catch (FileNotFoundException ex) {
            this.logger.error("File not found for " + file.getPath(), ex);
        }
        catch (IOException ex) {
            this.logger.error("IOException for " + file.getPath(), ex);
            throw ex;
        }
    }

    public GameData getGameData() {
        return this.gameData;
    }

    public void applyMagic() {
        try {
            IO original = new IO();
            original.inputBIQ(new File("D:\\Civilization III\\Conquests\\Scenarios\\Random Uncompressed.biq"));
            original.city.clear();
            int cityIndex = 0;
            for (SavCITY city : this.realCities) {
                CITY biqEquivalent = new CITY(original);
                biqEquivalent.setName(city.getName());
                biqEquivalent.setX(city.getX());
                biqEquivalent.setY(city.getY());
                biqEquivalent.setCulture(city.getCulturePoints());
                biqEquivalent.setOwner(city.getOwner() - 1);
                biqEquivalent.setOwnerType(3);
                biqEquivalent.setBorderLevel(city.getBorderLevel());
                biqEquivalent.setSize(city.getCitizens().size());
                List<Integer> buildingIndices = city.getBuildingsPresent();
                for (Integer index : buildingIndices) {
                    biqEquivalent.addBuilding(index);
                    if (index != 0) continue;
                    biqEquivalent.setHasPalace((byte)1);
                }
                int tileIndex = original.calculateTileIndex(city.getX(), city.getY());
                original.tile.get(tileIndex).setCity((short)cityIndex);
                original.city.add(biqEquivalent);
                ++cityIndex;
            }
            original.outputBIQ(new File("C:\\temp\\magic.biq"));
        }
        catch (Exception ex) {
            System.err.println(Arrays.toString(ex.getStackTrace()));
        }
    }
}

