/*
 * Decompiled with CFR 0.152.
 */
package com.civfanatics.civ3.savFile;

import com.civfanatics.civ3.biqFile.util.LittleEndianDataInputStream;
import com.civfanatics.civ3.savFile.BINF;
import com.civfanatics.civ3.savFile.EndOfCITYException;
import com.civfanatics.civ3.savFile.HeaderException;
import com.civfanatics.civ3.savFile.POPD;
import com.civfanatics.civ3.savFile.SAV;
import com.civfanatics.civ3.savFile.SavVERSION;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class SavCITY {
    Logger logger = Logger.getLogger(this.getClass());
    private SAV baselink;
    private byte[] inputFour = new byte[4];
    private String header;
    private int dataLength;
    private int ID;
    private short x;
    private short y;
    private byte owner;
    private byte[] unknownThreeBytes = new byte[3];
    private int maintenanceGPT;
    private int cityFlags;
    private int governorSettings;
    private long unknownLong;
    private int totalFood;
    private int shieldsCollected;
    private int pollution;
    private int constructing;
    private int constructingType;
    private int yearBuilt;
    private int unknown1;
    private int borderLevel;
    private int militaryPolice;
    private int luxConnectedCount;
    private int luxConnectedBits;
    private int unknown2;
    private int draftTurnsLeft;
    private byte[] unknown52Bytes = new byte[52];
    private String cityHeaderTwo;
    private int dataLength2;
    private byte unhappyNoReasonPercent;
    private byte unhappyCrowdedPercent;
    private byte unhappyWarWearinessPercent;
    private byte unhappyAggressionPercent;
    private byte unhappyPropagandaPercent;
    private byte unhappyDraftPercent;
    private byte unhappyOppressionPercent;
    private byte unhappyThisCityImprovementsPercent;
    private byte unhappyOtherCityImprovementsPercent;
    private byte[] sevenBytes = new byte[7];
    private String cityHeaderThree;
    private int dataLength3;
    private byte[] thirtySixBytes = new byte[36];
    private String cityHeaderFour;
    private int dataLength4;
    private int culturePerTurn;
    private int[] culturePerLEAD = new int[32];
    private long unknownLongInSection4;
    private int foodPerTurn;
    private int shieldsPerTurn;
    private int commercePerTurn;
    private byte[] twelveBytes = new byte[12];
    private String cityHeaderFive;
    private int dataLength5;
    private byte[] nameBuffer = new byte[24];
    private String name;
    private int queueSlotsUsed;
    private QueueConstructing[] queueConstructing = new QueueConstructing[9];
    private int foodPerTurnForPopulation;
    private int corruptShieldsPerTurn;
    private int corruptGoldPerTurn;
    private int excessFoodPerTurn;
    private int unwastedFoodPerTurn;
    private int uncorruptGoldPerTurn;
    private int luxGoldPerTurn;
    private int scienceGoldPerTurn;
    private int treasuryGoldPerTurn;
    private int entertainerCount;
    private int scientistCount;
    private int taxManCount;
    private String popdHeader;
    private int popdDataLength;
    private int specialistCount;
    private int citizenCount;
    private List<POPD> citizens = new ArrayList<POPD>();
    private String binfHeader;
    private int binfLength;
    private int buildingCount;
    private List<BINF> buildingInfo = new ArrayList<BINF>();
    private String bitmHeader;
    private int dataLengthBitm;
    private byte[] usableBuildingBits = new byte[32];
    private int buildingCountBitm;
    private int buildingBytes;
    private String dateHeader;
    private int dateDataLength;
    private byte[] yearTextBytes = new byte[64];
    private String yearText;
    private int baseUnit;
    private int month;
    private int week;
    private int year;
    private byte[] extraDATEBytes;
    private byte[] dummyCityData;

    public SavCITY(SAV baselink) {
        this.baselink = baselink;
    }

    public void readDataSection(LittleEndianDataInputStream in) throws IOException, EndOfCITYException, HeaderException {
        int c;
        in.mark(5);
        in.read(this.inputFour, 0, 4);
        this.header = new String(this.inputFour, "Windows-1252");
        if (!this.header.equals("CITY") && !this.header.equals("CTPG")) {
            in.reset();
            throw new EndOfCITYException();
        }
        this.dataLength = in.readInt();
        if (this.dataLength != 136) {
            this.readDummyCitySection(in);
            return;
        }
        this.ID = in.readInt();
        this.x = in.readShort();
        this.y = in.readShort();
        this.owner = in.readByte();
        in.read(this.unknownThreeBytes, 0, 3);
        this.maintenanceGPT = in.readInt();
        this.cityFlags = in.readInt();
        this.governorSettings = in.readInt();
        this.unknownLong = in.readLong();
        this.totalFood = in.readInt();
        this.shieldsCollected = in.readInt();
        this.pollution = in.readInt();
        this.constructing = in.readInt();
        this.constructingType = in.readInt();
        this.yearBuilt = in.readInt();
        this.unknown1 = in.readInt();
        this.borderLevel = in.readInt();
        this.militaryPolice = in.readInt();
        this.luxConnectedCount = in.readInt();
        this.luxConnectedBits = in.readInt();
        this.unknown2 = in.readInt();
        this.draftTurnsLeft = in.readInt();
        in.read(this.unknown52Bytes, 0, 52);
        in.read(this.inputFour, 0, 4);
        this.cityHeaderTwo = new String(this.inputFour, "Windows-1252");
        if (!"CITY".equals(this.cityHeaderTwo)) {
            String message = "Second header did not matched expected (CITY) for city at " + this.x + ", " + this.y + "; was " + this.cityHeaderTwo;
            this.logger.error(message);
            throw new HeaderException(message);
        }
        this.dataLength2 = in.readInt();
        this.unhappyNoReasonPercent = in.readByte();
        this.unhappyCrowdedPercent = in.readByte();
        this.unhappyWarWearinessPercent = in.readByte();
        this.unhappyAggressionPercent = in.readByte();
        this.unhappyPropagandaPercent = in.readByte();
        this.unhappyDraftPercent = in.readByte();
        this.unhappyOppressionPercent = in.readByte();
        this.unhappyThisCityImprovementsPercent = in.readByte();
        this.unhappyOtherCityImprovementsPercent = in.readByte();
        in.read(this.sevenBytes, 0, 7);
        in.read(this.inputFour, 0, 4);
        this.cityHeaderThree = new String(this.inputFour, "Windows-1252");
        if (!"CITY".equals(this.cityHeaderThree)) {
            String message = "Third header did not matched expected (CITY) for city at " + this.x + ", " + this.y + "; was " + this.cityHeaderThree;
            this.logger.error(message);
            throw new HeaderException(message);
        }
        this.dataLength3 = in.readInt();
        in.read(this.thirtySixBytes, 0, 36);
        in.read(this.inputFour, 0, 4);
        this.cityHeaderFour = new String(this.inputFour, "Windows-1252");
        if (!"CITY".equals(this.cityHeaderFour)) {
            String message = "Fourth header did not matched expected (CITY) for city at " + this.x + ", " + this.y + "; was " + this.cityHeaderFour;
            this.logger.error(message);
            throw new HeaderException(message);
        }
        this.dataLength4 = in.readInt();
        this.culturePerTurn = in.readInt();
        for (c = 0; c < 32; ++c) {
            this.culturePerLEAD[c] = in.readInt();
        }
        this.unknownLongInSection4 = in.readLong();
        this.foodPerTurn = in.readInt();
        this.shieldsPerTurn = in.readInt();
        this.commercePerTurn = in.readInt();
        in.read(this.twelveBytes, 0, 12);
        in.read(this.inputFour, 0, 4);
        this.cityHeaderFive = new String(this.inputFour, "Windows-1252");
        if (!"CITY".equals(this.cityHeaderFive)) {
            String message = "Fifth header did not matched expected (CITY) for city at " + this.x + ", " + this.y + "; was " + this.cityHeaderFive;
            this.logger.error(message);
            throw new HeaderException(message);
        }
        this.dataLength5 = in.readInt();
        in.read(this.nameBuffer, 0, 24);
        this.name = new String(this.nameBuffer, "Windows-1252");
        this.queueSlotsUsed = in.readInt();
        for (int q = 0; q < 9; ++q) {
            this.queueConstructing[q] = new QueueConstructing();
            this.queueConstructing[q].constructing = in.readInt();
            this.queueConstructing[q].constructingType = in.readInt();
        }
        this.foodPerTurnForPopulation = in.readInt();
        this.corruptShieldsPerTurn = in.readInt();
        this.corruptGoldPerTurn = in.readInt();
        this.excessFoodPerTurn = in.readInt();
        this.unwastedFoodPerTurn = in.readInt();
        this.uncorruptGoldPerTurn = in.readInt();
        this.luxGoldPerTurn = in.readInt();
        this.scienceGoldPerTurn = in.readInt();
        this.treasuryGoldPerTurn = in.readInt();
        this.entertainerCount = in.readInt();
        this.scientistCount = in.readInt();
        this.taxManCount = in.readInt();
        in.read(this.inputFour, 0, 4);
        this.popdHeader = new String(this.inputFour, "Windows-1252");
        if (!"POPD".equals(this.popdHeader)) {
            String message = "POPD header did not matched expected; was " + this.popdHeader;
            this.logger.error(message);
            throw new HeaderException(message);
        }
        this.popdDataLength = in.readInt();
        this.specialistCount = in.readInt();
        this.citizenCount = in.readInt();
        for (c = 0; c < this.citizenCount; ++c) {
            POPD newPop = new POPD();
            newPop.readDataSection(in);
            this.citizens.add(newPop);
        }
        in.read(this.inputFour, 0, 4);
        this.binfHeader = new String(this.inputFour, "Windows-1252");
        if (!"BINF".equals(this.binfHeader)) {
            String message = "BINF header did not matched expected; was " + this.popdHeader;
            this.logger.error(message);
            throw new HeaderException(message);
        }
        this.binfLength = in.readInt();
        this.buildingCount = in.readInt();
        for (int b = 0; b < this.buildingCount; ++b) {
            BINF newBinf = new BINF();
            newBinf.readDataSection(in);
            this.buildingInfo.add(newBinf);
        }
        in.read(this.inputFour, 0, 4);
        this.bitmHeader = new String(this.inputFour, "Windows-1252");
        if (!"BITM".equals(this.bitmHeader)) {
            String message = "BITM header did not matched expected; was " + this.popdHeader;
            this.logger.error(message);
            throw new HeaderException(message);
        }
        this.dataLengthBitm = in.readInt();
        in.read(this.usableBuildingBits, 0, 32);
        this.buildingCount = in.readInt();
        this.buildingBytes = in.readInt();
        if (this.baselink.majorVersion >= SavVERSION.SAV_PTW) {
            in.read(this.inputFour, 0, 4);
            this.dateHeader = new String(this.inputFour, "Windows-1252");
            if (!"DATE".equals(this.dateHeader)) {
                String message = "DATE header did not matched expected for " + this.name + "; was " + this.popdHeader;
                this.logger.error(message);
                throw new HeaderException(message);
            }
            this.dateDataLength = in.readInt();
            in.read(this.yearTextBytes, 0, 64);
            this.yearText = new String(this.yearTextBytes, "Windows-1252");
            this.baseUnit = in.readInt();
            this.month = in.readInt();
            this.week = in.readInt();
            this.year = in.readInt();
            if (this.dateDataLength > 80) {
                this.extraDATEBytes = new byte[this.dateDataLength - 80];
                in.read(this.extraDATEBytes, 0, this.dateDataLength - 80);
            }
        }
    }

    public void readDummyCitySection(LittleEndianDataInputStream in) throws IOException {
        this.dummyCityData = new byte[this.dataLength];
        in.read(this.dummyCityData, 0, this.dataLength);
    }

    public boolean isRealCity() {
        return this.dataLength == 136;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public SAV getBaselink() {
        return this.baselink;
    }

    public byte[] getInputFour() {
        return this.inputFour;
    }

    public String getHeader() {
        return this.header;
    }

    public int getDataLength() {
        return this.dataLength;
    }

    public int getID() {
        return this.ID;
    }

    public short getX() {
        return this.x;
    }

    public short getY() {
        return this.y;
    }

    public byte getOwner() {
        return this.owner;
    }

    public byte[] getUnknownThreeBytes() {
        return this.unknownThreeBytes;
    }

    public int getMaintenanceGPT() {
        return this.maintenanceGPT;
    }

    public int getCityFlags() {
        return this.cityFlags;
    }

    public int getGovernorSettings() {
        return this.governorSettings;
    }

    public long getUnknownLong() {
        return this.unknownLong;
    }

    public int getTotalFood() {
        return this.totalFood;
    }

    public int getShieldsCollected() {
        return this.shieldsCollected;
    }

    public int getPollution() {
        return this.pollution;
    }

    public int getConstructing() {
        return this.constructing;
    }

    public int getConstructingType() {
        return this.constructingType;
    }

    public int getYearBuilt() {
        return this.yearBuilt;
    }

    public int getUnknown1() {
        return this.unknown1;
    }

    public int getBorderLevel() {
        return this.borderLevel;
    }

    public int getMilitaryPolice() {
        return this.militaryPolice;
    }

    public int getLuxConnectedCount() {
        return this.luxConnectedCount;
    }

    public int getLuxConnectedBits() {
        return this.luxConnectedBits;
    }

    public int getUnknown2() {
        return this.unknown2;
    }

    public int getDraftTurnsLeft() {
        return this.draftTurnsLeft;
    }

    public byte[] getUnknown52Bytes() {
        return this.unknown52Bytes;
    }

    public String getCityHeaderTwo() {
        return this.cityHeaderTwo;
    }

    public int getDataLength2() {
        return this.dataLength2;
    }

    public byte getUnhappyNoReasonPercent() {
        return this.unhappyNoReasonPercent;
    }

    public byte getUnhappyCrowdedPercent() {
        return this.unhappyCrowdedPercent;
    }

    public byte getUnhappyWarWearinessPercent() {
        return this.unhappyWarWearinessPercent;
    }

    public byte getUnhappyAggressionPercent() {
        return this.unhappyAggressionPercent;
    }

    public byte getUnhappyPropagandaPercent() {
        return this.unhappyPropagandaPercent;
    }

    public byte getUnhappyDraftPercent() {
        return this.unhappyDraftPercent;
    }

    public byte getUnhappyOppressionPercent() {
        return this.unhappyOppressionPercent;
    }

    public byte getUnhappyThisCityImprovementsPercent() {
        return this.unhappyThisCityImprovementsPercent;
    }

    public byte getUnhappyOtherCityImprovementsPercent() {
        return this.unhappyOtherCityImprovementsPercent;
    }

    public byte[] getSevenBytes() {
        return this.sevenBytes;
    }

    public String getCityHeaderThree() {
        return this.cityHeaderThree;
    }

    public int getDataLength3() {
        return this.dataLength3;
    }

    public byte[] getThirtySixBytes() {
        return this.thirtySixBytes;
    }

    public String getCityHeaderFour() {
        return this.cityHeaderFour;
    }

    public int getDataLength4() {
        return this.dataLength4;
    }

    public int getCulturePerTurn() {
        return this.culturePerTurn;
    }

    public int[] getCulturePerLEAD() {
        return this.culturePerLEAD;
    }

    public long getUnknownLongInSection4() {
        return this.unknownLongInSection4;
    }

    public int getFoodPerTurn() {
        return this.foodPerTurn;
    }

    public int getShieldsPerTurn() {
        return this.shieldsPerTurn;
    }

    public int getCommercePerTurn() {
        return this.commercePerTurn;
    }

    public byte[] getTwelveBytes() {
        return this.twelveBytes;
    }

    public String getCityHeaderFive() {
        return this.cityHeaderFive;
    }

    public int getDataLength5() {
        return this.dataLength5;
    }

    public byte[] getNameBuffer() {
        return this.nameBuffer;
    }

    public String getName() {
        return this.name;
    }

    public int getQueueSlotsUsed() {
        return this.queueSlotsUsed;
    }

    public QueueConstructing[] getQueueConstructing() {
        return this.queueConstructing;
    }

    public int getFoodPerTurnForPopulation() {
        return this.foodPerTurnForPopulation;
    }

    public int getCorruptShieldsPerTurn() {
        return this.corruptShieldsPerTurn;
    }

    public int getCorruptGoldPerTurn() {
        return this.corruptGoldPerTurn;
    }

    public int getExcessFoodPerTurn() {
        return this.excessFoodPerTurn;
    }

    public int getUnwastedFoodPerTurn() {
        return this.unwastedFoodPerTurn;
    }

    public int getUncorruptGoldPerTurn() {
        return this.uncorruptGoldPerTurn;
    }

    public int getLuxGoldPerTurn() {
        return this.luxGoldPerTurn;
    }

    public int getScienceGoldPerTurn() {
        return this.scienceGoldPerTurn;
    }

    public int getTreasuryGoldPerTurn() {
        return this.treasuryGoldPerTurn;
    }

    public int getEntertainerCount() {
        return this.entertainerCount;
    }

    public int getScientistCount() {
        return this.scientistCount;
    }

    public int getTaxManCount() {
        return this.taxManCount;
    }

    public String getPopdHeader() {
        return this.popdHeader;
    }

    public int getPopdDataLength() {
        return this.popdDataLength;
    }

    public int getSpecialistCount() {
        return this.specialistCount;
    }

    public int getCitizenCount() {
        return this.citizenCount;
    }

    public List<POPD> getCitizens() {
        return this.citizens;
    }

    public String getBinfHeader() {
        return this.binfHeader;
    }

    public int getBinfLength() {
        return this.binfLength;
    }

    public int getBuildingCount() {
        return this.buildingCount;
    }

    public List<BINF> getBuildingInfo() {
        return this.buildingInfo;
    }

    public String getBitmHeader() {
        return this.bitmHeader;
    }

    public int getDataLengthBitm() {
        return this.dataLengthBitm;
    }

    public byte[] getUsableBuildingBits() {
        return this.usableBuildingBits;
    }

    public int getBuildingCountBitm() {
        return this.buildingCountBitm;
    }

    public int getBuildingBytes() {
        return this.buildingBytes;
    }

    public String getDateHeader() {
        return this.dateHeader;
    }

    public int getDateDataLength() {
        return this.dateDataLength;
    }

    public byte[] getYearTextBytes() {
        return this.yearTextBytes;
    }

    public String getYearText() {
        return this.yearText;
    }

    public int getBaseUnit() {
        return this.baseUnit;
    }

    public int getMonth() {
        return this.month;
    }

    public int getWeek() {
        return this.week;
    }

    public int getYear() {
        return this.year;
    }

    public byte[] getExtraDATEBytes() {
        return this.extraDATEBytes;
    }

    public byte[] getDummyCityData() {
        return this.dummyCityData;
    }

    public List<Integer> getBuildingsPresent() {
        int buildingIndex = 0;
        ArrayList<Integer> buildings = new ArrayList<Integer>();
        for (int i = 0; i < this.usableBuildingBits.length; ++i) {
            byte currentByte = this.usableBuildingBits[i];
            for (int bit = 1; bit < 255; bit <<= 1) {
                if ((currentByte & bit) == bit) {
                    buildings.add(buildingIndex);
                }
                ++buildingIndex;
            }
        }
        return buildings;
    }

    public int getCulturePoints() {
        int max = -1;
        for (int i = 0; i < this.culturePerLEAD.length; ++i) {
            if (this.culturePerLEAD[i] <= max) continue;
            max = this.culturePerLEAD[i];
        }
        return max;
    }

    private class QueueConstructing {
        private int constructing;
        private int constructingType;

        private QueueConstructing() {
        }
    }
}

