/*
 * Decompiled with CFR 0.152.
 */
package com.civfanatics.civ3.xplatformeditor.CustomComponents;

import com.civfanatics.civ3.biqFile.BIQSection;
import com.civfanatics.civ3.xplatformeditor.CustomComponents.QueryList;
import com.civfanatics.civ3.xplatformeditor.Main;
import com.civfanatics.civ3.xplatformeditor.civilopedia.CivilopediaIcon;
import com.civfanatics.civ3.xplatformeditor.utils;
import java.awt.image.BufferedImage;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.embed.swing.SwingFXUtils;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TextField;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.image.WritableImage;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.ContextMenuEvent;
import javafx.scene.input.DragEvent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.TransferMode;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.util.Callback;
import org.apache.log4j.Logger;

public class ImprovedListView<T extends BIQSection>
extends VBox {
    Logger logger = Logger.getLogger(((Object)((Object)this)).getClass());
    List<T> baseItemList;
    ObservableList<T> observableList;
    String itemTypeName = "";
    ContextMenu techListPopup = new ContextMenu();
    MenuItem menuAdd = new MenuItem("Add");
    MenuItem menuCopy = new MenuItem("Copy");
    MenuItem menuRename = new MenuItem("Rename");
    MenuItem menuDelete = new MenuItem("Delete");
    BiConsumer<Integer, Integer> swapFunction;
    boolean dndUpdateDisabled = false;
    TextField filter = new TextField();
    private ListView<T> listView = new ListView();

    public ImprovedListView(String itemTypeName, List<T> baseItemList, ObservableList<T> items, BiPredicate predicate) {
        this.itemTypeName = itemTypeName;
        this.baseItemList = baseItemList;
        this.observableList = items;
        this.setupFilter(items, predicate);
        this.setupUI();
        this.setupCellFactory();
        this.setupContextMenu();
        this.setupDragAndDrop();
    }

    public void setBaseItems(List<T> baseItemList) {
        this.baseItemList = baseItemList;
    }

    private void setupUI() {
        this.listView.getStylesheets().add((Object)"styles/styles.css");
        VBox.setVgrow(this.listView, (Priority)Priority.ALWAYS);
        this.getChildren().add((Object)this.filter);
        this.getChildren().add(this.listView);
    }

    private void setupFilter(ObservableList<T> items, BiPredicate predicate) {
        QueryList<T> queryList = new QueryList<T>(items);
        queryList.setPredicate(predicate);
        this.filter.textProperty().addListener(obs -> queryList.updateSearchQuery(this.filter.getText()));
        this.listView.setItems(queryList);
    }

    private void setupCellFactory() {
        this.listView.setCellFactory(new Callback<ListView<T>, ListCell<T>>(){

            public ListCell<T> call(ListView<T> param) {
                final ListCell cell = new ListCell<T>(){

                    protected void updateItem(T tech, boolean empty) {
                        super.updateItem(tech, empty);
                        if (empty || tech == null) {
                            this.setText(null);
                            this.setGraphic(null);
                        } else {
                            this.setText(((BIQSection)tech).getName());
                            if (Main.GRAPHICS_ENABLED) {
                                try {
                                    BufferedImage icon = CivilopediaIcon.getSmallCivilopediaIcon(tech);
                                    if (icon != null) {
                                        WritableImage fxImg = SwingFXUtils.toFXImage((BufferedImage)icon, null);
                                        this.setGraphic((Node)new ImageView((Image)fxImg));
                                        if (ImprovedListView.this.logger.isTraceEnabled()) {
                                            ImprovedListView.this.logger.trace("graphic set");
                                        }
                                    }
                                }
                                catch (Exception ex) {
                                    ImprovedListView.this.logger.error("Boom", ex);
                                }
                            }
                        }
                    }
                };
                cell.setOnDragDropped((EventHandler)new EventHandler<DragEvent>(){

                    public void handle(DragEvent event) {
                        try {
                            Dragboard d = event.getDragboard();
                            if (d.hasString()) {
                                int destination;
                                String theString = d.getString();
                                ImprovedListView.this.dndUpdateDisabled = true;
                                int source = Integer.parseInt(theString);
                                boolean keepGoing = ImprovedListView.this.localSwapFunction(source, destination = ((BIQSection)cell.getItem()).getIndex());
                                if (keepGoing) {
                                    ImprovedListView.this.swapFunction.accept(source, destination);
                                }
                                ImprovedListView.this.dndUpdateDisabled = false;
                            }
                        }
                        catch (Exception ex) {
                            ImprovedListView.this.logger.error("Unexpected error while dragging and dropping", ex);
                            String errType = ex.toString();
                            Alert a = new Alert(Alert.AlertType.ERROR, "Unexpected error while dragging and dropping: " + errType + ".  See the log for details and post info on the CFC thread for assistance.", new ButtonType[0]);
                            a.setHeaderText("Unexpected error");
                            a.setTitle("Unexpected error");
                            a.show();
                        }
                    }
                });
                cell.setOnDragEntered((EventHandler)new EventHandler<DragEvent>(){

                    public void handle(DragEvent event) {
                        cell.setOpacity(0.75);
                        cell.getStyleClass().add((Object)"dndBorder");
                    }
                });
                cell.setOnDragExited((EventHandler)new EventHandler<DragEvent>(){

                    public void handle(DragEvent event) {
                        cell.setOpacity(1.0);
                        cell.getStyleClass().remove((Object)"dndBorder");
                    }
                });
                return cell;
            }
        });
    }

    private void setupDragAndDrop() {
        this.listView.setOnDragDetected(new EventHandler(){

            public void handle(Event event) {
                if (ImprovedListView.this.logger.isTraceEnabled()) {
                    ImprovedListView.this.logger.trace("Drag detected");
                }
                String index = "" + ((BIQSection)ImprovedListView.this.listView.getSelectionModel().getSelectedItem()).getIndex();
                Dragboard db = ImprovedListView.this.listView.startDragAndDrop(new TransferMode[]{TransferMode.MOVE});
                ClipboardContent clip = new ClipboardContent();
                clip.putString(index);
                db.setContent((Map)clip);
            }
        });
        this.listView.setOnDragOver(event -> event.acceptTransferModes(new TransferMode[]{TransferMode.MOVE}));
    }

    private void setupContextMenu() {
        this.listView.setContextMenu(this.techListPopup);
        this.listView.setOnContextMenuRequested((EventHandler)new EventHandler<ContextMenuEvent>(){

            public void handle(ContextMenuEvent event) {
                ImprovedListView.this.techListPopup.show((Node)ImprovedListView.this.listView, event.getScreenX(), event.getScreenY());
                event.consume();
            }
        });
    }

    public void setAddAction(Consumer<String> addAction) {
        this.menuAdd.setOnAction(a -> {
            String capitalized = this.itemTypeName.substring(0, 1).toUpperCase() + this.itemTypeName.substring(1);
            String name = utils.getItemName("Enter " + this.itemTypeName + " name", capitalized + " Name", "Enter " + this.itemTypeName + " name:", "");
            addAction.accept(name);
            this.observableList.add(this.baseItemList.get(this.baseItemList.size() - 1));
        });
        this.techListPopup.getItems().add((Object)this.menuAdd);
    }

    public void setDeleteAction(Consumer<T> deleteAction) {
        this.menuDelete.setOnAction(a -> {
            BIQSection deletedItem = (BIQSection)this.listView.getSelectionModel().getSelectedItem();
            deleteAction.accept(deletedItem);
            this.observableList.remove((Object)deletedItem);
        });
        this.techListPopup.getItems().add((Object)this.menuDelete);
    }

    public void setRenameAction(Consumer<T> renameAction) {
        this.menuRename.setOnAction(a -> {
            renameAction.accept(this.listView.getSelectionModel().getSelectedItem());
            this.listView.refresh();
        });
        this.techListPopup.getItems().add((Object)this.menuRename);
    }

    public void setCopyAction(BiConsumer<T, String> copyAction) {
        this.menuCopy.setOnAction(a -> {
            String capitalized = this.itemTypeName.substring(0, 1).toUpperCase() + this.itemTypeName.substring(1);
            String name = utils.getItemName("Enter " + this.itemTypeName + " name", capitalized + " Name", "Enter the name for the copied " + this.itemTypeName + ":", "");
            copyAction.accept(this.listView.getSelectionModel().getSelectedItem(), name);
            this.observableList.add(this.baseItemList.get(this.baseItemList.size() - 1));
            this.listView.refresh();
        });
        this.techListPopup.getItems().add((Object)this.menuCopy);
    }

    public void setChangeFunction(final Consumer<T> changeFunction) {
        this.listView.getSelectionModel().selectedItemProperty().addListener(new ChangeListener<T>(){

            public void changed(ObservableValue<? extends T> ov, T oldVal, T newVal) {
                if (!ImprovedListView.this.dndUpdateDisabled) {
                    if (ImprovedListView.this.logger.isDebugEnabled()) {
                        ImprovedListView.this.logger.debug("Accepting change event");
                    }
                    changeFunction.accept(newVal);
                } else {
                    ImprovedListView.this.logger.info("Discarding save event due to DND being disabled");
                }
            }
        });
    }

    public void setSwapFunction(BiConsumer<Integer, Integer> swapFunction) {
        this.swapFunction = swapFunction;
    }

    private boolean localSwapFunction(int source, int destination) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Swapping order");
        }
        this.logger.info("Swapping...");
        if (source == destination) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Source and destination are the same; not swapping");
            }
            return false;
        }
        BIQSection sourceItem = (BIQSection)this.baseItemList.get(source);
        BIQSection initialDestinationTech = (BIQSection)this.baseItemList.get(destination);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Source tech: " + sourceItem.getName());
            this.logger.debug("Destination tech: " + initialDestinationTech.getName());
        }
        if (source < destination) {
            this.baseItemList.add(destination + 1, sourceItem);
            this.baseItemList.remove(source);
            sourceItem.setIndex(destination);
            for (int i = source; i < destination; ++i) {
                ((BIQSection)this.baseItemList.get(i)).setIndex(((BIQSection)this.baseItemList.get(i)).getIndex() - 1);
            }
            this.observableList.remove((Object)sourceItem);
            this.observableList.add(destination, (Object)sourceItem);
            this.listView.getSelectionModel().select(destination);
        } else {
            this.baseItemList.add(destination + 1, sourceItem);
            this.baseItemList.remove(source + 1);
            sourceItem.setIndex(destination + 1);
            for (int i = source; i > destination + 1; --i) {
                ((BIQSection)this.baseItemList.get(i)).setIndex(((BIQSection)this.baseItemList.get(i)).getIndex() + 1);
            }
            this.observableList.remove((Object)sourceItem);
            this.observableList.add(destination + 1, (Object)sourceItem);
            this.listView.getSelectionModel().select(destination + 1);
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("End swapping order");
        }
        return true;
    }
}

