/*
 * Decompiled with CFR 0.152.
 */
package com.civfanatics.civ3.xplatformeditor.CustomComponents;

import com.civfanatics.civ3.xplatformeditor.CustomComponents.SuperListModel;
import com.civfanatics.civ3.xplatformeditor.EditorTab;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;

public class SuperJList
extends JList {
    EditorTab host;
    JPopupMenu popUp = new JPopupMenu();
    JMenuItem delete;
    JMenuItem add;
    JMenuItem rename;
    JMenuItem copy;
    String typeOfItem;

    public SuperJList(EditorTab host, String typeOfItem) {
        this(host, typeOfItem, true, true);
    }

    public SuperJList(EditorTab host, String typeOfItem, boolean deleteable) {
        this(host, typeOfItem, deleteable, true);
    }

    public SuperJList(EditorTab host, String typeOfItem, boolean deleteable, boolean addable) {
        this(host, typeOfItem, deleteable, addable, false);
    }

    public SuperJList(EditorTab host, String typeOfItem, boolean deleteable, boolean addable, boolean copyable) {
        this.setSelectionMode(0);
        this.host = host;
        this.typeOfItem = typeOfItem;
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                SuperJList.this.checkForPopUp(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                SuperJList.this.checkForPopUp(evt);
            }
        });
        this.delete = new JMenuItem("Delete");
        this.delete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SuperJList.this.deleteAction();
            }
        });
        this.add = new JMenuItem("Add");
        this.add.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SuperJList.this.addAction();
            }
        });
        this.rename = new JMenuItem("Rename");
        this.rename.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SuperJList.this.renameAction();
            }
        });
        this.copy = new JMenuItem("Copy");
        this.copy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SuperJList.this.copyAction();
            }
        });
        if (deleteable) {
            this.popUp.add(this.delete);
        }
        if (addable) {
            this.popUp.add(this.add);
        }
        this.popUp.add(this.rename);
        if (copyable) {
            this.popUp.add(this.copy);
        }
    }

    private void checkForPopUp(MouseEvent evt) {
        if (evt.isPopupTrigger()) {
            this.setSelectedIndex(this.locationToIndex(new Point(evt.getX(), evt.getY())));
            Component component = evt.getComponent();
            int x = evt.getX();
            int y = evt.getY();
            this.popUp.show(component, x, y);
        }
    }

    private void addAction() {
        String name = JOptionPane.showInputDialog("Please choose a name for the new " + this.typeOfItem);
        if (name == null) {
            return;
        }
        ((SuperListModel)this.getModel()).addIndexedElement((Comparable)((Object)name));
        this.host.addItem(name);
        this.setSelectedIndex(this.getModel().getSize() - 1);
    }

    private void deleteAction() {
        this.host.deleteAction();
    }

    private void renameAction() {
        String currentName = this.getSelectedValue().toString();
        String name = JOptionPane.showInputDialog("Please choose a new name for your " + this.typeOfItem, (Object)currentName);
        if (name == null) {
            return;
        }
        if (name.trim().equals("")) {
            return;
        }
        int index = this.getSelectedIndex();
        index = ((SuperListModel)this.getModel()).getTrueIndex(index);
        ((SuperListModel)this.getModel()).set(index, name);
        this.host.renameBIQElement(index, name);
    }

    private void copyAction() {
        String name = JOptionPane.showInputDialog("Please enter a name for the copied  " + this.typeOfItem);
        if (name == null || name.trim().equals("")) {
            return;
        }
        int index = this.getSelectedIndex();
        index = ((SuperListModel)this.getModel()).getTrueIndex(index);
        ((SuperListModel)this.getModel()).addIndexedElement((Comparable)((Object)name));
        this.host.copyItem(name, index);
        this.setSelectedIndex(this.getModel().getSize() - 1);
    }
}

