/*
 * Decompiled with CFR 0.152.
 */
package com.civfanatics.civ3.xplatformeditor;

import com.civfanatics.civ3.biqFile.ESPN;
import com.civfanatics.civ3.xplatformeditor.CustomComponents.SuperJList;
import com.civfanatics.civ3.xplatformeditor.CustomComponents.SuperJTextField;
import com.civfanatics.civ3.xplatformeditor.CustomComponents.SuperListModel;
import com.civfanatics.civ3.xplatformeditor.EditorTab;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.lib.awtextra.AbsoluteConstraints;
import org.netbeans.lib.awtextra.AbsoluteLayout;

public class ESPNTab
extends EditorTab {
    int espionageIndex;
    public List<ESPN> espionage;
    boolean tabCreated = true;
    private SuperListModel espionageList;
    private JCheckBox chkESPNDiplomats;
    private JCheckBox chkESPNSpies;
    private JLabel lblCivilopedia;
    private JLabel lblDescription;
    private JLabel lblCost;
    private JPanel jPanel56;
    private JScrollPane jScrollPane7;
    private SuperJTextField txtESPNCivilopediaEntry;
    private SuperJTextField txtESPNDescription;
    private SuperJTextField txtESPNBaseCost;
    private SuperJList lstEspionages = new SuperJList(this, "act of espionage", false, false);

    public ESPNTab() {
        this.lstType = this.lstEspionages;
        this.tabName = "ESPN";
        this.textBoxes = new ArrayList();
        this.jScrollPane7 = new JScrollPane();
        this.lblCivilopedia = new JLabel();
        this.lblDescription = new JLabel();
        this.txtESPNCivilopediaEntry = new SuperJTextField();
        this.txtESPNDescription = new SuperJTextField();
        this.lblCost = new JLabel();
        this.txtESPNBaseCost = new SuperJTextField();
        this.jPanel56 = new JPanel();
        this.chkESPNDiplomats = new JCheckBox();
        this.chkESPNSpies = new JCheckBox();
        this.espionageList = new SuperListModel();
        this.lstEspionages.setModel(this.espionageList);
        this.espionageIndex = -1;
    }

    @Override
    public void setSelectedIndex(int i) {
        this.espionageIndex = i;
    }

    public void lstEspionagesValueChanged(ListSelectionEvent evt) {
        this.updateTab();
    }

    @Override
    public void updateTab() {
        if (this.espionageIndex != -1) {
            this.espionage.get(this.espionageIndex).setDescription(this.txtESPNDescription.getText());
            this.espionage.get(this.espionageIndex).setCivilopediaEntry(this.txtESPNCivilopediaEntry.getText());
            if (this.chkESPNDiplomats.isSelected() && this.chkESPNSpies.isSelected()) {
                this.espionage.get(this.espionageIndex).setMissionPerformedBy(3);
            } else if (this.chkESPNSpies.isSelected()) {
                this.espionage.get(this.espionageIndex).setMissionPerformedBy(2);
            } else if (this.chkESPNDiplomats.isSelected()) {
                this.espionage.get(this.espionageIndex).setMissionPerformedBy(1);
            } else {
                this.espionage.get(this.espionageIndex).setMissionPerformedBy(0);
            }
            this.espionage.get(this.espionageIndex).setBaseCost(this.txtESPNBaseCost.getInteger());
        }
        this.espionageIndex = this.lstEspionages.getSelectedIndex();
        if (this.espionageIndex != -1) {
            this.txtESPNDescription.setText(this.espionage.get(this.espionageIndex).getDescription());
            this.txtESPNCivilopediaEntry.setText(this.espionage.get(this.espionageIndex).getCivilopediaEntry());
            switch (this.espionage.get(this.espionageIndex).getMissionPerformedBy()) {
                case 3: {
                    this.chkESPNDiplomats.setSelected(true);
                    this.chkESPNSpies.setSelected(true);
                    break;
                }
                case 2: {
                    this.chkESPNDiplomats.setSelected(false);
                    this.chkESPNSpies.setSelected(true);
                    break;
                }
                case 1: {
                    this.chkESPNDiplomats.setSelected(true);
                    this.chkESPNSpies.setSelected(false);
                    break;
                }
                case 0: {
                    this.chkESPNDiplomats.setSelected(false);
                    this.chkESPNSpies.setSelected(false);
                    break;
                }
                default: {
                    this.logger.warn("Invalid data for mission performed by for espionage mission " + this.espionage.get(this.espionageIndex).getName() + "; integer value was " + this.espionage.get(this.espionageIndex).getMissionPerformedBy() + " and maximum value should be 3 (minimum should be 0).");
                }
            }
            this.txtESPNBaseCost.setText(Integer.toString(this.espionage.get(this.espionageIndex).getBaseCost()));
        }
    }

    public JPanel createTab() {
        this.setLayout(new AbsoluteLayout());
        this.lstEspionages.setSelectionMode(0);
        this.lstEspionages.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                ESPNTab.this.lstEspionagesValueChanged(evt);
            }
        });
        this.jScrollPane7.setViewportView(this.lstEspionages);
        this.add((Component)this.jScrollPane7, new AbsoluteConstraints(0, 0, 170, 700));
        this.lblDescription.setText("Description:");
        this.add((Component)this.lblDescription, new AbsoluteConstraints(190, 40, -1, -1));
        this.lblCivilopedia.setText("Civilopedia Entry:");
        this.add((Component)this.lblCivilopedia, new AbsoluteConstraints(190, 20, -1, -1));
        this.txtESPNCivilopediaEntry.setText("                                           ");
        this.add((Component)this.txtESPNCivilopediaEntry, new AbsoluteConstraints(300, 20, 170, -1));
        this.txtESPNDescription.setText("                                           ");
        this.add((Component)this.txtESPNDescription, new AbsoluteConstraints(300, 40, 570, -1));
        this.lblCost.setText("Cost:");
        this.add((Component)this.lblCost, new AbsoluteConstraints(190, 60, -1, -1));
        this.txtESPNBaseCost.setText("                   ");
        this.add((Component)this.txtESPNBaseCost, new AbsoluteConstraints(300, 60, 50, -1));
        this.jPanel56.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Performed By"));
        this.chkESPNDiplomats.setText("Diplomats");
        this.chkESPNSpies.setText("Spies");
        GroupLayout jPanel56Layout = new GroupLayout(this.jPanel56);
        this.jPanel56.setLayout(jPanel56Layout);
        jPanel56Layout.setHorizontalGroup(jPanel56Layout.createParallelGroup(1).add(jPanel56Layout.createSequentialGroup().add(jPanel56Layout.createParallelGroup(1).add(this.chkESPNDiplomats).add(this.chkESPNSpies)).addContainerGap(45, Short.MAX_VALUE)));
        jPanel56Layout.setVerticalGroup(jPanel56Layout.createParallelGroup(1).add(jPanel56Layout.createSequentialGroup().add(this.chkESPNDiplomats).addPreferredGap(0).add(this.chkESPNSpies).addContainerGap(-1, Short.MAX_VALUE)));
        this.add((Component)this.jPanel56, new AbsoluteConstraints(190, 90, -1, -1));
        this.setName("ESPN");
        this.tabCreated = true;
        return this;
    }

    public void sendData(List<ESPN> espionage) {
        this.espionage = espionage;
        this.espionageIndex = -1;
        this.espionageList.removeAllElements();
        for (int i = 0; i < espionage.size(); ++i) {
            this.espionageList.addElement(espionage.get(i).getName());
        }
    }

    @Override
    public void setNoLimits() {
        this.clearBadValueDocumentListeners();
        this.clearLengthDocumentListeners();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("SETTING NO LIMITS");
        }
    }

    @Override
    public void setMinimalLimits() {
        this.clearBadValueDocumentListeners();
        this.clearLengthDocumentListeners();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("SETTING MINIMAL LIMITS");
        }
        this.addLengthDocumentListener(127, this.txtESPNDescription);
        this.addLengthDocumentListener(31, this.txtESPNCivilopediaEntry);
    }

    @Override
    public void setExploratoryLimits() {
        this.clearBadValueDocumentListeners();
        this.clearLengthDocumentListeners();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("SETTING EXPLORATORY LIMITS");
        }
        this.setMinimalLimits();
    }

    @Override
    public void setSafeLimits() {
        this.clearBadValueDocumentListeners();
        this.clearLengthDocumentListeners();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("SETTING SAFE LIMITS");
        }
        this.setFiraxisLimits();
    }

    @Override
    public void setFiraxisLimits() {
        this.clearBadValueDocumentListeners();
        this.clearLengthDocumentListeners();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("SETTING FIRAXIS LIMITS");
        }
        this.setMinimalLimits();
        this.addBadValueDocumentListener(1000, this.txtESPNBaseCost);
    }

    @Override
    public void setTotalLimits() {
        this.clearBadValueDocumentListeners();
        this.clearLengthDocumentListeners();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("SETTING TOTAL LIMITS");
        }
        this.setFiraxisLimits();
    }

    @Override
    public void renameBIQElement(int index, String name) {
        this.espionage.get(index).setName(name);
    }
}

