/*
 * Decompiled with CFR 0.152.
 */
package com.civfanatics.civ3.xplatformeditor;

import com.civfanatics.civ3.biqFile.IO;
import com.civfanatics.civ3.xplatformeditor.CustomComponents.SuperJTextField;
import com.civfanatics.civ3.xplatformeditor.Listeners.BadValueDocumentListener;
import com.civfanatics.civ3.xplatformeditor.Listeners.LengthDocumentListener;
import com.civfanatics.civ3.xplatformeditor.specialty.SafetyLevel;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.event.DocumentListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.JTextComponent;
import org.apache.log4j.Logger;

public abstract class EditorTab
extends JPanel {
    protected static final String noneSelected = "None";
    Logger logger = Logger.getLogger(this.getClass());
    public List<JTextComponent> textBoxes;
    public String tabName;
    public IO baselink;
    JList lstType;
    public boolean newData = false;
    public boolean isActive = true;

    public abstract void updateTab();

    public abstract void setSelectedIndex(int var1);

    protected void clearBadValueDocumentListeners() {
        if (this.textBoxes == null) {
            this.textBoxes = new ArrayList<JTextComponent>();
        }
        for (int h = 0; h < this.textBoxes.size(); ++h) {
            DocumentListener[] list = ((AbstractDocument)this.textBoxes.get(h).getDocument()).getDocumentListeners();
            for (int i = 0; i < list.length; ++i) {
                if (!(list[i] instanceof BadValueDocumentListener)) continue;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("removing a bad value document listener " + list[i]);
                }
                this.textBoxes.get(h).getDocument().removeDocumentListener(list[i]);
                this.textBoxes.get(h).setForeground(Color.BLACK);
            }
        }
    }

    protected void clearLengthDocumentListeners() {
        if (this.textBoxes == null) {
            this.textBoxes = new ArrayList<JTextComponent>();
        }
        for (int h = 0; h < this.textBoxes.size(); ++h) {
            DocumentListener[] list = ((AbstractDocument)this.textBoxes.get(h).getDocument()).getDocumentListeners();
            for (int i = 0; i < list.length; ++i) {
                if (!(list[i] instanceof LengthDocumentListener)) continue;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("removing a length document listener");
                }
                this.textBoxes.get(h).getDocument().removeDocumentListener(list[i]);
                this.textBoxes.get(h).setForeground(Color.BLACK);
            }
        }
    }

    protected void addBadValueDocumentListener(int maxValue, int minValue, SuperJTextField txt) {
        this.initializeTextBox(txt);
        txt.getDocument().addDocumentListener(new BadValueDocumentListener(maxValue, minValue, txt));
    }

    protected void addBadValueDocumentListener(int maxValue, SuperJTextField txt) {
        this.initializeTextBox(txt);
        txt.getDocument().addDocumentListener(new BadValueDocumentListener(maxValue, txt));
    }

    protected void addLengthDocumentListener(int length, JTextComponent txt) {
        this.initializeTextBox(txt);
        txt.getDocument().addDocumentListener(new LengthDocumentListener(length, txt));
    }

    private void initializeTextBox(JTextComponent txt) {
        if (this.textBoxes == null) {
            this.textBoxes = new ArrayList<JTextComponent>();
        }
        if (!this.textBoxes.contains(txt)) {
            this.textBoxes.add(txt);
        }
    }

    public abstract void setNoLimits();

    public abstract void setMinimalLimits();

    public abstract void setExploratoryLimits();

    public abstract void setSafeLimits();

    public abstract void setFiraxisLimits();

    public abstract void setTotalLimits();

    public void setSafetyLevel(SafetyLevel level) {
        if (level.equals((Object)SafetyLevel.None)) {
            this.setNoLimits();
        } else if (level.equals((Object)SafetyLevel.Minimal)) {
            this.setMinimalLimits();
        } else if (level.equals((Object)SafetyLevel.Exploratory)) {
            this.setExploratoryLimits();
        } else if (level.equals((Object)SafetyLevel.Safe)) {
            this.setSafeLimits();
        } else if (level.equals((Object)SafetyLevel.Firaxis)) {
            this.setFiraxisLimits();
        } else if (level.equals((Object)SafetyLevel.Total)) {
            this.setTotalLimits();
        }
        this.updateAllListeners();
    }

    private void updateAllListeners() {
        for (JTextComponent txt : this.textBoxes) {
            DocumentListener[] list = ((AbstractDocument)txt.getDocument()).getDocumentListeners();
            for (int i = 0; i < list.length; ++i) {
                if (list[i] instanceof BadValueDocumentListener) {
                    ((BadValueDocumentListener)list[i]).checkValue();
                }
                if (!(list[i] instanceof LengthDocumentListener)) continue;
                ((LengthDocumentListener)list[i]).checkLength();
            }
        }
    }

    public void sendIOLink(IO io) {
        this.baselink = io;
    }

    public boolean checkBounds(List<String> valuesWithErrors) {
        if (this.textBoxes == null) {
            return true;
        }
        boolean returnValue = true;
        for (int i = 0; i < this.textBoxes.size(); ++i) {
            if (this.textBoxes.get(i).getForeground() != Color.red) continue;
            if (this.textBoxes.get(i) instanceof SuperJTextField && ((SuperJTextField)this.textBoxes.get(i)).getDescription() != null) {
                valuesWithErrors.add(((SuperJTextField)this.textBoxes.get(i)).getDescription());
            }
            returnValue = false;
        }
        return returnValue;
    }

    public void addItem(String name) {
    }

    public void deleteAction() {
    }

    public void renameBIQElement(int id, String newName) {
    }

    public void copyItem(String copyName, int oldIndex) {
    }

    protected void comboBoxSwap(int cmbSource, int cmbDest, JComboBox comboBox) {
        DefaultComboBoxModel model = (DefaultComboBoxModel)comboBox.getModel();
        boolean isSelected = comboBox.getSelectedIndex() == cmbSource;
        Object swappedItem = model.getElementAt(cmbSource);
        model.removeElementAt(cmbSource);
        model.insertElementAt(swappedItem, cmbDest);
        if (isSelected) {
            comboBox.setSelectedIndex(cmbDest);
        }
    }
}

