/*
 * Decompiled with CFR 0.152.
 */
package com.civfanatics.civ3.xplatformeditor;

import com.civfanatics.civ3.biqFile.civ3Version;
import com.civfanatics.civ3.xplatformeditor.BldgTab;
import com.civfanatics.civ3.xplatformeditor.CIVTab;
import com.civfanatics.civ3.xplatformeditor.CTZNTab;
import com.civfanatics.civ3.xplatformeditor.CultTab;
import com.civfanatics.civ3.xplatformeditor.DIFFTab;
import com.civfanatics.civ3.xplatformeditor.ESPNTab;
import com.civfanatics.civ3.xplatformeditor.EXPRTab;
import com.civfanatics.civ3.xplatformeditor.EditorTab;
import com.civfanatics.civ3.xplatformeditor.EraTab;
import com.civfanatics.civ3.xplatformeditor.FLAVTab;
import com.civfanatics.civ3.xplatformeditor.GAMETab;
import com.civfanatics.civ3.xplatformeditor.GOVTTab;
import com.civfanatics.civ3.xplatformeditor.GoodTab;
import com.civfanatics.civ3.xplatformeditor.GraphicsImport;
import com.civfanatics.civ3.xplatformeditor.Listeners.CustomAdjustmentListener;
import com.civfanatics.civ3.xplatformeditor.Main;
import com.civfanatics.civ3.xplatformeditor.MapTab;
import com.civfanatics.civ3.xplatformeditor.PLYRTab;
import com.civfanatics.civ3.xplatformeditor.RULETab;
import com.civfanatics.civ3.xplatformeditor.TERRTab;
import com.civfanatics.civ3.xplatformeditor.TRFMTab;
import com.civfanatics.civ3.xplatformeditor.TechTab;
import com.civfanatics.civ3.xplatformeditor.UnitTab;
import com.civfanatics.civ3.xplatformeditor.WSIZTab;
import com.civfanatics.civ3.xplatformeditor.specialty.SafetyLevel;
import com.civfanatics.civ3.xplatformeditor.tabs.biqc.BIQCTab;
import java.awt.Color;
import java.awt.Component;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class EditorTabbedPane
extends JTabbedPane {
    EditorTab previousTab;
    private static EditorTab[] editorTabs;
    public BIQCTab biqcTab;
    private CultTab cultTab;
    private BldgTab bldgTab;
    private GoodTab goodTab;
    private CIVTab civTab;
    private DIFFTab diffTab;
    private UnitTab unitTab;
    private TechTab techTab;
    private CTZNTab ctznTab;
    private RULETab ruleTab;
    private GOVTTab govtTab;
    private TERRTab terrTab;
    public GAMETab gameTab;
    private EraTab eraTab;
    private ESPNTab espnTab;
    private TRFMTab trfmTab;
    private WSIZTab wsizTab;
    private EXPRTab exprTab;
    PLYRTab plyrTab;
    private FLAVTab flavTab;
    JPanel pnlRULE;
    JPanel pnlBLDG;
    private JScrollPane mapScroll;
    MapTab mapTab;
    private CustomAdjustmentListener scollListener;
    Color[] colors;
    BufferedImage[][] unitIcons;
    Logger logger = Logger.getLogger(EditorTabbedPane.class);

    public void loadInterfaceElements(Color[] colors, BufferedImage[][] unitIcons, BufferedImage[] resourceIcons, BufferedImage units32) {
        boolean flavRemoved = false;
        this.colors = colors;
        this.unitIcons = unitIcons;
        this.unitTab.sendUnitIcons(unitIcons, units32);
        for (EditorTab e : editorTabs) {
            e.sendIOLink(Main.biqFile.get(Main.biqIndex));
            e.newData = true;
            e.setSelectedIndex(-1);
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info("IO links sent");
        }
        if (Main.biqFile.get(Main.biqIndex).hasCustomMap()) {
            this.gameTab.sendMapData(Main.biqFile.get((int)Main.biqIndex).worldCharacteristic);
        }
        if (Main.biqFile.get(Main.biqIndex).hasCustomRules()) {
            this.sendRuleData();
        } else {
            this.sendRuleData();
            for (int i = 1; i < 20; ++i) {
                if (i == 12 || i == 14) continue;
                this.setEnabledAt(i, false);
            }
            flavRemoved = true;
        }
        if (Main.biqFile.get(Main.biqIndex).hasCustomPlayerData()) {
            this.sendPlayerData();
            this.diffTab.sendTabLinks(this.ruleTab, this.plyrTab);
            this.govtTab.sendTabLinks(this.bldgTab, this.civTab, this.plyrTab);
            this.techTab.sendPlayerTab(this.plyrTab);
            this.unitTab.sendPlayerTab(this.plyrTab);
        } else {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Detected no custom player data");
            }
            this.plyrTab.setAllEnabled(false);
            this.setEnabledAt(12, false);
            this.diffTab.sendTabLinks(this.ruleTab);
            this.govtTab.sendTabLinks(this.bldgTab, this.civTab);
        }
        this.ruleTab.sendDiffTab(this.diffTab);
        if (this.logger.isInfoEnabled()) {
            this.logger.info("data links sent to tabs");
        }
        this.civTab.sendTabLinks(this.unitTab, this.gameTab);
        this.goodTab.sendTabLinks(this.terrTab, this.trfmTab, this.unitTab, this.bldgTab, this.ruleTab, this.mapTab);
        this.unitTab.sendTabLinks(this.bldgTab, this.civTab, this.ruleTab, this.mapTab, this.gameTab);
        this.techTab.sendTabLinks(this.goodTab, this.bldgTab, this.civTab, this.unitTab, this.ctznTab, this.govtTab, this.trfmTab);
        if (Main.biqFile.get((int)Main.biqIndex).version == civ3Version.CONQUESTS) {
            this.flavTab.sendTabLinks(this.bldgTab, this.civTab, this.techTab);
        }
        this.bldgTab.sendTabLinks(this.unitTab, this.mapTab);
        if (Main.biqFile.get(Main.biqIndex).hasCustomPlayerData() && Main.biqFile.get(Main.biqIndex).hasCustomMap()) {
            this.plyrTab.sendTabLinks(this.mapTab, this.gameTab);
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info("crosstab links sent");
        }
        for (EditorTab e : editorTabs) {
            e.newData = false;
        }
        if (!flavRemoved && Main.biqFile.get((int)Main.biqIndex).version != civ3Version.CONQUESTS) {
            this.remove(this.flavTab);
        }
        if (Main.GRAPHICS_ENABLED) {
            this.goodTab.sendGoodIcons(resourceIcons);
        }
    }

    void enableCustomRules() {
        for (int i = 1; i < 20; ++i) {
            if (i == 12 || i == 14) continue;
            this.setEnabledAt(i, true);
        }
        this.biqcTab.updateCheckBoxes();
    }

    void enableCustomPlayerData() {
        this.sendPlayerData();
        this.plyrTab.setAllEnabled(true);
        this.setEnabledAt(12, true);
        this.biqcTab.updateCheckBoxes();
    }

    public void sendRuleData() {
        this.logger.debug("About to send to CULT");
        this.cultTab.sendData(Main.biqFile.get((int)Main.biqIndex).culture, Main.biqFile.get((int)Main.biqIndex).rule);
        this.logger.debug("About to send to GOOD");
        this.goodTab.sendData(Main.biqFile.get((int)Main.biqIndex).resource, Main.biqFile.get((int)Main.biqIndex).technology);
        this.logger.debug("About to send to BLDG");
        this.bldgTab.sendData(Main.biqFile.get((int)Main.biqIndex).buildings, Main.biqFile.get((int)Main.biqIndex).resource, Main.biqFile.get((int)Main.biqIndex).government, Main.biqFile.get((int)Main.biqIndex).technology, Main.biqFile.get((int)Main.biqIndex).unit, Main.biqFile.get((int)Main.biqIndex).rule);
        this.logger.debug("Sent to BLDG< now to CIV");
        this.civTab.sendData(Main.biqFile.get((int)Main.biqIndex).civilization, Main.biqFile.get((int)Main.biqIndex).unit, Main.biqFile.get((int)Main.biqIndex).government, Main.biqFile.get((int)Main.biqIndex).eras, Main.biqFile.get((int)Main.biqIndex).technology, this.colors);
        this.diffTab.sendData(Main.biqFile.get((int)Main.biqIndex).difficulties);
        this.unitTab.sendData(Main.biqFile.get((int)Main.biqIndex).unit, Main.biqFile.get((int)Main.biqIndex).technology, Main.biqFile.get((int)Main.biqIndex).resource, Main.biqFile.get((int)Main.biqIndex).terrain, Main.biqFile.get((int)Main.biqIndex).civilization, Main.biqFile.get((int)Main.biqIndex).buildings);
        this.techTab.sendData(Main.biqFile.get((int)Main.biqIndex).technology, Main.biqFile.get((int)Main.biqIndex).eras);
        this.ctznTab.sendData(Main.biqFile.get((int)Main.biqIndex).citizens, Main.biqFile.get((int)Main.biqIndex).technology);
        this.ruleTab.sendData(Main.biqFile.get((int)Main.biqIndex).rule, Main.biqFile.get((int)Main.biqIndex).unit, Main.biqFile.get((int)Main.biqIndex).difficulties, Main.biqFile.get((int)Main.biqIndex).resource, Main.biqFile.get((int)Main.biqIndex).buildings);
        this.govtTab.sendData(Main.biqFile.get((int)Main.biqIndex).government, Main.biqFile.get((int)Main.biqIndex).experience, Main.biqFile.get((int)Main.biqIndex).espionage, Main.biqFile.get((int)Main.biqIndex).technology);
        this.terrTab.sendData(Main.biqFile.get((int)Main.biqIndex).terrain, Main.biqFile.get((int)Main.biqIndex).workerJob, Main.biqFile.get((int)Main.biqIndex).resource);
        this.gameTab.sendRuleData(Main.biqFile.get((int)Main.biqIndex).scenarioProperty, Main.biqFile.get((int)Main.biqIndex).civilization);
        this.eraTab.sendData(Main.biqFile.get((int)Main.biqIndex).eras);
        this.espnTab.sendData(Main.biqFile.get((int)Main.biqIndex).espionage);
        this.trfmTab.sendData(Main.biqFile.get((int)Main.biqIndex).workerJob, Main.biqFile.get((int)Main.biqIndex).technology, Main.biqFile.get((int)Main.biqIndex).resource);
        this.wsizTab.sendData(Main.biqFile.get((int)Main.biqIndex).worldSize);
        this.exprTab.sendData(Main.biqFile.get((int)Main.biqIndex).experience);
        if (Main.biqFile.get((int)Main.biqIndex).version == civ3Version.CONQUESTS) {
            this.flavTab.sendData(Main.biqFile.get((int)Main.biqIndex).flavor);
        }
    }

    public void sendPlayerData() {
        this.plyrTab.sendData(Main.biqFile.get((int)Main.biqIndex).scenarioProperty, Main.biqFile.get((int)Main.biqIndex).player, this.colors, Main.biqFile.get((int)Main.biqIndex).technology, Main.biqFile.get((int)Main.biqIndex).unit, Main.biqFile.get((int)Main.biqIndex).difficulties, Main.biqFile.get((int)Main.biqIndex).government, Main.biqFile.get((int)Main.biqIndex).eras, Main.biqFile.get((int)Main.biqIndex).civilization, Main.biqFile.get(Main.biqIndex));
        if (this.logger.isInfoEnabled()) {
            this.logger.info("custom player data sent");
        }
    }

    public void alertBIQCTab(File file) {
        this.biqcTab.alertToNewlyOpenedFile(file);
    }

    public void initialTabUpdate() {
        for (int i = 0; i < editorTabs.length; ++i) {
            if (!EditorTabbedPane.editorTabs[i].isActive || EditorTabbedPane.editorTabs[i].lstType == null) continue;
            editorTabs[i].updateTab();
            if (editorTabs[i] == this.plyrTab && !Main.biqFile.get(Main.biqIndex).hasCustomPlayerData()) continue;
            EditorTabbedPane.editorTabs[i].lstType.setSelectedIndex(0);
        }
    }

    public void setup(Main main) {
        this.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                EditorTabbedPane.this.pnlTabsStateChanged(evt);
            }
        });
        this.setTabLayoutPolicy(1);
        this.setVisible(false);
        this.biqcTab = new BIQCTab();
        this.cultTab = new CultTab();
        this.bldgTab = new BldgTab();
        this.civTab = new CIVTab();
        this.goodTab = new GoodTab();
        this.diffTab = new DIFFTab();
        this.unitTab = new UnitTab();
        this.techTab = new TechTab();
        this.ctznTab = new CTZNTab();
        this.ruleTab = new RULETab();
        this.govtTab = new GOVTTab();
        this.terrTab = new TERRTab();
        this.gameTab = new GAMETab();
        this.eraTab = new EraTab();
        this.espnTab = new ESPNTab();
        this.trfmTab = new TRFMTab();
        this.wsizTab = new WSIZTab();
        this.exprTab = new EXPRTab();
        this.plyrTab = new PLYRTab();
        this.flavTab = new FLAVTab();
        this.mapTab = new MapTab(this.mapScroll, this.scollListener, main);
        JPanel pnlBIQC = this.biqcTab.createTab();
        JPanel pnlCULT = this.cultTab.createTab();
        this.pnlBLDG = this.bldgTab.createTab();
        JPanel pnlGOOD = this.goodTab.createTab();
        JPanel pnlCIV = this.civTab.createTab();
        JPanel pnlDIFF = this.diffTab.createTab();
        JPanel pnlPRTO = this.unitTab.createTab();
        JPanel pnlTECH = this.techTab.createTab();
        JPanel pnlCTZN = this.ctznTab.createTab();
        this.pnlRULE = this.ruleTab.createTab();
        JPanel pnlGOVT = this.govtTab.createTab();
        JPanel pnlTERR = this.terrTab.createTab();
        JPanel pnlGAME = this.gameTab.createTab();
        JPanel pnlERA = this.eraTab.createTab();
        JPanel pnlESPN = this.espnTab.createTab();
        JPanel pnlTRFM = this.trfmTab.createTab();
        JPanel pnlWSIZ = this.wsizTab.createTab();
        JPanel pnlEXPR = this.exprTab.createTab();
        JPanel pnlPLYR = this.plyrTab.createTab();
        JPanel pnlFLAV = this.flavTab.createTab();
        try {
            this.addTabb("BIC", pnlBIQC);
            this.addTabb("BLDG", this.pnlBLDG);
            this.addTabb("CIV", pnlCIV);
            this.addTabb("CTZN", pnlCTZN);
            this.addTabb("CULT", pnlCULT);
            this.addTabb("DIFF", pnlDIFF);
            this.addTabb("ERA", pnlERA);
            this.addTabb("ESPN", pnlESPN);
            this.addTabb("EXPR", pnlEXPR);
            this.addTabb("FLAV", pnlFLAV);
            this.addTabb("GOOD", pnlGOOD);
            this.addTabb("GOVT", pnlGOVT);
            this.addTabb("PLYR", pnlPLYR);
            this.addTabb("RULE", this.pnlRULE);
            this.addTabb("PROP", pnlGAME);
            this.addTabb("TECH", pnlTECH);
            this.addTabb("TERR", pnlTERR);
            this.addTabb("TFRM", pnlTRFM);
            this.addTabb("Unit", pnlPRTO);
            this.addTabb("WSIZ", pnlWSIZ);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.logger.error("Caught!", e);
            this.logger.error(e.getCause());
        }
        if (Main.GRAPHICS_ENABLED) {
            this.addTab("MAP", this.mapTab);
            int i = this.getTabCount();
            this.setEnabledAt(i - 1, false);
        }
        this.biqcTab.sendData(Main.biqFile, null, main);
        editorTabs = new EditorTab[19];
        EditorTabbedPane.editorTabs[0] = this.bldgTab;
        EditorTabbedPane.editorTabs[1] = this.ctznTab;
        EditorTabbedPane.editorTabs[2] = this.cultTab;
        EditorTabbedPane.editorTabs[3] = this.diffTab;
        EditorTabbedPane.editorTabs[4] = this.eraTab;
        EditorTabbedPane.editorTabs[5] = this.espnTab;
        EditorTabbedPane.editorTabs[6] = this.exprTab;
        EditorTabbedPane.editorTabs[7] = this.flavTab;
        EditorTabbedPane.editorTabs[8] = this.goodTab;
        EditorTabbedPane.editorTabs[9] = this.govtTab;
        EditorTabbedPane.editorTabs[10] = this.gameTab;
        EditorTabbedPane.editorTabs[11] = this.unitTab;
        EditorTabbedPane.editorTabs[12] = this.techTab;
        EditorTabbedPane.editorTabs[13] = this.terrTab;
        EditorTabbedPane.editorTabs[14] = this.trfmTab;
        EditorTabbedPane.editorTabs[15] = this.wsizTab;
        EditorTabbedPane.editorTabs[16] = this.plyrTab;
        EditorTabbedPane.editorTabs[17] = this.ruleTab;
        EditorTabbedPane.editorTabs[18] = this.civTab;
    }

    private void pnlTabsStateChanged(ChangeEvent evt) {
        if (Main.fileOpen) {
            Component selectedComponent;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("State of tab panel changed");
            }
            if ((selectedComponent = this.getSelectedComponent()) instanceof JScrollPane) {
                selectedComponent = ((JScrollPane)selectedComponent).getViewport().getView();
            }
            if (selectedComponent instanceof JPanel) {
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace("instaneof JPanel");
                }
                if (this.previousTab != null) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("tab changed.  sending update notice to previous tab " + this.previousTab.getName());
                    }
                    this.previousTab.updateTab();
                    this.previousTab.setSelectedIndex(-1);
                }
                JPanel tmpPanel = (JPanel)selectedComponent;
                String[] editorTabPanels = new String[]{"BLDG", "RACE", "CTZN", "CULT", "DIFF", "ERAS", "ESPN", "EXPR", "FLAV", "GOVT", "GOOD", "RULE", "GAME", "TECH", "TERR", "TRFM", "PRTO", "WSIZ", "PLYR"};
                String pnlName = tmpPanel.getName();
                boolean instanceofEditorTab = false;
                for (int i = 0; i < editorTabPanels.length; ++i) {
                    if (!editorTabPanels[i].equals(pnlName)) continue;
                    instanceofEditorTab = true;
                }
                if (instanceofEditorTab) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("new tab is instanceof EditorPanel.  updating appropriately");
                    }
                    if (this.previousTab == null && (EditorTab)tmpPanel == this.unitTab) {
                        this.unitTab.displayIcon(Main.biqFile.get((int)Main.biqIndex).unit.get(0).getIconIndex());
                    }
                    this.previousTab = (EditorTab)tmpPanel;
                    if (tmpPanel == this.pnlRULE) {
                        this.ruleTab.updateTab();
                    }
                    if (tmpPanel == this.gameTab) {
                        this.gameTab.setSelectedIndex(0);
                    }
                    if (pnlName.equals("PLYR")) {
                        this.plyrTab.updateTab();
                    }
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Selected component: " + tmpPanel.getName() + "\n" + tmpPanel.toString());
                }
            }
            if (Main.GRAPHICS_ENABLED) {
                if (this.getSelectedComponent() == this.mapTab) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Map panel selected");
                    }
                    this.mapTab.map.activeTab = true;
                    this.mapTab.map.triggerUpdates();
                    this.mapTab.showGraphics();
                } else {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Map panel not selected");
                    }
                    this.mapTab.map.activeTab = false;
                }
            }
        }
    }

    public void addTabb(String title, Component component) {
        JScrollPane scrPane = new JScrollPane(component);
        scrPane.getHorizontalScrollBar().setUnitIncrement(10);
        scrPane.getVerticalScrollBar().setUnitIncrement(10);
        this.addTab(title, scrPane);
    }

    public boolean checkBounds() {
        ArrayList<String> valuesWithErrors = new ArrayList<String>();
        for (EditorTab e : editorTabs) {
            if (e.checkBounds(valuesWithErrors)) continue;
            if (valuesWithErrors.size() == 0) {
                JOptionPane.showMessageDialog(null, "At least one value on tab " + e.getName() + " does not fall within the bounds of your safety level.\nPlease change safety levels, or change the value(s) such that they fall within the bounds of the safety level.", "Unsafe values!", 2);
                return false;
            }
            StringBuilder sb = new StringBuilder();
            sb.append("The follow values on the ").append(e.getName()).append(" tab are not valid:\n\n\t");
            for (String value : valuesWithErrors) {
                sb.append(value).append("\n");
            }
            sb.append("\nPlease change safety levels, or change the value(s) such that they fall within the bounds of the safety level.");
            JOptionPane.showMessageDialog(null, sb.toString(), "Unsafe values!", 2);
            return false;
        }
        return true;
    }

    public void updateAllTabs() {
        for (int i = 0; i < editorTabs.length; ++i) {
            editorTabs[i].updateTab();
        }
    }

    public void checkForMapUpdates() {
        if (Main.GRAPHICS_ENABLED && this.mapTab != null) {
            this.mapTab.map.triggerUpdates();
        }
    }

    public void importMapGraphics() {
        GraphicsImport gi = new GraphicsImport(Main.biqFile.get(Main.biqIndex), Main.settings, this.mapTab.map, this.colors, this, this.mapTab, this.unitIcons);
        gi.start();
    }

    public void alertToSafetyUpdate(Map safetyLevels) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("The user requested a change in the safety levels");
        }
        for (EditorTab e : editorTabs) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Safety level for " + e.tabName + ": " + (Object)((Object)((SafetyLevel)((Object)safetyLevels.get(e.tabName)))));
            }
            String tabName = e.tabName.equals("GAME") ? "PROP" : e.tabName;
            e.setSafetyLevel((SafetyLevel)((Object)safetyLevels.get(tabName)));
        }
    }
}

