/*
 * Decompiled with CFR 0.152.
 */
package com.civfanatics.civ3.xplatformeditor;

import com.civfanatics.civ3.biqFile.BLDG;
import com.civfanatics.civ3.biqFile.FLAV;
import com.civfanatics.civ3.biqFile.RACE;
import com.civfanatics.civ3.biqFile.TECH;
import com.civfanatics.civ3.biqFile.civ3Version;
import com.civfanatics.civ3.xplatformeditor.BldgTab;
import com.civfanatics.civ3.xplatformeditor.CIVTab;
import com.civfanatics.civ3.xplatformeditor.EditorTab;
import com.civfanatics.civ3.xplatformeditor.FlavTable;
import com.civfanatics.civ3.xplatformeditor.TechTab;
import com.civfanatics.civ3.xplatformeditor.utils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;

public class FLAVTab
extends EditorTab {
    FlavTable tableModel;
    JMenuItem add;
    JMenuItem delete;
    JMenuItem rename;
    private DefaultListModel flavListModel;
    public List<FLAV> flavors = new ArrayList<FLAV>();
    int flavIndex;
    private JList lstFlavors;
    private JScrollPane scrFlavorList;
    private JScrollPane scrFlavorRelations;
    private JTable tblFlavors;

    public FLAVTab() {
        this.flavListModel = new DefaultListModel();
        this.tabName = "FLAV";
        this.tableModel = new FlavTable();
        this.scrFlavorRelations = new JScrollPane();
        this.tblFlavors = new JTable(this.tableModel);
        this.scrFlavorList = new JScrollPane();
        this.lstFlavors = new JList();
        this.flavIndex = -1;
        this.setName(this.tabName);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("intiailized FLAVTab");
        }
        this.add = new JMenuItem();
        this.add.setText("Add");
        this.delete = new JMenuItem();
        this.delete.setText("Delete");
        this.rename = new JMenuItem();
        this.rename.setText("Rename");
        this.lstFlavors.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                FLAVTab.this.lstFlavorsPopup(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                FLAVTab.this.lstFlavorsPopup(evt);
            }
        });
        this.add.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                String name = JOptionPane.showInputDialog("Please choose a name for the new flavor");
                FLAVTab.this.addFlavor(name);
                FLAVTab.this.lstFlavors.setSelectedIndex(FLAVTab.this.flavListModel.size() - 1);
            }
        });
        this.delete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FLAVTab.this.deleteFlavor();
            }
        });
        this.rename.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FLAVTab.this.renameFlavor();
            }
        });
    }

    private void renameFlavor() {
        String existingName = this.lstFlavors.getSelectedValue().toString();
        String newName = (String)JOptionPane.showInputDialog(null, "Please enter the new name for this flavor", "New Flavor Name", -1, null, null, existingName);
        if (newName == null || newName.equals("")) {
            return;
        }
        if (newName.length() > 255) {
            JOptionPane.showMessageDialog(null, "The flavor name cannot exceed 255 characters", "Too long", 0);
            return;
        }
        int index = this.lstFlavors.getSelectedIndex();
        this.flavors.get((int)index).name = newName;
        Vector<String> names = new Vector<String>(this.flavors.size());
        for (int i = 0; i < this.flavors.size(); ++i) {
            names.add(utils.cTrim(this.flavors.get(i).getName()));
        }
        this.tableModel.setHeaders(names);
        this.flavListModel.set(index, newName);
        this.tableModel.updateGUI();
        this.updateTab();
    }

    private void deleteFlavor() {
        int i;
        if (this.flavors.size() == 1) {
            JOptionPane.showMessageDialog(null, "You cannot delete the last flavor.", "Cannot delete", 0);
            return;
        }
        int index = this.lstFlavors.getSelectedIndex();
        for (BLDG bldg : this.baselink.buildings) {
            bldg.handleDeletedFlavour(index);
        }
        for (TECH tech : this.baselink.technology) {
            tech.handleDeletedFlavour(index);
        }
        for (RACE civilization : this.baselink.civilization) {
            civilization.handleDeletedFlavour(index);
        }
        this.flavors.remove(index);
        for (i = 0; i < this.flavors.size(); ++i) {
            this.flavors.get((int)i).relationWithOtherFlavor.remove(index);
            --this.flavors.get((int)i).numberOfFlavors;
        }
        this.tableModel.removeFlavor(index);
        this.flavListModel.removeAllElements();
        this.lstFlavors.setModel(this.flavListModel);
        for (i = 0; i < this.flavors.size(); ++i) {
            this.flavListModel.addElement(utils.cTrim(this.flavors.get((int)i).name));
        }
        Vector<String> names = new Vector<String>(this.flavors.size());
        for (int i2 = 0; i2 < this.flavors.size(); ++i2) {
            names.add(utils.cTrim(this.flavors.get(i2).getName()));
        }
        this.tableModel.setHeaders(names);
        this.updateTab();
    }

    private void addFlavor(String name) {
        for (int i = 0; i < this.flavors.size(); ++i) {
            ++this.flavors.get((int)i).numberOfFlavors;
            this.flavors.get((int)i).relationWithOtherFlavor.add(50);
        }
        this.flavors.add(new FLAV(this.baselink, name));
        int newsize = this.flavors.size();
        for (int i = 0; i < newsize; ++i) {
            this.flavors.get((int)(newsize - 1)).relationWithOtherFlavor.add(50);
        }
        this.flavors.get((int)(newsize - 1)).numberOfFlavors = newsize;
        this.updateData(this.flavors);
        for (BLDG bldg : this.baselink.buildings) {
            bldg.handleAddedFlavour();
        }
        for (TECH tech : this.baselink.technology) {
            tech.handleAddedFlavour();
        }
        for (RACE civilization : this.baselink.civilization) {
            civilization.handleAddedFlavour();
        }
    }

    private void lstFlavorsPopup(MouseEvent evt) {
        if (evt.isPopupTrigger()) {
            this.lstFlavors.setSelectedIndex(this.lstFlavors.locationToIndex(new Point(evt.getX(), evt.getY())));
            JPopupMenu popUp = new JPopupMenu();
            popUp.add(this.add);
            popUp.add(this.rename);
            popUp.add(this.delete);
            Component component = evt.getComponent();
            int x = evt.getX();
            int y = evt.getY();
            popUp.show(component, x, y);
        }
    }

    @Override
    public void setSelectedIndex(int i) {
        this.flavIndex = i;
    }

    @Override
    public void updateTab() {
        if (this.baselink.version != civ3Version.CONQUESTS) {
            return;
        }
        if (this.flavIndex != -1) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("saving flavor data");
            }
            for (int i = 0; i < this.flavors.size(); ++i) {
                for (int j = 0; j < this.flavors.size(); ++j) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("i: " + i + ", j: " + j);
                    }
                    if (i == 7 && j == 0 && this.logger.isDebugEnabled()) {
                        this.logger.debug("debug')");
                    }
                    String valueAt = String.valueOf(this.tableModel.getValueAt(i, j + 1));
                    this.flavors.get((int)i).relationWithOtherFlavor.set(j, Integer.valueOf(valueAt));
                }
            }
        }
        this.flavIndex = 0;
        this.displayData();
    }

    private void displayData() {
        if (this.flavIndex != -1) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("updating table");
            }
            this.tableModel.sendUpdate(this.flavors);
        }
    }

    public JPanel createTab() {
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints g = new GridBagConstraints();
        this.setLayout(gbl);
        this.tblFlavors.setAutoResizeMode(0);
        this.tblFlavors.setSelectionMode(0);
        this.tblFlavors.setCellSelectionEnabled(true);
        this.scrFlavorRelations.setViewportView(this.tblFlavors);
        this.scrFlavorRelations.setPreferredSize(new Dimension(850, 600));
        this.scrFlavorRelations.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.scrFlavorList.setViewportView(this.lstFlavors);
        g.gridwidth = 1;
        g.gridheight = 1;
        g.gridx = 0;
        g.gridy = 0;
        g.weighty = 1.0;
        g.weightx = 0.125;
        g.fill = 1;
        this.add((Component)this.scrFlavorList, g);
        ++g.gridx;
        g.weightx = 0.875;
        this.add((Component)this.scrFlavorRelations, g);
        return this;
    }

    public void sendData(List<FLAV> flavors) {
        int i;
        int i2;
        this.flavors = flavors;
        this.tableModel.clear();
        for (i2 = 0; i2 < flavors.size(); ++i2) {
            this.tableModel.addRow();
        }
        for (i2 = -1; i2 < flavors.size(); ++i2) {
            this.tableModel.addColumn();
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(this.tableModel.getRowCount() + ", col: " + this.tableModel.getColumnCount());
        }
        Vector<String> names = new Vector<String>(flavors.size());
        for (i = 0; i < flavors.size(); ++i) {
            names.add(utils.cTrim(flavors.get(i).getName()));
        }
        this.tableModel.setHeaders(names);
        this.tableModel.updateGUI();
        this.flavListModel.removeAllElements();
        this.lstFlavors.setModel(this.flavListModel);
        for (i = 0; i < flavors.size(); ++i) {
            this.flavListModel.addElement(utils.cTrim(flavors.get((int)i).name));
        }
        this.updateTab();
    }

    public void updateData(List<FLAV> flavors) {
        int i;
        this.flavors = flavors;
        this.tableModel.addFullRow();
        this.tableModel.addColumn(50);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(this.tableModel.getRowCount() + ", col: " + this.tableModel.getColumnCount());
        }
        Vector<String> names = new Vector<String>(flavors.size());
        for (i = 0; i < flavors.size(); ++i) {
            names.add(utils.cTrim(flavors.get(i).getName()));
        }
        this.tableModel.setHeaders(names);
        this.tableModel.updateGUI();
        this.flavListModel.removeAllElements();
        this.lstFlavors.setModel(this.flavListModel);
        for (i = 0; i < flavors.size(); ++i) {
            this.flavListModel.addElement(utils.cTrim(flavors.get((int)i).name));
        }
        this.updateTab();
    }

    public void sendTabLinks(BldgTab bldgTab, CIVTab civTab, TechTab techTab) {
        bldgTab.lstBLDGFlavors.setModel(this.flavListModel);
        civTab.lstFlavors.setModel(this.flavListModel);
        techTab.lstFlavors.setModel(this.flavListModel);
    }

    @Override
    public void setNoLimits() {
        this.clearBadValueDocumentListeners();
        this.clearLengthDocumentListeners();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("SETTING NO LIMITS");
        }
    }

    @Override
    public void setMinimalLimits() {
        this.setNoLimits();
    }

    @Override
    public void setExploratoryLimits() {
        this.setNoLimits();
    }

    @Override
    public void setSafeLimits() {
        this.setNoLimits();
    }

    @Override
    public void setFiraxisLimits() {
        this.setNoLimits();
    }

    @Override
    public void setTotalLimits() {
        this.setNoLimits();
    }
}

