/*
 * Decompiled with CFR 0.152.
 */
package com.civfanatics.civ3.xplatformeditor;

import com.civfanatics.civ3.biqFile.FLAV;
import java.util.List;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import org.apache.log4j.Logger;

public class FlavTable
extends AbstractTableModel {
    private String[] columnNames;
    Logger logger = Logger.getLogger(this.getClass());
    private Vector<Vector<Object>> data = new Vector();
    boolean addingFlavor = false;

    @Override
    public int getColumnCount() {
        if (this.data.size() == 0) {
            return 0;
        }
        return this.data.get(0).size();
    }

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    @Override
    public Object getValueAt(int x, int y) {
        return this.data.get(x).get(y);
    }

    @Override
    public String getColumnName(int col) {
        if (col > this.columnNames.length) {
            return "";
        }
        return this.columnNames[col];
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return col != 0 || this.addingFlavor;
    }

    @Override
    public void setValueAt(Object value, int x, int y) {
        this.data.get(x).set(y, Integer.valueOf((String)value));
        this.fireTableCellUpdated(x, y);
    }

    public void addRow() {
        this.data.add(new Vector());
    }

    public void addFullRow() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("ADDING FULL ROW TO FLAVTABLE");
        }
        Vector<Integer> newRow = new Vector<Integer>();
        for (int i = 0; i <= this.data.size(); ++i) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("i: " + i);
            }
            newRow.add(50);
        }
        this.data.add(newRow);
    }

    public void addColumn() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("ADDING COLUMN TO FLAVTABLE");
        }
        for (int i = 0; i < this.data.size(); ++i) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("i: " + i);
            }
            this.data.get(i).add(0);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("ADDING COLUMN TO FLAVTABLE");
        }
    }

    public void addColumn(int start) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("ADDING COLUMN TO FLAVTABLE");
        }
        for (int i = 0; i < this.data.size(); ++i) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("i: " + i);
            }
            this.data.get(i).add(start);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("ADDING COLUMN TO FLAVTABLE");
        }
    }

    public void removeFlavor(int flavor) {
        for (int i = 0; i < this.data.size(); ++i) {
            this.data.get(i).remove(flavor);
        }
        this.data.remove(flavor);
        this.updateGUI();
    }

    public void clear() {
        this.data = new Vector();
    }

    public void updateGUI() {
        this.fireTableStructureChanged();
    }

    public void setHeaders(Vector<String> headers) {
        this.addingFlavor = true;
        this.columnNames = new String[headers.size() + 1];
        this.columnNames[0] = "";
        for (int i = 0; i < this.data.size(); ++i) {
            this.data.get(i).set(0, headers.get(i));
            this.columnNames[i + 1] = headers.get(i);
        }
        this.addingFlavor = false;
    }

    public void sendUpdate(List<FLAV> flavors) {
        for (int i = 0; i < flavors.size(); ++i) {
            for (int j = 0; j < flavors.get((int)i).relationWithOtherFlavor.size(); ++j) {
                this.data.get(i).set(j + 1, flavors.get((int)i).relationWithOtherFlavor.get(j));
            }
        }
        this.fireTableStructureChanged();
    }
}

