/*
 * Decompiled with CFR 0.152.
 */
package com.civfanatics.civ3.xplatformeditor;

import com.civfanatics.civ3.biqFile.BLDG;
import com.civfanatics.civ3.biqFile.GOOD;
import com.civfanatics.civ3.biqFile.PRTO;
import com.civfanatics.civ3.biqFile.RULE;
import com.civfanatics.civ3.biqFile.TECH;
import com.civfanatics.civ3.biqFile.TERR;
import com.civfanatics.civ3.biqFile.TILE;
import com.civfanatics.civ3.biqFile.TRFM;
import com.civfanatics.civ3.xplatformeditor.BldgTab;
import com.civfanatics.civ3.xplatformeditor.CustomComponents.ImprovedListView;
import com.civfanatics.civ3.xplatformeditor.CustomComponents.SuperJList;
import com.civfanatics.civ3.xplatformeditor.CustomComponents.SuperJTextField;
import com.civfanatics.civ3.xplatformeditor.CustomComponents.SuperListModel;
import com.civfanatics.civ3.xplatformeditor.EditorTab;
import com.civfanatics.civ3.xplatformeditor.IconPanel;
import com.civfanatics.civ3.xplatformeditor.Main;
import com.civfanatics.civ3.xplatformeditor.MapTab;
import com.civfanatics.civ3.xplatformeditor.RULETab;
import com.civfanatics.civ3.xplatformeditor.TERRTab;
import com.civfanatics.civ3.xplatformeditor.TRFMTab;
import com.civfanatics.civ3.xplatformeditor.UnitTab;
import com.civfanatics.civ3.xplatformeditor.civilopedia.CivilopediaIcon;
import com.civfanatics.civ3.xplatformeditor.specialty.PredicateFactory;
import com.civfanatics.civ3.xplatformeditor.utils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.List;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.embed.swing.JFXPanel;
import javafx.scene.Scene;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jdesktop.layout.GroupLayout;

public class GoodTab
extends EditorTab {
    public List<GOOD> resource;
    public List<TECH> technology;
    public List<BLDG> building;
    public List<PRTO> unit;
    public List<TERR> terrain;
    public List<TRFM> workerJob;
    public List<RULE> rule;
    int goodIndex;
    boolean tabCreated;
    private SuperListModel goodList;
    TERRTab terrTab;
    RULETab ruleTab;
    UnitTab unitTab;
    TRFMTab trfmTab;
    BldgTab bldgTab;
    MapTab mapTab;
    private ButtonGroup btnGroupGOODType;
    BufferedImage[] goodIcons;
    private IconPanel pnlLargeIcon = new IconPanel();
    DefaultComboBoxModel mdlPrerequisite = new DefaultComboBoxModel();
    JMenuItem delete;
    JMenuItem add;
    final JFXPanel jFXPanel = new JFXPanel();
    ImprovedListView<GOOD> goodListUI;
    ObservableList<GOOD> observableTechList = FXCollections.observableArrayList();
    public JComboBox cmbGOODPrerequisite;
    private JLabel lblCivilopediaEntry;
    private JLabel lblPrerequisites;
    private JLabel jLabel66;
    private JLabel lblShields;
    private JLabel lblCommerce;
    private JLabel lblappearanceRatio;
    private JLabel lblDisappearanceRatio;
    private JLabel lblAppearancesOnMap = new JLabel();
    private JLabel lblIcon;
    private JPanel pnlBonuses;
    private JPanel pnlType;
    private JScrollPane scrGoods;
    private SuperJList lstGoods = new SuperJList(this, "good", true, true, true);
    private JRadioButton rbtnGOODBonus;
    private JRadioButton rbtnGOODLuxury;
    private JRadioButton rbtnGOODStrategic;
    private SuperJTextField txtGOODAppearanceRatio;
    private SuperJTextField txtGOODCivilopediaEntry;
    private SuperJTextField txtGOODCommerceBonus;
    private SuperJTextField txtGOODDisapperanceProbability;
    private SuperJTextField txtGOODFoodBonus;
    private SuperJTextField txtGOODIcon;
    private SuperJTextField txtGOODShieldsBonus;

    public GoodTab() {
        if (Main.settings.useJavaFX) {
            this.setupJavaFX();
        }
        this.lstType = this.lstGoods;
        this.tabName = "GOOD";
    }

    public JPanel createTab() {
        this.textBoxes = new ArrayList();
        this.scrGoods = new JScrollPane();
        this.lblCivilopediaEntry = new JLabel();
        this.txtGOODCivilopediaEntry = new SuperJTextField();
        this.txtGOODCivilopediaEntry.setDescription(Main.i18n("general.civilopediaEntry"));
        this.lblPrerequisites = new JLabel();
        this.cmbGOODPrerequisite = new JComboBox();
        this.pnlBonuses = new JPanel();
        this.jLabel66 = new JLabel();
        this.lblShields = new JLabel();
        this.lblCommerce = new JLabel();
        this.txtGOODFoodBonus = new SuperJTextField();
        this.txtGOODShieldsBonus = new SuperJTextField();
        this.txtGOODCommerceBonus = new SuperJTextField();
        this.txtGOODFoodBonus.setDescription(Main.i18n("good.food"));
        this.txtGOODShieldsBonus.setDescription(Main.i18n("good.shields"));
        this.txtGOODCommerceBonus.setDescription(Main.i18n("good.commerce"));
        this.pnlType = new JPanel();
        this.rbtnGOODStrategic = new JRadioButton();
        this.rbtnGOODLuxury = new JRadioButton();
        this.rbtnGOODBonus = new JRadioButton();
        this.lblappearanceRatio = new JLabel();
        this.lblDisappearanceRatio = new JLabel();
        this.txtGOODAppearanceRatio = new SuperJTextField();
        this.txtGOODDisapperanceProbability = new SuperJTextField();
        this.txtGOODAppearanceRatio.setDescription(Main.i18n("good.appearanceRatio"));
        this.txtGOODDisapperanceProbability.setDescription(Main.i18n("good.disappearanceRatio"));
        this.lblIcon = new JLabel();
        this.txtGOODIcon = new SuperJTextField();
        this.txtGOODIcon.setDescription(Main.i18n("good.icon"));
        this.btnGroupGOODType = new ButtonGroup();
        this.lstGoods.setSelectionMode(0);
        this.lstGoods.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                GoodTab.this.lstGoodsValueChanged(evt);
            }
        });
        this.scrGoods.setViewportView(this.lstGoods);
        this.lblCivilopediaEntry.setText(Main.i18n("general.civilopediaEntry") + ":");
        this.lblPrerequisites.setText(Main.i18n("general.prerequisite") + ":");
        this.cmbGOODPrerequisite.setModel(this.mdlPrerequisite);
        this.pnlBonuses.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Main.i18n("good.bonuses")));
        this.jLabel66.setText(Main.i18n("good.food") + ":");
        this.lblShields.setText(Main.i18n("good.shields") + ":");
        this.lblCommerce.setText(Main.i18n("good.commerce") + ":");
        this.pnlLargeIcon.setPreferredSize(new Dimension(128, 128));
        GroupLayout pnlBonusesLayout = new GroupLayout(this.pnlBonuses);
        this.pnlBonuses.setLayout(pnlBonusesLayout);
        pnlBonusesLayout.setHorizontalGroup(pnlBonusesLayout.createParallelGroup(1).add(2, pnlBonusesLayout.createSequentialGroup().addContainerGap().add(pnlBonusesLayout.createParallelGroup(1).add(this.lblCommerce).add(this.lblShields).add(this.jLabel66)).addPreferredGap(0).add(pnlBonusesLayout.createParallelGroup(1).add(2, this.txtGOODShieldsBonus, -1, 43, Short.MAX_VALUE).add(2, this.txtGOODCommerceBonus, -1, 43, Short.MAX_VALUE).add(2, this.txtGOODFoodBonus, -1, 43, Short.MAX_VALUE)).addContainerGap()));
        pnlBonusesLayout.setVerticalGroup(pnlBonusesLayout.createParallelGroup(1).add(pnlBonusesLayout.createSequentialGroup().addContainerGap().add(pnlBonusesLayout.createParallelGroup(1).add(2, this.jLabel66).add(2, pnlBonusesLayout.createSequentialGroup().add(this.txtGOODFoodBonus, -2, -1, -2).add(1, 1, 1))).addPreferredGap(0).add(pnlBonusesLayout.createParallelGroup(3).add(this.lblShields).add(this.txtGOODShieldsBonus, -2, -1, -2)).addPreferredGap(0).add(pnlBonusesLayout.createParallelGroup(3).add(this.lblCommerce).add(this.txtGOODCommerceBonus, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pnlType.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Main.i18n("good.type")));
        this.rbtnGOODStrategic.setText(Main.i18n("good.strategic"));
        this.rbtnGOODLuxury.setText(Main.i18n("good.luxury"));
        this.rbtnGOODBonus.setText(Main.i18n("good.bonus"));
        GroupLayout pnlTypeLayout = new GroupLayout(this.pnlType);
        this.pnlType.setLayout(pnlTypeLayout);
        pnlTypeLayout.setHorizontalGroup(pnlTypeLayout.createParallelGroup(1).add(pnlTypeLayout.createSequentialGroup().addContainerGap().add(pnlTypeLayout.createParallelGroup(1).add(this.rbtnGOODStrategic).add(this.rbtnGOODLuxury).add(this.rbtnGOODBonus)).addContainerGap(9, Short.MAX_VALUE)));
        pnlTypeLayout.setVerticalGroup(pnlTypeLayout.createParallelGroup(1).add(pnlTypeLayout.createSequentialGroup().add(this.rbtnGOODStrategic).addPreferredGap(1).add(this.rbtnGOODLuxury).addPreferredGap(1).add(this.rbtnGOODBonus).addContainerGap(9, Short.MAX_VALUE)));
        this.lblappearanceRatio.setText(Main.i18n("good.appearanceRatio") + ":");
        this.lblDisappearanceRatio.setText(Main.i18n("good.disappearanceRatio") + ":");
        this.lblAppearancesOnMap.setText("Appearances on Map: 0");
        this.lblIcon.setText(Main.i18n("good.icon") + ":");
        this.txtGOODIcon.setText("             ");
        GroupLayout thisLayout = new GroupLayout(this);
        this.setLayout(thisLayout);
        Object listComponent = Main.settings.useJavaFX ? this.jFXPanel : this.scrGoods;
        thisLayout.setHorizontalGroup(thisLayout.createParallelGroup(1).add(thisLayout.createSequentialGroup().add((Component)listComponent, -2, 165, -2).addPreferredGap(0).add(thisLayout.createParallelGroup(2).add(1, thisLayout.createSequentialGroup().add(this.lblDisappearanceRatio).add(25, 25, 25).add(thisLayout.createParallelGroup(2, false).add(1, this.txtGOODAppearanceRatio).add(1, this.txtGOODDisapperanceProbability, -1, 48, Short.MAX_VALUE))).add(1, thisLayout.createSequentialGroup().add(thisLayout.createParallelGroup(2, false).add(1, thisLayout.createSequentialGroup().add(this.pnlBonuses, -2, -1, -2).addPreferredGap(0).add(this.pnlType, -1, -1, Short.MAX_VALUE).addPreferredGap(0).add(this.pnlLargeIcon, -1, -1, Short.MAX_VALUE)).add(1, thisLayout.createSequentialGroup().add(thisLayout.createParallelGroup(1).add(this.lblCivilopediaEntry).add(this.lblPrerequisites)).addPreferredGap(0).add(thisLayout.createParallelGroup(1, false).add(this.cmbGOODPrerequisite, 0, -1, Short.MAX_VALUE).add(this.txtGOODCivilopediaEntry, -1, 161, Short.MAX_VALUE))).add(thisLayout.createParallelGroup(1, false).add(this.cmbGOODPrerequisite, 0, -1, Short.MAX_VALUE).add(this.txtGOODCivilopediaEntry, -1, 161, Short.MAX_VALUE))).addPreferredGap(0).add(this.lblIcon).addPreferredGap(1).add(this.txtGOODIcon, -2, 40, -2)).add(1, this.lblappearanceRatio).add(1, this.lblAppearancesOnMap)).addContainerGap()));
        thisLayout.setVerticalGroup(thisLayout.createParallelGroup(1).add((Component)listComponent, -1, 679, Short.MAX_VALUE).add(thisLayout.createSequentialGroup().addContainerGap().add(thisLayout.createParallelGroup(3).add(this.lblCivilopediaEntry).add(this.txtGOODCivilopediaEntry, -2, -1, -2).add(this.lblIcon).add(this.txtGOODIcon, -2, -1, -2)).addPreferredGap(0).add(thisLayout.createParallelGroup(3).add(this.lblPrerequisites).add(this.cmbGOODPrerequisite, -2, -1, -2)).addPreferredGap(0).add(thisLayout.createParallelGroup(1).add(this.pnlType, -1, -1, -2).add(this.pnlBonuses, -2, -1, -2).add(this.pnlLargeIcon, -2, -1, -2)).add(10, 10, 10).add(thisLayout.createParallelGroup(3).add(this.lblappearanceRatio).add(this.txtGOODAppearanceRatio, -2, -1, -2)).addPreferredGap(0).add(thisLayout.createParallelGroup(3).add(this.lblDisappearanceRatio).add(this.txtGOODDisapperanceProbability, -2, -1, -2)).add(10, 10, 10).add(thisLayout.createParallelGroup(3).add(this.lblAppearancesOnMap)).addContainerGap(-1, Short.MAX_VALUE)));
        if (Main.settings.useJavaFX) {
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    Scene scene = new Scene(GoodTab.this.goodListUI, 170.0, 670.0);
                    GoodTab.this.jFXPanel.setScene(scene);
                }
            });
        }
        this.btnGroupGOODType.add(this.rbtnGOODStrategic);
        this.btnGroupGOODType.add(this.rbtnGOODLuxury);
        this.btnGroupGOODType.add(this.rbtnGOODBonus);
        this.setName("GOOD");
        this.tabCreated = true;
        return this;
    }

    private void setupJavaFX() {
        this.goodListUI = new ImprovedListView<GOOD>("resource", this.resource, this.observableTechList, PredicateFactory.createGOODFilter());
        this.goodListUI.setAddAction(this::addItem);
        this.goodListUI.setCopyAction(this::copyItem);
        this.goodListUI.setRenameAction(this::renameItem);
        this.goodListUI.setDeleteAction(this::deleteAction);
        this.goodListUI.setChangeFunction(this::updateTab);
        this.goodListUI.setSwapFunction(this::swapOrder);
    }

    public void sendGoodIcons(BufferedImage[] goodIcons) {
        this.goodIcons = goodIcons;
    }

    public void sendData(final List<GOOD> resource, List<TECH> technology) {
        int i;
        assert (this.tabCreated) : "The tab must be created before data is send to it.";
        this.resource = resource;
        this.technology = technology;
        this.goodIndex = -1;
        this.goodList = new SuperListModel();
        this.lstGoods.setModel(this.goodList);
        this.cmbGOODPrerequisite.removeAllItems();
        this.cmbGOODPrerequisite.addItem("None");
        for (i = 0; i < technology.size(); ++i) {
            utils.addWithPossibleDuplicates(technology.get(i).getName(), this.mdlPrerequisite);
        }
        for (i = 0; i < resource.size(); ++i) {
            this.goodList.addElement(resource.get(i).getName());
        }
        if (Main.settings.useJavaFX) {
            this.goodListUI.setBaseItems(this.resource);
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    for (int i = 0; i < resource.size(); ++i) {
                        GoodTab.this.observableTechList.add(resource.get(i));
                    }
                }
            });
        }
    }

    @Override
    public void setSelectedIndex(int i) {
        this.goodIndex = i;
    }

    public void sendTabLinks(TERRTab terrTab, TRFMTab trfmTab, UnitTab unitTab, BldgTab bldgTab, RULETab ruleTab, MapTab mapTab) {
        this.terrTab = terrTab;
        this.trfmTab = trfmTab;
        this.unitTab = unitTab;
        this.bldgTab = bldgTab;
        this.ruleTab = ruleTab;
        this.mapTab = mapTab;
    }

    public void setDependencies(List<BLDG> building, List<PRTO> unit, List<RULE> rule, List<TERR> terrain, List<TRFM> workerJob) {
        this.building = building;
        this.unit = unit;
        this.rule = rule;
        this.terrain = terrain;
        this.workerJob = workerJob;
    }

    @Override
    public void updateTab() {
        this.updateTab(null);
    }

    public void updateTab(GOOD newlySelectedGood) {
        if (this.goodIndex != -1) {
            this.resource.get(this.goodIndex).setCivilopediaEntry(this.txtGOODCivilopediaEntry.getText());
            this.resource.get(this.goodIndex).setAppearanceRatio(this.txtGOODAppearanceRatio.getInteger());
            this.resource.get(this.goodIndex).setDisapperanceProbability(this.txtGOODDisapperanceProbability.getInteger());
            this.resource.get(this.goodIndex).setIcon(this.txtGOODIcon.getInteger());
            this.resource.get(this.goodIndex).setPrerequisite(this.cmbGOODPrerequisite.getSelectedIndex() - 1);
            this.resource.get(this.goodIndex).setFoodBonus(this.txtGOODFoodBonus.getInteger());
            this.resource.get(this.goodIndex).setShieldsBonus(this.txtGOODShieldsBonus.getInteger());
            this.resource.get(this.goodIndex).setCommerceBonus(this.txtGOODCommerceBonus.getInteger());
            if (this.rbtnGOODStrategic.isSelected()) {
                this.resource.get(this.goodIndex).setType(2);
            } else if (this.rbtnGOODLuxury.isSelected()) {
                this.resource.get(this.goodIndex).setType(1);
            } else {
                this.resource.get(this.goodIndex).setType(0);
            }
        }
        this.goodIndex = Main.settings.useJavaFX ? (newlySelectedGood != null ? newlySelectedGood.getIndex() : -1) : this.lstGoods.getSelectedIndex();
        if (this.goodIndex != -1) {
            this.txtGOODCivilopediaEntry.setText(this.resource.get(this.goodIndex).getCivilopediaEntry());
            this.txtGOODAppearanceRatio.setText(Integer.toString(this.resource.get(this.goodIndex).getAppearanceRatio()));
            this.txtGOODDisapperanceProbability.setText(Integer.toString(this.resource.get(this.goodIndex).getDisapperanceProbability()));
            this.txtGOODIcon.setText(Integer.toString(this.resource.get(this.goodIndex).getIcon()));
            this.cmbGOODPrerequisite.setSelectedIndex(this.resource.get(this.goodIndex).getPrerequisite() + 1);
            this.txtGOODFoodBonus.setText(Integer.toString(this.resource.get(this.goodIndex).getFoodBonus()));
            this.txtGOODShieldsBonus.setText(Integer.toString(this.resource.get(this.goodIndex).getShieldsBonus()));
            this.txtGOODCommerceBonus.setText(Integer.toString(this.resource.get(this.goodIndex).getCommerceBonus()));
            if (this.resource.get(this.goodIndex).getType() == 0) {
                this.rbtnGOODBonus.setSelected(true);
                this.rbtnGOODLuxury.setSelected(false);
                this.rbtnGOODStrategic.setSelected(false);
            }
            if (this.resource.get(this.goodIndex).getType() == 1) {
                this.rbtnGOODBonus.setSelected(false);
                this.rbtnGOODLuxury.setSelected(true);
                this.rbtnGOODStrategic.setSelected(false);
            }
            if (this.resource.get(this.goodIndex).getType() == 2) {
                this.rbtnGOODBonus.setSelected(false);
                this.rbtnGOODLuxury.setSelected(false);
                this.rbtnGOODStrategic.setSelected(true);
            }
            if (this.baselink.hasCustomMap()) {
                int resourceCount = 0;
                for (TILE tile : this.baselink.tile) {
                    if (tile.getResource() != this.goodIndex) continue;
                    ++resourceCount;
                }
                this.lblAppearancesOnMap.setText("Appearances on Map: " + resourceCount);
            }
            this.updateResourceIcon();
        }
    }

    private void updateResourceIcon() {
        if (this.goodIndex != -1 && Main.GRAPHICS_ENABLED) {
            try {
                BufferedImage img = CivilopediaIcon.getLargeCivilopediaIcon(this.resource.get(this.goodIndex));
                if (img != null) {
                    this.pnlLargeIcon.setVisible(true);
                    this.pnlLargeIcon.setImage(img);
                    Graphics g = this.pnlLargeIcon.getGraphics();
                    this.pnlLargeIcon.update(g);
                    g.dispose();
                } else {
                    this.pnlLargeIcon.setVisible(false);
                }
            }
            catch (FileNotFoundException ex) {
                this.logger.warn("Scenario file not found", ex);
            }
        }
    }

    private void lstGoodsValueChanged(ListSelectionEvent evt) {
        this.updateTab();
    }

    @Override
    public void setNoLimits() {
        this.clearBadValueDocumentListeners();
        this.clearLengthDocumentListeners();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("SETTING NO LIMITS");
        }
    }

    @Override
    public void setMinimalLimits() {
        this.clearBadValueDocumentListeners();
        this.clearLengthDocumentListeners();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("SETTING MINIMAL LIMITS");
        }
        this.addLengthDocumentListener(31, this.txtGOODCivilopediaEntry);
    }

    @Override
    public void setExploratoryLimits() {
        this.clearBadValueDocumentListeners();
        this.clearLengthDocumentListeners();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("SETTING EXPLORATORY LIMITS");
        }
        this.setMinimalLimits();
    }

    @Override
    public void setSafeLimits() {
        this.clearBadValueDocumentListeners();
        this.clearLengthDocumentListeners();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("SETTING SAFE LIMITS");
        }
        this.setFiraxisLimits();
    }

    @Override
    public void setFiraxisLimits() {
        this.clearBadValueDocumentListeners();
        this.clearLengthDocumentListeners();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("SETTING FIRAXIS LIMITS");
        }
        this.setMinimalLimits();
        this.addBadValueDocumentListener(10000, this.txtGOODDisapperanceProbability);
        this.addBadValueDocumentListener(900, this.txtGOODAppearanceRatio);
        this.addBadValueDocumentListener(35, this.txtGOODIcon);
        this.addBadValueDocumentListener(25, -25, this.txtGOODFoodBonus);
        this.addBadValueDocumentListener(25, -25, this.txtGOODCommerceBonus);
        this.addBadValueDocumentListener(25, -25, this.txtGOODShieldsBonus);
    }

    @Override
    public void setTotalLimits() {
        this.clearBadValueDocumentListeners();
        this.clearLengthDocumentListeners();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("SETTING TOTAL LIMITS");
        }
        this.setFiraxisLimits();
    }

    public void renameItem(GOOD good) {
        String name = utils.getItemName("Rename " + good.getName(), "Good Name", "Enter new name for " + good.getName() + ": ", good.getName());
        if (name.length() > 0) {
            good.setName(name);
            int n = good.getIndex() + 1;
        }
    }

    public void swapOrder(int source, int destination) {
        this.goodIndex = source < destination ? destination : destination + 1;
        this.updateOrderInOtherTabs(source, destination, this.resource.get(this.goodIndex).getName());
    }

    private void updateOrderInOtherTabs(int source, int destination, String goodName) {
        int cmbSource = source + 1;
        int cmbDest = destination + 1;
        if (source > destination) {
            ++cmbDest;
            ++destination;
        }
        if (this.baselink.hasCustomMap()) {
            this.comboBoxSwap(cmbSource, cmbDest, this.mapTab.cmbResource);
            for (TILE t : this.baselink.tile) {
                t.handleSwappedGood();
            }
        }
        if (this.baselink.hasCustomRules()) {
            this.comboBoxSwap(cmbSource, cmbDest, this.ruleTab.cmbRULEDefaultMoneyResource);
            this.baselink.rule.get(0).handleSwappedGood();
            this.comboBoxSwap(cmbSource, cmbDest, this.trfmTab.cmbTRFMRequiredResource1);
            this.comboBoxSwap(cmbSource, cmbDest, this.trfmTab.cmbTRFMRequiredResource2);
            for (TRFM trfm : this.baselink.workerJob) {
                trfm.handleSwappedGood();
            }
            this.comboBoxSwap(cmbSource, cmbDest, this.bldgTab.cmbBLDGReqResource1);
            this.comboBoxSwap(cmbSource, cmbDest, this.bldgTab.cmbBLDGReqResource2);
            for (BLDG bldg : this.baselink.buildings) {
                bldg.handleSwappedGood();
            }
            this.comboBoxSwap(cmbSource, cmbDest, this.unitTab.cmbPRTORequiredResource1);
            this.comboBoxSwap(cmbSource, cmbDest, this.unitTab.cmbPRTORequiredResource2);
            this.comboBoxSwap(cmbSource, cmbDest, this.unitTab.cmbPRTORequiredResource3);
            for (PRTO prto : this.baselink.unit) {
                prto.handleSwappedGOOD();
            }
            for (TERR terr : this.baselink.terrain) {
                terr.handleSwappedGOOD(source, destination);
            }
            this.terrTab.initializeResourceList();
            this.terrTab.displayPossibleResources(this.terrTab.lstTerrains.getSelectedIndex());
        }
    }

    @Override
    public boolean checkBounds(List<String> invalidValues) {
        if (this.goodIndex == -1) {
            return true;
        }
        return super.checkBounds(invalidValues);
    }

    @Override
    public void renameBIQElement(int index, String name) {
        this.resource.get(index).setName(name);
    }

    public void deleteAction(GOOD deletedGood) {
        int j;
        int i;
        int index = -1;
        index = !Main.settings.useJavaFX ? this.lstGoods.getSelectedIndex() : deletedGood.getIndex();
        if (this.baselink.hasCustomMap()) {
            if (this.mapTab.cmbResource.getSelectedIndex() - 1 == index) {
                this.mapTab.cmbResource.setSelectedIndex(0);
            } else if (this.mapTab.cmbResource.getSelectedIndex() - 1 > index) {
                this.mapTab.cmbResource.setSelectedIndex(this.mapTab.cmbResource.getSelectedIndex() - 1);
            }
            this.mapTab.resourceModel.removeElementAt(index + 1);
            for (i = 0; i < this.baselink.tile.size(); ++i) {
                if (this.baselink.tile.get((int)i).resourceInt == index) {
                    this.baselink.tile.get((int)i).resourceInt = -1;
                    continue;
                }
                if (this.baselink.tile.get((int)i).resourceInt <= index) continue;
                --this.baselink.tile.get((int)i).resourceInt;
            }
        }
        if (this.ruleTab.cmbRULEDefaultMoneyResource.getSelectedIndex() - 1 == index) {
            this.ruleTab.rule.get(0).setDefaultMoneyResource(-1);
            this.ruleTab.cmbRULEDefaultMoneyResource.setSelectedIndex(0);
        } else if (this.ruleTab.cmbRULEDefaultMoneyResource.getSelectedIndex() - 1 > index) {
            this.ruleTab.rule.get(0).setDefaultMoneyResource(this.ruleTab.rule.get(0).getDefaultMoneyResource() - 1);
            this.ruleTab.cmbRULEDefaultMoneyResource.setSelectedIndex(this.ruleTab.cmbRULEDefaultMoneyResource.getSelectedIndex() - 1);
        }
        this.ruleTab.mdlDefaultMoneyResource.removeElementAt(index + 1);
        if (this.trfmTab.cmbTRFMRequiredResource1.getSelectedIndex() - 1 == index) {
            this.trfmTab.cmbTRFMRequiredResource1.setSelectedIndex(0);
        }
        if (this.trfmTab.cmbTRFMRequiredResource2.getSelectedIndex() - 1 == index) {
            this.trfmTab.cmbTRFMRequiredResource2.setSelectedIndex(0);
        }
        this.trfmTab.mdlRequiredResource1.removeElementAt(index + 1);
        this.trfmTab.mdlRequiredResource2.removeElementAt(index + 1);
        for (i = 0; i < this.trfmTab.workerJob.size(); ++i) {
            this.trfmTab.workerJob.get(i).handleDeletedGood(index);
        }
        if (this.bldgTab.cmbBLDGReqResource1.getSelectedIndex() - 1 == index) {
            this.bldgTab.cmbBLDGReqResource1.setSelectedIndex(0);
        }
        if (this.bldgTab.cmbBLDGReqResource2.getSelectedIndex() - 1 == index) {
            this.bldgTab.cmbBLDGReqResource2.setSelectedIndex(0);
        }
        this.bldgTab.mdlReqResource1.removeElementAt(index + 1);
        this.bldgTab.mdlReqResource2.removeElementAt(index + 1);
        for (i = 0; i < this.bldgTab.buildings.size(); ++i) {
            if (this.bldgTab.buildings.get(i).getReqResource1() == index) {
                this.bldgTab.buildings.get(i).setReqResource1(-1);
            } else if (this.bldgTab.buildings.get(i).getReqResource1() > index) {
                this.bldgTab.buildings.get(i).setReqResource1(this.bldgTab.buildings.get(i).getReqResource1() - 1);
            }
            if (this.bldgTab.buildings.get(i).getReqResource2() == index) {
                this.bldgTab.buildings.get(i).setReqResource2(-1);
                continue;
            }
            if (this.bldgTab.buildings.get(i).getReqResource2() <= index) continue;
            this.bldgTab.buildings.get(i).setReqResource2(this.bldgTab.buildings.get(i).getReqResource2() - 1);
        }
        if (this.unitTab.cmbPRTORequiredResource1.getSelectedIndex() - 1 == index) {
            this.unitTab.cmbPRTORequiredResource1.setSelectedIndex(0);
        }
        if (this.unitTab.cmbPRTORequiredResource2.getSelectedIndex() - 1 == index) {
            this.unitTab.cmbPRTORequiredResource2.setSelectedIndex(0);
        }
        if (this.unitTab.cmbPRTORequiredResource3.getSelectedIndex() - 1 == index) {
            this.unitTab.cmbPRTORequiredResource3.setSelectedIndex(0);
        }
        this.unitTab.mdlRequiredResource1.removeElementAt(index + 1);
        this.unitTab.mdlRequiredResource2.removeElementAt(index + 1);
        this.unitTab.mdlRequiredResource3.removeElementAt(index + 1);
        for (PRTO prto : this.unitTab.unit) {
            prto.handleDeletedResource(index);
        }
        int[] selected = this.terrTab.lstTERRResources.getSelectedIndices();
        boolean thisOneFound = false;
        for (int i2 = 0; i2 < selected.length; ++i2) {
            if (selected[i2] != index) continue;
            thisOneFound = true;
        }
        int len = selected.length;
        if (thisOneFound) {
            --len;
        }
        int[] newSelected = new int[len];
        int count = 0;
        for (j = 0; j < selected.length; ++j) {
            if (selected[j] < index) {
                newSelected[count] = selected[j];
                ++count;
                continue;
            }
            if (selected[j] <= index) continue;
            newSelected[count] = selected[j] - 1;
            ++count;
        }
        this.terrTab.resourceList.removeElementAt(index);
        this.terrTab.lstTERRResources.setSelectedIndices(newSelected);
        for (j = 0; j < this.terrTab.terrain.size(); ++j) {
            this.logger.trace("Removing good " + index + " from terrain " + j);
            this.terrTab.terrain.get((int)j).allowedResources.remove(index);
            --this.terrTab.terrain.get((int)j).numPossibleResources;
        }
        this.goodIndex = -1;
        utils.removeFromList(index, this.resource, this.goodList, (JList)this.lstGoods);
        for (GOOD good : this.resource) {
            if (good.getIndex() <= index) continue;
            good.setIndex(good.getIndex() - 1);
        }
    }

    @Override
    public void addItem(String name) {
        this.addGood(name, new GOOD(name, this.baselink));
    }

    public void copyItem(GOOD resource, String name) {
        GOOD copiedGood = resource.clone();
        copiedGood.setName(name);
        this.addGood(name, copiedGood);
    }

    public void addGood(String name, GOOD newGood) {
        newGood.setIndex(this.resource.size());
        this.resource.add(newGood);
        utils.addWithPossibleDuplicates(name, this.bldgTab.mdlReqResource1);
        utils.addWithPossibleDuplicates(name, this.bldgTab.mdlReqResource2);
        utils.addWithPossibleDuplicates(name, this.unitTab.mdlRequiredResource1);
        utils.addWithPossibleDuplicates(name, this.unitTab.mdlRequiredResource2);
        utils.addWithPossibleDuplicates(name, this.unitTab.mdlRequiredResource3);
        utils.addWithPossibleDuplicates(name, this.ruleTab.mdlDefaultMoneyResource);
        utils.addWithPossibleDuplicates(name, this.mapTab.resourceModel);
        this.terrTab.resourceList.addElement(name);
        for (int i = 0; i < this.terrTab.terrain.size(); ++i) {
            this.terrTab.terrain.get((int)i).allowedResources.add(false);
        }
        utils.addWithPossibleDuplicates(name, this.trfmTab.mdlRequiredResource1);
        utils.addWithPossibleDuplicates(name, this.trfmTab.mdlRequiredResource2);
    }
}

