/*
 * Decompiled with CFR 0.152.
 */
package com.civfanatics.civ3.xplatformeditor;

import com.civfanatics.civ3.biqFile.IO;
import com.civfanatics.civ3.xplatformeditor.Main;
import com.civfanatics.civ3.xplatformeditor.MapPanel;
import com.civfanatics.civ3.xplatformeditor.MapTab;
import com.civfanatics.civ3.xplatformeditor.PCXImportThread;
import com.civfanatics.civ3.xplatformeditor.Settings;
import com.civfanatics.civ3.xplatformeditor.imageSupport.Civ3PCXFilter;
import com.civfanatics.civ3.xplatformeditor.tabs.map.GraphicsAssets;
import com.civfanatics.civ3.xplatformeditor.utils;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RasterFormatException;
import java.io.FileNotFoundException;
import javax.swing.JOptionPane;
import javax.swing.JTabbedPane;
import org.apache.log4j.Logger;

public class GraphicsImport
extends Thread {
    IO biq;
    static Logger logger = Logger.getLogger("GraphicsImport");
    static final String newline = System.getProperty("line.separator");
    static final String fileSlash = System.getProperty("file.separator");
    Settings settings;
    MapPanel mapPanel;
    MapTab mapTab;
    Color[] colors;
    JTabbedPane tabs;
    BufferedImage[][] unitIcons;
    static final int NUM_TNT_DUPLICATES = 3;

    public GraphicsImport(IO biq, Settings settings, MapPanel mapPanel, Color[] colors, JTabbedPane tabs, MapTab mapTab, BufferedImage[][] unitIcons) {
        this.biq = biq;
        this.settings = settings;
        this.mapPanel = mapPanel;
        this.colors = colors;
        this.tabs = tabs;
        this.mapTab = mapTab;
        this.unitIcons = unitIcons;
    }

    @Override
    public void run() {
        try {
            this.importGraphicsMultithreaded();
            System.gc();
            logger.info("Graphics loaded.  Memory in use: " + Runtime.getRuntime().totalMemory() / 1024L + " KB");
            logger.info("Graphics loaded.  Memory available: " + Runtime.getRuntime().maxMemory() / 1024L + " KB");
        }
        catch (OutOfMemoryError e) {
            logger.error("Out of memory", e);
            logger.error("Memory in use: " + Runtime.getRuntime().totalMemory() / 1024L + " KB");
            logger.error("Memory available: " + Runtime.getRuntime().maxMemory() / 1024L + " KB");
            JOptionPane.showMessageDialog(null, "<html>Out of memory.  This is likely to occur with graphics (map) enabled when not using the launcher.  Please check that<br><ul><li>You are using the launcher if you are using the map</li><li>You are not trying to open multiple BIQs at once</li></ul><br>If you aren't doing either of these, please make a post on the forum including what scenario you were trying to open.<br>You will still be able to edit the non-map parts of the BIQ, although disabling the map in Settings (Main tab) and restarting is recommended.</html>", "Out of memory", 0);
        }
    }

    private void importGraphicsMultithreaded() {
        int j;
        int j2;
        int k;
        int j3;
        long startGraphics = System.nanoTime();
        String[] baseTerrainNames = new String[9];
        try {
            baseTerrainNames[0] = utils.findFile("xtgc.pcx", "Art" + fileSlash + "Terrain" + fileSlash, this.biq);
            baseTerrainNames[1] = utils.findFile("xpgc.pcx", "Art" + fileSlash + "Terrain" + fileSlash, this.biq);
            baseTerrainNames[2] = utils.findFile("xdgc.pcx", "Art" + fileSlash + "Terrain" + fileSlash, this.biq);
            baseTerrainNames[3] = utils.findFile("xdpc.pcx", "Art" + fileSlash + "Terrain" + fileSlash, this.biq);
            baseTerrainNames[4] = utils.findFile("xdgp.pcx", "Art" + fileSlash + "Terrain" + fileSlash, this.biq);
            baseTerrainNames[5] = utils.findFile("xggc.pcx", "Art" + fileSlash + "Terrain" + fileSlash, this.biq);
            baseTerrainNames[6] = utils.findFile("wCSO.pcx", "Art" + fileSlash + "Terrain" + fileSlash, this.biq);
            baseTerrainNames[7] = utils.findFile("wSSS.pcx", "Art" + fileSlash + "Terrain" + fileSlash, this.biq);
            baseTerrainNames[8] = utils.findFile("wOOO.pcx", "Art" + fileSlash + "Terrain" + fileSlash, this.biq);
        }
        catch (FileNotFoundException e) {
            logger.error("Could not find one of the terrain graphics; civInstallDir = " + this.settings.civInstallDir, e);
            JOptionPane.showMessageDialog(null, "Could not find one of the terrain graphics.  The civ install dir (" + this.settings.civInstallDir + ") being incorrect may cause this problem.  This can be changed by clicking on the Settings button.\nError: " + e.getMessage());
            return;
        }
        String[] lmTerrainNames = new String[9];
        try {
            lmTerrainNames[0] = utils.findFile("lxtgc.pcx", "Art" + fileSlash + "Terrain" + fileSlash, this.biq);
            lmTerrainNames[1] = utils.findFile("lxpgc.pcx", "Art" + fileSlash + "Terrain" + fileSlash, this.biq);
            lmTerrainNames[2] = utils.findFile("lxdgc.pcx", "Art" + fileSlash + "Terrain" + fileSlash, this.biq);
            lmTerrainNames[3] = utils.findFile("lxdpc.pcx", "Art" + fileSlash + "Terrain" + fileSlash, this.biq);
            lmTerrainNames[4] = utils.findFile("lxdgp.pcx", "Art" + fileSlash + "Terrain" + fileSlash, this.biq);
            lmTerrainNames[5] = utils.findFile("lxggc.pcx", "Art" + fileSlash + "Terrain" + fileSlash, this.biq);
            lmTerrainNames[6] = utils.findFile("lwCSO.pcx", "Art" + fileSlash + "Terrain" + fileSlash, this.biq);
            lmTerrainNames[7] = utils.findFile("lwSSS.pcx", "Art" + fileSlash + "Terrain" + fileSlash, this.biq);
            lmTerrainNames[8] = utils.findFile("lwOOO.pcx", "Art" + fileSlash + "Terrain" + fileSlash, this.biq);
        }
        catch (FileNotFoundException e) {
            logger.error("Could not find one of the terrain graphics; civInstallDir = " + this.settings.civInstallDir, e);
            JOptionPane.showMessageDialog(null, "Could not find one of the terrain graphics.  The civ install dir (" + this.settings.civInstallDir + ") being incorrect may cause this problem.  This can be changed by clicking on the Settings button.\nError: " + e.getMessage());
            return;
        }
        String grassForestName = null;
        try {
            grassForestName = utils.findFile("grassland forests.pcx", "Art" + fileSlash + "Terrain" + fileSlash, this.biq);
        }
        catch (FileNotFoundException e) {
            logger.error("Could not find xhills.pcx; civInstallDir = " + this.settings.civInstallDir, e);
            JOptionPane.showMessageDialog(null, "Could not find grassland forests.pcx.  The civ install dir (" + this.settings.civInstallDir + ") being incorrect may cause this problem.  This can be changed by clicking on the Settings button.\nError: " + e.getMessage());
            return;
        }
        String plainsForestName = null;
        try {
            plainsForestName = utils.findFile("plains forests.pcx", "Art" + fileSlash + "Terrain" + fileSlash, this.biq);
        }
        catch (FileNotFoundException e) {
            logger.error("Could not find xhills.pcx; civInstallDir = " + this.settings.civInstallDir, e);
            JOptionPane.showMessageDialog(null, "Could not find plains forests.pcx.  The civ install dir (" + this.settings.civInstallDir + ") being incorrect may cause this problem.  This can be changed by clicking on the Settings button.\nError: " + e.getMessage());
            return;
        }
        String tundraForestName = null;
        try {
            tundraForestName = utils.findFile("tundra forests.pcx", "Art" + fileSlash + "Terrain" + fileSlash, this.biq);
        }
        catch (FileNotFoundException e) {
            logger.error("Could not find tundra forests.pcx; civInstallDir = " + this.settings.civInstallDir, e);
            JOptionPane.showMessageDialog(null, "Could not find tundra forests.pcx.  The civ install dir (" + this.settings.civInstallDir + ") being incorrect may cause this problem.  This can be changed by clicking on the Settings button.\nError: " + e.getMessage());
            return;
        }
        String marshName = null;
        try {
            marshName = utils.findFile("marsh.pcx", "Art" + fileSlash + "Terrain" + fileSlash, this.biq);
        }
        catch (FileNotFoundException e) {
            logger.error("Could not find marsh.pcx; civInstallDir = " + this.settings.civInstallDir, e);
            JOptionPane.showMessageDialog(null, "Could not find grassland forests.pcx.  The civ install dir (" + this.settings.civInstallDir + ") being incorrect may cause this problem.  This can be changed by clicking on the Settings button.\nError: " + e.getMessage());
            return;
        }
        String roadName = null;
        try {
            roadName = utils.findFile("roads.pcx", "Art" + fileSlash + "Terrain" + fileSlash, this.biq);
        }
        catch (FileNotFoundException e) {
            logger.error("Could not find roads.pcx; civInstallDir = " + this.settings.civInstallDir, e);
            JOptionPane.showMessageDialog(null, "Could not find roads.pcx.  The civ install dir (" + this.settings.civInstallDir + ") being incorrect may cause this problem.  This can be changed by clicking on the Settings button.\nError: " + e.getMessage());
            return;
        }
        String railroadName = null;
        try {
            railroadName = utils.findFile("railroads.pcx", "Art" + fileSlash + "Terrain" + fileSlash, this.biq);
        }
        catch (FileNotFoundException e) {
            logger.error("Could not find railroads.pcx; civInstallDir = " + this.settings.civInstallDir, e);
            JOptionPane.showMessageDialog(null, "Could not find railroads.pcx.  The civ install dir (" + this.settings.civInstallDir + ") being incorrect may cause this problem.  This can be changed by clicking on the Settings button.\nError: " + e.getMessage());
            return;
        }
        String irrigationName = null;
        try {
            irrigationName = utils.findFile("irrigation.pcx", "Art" + fileSlash + "Terrain" + fileSlash, this.biq);
        }
        catch (FileNotFoundException e) {
            logger.error("Could not find irrigation.pcx; civInstallDir = " + this.settings.civInstallDir, e);
            JOptionPane.showMessageDialog(null, "Could not find irrigation.pcx.  The civ install dir (" + this.settings.civInstallDir + ") being incorrect may cause this problem.  This can be changed by clicking on the Settings button.\nError: " + e.getMessage());
            return;
        }
        String plainsIrrigationName = null;
        try {
            plainsIrrigationName = utils.findFile("irrigation PLAINS.pcx", "Art" + fileSlash + "Terrain" + fileSlash, this.biq);
        }
        catch (FileNotFoundException e) {
            logger.error("Could not find irrigation PLAINS.pcx; civInstallDir = " + this.settings.civInstallDir, e);
            JOptionPane.showMessageDialog(null, "Could not find irrigation PLAINS.pcx.  The civ install dir (" + this.settings.civInstallDir + ") being incorrect may cause this problem.  This can be changed by clicking on the Settings button.\nError: " + e.getMessage());
            return;
        }
        String desertIrrigationName = null;
        try {
            desertIrrigationName = utils.findFile("irrigation DESETT.pcx", "Art" + fileSlash + "Terrain" + fileSlash, this.biq);
        }
        catch (FileNotFoundException e) {
            logger.error("Could not find irrigation DESETT.pcx (Firaxis's typo); civInstallDir = " + this.settings.civInstallDir, e);
            JOptionPane.showMessageDialog(null, "Could not find irrigation DESETT.pcx (Firaxis's typo).  The civ install dir (" + this.settings.civInstallDir + ") being incorrect may cause this problem.  This can be changed by clicking on the Settings button.\nError: " + e.getMessage());
            return;
        }
        String tundraIrrigationName = null;
        try {
            tundraIrrigationName = utils.findFile("irrigation TUNDRA.pcx", "Art" + fileSlash + "Terrain" + fileSlash, this.biq);
        }
        catch (FileNotFoundException e) {
            logger.error("Could not find irrigation TUNDRA.pcx; civInstallDir = " + this.settings.civInstallDir, e);
            JOptionPane.showMessageDialog(null, "Could not find irrigation TUNDRA.pcx.  The civ install dir (" + this.settings.civInstallDir + ") being incorrect may cause this problem.  This can be changed by clicking on the Settings button.\nError: " + e.getMessage());
            return;
        }
        String riverName = null;
        try {
            riverName = utils.findFile("mtnRivers.pcx", "Art" + fileSlash + "Terrain" + fileSlash, this.biq);
        }
        catch (FileNotFoundException e) {
            logger.error("Could not find mtnRivers.pcx; civInstallDir = " + this.settings.civInstallDir, e);
            JOptionPane.showMessageDialog(null, "Could not find mtnRivers.pcx.  The civ install dir (" + this.settings.civInstallDir + ") being incorrect may cause this problem.  This can be changed by clicking on the Settings button.\nError: " + e.getMessage());
            return;
        }
        String buildingName = null;
        try {
            buildingName = utils.findFile("TerrainBuildings.pcx", "Art" + fileSlash + "Terrain" + fileSlash, this.biq);
        }
        catch (FileNotFoundException e) {
            logger.error("Could not find TerrainBuildings.pcx; civInstallDir = " + this.settings.civInstallDir, e);
            JOptionPane.showMessageDialog(null, "Could not find TerrainBuildings.pcx.  The civ install dir (" + this.settings.civInstallDir + ") being incorrect may cause this problem.  This can be changed by clicking on the Settings button.\nError: " + e.getMessage());
            return;
        }
        String tntName = null;
        try {
            tntName = utils.findFile("tnt.pcx", "Art" + fileSlash + "Terrain" + fileSlash, this.biq);
        }
        catch (FileNotFoundException e) {
            logger.error("Could not find tnt.pcx; civInstallDir = " + this.settings.civInstallDir, e);
            JOptionPane.showMessageDialog(null, "Could not find tnt.pcx.  The civ install dir (" + this.settings.civInstallDir + ") being incorrect may cause this problem.  This can be changed by clicking on the Settings button.\nError: " + e.getMessage());
            return;
        }
        String goodyhutName = null;
        try {
            goodyhutName = utils.findFile("goodyhuts.pcx", "Art" + fileSlash + "Terrain" + fileSlash, this.biq);
        }
        catch (FileNotFoundException e) {
            logger.error("Could not find goodyhuts.pcx; civInstallDir = " + this.settings.civInstallDir, e);
            JOptionPane.showMessageDialog(null, "Could not find TerrainBuildings.pcx.  The civ install dir (" + this.settings.civInstallDir + ") being incorrect may cause this problem.  This can be changed by clicking on the Settings button.\nError: " + e.getMessage());
            return;
        }
        String startingLocationName = null;
        try {
            startingLocationName = utils.findFile("StartLoc.pcx", "Art" + fileSlash + "Terrain" + fileSlash, this.biq);
        }
        catch (FileNotFoundException e) {
            logger.error("Could not find StartLoc.pcx; civInstallDir = " + this.settings.civInstallDir, e);
            JOptionPane.showMessageDialog(null, "Could not find StartLoc.pcx.  The civ install dir (" + this.settings.civInstallDir + ") being incorrect may cause this problem.  This can be changed by clicking on the Settings button.\nError: " + e.getMessage());
            return;
        }
        String resourceName = null;
        try {
            resourceName = utils.findFile("resources.pcx", "Art" + fileSlash, this.biq);
        }
        catch (FileNotFoundException e) {
            logger.error("Could not find resources.pcx; civInstallDir = " + this.settings.civInstallDir, e);
            JOptionPane.showMessageDialog(null, "Could not find resources.pcx.  The civ install dir (" + this.settings.civInstallDir + ") being incorrect may cause this problem.  This can be changed by clicking on the Settings button.\nError: " + e.getMessage());
            return;
        }
        String lmTerrOverlayName = null;
        try {
            lmTerrOverlayName = utils.findFile("landmark_terrain.pcx", "Art" + fileSlash + "Terrain" + fileSlash, this.biq);
        }
        catch (FileNotFoundException e) {
            logger.error("Could not find landmark_terrain.pcx; civInstallDir = " + this.settings.civInstallDir, e);
            JOptionPane.showMessageDialog(null, "Could not find landmark_terrain.pcx.  The civ install dir (" + this.settings.civInstallDir + ") being incorrect may cause this problem.  This can be changed by clicking on the Settings button.\nError: " + e.getMessage());
            return;
        }
        String americanName = null;
        String americanWName = null;
        String europeanName = null;
        String europeanWName = null;
        String mediterraneanName = null;
        String mediterraneanWName = null;
        String midEastName = null;
        String midEastWName = null;
        String asianName = null;
        String asianWName = null;
        try {
            americanName = utils.findFile("rAMER.pcx", "Art" + fileSlash + "Cities" + fileSlash, this.biq);
            americanWName = utils.findFile("AMERWALL.pcx", "Art" + fileSlash + "Cities" + fileSlash, this.biq);
            europeanName = utils.findFile("rEURO.pcx", "Art" + fileSlash + "Cities" + fileSlash, this.biq);
            europeanWName = utils.findFile("EUROWALL.pcx", "Art" + fileSlash + "Cities" + fileSlash, this.biq);
            mediterraneanName = utils.findFile("rROMAN.pcx", "Art" + fileSlash + "Cities" + fileSlash, this.biq);
            mediterraneanWName = utils.findFile("ROMANWALL.pcx", "Art" + fileSlash + "Cities" + fileSlash, this.biq);
            midEastName = utils.findFile("rMIDEAST.pcx", "Art" + fileSlash + "Cities" + fileSlash, this.biq);
            midEastWName = utils.findFile("MIDEASTWALL.pcx", "Art" + fileSlash + "Cities" + fileSlash, this.biq);
            asianName = utils.findFile("rASIAN.pcx", "Art" + fileSlash + "Cities" + fileSlash, this.biq);
            asianWName = utils.findFile("ASIANWALL.pcx", "Art" + fileSlash + "Cities" + fileSlash, this.biq);
        }
        catch (FileNotFoundException e) {
            logger.error("Could not find one of the city pcx files; civInstallDir = " + this.settings.civInstallDir, e);
            JOptionPane.showMessageDialog(null, "Could not one of the city pcx files.  The civ install dir (" + this.settings.civInstallDir + ") being incorrect may cause this problem.  This can be changed by clicking on the Settings button.\nError: " + e.getMessage());
            return;
        }
        String ruinsName = null;
        try {
            ruinsName = utils.findFile("DESTROY.pcx", "Art" + fileSlash + "Cities" + fileSlash, this.biq);
        }
        catch (FileNotFoundException e) {
            logger.error("Could not find DESTROY.pcx; civInstallDir = " + this.settings.civInstallDir, e);
            JOptionPane.showMessageDialog(null, "Could not find DESTROY.pcx.  The civ install dir (" + this.settings.civInstallDir + ") being incorrect may cause this problem.  This can be changed by clicking on the Settings button.\nError: " + e.getMessage());
            return;
        }
        String pollutionName = null;
        try {
            pollutionName = utils.findFile("pollution.pcx", "Art" + fileSlash + "Terrain" + fileSlash, this.biq);
        }
        catch (FileNotFoundException e) {
            logger.error("Could not find pollution.pcx; civInstallDir = " + this.settings.civInstallDir, e);
            JOptionPane.showMessageDialog(null, "Could not find pollution.pcx.  The civ install dir (" + this.settings.civInstallDir + ") being incorrect may cause this problem.  This can be changed by clicking on the Settings button.\nError: " + e.getMessage());
            return;
        }
        String airfieldsName = null;
        try {
            airfieldsName = utils.findFile("x_airfields and detect.pcx", "Art" + fileSlash + "Terrain" + fileSlash, this.biq);
        }
        catch (FileNotFoundException e) {
            logger.error("Could not find x_airfields and detect.pcx; civInstallDir = " + this.settings.civInstallDir, e);
            JOptionPane.showMessageDialog(null, "Could not find x_airfields and detect.pcx.  The civ install dir (" + this.settings.civInstallDir + ") being incorrect may cause this problem.  This can be changed by clicking on the Settings button.\nError: " + e.getMessage());
            return;
        }
        String victoryPointName = null;
        try {
            victoryPointName = utils.findFile("x_victory.pcx", "Art" + fileSlash + "Terrain" + fileSlash, this.biq);
        }
        catch (FileNotFoundException e) {
            logger.error("Could not find x_victory.pcx; civInstallDir = " + this.settings.civInstallDir, e);
            JOptionPane.showMessageDialog(null, "Could not find x_victory.pcx.  The civ install dir (" + this.settings.civInstallDir + ") being incorrect may cause this problem.  This can be changed by clicking on the Settings button.\nError: " + e.getMessage());
            return;
        }
        String craterName = null;
        try {
            craterName = utils.findFile("craters.pcx", "Art" + fileSlash + "Terrain" + fileSlash, this.biq);
        }
        catch (FileNotFoundException e) {
            logger.error("Could not find craters.pcx; civInstallDir = " + this.settings.civInstallDir, e);
            JOptionPane.showMessageDialog(null, "Could not find craters.pcx.  The civ install dir (" + this.settings.civInstallDir + ") being incorrect may cause this problem.  This can be changed by clicking on the Settings button.\nError: " + e.getMessage());
            return;
        }
        PCXImportThread[] baseTerrainsThreads = new PCXImportThread[9];
        for (int i = 0; i < 9; ++i) {
            baseTerrainsThreads[i] = new PCXImportThread(baseTerrainNames[i]);
            baseTerrainsThreads[i].start();
        }
        PCXImportThread[] lmTerrainsThreads = new PCXImportThread[9];
        for (int i = 0; i < 9; ++i) {
            lmTerrainsThreads[i] = new PCXImportThread(lmTerrainNames[i]);
            lmTerrainsThreads[i].start();
        }
        PCXImportThread grassForestThread = new PCXImportThread(grassForestName);
        grassForestThread.start();
        PCXImportThread plainsForestThread = new PCXImportThread(plainsForestName);
        plainsForestThread.start();
        PCXImportThread tundraForestThread = new PCXImportThread(tundraForestName);
        tundraForestThread.start();
        PCXImportThread marshThread = new PCXImportThread(marshName);
        marshThread.start();
        PCXImportThread roadThread = new PCXImportThread(roadName);
        roadThread.start();
        PCXImportThread railroadThread = new PCXImportThread(railroadName);
        railroadThread.start();
        PCXImportThread irrigationThread = new PCXImportThread(irrigationName);
        irrigationThread.start();
        PCXImportThread plainsIrrigationThread = new PCXImportThread(plainsIrrigationName);
        plainsIrrigationThread.start();
        PCXImportThread desertIrrigationThread = new PCXImportThread(desertIrrigationName);
        desertIrrigationThread.start();
        PCXImportThread tundraIrrigationThread = new PCXImportThread(tundraIrrigationName);
        tundraIrrigationThread.start();
        PCXImportThread riverThread = new PCXImportThread(riverName);
        riverThread.start();
        PCXImportThread buildingThread = new PCXImportThread(buildingName);
        buildingThread.start();
        PCXImportThread tntThread = new PCXImportThread(tntName);
        tntThread.start();
        PCXImportThread goodyhutThread = new PCXImportThread(goodyhutName);
        goodyhutThread.start();
        PCXImportThread startingLocationThread = new PCXImportThread(startingLocationName, true);
        startingLocationThread.start();
        PCXImportThread resourceThread = new PCXImportThread(resourceName);
        resourceThread.start();
        PCXImportThread lmTerrOverlayThread = new PCXImportThread(lmTerrOverlayName);
        lmTerrOverlayThread.start();
        String[] noWallNames = new String[]{americanName, europeanName, mediterraneanName, midEastName, asianName};
        String[] wallNames = new String[]{americanWName, europeanWName, mediterraneanWName, midEastWName, asianWName};
        PCXImportThread[] noWallThreads = new PCXImportThread[5];
        PCXImportThread[] wallThreads = new PCXImportThread[5];
        for (int i = 0; i < 5; ++i) {
            noWallThreads[i] = new PCXImportThread(noWallNames[i]);
            wallThreads[i] = new PCXImportThread(wallNames[i]);
            noWallThreads[i].start();
            wallThreads[i].start();
        }
        PCXImportThread ruinsThread = new PCXImportThread(ruinsName);
        ruinsThread.start();
        PCXImportThread pollutionThread = new PCXImportThread(pollutionName);
        pollutionThread.start();
        PCXImportThread airfieldsThread = new PCXImportThread(airfieldsName);
        airfieldsThread.start();
        PCXImportThread victoryPointThread = new PCXImportThread(victoryPointName);
        victoryPointThread.start();
        PCXImportThread craterThread = new PCXImportThread(craterName);
        craterThread.start();
        try {
            int i;
            for (i = 0; i < 9; ++i) {
                baseTerrainsThreads[i].join();
                lmTerrainsThreads[i].join();
            }
            grassForestThread.join();
            plainsForestThread.join();
            tundraForestThread.join();
            marshThread.join();
            roadThread.join();
            railroadThread.join();
            irrigationThread.join();
            plainsIrrigationThread.join();
            desertIrrigationThread.join();
            tundraIrrigationThread.join();
            riverThread.join();
            buildingThread.join();
            tntThread.join();
            goodyhutThread.join();
            startingLocationThread.join();
            resourceThread.join();
            lmTerrOverlayThread.join();
            for (i = 0; i < 5; ++i) {
                noWallThreads[i].join();
                wallThreads[i].join();
            }
            ruinsThread.join();
            pollutionThread.join();
            airfieldsThread.join();
            victoryPointThread.join();
            craterThread.join();
        }
        catch (InterruptedException e) {
            logger.error(e);
        }
        BufferedImage[][] baseTerrainGraphics = new BufferedImage[9][81];
        for (int i = 0; i < 9; ++i) {
            for (int j4 = 0; j4 < 9; ++j4) {
                for (int k2 = 0; k2 < 9; ++k2) {
                    baseTerrainGraphics[i][j4 * 9 + k2] = baseTerrainsThreads[i].getBufferedImage().getSubimage(k2 * 128, j4 * 64, 128, 64);
                }
            }
            baseTerrainsThreads[i] = null;
        }
        BufferedImage[][] lmTerrainGraphics = new BufferedImage[9][81];
        for (int i = 0; i < 9; ++i) {
            for (j3 = 0; j3 < 9; ++j3) {
                for (k = 0; k < 9; ++k) {
                    lmTerrainGraphics[i][j3 * 9 + k] = lmTerrainsThreads[i].getBufferedImage().getSubimage(k * 128, j3 * 64, 128, 64);
                }
            }
            lmTerrainsThreads[i] = null;
        }
        BufferedImage[] largeJungle = new BufferedImage[8];
        for (j3 = 0; j3 < 2; ++j3) {
            for (k = 0; k < 4; ++k) {
                largeJungle[j3 * 4 + k] = grassForestThread.getBufferedImage().getSubimage(k * 128, j3 * 88, 128, 88);
            }
        }
        BufferedImage[] smallJungle = new BufferedImage[12];
        for (int j5 = 0; j5 < 2; ++j5) {
            for (int k3 = 0; k3 < 6; ++k3) {
                smallJungle[j5 * 6 + k3] = grassForestThread.getBufferedImage().getSubimage(k3 * 128, j5 * 88 + 176, 128, 88);
            }
        }
        BufferedImage[] largeGrassForest = new BufferedImage[8];
        for (int j6 = 0; j6 < 2; ++j6) {
            for (int k4 = 0; k4 < 4; ++k4) {
                largeGrassForest[j6 * 4 + k4] = grassForestThread.getBufferedImage().getSubimage(k4 * 128, j6 * 88 + 352, 128, 88);
            }
        }
        BufferedImage[] smallGrassForest = new BufferedImage[10];
        for (int j7 = 0; j7 < 2; ++j7) {
            for (int k5 = 0; k5 < 5; ++k5) {
                smallGrassForest[j7 * 5 + k5] = grassForestThread.getBufferedImage().getSubimage(k5 * 128, j7 * 88 + 528, 128, 88);
            }
        }
        BufferedImage[] grassPineForest = new BufferedImage[12];
        for (int j8 = 0; j8 < 2; ++j8) {
            for (int k6 = 0; k6 < 6; ++k6) {
                grassPineForest[j8 * 6 + k6] = grassForestThread.getBufferedImage().getSubimage(k6 * 128, j8 * 88 + 704, 128, 88);
            }
        }
        grassForestThread = null;
        BufferedImage[] largePlainsForest = new BufferedImage[8];
        for (int j9 = 0; j9 < 2; ++j9) {
            for (int k7 = 0; k7 < 4; ++k7) {
                largePlainsForest[j9 * 4 + k7] = plainsForestThread.getBufferedImage().getSubimage(k7 * 128, j9 * 88 + 352, 128, 88);
            }
        }
        BufferedImage[] smallPlainsForest = new BufferedImage[10];
        for (int j10 = 0; j10 < 2; ++j10) {
            for (int k8 = 0; k8 < 5; ++k8) {
                smallPlainsForest[j10 * 5 + k8] = plainsForestThread.getBufferedImage().getSubimage(k8 * 128, j10 * 88 + 528, 128, 88);
            }
        }
        BufferedImage[] plainsPineForest = new BufferedImage[12];
        for (int j11 = 0; j11 < 2; ++j11) {
            for (int k9 = 0; k9 < 6; ++k9) {
                plainsPineForest[j11 * 6 + k9] = plainsForestThread.getBufferedImage().getSubimage(k9 * 128, j11 * 88 + 704, 128, 88);
            }
        }
        plainsForestThread = null;
        BufferedImage[] largeTundraForest = new BufferedImage[8];
        for (int j12 = 0; j12 < 2; ++j12) {
            for (int k10 = 0; k10 < 4; ++k10) {
                largeTundraForest[j12 * 4 + k10] = tundraForestThread.getBufferedImage().getSubimage(k10 * 128, j12 * 88 + 352, 128, 88);
            }
        }
        BufferedImage[] smallTundraForest = new BufferedImage[10];
        for (int j13 = 0; j13 < 2; ++j13) {
            for (int k11 = 0; k11 < 5; ++k11) {
                smallTundraForest[j13 * 5 + k11] = tundraForestThread.getBufferedImage().getSubimage(k11 * 128, j13 * 88 + 528, 128, 88);
            }
        }
        BufferedImage[] tundraPineForest = new BufferedImage[12];
        for (int j14 = 0; j14 < 2; ++j14) {
            for (int k12 = 0; k12 < 6; ++k12) {
                tundraPineForest[j14 * 6 + k12] = tundraForestThread.getBufferedImage().getSubimage(k12 * 128, j14 * 88 + 704, 128, 88);
            }
        }
        tundraForestThread = null;
        BufferedImage[] largeMarsh = new BufferedImage[8];
        for (int j15 = 0; j15 < 2; ++j15) {
            for (int k13 = 0; k13 < 4; ++k13) {
                largeMarsh[j15 * 4 + k13] = marshThread.getBufferedImage().getSubimage(k13 * 128, j15 * 88, 128, 88);
            }
        }
        BufferedImage[] pineMarsh = new BufferedImage[12];
        for (int j16 = 0; j16 < 2; ++j16) {
            for (int k14 = 0; k14 < 5; ++k14) {
                pineMarsh[j16 * 5 + k14] = marshThread.getBufferedImage().getSubimage(k14 * 128, j16 * 88 + 704, 128, 88);
            }
        }
        marshThread = null;
        BufferedImage[] roadGraphics = new BufferedImage[256];
        for (int j17 = 0; j17 < 16; ++j17) {
            for (int k15 = 0; k15 < 16; ++k15) {
                roadGraphics[j17 * 16 + k15] = roadThread.getBufferedImage().getSubimage(k15 * 128, j17 * 64, 128, 64);
            }
        }
        roadThread = null;
        BufferedImage[] railroadGraphics = new BufferedImage[256];
        for (int j18 = 0; j18 < 16; ++j18) {
            for (int k16 = 0; k16 < 16; ++k16) {
                railroadGraphics[j18 * 16 + k16] = railroadThread.getBufferedImage().getSubimage(k16 * 128, j18 * 64, 128, 64);
            }
        }
        railroadThread = null;
        BufferedImage[] irrigationGraphics = new BufferedImage[16];
        for (int j19 = 0; j19 < 4; ++j19) {
            for (int k17 = 0; k17 < 4; ++k17) {
                irrigationGraphics[j19 * 4 + k17] = irrigationThread.getBufferedImage().getSubimage(k17 * 128, j19 * 64, 128, 64);
            }
        }
        irrigationThread = null;
        BufferedImage[] plainsIrrigationGraphics = new BufferedImage[16];
        for (int j20 = 0; j20 < 4; ++j20) {
            for (int k18 = 0; k18 < 4; ++k18) {
                plainsIrrigationGraphics[j20 * 4 + k18] = plainsIrrigationThread.getBufferedImage().getSubimage(k18 * 128, j20 * 64, 128, 64);
            }
        }
        plainsIrrigationThread = null;
        BufferedImage[] desertIrrigationGraphics = new BufferedImage[16];
        for (int j21 = 0; j21 < 4; ++j21) {
            for (int k19 = 0; k19 < 4; ++k19) {
                desertIrrigationGraphics[j21 * 4 + k19] = desertIrrigationThread.getBufferedImage().getSubimage(k19 * 128, j21 * 64, 128, 64);
            }
        }
        desertIrrigationThread = null;
        BufferedImage[] tundraIrrigationGraphics = new BufferedImage[16];
        for (int j22 = 0; j22 < 4; ++j22) {
            for (int k20 = 0; k20 < 4; ++k20) {
                tundraIrrigationGraphics[j22 * 4 + k20] = tundraIrrigationThread.getBufferedImage().getSubimage(k20 * 128, j22 * 64, 128, 64);
            }
        }
        tundraIrrigationThread = null;
        BufferedImage[] riverGraphics = new BufferedImage[16];
        for (int j23 = 0; j23 < 4; ++j23) {
            for (int k21 = 0; k21 < 4; ++k21) {
                riverGraphics[j23 * 4 + k21] = riverThread.getBufferedImage().getSubimage(k21 * 128, j23 * 64, 128, 64);
            }
        }
        riverThread = null;
        BufferedImage[] buildingGraphics = new BufferedImage[16];
        try {
            for (int j24 = 0; j24 < 4; ++j24) {
                int width = buildingThread.getBufferedImage().getWidth();
                int max = width == 512 ? 4 : 3;
                for (int k22 = 0; k22 < max; ++k22) {
                    buildingGraphics[j24 * 4 + k22] = buildingThread.getBufferedImage().getSubimage(k22 * 128, j24 * 64, 128, 64);
                }
            }
        }
        catch (RasterFormatException e) {
            logger.error("Error importing " + buildingName, e);
            return;
        }
        buildingThread = null;
        int nY = 0;
        int TILE_X = 128;
        int TILE_Y = 64;
        BufferedImage tnt = tntThread.getBufferedImage();
        tntThread = null;
        BufferedImage[] tntGrass = new BufferedImage[3];
        for (int i = 0; i < 3; ++i) {
            tntGrass[i] = tnt.getSubimage(i * TILE_X, nY, TILE_X, TILE_Y);
        }
        nY += TILE_Y;
        BufferedImage[] tntGrassShield = new BufferedImage[3];
        for (int i = 0; i < 3; ++i) {
            tntGrassShield[i] = tnt.getSubimage(i * TILE_X, nY, TILE_X, TILE_Y);
        }
        nY += TILE_Y;
        BufferedImage[] tntPlains = new BufferedImage[3];
        for (int i = 0; i < 3; ++i) {
            tntPlains[i] = tnt.getSubimage(i * TILE_X, nY, TILE_X, TILE_Y);
        }
        nY += TILE_Y;
        BufferedImage[] tntDesert = new BufferedImage[3];
        for (int i = 0; i < 3; ++i) {
            tntDesert[i] = tnt.getSubimage(i * TILE_X, nY, TILE_X, TILE_Y);
        }
        nY += TILE_Y;
        BufferedImage[] tntTundra = new BufferedImage[3];
        for (int i = 0; i < 3; ++i) {
            tntTundra[i] = tnt.getSubimage(i * TILE_X, nY, TILE_X, TILE_Y);
        }
        nY += TILE_Y;
        BufferedImage[] tntFloodPlains = new BufferedImage[3];
        for (int i = 0; i < 3; ++i) {
            tntFloodPlains[i] = tnt.getSubimage(i * TILE_X, nY, TILE_X, TILE_Y);
        }
        BufferedImage[] goodyhutGraphics = new BufferedImage[8];
        for (int j25 = 0; j25 < 3; ++j25) {
            for (int k23 = 0; k23 < 3 && (k23 != 2 || j25 != 2); ++k23) {
                goodyhutGraphics[j25 * 3 + k23] = goodyhutThread.getBufferedImage().getSubimage(k23 * 128, j25 * 64, 128, 64);
            }
        }
        goodyhutThread = null;
        long borderStart = System.nanoTime();
        String territoryName = null;
        try {
            territoryName = utils.findFile("Territory.pcx", "Art" + fileSlash + "Terrain" + fileSlash, this.biq);
        }
        catch (FileNotFoundException e) {
            logger.error("Could not find Territory.pcx; civInstallDir = " + this.settings.civInstallDir, e);
            JOptionPane.showMessageDialog(null, "Could not find Territory.pcx.  The civ install dir (" + this.settings.civInstallDir + ") being incorrect may cause this problem.  This can be changed by clicking on the Settings button.\nError: " + e.getMessage());
            return;
        }
        Civ3PCXFilter borders = new Civ3PCXFilter(territoryName);
        borders.civ3TransparencyEnabled = false;
        Short one = 255;
        Short two = 1;
        borders.resetTransparents();
        borders.addTransparent(one);
        borders.addTransparent(two);
        borders.readFile();
        borders.parse();
        borders.setColor(249, new Color(0, 93, 0, 112));
        borders.setColor(252, new Color(0, 36, 0, 112));
        BufferedImage[][] borderGraphics = new BufferedImage[32][8];
        for (int i = 0; i < 32; ++i) {
            Color color = this.colors[i];
            borders.setColor(64, color);
            borders.setColor(65, color.brighter());
            for (int j26 = 0; j26 < 4; ++j26) {
                for (int k24 = 0; k24 < 2; ++k24) {
                    borderGraphics[i][j26 * 2 + k24] = borders.getSubimage(k24 * 128, j26 * 72, 128, 72);
                }
            }
        }
        BufferedImage[] startLocGraphics = new BufferedImage[32];
        for (int i = 0; i < 32; ++i) {
            Color color = this.colors[i];
            startingLocationThread.setColor(6, color);
            startLocGraphics[i] = startingLocationThread.getBufferedImage().getSubimage(0, 0, 128, 64);
        }
        startingLocationThread = null;
        Civ3PCXFilter resource = new Civ3PCXFilter(resourceName);
        resource.readFile();
        resource.parse();
        resource.createBufferedImage();
        int height = resource.ysize / 50;
        BufferedImage[] resourceGraphics = new BufferedImage[height * 6];
        for (int j27 = 0; j27 < height; ++j27) {
            for (int k25 = 0; k25 < 6; ++k25) {
                resourceGraphics[j27 * 6 + k25] = resource.getBufferedImage().getSubimage(k25 * 50, j27 * 50, 50, 50);
            }
        }
        BufferedImage landmarkOverlay = lmTerrOverlayThread.getBufferedImage().getSubimage(0, 0, 128, 64);
        lmTerrOverlayThread = null;
        BufferedImage[][][] noWallCityGraphics = new BufferedImage[5][4][3];
        for (int i = 0; i < 5; ++i) {
            for (int j28 = 0; j28 < 4; ++j28) {
                for (int k26 = 0; k26 < 3; ++k26) {
                    int widthPer = noWallThreads[i].getBufferedImage().getWidth() / 3;
                    int heightPer = noWallThreads[i].getBufferedImage().getHeight() / 4;
                    noWallCityGraphics[i][j28][k26] = noWallThreads[i].getBufferedImage().getSubimage(k26 * widthPer, heightPer * j28, widthPer, heightPer);
                }
            }
            noWallThreads[i] = null;
        }
        BufferedImage[][] wallCityGraphics = new BufferedImage[5][4];
        for (int i = 0; i < 5; ++i) {
            System.out.println(i);
            int maxWidth = wallThreads[i].getBufferedImage().getWidth() >= 167 ? 167 : wallThreads[i].getBufferedImage().getWidth();
            int heightPer = wallThreads[i].getBufferedImage().getHeight() / 4;
            for (j2 = 0; j2 < 4; ++j2) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Image " + j2 + " for culture " + i + ".  Image height is: " + wallThreads[i].getBufferedImage().getHeight());
                }
                wallCityGraphics[i][j2] = wallThreads[i].getBufferedImage().getSubimage(0, heightPer * j2, maxWidth, heightPer);
                if (!logger.isDebugEnabled()) continue;
                logger.debug("OK");
            }
            wallThreads[i] = null;
        }
        BufferedImage[] ruinGraphics = new BufferedImage[3];
        int ruinWidth = ruinsThread.getBufferedImage().getWidth() / 3;
        int ruinHeight = ruinsThread.getBufferedImage().getHeight();
        for (j2 = 0; j2 < 3; ++j2) {
            ruinGraphics[j2] = ruinsThread.getBufferedImage().getSubimage(ruinWidth * j2, 0, ruinWidth, ruinHeight);
        }
        ruinsThread = null;
        BufferedImage[] pollutionGraphics = new BufferedImage[25];
        for (int j29 = 0; j29 < 5; ++j29) {
            for (int k27 = 0; k27 < 5; ++k27) {
                pollutionGraphics[j29 * 5 + k27] = pollutionThread.getBufferedImage().getSubimage(k27 * 128, j29 * 64, 128, 64);
            }
        }
        pollutionThread = null;
        BufferedImage[] airfieldGraphics = new BufferedImage[2];
        BufferedImage[] outpostGraphics = new BufferedImage[3];
        for (j = 0; j < 2; ++j) {
            airfieldGraphics[j] = airfieldsThread.getBufferedImage().getSubimage(j * 128, 0, 128, 64);
        }
        for (j = 0; j < 3; ++j) {
            outpostGraphics[j] = airfieldsThread.getBufferedImage().getSubimage(j * 128, 64, 128, 128);
        }
        BufferedImage radarTowerGraphics = airfieldsThread.getBufferedImage().getSubimage(0, 192, 128, 128);
        airfieldsThread = null;
        BufferedImage victoryPointGraphics = null;
        victoryPointGraphics = victoryPointThread.getBufferedImage();
        victoryPointThread = null;
        BufferedImage[] craterGraphics = new BufferedImage[25];
        for (int j30 = 0; j30 < 5; ++j30) {
            for (int k28 = 0; k28 < 5; ++k28) {
                int heightPer = craterThread.getBufferedImage().getHeight() / 5;
                int widthPer = craterThread.getBufferedImage().getWidth() / 5;
                if (logger.isTraceEnabled()) {
                    logger.trace(k28 * 128 + " " + j30 * 64);
                }
                craterGraphics[j30 * 5 + k28] = craterThread.getBufferedImage().getSubimage(k28 * widthPer, j30 * heightPer, widthPer, heightPer);
            }
        }
        craterThread = null;
        BufferedImage[] mountainGraphics = this.importGraphics("Mountains.pcx", 4, 4, 88);
        if (mountainGraphics == null) {
            return;
        }
        long endMountains = System.nanoTime();
        BufferedImage[] snowMountainGraphics = this.importGraphics("Mountains-snow.pcx", 4, 4, 88);
        if (snowMountainGraphics == null) {
            return;
        }
        long endSnow = System.nanoTime();
        BufferedImage[] lmMountainGraphics = this.importGraphics("LMMountains.pcx", 4, 4, 88);
        if (lmMountainGraphics == null) {
            return;
        }
        BufferedImage[] forestMountainGraphics = this.importGraphics("mountain forests.pcx", 4, 4, 88);
        if (lmMountainGraphics == null) {
            return;
        }
        BufferedImage[] jungleMountainGraphics = this.importGraphics("mountain jungles.pcx", 4, 4, 88);
        if (lmMountainGraphics == null) {
            return;
        }
        BufferedImage[] hillGraphics = this.importGraphics("xhills.pcx", 4, 4, 72);
        if (hillGraphics == null) {
            return;
        }
        BufferedImage[] lmHillGraphics = this.importGraphics("LMHills.pcx", 4, 4, 72);
        if (lmHillGraphics == null) {
            return;
        }
        BufferedImage[] forestHillGraphics = this.importGraphics("hill forests.pcx", 4, 4, 72);
        if (hillGraphics == null) {
            return;
        }
        BufferedImage[] jungleHillGraphics = this.importGraphics("hill jungle.pcx", 4, 4, 72);
        if (hillGraphics == null) {
            return;
        }
        long endHills = System.nanoTime();
        BufferedImage[] volcanoGraphics = this.importGraphics("Volcanos.pcx", 4, 4, 88);
        if (volcanoGraphics == null) {
            return;
        }
        BufferedImage[] forestVolcanoGraphics = this.importGraphics("Volcanos forests.pcx", 4, 4, 88);
        if (forestVolcanoGraphics == null) {
            return;
        }
        BufferedImage[] jungleVolcanoGraphics = this.importGraphics("Volcanos jungles.pcx", 4, 4, 88);
        if (jungleVolcanoGraphics == null) {
            return;
        }
        BufferedImage fog = null;
        try {
            String fogFile = utils.findFile("EditFog.pcx", "Art" + fileSlash + "Terrain" + fileSlash, this.biq);
            PCXImportThread fogThread = new PCXImportThread(fogFile);
            fogThread.start();
            fogThread.join();
            fog = fogThread.getBufferedImage();
        }
        catch (FileNotFoundException fogFile) {
        }
        catch (InterruptedException fogFile) {
            // empty catch block
        }
        long endGraphics = System.nanoTime();
        long grxTime = (endGraphics - startGraphics) / 1000000L;
        logger.info("It took " + grxTime + " milliseconds to import all the graphics.");
        grxTime = (endGraphics - borderStart) / 1000000L;
        logger.info(grxTime + " milliseconds of that was for borders");
        long start = System.nanoTime();
        this.biq.calculateTileOwners();
        long finish = System.nanoTime();
        long ms = (finish - start) / 1000000L;
        if (logger.isDebugEnabled()) {
            logger.debug("It took " + ms + " milliseconds to calculate all the tile owners.");
        }
        this.mapPanel.sendData(this.biq.worldMap.get(0), this.biq.tile, this.biq.resource, this.biq.city, this.biq.rule, this.biq.civilization, this.biq);
        this.mapPanel.sendPlayerData(this.biq.player);
        GraphicsAssets assets = new GraphicsAssets();
        assets.sendGraphics(baseTerrainGraphics, lmTerrainGraphics, roadGraphics, railroadGraphics, buildingGraphics, borderGraphics, resourceGraphics, noWallCityGraphics, wallCityGraphics, goodyhutGraphics, pollutionGraphics, startLocGraphics, airfieldGraphics, outpostGraphics, radarTowerGraphics, victoryPointGraphics, craterGraphics, ruinGraphics, landmarkOverlay, this.unitIcons);
        assets.sendHills(mountainGraphics, snowMountainGraphics, lmMountainGraphics, forestMountainGraphics, jungleMountainGraphics, hillGraphics, lmHillGraphics, forestHillGraphics, jungleHillGraphics, volcanoGraphics, forestVolcanoGraphics, jungleVolcanoGraphics);
        assets.sendWoodlands(largeJungle, smallJungle, largeGrassForest, smallGrassForest, grassPineForest, largePlainsForest, smallPlainsForest, plainsPineForest, largeTundraForest, smallTundraForest, tundraPineForest, largeMarsh, pineMarsh);
        assets.sendIrrigation(irrigationGraphics, plainsIrrigationGraphics, desertIrrigationGraphics, tundraIrrigationGraphics, riverGraphics);
        assets.sendTNT(tntGrass, tntGrassShield, tntPlains, tntDesert, tntTundra, tntFloodPlains);
        assets.sendFog(fog);
        this.mapPanel.setAssets(assets);
        this.mapTab.setUp(this.biq);
        this.mapPanel.sendTab(this.mapTab);
        this.mapPanel.startMapPanel();
        this.tabs.setEnabledAt(this.tabs.getTabCount() - 1, true);
        Main.mapIsLoaded = true;
        logger.info("Graphics loaded.  Memory in use: " + Runtime.getRuntime().totalMemory() / 1024L + " KB");
        logger.info("Graphics loaded.  Memory available: " + Runtime.getRuntime().maxMemory() / 1024L + " KB");
    }

    private BufferedImage[] importGraphics(String fileName, int xDim, int yDim, int heightEach, int heightOffset) {
        String mtnName = null;
        try {
            mtnName = utils.findFile(fileName, "Art" + fileSlash + "Terrain" + fileSlash, this.biq);
        }
        catch (FileNotFoundException e) {
            logger.error("Could not find " + fileName + "; civInstallDir = " + this.settings.civInstallDir, e);
            JOptionPane.showMessageDialog(null, "Could not find " + fileName + ".  The civ install dir (" + this.settings.civInstallDir + ") being incorrect may cause this problem.  This can be changed by clicking on the Settings button.\nError: " + e.getMessage());
            return null;
        }
        Civ3PCXFilter mtns = new Civ3PCXFilter(mtnName);
        mtns.readFile();
        mtns.parse();
        mtns.createBufferedImage();
        BufferedImage[] mountainGraphics = new BufferedImage[xDim * yDim];
        for (int j = 0; j < 4; ++j) {
            for (int k = 0; k < 4; ++k) {
                mountainGraphics[j * 4 + k] = mtns.getBufferedImage().getSubimage(k * 128, j * heightEach + heightOffset, 128, heightEach);
            }
        }
        return mountainGraphics;
    }

    private BufferedImage[] importGraphics(String fileName, int xDim, int yDim, int heightEach) {
        return this.importGraphics(fileName, xDim, yDim, heightEach, 0);
    }
}

