/*
 * Decompiled with CFR 0.152.
 */
package com.civfanatics.civ3.xplatformeditor.Listeners;

import com.civfanatics.civ3.xplatformeditor.CustomComponents.SuperJTextField;
import java.awt.Color;
import java.awt.SystemColor;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.log4j.Logger;

public class BadValueDocumentListener
implements DocumentListener {
    int maxValue;
    int minValue;
    SuperJTextField txt;
    Logger logger = Logger.getLogger(this.getClass());
    boolean isNull;
    boolean isValid;

    public BadValueDocumentListener(int maxValue, SuperJTextField txt) {
        this(maxValue, 0, txt);
    }

    public BadValueDocumentListener(int maxValue, int minValue, SuperJTextField txt) {
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.txt = txt;
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("Change detected");
        }
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("Removal detected");
        }
        this.checkValue();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("Insertion detected");
        }
        this.checkValue();
    }

    public void checkValue() {
        int intVal;
        String text = this.txt.getText();
        if (this.logger.isTraceEnabled()) {
            this.logger.trace(text);
        }
        try {
            intVal = Integer.valueOf(text);
        }
        catch (NumberFormatException e) {
            this.badValue();
            return;
        }
        if (intVal > this.maxValue || intVal < this.minValue) {
            this.badValue();
        } else {
            this.goodValue();
        }
    }

    private void badValue() {
        this.txt.setForeground(Color.red);
        this.isValid = false;
        if (this.txt.getText().equals("")) {
            this.isNull = true;
        }
    }

    private void goodValue() {
        SystemColor systemColor = SystemColor.textText;
        this.txt.setForeground(systemColor);
        this.isValid = false;
        this.isNull = true;
    }
}

