/*
 * Decompiled with CFR 0.152.
 */
package com.civfanatics.civ3.xplatformeditor.Listeners;

import com.civfanatics.civ3.xplatformeditor.CustomComponents.SuperJTextField;
import java.awt.Color;
import java.lang.reflect.Method;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.log4j.Logger;

public class FireTriggerDocumentListener
implements DocumentListener {
    int maxValue;
    int minValue;
    SuperJTextField txt;
    Logger logger = Logger.getLogger(this.getClass());
    public Method method;

    public FireTriggerDocumentListener(int maxValue, SuperJTextField txt) {
        this(maxValue, 0, txt);
    }

    public FireTriggerDocumentListener(SuperJTextField txt) {
        this.txt = txt;
    }

    public FireTriggerDocumentListener(int maxValue, int minValue, SuperJTextField txt) {
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.txt = txt;
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("Change detected");
        }
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("Removal detected");
        }
        this.checkValue();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("Insertion detected");
        }
        this.checkValue();
    }

    public void checkValue() {
        String text = this.txt.getText();
        if (text.equals("")) {
            return;
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace(text);
        }
        try {
            int intVal = Integer.valueOf(text);
        }
        catch (NumberFormatException e) {
            this.badValue();
        }
    }

    private void badValue() {
        this.txt.setForeground(Color.red);
    }

    private void goodValue() {
        this.txt.setForeground(Color.black);
    }
}

