/*
 * Decompiled with CFR 0.152.
 */
package com.civfanatics.civ3.xplatformeditor.Listeners;

import java.awt.Color;
import java.awt.SystemColor;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.apache.log4j.Logger;

public class LengthDocumentListener
implements DocumentListener {
    Logger logger = Logger.getLogger(this.getClass());
    int maxLength;
    JTextComponent txt;

    public LengthDocumentListener(int maxLength, JTextComponent txt) {
        this.maxLength = maxLength;
        this.txt = txt;
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("Change detected");
        }
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("Removal detected");
        }
        this.checkLength();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("Insertion detected");
        }
        this.checkLength();
    }

    public void checkLength() {
        String s = this.txt.getText();
        if (this.logger.isTraceEnabled()) {
            this.logger.trace(s);
        }
        if (s.length() > this.maxLength) {
            this.badValue();
        } else {
            this.goodValue();
        }
    }

    private void badValue() {
        this.txt.setForeground(Color.red);
    }

    private void goodValue() {
        SystemColor systemColor = SystemColor.textText;
        this.txt.setForeground(systemColor);
    }
}

