/*
 * Decompiled with CFR 0.152.
 */
package com.civfanatics.civ3.xplatformeditor;

import com.civfanatics.civ3.biqFile.BIQSection;
import com.civfanatics.civ3.biqFile.GOOD;
import com.civfanatics.civ3.biqFile.IO;
import com.civfanatics.civ3.biqFile.LEAD;
import com.civfanatics.civ3.biqFile.OperatingSystem;
import com.civfanatics.civ3.biqFile.PRTO;
import com.civfanatics.civ3.biqFile.TILE;
import com.civfanatics.civ3.biqFile.civ3Version;
import com.civfanatics.civ3.biqFile.util.DefaultRulesLoader;
import com.civfanatics.civ3.pediaIcons.PediaIconsFile;
import com.civfanatics.civ3.savFile.SAV;
import com.civfanatics.civ3.xplatformeditor.CustomComponents.InterruptThread;
import com.civfanatics.civ3.xplatformeditor.EditorTabbedPane;
import com.civfanatics.civ3.xplatformeditor.FileExtensionFilter;
import com.civfanatics.civ3.xplatformeditor.FileIO;
import com.civfanatics.civ3.xplatformeditor.MapPanel;
import com.civfanatics.civ3.xplatformeditor.MenuSystem;
import com.civfanatics.civ3.xplatformeditor.ReadOnlyException;
import com.civfanatics.civ3.xplatformeditor.Settings;
import com.civfanatics.civ3.xplatformeditor.SettingsPanel;
import com.civfanatics.civ3.xplatformeditor.imageSupport.Civ3PCXFilter;
import com.civfanatics.civ3.xplatformeditor.imageSupport.PCXFilter;
import com.civfanatics.civ3.xplatformeditor.specialty.AboutPanel;
import com.civfanatics.civ3.xplatformeditor.specialty.CSVImportPanel;
import com.civfanatics.civ3.xplatformeditor.specialty.CSVPanel;
import com.civfanatics.civ3.xplatformeditor.specialty.FrmSafetyLevel;
import com.civfanatics.civ3.xplatformeditor.specialty.JavaVersion;
import com.civfanatics.civ3.xplatformeditor.specialty.SafetyLevel;
import com.civfanatics.civ3.xplatformeditor.specialty.StartupWidgets;
import com.civfanatics.civ3.xplatformeditor.specialty.VersionChecker;
import com.civfanatics.civ3.xplatformeditor.tabs.biqc.checkBoxSettings;
import com.civfanatics.civ3.xplatformeditor.tabs.map.BMPSizeCalculator;
import com.civfanatics.civ3.xplatformeditor.tabs.map.CustomMapSetupForm;
import com.civfanatics.civ3.xplatformeditor.tabs.map.MapFromBMPForm;
import com.civfanatics.civ3.xplatformeditor.tabs.map.PolarBearForm;
import com.civfanatics.civ3.xplatformeditor.undoRedo.UndoStack;
import com.civfanatics.civ3.xplatformeditor.utils;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Insets;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.TimerTask;
import javafx.application.Platform;
import javafx.embed.swing.JFXPanel;
import javafx.stage.Stage;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.plaf.FontUIResource;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.simplericity.macify.eawt.Application;
import org.simplericity.macify.eawt.ApplicationEvent;
import org.simplericity.macify.eawt.ApplicationListener;
import org.simplericity.macify.eawt.DefaultApplication;
import webbrowserfx.WebBrowserFX;
import webpageviewer.BrowserWindow;

public class Main
extends JFrame
implements ApplicationListener {
    static final boolean defaultFile = false;
    public static final String newline = System.getProperty("line.separator");
    public static String fileSlash = System.getProperty("file.separator");
    public static final String VERSION = "1.39";
    static final String TITLE = "Conquests Editor 1.39";
    public static boolean GRAPHICS_ENABLED = true;
    String titleRemainder = "";
    static String fontChoice = "Tahoma";
    String errorWhileSaving = "Error while saving file";
    String[] acceptedExtensions = new String[]{"biq", "bic"};
    public static OperatingSystem os = new OperatingSystem();
    static int numProcs = -1;
    public static Settings settings = new Settings();
    private JPanel pnlTemporary;
    boolean canPressF1 = true;
    BrowserWindow helpWindow;
    WebBrowserFX helpFX;
    Stage helpStage = null;
    static String imagePath = "./imgs/";
    private File savedFile;
    private static UndoStack currentUndoStack;
    private UndoStack undoStack;
    Action allowF1 = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            Main.this.canPressF1 = true;
        }
    };
    public static ResourceBundle i18n;
    public String help_ColorPalette = "help/civColors.html";
    String help_Home;
    public String currentHelp = this.help_Home = "help/civ3editor.html";
    Timer helpTimer = new Timer(1000, this.allowF1);
    static Logger logger;
    public static List<IO> biqFile;
    public List<checkBoxSettings> checkBoxSettings;
    public static int biqIndex;
    int biq2Index = -2;
    int maxBiqIndex = -1;
    static boolean fileOpen;
    int numSelected;
    int ruleIndex;
    String separator;
    Timer lblTimer;
    Color[] colors;
    BufferedImage[][] unitIcons;
    BufferedImage units32;
    BufferedImage[] resourceIcons;
    public static Image icon;
    java.util.Timer autoSaveTimer;
    private Application application;
    FrmSafetyLevel safetyLevelWindow;
    SettingsPanel settingsPanel;
    AboutPanel aboutPanel;
    public static Map<String, SafetyLevel> safetyLevels;
    GridBagLayout mainLayout = new GridBagLayout();
    GridBagConstraints gc = new GridBagConstraints();
    static boolean mapIsLoaded;
    public static Main mainMain;
    LoadAccelerator loadAccelerator = null;
    VersionChecker versionChecker = null;
    static final String[] pcxNames;
    public static String fileChooserMode;
    public static JFileChooser jfcBMPChooser;
    public static JFileChooser jfcCSVChooser;
    FileExtensionFilter savFilter = null;
    FileExtensionFilter[] saveFilters = null;
    FileExtensionFilter scenarioFileFilter = null;
    FileExtensionFilter bicFilter = null;
    FileExtensionFilter biqFilter = null;
    MenuSystem menus = null;
    static boolean needToWaitTillArgsProcessed;
    static String editorDirectory;
    public static SAV currentSAV;
    boolean forceOfflineDueToError = false;
    private volatile boolean loadAcceleratorDone = false;
    public static javafx.scene.image.Image javaFXImage;
    public static EditorTabbedPane pnlTabs;

    static void setupLogging(String editorDirectory) {
        String fileName = editorDirectory + "log.txt";
        File lgFile = new File(fileName);
        if (lgFile.length() > 0x100000L) {
            lgFile.delete();
        }
        lgFile = null;
        Logger.getRootLogger().setLevel(Level.INFO);
        BasicConfigurator.configure();
        Logger root = Logger.getRootLogger();
        PatternLayout layout = new PatternLayout("%-4r [%t] %-5p %c %x - %m%n");
        FileAppender logFile = new FileAppender();
        try {
            logger.info("User dir = " + System.getProperty("user.dir"));
            if (editorDirectory != null && !editorDirectory.isEmpty()) {
                System.setProperty("user.dir", editorDirectory);
                logger.info("User dir set to = " + System.getProperty("user.dir"));
            }
            logFile = new FileAppender((Layout)layout, fileName);
        }
        catch (IOException e) {
            needToWaitTillArgsProcessed = true;
            logger.error("Error while setting up the log output to file: ", e);
        }
        root.addAppender(logFile);
        logger.info("Starting program - version 1.39");
    }

    static void setupLocale() {
        Locale locale = new Locale("en", "US");
        if (Main.settings.editorLanguage.equals("Russian")) {
            locale = new Locale("ru", "RU");
        } else if (Main.settings.editorLanguage.equals("French")) {
            locale = new Locale("fr", "FR");
        } else if (Main.settings.editorLanguage.equals("Esperanto")) {
            locale = new Locale("eo", "US");
        } else if (Main.settings.editorLanguage.equals("zzTest")) {
            locale = new Locale("zz", "US");
        }
        try {
            File f = new File(Main.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath());
            logger.info("Locale path: " + Main.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath());
            f = new File(f.getParent() + "/langs");
            URL[] urls = new URL[1];
            try {
                urls[0] = f.toURL();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            URLClassLoader cl = new URLClassLoader(urls);
            try {
                logger.info("i18n URL: " + f.getCanonicalPath());
            }
            catch (IOException ex) {
                logger.error("IOException", ex);
            }
            i18n = ResourceBundle.getBundle("EditorStrings", locale, cl);
        }
        catch (URISyntaxException ex) {
            logger.error("URISyntaxException", ex);
        }
        JComponent.setDefaultLocale(locale);
    }

    public Main(String fileToOpen) {
        String javaVersion;
        if (logger.isDebugEnabled()) {
            logger.info("In constructor");
        }
        mainMain = this;
        this.application = new DefaultApplication();
        this.application.addApplicationListener(this);
        icon = Toolkit.getDefaultToolkit().getImage(imagePath + "icon.PNG");
        if (Main.os.name.toLowerCase().contains("mac")) {
            this.integrateWithOSX();
        }
        this.setIconImage(icon);
        if (logger.isInfoEnabled()) {
            logger.info("Running " + Main.os.name + " " + Main.os.version + " on " + Main.os.arch);
        }
        if (logger.isInfoEnabled()) {
            logger.info("Java vendor: " + System.getProperty("java.specification.vendor"));
        }
        if (logger.isInfoEnabled()) {
            logger.info("Java runtime version: " + System.getProperty("java.version"));
        }
        if (logger.isInfoEnabled()) {
            logger.info("Java runtime name: " + System.getProperty("java.runtime.name"));
        }
        if (JavaVersion.hasJava11(javaVersion = System.getProperty("java.version"))) {
            this.alertAboutJava11();
        }
        if (javaVersion.startsWith("1.8.0")) {
            String update = javaVersion.substring(javaVersion.indexOf("_") + 1);
            Integer minorVersion = Integer.valueOf(update);
            if (minorVersion < 60) {
                Main.settings.useJavaFX = false;
                Main.settings.forceSwing = true;
                JOptionPane.showMessageDialog(null, "<html>You are currently running Java 8 update " + minorVersion + ".<br />Version 1.10 of the editor introduces some features that require update 60 or later.<br />Please download and install the current update of Java from http://www.oracle.com/technetwork/java/javase/downloads/index.html.<br /><br />Alternately, old versions of the editor or a version that bundles Java can be downloaded from the \"Old Versions\" section of the editor thread's first post,<br />at https://forums.civfanatics.com/threads/cross-platform-editor-for-conquests-now-available.377188/.", "Java Update Required", 0);
                System.exit(60);
            } else if (minorVersion >= 151 && Main.os.name.equals("Windows XP")) {
                Main.settings.useJavaFX = false;
                Main.settings.forceSwing = true;
                Main.settings.forceSwingDueToJavaBug = true;
                logger.warn("Enforcing use of old lists to avoid Java bug on update 151+ on Windows XP");
            }
        }
        this.checkBoxSettings = new ArrayList<checkBoxSettings>();
        this.initComponents();
        logger.info("Is hardware enabled? " + System.getProperty("sun.java2d.opengl", "true"));
        super.setTitle(TITLE);
        this.loadAccelerator = new LoadAccelerator(this);
        this.loadAccelerator.start();
        if (Main.settings.checkForUpdates) {
            this.versionChecker = new VersionChecker(this, VERSION);
            this.versionChecker.start();
        }
        if (!fileToOpen.isEmpty()) {
            this.openFile(fileToOpen);
        }
    }

    void alertAboutJava11() {
        JOptionPane.showMessageDialog(null, "<html>Java 11 shipped on September 25, 2018, and removed some components the editor depends on.<br/>  Your system is running Java 11 or later, and the editor may not behave as expected.  An update is being prepared to address this,<br/> but in the meantime you may wish to use the 1.24 XP version, or the 1.19 Legacy version, both of which will work as expected, instead.  <br/>The forum thread has more information and download links for these in post #1034, as well as links in the first post.</html>", "Java 11 Not Yet Supported", 0);
    }

    @Override
    public void setTitle(String string) {
        super.setTitle("Conquests Editor 1.39 - " + string);
    }

    private void initComponents() {
        if (logger.isDebugEnabled()) {
            logger.info("Starting initialize method now");
        }
        this.menus = new MenuSystem(this);
        this.menus.getAbout().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Main.this.handleAbout(null);
            }
        });
        pnlTabs = new EditorTabbedPane();
        this.setDefaultCloseOperation(3);
        this.setTitle("Conquests Editor Version Here");
        GraphicsDevice screen = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        int screenWidth = screen.getDisplayMode().getWidth();
        int screenHeight = screen.getDisplayMode().getHeight();
        Insets uiInsets = Toolkit.getDefaultToolkit().getScreenInsets(screen.getDefaultConfiguration());
        int widthInsets = uiInsets.left + uiInsets.right;
        int heightInsets = uiInsets.bottom + uiInsets.top;
        int maxWidth = screenWidth - widthInsets;
        int maxHeight = screenHeight - heightInsets;
        if (Main.settings.width <= (maxWidth += 10) && Main.settings.height <= (maxHeight += 10)) {
            this.setSize(new Dimension(Main.settings.width, Main.settings.height));
        } else {
            logger.info("Screen dimensions of " + Main.settings.width + " x " + Main.settings.height + " exceed maximum of " + maxWidth + " x " + maxHeight);
            this.setSize(new Dimension(1030, 768));
        }
        this.setMinimumSize(new Dimension(800, 600));
        this.setName("frmMain");
        this.setResizable(true);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                pnlTabs.setSize(Main.this.getWidth(), Main.this.getHeight() - 50);
                if (Main.pnlTabs.mapTab != null && Main.pnlTabs.mapTab.map != null) {
                    Main.pnlTabs.mapTab.map.updateBufferSize(Main.this.getWidth());
                    Main.pnlTabs.mapTab.updateWidth(Main.this.getWidth());
                }
                Main.settings.width = Main.this.getWidth();
                Main.settings.height = Main.this.getHeight();
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent evt) {
                Main.this.formWindowActivated(evt);
            }

            @Override
            public void windowClosing(WindowEvent evt) {
                Main.this.formWindowClosing(evt);
            }

            @Override
            public void windowDeactivated(WindowEvent evt) {
                Main.this.formWindowDeactivated(evt);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent evt) {
                Main.this.formComponentHidden(evt);
            }
        });
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                Main.this.formFocusGained(evt);
            }
        });
        this.getContentPane().setLayout(this.mainLayout);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int button = e.getButton();
                System.out.println("Clicked mouse button " + button);
            }
        });
        long eventMask = 16L;
        Toolkit.getDefaultToolkit().addAWTEventListener(new AWTEventListener(){

            @Override
            public void eventDispatched(AWTEvent e) {
                MouseEvent m;
                e.toString();
                if (e instanceof MouseEvent && (m = (MouseEvent)e).getID() == 500) {
                    if (m.getButton() == 4) {
                        System.out.println("Button 4 clicked");
                    } else if (m.getButton() == 5) {
                        System.out.println("Button 5 clicked");
                    }
                }
            }
        }, eventMask);
        KeyEventDispatcher ked = new KeyEventDispatcher(){

            @Override
            public boolean dispatchKeyEvent(KeyEvent ke) {
                if (Main.this.canPressF1 && ke.getKeyCode() == 112) {
                    Main.this.displayHelp();
                    return true;
                }
                return false;
            }
        };
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(ked);
        JMenuItem helpComponent = this.menus.getHelp();
        helpComponent.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Main.this.displayHelp();
            }
        });
        this.pnlTemporary = StartupWidgets.setupStartWidgets(this.getContentPane(), this.gc, this.pnlTemporary, this::openFile);
        String[] csv = new String[]{"csv"};
        FileExtensionFilter csvFilter = new FileExtensionFilter(csv, "CSV Files");
        jfcCSVChooser.setFileFilter(csvFilter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void displayHelp() {
        String update;
        Integer minorVersion;
        this.canPressF1 = false;
        boolean offlineHelp = false;
        String javaVersion = System.getProperty("java.version");
        if (javaVersion.startsWith("1.8.0") && (minorVersion = Integer.valueOf(update = javaVersion.substring(javaVersion.indexOf("_") + 1))) >= 112 && Main.os.name.equals("Windows XP")) {
            logger.info("Using offline help due to WebKit in Java 8 update " + minorVersion + " being too new for Windows XP");
            offlineHelp = true;
        }
        if (!offlineHelp) {
            InterruptThread it = new InterruptThread();
            it.start();
            try {
                InterruptThread interruptThread = it;
                synchronized (interruptThread) {
                    it.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            offlineHelp = it.getOfflineStatus();
        }
        if (this.forceOfflineDueToError) {
            offlineHelp = true;
        }
        if (offlineHelp) {
            if (logger.isDebugEnabled()) {
                logger.debug("Displaying offline help");
            }
            if (this.helpWindow == null) {
                this.helpWindow = new BrowserWindow("Editor Help", false, false);
                this.helpWindow.setLocationRelativeTo(mainMain);
            }
            this.helpWindow.goToUrl(this.currentHelp);
            this.helpWindow.setVisible(true);
        } else {
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Displaying online help");
                    }
                    if (Main.this.helpFX == null) {
                        Main.this.helpStage = new Stage();
                        Main.this.helpFX = new WebBrowserFX();
                        boolean testingUpdates = false;
                        if (testingUpdates) {
                            Main.this.helpFX.setHomepage("file:////" + System.getProperty("user.dir") + "/onlineHelp/civ3editor.html");
                        } else {
                            Main.this.helpFX.setHomepage("http://quintillus.warpmail.net/civ3editor/onlineHelp/civ3editor.html");
                        }
                    }
                    try {
                        Main.this.helpFX.start(Main.this.helpStage);
                    }
                    catch (ExceptionInInitializerError | NoClassDefFoundError er) {
                        logger.error("Could not initialize help system", er);
                    }
                    Main.this.helpStage.getIcons().add((Object)javaFXImage);
                    Main.this.helpStage.show();
                }
            });
        }
        this.helpTimer.start();
    }

    public void createNewBIQ() {
        int choice;
        if (biqFile.size() > 0 && (choice = JOptionPane.showConfirmDialog(null, "<html>The editor only supports opening one file at a time, other than for BIQ Compare mode.<br>You can try opening more than one in other modes, but it is recommended to open a second instance of the editor instead.<br>Continue opening additional file?</html>", "Open multiple files?", 0, 2)) == 1) {
            return;
        }
        boolean successfulInput = this.newBIQ();
        if (successfulInput) {
            IO currentBIQ = biqFile.get(biqIndex);
            this.performPostOpeningActions(currentBIQ, new File("Untitled"), false);
        }
    }

    private void performPostSAVOpenActions(File file) {
        this.titleRemainder = " - " + file.getName();
        Main.super.setTitle(TITLE + this.titleRemainder);
        this.menus.enableSavMenus();
    }

    private void performPostOpeningActions(IO currentBIQ, File file, boolean customRules) {
        if (!currentBIQ.hasCustomRules()) {
            this.setUpRuleInfrastructure();
        }
        if (!currentBIQ.hasCustomPlayerData()) {
            this.setUpPlayerDataInfrastructure();
        }
        if (!this.loadAcceleratorDone) {
            try {
                this.loadAccelerator.join();
            }
            catch (InterruptedException e) {
                logger.error("Interrupted", e);
            }
        }
        pnlTabs.alertBIQCTab(file);
        pnlTabs.setEnabled(true);
        this.titleRemainder = " - " + file.getName();
        Main.super.setTitle(TITLE + this.titleRemainder);
        currentBIQ.fileName = file.getName();
        currentBIQ.trim();
        this.loadInterfaceElements();
        this.menus.enablePostOpenMenus(currentBIQ);
        pnlTabs.initialTabUpdate();
        this.setAutoSaveTimer();
        pnlTabs.setVisible(true);
        this.pnlTemporary.setVisible(false);
        String newBIQName = "";
        try {
            newBIQName = file.getCanonicalPath();
        }
        catch (IOException ex) {
            newBIQName = file.getAbsolutePath();
        }
        this.updateRecentFilesList(newBIQName);
        utils.addFileToRecentFiles(editorDirectory, newBIQName);
        if (!currentBIQ.hasCustomMap()) {
            this.menus.disableMapEditingOptions();
        }
        currentUndoStack = this.undoStack = new UndoStack(currentBIQ, this.menus.editMenu);
    }

    void open(ActionEvent evt) {
        this.openFile(null);
    }

    public void openFile(String fileName) {
        int choice;
        if (biqFile.size() > 0 && (choice = JOptionPane.showConfirmDialog(null, "<html>The editor only supports opening one file at a time, other than for BIQ Compare mode.<br>You can try opening more than one in other modes, but it is recommended to open a second instance of the editor instead.<br>Continue opening additional file?</html>", "Open multiple files?", 0, 2)) == 1) {
            return;
        }
        File file = null;
        if (fileName == null) {
            file = this.getInputFile();
            if (file == null) {
                return;
            }
        } else {
            file = new File(fileName);
        }
        boolean successfulInput = false;
        try {
            successfulInput = this.openBIQ(file);
        }
        catch (FileNotFoundException ex) {
            JOptionPane.showMessageDialog(null, "The specified file (" + file.getPath() + ") could not be found. \nCheck if it has been moved or deleted.", "File Not Found", 0);
            return;
        }
        if (successfulInput) {
            IO currentBIQ = biqFile.get(biqIndex);
            this.performPostOpeningActions(currentBIQ, file, currentBIQ.hasCustomRules());
        } else if (Main.biqFile.get((int)Main.biqIndex).majorVersionNumber == 0 && Main.biqFile.get((int)Main.biqIndex).minorVersionNumber == 0) {
            JOptionPane.showMessageDialog(null, "The specified file (" + file.getPath() + ") could not be opened. \nIt is an unsupported version " + Main.biqFile.get((int)Main.biqIndex).majorVersionNumber + "." + Main.biqFile.get((int)Main.biqIndex).minorVersionNumber + " BIQ file, which likely resulted in the error.\n\nIt is also possible that this is due to running Windows Vista or later with UAC enabled and Civ3 installed in a protected location (such as C:\\Program Files),\nresulting in the editor being denied permission to open the file.  Turning off UAC or reinstalling Civ3 to somewhere such as C:\\Civilization III should solve this problem.\n\nPlease make a forum post at http://forums.civfanatics.com/showthread.php?t=377188 with this BIQ attached if you would like to see support added.");
        } else if (Main.biqFile.get((int)Main.biqIndex).majorVersionNumber != 12 || Main.biqFile.get((int)Main.biqIndex).minorVersionNumber != 8 && Main.biqFile.get((int)Main.biqIndex).minorVersionNumber != 6) {
            JOptionPane.showMessageDialog(null, "The specified file (" + file.getPath() + ") could not be opened. \nIt is an unsupported version " + Main.biqFile.get((int)Main.biqIndex).majorVersionNumber + "." + Main.biqFile.get((int)Main.biqIndex).minorVersionNumber + " BIQ file, which likely resulted in the error.\n\nPlease make a forum post at http://forums.civfanatics.com/showthread.php?t=377188 with this BIQ attached if you would like to see support added.");
        } else {
            JOptionPane.showMessageDialog(null, "The specified file (" + file.getPath() + ") could not be opened. \nCheck that it is correctly spelled, and that it is an uncompressed BIQ 12.08 that no other programs are using.\n\nThe log file will contain more information about where the error occured.");
        }
    }

    private void updateRecentFilesList(String newBIQName) {
        if (newBIQName.endsWith("Untitled")) {
            return;
        }
        int listPosition = -1;
        for (int i = 0; i < 5 && Settings.recentFiles[i] != null; ++i) {
            if (!Settings.recentFiles[i].equals(newBIQName)) continue;
            listPosition = i;
        }
        int max = listPosition == -1 ? 5 : listPosition + 1;
        for (int i = max - 1; i > 0; --i) {
            Settings.recentFiles[i] = Settings.recentFiles[i - 1];
        }
        Settings.recentFiles[0] = newBIQName;
        this.menus.updateRecentFiles(newBIQName, max);
    }

    public void setAutoSaveTimer() {
        if (!fileOpen) {
            return;
        }
        if (this.autoSaveTimer != null) {
            this.autoSaveTimer.cancel();
        }
        this.autoSaveTimer = new java.util.Timer("Auto-Save Timer");
        this.autoSaveTimer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                Main.this.autoSave();
            }
        }, 1000L * Main.settings.autoSaveInterval, 1000L * Main.settings.autoSaveInterval);
    }

    private void autoSave() {
        pnlTabs.updateAllTabs();
        String fileName = "autoSave" + String.valueOf(Main.settings.nextAutosave) + ".biq";
        File file = new File(fileName);
        this.saveFile(file);
        ++Main.settings.nextAutosave;
        if (Main.settings.nextAutosave >= Main.settings.maxAutosaves) {
            Main.settings.nextAutosave = 0;
        }
    }

    private File getInputFile() {
        File file;
        if (this.bicFilter == null) {
            String[] bic = new String[]{"bic"};
            String[] biq = new String[]{"biq"};
            this.bicFilter = new FileExtensionFilter(bic, Main.i18n("save.bicFiles"));
            this.biqFilter = new FileExtensionFilter(biq, Main.i18n("save.biqFiles"));
            this.scenarioFileFilter = new FileExtensionFilter(this.acceptedExtensions, Main.i18n("save.allScenarioFiles"));
        }
        FileExtensionFilter[] filters = new FileExtensionFilter[]{this.bicFilter, this.biqFilter, this.scenarioFileFilter};
        try {
            file = FileIO.getFile(0, false, filters);
        }
        catch (IOException ex) {
            logger.error("IOException", ex);
            return null;
        }
        this.savedFile = file;
        return file;
    }

    private boolean openBIQ(File file) throws FileNotFoundException {
        if (logger.isInfoEnabled()) {
            logger.info("Input file: " + file.getAbsolutePath());
        }
        biqFile.add(new IO());
        this.checkBoxSettings.add(new checkBoxSettings());
        ++this.maxBiqIndex;
        if (biqIndex != -1) {
            // empty if block
        }
        biqIndex = this.maxBiqIndex;
        Main.biqFile.get((int)Main.biqIndex).fileName = file.getName();
        biqFile.get(biqIndex).setLanguage(Main.settings.biqLanguage);
        long start = System.nanoTime();
        boolean successfulInput = biqFile.get(biqIndex).inputBIQ(file);
        long end = System.nanoTime();
        if (logger.isInfoEnabled()) {
            logger.info("Time to input file: " + (end - start) / 1000000L + " milliseconds.");
        }
        try {
            String pediaFile = utils.findFile("PediaIcons.txt", "Text/", biqFile.get(biqIndex));
            PediaIconsFile pediaIcons = new PediaIconsFile();
            pediaIcons.parseFile(pediaFile);
            biqFile.get(biqIndex).setPediaIcons(pediaIcons);
        }
        catch (FileNotFoundException ex) {
            logger.warn("Could not find PediaIcons.txt file", ex);
        }
        catch (Exception ex) {
            logger.error("Error reading pedia icons file", ex);
            JOptionPane.showMessageDialog(null, "<html>The pedia icons file could not be read.  While the editor will still work, the icons will not show up as intended.<br/><br/>It is recommended to upload your scenario (including the Text folder) to the CFC thread so the issue can be diagnosed.</html>", "Error reading pedia icons", 2);
        }
        return successfulInput;
    }

    private boolean newBIQ() {
        IO newBIQ = new IO();
        newBIQ.version = civ3Version.CONQUESTS;
        biqFile.add(newBIQ);
        this.checkBoxSettings.add(new checkBoxSettings());
        ++this.maxBiqIndex;
        biqIndex = this.maxBiqIndex;
        Main.biqFile.get((int)Main.biqIndex).fileName = "Untitled";
        biqFile.get(biqIndex).setLanguage(Main.settings.biqLanguage);
        String baseBIQ = utils.getConquestsFolder(Main.settings.civInstallDir) + "conquests.biq";
        File file = new File(baseBIQ);
        IO baseRules = this.openSpecificFile(file);
        newBIQ.scenarioProperty = baseRules.scenarioProperty;
        return true;
    }

    private IO openSpecificFile(File file) {
        if (logger.isInfoEnabled()) {
            logger.info("Input file: " + file.getAbsolutePath());
        }
        IO biqInput = new IO();
        this.checkBoxSettings.add(new checkBoxSettings());
        if (biqIndex != -1) {
            // empty if block
        }
        biqInput.fileName = file.getName();
        biqInput.setLanguage(Main.settings.biqLanguage);
        long start = System.nanoTime();
        boolean successfulInput = false;
        try {
            successfulInput = biqInput.inputBIQ(file);
        }
        catch (FileNotFoundException ex) {
            JOptionPane.showMessageDialog(null, "The specified file (" + file.getPath() + ") could not be found. \nCheck if it has been moved or deleted.");
        }
        long end = System.nanoTime();
        if (logger.isInfoEnabled()) {
            logger.info("Time to input file: " + (end - start) / 1000000L + " milliseconds.");
        }
        return biqInput;
    }

    public static void processConfigFile(String directory) {
        logger.info("Looking for config file at " + directory + "civ3editor.ini");
        File config = new File(directory + "civ3editor.ini");
        if (config.exists()) {
            settings.importConfigFile(config);
            numProcs = Integer.parseInt(Main.settings.numProcs);
            if (!Main.settings.firstRun.equals("false")) {
                Main.firstRunStuff();
            }
        } else {
            logger.warn("Couldn't find config file");
            Main.firstRunStuff();
        }
        if (numProcs < 1) {
            numProcs = Runtime.getRuntime().availableProcessors();
        }
        IO.setNumProcs(numProcs);
        DefaultRulesLoader.defaultRulesPath = utils.getConquestsFolder(Main.settings.civInstallDir) + "conquests.biq";
        DefaultRulesLoader.defaultRulesLanguage = Main.settings.biqLanguage;
    }

    private static void firstRunStuff() {
        int majorVersion;
        block29: {
            File defLoc;
            Main.settings.noConfigFileAtStart = true;
            boolean autoFound = false;
            String installPath = null;
            if (Main.os.name.toLowerCase().contains("mac") || Main.os.name.toLowerCase().contains("os x")) {
                defLoc = new File("/Applications/");
                String likelyInstall = "/Applications/Civ III Complete";
                if (utils.verifyGoodInstall(likelyInstall)) {
                    autoFound = true;
                    installPath = likelyInstall;
                } else {
                    if (defLoc.exists()) {
                        FileIO.setCurrentDirectory(defLoc);
                    }
                    JOptionPane.showMessageDialog(null, "Welcome!  As part of the first-time setup, please choose where you have Civilization III Complete\ninstalled (this is the folder above the \"Conquests Game Data\" folder).\n  This will be used to find PCX image files, as well as set up the default scenario location.", "OS X setup", -1);
                }
            } else {
                if (Main.os.name.toLowerCase().contains("windows")) {
                    installPath = Main.regKeyValue("\"HKEY_LOCAL_MACHINE\\SOFTWARE\\Infogrames Interactive\\Civilization III\"", "REG_SZ", "Install_Path");
                    if (installPath.equals("")) {
                        installPath = Main.regKeyValue("\"HKEY_LOCAL_MACHINE\\SOFTWARE\\Wow6432Node\\Infogrames Interactive\\Civilization III\"", "REG_SZ", "Install_Path");
                        if (installPath.equals("")) {
                            autoFound = false;
                            if (logger.isInfoEnabled()) {
                                logger.info("Could not find install path");
                            }
                        } else {
                            autoFound = true;
                        }
                    } else {
                        autoFound = true;
                    }
                }
                if (autoFound) {
                    if (!utils.verifyGoodInstall(installPath)) {
                        autoFound = false;
                        defLoc = null;
                        defLoc = Main.os.arch.toLowerCase().contains("x86") ? new File("C:/Program Files/") : new File("C:/Program Files (x86)/");
                        if (defLoc.exists()) {
                            FileIO.setCurrentDirectory(defLoc);
                        }
                        JOptionPane.showMessageDialog(null, "Welcome!  As part of the first-time setup, please choose where you have Civilization III (the base game, not the\n expansions) installed.  This will be used to find PCX image files, as well as set up the default scenario location.", "Windows/Linux Setup", -1);
                    }
                } else {
                    defLoc = null;
                    defLoc = Main.os.arch.toLowerCase().contains("x86") ? new File("C:/Program Files/") : new File("C:/Program Files (x86)/");
                    if (defLoc.exists()) {
                        FileIO.setCurrentDirectory(defLoc);
                    }
                    JOptionPane.showMessageDialog(null, "Welcome!  As part of the first-time setup, please choose where you have Civilization III (the base game, not the\n expansions) installed.  This will be used to find PCX image files, as well as set up the default scenario location.", "Windows/Linux setup", -1);
                }
            }
            if (!autoFound) {
                File file = null;
                try {
                    file = FileIO.getFile(0, true, null);
                }
                catch (IOException ex) {
                    logger.error("IOException while getting file", ex);
                }
                if (file != null) {
                    try {
                        Main.settings.civInstallDir = file.getCanonicalPath();
                        Main.settings.openDir = Main.os.name.toLowerCase().contains("mac") ? Main.settings.civInstallDir + fileSlash + "Conquests Game Data" + fileSlash + "Scenarios" : Main.settings.civInstallDir + fileSlash + "Conquests" + fileSlash + "Scenarios";
                    }
                    catch (IOException e) {
                        logger.error("Exception while trying to get canonical path of civ install dir", e);
                    }
                    Main.settings.firstRun = "false";
                    try {
                        settings.exportConfigFile();
                    }
                    catch (ReadOnlyException ex) {
                        if (logger.isInfoEnabled()) {
                            logger.info("Cannot save settings configuration", ex);
                        }
                    }
                }
            } else {
                Main.settings.civInstallDir = installPath;
                Main.settings.openDir = !Main.os.name.toLowerCase().contains("mac") ? installPath + fileSlash + "Conquests" + fileSlash + "Scenarios" : installPath + fileSlash + "Conquests Game Data" + fileSlash + "Scenarios";
                Main.settings.firstRun = "false";
                try {
                    settings.exportConfigFile();
                }
                catch (ReadOnlyException ex) {
                    if (!logger.isInfoEnabled()) break block29;
                    logger.info("Cannot save settings configuration");
                }
            }
        }
        if (Main.os.name.toLowerCase().contains("windows") && (majorVersion = Integer.parseInt(Main.os.version.substring(0, 1), 10)) >= 6 && Main.settings.civInstallDir.contains("Program Files")) {
            JOptionPane.showMessageDialog(null, "<html>It appears that you are using Windows Vista or later and have Civ3 installed to a Program Files folder.<br>  If you have UAC on, it's highly advisable to reinstall Civ3 to somewhere else (such as C:\\Civilization III) before modding.<br>After reinstalling Civ3, you'll need to go to Settings and re-specify where it's installed.</html>");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void save(ActionEvent evt) {
        pnlTabs.updateAllTabs();
        if (!this.validateBIQFile()) {
            return;
        }
        if (!pnlTabs.checkBounds()) {
            return;
        }
        try {
            boolean success;
            int response;
            String[] biqExtension = this.acceptedExtensions;
            this.biqFilter = new FileExtensionFilter(biqExtension, Main.i18n("save.biqFiles"));
            FileExtensionFilter[] biqSaveFilter = new FileExtensionFilter[]{this.biqFilter};
            File file = FileIO.getFile(1, false, biqSaveFilter);
            if (file == null) {
                return;
            }
            if (!file.getPath().endsWith(".biq")) {
                file = new File(file.getPath() + ".biq");
            }
            if (file.exists() && !fileChooserMode.equals("JavaFX") && (response = JOptionPane.showOptionDialog(null, "File already exists.  Overwrite?", "Existing File", 0, 3, null, null, null)) != 0) {
                return;
            }
            if (Main.settings.autoArchive && this.savedFile != null) {
                try {
                    File sourceFile = this.savedFile;
                    Calendar calendar = Calendar.getInstance();
                    int year = calendar.get(1);
                    int month = calendar.get(2) + 1;
                    int day = calendar.get(5);
                    int hour = calendar.get(11);
                    int minute = calendar.get(12);
                    DecimalFormat two = new DecimalFormat("00");
                    String sMonth = two.format(month);
                    String sDay = two.format(day);
                    String sHour = two.format(hour);
                    String sMinute = two.format(minute);
                    String absolutePath = sourceFile.getAbsolutePath();
                    String newName = absolutePath.substring(0, absolutePath.length() - 4) + "_Archive_" + year + "_" + sMonth + "_" + sDay + " " + sHour + "" + sMinute + ".biq";
                    File destFile = new File(newName);
                    if (!destFile.exists()) {
                        destFile.createNewFile();
                    }
                    FileChannel source = null;
                    AbstractInterruptibleChannel destination = null;
                    try {
                        source = new FileInputStream(sourceFile).getChannel();
                        destination = new FileOutputStream(destFile).getChannel();
                        boolean transferred = false;
                        int bytesMoved = 0;
                        while (!transferred) {
                            if ((long)(bytesMoved = (int)((long)bytesMoved + ((FileChannel)destination).transferFrom(source, bytesMoved, source.size() - (long)bytesMoved))) != source.size()) continue;
                            transferred = true;
                        }
                    }
                    finally {
                        if (source != null) {
                            source.close();
                        }
                        if (destination != null) {
                            destination.close();
                        }
                    }
                }
                catch (NullPointerException ex) {
                    logger.error("Null pointer exception while saving archived version.  Is savedFile null? " + (this.savedFile == null), ex);
                }
            }
            if (success = this.saveFile(file)) {
                this.savedFile = file;
                this.titleRemainder = " - " + file.getName();
                this.updateRecentFilesList(file.getCanonicalPath());
            }
            this.restoreTitle();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            logger.error(this.errorWhileSaving, e);
            String badNews = "Don't panic!  This error is likely due to setting a value that the editor can't handle.\nFortunately, the data in the editor won't be lost.  Look at the number that was\nout of bounds in this error message.  You likely entered that number somewhere it\ncan't be.  Setting it to  a more conventional value should allow you to save your file.\n     Error: ";
            JOptionPane.showMessageDialog(null, badNews + e, this.errorWhileSaving, 0);
        }
        catch (Exception e) {
            logger.error(this.errorWhileSaving, e);
            JOptionPane.showMessageDialog(null, e, this.errorWhileSaving, 0);
        }
    }

    private boolean validateBIQFile() {
        if (Main.settings.validateInfiniteUnitUpgrade) {
            for (PRTO prto : Main.biqFile.get((int)Main.biqIndex).unit) {
                if (!prto.hasInfiniteUpgradePath()) continue;
                String upgradePath = prto.getUpgradePath();
                JOptionPane.showMessageDialog(null, "<html>There is a loop in a unit upgrade path:<br/><br/>" + upgradePath + "<br/><br/>This will cause infinite turn times in Civ; please change the upgrade path before saving.</html>", "Loop in Unit Upgrade Path", 0);
                return false;
            }
        }
        if (Main.settings.validatePhantomResourceBug) {
            boolean[] hasStrategicOrLuxResource = new boolean[32];
            int[] stratOrLuxResource = new int[32];
            List<GOOD> resources = Main.biqFile.get((int)Main.biqIndex).resource;
            for (int i = 0; i < resources.size(); ++i) {
                GOOD resource = resources.get(i);
                int modulus = i % 32;
                if (!resource.isStrategic() && !resource.isLuxury()) continue;
                if (hasStrategicOrLuxResource[modulus]) {
                    String firstName = resources.get(stratOrLuxResource[modulus]).getName();
                    String secondName = resources.get(i).getName();
                    Object[] options = new Object[]{"Cancel Save", "Save Anyway"};
                    int userChoice = JOptionPane.showOptionDialog(null, "<html>The resources " + firstName + " and " + secondName + " will trigger the Phantom Resource Bug.<br/>This occurs when you have strategic or luxury resources positioned 32, 64, etc. spaces away from each other.<br/>You can resolve this by reordering (dragging and dropping) resources on the GOOD tab, and can disable this check in the editor preferences.<br/>See the Help for the GOOD tab (and related CFC links) for more information</html>", "Phantom Resource Bug", 0, 2, null, options, "Cancel Save");
                    if (userChoice != 0) break;
                    return false;
                }
                hasStrategicOrLuxResource[modulus] = true;
                stratOrLuxResource[modulus] = i;
            }
        }
        return true;
    }

    private boolean saveFile(File file) {
        Main.biqFile.get((int)Main.biqIndex).numBuildings = Main.biqFile.get((int)Main.biqIndex).buildings.size();
        Main.biqFile.get((int)Main.biqIndex).numCivilizations = Main.biqFile.get((int)Main.biqIndex).civilization.size();
        Main.biqFile.get((int)Main.biqIndex).numCitizens = Main.biqFile.get((int)Main.biqIndex).citizens.size();
        Main.biqFile.get((int)Main.biqIndex).numCulturalOpinions = Main.biqFile.get((int)Main.biqIndex).culture.size();
        Main.biqFile.get((int)Main.biqIndex).numDifficulties = Main.biqFile.get((int)Main.biqIndex).difficulties.size();
        Main.biqFile.get((int)Main.biqIndex).numEras = Main.biqFile.get((int)Main.biqIndex).eras.size();
        Main.biqFile.get((int)Main.biqIndex).numEspionage = Main.biqFile.get((int)Main.biqIndex).espionage.size();
        Main.biqFile.get((int)Main.biqIndex).numExprLevel = Main.biqFile.get((int)Main.biqIndex).experience.size();
        Main.biqFile.get((int)Main.biqIndex).numFlavors = Main.biqFile.get((int)Main.biqIndex).version == civ3Version.CONQUESTS ? Main.biqFile.get((int)Main.biqIndex).flavor.size() : 0;
        Main.biqFile.get((int)Main.biqIndex).numGoods = Main.biqFile.get((int)Main.biqIndex).resource.size();
        Main.biqFile.get((int)Main.biqIndex).numGovernments = Main.biqFile.get((int)Main.biqIndex).government.size();
        Main.biqFile.get((int)Main.biqIndex).numRules = Main.biqFile.get((int)Main.biqIndex).rule.size();
        Main.biqFile.get((int)Main.biqIndex).numScenarioProperties = Main.biqFile.get((int)Main.biqIndex).scenarioProperty.size();
        Main.biqFile.get((int)Main.biqIndex).numTechnologies = Main.biqFile.get((int)Main.biqIndex).technology.size();
        Main.biqFile.get((int)Main.biqIndex).numTerrains = Main.biqFile.get((int)Main.biqIndex).terrain.size();
        Main.biqFile.get((int)Main.biqIndex).numWorkerJobs = Main.biqFile.get((int)Main.biqIndex).workerJob.size();
        Main.biqFile.get((int)Main.biqIndex).numWorldSizes = Main.biqFile.get((int)Main.biqIndex).worldSize.size();
        this.setTitle("Saving...");
        long start = System.nanoTime();
        boolean successfulExport = biqFile.get(biqIndex).outputBIQ(file);
        long end = System.nanoTime();
        if (logger.isInfoEnabled()) {
            logger.info("Time to export file: " + (end - start) / 1000000L + " milliseconds.");
        }
        if (!successfulExport) {
            logger.error("Failed to successfully output file");
            JOptionPane.showMessageDialog(null, "Failed to successfully output file");
        }
        this.restoreTitle();
        return successfulExport;
    }

    private void restoreTitle() {
        super.setTitle(TITLE + this.titleRemainder);
    }

    void inputBIQRulesFromSAV(ActionEvent evt) {
        try {
            File file;
            String[] biqExtension = new String[]{"sav", "SAV"};
            if (this.savFilter == null) {
                this.savFilter = new FileExtensionFilter(biqExtension, "SAV files");
                this.saveFilters = new FileExtensionFilter[1];
                this.saveFilters[0] = this.savFilter;
            }
            if ((file = FileIO.getFile(0, false, this.saveFilters)) != null) {
                if (logger.isInfoEnabled()) {
                    logger.info("SAV file name: " + file.getCanonicalPath());
                }
                biqFile.add(new IO());
                this.checkBoxSettings.add(new checkBoxSettings());
                ++this.maxBiqIndex;
                biqIndex = this.maxBiqIndex;
                Main.biqFile.get((int)Main.biqIndex).fileName = file.getName();
                if (logger.isInfoEnabled()) {
                    logger.info("searching for biq...: ");
                }
                boolean successfulInput = biqFile.get(biqIndex).inputBIQFromScenario(file);
                if (logger.isInfoEnabled()) {
                    logger.info("successful input: " + successfulInput);
                }
                if (successfulInput) {
                    pnlTabs.alertBIQCTab(file);
                    pnlTabs.setEnabled(true);
                    this.titleRemainder = " - " + file.getName();
                    this.restoreTitle();
                    Main.biqFile.get((int)Main.biqIndex).fileName = file.getName();
                    this.loadInterfaceElements();
                    pnlTabs.initialTabUpdate();
                } else {
                    JOptionPane.showMessageDialog(null, "The specified file (" + file.getPath() + ") could not be opened. \nCheck that it is correctly spelled, and that it is an uncompressed BIQ 12.08 that no other programs are using.");
                }
                pnlTabs.setVisible(true);
                this.pnlTemporary.setVisible(false);
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, e);
        }
    }

    void openSAVFile(ActionEvent evt) {
        try {
            String[] biqExtension = new String[]{"sav", "SAV"};
            if (this.savFilter == null) {
                this.savFilter = new FileExtensionFilter(biqExtension, "SAV files");
                this.saveFilters = new FileExtensionFilter[1];
                this.saveFilters[0] = this.savFilter;
            }
            File savDir = new File(new File(Main.settings.openDir).getParentFile().getCanonicalPath() + "/Saves");
            FileIO.setCurrentDirectory(savDir);
            File file = FileIO.getFile(0, false, this.saveFilters);
            if (file != null) {
                if (logger.isInfoEnabled()) {
                    logger.info("SAV file name: " + file.getCanonicalPath());
                }
                this.openSAV(file);
            }
            logger.info("Finish SAV opening");
        }
        catch (Exception e) {
            logger.error("Unexpected error when inputting SAV", e);
            JOptionPane.showMessageDialog(null, e);
        }
    }

    private void openSAV(File file) throws IOException {
        SAV sav = new SAV();
        System.out.println("File name: " + file.getName());
        boolean successfulInput = sav.inputSAV(file);
        if (logger.isInfoEnabled()) {
            logger.info("successful input: " + successfulInput);
        }
        if (successfulInput) {
            this.loadNTPColors(sav.getEmbeddedRules().getEmbeddedRules());
            logger.info("Successful SAV input");
            currentSAV = sav;
            this.performPostSAVOpenActions(file);
            JOptionPane.showMessageDialog(null, "This feature is still in development, and not ready yet.  However, no errors were encountered!");
        } else {
            logger.info("Unsuccessful SAV input");
            JOptionPane.showMessageDialog(null, "This feature is still in development, and not ready yet.  An error did occur while opening (" + file.getPath() + "), and there may be more info in the log files.");
        }
    }

    private void formFocusGained(FocusEvent evt) {
        if (logger.isDebugEnabled()) {
            logger.debug("Gained focus");
        }
    }

    private void formComponentHidden(ComponentEvent evt) {
        if (logger.isDebugEnabled()) {
            logger.debug("Component hidden");
        }
    }

    private void formWindowDeactivated(WindowEvent evt) {
        if (logger.isDebugEnabled()) {
            logger.debug("Window deactivated");
        }
    }

    private void formWindowClosing(WindowEvent evt) {
        this.quitAction();
    }

    private void quitAction() {
        boolean quit;
        block4: {
            int yesno;
            quit = true;
            this.setDefaultCloseOperation(3);
            if (Main.settings.confirmQuit && (yesno = JOptionPane.showConfirmDialog(null, "Do you really want to exit?", "Exit?", 0)) == 1) {
                quit = false;
                this.setDefaultCloseOperation(0);
            }
            try {
                settings.exportConfigFile();
                logger.info("Successful exit");
            }
            catch (ReadOnlyException ex) {
                if (!logger.isInfoEnabled()) break block4;
                logger.warn("Cannot save settings configuration");
            }
        }
        if (Main.os.name.toLowerCase().contains("mac") && quit) {
            System.exit(0);
        }
    }

    void cmdSafetyLevelActionPerformed(ActionEvent evt) {
        this.safetyLevelWindow.setLocationRelativeTo(this);
        this.safetyLevelWindow.setVisible(true);
    }

    void importMapFromBMP() {
        MapFromBMPForm bmpForm = new MapFromBMPForm();
        bmpForm.pack();
        bmpForm.setLocationRelativeTo(this);
        bmpForm.setVisible(true);
        this.menus.enableMapEditingOptions();
    }

    void showBMPSizeCalculator() {
        BMPSizeCalculator bmpSize = new BMPSizeCalculator();
        bmpSize.setLocationRelativeTo(this);
        bmpSize.setVisible(true);
    }

    void cmdImportMapActionPerformed(ActionEvent evt) {
        int curBIQIndex = biqIndex;
        File file = this.getInputFile();
        if (file == null) {
            return;
        }
        boolean successfulInput = false;
        try {
            successfulInput = this.openBIQ(file);
        }
        catch (FileNotFoundException ex) {
            JOptionPane.showMessageDialog(null, "The specified file (" + file.getPath() + ") could not be found. \nCheck if it has been moved or deleted.");
            return;
        }
        if (successfulInput) {
            if (biqFile.get(biqIndex).hasCustomRules()) {
                HashMap<Integer, Integer> resourceMapping = new HashMap<Integer, Integer>();
                for (int newResourceId = 0; newResourceId < Main.biqFile.get((int)Main.biqIndex).resource.size(); ++newResourceId) {
                    String name = Main.biqFile.get((int)Main.biqIndex).resource.get(newResourceId).getName();
                    boolean found = false;
                    for (int oldResourceId = 0; oldResourceId < Main.biqFile.get((int)curBIQIndex).resource.size(); ++oldResourceId) {
                        if (!Main.biqFile.get((int)curBIQIndex).resource.get(oldResourceId).getName().equals(name)) continue;
                        resourceMapping.put(newResourceId, oldResourceId);
                        found = true;
                        break;
                    }
                    if (found) continue;
                    resourceMapping.put(newResourceId, -1);
                }
                for (TILE tile : Main.biqFile.get((int)Main.biqIndex).tile) {
                    if (tile.getResource() == -1) continue;
                    int newResourceId = (Integer)resourceMapping.get(tile.getResource());
                    tile.setResource(newResourceId);
                }
            }
            Main.biqFile.get((int)curBIQIndex).worldCharacteristic = Main.biqFile.get((int)Main.biqIndex).worldCharacteristic;
            Main.biqFile.get((int)curBIQIndex).worldMap = Main.biqFile.get((int)Main.biqIndex).worldMap;
            Main.biqFile.get((int)curBIQIndex).tile = Main.biqFile.get((int)Main.biqIndex).tile;
            Main.biqFile.get((int)curBIQIndex).continent = Main.biqFile.get((int)Main.biqIndex).continent;
            Main.biqFile.get((int)curBIQIndex).startingLocation = Main.biqFile.get((int)Main.biqIndex).startingLocation;
            Main.biqFile.get((int)curBIQIndex).city = Main.biqFile.get((int)Main.biqIndex).city;
            Main.biqFile.get((int)curBIQIndex).mapUnit = Main.biqFile.get((int)Main.biqIndex).mapUnit;
            Main.biqFile.get((int)curBIQIndex).colony = Main.biqFile.get((int)Main.biqIndex).colony;
            biqFile.get(curBIQIndex).setCustomMap(true);
            biqIndex = curBIQIndex;
            Main.pnlTabs.gameTab.sendMapData(Main.biqFile.get((int)curBIQIndex).worldCharacteristic);
            Main.enableMapTab();
            JOptionPane.showMessageDialog(null, "Map successfully imported.", "Success!", 1);
            this.menus.enableMapEditingOptions();
        } else {
            JOptionPane.showMessageDialog(null, "Error inputting the new map", "Error", 0);
        }
    }

    private void formWindowActivated(WindowEvent evt) {
        if (logger.isDebugEnabled()) {
            logger.debug("Window activated");
        }
    }

    void cmdExportToCSVActionPerformed(ActionEvent evt) {
        CSVPanel pnlCSV = new CSVPanel(biqFile.get(biqIndex));
        pnlCSV.setIconImage(icon);
        pnlCSV.setLocationRelativeTo(this);
        pnlCSV.setVisible(true);
    }

    void cmdImportFromCSVActionPerformed(ActionEvent evt) {
        CSVImportPanel pnlCSV = new CSVImportPanel(biqFile.get(biqIndex));
        pnlCSV.setIconImage(icon);
        pnlCSV.setLocationRelativeTo(this);
        pnlCSV.setVisible(true);
    }

    void openSettingsWindow(ActionEvent evt) {
        if (this.settingsPanel == null) {
            this.settingsPanel = new SettingsPanel(settings, this);
        }
        this.settingsPanel.setIconImage(icon);
        this.settingsPanel.setLocationRelativeTo(this);
        this.settingsPanel.setVisible(true);
    }

    void enableCustomMap(ActionEvent evt) {
        CustomMapSetupForm mapSetupForm = new CustomMapSetupForm();
        mapSetupForm.setLocationRelativeTo(this);
        mapSetupForm.setVisible(true);
        this.menus.enableMapEditingOptions();
    }

    void showPolarOptions(ActionEvent evt) {
        PolarBearForm polar = new PolarBearForm();
        polar.setLocationRelativeTo(this);
        polar.setVisible(true);
    }

    void showRedistributeGrassland() {
        String percent = JOptionPane.showInputDialog(this, "Enter the percentage of grasslands that should be bonus, ex. 5 for 5%:", "Bonus Grassland Percentage", -1);
        int iPercent = Integer.parseInt(percent);
        IO biq = biqFile.get(biqIndex);
        List<TILE> tiles = biq.tile;
        Random random = new Random();
        for (TILE t : tiles) {
            if (t.getRealTerrain() != 2) continue;
            int rnd = random.nextInt(100);
            t.setBonusGrassland(rnd < iPercent);
        }
        JOptionPane.showMessageDialog(this, "The bonus grassland has been redistributed", "Success!", 1);
    }

    void clearAllCities() {
        Main.biqFile.get((int)Main.biqIndex).city.clear();
        for (TILE t : Main.biqFile.get((int)Main.biqIndex).tile) {
            t.setCity((short)-1);
            t.citiesWithInfluence.clear();
        }
        biqFile.get(biqIndex).calculateTileOwners();
    }

    void clearAllUnits() {
        Main.biqFile.get((int)Main.biqIndex).mapUnit.clear();
        for (TILE t : Main.biqFile.get((int)Main.biqIndex).tile) {
            t.unitsOnTile.clear();
            t.unitWithBestDefence = -1;
        }
    }

    void changeZoomPercentage(ActionEvent evt) {
        String s = JOptionPane.showInputDialog(this, "Enter the zoom percent (1 to 1000)", "Zoom percent", 3);
        if (s == null) {
            return;
        }
        try {
            Double d = Double.parseDouble(s);
            Main.pnlTabs.mapTab.map.setZoom(d);
        }
        catch (NumberFormatException e) {
            JOptionPane.showMessageDialog(null, s + " is not a valid zoom.  Leaving zoom at " + MapPanel.zoom);
        }
        catch (OutOfMemoryError e) {
            JOptionPane.showMessageDialog(null, "Whoops!  There's not enough memory to zoom out that far!  Set a lower zoom, and you'll be back in business", "Satellites can't orbit that far out!", 1);
        }
    }

    private static void setFontRecursive(Component[] components, Font font) {
        for (Component c : components) {
            c.setFont(font);
            if (!(c instanceof Container)) continue;
            Main.setFontRecursive(((Container)c).getComponents(), font);
        }
    }

    private void loadInterfaceElements() {
        try {
            if (logger.isInfoEnabled()) {
                logger.info("civInstallDir: " + Main.settings.civInstallDir);
            }
            if (GRAPHICS_ENABLED) {
                if (!this.loadNTPColors(biqFile.get(biqIndex))) {
                    return;
                }
            } else {
                this.colors = new Color[32];
                for (int i = 0; i < 32; ++i) {
                    this.colors[i] = Color.MAGENTA;
                }
            }
            if (GRAPHICS_ENABLED) {
                String units32Name = null;
                try {
                    units32Name = utils.findFile("units_32.pcx", "Art" + fileSlash + "Units" + fileSlash, biqFile.get(biqIndex));
                }
                catch (FileNotFoundException e) {
                    logger.error("Could not find units_32.pcx; civInstallDir = " + Main.settings.civInstallDir, e);
                    JOptionPane.showMessageDialog(null, "Could not find units_32.pcx.  The civ install dir (" + Main.settings.civInstallDir + ") being incorrect may cause this problem.  This can be changed by clicking on the Settings button.\nError: " + e.getMessage());
                    return;
                }
                Civ3PCXFilter units_32 = new Civ3PCXFilter(units32Name);
                if (logger.isDebugEnabled()) {
                    logger.debug("about to read the units32");
                }
                units_32.readFile();
                if (logger.isDebugEnabled()) {
                    logger.debug("about to parse the units32");
                }
                units_32.parse();
                if (logger.isDebugEnabled()) {
                    logger.debug("about to buffer the units32");
                }
                units_32.createBufferedImage();
                this.units32 = units_32.getBufferedImage();
                int width = this.units32.getWidth();
                if (width != 463 && logger.isInfoEnabled()) {
                    logger.info("Nonstandard height of units_32.pcx - should be okay in editor 0.57+");
                }
                int height = this.units32.getHeight();
                int localWidth = this.units32.getWidth();
                this.unitIcons = new BufferedImage[(localWidth - 1) / 32][(height - 1) / 32];
                for (int i = 0; i < (localWidth - 1) / 32; ++i) {
                    for (int j = 0; j < (height - 1) / 33; ++j) {
                        this.unitIcons[i][j] = this.units32.getSubimage(i * 32 + 1 + i, j * 32 + 1 + j, 32, 32);
                    }
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("got the units32 determined");
                }
            }
            if (GRAPHICS_ENABLED) {
                String resourcesName = null;
                try {
                    resourcesName = utils.findFile("resources.pcx", "Art" + fileSlash, biqFile.get(biqIndex));
                }
                catch (FileNotFoundException e) {
                    logger.error("Could not find resources.pcx; civInstallDir = " + Main.settings.civInstallDir, e);
                    JOptionPane.showMessageDialog(null, "Could not find resources.pcx.  The civ install dir (" + Main.settings.civInstallDir + ") being incorrect may cause this problem.  This can be changed by clicking on the Settings button.\nError: " + e.getMessage());
                    return;
                }
                PCXFilter resources = new PCXFilter(resourcesName);
                resources.readFile();
                resources.parse();
                resources.createBufferedImage();
                BufferedImage resourcesBI = resources.getBufferedImage();
                int width = resourcesBI.getWidth();
                int height = resourcesBI.getHeight();
                this.resourceIcons = new BufferedImage[width / 50 * height / 50];
                for (int j = 0; j < height / 50; ++j) {
                    for (int i = 0; i < width / 50; ++i) {
                        this.resourceIcons[i + j * (width / 50)] = resourcesBI.getSubimage(i * 50, j * 50, 50, 50);
                    }
                }
            }
            pnlTabs.loadInterfaceElements(this.colors, this.unitIcons, this.resourceIcons, this.units32);
            this.alertToSafetyUpdate();
            if (GRAPHICS_ENABLED && biqFile.get(biqIndex).hasCustomMap()) {
                pnlTabs.importMapGraphics();
            }
            fileOpen = true;
        }
        catch (Exception e) {
            logger.error("Unexpected exception: ", e);
            JOptionPane.showMessageDialog(null, "An unexpected exception occured: " + e.toString(), "Unexpected exception", 0);
        }
    }

    private boolean loadNTPColors(IO biq) throws HeadlessException {
        if (logger.isTraceEnabled()) {
            logger.trace("pcxNames.length: " + pcxNames.length);
        }
        PCXFilter[] pcxFiles = new PCXFilter[pcxNames.length];
        this.colors = new Color[pcxNames.length];
        for (int i = 0; i < pcxNames.length; ++i) {
            String pcxName = "";
            try {
                pcxName = Main.findPaletteFile(pcxNames[i] + ".pcx", biq);
            }
            catch (FileNotFoundException e) {
                logger.error("PCX file not found for " + pcxName + "; civInstallDir = " + Main.settings.civInstallDir, e);
                JOptionPane.showMessageDialog(null, "Could not find the pcx file " + pcxName + ".  The civ install dir (" + Main.settings.civInstallDir + ") being incorrect may cause this problem.  This can be changed by clicking on the Settings button.\nError: " + e.getMessage());
                return false;
            }
            pcxFiles[i] = new PCXFilter(pcxName);
            pcxFiles[i].readFile();
            pcxFiles[i].parse();
            this.colors[i] = pcxFiles[i].getColorAt(0, 0);
        }
        if (logger.isInfoEnabled()) {
            logger.info("colors determined");
        }
        long endColors = System.nanoTime();
        return true;
    }

    private static String findPaletteFile(String name, IO biq) throws FileNotFoundException {
        return utils.findFile(name, "Art" + fileSlash + "Units" + fileSlash + "Palettes" + fileSlash, biq);
    }

    public static void updateFileChooserDirectories() {
        FileIO.setCurrentDirectory(new File(Main.settings.openDir));
    }

    public static void main(String[] args) {
        if (args.length > 0) {
            editorDirectory = args[0];
        }
        final String fileToOpen = args.length > 1 ? args[1] : "";
        IO.pathToBin = editorDirectory;
        imagePath = editorDirectory + imagePath;
        Main.setupLogging(editorDirectory);
        Main.processConfigFile(editorDirectory);
        Main.setupLocale();
        Main.updateFileChooserDirectories();
        jfcBMPChooser.setCurrentDirectory(new File(Main.settings.bmpDir));
        Main.setUIFont(new FontUIResource(Main.settings.fontChoice, 0, Main.settings.fontSize));
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    if (Main.settings.lookAndFeel.equals("System")) {
                        UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                    } else if (Main.settings.lookAndFeel.equals("Metal")) {
                        UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
                    }
                }
                catch (ClassNotFoundException e) {
                    logger.error("Could not find the class javax.swing.plaf.metal.MetalLookAndFeel.  This should be included in your Java distribution.", e);
                }
                catch (InstantiationException e) {
                    logger.error("Could not instantiate the Metal look and feel", e);
                }
                catch (IllegalAccessException e) {
                    logger.error("Illegal access on the Metal look and feel", e);
                }
                catch (UnsupportedLookAndFeelException e) {
                    logger.error("The look and feel is not present and/or supported on your system", e);
                }
                Main main = new Main(fileToOpen);
                main.setLocationRelativeTo(null);
                main.setVisible(true);
                if (logger.isInfoEnabled()) {
                    logger.info("Took this many ms to get window visible");
                }
            }
        });
    }

    public static void setUIFont(FontUIResource f) {
        UIManager.put("Button.font", f);
        UIManager.put("CheckBox.font", f);
        UIManager.put("CheckBoxMenuItem.font", f);
        UIManager.put("ColorChooser.font", f);
        UIManager.put("ComboBox.font", f);
        UIManager.put("EditorPane.font", f);
        UIManager.put("FormattedTextField.font", f);
        UIManager.put("IconButton.font", f);
        UIManager.put("Label.font", f);
        UIManager.put("List.font", f);
        UIManager.put("Menu.font", f);
        UIManager.put("MenuBar.font", f);
        UIManager.put("MenuItem.font", f);
        UIManager.put("OptionPane.font", f);
        UIManager.put("Panel.font", f);
        UIManager.put("PasswordField.font", f);
        UIManager.put("PopupMenu.font", f);
        UIManager.put("ProgressBar.font", f);
        UIManager.put("RadioButton.font", f);
        UIManager.put("RadioButtonMenuItem.font", f);
        UIManager.put("ScrollPane.font", f);
        UIManager.put("Slider.font", f);
        UIManager.put("Spinner.font", f);
        UIManager.put("TabbedPane.font", f);
        UIManager.put("Table.font", f);
        UIManager.put("TableHeader.font", f);
        UIManager.put("TextArea.font", f);
        UIManager.put("TextField.font", f);
        UIManager.put("TextPane.font", f);
        UIManager.put("TitledBorder.font", f);
        UIManager.put("ToggleButton.font", f);
        UIManager.put("ToolBar.font", f);
        UIManager.put("ToolTip.font", f);
        UIManager.put("Tree.font", f);
        UIManager.put("Viewport.font", f);
    }

    public void alertToSafetyUpdate() {
        pnlTabs.alertToSafetyUpdate(safetyLevels);
    }

    public static String i18n(String key) {
        return i18n.getString(key);
    }

    public void integrateWithOSX() {
        try {
            Class<?> appClass = Class.forName("com.apple.eawt.Application");
            Object editor = appClass.getMethod("getApplication", new Class[0]).invoke(null, new Object[0]);
            Method setDockImage = appClass.getMethod("setDockIconImage", Image.class);
            setDockImage.invoke(editor, icon);
        }
        catch (ClassNotFoundException ex) {
            logger.error("com.apple.eawt.Application class not found", ex);
        }
        catch (NoSuchMethodException ex) {
            logger.error("Apple methods not found", ex);
        }
        catch (IllegalAccessException | InvocationTargetException ex) {
            logger.error("IllegalAccess or InvocationTargetException (unexpected)", ex);
        }
    }

    @Override
    public void handleAbout(ApplicationEvent event) {
        if (this.aboutPanel == null) {
            this.aboutPanel = new AboutPanel();
        }
        this.aboutPanel.setLocationRelativeTo(this);
        this.aboutPanel.setVisible(true);
        if (event != null) {
            event.setHandled(true);
        }
    }

    @Override
    public void handleOpenApplication(ApplicationEvent event) {
    }

    @Override
    public void handleOpenFile(ApplicationEvent event) {
    }

    @Override
    public void handlePreferences(ApplicationEvent event) {
    }

    @Override
    public void handlePrintFile(ApplicationEvent event) {
    }

    @Override
    public void handleQuit(ApplicationEvent event) {
        this.quitAction();
    }

    @Override
    public void handleReOpenApplication(ApplicationEvent event) {
        this.setVisible(true);
    }

    public static void enableMapTab() {
        pnlTabs.importMapGraphics();
        Main.pnlTabs.plyrTab.sendMapTabLink(Main.pnlTabs.mapTab);
        Main.pnlTabs.biqcTab.updateCheckBoxes();
        Main.pnlTabs.gameTab.worldChar = Main.biqFile.get((int)Main.biqIndex).worldCharacteristic;
    }

    public static void addCustomRules() {
        IO biq = biqFile.get(biqIndex);
        if (!biq.hasCustomRules()) {
            biq.setCustomRules(true);
            pnlTabs.enableCustomRules();
        }
    }

    public static void addCustomPlayerData() {
        IO biq = biqFile.get(biqIndex);
        if (!biq.hasCustomPlayerData()) {
            biq.setCustomPlayerData(true);
            pnlTabs.enableCustomPlayerData();
        }
    }

    private static int regParseIntValue(String regString) {
        String hex = regString.substring(2);
        return Integer.parseInt(hex, 16);
    }

    private static String regKeyValue(String key, String type, String value) {
        String result = "";
        String[] registryQuery = new String[]{"reg", "query", key};
        InputStream i = null;
        Process reg = null;
        int numBytes = 0;
        try {
            reg = Runtime.getRuntime().exec(registryQuery);
            i = reg.getInputStream();
            reg.waitFor();
            numBytes = i.available();
        }
        catch (IOException e) {
            logger.warn("Registry query failed", e);
            return result;
        }
        catch (InterruptedException e) {
            logger.warn("Exception", e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Got " + numBytes + " bytes from the registry query");
        }
        byte[] regBytes = new byte[numBytes];
        String queryResult = null;
        try {
            i.read(regBytes);
            queryResult = new String(regBytes, "ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            logger.warn("Unsupported encoding", e);
        }
        catch (IOException e) {
            logger.warn("Registry query failed", e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug(queryResult);
        }
        if (!queryResult.contains("Invalid key name")) {
            StringTokenizer t = new StringTokenizer(queryResult, "\r\n");
            block8: while (t.hasMoreTokens()) {
                String nextLine = t.nextToken();
                if (logger.isDebugEnabled()) {
                    logger.debug("Line: " + nextLine);
                }
                if (!nextLine.contains(value)) continue;
                StringTokenizer lineTokenizer = new StringTokenizer(nextLine, "\t");
                while (lineTokenizer.hasMoreTokens()) {
                    String nextToken = lineTokenizer.nextToken();
                    if (logger.isDebugEnabled()) {
                        logger.debug("Token: " + nextToken);
                    }
                    if (!nextToken.contains(type)) continue;
                    if (nextToken.equals(nextLine)) {
                        int w = nextToken.indexOf(type);
                        result = nextToken.substring(w += 4 + type.length());
                        break block8;
                    }
                    try {
                        result = lineTokenizer.nextToken();
                    }
                    catch (NoSuchElementException e) {}
                    break block8;
                }
                break block8;
            }
        }
        return result;
    }

    private void setUpRuleInfrastructure() {
        String baseBIQ = utils.getConquestsFolder(Main.settings.civInstallDir) + "conquests.biq";
        File file = new File(baseBIQ);
        IO baseRules = this.openSpecificFile(file);
        IO biq = biqFile.get(biqIndex);
        Main.biqFile.get((int)Main.biqIndex).buildings = baseRules.buildings;
        Main.biqFile.get((int)Main.biqIndex).citizens = baseRules.citizens;
        Main.biqFile.get((int)Main.biqIndex).culture = baseRules.culture;
        Main.biqFile.get((int)Main.biqIndex).difficulties = baseRules.difficulties;
        Main.biqFile.get((int)Main.biqIndex).eras = baseRules.eras;
        Main.biqFile.get((int)Main.biqIndex).espionage = baseRules.espionage;
        Main.biqFile.get((int)Main.biqIndex).experience = baseRules.experience;
        Main.biqFile.get((int)Main.biqIndex).resource = baseRules.resource;
        Main.biqFile.get((int)Main.biqIndex).government = baseRules.government;
        Main.biqFile.get((int)Main.biqIndex).rule = baseRules.rule;
        Main.biqFile.get((int)Main.biqIndex).unit = baseRules.unit;
        Main.biqFile.get((int)Main.biqIndex).numUnits = baseRules.numUnits;
        Main.biqFile.get((int)Main.biqIndex).civilization = baseRules.civilization;
        Main.biqFile.get((int)Main.biqIndex).technology = baseRules.technology;
        Main.biqFile.get((int)Main.biqIndex).workerJob = baseRules.workerJob;
        Main.biqFile.get((int)Main.biqIndex).terrain = baseRules.terrain;
        Main.biqFile.get((int)Main.biqIndex).worldSize = baseRules.worldSize;
        Main.biqFile.get((int)Main.biqIndex).flavor = baseRules.flavor;
        if (biq.convertToConquests == 1 && biq.scenarioProperty.get((int)0).civPartOfWhichAlliance.size() == 0) {
            for (int i = 1; i < baseRules.civilization.size(); ++i) {
                biq.scenarioProperty.get((int)0).civPartOfWhichAlliance.add(0);
            }
        }
        baseRules = null;
    }

    private void setUpPlayerDataInfrastructure() {
        for (int i = 0; i < 8; ++i) {
            LEAD player = new LEAD(biqFile.get(biqIndex));
            if (i == 0) {
                player.humanPlayer = 1;
            }
            Main.biqFile.get((int)Main.biqIndex).player.add(player);
        }
    }

    public void updateBIQLinks() {
        if (biqFile.get(biqIndex).hasCustomMap()) {
            Main.pnlTabs.mapTab.map.sendData(Main.biqFile.get((int)Main.biqIndex).worldMap.get(0), Main.biqFile.get((int)Main.biqIndex).tile, Main.biqFile.get((int)Main.biqIndex).resource, Main.biqFile.get((int)Main.biqIndex).city, Main.biqFile.get((int)Main.biqIndex).rule, Main.biqFile.get((int)Main.biqIndex).civilization, biqFile.get(biqIndex));
        }
    }

    public static IO getCurrentBIQ() {
        return biqFile.get(biqIndex);
    }

    public static void setBIQForTesting(IO testBiqFile) {
        biqFile = new ArrayList<IO>();
        biqFile.add(testBiqFile);
        biqIndex = 0;
    }

    public static void undoPush(BIQSection b, int index) {
        currentUndoStack.push(b, index);
    }

    static {
        i18n = null;
        logger = Logger.getLogger("Main");
        biqFile = new ArrayList<IO>();
        biqIndex = -1;
        fileOpen = false;
        mapIsLoaded = false;
        pcxNames = new String[]{"ntp00", "ntp01", "ntp02", "ntp03", "ntp04", "ntp05", "ntp06", "ntp07", "ntp08", "ntp09", "ntp10", "ntp11", "ntp12", "ntp13", "ntp14", "ntp15", "ntp16", "ntp17", "ntp18", "ntp19", "ntp20", "ntp21", "ntp22", "ntp23", "ntp24", "ntp25", "ntp26", "ntp27", "ntp28", "ntp29", "ntp30", "ntp31"};
        fileChooserMode = "FileDialog";
        jfcBMPChooser = new JFileChooser();
        jfcCSVChooser = new JFileChooser();
        needToWaitTillArgsProcessed = true;
        editorDirectory = "";
        currentSAV = null;
        System.setProperty("com.apple.mrj.application.apple.menu.about.name", TITLE);
        System.setProperty("apple.laf.useScreenMenuBar", "true");
        Main.os.name = System.getProperty("os.name");
        Main.os.version = System.getProperty("os.version");
        Main.os.arch = System.getProperty("os.arch");
        fileChooserMode = Main.os.name.toLowerCase().contains("mac") && (Main.os.arch.toLowerCase().contains("x86") || Main.os.arch.toLowerCase().contains("x64")) ? "FileDialog" : "JavaFX";
        safetyLevels = new HashMap<String, SafetyLevel>();
        safetyLevels.put("BLDG", SafetyLevel.Safe);
        safetyLevels.put("CTZN", SafetyLevel.Safe);
        safetyLevels.put("CULT", SafetyLevel.Safe);
        safetyLevels.put("DIFF", SafetyLevel.Safe);
        safetyLevels.put("ERA", SafetyLevel.Safe);
        safetyLevels.put("ESPN", SafetyLevel.Safe);
        safetyLevels.put("EXPR", SafetyLevel.Safe);
        safetyLevels.put("FLAV", SafetyLevel.Safe);
        safetyLevels.put("GOOD", SafetyLevel.Safe);
        safetyLevels.put("GOVT", SafetyLevel.Safe);
        safetyLevels.put("PLYR", SafetyLevel.Safe);
        safetyLevels.put("RULE", SafetyLevel.Safe);
        safetyLevels.put("PRTO", SafetyLevel.Safe);
        safetyLevels.put("TECH", SafetyLevel.Safe);
        safetyLevels.put("TERR", SafetyLevel.Safe);
        safetyLevels.put("TRFM", SafetyLevel.Safe);
        safetyLevels.put("WSIZ", SafetyLevel.Safe);
        safetyLevels.put("RACE", SafetyLevel.Safe);
        safetyLevels.put("PROP", SafetyLevel.Safe);
        javaFXImage = null;
    }

    public class LoadAccelerator
    extends Thread {
        Main main;

        public LoadAccelerator(Main main) {
            this.main = main;
        }

        @Override
        public void run() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    new JFXPanel();
                    Platform.setImplicitExit((boolean)false);
                }
            });
            if (logger.isDebugEnabled()) {
                logger.debug("running the load accelerator");
            }
            Main.this.menus.setupDelayedActions();
            pnlTabs.setup(this.main);
            Main.this.gc.gridy = 1;
            Main.this.gc.gridx = 0;
            Main.this.gc.weighty = 1.0;
            Main.this.gc.weightx = 1.0;
            Main.this.gc.gridwidth = 12;
            Main.this.gc.fill = 1;
            Main.this.getContentPane().add((Component)pnlTabs, Main.this.gc);
            javaFXImage = new javafx.scene.image.Image("file:imgs/icon.PNG");
            Main.this.safetyLevelWindow = new FrmSafetyLevel();
            Main.this.safetyLevelWindow.setIconImage(icon);
            Main.this.safetyLevelWindow.syncWithMain(safetyLevels, this.main);
            logger.info("load accelerator done");
            Main.this.loadAcceleratorDone = true;
        }
    }
}

