/*
 * Decompiled with CFR 0.152.
 */
package com.civfanatics.civ3.xplatformeditor;

import com.civfanatics.civ3.biqFile.CITY;
import com.civfanatics.civ3.biqFile.CLNY;
import com.civfanatics.civ3.biqFile.GOOD;
import com.civfanatics.civ3.biqFile.IO;
import com.civfanatics.civ3.biqFile.LEAD;
import com.civfanatics.civ3.biqFile.RACE;
import com.civfanatics.civ3.biqFile.RULE;
import com.civfanatics.civ3.biqFile.SLOC;
import com.civfanatics.civ3.biqFile.TERR;
import com.civfanatics.civ3.biqFile.TILE;
import com.civfanatics.civ3.biqFile.UNIT;
import com.civfanatics.civ3.biqFile.WMAP;
import com.civfanatics.civ3.xplatformeditor.Main;
import com.civfanatics.civ3.xplatformeditor.MapTab;
import com.civfanatics.civ3.xplatformeditor.MenuSystem;
import com.civfanatics.civ3.xplatformeditor.Settings;
import com.civfanatics.civ3.xplatformeditor.tabs.map.Brush;
import com.civfanatics.civ3.xplatformeditor.tabs.map.GraphicsAssets;
import com.civfanatics.civ3.xplatformeditor.tabs.map.MapDirection;
import com.civfanatics.civ3.xplatformeditor.tabs.map.MapUtils;
import com.civfanatics.civ3.xplatformeditor.tabs.map.OverlayType;
import com.civfanatics.civ3.xplatformeditor.tabs.map.renderer.ClassicRenderer;
import com.civfanatics.civ3.xplatformeditor.tabs.map.renderer.Renderer;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.apache.log4j.Logger;

public class MapPanel
extends JPanel
implements Runnable {
    Logger logger = Logger.getLogger(this.getClass());
    private static final int PANELWIDTH = 1000;
    private static final int PANELHEIGHT = 700;
    private static int BUFFERWIDTH = 1300;
    private static int BUFFERHEIGHT = 1200;
    private static int TILE_WIDTH = 128;
    private static int TILE_HEIGHT = 64;
    private Thread animator;
    private volatile boolean running = false;
    public volatile boolean activeTab = false;
    public int updateCount = 2;
    public boolean firstIteration = true;
    public boolean alwaysUpdate = false;
    private boolean isBenchmarking = false;
    private long benchmarkFrames = 0L;
    private long totalRenderTime;
    private BufferedImage buffer = null;
    private int horizScrollOffset;
    private int vertScrollOffset;
    private int period = 30000000;
    public boolean isPaused = false;
    final short CLASSIC_MODE = 1;
    static double zoom = 1.0;
    static short renderMode = 1;
    WMAP wmap;
    IO biq;
    List<TILE> tiles;
    List<LEAD> player;
    List<GOOD> resource;
    List<CITY> city;
    List<RULE> rule;
    List<RACE> civ;
    List<SLOC> startingLocation;
    List<CLNY> colony;
    GraphicsAssets assets = null;
    MapTab mapTab;
    public boolean gridOn = true;
    private boolean customPlayerData = false;
    Settings settings;
    Brush brush;
    Renderer renderer = null;
    private boolean skipOverlayRestrictions = false;
    Random rnd = new Random();
    int napTime = 0;
    Set encounteredExceptions = new HashSet();

    public MapPanel() {
        this.settings = Main.settings;
        this.brush = new Brush();
        this.setBackground(Color.white);
        this.setPreferredSize(new Dimension(1000, 700));
        this.setFocusable(true);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                MapPanel.this.getGraphics().drawOval(e.getX(), e.getY(), 3, 3);
                MapPanel.this.mousePress(e.getX(), e.getY());
            }
        });
        this.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                MapPanel.this.mousePress(e.getX(), e.getY());
            }

            @Override
            public void mouseMoved(MouseEvent e) {
            }
        });
    }

    public void setAssets(GraphicsAssets assets) {
        this.assets = assets;
        Image image = this.createImage(BUFFERWIDTH, BUFFERHEIGHT);
        this.renderer = new ClassicRenderer(image, assets, this.biq);
    }

    public void benchmark() {
        EventQueue.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    MapPanel.this.benchmarkFrames = 0L;
                    MapPanel.this.totalRenderTime = 0L;
                    MapPanel.this.alwaysUpdate = true;
                    MapPanel.this.isBenchmarking = true;
                    3 var1_1 = this;
                    synchronized (var1_1) {
                        this.wait(10000L);
                    }
                    MapPanel.this.isBenchmarking = false;
                    MapPanel.this.alwaysUpdate = false;
                    long avgTimePerFrame = MapPanel.this.totalRenderTime / MapPanel.this.benchmarkFrames;
                    long fps = 1000000L / avgTimePerFrame;
                    MapPanel.this.logger.info("The average FPS is " + fps + " frames per second");
                    JOptionPane.showMessageDialog(null, "The average FPS is " + fps + " frames per second");
                }
                catch (Exception ex) {
                    MapPanel.this.logger.error("Exception in benchmarking thread", ex);
                }
            }
        });
    }

    public void sendData(WMAP wmap, List<TILE> tile, List<GOOD> resource, List<CITY> city, List<RULE> rule, List<RACE> civ, IO biq) {
        this.tiles = tile;
        this.wmap = wmap;
        this.resource = resource;
        this.city = city;
        this.rule = rule;
        this.civ = civ;
        this.biq = biq;
        this.startingLocation = biq.startingLocation;
        this.colony = biq.colony;
        this.setPreferredSize(new Dimension(wmap.width * 64, wmap.height * 32));
        this.logger.info("Size of canvas: " + wmap.width * 64 + " x " + wmap.height * 32);
    }

    public void sendPlayerData(List<LEAD> player) {
        this.customPlayerData = true;
        this.player = player;
    }

    public void receiveHorizPosition(int x) {
        this.horizScrollOffset = (int)((double)x / zoom);
        this.renderer.setHorizPosition(this.horizScrollOffset);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("New x value: " + x);
            this.logger.debug("horizScrollPosition: " + this.horizScrollOffset);
        }
        this.triggerUpdates();
    }

    public void receiveVertPosition(int y) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Receiving vertical position");
        }
        this.vertScrollOffset = (int)((double)y / zoom);
        this.renderer.setVertPosition(this.vertScrollOffset);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("New y value: " + y);
        }
        this.triggerUpdates();
    }

    private void mousePress(int xPixel, int yPixel) {
        int northPolarYHeight_32 = 32;
        if (!this.isPaused) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Mouse press at " + xPixel + ", " + yPixel + ".");
            }
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("2*(xPixel/128) + 1 = " + (2 * (xPixel / 128) + 1));
                this.logger.trace("(2*((int)(((yPixel - 32)/64)/zoom))) + 1 = " + (2 * (int)((double)((yPixel - northPolarYHeight_32) / 64) / zoom) + 1));
                this.logger.trace("yPixel: " + yPixel);
                this.logger.trace("mapY w/o zoom: " + (2 * ((yPixel - northPolarYHeight_32) / 64) + 1));
                this.logger.trace("mapY with zoom: " + (2 * (int)((double)((yPixel - northPolarYHeight_32) / 64) / zoom) + 1));
                this.logger.trace("mapY with zoom with double: " + (2 * (int)((double)(yPixel - northPolarYHeight_32) / 64.0 / zoom) + 1));
            }
            int mapY = 2 * (int)(((double)yPixel - (double)northPolarYHeight_32 * zoom) / (64.0 * zoom)) + 1;
            int mapX = 2 * (int)((double)xPixel / (128.0 * zoom)) + 1;
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("mapX with zoom: " + (2 * (int)((double)xPixel / (128.0 * zoom)) + 1));
                this.logger.trace("mapX with zoom with extra double: " + (2 * (int)((double)xPixel / (128.0 * zoom)) + 1));
                this.logger.trace("mapX before int conversion (reg): " + (double)xPixel / (128.0 * zoom));
                this.logger.trace("mapX: " + mapX);
            }
            if (mapX % 2 != 1) {
                this.logger.warn("mapX is even at a point when it should always be odd.  mapX is " + mapX + ".  Mouse press was at (" + xPixel + ", " + yPixel + ")");
            }
            if (mapY % 2 != 1) {
                this.logger.warn("mapY is even at a point when it should always be odd.  mapY is " + mapY + ".  Mouse press was at (" + xPixel + ", " + yPixel + ")");
            }
            int xOffset = (int)((double)xPixel % (128.0 * zoom));
            int yOffset = (int)(((double)yPixel - (double)northPolarYHeight_32 * zoom) % (64.0 * zoom));
            if (this.logger.isTraceEnabled()) {
                this.logger.info("xOffset: " + xOffset);
                this.logger.info("yOffset: " + yOffset);
            }
            int riverX = mapX;
            int riverY = mapY;
            if (2 * yOffset + xOffset < (int)(64.0 * zoom) && yOffset < (int)(32.0 * zoom) && xOffset < (int)(64.0 * zoom)) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Move NW from " + mapX + ", " + mapY);
                }
                --mapX;
                --mapY;
            } else if (-2 * yOffset + xOffset > (int)(64.0 * zoom) && xOffset > (int)(64.0 * zoom) && yOffset < (int)(32.0 * zoom)) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Move NE from " + mapX + ", " + mapY);
                }
                ++mapX;
                --mapY;
            } else if (-2 * yOffset + xOffset < (int)(-64.0 * zoom) && xOffset < (int)(64.0 * zoom) && yOffset > (int)(32.0 * zoom)) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Move SW from " + mapX + ", " + mapY);
                }
                --mapX;
                ++mapY;
            } else if (2 * yOffset + xOffset > (int)(192.0 * zoom) && yOffset > (int)(32.0 * zoom) && xOffset > (int)(64.0 * zoom)) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Move SE from " + mapX + ", " + mapY);
                }
                ++mapX;
                ++mapY;
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Square pressed = " + mapX + ", " + mapY);
            }
            if (mapX >= this.wmap.width || mapX < 0 || mapY > this.wmap.height || mapY < 0) {
                return;
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Brush mode: " + this.brush.mode);
            }
            switch (this.brush.mode) {
                case 0: {
                    this.mapTab.alertToSquarePress(mapX, mapY);
                    break;
                }
                case 1: {
                    List<TILE> tilesInDiameter = this.biq.getTilesInDiameter(mapX, mapY, this.brush.diameter);
                    for (TILE tile : tilesInDiameter) {
                        this.handleTerrainEvent(tile, false);
                    }
                    this.triggerUpdates();
                    this.mapTab.alertToSquarePress(mapX, mapY);
                    break;
                }
                case 3: {
                    if (this.brush.overlayType == OverlayType.RIVER) {
                        MapDirection direction = MapUtils.determineRiverDirection(xOffset, yOffset, mapX, mapY);
                        if (direction != MapDirection.NONE) {
                            this.handleRiverEvent(riverX, riverY, direction);
                        }
                    } else {
                        this.handleOverlayEvent(mapX, mapY);
                    }
                    this.mapTab.alertToSquarePress(mapX, mapY);
                    break;
                }
                case 4: {
                    this.handleCityEvent(mapX, mapY);
                    this.mapTab.alertToSquarePress(mapX, mapY);
                    break;
                }
                case 5: {
                    this.brush.mode = 0;
                    this.handleCityRelocateEvent(mapX, mapY);
                    this.mapTab.alertToSquarePress(mapX, mapY);
                    break;
                }
                case 6: {
                    this.brush.mode = 0;
                    boolean cityMoved = this.handleCityRelocateEvent(mapX, mapY);
                    if (cityMoved) {
                        this.handleUnitRelocationEvent(mapX, mapY);
                    }
                    this.mapTab.alertToSquarePress(mapX, mapY);
                    break;
                }
                case 7: {
                    this.handleFogEvent(mapX, mapY, true);
                    this.mapTab.alertToSquarePress(mapX, mapX);
                    break;
                }
                case 8: {
                    this.handleFogEvent(mapX, mapY, false);
                    break;
                }
                default: {
                    this.logger.warn("Unexpected brush mode");
                }
            }
        }
    }

    private void handleTerrainEvent(TILE tile, boolean triggerUpdates) {
        int x = tile.xPos;
        int y = tile.yPos;
        int terrainType = this.brush.terrainType;
        if (terrainType > 6 && terrainType < 11) {
            tile.setRealTerrain(terrainType);
            tile.setUpNibbles();
            tile.C3CBonuses = this.brush.isLandmark ? (tile.C3CBonuses |= 0x2000) : (tile.C3CBonuses &= 0xFFFFDFFF);
            if (terrainType == 7) {
                tile.C3CBonuses = this.brush.isPine ? (tile.C3CBonuses |= 0x20) : (tile.C3CBonuses &= 0xFFFFFFDF);
            }
            if (triggerUpdates) {
                this.triggerUpdates();
            }
        } else if (terrainType < 14) {
            boolean wasLandmark;
            boolean bl = wasLandmark = (tile.C3CBonuses & 0x2000) == 8192;
            tile.C3CBonuses = this.brush.isLandmark ? (tile.C3CBonuses |= 0x2000) : (tile.C3CBonuses &= 0xFFFFDFFF);
            if (terrainType == 12 && this.brush.isDeepwaterHarbour) {
                if (tile.getBaseTerrain() == 11) {
                    tile.setBaseTerrain(terrainType);
                    tile.setRealTerrain(terrainType);
                    tile.setUpNibbles();
                    JOptionPane.showMessageDialog(null, "Deepwater harbour created");
                    return;
                }
                JOptionPane.showMessageDialog(null, "Can only create deepwater harbours on coast");
            }
            if (this.makeTerrainChange(x, y, terrainType)) {
                if (terrainType == 6) {
                    tile.C3CBonuses = this.brush.isSnowCapped ? (tile.C3CBonuses |= 0x10) : (tile.C3CBonuses &= 0xFFFFFFEF);
                }
                if (terrainType == 2) {
                    tile.C3CBonuses = this.brush.isBonusGrassland ? (tile.C3CBonuses |= 1) : (tile.C3CBonuses &= 0xFFFFFFFE);
                }
                if (triggerUpdates) {
                    this.triggerUpdates();
                }
            } else if (wasLandmark) {
                this.logger.info("Making landmark");
                tile.C3CBonuses |= 0x2000;
            } else {
                this.logger.info("Making unlandmark");
                tile.C3CBonuses &= 0xFFFFDFFF;
            }
        }
    }

    private void handleFogEvent(int mapX, int mapY, boolean addFog) {
        int tileID = this.biq.calculateTileIndex(mapX, mapY);
        this.tiles.get(tileID).setFogOfWar(addFog ? (short)0 : 1);
        this.triggerUpdates();
    }

    private boolean makeTerrainChange(int x, int y, int terrainType) {
        boolean okay = true;
        int north = this.biq.calculateTileIndex(x, y - 2);
        int northEast = this.biq.calculateTileIndex(x + 1, y - 1);
        int east = this.biq.calculateTileIndex(x + 2, y);
        int southEast = this.biq.calculateTileIndex(x + 1, y + 1);
        int south = this.biq.calculateTileIndex(x, y + 2);
        int southWest = this.biq.calculateTileIndex(x - 1, y + 1);
        int west = this.biq.calculateTileIndex(x - 2, y);
        int northWest = this.biq.calculateTileIndex(x - 1, y - 1);
        int center = this.biq.calculateTileIndex(x, y);
        boolean canMakeChange = true;
        byte backupReal = this.tiles.get(center).getRealTerrain();
        byte backupBase = this.tiles.get(center).getBaseTerrain();
        if (terrainType == 5 || terrainType == 6) {
            this.biq.tile.get(center).setRealTerrain(terrainType);
            this.biq.tile.get(center).setBaseTerrain(2);
        } else {
            this.biq.tile.get(center).setRealTerrain(terrainType);
            this.biq.tile.get(center).setBaseTerrain(terrainType);
        }
        this.tiles.get(center).setUpNibbles();
        if (!MapUtils.validChangeOnTiles(this.biq, northWest, north, northEast, center)) {
            canMakeChange = false;
        }
        if (!MapUtils.validChangeOnTiles(this.biq, center, northEast, east, southEast)) {
            canMakeChange = false;
        }
        if (!MapUtils.validChangeOnTiles(this.biq, southWest, center, southEast, south)) {
            canMakeChange = false;
        }
        if (!MapUtils.validChangeOnTiles(this.biq, west, northWest, center, southWest)) {
            canMakeChange = false;
        }
        if (!canMakeChange) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Invalid change");
            }
            this.biq.tile.get(center).setRealTerrain(backupReal);
            this.biq.tile.get(center).setBaseTerrain(backupBase);
            this.tiles.get(center).setUpNibbles();
            return false;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Valid change");
        }
        MapUtils.recalculateFileAndIndex(this.biq, x, y);
        MapUtils.recalculateFileAndIndex(this.biq, x - 1, y + 1);
        MapUtils.recalculateFileAndIndex(this.biq, x + 1, y + 1);
        MapUtils.recalculateFileAndIndex(this.biq, x, y + 2);
        return true;
    }

    private void handleOverlayEvent(int x, int y) {
        int tileSelected = this.biq.calculateTileIndex(x, y);
        TILE tile = this.tiles.get(tileSelected);
        int terrainType = this.brush.terrainType;
        byte realTerrain = this.tiles.get(tileSelected).getRealTerrain();
        TERR terrain = this.biq.terrain.get(realTerrain);
        switch (this.brush.overlayType) {
            case IRRIGATION: {
                if (terrain.getFoodBonus() <= 0 && !this.skipOverlayRestrictions) break;
                this.tiles.get(tileSelected).setIrrigated(true);
                this.tiles.get(tileSelected).setMined(false);
                break;
            }
            case MINE: {
                if (terrain.getShieldsBonus() <= 0 && !this.skipOverlayRestrictions) break;
                this.tiles.get(tileSelected).setMined(true);
                this.tiles.get(tileSelected).setIrrigated(false);
                break;
            }
            case ROAD: {
                if (terrain.getCommerceBonus() <= 0 && !this.skipOverlayRestrictions) break;
                this.tiles.get(tileSelected).setRoad(true);
                break;
            }
            case RAILROAD: {
                if (terrain.getCommerceBonus() <= 0 && !this.skipOverlayRestrictions) break;
                this.tiles.get(tileSelected).setRailroad(true);
                break;
            }
            case FORT: {
                if (terrain.getAllowForts() != 1 && !this.skipOverlayRestrictions) break;
                this.tiles.get(tileSelected).setFort(true);
                break;
            }
            case BARRICADE: {
                if (terrain.getAllowForts() != 1 && !this.skipOverlayRestrictions) break;
                this.tiles.get(tileSelected).setBarricade(true);
                break;
            }
            case BARBARIAN_CAMP: {
                if (this.tiles.get(tileSelected).isWater() && !this.skipOverlayRestrictions) break;
                this.tiles.get(tileSelected).setBarbarianCamp(true);
                break;
            }
            case GOODY_HUT: {
                if (this.tiles.get(tileSelected).isWater() && !this.skipOverlayRestrictions) break;
                this.tiles.get(tileSelected).setGoodyHut(true);
                break;
            }
            case POLLUTION: {
                this.tiles.get(tileSelected).setPollution(true);
                break;
            }
            case CRATERS: {
                this.tiles.get(tileSelected).setCrater(true);
                break;
            }
            case VICTORY_POINT_LOCATION: {
                this.tiles.get(tileSelected).setVictoryPointLocation((short)0);
                break;
            }
            case RUINS: {
                if (terrain.getAllowCities() != 1 && !this.skipOverlayRestrictions) break;
                this.tiles.get(tileSelected).setRuin(1);
                break;
            }
            case STARTING_LOCATION: {
                if (this.tiles.get(tileSelected).isWater() && !this.skipOverlayRestrictions) break;
                SLOC newStartingLocation = new SLOC(this.biq);
                newStartingLocation.setX(x);
                newStartingLocation.setY(y);
                newStartingLocation.setOwnerType(0);
                this.biq.startingLocation.add(newStartingLocation);
                break;
            }
            case RADAR_TOWER: {
                if (!terrain.allowsRadarTowers() && !this.skipOverlayRestrictions) break;
                this.handlePaintedColony(tile, 2);
                break;
            }
            case AIRFIELD: {
                if (!terrain.allowsAirfields() && !this.skipOverlayRestrictions) break;
                this.handlePaintedColony(tile, 1);
                break;
            }
            case COLONY: {
                GOOD good;
                int goodIndex;
                boolean allowColony = false;
                if (terrain.allowsColonies() && (goodIndex = tile.getResource()) != -1 && ((good = this.biq.resource.get(goodIndex)).isLuxury() || good.isStrategic())) {
                    allowColony = true;
                }
                if (!allowColony && !this.skipOverlayRestrictions) break;
                this.handlePaintedColony(tile, 0);
                break;
            }
            case OUTPOST: {
                if (!terrain.allowsOutposts() && !this.skipOverlayRestrictions) break;
                this.handlePaintedColony(tile, 3);
            }
        }
        this.triggerUpdates();
    }

    private void handleRiverEvent(int mapX, int mapY, MapDirection direction) {
        this.mapTab.toggleRiver(mapX, mapY, direction, true);
        this.triggerUpdates();
    }

    private void handlePaintedColony(TILE tile, int COLONY_TYPE) {
        if (tile.getColony() == -1) {
            CLNY newColony = new CLNY(this.biq);
            newColony.setImprovementType(COLONY_TYPE);
            newColony.setX(tile.xPos);
            newColony.setY(tile.yPos);
            if (tile.owner != -1) {
                newColony.setOwner(tile.owner);
                newColony.setOwnerType(tile.ownerType);
            } else {
                newColony.setOwnerType(2);
                newColony.setOwner(1);
            }
            this.biq.colony.add(newColony);
            tile.setColony((short)(this.biq.colony.size() - 1));
        } else {
            CLNY curColony = this.biq.colony.get(tile.getColony());
            if (curColony.getImprovementType() != COLONY_TYPE) {
                curColony.setImprovementType(COLONY_TYPE);
            }
        }
    }

    private void handleCityEvent(int x, int y) {
        int tileSelected = this.biq.calculateTileIndex(x, y);
        if (this.tiles.get(tileSelected).getCity() != -1) {
            return;
        }
        this.logger.info("Handling city event");
        String name = JOptionPane.showInputDialog(null, "Enter a name for the new city.", "City name", -1);
        if (name == null) {
            return;
        }
        CITY newCity = new CITY(this.biq, name, x, y);
        this.biq.city.add(newCity);
        this.tiles.get(tileSelected).setCity((short)(this.biq.city.size() - 1));
        this.biq.calculateTileOwners();
    }

    private boolean handleCityRelocateEvent(int x, int y) {
        int tileSelected = this.biq.calculateTileIndex(x, y);
        if (this.tiles.get(tileSelected).getCity() != -1) {
            return false;
        }
        short cityIndex = this.brush.tileBeingRelocated.getCity();
        int oldX = this.biq.city.get(cityIndex).getX();
        int oldY = this.biq.city.get(cityIndex).getY();
        List<TILE> oldInfluences = this.biq.city.get((int)cityIndex).tilesInfluenced;
        this.biq.city.get(cityIndex).setX(x);
        this.biq.city.get(cityIndex).setY(y);
        int oldIndex = this.biq.calculateTileIndex(oldX, oldY);
        this.tiles.get(oldIndex).setCity((short)-1);
        this.tiles.get(tileSelected).setCity(cityIndex);
        this.biq.calculateTileOwners();
        return true;
    }

    private void handleUnitRelocationEvent(int x, int y) {
        List<Integer> units = this.brush.tileBeingRelocated.unitsOnTile;
        int newIndex = this.biq.calculateTileIndex(x, y);
        this.logger.info("x, y works out to: " + x + ", " + y + " = " + newIndex);
        for (int i = 0; i < units.size(); ++i) {
            int unitIndex = units.get(i);
            UNIT unit = this.biq.mapUnit.get(unitIndex);
            unit.setX(x);
            unit.setY(y);
            this.logger.info("new tile has x, y of " + this.biq.tile.get((int)newIndex).xPos + ", " + this.biq.tile.get((int)newIndex).yPos);
            this.biq.tile.get((int)newIndex).unitsOnTile.add(unitIndex);
        }
        this.biq.tile.get(newIndex).calculateUnitWithBestDefence();
        this.brush.tileBeingRelocated.unitsOnTile.clear();
        this.brush.tileBeingRelocated.calculateUnitWithBestDefence();
    }

    public void sendTab(MapTab tab) {
        this.mapTab = tab;
    }

    @Override
    public void addNotify() {
        super.addNotify();
    }

    public void startMapPanel() {
        if (this.animator == null || !this.running) {
            this.animator = new Thread(this);
            this.animator.start();
        }
        this.logger.info("Map panel started");
    }

    public void stopMapPanel() {
        this.running = false;
    }

    @Override
    public void run() {
        long beforeTime = System.nanoTime();
        this.running = true;
        while (this.running) {
            if (this.shouldRedraw()) {
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace("update: " + this.updateCount);
                }
                beforeTime = System.nanoTime();
                if (this.firstIteration || this.isBenchmarking) {
                    this.firstIteration = false;
                    this.renderer.render();
                }
                this.buffer = this.renderer.getBuffer();
                this.paintScreen();
                long timeDiff = System.nanoTime() - beforeTime;
                if (this.logger.isTraceEnabled() || this.isBenchmarking) {
                    this.logger.trace("time to render: " + timeDiff / 1000000L);
                    ++this.benchmarkFrames;
                    this.totalRenderTime += timeDiff / 1000L;
                }
                long sleepTime = (long)this.period - timeDiff;
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace("Sleep time: " + sleepTime / 1000000L + " ms");
                }
                if (sleepTime <= 0L) {
                    sleepTime = 5L;
                }
                try {
                    Thread.sleep(sleepTime / 1000000L);
                }
                catch (InterruptedException ex) {
                    this.logger.error("Interrupted exception in map loop", ex);
                }
                beforeTime = System.nanoTime();
                --this.updateCount;
                continue;
            }
            try {
                Thread.sleep(30L);
                this.napTime += 30;
                if (this.napTime <= 5000) continue;
                this.updateCount = 2;
                this.napTime = 0;
            }
            catch (InterruptedException ex) {
                this.logger.error("Interrupted exception in map loop", ex);
            }
        }
    }

    private boolean shouldRedraw() {
        return this.activeTab && (this.updateCount > 0 || this.alwaysUpdate) && !MenuSystem.hasMenuOpen();
    }

    public void triggerUpdates() {
        this.updateCount = Main.settings.drawReps;
        this.firstIteration = true;
    }

    private void paintScreen() {
        try {
            Graphics2D g = (Graphics2D)this.getGraphics();
            if (g != null && this.buffer != null && this.activeTab) {
                if (zoom != 1.0) {
                    Image i = this.buffer.getScaledInstance((int)((double)this.buffer.getWidth() * zoom), (int)((double)this.buffer.getHeight() * zoom), Main.settings.zoomQuality);
                    g.drawImage(i, (int)((double)this.horizScrollOffset * zoom), (int)((double)this.vertScrollOffset * zoom), null);
                } else {
                    g.drawImage((Image)this.buffer, this.horizScrollOffset, this.vertScrollOffset, null);
                }
            }
            g.dispose();
        }
        catch (Exception e) {
            this.logger.error("Graphics context error: ", e);
        }
    }

    public void updateBufferSize(int width) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("Got new buffer width");
        }
        BUFFERWIDTH = width + 64;
        this.buffer = (BufferedImage)this.createImage(BUFFERWIDTH, BUFFERHEIGHT);
        this.setZoom(100.0 * zoom);
    }

    public Image drawTile(int x, int y) {
        return this.renderer.drawTile(x, y);
    }

    public int getVertPosition() {
        return this.vertScrollOffset;
    }

    void setZoom(double d) {
        if (this.wmap != null) {
            zoom = d * 0.01;
            BUFFERWIDTH = (int)((double)Main.mainMain.getWidth() / zoom);
            BUFFERHEIGHT = (int)((double)Main.mainMain.getHeight() / zoom);
            this.buffer = (BufferedImage)this.createImage(BUFFERWIDTH, BUFFERHEIGHT);
            this.renderer.setViewportSize(BUFFERWIDTH, BUFFERHEIGHT);
            int scrollBarWidth = (int)((double)(this.wmap.width * 64) * zoom);
            int scrollBarHeight = (int)((double)(this.wmap.height * 32) * zoom);
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("New width: " + scrollBarWidth + ", scrollBarHeight: " + scrollBarHeight);
            }
            this.setPreferredSize(new Dimension(scrollBarWidth, scrollBarHeight));
            Main.pnlTabs.mapTab.setZoom(zoom, scrollBarWidth, scrollBarHeight);
        }
    }
}

