/*
 * Decompiled with CFR 0.152.
 */
package com.civfanatics.civ3.xplatformeditor;

import com.civfanatics.civ3.biqFile.IO;
import com.civfanatics.civ3.ruleModifier.ui.RuleChangeApplierController;
import com.civfanatics.civ3.savFile.HistTurn;
import com.civfanatics.civ3.savFile.SAV;
import com.civfanatics.civ3.xplatformeditor.CustomComponents.EditMenu;
import com.civfanatics.civ3.xplatformeditor.Main;
import com.civfanatics.civ3.xplatformeditor.Settings;
import com.civfanatics.civ3.xplatformeditor.savFunctionality.CustomHistograph;
import com.civfanatics.civ3.xplatformeditor.tabs.map.MapFlipper;
import com.civfanatics.civ3.xplatformeditor.tabs.map.MapStats;
import com.civfanatics.civ3.xplatformeditor.tabs.map.frmBuildingsInCities;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import javafx.application.Platform;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.stage.Stage;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import org.apache.log4j.Logger;

public class MenuSystem {
    static Logger logger = Logger.getLogger(MenuSystem.class);
    JMenu mapMenu;
    JMenuItem save;
    JMenuItem importMap = new JMenuItem(Main.i18n("menu.map.importMap"));
    JMenuItem importMapFromBMP = new JMenuItem(Main.i18n("menu.map.importFromBMP"));
    JMenuItem bmpSizeCalculator = new JMenuItem(Main.i18n("menu.map.bmpSizeCalculator"));
    JMenuItem adjustSafety = new JMenuItem("Adjust Safety Level");
    JMenuItem addCustomMap = new JMenuItem(Main.i18n("menu.map.addCustom"));
    JMenuItem adjustZoom = new JMenuItem(Main.i18n("menu.map.changeZoom"));
    JMenuItem changeBuildingsInManyCities = new JMenuItem("Set Buildings in Many Cities at Once");
    JMenuItem polarWorldWrap = new JMenuItem(Main.i18n("menu.map.polarWrap"));
    JMenuItem redistributeGrassland = new JMenuItem(Main.i18n("menu.map.redistributeGrassland"));
    JMenuItem flipMap = new JMenuItem(Main.i18n("menu.map.flipMap"));
    JMenuItem mapStats = new JMenuItem("Map Statistics");
    JMenu mapClear = new JMenu("Clear");
    JMenuItem clearCities = new JMenuItem("Cities");
    JMenuItem clearUnits = new JMenuItem("Units");
    JMenuItem exportToCSV = new JMenuItem("Export to CSV");
    JMenuItem importFromCSV = new JMenuItem("Import from CSV");
    JMenuItem changeSettings = new JMenuItem(Main.i18n("menu.options.settings"));
    JMenuItem enableCustomRules = new JMenuItem("Enable Custom Rules");
    JMenuItem enableCustomPlayerData = new JMenuItem("Enable Custom Player Data");
    JMenuItem changeSpecialActions = new JMenuItem("Change special actions");
    JMenuItem viewHelp = new JMenuItem(Main.i18n("menu.help.view"));
    JMenuItem memoryInfo = new JMenuItem("View Memory Usage Info");
    JMenuItem benchmarkMap = new JMenuItem("Benchmark Map");
    JMenuItem about = new JMenuItem(Main.i18n("menu.help.about"));
    JMenu recent;
    JMenuItem[] recentFiles = new JMenuItem[5];
    Main main = null;
    JMenu savActions = new JMenu("SAV Actions");
    JMenuItem applyRuleChanges = new JMenuItem("Apply Rule Changes");
    JMenu histograph = new JMenu("Histograph");
    JMenuItem powerHistograph = new JMenuItem("Power");
    JMenuItem scoreHistograph = new JMenuItem("Score");
    JMenuItem cultureHistograph = new JMenuItem("Culture");
    EditMenu editMenu;
    private static AtomicInteger menusOpen = new AtomicInteger();
    static boolean editEnabled = false;

    public MenuSystem(Main container) {
        this.main = container;
        this.setupMenus();
    }

    private void setupMenus() {
        boolean mac = Main.os.name.toLowerCase().contains("mac");
        int CTRL_CMD_MASK = mac ? 4 : 2;
        JMenuBar menuBar = new JMenuBar();
        JMenu file = new JMenu(Main.i18n("menu.file"));
        JMenuItem createNew = new JMenuItem(Main.i18n("menu.file.new"));
        JMenuItem open = new JMenuItem(Main.i18n("menu.file.open"));
        JMenuItem inputSAV = new JMenuItem(Main.i18n("menu.file.inputFromSAV"));
        inputSAV.setToolTipText("Allows you to extract the BIQ rules from a SAV.  Useful for recovering lost BIQs.");
        JMenuItem openSAV = new JMenuItem(Main.i18n("menu.file.openSAV"));
        openSAV.setToolTipText("This is currently a development-only feature.  Only use where permitted by law.");
        this.save = new JMenuItem(Main.i18n("menu.file.save"));
        this.save.setEnabled(false);
        this.exportToCSV.setEnabled(false);
        this.importFromCSV.setEnabled(false);
        this.changeSpecialActions.setEnabled(false);
        this.enableCustomRules.setEnabled(false);
        this.enableCustomPlayerData.setEnabled(false);
        this.recent = new JMenu(Main.i18n.getString("menu.file.recent"));
        this.recent.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent e) {
                logger.info("Recent menu selected");
            }

            @Override
            public void menuDeselected(MenuEvent e) {
                logger.info("Recent menu deselected");
            }

            @Override
            public void menuCanceled(MenuEvent e) {
                logger.info("Recent menu canceled");
            }
        });
        file.add(createNew);
        file.add(open);
        file.add(inputSAV);
        file.add(openSAV);
        file.add(this.save);
        file.setMnemonic(70);
        createNew.setMnemonic(78);
        createNew.setAccelerator(KeyStroke.getKeyStroke(78, CTRL_CMD_MASK));
        open.setMnemonic(79);
        open.setAccelerator(KeyStroke.getKeyStroke(79, CTRL_CMD_MASK));
        inputSAV.setMnemonic(73);
        this.save.setMnemonic(83);
        this.save.setAccelerator(KeyStroke.getKeyStroke(83, CTRL_CMD_MASK));
        this.recent.setMnemonic(82);
        for (int i = 0; i < 5; ++i) {
            if (Settings.recentFiles[i] == null) continue;
            JMenuItem rf = new JMenuItem(Settings.recentFiles[i]);
            rf.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MenuSystem.this.main.openFile(e.getActionCommand());
                }
            });
            this.recentFiles[i] = rf;
            this.recent.add(rf);
        }
        file.add(this.recent);
        menuBar.add(file);
        this.editMenu = new EditMenu("Edit");
        if (editEnabled) {
            menuBar.add(this.editMenu);
        }
        this.mapMenu = new JMenu(Main.i18n.getString("menu.map"));
        this.mapMenu.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent e) {
                logger.info("Map menu selected");
            }

            @Override
            public void menuDeselected(MenuEvent e) {
                logger.info("Map menu deselected");
            }

            @Override
            public void menuCanceled(MenuEvent e) {
                logger.info("Map menu canceled");
            }
        });
        this.mapMenu.add(this.importMap);
        this.importMap.setMnemonic(73);
        this.mapMenu.add(this.importMapFromBMP);
        this.importMapFromBMP.setMnemonic(66);
        this.mapMenu.add(this.bmpSizeCalculator);
        this.bmpSizeCalculator.setMnemonic(83);
        this.mapMenu.add(this.addCustomMap);
        this.addCustomMap.setMnemonic(65);
        this.mapMenu.addSeparator();
        this.mapMenu.add(this.adjustZoom);
        this.adjustZoom.setMnemonic(90);
        this.adjustZoom.setAccelerator(KeyStroke.getKeyStroke(90, CTRL_CMD_MASK | 1));
        this.mapMenu.add(this.changeBuildingsInManyCities);
        this.changeBuildingsInManyCities.setMnemonic(67);
        this.mapMenu.add(this.polarWorldWrap);
        this.polarWorldWrap.setMnemonic(80);
        this.mapMenu.add(this.redistributeGrassland);
        this.redistributeGrassland.setMnemonic(71);
        this.mapMenu.add(this.flipMap);
        this.mapMenu.add(this.mapStats);
        this.flipMap.setMnemonic(70);
        this.mapClear.add(this.clearCities);
        this.mapClear.add(this.clearUnits);
        this.mapMenu.add(this.mapClear);
        this.mapMenu.setEnabled(false);
        this.mapMenu.setMnemonic(77);
        menuBar.add(this.mapMenu);
        JMenu options = new JMenu(Main.i18n.getString("menu.options"));
        options.add(this.adjustSafety);
        this.adjustSafety.setMnemonic(76);
        options.add(this.exportToCSV);
        this.exportToCSV.setMnemonic(67);
        options.add(this.importFromCSV);
        this.importFromCSV.setMnemonic(73);
        options.add(this.changeSettings);
        this.changeSettings.setMnemonic(83);
        this.changeSettings.setAccelerator(KeyStroke.getKeyStroke(80, CTRL_CMD_MASK));
        options.add(this.enableCustomRules);
        this.enableCustomRules.setMnemonic(82);
        this.enableCustomRules.setAccelerator(KeyStroke.getKeyStroke(82, CTRL_CMD_MASK));
        options.add(this.enableCustomPlayerData);
        this.enableCustomPlayerData.setMnemonic(80);
        this.enableCustomPlayerData.setAccelerator(KeyStroke.getKeyStroke(80, 1 | CTRL_CMD_MASK));
        options.setMnemonic(79);
        menuBar.add(options);
        this.applyRuleChanges.addActionListener(e -> Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    FXMLLoader fxmlLoader = new FXMLLoader();
                    fxmlLoader.setLocation(Main.class.getResource("/fxml/RuleChangeApplier.fxml"));
                    Parent root = (Parent)fxmlLoader.load();
                    RuleChangeApplierController controller = (RuleChangeApplierController)fxmlLoader.getController();
                    root.setVisible(true);
                    Stage stage = new Stage();
                    Scene scene = new Scene(root);
                    stage.setScene(scene);
                    stage.setTitle("Update Scenario Rules");
                    stage.getIcons().add((Object)Main.javaFXImage);
                    stage.show();
                }
                catch (IOException ex) {
                    logger.error("Error loading FXML for rule changes", ex);
                }
            }
        }));
        this.savActions.add(this.applyRuleChanges);
        this.powerHistograph.addActionListener(e -> Platform.runLater((Runnable)new HistographDataThread("Power", HistTurn::getPower)));
        this.scoreHistograph.addActionListener(e -> Platform.runLater((Runnable)new HistographDataThread("Score", HistTurn::getScore)));
        this.cultureHistograph.addActionListener(e -> Platform.runLater((Runnable)new HistographDataThread("Culture", HistTurn::getCulture)));
        this.histograph.add(this.powerHistograph);
        this.histograph.add(this.scoreHistograph);
        this.histograph.add(this.cultureHistograph);
        this.histograph.setEnabled(false);
        this.savActions.add(this.histograph);
        menuBar.add(this.savActions);
        JMenu help = new JMenu(Main.i18n.getString("menu.help"));
        help.add(this.viewHelp);
        this.viewHelp.setMnemonic(72);
        help.add(this.memoryInfo);
        this.memoryInfo.setMnemonic(77);
        help.add(this.benchmarkMap);
        this.benchmarkMap.setMnemonic(66);
        help.add(this.about);
        this.about.setMnemonic(65);
        help.setMnemonic(72);
        menuBar.add(help);
        createNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MenuSystem.this.main.createNewBIQ();
            }
        });
        open.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MenuSystem.this.main.open(evt);
            }
        });
        this.save.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MenuSystem.this.main.save(evt);
            }
        });
        inputSAV.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MenuSystem.this.main.inputBIQRulesFromSAV(evt);
            }
        });
        openSAV.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MenuSystem.this.main.openSAVFile(evt);
            }
        });
        this.main.setJMenuBar(menuBar);
        MenuListener statusChecker = new MenuListener(){

            @Override
            public void menuSelected(MenuEvent e) {
                menusOpen.incrementAndGet();
            }

            @Override
            public void menuDeselected(MenuEvent e) {
                menusOpen.decrementAndGet();
            }

            @Override
            public void menuCanceled(MenuEvent e) {
            }
        };
        file.addMenuListener(statusChecker);
        this.mapMenu.addMenuListener(statusChecker);
        options.addMenuListener(statusChecker);
        help.addMenuListener(statusChecker);
    }

    public static boolean hasMenuOpen() {
        return menusOpen.get() > 0;
    }

    public void setupDelayedActions() {
        this.importMap.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MenuSystem.this.main.cmdImportMapActionPerformed(evt);
            }
        });
        this.importMapFromBMP.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MenuSystem.this.main.importMapFromBMP();
            }
        });
        this.bmpSizeCalculator.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MenuSystem.this.main.showBMPSizeCalculator();
            }
        });
        this.adjustSafety.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MenuSystem.this.main.cmdSafetyLevelActionPerformed(evt);
            }
        });
        this.exportToCSV.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MenuSystem.this.main.cmdExportToCSVActionPerformed(evt);
            }
        });
        this.importFromCSV.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MenuSystem.this.main.cmdImportFromCSVActionPerformed(evt);
            }
        });
        this.changeSettings.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MenuSystem.this.main.openSettingsWindow(evt);
            }
        });
        this.addCustomMap.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MenuSystem.this.main.enableCustomMap(evt);
            }
        });
        this.adjustZoom.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MenuSystem.this.main.changeZoomPercentage(evt);
            }
        });
        this.changeBuildingsInManyCities.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                frmBuildingsInCities bldgForm = new frmBuildingsInCities(Main.biqFile.get(Main.biqIndex));
                bldgForm.setLocationRelativeTo(Main.mainMain);
                bldgForm.setVisible(true);
            }
        });
        this.polarWorldWrap.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MenuSystem.this.main.showPolarOptions(evt);
            }
        });
        this.redistributeGrassland.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MenuSystem.this.main.showRedistributeGrassland();
            }
        });
        this.flipMap.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MapFlipper.flip(Main.biqFile.get(Main.biqIndex));
            }
        });
        this.mapStats.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String stats = MapStats.calculateMapStats(Main.biqFile.get(Main.biqIndex));
                JOptionPane.showMessageDialog(null, stats);
            }
        });
        this.clearCities.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int confirmation = JOptionPane.showConfirmDialog(null, "This will clear all cities from the map.  Do you really wish to do this?.", "Clear All Cities", 0);
                if (confirmation == 0) {
                    MenuSystem.this.main.clearAllCities();
                }
            }
        });
        this.clearUnits.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int confirmation = JOptionPane.showConfirmDialog(null, "This will clear all units from the map.  Do you really wish to do this?.", "Clear All Units", 0);
                if (confirmation == 0) {
                    MenuSystem.this.main.clearAllUnits();
                }
            }
        });
        this.memoryInfo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                long maxAllocatable = Runtime.getRuntime().maxMemory();
                long allocatedToJVM = Runtime.getRuntime().totalMemory();
                long allocatedButFree = Runtime.getRuntime().freeMemory();
                long inUse = (allocatedToJVM - allocatedButFree) / 1024L;
                long max = maxAllocatable / 1024L;
                long allocated = allocatedToJVM / 1024L;
                allocatedButFree /= 1024L;
                double percent = (double)inUse * 100.0 / (double)max;
                String unit = " KB";
                if (inUse > 16384L) {
                    inUse /= 1024L;
                    max /= 1024L;
                    allocated /= 1024L;
                    allocatedButFree /= 1024L;
                    unit = " MB";
                }
                JOptionPane.showMessageDialog(null, "<html>Current memory usage:<br><br>" + inUse + unit + " is currently being used.<br>" + max + unit + " is the maximum the program can use.<br>" + String.format("%1.1f", percent) + "% of the maximum memory is in use.<br><br>" + allocated + unit + " of your system memory is allocated to Java.<br>" + allocatedButFree + unit + " of the above is free, giving the current memory usage.</html>", "Memory Usage", 1);
            }
        });
        this.benchmarkMap.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JOptionPane.showMessageDialog(null, "<html>The program will now benchmark the map.  It will be unresponsive for 10 seconds while doing so.<br/>Then it will report the average FPS, when rendering full tilt.<br/>This is equivalent to how fast it renders when you are scrolling constantly.<br/>Due to optimizations, the map usually spends most of its time sleeping.");
                Main.pnlTabs.mapTab.map.benchmark();
            }
        });
        this.enableCustomRules.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Main.addCustomRules();
                MenuSystem.this.enableCustomRules.setEnabled(false);
            }
        });
        this.enableCustomPlayerData.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Main.addCustomPlayerData();
                MenuSystem.this.enableCustomPlayerData.setEnabled(false);
            }
        });
    }

    void enablePostOpenMenus(IO biq) {
        this.save.setEnabled(true);
        this.exportToCSV.setEnabled(true);
        this.importFromCSV.setEnabled(true);
        this.changeSpecialActions.setEnabled(true);
        this.mapMenu.setEnabled(true);
        this.enableCustomRules.setEnabled(!biq.hasCustomRules());
        this.enableCustomPlayerData.setEnabled(!biq.hasCustomPlayerData());
    }

    void enableSavMenus() {
        this.histograph.setEnabled(true);
    }

    void enableMapEditingOptions() {
        this.adjustZoom.setEnabled(true);
        this.polarWorldWrap.setEnabled(true);
        this.redistributeGrassland.setEnabled(true);
        this.flipMap.setEnabled(true);
        this.changeBuildingsInManyCities.setEnabled(true);
        this.mapStats.setEnabled(true);
    }

    void disableMapEditingOptions() {
        this.adjustZoom.setEnabled(false);
        this.polarWorldWrap.setEnabled(false);
        this.redistributeGrassland.setEnabled(false);
        this.flipMap.setEnabled(false);
        this.changeBuildingsInManyCities.setEnabled(false);
        this.mapStats.setEnabled(false);
    }

    void updateRecentFiles(String newBIQName, int max) {
        int i;
        this.recent.removeAll();
        for (i = max - 1; i > 0; --i) {
            this.recentFiles[i] = this.recentFiles[i - 1];
        }
        this.recentFiles[0] = new JMenuItem(newBIQName);
        this.recentFiles[0].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MenuSystem.this.main.openFile(e.getActionCommand());
            }
        });
        for (i = 0; i < 5; ++i) {
            if (this.recentFiles[i] == null) continue;
            this.recent.add(this.recentFiles[i]);
        }
    }

    public JMenuItem getHelp() {
        return this.viewHelp;
    }

    public JMenuItem getAbout() {
        return this.about;
    }

    public JMenuItem getSpecialActions() {
        return this.changeSpecialActions;
    }

    class HistographDataThread
    extends Thread {
        BiFunction<HistTurn, Integer, Integer> histographExtractorFunction;
        String label;

        public HistographDataThread(String label, BiFunction<HistTurn, Integer, Integer> histographExtractorFunction) {
            this.histographExtractorFunction = histographExtractorFunction;
            this.label = label;
        }

        @Override
        public void run() {
            try {
                Stage stage = new Stage();
                SAV sav = Main.currentSAV;
                int numPlayers = sav.getGameData().getNumPlayers();
                ArrayList<String> players = new ArrayList<String>();
                ArrayList<Color> colors = new ArrayList<Color>();
                for (int i = 1; i <= numPlayers; ++i) {
                    int civIndex = sav.players[i].getRaceID();
                    int color = sav.players[i].getColor();
                    colors.add(Main.mainMain.colors[color]);
                    if (civIndex <= -1) continue;
                    String civName = sav.getEmbeddedRules().getEmbeddedRules().civilization.get(civIndex).getName();
                    players.add(civName);
                }
                CustomHistograph histograph = new CustomHistograph();
                ArrayList<List<Integer>> allScores = new ArrayList<List<Integer>>();
                for (int i = 1; i <= numPlayers; ++i) {
                    allScores.add(sav.histograph.getHistographScoresForPlayer(i, this.histographExtractorFunction));
                }
                histograph.sendData(this.label, allScores, players, colors);
                histograph.start(stage);
            }
            catch (Exception ex) {
                logger.error("Failed to start histograph", ex);
            }
        }
    }
}

