/*
 * Decompiled with CFR 0.152.
 */
package com.civfanatics.civ3.xplatformeditor;

import com.civfanatics.civ3.biqFile.util.LittleEndianDataInputStream;
import com.civfanatics.civ3.biqFile.util.LittleEndianDataOutputStream;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;

public class OldPCXFilter {
    static final boolean printPalette = false;
    static final boolean printBitmap = false;
    boolean civ3TransparencyEnabled = true;
    BufferedImage thisBufferedImage;
    Boolean[] rowEnds;
    static Logger logger = Logger.getLogger("pcxFilter");
    String newline = "\n";
    boolean printDiagnostics = false;
    File pcxFile;
    byte[] buffer;
    public List<Short> transparents;
    byte manufacturer;
    byte version;
    byte encoding;
    byte bitsPerPixel;
    short xmin;
    short ymin;
    short xmax;
    short ymax;
    short horizontalResolution;
    short verticalResolution;
    byte[] EGA_Colormap = new byte[48];
    byte reserved;
    byte numColorPlanes;
    short bytesPerLine;
    short paletteInfo;
    short hScreenSize;
    short vScreenSize;
    short xsize;
    short ysize;
    Bitmap bitmap;
    public Palette256 palette;

    public OldPCXFilter(String string) {
        this.pcxFile = new File(string);
        this.transparents = new ArrayList<Short>();
    }

    public void readFile() {
        FilterInputStream inFile = null;
        try {
            inFile = new LittleEndianDataInputStream(new BufferedInputStream(new FileInputStream(this.pcxFile)));
            this.buffer = new byte[(int)this.pcxFile.length()];
            ((LittleEndianDataInputStream)inFile).readFully(this.buffer);
        }
        catch (IOException e) {
            logger.error(e);
        }
        finally {
            try {
                inFile.close();
            }
            catch (IOException e) {
                logger.error(e);
            }
        }
    }

    public void parse() {
        LittleEndianDataInputStream in = new LittleEndianDataInputStream(new ByteArrayInputStream(this.buffer));
        try {
            this.manufacturer = in.readByte();
            this.version = in.readByte();
            this.encoding = in.readByte();
            this.bitsPerPixel = in.readByte();
            this.xmin = in.readShort();
            this.ymin = in.readShort();
            this.xmax = in.readShort();
            this.ymax = in.readShort();
            this.xsize = (short)(this.uminus(this.xmax, this.xmin) + 1);
            this.ysize = (short)(this.uminus(this.ymax, this.ymin) + 1);
            this.horizontalResolution = in.readShort();
            this.verticalResolution = in.readShort();
            in.read(this.EGA_Colormap, 0, 48);
            this.reserved = in.readByte();
            this.numColorPlanes = in.readByte();
            this.bytesPerLine = in.readShort();
            this.paletteInfo = in.readShort();
            this.hScreenSize = in.readShort();
            this.vScreenSize = in.readShort();
            if (this.printDiagnostics) {
                logger.info("manufacturer: " + this.manufacturer);
                logger.info("version: " + this.version);
                logger.info("encoding: " + this.encoding);
                logger.info("bits per pixel: " + this.bitsPerPixel);
                logger.info("xmin: " + this.xmin);
                logger.info("ymin: " + this.ymin);
                logger.info("xmax: " + this.xmax);
                logger.info("ymax: " + this.ymax);
                logger.info("xsize: " + this.xsize);
                logger.info("ysize: " + this.ysize);
            }
            in.skip(54L);
            in.mark(this.buffer.length);
            if (this.version == 5) {
                in.skip(this.buffer.length - 128 - 769);
                byte check = in.readByte();
                if (check == 12) {
                    this.palette = new Palette256();
                    for (int i = 0; i < 256; ++i) {
                        byte red = in.readByte();
                        byte green = in.readByte();
                        byte blue = in.readByte();
                        this.palette.addColor(red, green, blue);
                    }
                } else {
                    logger.error("Incorrect byte prior to expected 256 color palette");
                    logger.error("Byte is " + OldPCXFilter.toString(check));
                    logger.error("Jumped " + (this.buffer.length - 128 - 769) + " bytes after header");
                }
                in.reset();
                int pixelCount = 0;
                int numPixelsFromRepeats = 0;
                this.bitmap = new Bitmap(this.bytesPerLine, this.ysize);
                this.rowEnds = new Boolean[this.ysize];
                while (pixelCount < this.bytesPerLine * this.ysize) {
                    byte temp = in.readByte();
                    int stemp = temp & 0xFF;
                    if (stemp >= 192) {
                        int repeats = stemp & 0x3F;
                        if (logger.isTraceEnabled()) {
                            logger.trace("Processed " + pixelCount + " pixels.");
                            logger.trace("To repeat " + repeats + " times.");
                        }
                        byte color = in.readByte();
                        repeats = this.bitmap.addRepeats(repeats, this.palette.getColor(color), color);
                        pixelCount += repeats;
                        numPixelsFromRepeats += repeats;
                    } else {
                        this.bitmap.add(this.palette.getColor(temp), temp);
                        ++pixelCount;
                    }
                    if (pixelCount % this.bytesPerLine == 0) {
                        this.rowEnds[pixelCount / this.bytesPerLine - 1] = true;
                    }
                    if (!logger.isTraceEnabled()) continue;
                    logger.trace("Processed " + pixelCount + " pixels.");
                }
                if (this.printDiagnostics) {
                    logger.info("Processed " + pixelCount + " pixels");
                    logger.info(numPixelsFromRepeats + " pixels were from repeats");
                }
                if (logger.isDebugEnabled()) {
                    for (int i = 0; i < this.rowEnds.length; ++i) {
                        logger.info(i + ": " + this.rowEnds[i]);
                    }
                }
                if (logger.isDebugEnabled()) {
                    logger.debug(this.toString());
                }
            }
        }
        catch (IOException e) {
            logger.error("Error caught: ", e);
        }
    }

    public void exportPCX(String filename) {
        File file = new File(filename);
        try {
            int i;
            LittleEndianDataOutputStream dos = new LittleEndianDataOutputStream(new FileOutputStream(file));
            dos.writeByte(this.manufacturer);
            dos.writeByte(this.version);
            dos.writeByte(this.encoding);
            dos.writeByte(this.bitsPerPixel);
            dos.writeShort(this.xmin);
            dos.writeShort(this.ymin);
            dos.writeShort(this.xmax);
            dos.writeShort(this.ymax);
            dos.writeShort(this.horizontalResolution);
            dos.writeShort(this.verticalResolution);
            dos.write(this.EGA_Colormap, 0, 48);
            dos.writeByte(this.reserved);
            dos.writeByte(this.numColorPlanes);
            dos.writeShort(this.bytesPerLine);
            dos.writeShort(this.paletteInfo);
            dos.writeShort(this.hScreenSize);
            dos.writeShort(this.vScreenSize);
            for (i = 0; i < 54; ++i) {
                dos.writeByte(0);
            }
            for (int y = 0; y < this.ysize; ++y) {
                for (int x = 0; x < this.xsize; ++x) {
                    int color = this.bitmap.colorInts.get(this.bitmap.xsize * y + x);
                    int repeats = 0;
                    boolean repeat = false;
                    do {
                        int newColor;
                        if ((newColor = this.bitmap.colorInts.get(this.bitmap.xsize * y + x + repeats + 1).intValue()) != color) continue;
                        repeats = (short)(repeats + 1);
                        repeat = true;
                    } while (repeat && repeats < 192);
                    if (repeat) continue;
                    dos.writeByte(this.bitmap.colorInts.get(this.bitmap.xsize * y + x));
                }
                if (this.xsize % 1 != 0) continue;
                dos.writeByte(193);
                dos.writeByte(255);
            }
            dos.writeByte(12);
            for (i = 0; i < this.palette.paletteSize; ++i) {
                dos.writeByte(this.palette.palette[i].getRed());
                dos.writeByte(this.palette.palette[i].getGreen());
                dos.writeByte(this.palette.palette[i].getBlue());
            }
            dos.close();
        }
        catch (FileNotFoundException e) {
            logger.error("File not found", e);
        }
        catch (IOException e) {
            logger.error("IOException", e);
        }
    }

    public void createBufferedImage() {
        this.thisBufferedImage = new BufferedImage(this.xsize, this.ysize, 2);
        int[] rgbArray = new int[this.xsize * this.ysize];
        for (int y = 0; y < this.ysize; ++y) {
            for (int x = 0; x < this.xsize; ++x) {
                rgbArray[y * this.xsize + x] = this.bitmap.getPixelRGB(x, y);
            }
        }
        this.thisBufferedImage.setRGB(0, 0, this.xsize, this.ysize, rgbArray, 0, this.xsize);
    }

    public BufferedImage getSubimage(int xStart, int yStart, int width, int height) {
        BufferedImage subimage = new BufferedImage(width, height, 2);
        int[] rgbArray = new int[width * height];
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                rgbArray[y * width + x] = this.bitmap.getPixelRGB(x + xStart, y + yStart);
            }
        }
        subimage.setRGB(0, 0, width, height, rgbArray, 0, width);
        return subimage;
    }

    public BufferedImage getBufferedImage() {
        return this.thisBufferedImage;
    }

    public String toString() {
        StringBuilder toStr = new StringBuilder(1000);
        toStr.append("Manufacturer: " + OldPCXFilter.toString(this.manufacturer) + this.newline);
        toStr.append("Version: " + OldPCXFilter.toString(this.version) + this.newline);
        toStr.append("Encoding: " + OldPCXFilter.toString(this.encoding) + this.newline);
        toStr.append("BitsPerPixel: " + OldPCXFilter.toString(this.bitsPerPixel) + this.newline);
        toStr.append("Xmin: " + OldPCXFilter.toString(this.xmin) + this.newline);
        toStr.append("Ymin: " + OldPCXFilter.toString(this.ymin) + this.newline);
        toStr.append("Xmax: " + OldPCXFilter.toString(this.xmax) + this.newline);
        toStr.append("Ymax: " + OldPCXFilter.toString(this.ymax) + this.newline);
        toStr.append("XSize: " + OldPCXFilter.toString(this.xsize) + this.newline);
        toStr.append("YSize: " + OldPCXFilter.toString(this.ysize) + this.newline);
        toStr.append("horizontalResolution: " + OldPCXFilter.toString(this.horizontalResolution) + this.newline);
        toStr.append("verticalResolution: " + OldPCXFilter.toString(this.verticalResolution) + this.newline);
        toStr.append("numColorPlanes: " + OldPCXFilter.toString(this.numColorPlanes) + this.newline);
        toStr.append("bytesPerScanLine: " + OldPCXFilter.toString(this.bytesPerLine) + this.newline);
        toStr.append("paletteInfo: " + OldPCXFilter.toString(this.paletteInfo) + this.newline);
        toStr.append("hScreenSize: " + OldPCXFilter.toString(this.hScreenSize) + this.newline);
        toStr.append("vScreenSize: " + OldPCXFilter.toString(this.vScreenSize) + this.newline);
        return toStr.toString();
    }

    private int uminus(int one, int two) {
        if (two > one) {
            return 0;
        }
        long oneI = 0xFFFFFFFFL & (long)one;
        long twoI = 0xFFFFFFFFL & (long)two;
        long aI = oneI - twoI;
        int toReturn = aI > Integer.MAX_VALUE ? (int)(aI - 0x100000000L) : (int)aI;
        return toReturn;
    }

    private short uminus(short one, short two) {
        if (two > one) {
            return 0;
        }
        int oneI = one & 0xFFFF;
        int twoI = two & 0xFFFF;
        int aI = oneI - twoI;
        short toReturn = aI > Short.MAX_VALUE ? (short)(aI - 65536) : (short)aI;
        return toReturn;
    }

    private byte uminus(byte one, byte two) {
        if (two > one) {
            return 0;
        }
        int oneI = one & 0xFF;
        int twoI = two & 0xFF;
        int aI = oneI - twoI;
        byte toReturn = aI > 127 ? (byte)(aI - 256) : (byte)aI;
        return toReturn;
    }

    private static String toString(int uint) {
        if (uint >= 0) {
            return Integer.toString(uint);
        }
        return Long.toString((long)uint + 0x100000000L);
    }

    private static String toString(short ushort) {
        if (ushort >= 0) {
            return Short.toString(ushort);
        }
        return Integer.toString(ushort + 65536);
    }

    private static String toString(byte ubyte) {
        if (ubyte >= 0) {
            return Byte.toString(ubyte);
        }
        return Short.toString((short)(ubyte + 256));
    }

    public static class Bitmap {
        Color[][] map;
        List<Integer> colorInts = new LinkedList<Integer>();
        int xsize;
        int ysize;
        int xindex;
        int yindex;

        public Bitmap(int xsize, int ysize) {
            this.xsize = xsize;
            this.ysize = ysize;
            this.xindex = 0;
            this.yindex = 0;
            if (logger.isDebugEnabled()) {
                logger.debug("New bitmap with size " + xsize + " by " + ysize);
            }
            this.map = new Color[xsize][ysize];
        }

        public void add(Color color, int index) {
            this.map[this.xindex][this.yindex] = color;
            this.colorInts.add(index);
            ++this.xindex;
            if (this.xindex >= this.xsize) {
                this.xindex = 0;
                ++this.yindex;
            }
        }

        public int addRepeats(int repeats, Color color, int index) {
            int count = 0;
            for (int i = 0; i < repeats; ++i) {
                this.map[this.xindex][this.yindex] = color;
                ++this.xindex;
                if (this.xindex >= this.xsize) {
                    this.xindex = 0;
                    ++this.yindex;
                }
                this.colorInts.add(index);
                ++count;
            }
            return count;
        }

        public String toString() {
            StringBuilder str = new StringBuilder();
            for (int i = 0; i < this.xsize; ++i) {
                str.append("[");
                for (int j = 0; j < this.ysize; ++j) {
                    str.append("[");
                    str.append(this.map[i][j].toString());
                    str.append("]");
                }
                str.append("]\n");
            }
            return str.toString();
        }

        public Color[][] getMap() {
            return this.map;
        }

        public Color getPixel(int x, int y) {
            return this.map[x][y];
        }

        public int getPixelRGB(int x, int y) {
            return this.map[x][y].getRGB();
        }
    }

    public class Palette256 {
        public Color[] palette = new Color[256];
        short paletteSize = 0;

        public boolean addColor(byte red, byte green, byte blue) {
            int sBlue;
            if (this.paletteSize >= 256) {
                return false;
            }
            int sRed = red < 0 ? red + 256 : red;
            int sGreen = green < 0 ? green + 256 : green;
            int n = sBlue = blue < 0 ? blue + 256 : blue;
            if (logger.isTraceEnabled()) {
                logger.trace("sRed: " + sRed + " sGreen: " + sGreen + " sBlue: " + sBlue);
            }
            if (OldPCXFilter.this.civ3TransparencyEnabled && (this.paletteSize == 254 || this.paletteSize == 255) || OldPCXFilter.this.transparents.contains(this.paletteSize)) {
                if (logger.isDebugEnabled()) {
                    logger.debug("color " + this.paletteSize + " is transparent");
                }
                this.palette[this.paletteSize] = new Color(sRed, sGreen, sBlue, 0);
                this.paletteSize = (short)(this.paletteSize + 1);
                return true;
            }
            this.palette[this.paletteSize] = new Color(sRed, sGreen, sBlue);
            this.paletteSize = (short)(this.paletteSize + 1);
            return true;
        }

        public boolean makeTransparent(int index) {
            Color newColor;
            if (index > 255) {
                return false;
            }
            Color currentColor = this.palette[index];
            this.palette[index] = newColor = new Color(currentColor.getRed(), currentColor.getGreen(), currentColor.getBlue(), 0);
            return true;
        }

        public void setColor(int index, Color color) {
            Color oldColor = this.palette[index];
            this.palette[index] = color;
            for (int x = 0; x < OldPCXFilter.this.bitmap.xsize; ++x) {
                for (int y = 0; y < OldPCXFilter.this.bitmap.ysize; ++y) {
                    if (!OldPCXFilter.this.bitmap.map[x][y].equals(oldColor)) continue;
                    OldPCXFilter.this.bitmap.map[x][y] = color;
                }
            }
        }

        public Color getColor(byte index) {
            int sIndex = index & 0xFF;
            return this.palette[sIndex];
        }

        public String toString() {
            StringBuilder toRtn = new StringBuilder();
            for (int i = 0; i < this.paletteSize; ++i) {
                toRtn.append(this.palette[i].toString() + OldPCXFilter.this.newline);
            }
            return toRtn.toString();
        }
    }
}

