/*
 * Decompiled with CFR 0.152.
 */
package com.civfanatics.civ3.xplatformeditor;

import com.civfanatics.civ3.xplatformeditor.imageSupport.Civ3PCXFilter;
import java.awt.Color;
import java.awt.image.BufferedImage;
import org.apache.log4j.Logger;

public class PCXImportThread
extends Thread {
    String fileName = "";
    boolean keepPCX = false;
    BufferedImage buffered = null;
    Civ3PCXFilter pcx = null;
    static Logger logger = Logger.getLogger("PCX Import Thread");

    public PCXImportThread(String fileName) {
        this.fileName = fileName;
    }

    public PCXImportThread(String fileName, boolean keepPCX) {
        this.fileName = fileName;
        this.keepPCX = true;
    }

    @Override
    public void run() {
        try {
            this.importPCX();
        }
        catch (NullPointerException ex) {
            logger.info("NPE with file " + this.fileName, ex);
        }
        catch (OutOfMemoryError ex) {
            logger.info("Out of memory with file " + this.fileName, ex);
        }
    }

    private void importPCX() {
        this.pcx = new Civ3PCXFilter(this.fileName);
        this.pcx.readFile();
        this.pcx.parse();
        this.pcx.createBufferedImage();
        this.buffered = this.pcx.getBufferedImage();
        if (!this.keepPCX) {
            this.pcx = null;
        }
    }

    public BufferedImage getBufferedImage() {
        return this.buffered;
    }

    public void setColor(int index, Color c) {
        if (this.keepPCX) {
            this.pcx.setColor(index, c);
            this.pcx.createBufferedImage();
            this.buffered = this.pcx.getBufferedImage();
        } else {
            logger.error("Cannot set color on " + this.fileName + " as raw PCX data was not kept");
        }
    }
}

