/*
 * Decompiled with CFR 0.152.
 */
package com.civfanatics.civ3.xplatformeditor;

import com.civfanatics.civ3.xplatformeditor.Main;
import com.civfanatics.civ3.xplatformeditor.ReadOnlyException;
import com.civfanatics.civ3.xplatformeditor.specialty.SafetyLevel;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.util.NoSuchElementException;
import java.util.Scanner;
import java.util.StringTokenizer;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class Settings {
    String openDir = "";
    public String bmpDir = "";
    public String civInstallDir = "";
    String numProcs = "0";
    String debugLevel = "info";
    String firstRun = "true";
    public boolean noConfigFileAtStart = false;
    public boolean woodlandsEnabled = true;
    public boolean hillsEnabled = true;
    public boolean marshEnabled = true;
    public boolean irrigationEnabled = true;
    public boolean minesEnabled = true;
    public boolean fortificationsEnabled = true;
    public boolean roadsEnabled = true;
    public boolean resourcesEnabled = true;
    public boolean citiesEnabled = true;
    public boolean unitsEnabled = true;
    public boolean colonialBuildingsEnabled = true;
    public boolean riversEnabled = true;
    public boolean pollutionEnabled = true;
    public boolean bordersEnabled = true;
    public boolean barbarianCampsEnabled = true;
    public boolean goodyHutsEnabled = true;
    public boolean cratersEnabled = true;
    public boolean ruinsEnabled = true;
    public boolean vplsEnabled = true;
    public boolean cityNamesEnabled = true;
    public boolean gridEnabled = false;
    public boolean showFog = false;
    int zoomQuality = 1;
    int drawReps = 5;
    boolean validateInfiniteUnitUpgrade = true;
    boolean validatePhantomResourceBug = true;
    int nextAutosave = 0;
    int maxAutosaves = 10;
    long autoSaveInterval = 240L;
    boolean autoArchive = false;
    String fontChoice = "Tahoma";
    boolean confirmQuit = true;
    static Logger logger = Logger.getLogger("Settings");
    static boolean horizontalScrolling = false;
    public static boolean showFoodAndShields = false;
    public String biqLanguage = "English";
    String editorLanguage = "English";
    public static String[] recentFiles = new String[5];
    int fontSize = 12;
    String lookAndFeel = "Metal";
    int height = 768;
    int width = 1030;
    public int riverProximityMax = 10;
    public int riverCornerRadius = 14;
    boolean useSwing = false;
    boolean useJavaFX = true;
    boolean forceSwing = false;
    boolean forceSwingDueToJavaBug = false;
    public boolean checkForUpdates = true;
    public String suppressedUpdateVersion = "";
    public String decompressionMethod = "7z x [filename] -y -o";
    public boolean sevenZipVerified = false;

    public void exportConfigFile() throws ReadOnlyException {
        File config = new File("civ3editor.ini");
        if (!config.exists()) {
            try {
                config.createNewFile();
            }
            catch (IOException e) {
                logger.error("Could not create file for export - check disk space");
            }
        }
        if (config.exists()) {
            if (!config.canWrite()) {
                logger.warn("Config file is read-only");
                throw new ReadOnlyException("civ3editor.ini is read-only");
            }
            FileWriter out = null;
            try {
                out = new FileWriter(config);
                out.write("openDir=" + this.openDir + Main.newline);
                out.write("civInstallDir=" + this.civInstallDir + Main.newline);
                out.write("bmpDir=" + this.bmpDir + Main.newline);
                out.write("debugLevel=" + this.debugLevel + Main.newline);
                out.write("numProcs=" + this.numProcs + Main.newline);
                out.write("firstRun=" + this.firstRun + Main.newline);
                out.write("nextAutosave=" + String.valueOf(this.nextAutosave) + Main.newline);
                out.write("maxAutosaves=" + String.valueOf(this.maxAutosaves) + Main.newline);
                out.write("autoSaveInterval=" + String.valueOf(this.autoSaveInterval) + Main.newline);
                out.write("autoArchive=" + String.valueOf(this.autoArchive) + Main.newline);
                out.write("fontChoice=" + this.fontChoice + Main.newline);
                out.write("confirmQuit=" + String.valueOf(this.confirmQuit) + Main.newline);
                out.write("graphicsEnabled=" + Boolean.toString(Main.GRAPHICS_ENABLED) + Main.newline);
                out.write("horizontalScrolling=" + Boolean.toString(horizontalScrolling) + Main.newline);
                out.write("biqLanguage=" + this.biqLanguage + Main.newline);
                out.write("editorLanguage=" + this.editorLanguage + Main.newline);
                out.write("validateInfiniteUnitUpgrade=" + Boolean.toString(this.validateInfiniteUnitUpgrade) + Main.newline);
                out.write("validatePhantomResourceBug=" + Boolean.toString(this.validatePhantomResourceBug) + Main.newline);
                String zoomStr = "";
                if (this.zoomQuality == 1) {
                    zoomStr = "balanced";
                } else if (this.zoomQuality == 2) {
                    zoomStr = "quick";
                } else if (this.zoomQuality == 4) {
                    zoomStr = "quality";
                }
                out.write("zoomQuality=" + zoomStr + Main.newline);
                for (int i = 0; i < 5; ++i) {
                    if (recentFiles[i] == null) continue;
                    out.write("recent" + i + "=" + recentFiles[i] + Main.newline);
                }
                out.write("fontSize=" + this.fontSize + Main.newline);
                out.write("lookAndFeel=" + this.lookAndFeel + Main.newline);
                out.write("width=" + this.width + Main.newline);
                out.write("height=" + this.height + Main.newline);
                out.write("riverProximity=" + this.riverProximityMax + Main.newline);
                out.write("riverCornerRadius=" + this.riverCornerRadius + Main.newline);
                out.write("useSwing=" + Boolean.toString(this.useSwing) + Main.newline);
                out.write("checkForUpdates=" + Boolean.toString(this.checkForUpdates) + Main.newline);
                out.write("suppressedUpdateVersion=" + this.suppressedUpdateVersion + Main.newline);
                out.write("safetyBLDG=" + Main.safetyLevels.get("BLDG").toString() + Main.newline);
                out.write("safetyCTZN=" + Main.safetyLevels.get("CTZN").toString() + Main.newline);
                out.write("safetyCULT=" + Main.safetyLevels.get("CULT").toString() + Main.newline);
                out.write("safetyDIFF=" + Main.safetyLevels.get("DIFF").toString() + Main.newline);
                out.write("safetyERA=" + Main.safetyLevels.get("ERA").toString() + Main.newline);
                out.write("safetyESPN=" + Main.safetyLevels.get("ESPN").toString() + Main.newline);
                out.write("safetyEXPR=" + Main.safetyLevels.get("EXPR").toString() + Main.newline);
                out.write("safetyFLAV=" + Main.safetyLevels.get("FLAV").toString() + Main.newline);
                out.write("safetyGOOD=" + Main.safetyLevels.get("GOOD").toString() + Main.newline);
                out.write("safetyGOVT=" + Main.safetyLevels.get("GOVT").toString() + Main.newline);
                out.write("safetyPLYR=" + Main.safetyLevels.get("PLYR").toString() + Main.newline);
                out.write("safetyRULE=" + Main.safetyLevels.get("RULE").toString() + Main.newline);
                out.write("safetyPRTO=" + Main.safetyLevels.get("PRTO").toString() + Main.newline);
                out.write("safetyTECH=" + Main.safetyLevels.get("TECH").toString() + Main.newline);
                out.write("safetyTERR=" + Main.safetyLevels.get("TERR").toString() + Main.newline);
                out.write("safetyTRFM=" + Main.safetyLevels.get("TRFM").toString() + Main.newline);
                out.write("safetyWSIZ=" + Main.safetyLevels.get("WSIZ").toString() + Main.newline);
                out.write("safetyRACE=" + Main.safetyLevels.get("RACE").toString() + Main.newline);
                out.write("safetyPROP=" + Main.safetyLevels.get("PROP").toString() + Main.newline);
                out.write("decompressionMethod=" + this.decompressionMethod + Main.newline);
                out.write("sevenZipVerified=" + Boolean.toString(this.sevenZipVerified) + Main.newline);
            }
            catch (IOException e) {
                logger.error("Error exporting config file", e);
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    logger.error("Failed to close config file output", e);
                }
            }
        }
    }

    public void importConfigFile(File config) {
        Scanner in = null;
        try {
            in = new Scanner(config);
        }
        catch (FileNotFoundException e) {
            logger.error("Config file not found", e);
        }
        while (in.hasNextLine()) {
            String nextLine = in.nextLine();
            StringTokenizer tokenizer = new StringTokenizer(nextLine, "=\n");
            String ident = tokenizer.nextToken();
            String value = "";
            try {
                value = tokenizer.nextToken();
            }
            catch (NoSuchElementException e) {
                logger.warn("Missing value for key " + ident + " in config file.");
            }
            if (logger.isDebugEnabled()) {
                logger.debug("ident: " + ident);
                logger.debug("value: " + value);
            }
            if (ident.equals("openDir")) {
                this.openDir = value;
                continue;
            }
            if (ident.equals("civInstallDir")) {
                this.civInstallDir = value;
                continue;
            }
            if (ident.equals("bmpDir")) {
                this.bmpDir = value;
                continue;
            }
            if (ident.equals("firstRun")) {
                this.firstRun = value;
                continue;
            }
            if (ident.equals("debugLevel")) {
                if (value.equals("trace")) {
                    logger.getRootLogger().setLevel(Level.TRACE);
                }
                if (value.equals("debug")) {
                    logger.getRootLogger().setLevel(Level.DEBUG);
                } else if (value.equals("info")) {
                    logger.getRootLogger().setLevel(Level.INFO);
                } else if (value.equals("warn")) {
                    logger.getRootLogger().setLevel(Level.WARN);
                } else if (value.equals("error")) {
                    logger.getRootLogger().setLevel(Level.ERROR);
                }
                this.debugLevel = value;
                continue;
            }
            if (ident.equals("numProcs")) {
                try {
                    this.numProcs = value;
                }
                catch (NumberFormatException e) {
                    this.numProcs = "0";
                }
                continue;
            }
            if (ident.equals("autoSaveInterval")) {
                try {
                    this.autoSaveInterval = Long.parseLong(value);
                }
                catch (NumberFormatException e) {
                    this.autoSaveInterval = 240L;
                }
                continue;
            }
            if (ident.equals("maxAutosaves")) {
                try {
                    this.maxAutosaves = Integer.parseInt(value);
                }
                catch (NumberFormatException e) {
                    this.maxAutosaves = 10;
                }
                continue;
            }
            if (ident.equals("nextAutosave")) {
                try {
                    this.nextAutosave = Integer.parseInt(value);
                }
                catch (NumberFormatException e) {
                    this.nextAutosave = 0;
                }
                continue;
            }
            if (ident.equals("autoArchive")) {
                this.autoArchive = Boolean.valueOf(value);
                continue;
            }
            if (ident.equals("fontChoice")) {
                this.fontChoice = value;
                continue;
            }
            if (ident.equals("confirmQuit")) {
                this.confirmQuit = Boolean.valueOf(value);
                continue;
            }
            if (ident.equals("graphicsEnabled")) {
                Main.GRAPHICS_ENABLED = Boolean.valueOf(value);
                continue;
            }
            if (ident.equals("horizontalScrolling")) {
                horizontalScrolling = Boolean.valueOf(value);
                continue;
            }
            if (ident.equals("zoomQuality")) {
                if (value.equalsIgnoreCase("quick")) {
                    this.zoomQuality = 2;
                    continue;
                }
                if (value.equalsIgnoreCase("balanced")) {
                    this.zoomQuality = 1;
                    continue;
                }
                if (!value.equalsIgnoreCase("quality")) continue;
                this.zoomQuality = 4;
                continue;
            }
            if (ident.equals("biqLanguage")) {
                this.biqLanguage = value;
                continue;
            }
            if (ident.equals("editorLanguage")) {
                this.editorLanguage = value;
                continue;
            }
            if (ident.equals("validateInfiniteUnitUpgrade")) {
                this.validateInfiniteUnitUpgrade = Boolean.valueOf(value);
                continue;
            }
            if (ident.equals("validatePhantomResourceBug")) {
                this.validatePhantomResourceBug = Boolean.valueOf(value);
                continue;
            }
            if (ident.equals("recent0")) {
                Settings.recentFiles[0] = value;
                continue;
            }
            if (ident.equals("recent1")) {
                Settings.recentFiles[1] = value;
                continue;
            }
            if (ident.equals("recent2")) {
                Settings.recentFiles[2] = value;
                continue;
            }
            if (ident.equals("recent3")) {
                Settings.recentFiles[3] = value;
                continue;
            }
            if (ident.equals("recent4")) {
                Settings.recentFiles[4] = value;
                continue;
            }
            if (ident.equals("fontSize")) {
                this.fontSize = Integer.parseInt(value);
                continue;
            }
            if (ident.equals("lookAndFeel")) {
                this.lookAndFeel = value;
                continue;
            }
            if (ident.equals("width")) {
                try {
                    this.width = Integer.parseInt(value);
                }
                catch (NumberFormatException e) {
                    this.width = 1030;
                }
                continue;
            }
            if (ident.equals("height")) {
                try {
                    this.height = Integer.parseInt(value);
                }
                catch (NumberFormatException e) {
                    this.height = 768;
                }
                continue;
            }
            if (ident.equals("riverProximity")) {
                try {
                    this.riverProximityMax = Integer.parseInt(value);
                }
                catch (NumberFormatException e) {
                    this.riverProximityMax = 10;
                }
                continue;
            }
            if (ident.equals("riverCornerRadius")) {
                try {
                    this.riverCornerRadius = Integer.parseInt(value);
                }
                catch (NumberFormatException e) {
                    this.riverCornerRadius = 14;
                }
                continue;
            }
            if (ident.equals("useSwing")) {
                this.useSwing = Boolean.valueOf(value);
                if (!this.useSwing) continue;
                this.useJavaFX = false;
                continue;
            }
            if (ident.equals("checkForUpdates")) {
                this.checkForUpdates = Boolean.valueOf(value);
                continue;
            }
            if (ident.equals("suppressedUpdateVersion")) {
                this.suppressedUpdateVersion = value;
                continue;
            }
            if (ident.startsWith("safety")) {
                String safetyLevel = ident.substring(6);
                Main.safetyLevels.put(safetyLevel, SafetyLevel.valueOf(value));
                continue;
            }
            if (ident.equals("decompressionMethod")) {
                this.decompressionMethod = value;
                continue;
            }
            if (!ident.equals("sevenZipVerified")) continue;
            this.sevenZipVerified = Boolean.valueOf(value);
        }
        in.close();
    }
}

