/*
 * Decompiled with CFR 0.152.
 */
package com.civfanatics.civ3.xplatformeditor;

import com.civfanatics.civ3.xplatformeditor.CustomComponents.SuperJTextField;
import com.civfanatics.civ3.xplatformeditor.Main;
import com.civfanatics.civ3.xplatformeditor.ReadOnlyException;
import com.civfanatics.civ3.xplatformeditor.Settings;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.IOException;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.ToolTipManager;
import javax.swing.border.TitledBorder;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class SettingsPanel
extends JFrame {
    static Logger logger = Logger.getLogger("Settings Panel");
    final Settings settings;
    JLabel lblWhatToDo = new JLabel("<HTML>Use these options to configure the editor, and then click Save<BR>to save the new settings or Cancel to cancel.<BR>Hover the mouse over the labels for help.</HTML>");
    JButton cmdSave = new JButton("Save");
    JButton cmdCancel = new JButton("Cancel");
    JPanel folders = new JPanel();
    JLabel lblOpenDir = new JLabel("Default opening directory");
    SuperJTextField openDir = new SuperJTextField();
    JButton openDirBrowse = new JButton("Browse");
    JLabel lblCivDir = new JLabel("Civ3 Install Directory");
    SuperJTextField civInstallDir = new SuperJTextField();
    JButton civInstallBrowse = new JButton("Browse");
    JPanel advanced = new JPanel();
    JPanel biqValidation = new JPanel();
    JLabel lblDebugLevel = new JLabel("Debug Level");
    Vector<String> debugLevels;
    JComboBox cmbDebugLevel;
    JLabel numProcs = new JLabel("Number of processors");
    JSpinner spnrNumProcs = new JSpinner();
    JTabbedPane tabs = new JTabbedPane();
    JPanel pnlMain = new JPanel();
    JPanel pnlMap = new JPanel();
    JPanel pnlAutoSave = new JPanel();
    JLabel lblInterval = new JLabel("Autosave Interval (seconds):");
    SpinnerNumberModel intervalModel = new SpinnerNumberModel(240, 1, Integer.MAX_VALUE, 1);
    JSpinner spnrInterval = new JSpinner(this.intervalModel);
    JLabel lblNumSaves = new JLabel("Number of autosaves");
    SpinnerNumberModel numSavesModel = new SpinnerNumberModel(10, 1, Integer.MAX_VALUE, 1);
    JSpinner spnrNumSaves = new JSpinner(this.numSavesModel);
    JLabel lblAutoArchive = new JLabel("<HTML>Auto archive is a feature that will automatically<BR>save a copy of your previous save when you save again,<BR>with _Archive_ and the date and time as part of the<BR>name.  That way you can go back to an older version if<BR>need be.</HTML>");
    JCheckBox chkAutoArchive = new JCheckBox("Auto Archive");
    JCheckBox chkInfiniteUpgrade = new JCheckBox("Infinite Upgrade Loop");
    JCheckBox chkPhantomResources = new JCheckBox("Phantom Resource Bug");
    JLabel lblAboutMapSettings = new JLabel("<HTML>You may optionally disable some layers of the map<BR>from displaying, just as you can in regular Civ3.</HMTL>");
    JCheckBox chkWoodlandsEnabled = new JCheckBox("Forest/Jungle");
    JCheckBox chkHllsEnabled = new JCheckBox("Hills/Mountains");
    JCheckBox chkMarshEnabled = new JCheckBox("Marsh");
    JCheckBox chkResourcesEnabled = new JCheckBox("Resources");
    JCheckBox chkRiversEnabled = new JCheckBox("Rivers");
    JCheckBox chkRoadsEnabled = new JCheckBox("Roads/Railroads");
    JCheckBox chkIrrigationEnabled = new JCheckBox("Irrigation");
    JCheckBox chkMinesEnabled = new JCheckBox("Mines");
    JCheckBox chkFortificationsEnabled = new JCheckBox("Fortifications");
    JCheckBox chkUnitsEnabled = new JCheckBox("Units");
    JCheckBox chkCitiesEnabled = new JCheckBox("Cities");
    JCheckBox chkColonialBuildingsEnabled = new JCheckBox("Colonies");
    JCheckBox chkBordersEnabled = new JCheckBox("Borders");
    JCheckBox chkBarbarianCampsEnabled = new JCheckBox("Barbarian Camps");
    JCheckBox chkGoodyHutsEnabled = new JCheckBox("Goody Huts");
    JCheckBox chkPollutionEnabled = new JCheckBox("Pollution");
    JCheckBox chkRuinsEnabled = new JCheckBox("Ruins");
    JCheckBox chkCratersEnabled = new JCheckBox("Craters");
    JCheckBox chkVplsEnabled = new JCheckBox("Victory Points");
    JCheckBox chkCityNamesEnabled = new JCheckBox("City Names");
    JCheckBox chkGridOn = new JCheckBox("Grid");
    JCheckBox chkFoodAndShields = new JCheckBox("Food and Shields on Map");
    JCheckBox chkFogOfWar = new JCheckBox("Fog of War");
    JLabel lblDrawMode = new JLabel("<HTML>Select the draw mode.  This affects how high-quality<br>the map is when you zoom.  Default is \"Balanced\"</HTML>");
    JRadioButton rbtnQuick = new JRadioButton("Quick");
    JRadioButton rbtnBalanced = new JRadioButton("Balanced");
    JRadioButton rbtnQuality = new JRadioButton("Quality");
    ButtonGroup btnGroup = new ButtonGroup();
    JLabel lblRiverSensitivity = new JLabel("<HTML>River sensitivity options - river proximity determines<br>how close you must be to a tile edge to paint a river.<br>Corner radius is how far you must be from a tile corner.</HTML>");
    JLabel lblRiverProximity = new JLabel("River Proximity:");
    SpinnerModel mdlProximity;
    JSpinner spnrRiverProximity;
    JLabel lblRiverCornerRadius;
    SpinnerModel mdlCornerRadius;
    JSpinner spnrCornerRadius;
    JLabel lblFont;
    Object[] mdlItems;
    DefaultComboBoxModel mdlFonts;
    JComboBox cmbFont;
    JLabel lblQuit;
    JCheckBox chkQuit;
    JLabel lblGraphicsEnabled;
    JCheckBox chkGraphicsEnabled;
    JLabel lblSwingLists;
    JCheckBox chkSwingLists;
    JLabel lblHorizontalScroll;
    JCheckBox chkHorizontalScrolling;
    JLabel lblBiqLanguage;
    Object[] mdlItems2;
    DefaultComboBoxModel mdlLanguages;
    JComboBox cmbBiqLanguage;
    JLabel lblEditorLanguage;
    Object[] mdlItems3;
    DefaultComboBoxModel mdlEditorLangs;
    JComboBox cmbEditorLanguage;
    JLabel lblFontSize;
    Object[] mdlFontSizes;
    DefaultComboBoxModel cmbFontSizesModel;
    JComboBox cmbFontSizes;
    JLabel lblLookAndFeel;
    Object[] mdlLAF;
    DefaultComboBoxModel cmbLAFModel;
    JComboBox cmbLAF;

    public SettingsPanel(Settings s, final Main main) {
        this.mdlProximity = new SpinnerNumberModel(Main.settings.riverProximityMax, 2, 24, 2);
        this.spnrRiverProximity = new JSpinner(this.mdlProximity);
        this.lblRiverCornerRadius = new JLabel("Corner Radius:");
        this.mdlCornerRadius = new SpinnerNumberModel(Main.settings.riverCornerRadius, 2, 24, 2);
        this.spnrCornerRadius = new JSpinner(this.mdlCornerRadius);
        this.lblFont = new JLabel("Font (requires restart)");
        this.mdlItems = new Object[]{"Tahoma", "Arial", "LucidaSansRegular", "Trebuchet MS", "SimSun"};
        this.mdlFonts = new DefaultComboBoxModel<Object>(this.mdlItems);
        this.cmbFont = new JComboBox(this.mdlFonts);
        this.lblQuit = new JLabel("Confirm quit");
        this.chkQuit = new JCheckBox();
        this.lblGraphicsEnabled = new JLabel("Map enabled");
        this.chkGraphicsEnabled = new JCheckBox();
        this.lblSwingLists = new JLabel("Use old lists (req. restart)");
        this.chkSwingLists = new JCheckBox();
        this.lblHorizontalScroll = new JLabel("Horizontal mousewheel scrolling");
        this.chkHorizontalScrolling = new JCheckBox();
        this.lblBiqLanguage = new JLabel("BIQ Language");
        this.mdlItems2 = new Object[]{"English", "Russian", "Chinese"};
        this.mdlLanguages = new DefaultComboBoxModel<Object>(this.mdlItems2);
        this.cmbBiqLanguage = new JComboBox(this.mdlLanguages);
        this.lblEditorLanguage = new JLabel("Editor Language");
        this.mdlItems3 = new Object[]{"English", "Russian", "French"};
        this.mdlEditorLangs = new DefaultComboBoxModel<Object>(this.mdlItems3);
        this.cmbEditorLanguage = new JComboBox(this.mdlEditorLangs);
        this.lblFontSize = new JLabel("Font Size");
        this.mdlFontSizes = new Object[]{"12", "14", "16"};
        this.cmbFontSizesModel = new DefaultComboBoxModel<Object>(this.mdlFontSizes);
        this.cmbFontSizes = new JComboBox(this.cmbFontSizesModel);
        this.lblLookAndFeel = new JLabel("Look and Feel");
        this.mdlLAF = new Object[]{"Metal", "System", "Nimbus"};
        this.cmbLAFModel = new DefaultComboBoxModel<Object>(this.mdlLAF);
        this.cmbLAF = new JComboBox(this.cmbLAFModel);
        this.debugLevels = new Vector();
        this.debugLevels.add("trace");
        this.debugLevels.add("debug");
        this.debugLevels.add("info");
        this.debugLevels.add("warn");
        this.debugLevels.add("error");
        this.cmbDebugLevel = new JComboBox<String>(this.debugLevels);
        this.settings = s;
        this.setTitle("Settings");
        this.folders.setBorder(new TitledBorder("Folders used"));
        this.folders.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.weightx = 0.01;
        c.weighty = 0.0;
        c.gridx = 0;
        c.gridy = 0;
        this.folders.add((Component)this.lblCivDir, c);
        ++c.gridy;
        this.folders.add((Component)this.civInstallDir, c);
        ++c.gridx;
        c.weightx = 0.0;
        this.folders.add((Component)this.civInstallBrowse, c);
        c.weightx = 0.01;
        ++c.gridy;
        --c.gridx;
        this.folders.add((Component)this.lblOpenDir, c);
        ++c.gridy;
        this.folders.add((Component)this.openDir, c);
        ++c.gridx;
        c.weightx = 0.0;
        this.folders.add((Component)this.openDirBrowse, c);
        this.initializeAdvancedSection();
        this.initializeValidationSection();
        this.pnlMain.setLayout(new GridBagLayout());
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 7;
        c.gridheight = 1;
        c.fill = 2;
        c.weightx = 0.9;
        c.weighty = 0.0;
        c.weightx = 0.9;
        c.weighty = 0.1;
        c.insets = new Insets(0, 5, 0, 5);
        this.pnlMain.add((Component)this.lblWhatToDo, c);
        c.gridy = 1;
        c.weighty = 0.5;
        c.insets = new Insets(0, 0, 0, 0);
        this.pnlMain.add((Component)this.folders, c);
        ++c.gridy;
        this.pnlMain.add((Component)this.advanced, c);
        ++c.gridy;
        this.pnlMain.add((Component)this.biqValidation, c);
        this.openDir.setText(this.settings.openDir);
        this.civInstallDir.setText(this.settings.civInstallDir);
        this.spnrNumProcs.setModel(new SpinnerNumberModel(0, 0, 0x100000, 1));
        try {
            this.spnrNumProcs.setValue(Integer.parseInt(this.settings.numProcs));
        }
        catch (NumberFormatException e) {
            this.spnrNumProcs.setValue(-1);
        }
        this.cmbDebugLevel.setSelectedItem(this.settings.debugLevel);
        this.cmbFont.setSelectedItem(this.settings.fontChoice);
        this.cmbBiqLanguage.setSelectedItem(this.settings.biqLanguage);
        this.cmbEditorLanguage.setSelectedItem(this.settings.editorLanguage);
        if (this.settings.fontSize == 12) {
            this.cmbFontSizes.setSelectedItem("12");
        } else if (this.settings.fontSize == 14) {
            this.cmbFontSizes.setSelectedItem("14");
        } else if (this.settings.fontSize == 16) {
            this.cmbFontSizes.setSelectedItem("16");
        }
        this.cmbLAF.setSelectedItem(this.settings.lookAndFeel);
        this.cmdSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SettingsPanel.this.settings.openDir = SettingsPanel.this.openDir.getText();
                SettingsPanel.this.settings.civInstallDir = SettingsPanel.this.civInstallDir.getText();
                SettingsPanel.this.settings.debugLevel = (String)SettingsPanel.this.cmbDebugLevel.getSelectedItem();
                if (SettingsPanel.this.settings.debugLevel.equals("trace")) {
                    Logger.getRootLogger().setLevel(Level.TRACE);
                } else if (SettingsPanel.this.settings.debugLevel.equals("debug")) {
                    Logger.getRootLogger().setLevel(Level.DEBUG);
                } else if (SettingsPanel.this.settings.debugLevel.equals("info")) {
                    Logger.getRootLogger().setLevel(Level.INFO);
                } else if (SettingsPanel.this.settings.debugLevel.equals("warn")) {
                    Logger.getRootLogger().setLevel(Level.WARN);
                } else if (SettingsPanel.this.settings.debugLevel.equals("error")) {
                    Logger.getRootLogger().setLevel(Level.ERROR);
                }
                SettingsPanel.this.settings.numProcs = String.valueOf(((SpinnerNumberModel)SettingsPanel.this.spnrNumProcs.getModel()).getNumber().intValue());
                SettingsPanel.this.settings.fontChoice = SettingsPanel.this.cmbFont.getSelectedItem().toString();
                SettingsPanel.this.settings.confirmQuit = SettingsPanel.this.chkQuit.isSelected();
                SettingsPanel.this.settings.biqLanguage = SettingsPanel.this.cmbBiqLanguage.getSelectedItem().toString();
                SettingsPanel.this.settings.editorLanguage = SettingsPanel.this.cmbEditorLanguage.getSelectedItem().toString();
                SettingsPanel.this.settings.validateInfiniteUnitUpgrade = SettingsPanel.this.chkInfiniteUpgrade.isSelected();
                SettingsPanel.this.settings.validatePhantomResourceBug = SettingsPanel.this.chkPhantomResources.isSelected();
                SettingsPanel.this.settings.barbarianCampsEnabled = SettingsPanel.this.chkBarbarianCampsEnabled.isSelected();
                SettingsPanel.this.settings.bordersEnabled = SettingsPanel.this.chkBordersEnabled.isSelected();
                SettingsPanel.this.settings.citiesEnabled = SettingsPanel.this.chkCitiesEnabled.isSelected();
                SettingsPanel.this.settings.colonialBuildingsEnabled = SettingsPanel.this.chkColonialBuildingsEnabled.isSelected();
                SettingsPanel.this.settings.cratersEnabled = SettingsPanel.this.chkCratersEnabled.isSelected();
                SettingsPanel.this.settings.fortificationsEnabled = SettingsPanel.this.chkFortificationsEnabled.isSelected();
                SettingsPanel.this.settings.goodyHutsEnabled = SettingsPanel.this.chkGoodyHutsEnabled.isSelected();
                SettingsPanel.this.settings.hillsEnabled = SettingsPanel.this.chkHllsEnabled.isSelected();
                SettingsPanel.this.settings.irrigationEnabled = SettingsPanel.this.chkIrrigationEnabled.isSelected();
                SettingsPanel.this.settings.marshEnabled = SettingsPanel.this.chkMarshEnabled.isSelected();
                SettingsPanel.this.settings.minesEnabled = SettingsPanel.this.chkMinesEnabled.isSelected();
                SettingsPanel.this.settings.pollutionEnabled = SettingsPanel.this.chkPollutionEnabled.isSelected();
                SettingsPanel.this.settings.resourcesEnabled = SettingsPanel.this.chkResourcesEnabled.isSelected();
                SettingsPanel.this.settings.riversEnabled = SettingsPanel.this.chkRiversEnabled.isSelected();
                SettingsPanel.this.settings.roadsEnabled = SettingsPanel.this.chkRoadsEnabled.isSelected();
                SettingsPanel.this.settings.ruinsEnabled = SettingsPanel.this.chkRuinsEnabled.isSelected();
                SettingsPanel.this.settings.unitsEnabled = SettingsPanel.this.chkUnitsEnabled.isSelected();
                SettingsPanel.this.settings.vplsEnabled = SettingsPanel.this.chkVplsEnabled.isSelected();
                SettingsPanel.this.settings.woodlandsEnabled = SettingsPanel.this.chkWoodlandsEnabled.isSelected();
                SettingsPanel.this.settings.cityNamesEnabled = SettingsPanel.this.chkCityNamesEnabled.isSelected();
                SettingsPanel.this.settings.gridEnabled = SettingsPanel.this.chkGridOn.isSelected();
                Settings.showFoodAndShields = SettingsPanel.this.chkFoodAndShields.isSelected();
                SettingsPanel.this.settings.showFog = SettingsPanel.this.chkFogOfWar.isSelected();
                SettingsPanel.this.settings.maxAutosaves = ((SpinnerNumberModel)SettingsPanel.this.spnrNumSaves.getModel()).getNumber().intValue();
                if (SettingsPanel.this.settings.nextAutosave > SettingsPanel.this.settings.maxAutosaves) {
                    SettingsPanel.this.settings.nextAutosave = 0;
                }
                SettingsPanel.this.intervalModel.getNumber().intValue();
                SettingsPanel.this.settings.autoSaveInterval = ((SpinnerNumberModel)SettingsPanel.this.spnrInterval.getModel()).getNumber().intValue();
                main.setAutoSaveTimer();
                SettingsPanel.this.settings.autoArchive = SettingsPanel.this.chkAutoArchive.isSelected();
                Main.GRAPHICS_ENABLED = SettingsPanel.this.chkGraphicsEnabled.isSelected();
                if (!Main.settings.forceSwing) {
                    SettingsPanel.this.settings.useSwing = SettingsPanel.this.chkSwingLists.isSelected();
                }
                Settings.horizontalScrolling = SettingsPanel.this.chkHorizontalScrolling.isSelected();
                if (SettingsPanel.this.rbtnBalanced.isSelected()) {
                    SettingsPanel.this.settings.zoomQuality = 1;
                } else if (SettingsPanel.this.rbtnQuick.isSelected()) {
                    SettingsPanel.this.settings.zoomQuality = 2;
                } else if (SettingsPanel.this.rbtnQuality.isSelected()) {
                    SettingsPanel.this.settings.zoomQuality = 4;
                }
                SettingsPanel.this.settings.riverProximityMax = (Integer)SettingsPanel.this.mdlProximity.getValue();
                SettingsPanel.this.settings.riverCornerRadius = (Integer)SettingsPanel.this.mdlCornerRadius.getValue();
                SettingsPanel.this.settings.fontSize = Integer.parseInt(SettingsPanel.this.cmbFontSizes.getSelectedItem().toString());
                SettingsPanel.this.settings.lookAndFeel = SettingsPanel.this.cmbLAF.getSelectedItem().toString();
                try {
                    SettingsPanel.this.settings.exportConfigFile();
                    Main.updateFileChooserDirectories();
                    SettingsPanel.this.dispose();
                }
                catch (ReadOnlyException ex) {
                    JOptionPane.showMessageDialog(null, "Cannot save because " + ex.getMessage(), "Cannot save settings", 0);
                }
            }
        });
        this.cmdCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SettingsPanel.this.dispose();
            }
        });
        this.openDirBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent a) {
                JFileChooser jFileChooser1 = new JFileChooser();
                File curLoc = new File(SettingsPanel.this.settings.openDir);
                if (curLoc.exists()) {
                    jFileChooser1.setCurrentDirectory(curLoc);
                }
                jFileChooser1.setFileSelectionMode(1);
                int response = jFileChooser1.showOpenDialog(null);
                if (response == 0) {
                    File file = jFileChooser1.getSelectedFile();
                    try {
                        SettingsPanel.this.settings.openDir = file.getCanonicalPath();
                        SettingsPanel.this.openDir.setText(SettingsPanel.this.settings.openDir);
                    }
                    catch (IOException e) {
                        logger.error("Exception while trying to get canonical path of default opening dir", e);
                    }
                }
            }
        });
        this.civInstallBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent a) {
                JFileChooser jFileChooser1 = new JFileChooser();
                File curLoc = new File(SettingsPanel.this.settings.civInstallDir);
                if (curLoc.exists()) {
                    jFileChooser1.setCurrentDirectory(curLoc);
                }
                jFileChooser1.setFileSelectionMode(1);
                int response = jFileChooser1.showOpenDialog(null);
                if (response == 0) {
                    File file = jFileChooser1.getSelectedFile();
                    try {
                        SettingsPanel.this.settings.civInstallDir = file.getCanonicalPath();
                        SettingsPanel.this.civInstallDir.setText(SettingsPanel.this.settings.civInstallDir);
                    }
                    catch (IOException e) {
                        logger.error("Exception while trying to get canonical path of default install dir", e);
                    }
                }
            }
        });
        ToolTipManager.sharedInstance().setDismissDelay(10000);
        this.lblDebugLevel.setToolTipText("<HTML>A log is kept in the file log.txt, in the same folder where the editor is, to help debug any bugs that are encountered.<BR>Requires restart to take effect.<BR>Warning: debug or trace may noticeably slow down program.</HTML>");
        this.numProcs.setToolTipText("<HTML>Number of processors to use.  0 = all available.</HTML>");
        this.lblCivDir.setToolTipText("<HTML>Where Civ3 (the base game, not Conquests, on Windows; Complete on Mac) is intalled.</HTML>");
        this.lblOpenDir.setToolTipText("<HTML>Where you'd like the program to use as your default BIQ file location.</HTML>");
        this.chkWoodlandsEnabled.setSelected(this.settings.woodlandsEnabled);
        this.chkHllsEnabled.setSelected(this.settings.hillsEnabled);
        this.chkMarshEnabled.setSelected(this.settings.marshEnabled);
        this.chkResourcesEnabled.setSelected(this.settings.resourcesEnabled);
        this.chkRiversEnabled.setSelected(this.settings.riversEnabled);
        this.chkRoadsEnabled.setSelected(this.settings.roadsEnabled);
        this.chkIrrigationEnabled.setSelected(this.settings.irrigationEnabled);
        this.chkMinesEnabled.setSelected(this.settings.minesEnabled);
        this.chkFortificationsEnabled.setSelected(this.settings.fortificationsEnabled);
        this.chkUnitsEnabled.setSelected(this.settings.unitsEnabled);
        this.chkCitiesEnabled.setSelected(this.settings.citiesEnabled);
        this.chkColonialBuildingsEnabled.setSelected(this.settings.colonialBuildingsEnabled);
        this.chkBordersEnabled.setSelected(this.settings.bordersEnabled);
        this.chkBarbarianCampsEnabled.setSelected(this.settings.barbarianCampsEnabled);
        this.chkGoodyHutsEnabled.setSelected(this.settings.goodyHutsEnabled);
        this.chkPollutionEnabled.setSelected(this.settings.pollutionEnabled);
        this.chkRuinsEnabled.setSelected(this.settings.ruinsEnabled);
        this.chkCratersEnabled.setSelected(this.settings.cratersEnabled);
        this.chkVplsEnabled.setSelected(this.settings.vplsEnabled);
        this.chkCityNamesEnabled.setSelected(this.settings.cityNamesEnabled);
        this.chkGridOn.setSelected(this.settings.gridEnabled);
        this.chkFoodAndShields.setSelected(Settings.showFoodAndShields);
        this.chkFogOfWar.setSelected(this.settings.showFog);
        this.pnlMap.setLayout(new GridBagLayout());
        c = new GridBagConstraints();
        c.gridy = 0;
        c.gridx = 0;
        c.gridheight = 1;
        c.gridwidth = 2;
        c.fill = 2;
        this.pnlMap.add((Component)this.lblAboutMapSettings, c);
        ++c.gridy;
        c.gridwidth = 1;
        this.pnlMap.add((Component)this.chkWoodlandsEnabled, c);
        ++c.gridx;
        this.pnlMap.add((Component)this.chkHllsEnabled, c);
        ++c.gridy;
        --c.gridx;
        this.pnlMap.add((Component)this.chkMarshEnabled, c);
        ++c.gridx;
        this.pnlMap.add((Component)this.chkResourcesEnabled, c);
        ++c.gridy;
        --c.gridx;
        this.pnlMap.add((Component)this.chkRiversEnabled, c);
        ++c.gridx;
        this.pnlMap.add((Component)this.chkRoadsEnabled, c);
        ++c.gridy;
        --c.gridx;
        this.pnlMap.add((Component)this.chkIrrigationEnabled, c);
        ++c.gridx;
        this.pnlMap.add((Component)this.chkMinesEnabled, c);
        ++c.gridy;
        --c.gridx;
        this.pnlMap.add((Component)this.chkFortificationsEnabled, c);
        ++c.gridx;
        this.pnlMap.add((Component)this.chkUnitsEnabled, c);
        ++c.gridy;
        --c.gridx;
        this.pnlMap.add((Component)this.chkCitiesEnabled, c);
        ++c.gridx;
        this.pnlMap.add((Component)this.chkColonialBuildingsEnabled, c);
        ++c.gridy;
        --c.gridx;
        this.pnlMap.add((Component)this.chkBordersEnabled, c);
        ++c.gridx;
        this.pnlMap.add((Component)this.chkBarbarianCampsEnabled, c);
        ++c.gridy;
        --c.gridx;
        this.pnlMap.add((Component)this.chkGoodyHutsEnabled, c);
        ++c.gridx;
        this.pnlMap.add((Component)this.chkPollutionEnabled, c);
        ++c.gridy;
        --c.gridx;
        this.pnlMap.add((Component)this.chkRuinsEnabled, c);
        ++c.gridx;
        this.pnlMap.add((Component)this.chkCratersEnabled, c);
        ++c.gridy;
        --c.gridx;
        this.pnlMap.add((Component)this.chkVplsEnabled, c);
        ++c.gridx;
        this.pnlMap.add((Component)this.chkCityNamesEnabled, c);
        ++c.gridy;
        --c.gridx;
        this.pnlMap.add((Component)this.chkGridOn, c);
        ++c.gridx;
        this.pnlMap.add((Component)this.chkFoodAndShields, c);
        ++c.gridy;
        --c.gridx;
        this.pnlMap.add((Component)this.chkFogOfWar, c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 2;
        this.pnlMap.add((Component)this.lblDrawMode, c);
        if (this.settings.zoomQuality == 1) {
            this.rbtnBalanced.setSelected(true);
        } else if (this.settings.zoomQuality == 2) {
            this.rbtnQuick.setSelected(true);
        } else if (this.settings.zoomQuality == 4) {
            this.rbtnQuality.setSelected(true);
        }
        this.rbtnQuick.setToolTipText("Less internsive, but doesn't look as good.  Recommended with less powerful processors, or with < 50% zoom.");
        this.rbtnBalanced.setToolTipText("Acceptable performance at 50% zoom with recent processors, and the default.");
        this.rbtnQuality.setToolTipText("Looks the best, but is slow.");
        this.btnGroup.add(this.rbtnQuick);
        this.btnGroup.add(this.rbtnBalanced);
        this.btnGroup.add(this.rbtnQuality);
        ++c.gridy;
        c.gridwidth = 1;
        this.pnlMap.add((Component)this.rbtnQuick, c);
        ++c.gridx;
        this.pnlMap.add((Component)this.rbtnBalanced, c);
        --c.gridx;
        ++c.gridy;
        this.pnlMap.add((Component)this.rbtnQuality, c);
        this.spnrRiverProximity.setValue(this.settings.riverProximityMax);
        this.spnrCornerRadius.setValue(this.settings.riverCornerRadius);
        ++c.gridy;
        c.gridwidth = 2;
        this.pnlMap.add((Component)this.lblRiverSensitivity, c);
        ++c.gridy;
        c.gridwidth = 1;
        this.pnlMap.add((Component)this.lblRiverProximity, c);
        ++c.gridx;
        this.pnlMap.add((Component)this.spnrRiverProximity, c);
        --c.gridx;
        ++c.gridy;
        this.pnlMap.add((Component)this.lblRiverCornerRadius, c);
        ++c.gridx;
        this.pnlMap.add((Component)this.spnrCornerRadius, c);
        this.spnrNumSaves.setValue(this.settings.maxAutosaves);
        this.spnrInterval.setValue(this.settings.autoSaveInterval);
        this.chkAutoArchive.setSelected(this.settings.autoArchive);
        this.pnlAutoSave.setLayout(new GridBagLayout());
        c = new GridBagConstraints();
        c.gridy = 0;
        c.gridx = 0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.weightx = 0.5;
        c.fill = 2;
        this.pnlAutoSave.add((Component)this.lblNumSaves, c);
        ++c.gridx;
        this.pnlAutoSave.add((Component)this.spnrNumSaves, c);
        --c.gridx;
        ++c.gridy;
        this.pnlAutoSave.add((Component)this.lblInterval, c);
        ++c.gridx;
        this.pnlAutoSave.add((Component)this.spnrInterval, c);
        --c.gridx;
        ++c.gridy;
        c.gridheight = 4;
        c.gridwidth = 2;
        c.ipady = 5;
        this.pnlAutoSave.add((Component)this.lblAutoArchive, c);
        c.gridy += 4;
        c.gridheight = 1;
        c.gridwidth = 1;
        ++c.gridx;
        c.ipady = 0;
        this.pnlAutoSave.add((Component)this.chkAutoArchive, c);
        this.tabs.add((Component)this.pnlMain, "Main");
        if (Main.GRAPHICS_ENABLED) {
            this.tabs.add((Component)this.pnlMap, "Map");
        }
        this.tabs.add((Component)this.pnlAutoSave, "Autosave");
        this.getContentPane().setLayout(new GridBagLayout());
        c = new GridBagConstraints();
        c.gridy = 0;
        c.weighty = 1.0;
        c.gridwidth = 2;
        c.gridheight = 1;
        c.gridx = 0;
        this.getContentPane().add((Component)this.tabs, c);
        ++c.gridy;
        c.weighty = 0.0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.weightx = 0.5;
        c.fill = 2;
        this.getContentPane().add((Component)this.cmdSave, c);
        ++c.gridx;
        this.getContentPane().add((Component)this.cmdCancel, c);
        this.lblQuit.setLabelFor(this.chkQuit);
        this.lblGraphicsEnabled.setLabelFor(this.chkGraphicsEnabled);
        this.lblSwingLists.setLabelFor(this.chkSwingLists);
        this.lblHorizontalScroll.setLabelFor(this.chkHorizontalScrolling);
        this.pack();
        this.setResizable(false);
    }

    private void initializeAdvancedSection() {
        this.cmbBiqLanguage.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() != 1) {
                    return;
                }
                if (e.getItem().equals("Chinese")) {
                    SettingsPanel.this.cmbFont.setSelectedIndex(4);
                }
            }
        });
        this.advanced.setBorder(new TitledBorder("Advanced options"));
        this.advanced.setLayout(new GridLayout(12, 2));
        this.advanced.add(this.lblDebugLevel);
        this.advanced.add(this.cmbDebugLevel);
        this.advanced.add(this.numProcs);
        this.advanced.add(this.spnrNumProcs);
        this.advanced.add(this.lblFont);
        this.advanced.add(this.cmbFont);
        this.chkQuit.setSelected(this.settings.confirmQuit);
        this.lblQuit.setToolTipText("If checked, the program will ask you if you really want to quit when you exit.");
        this.advanced.add(this.lblQuit);
        this.advanced.add(this.chkQuit);
        this.chkGraphicsEnabled.setSelected(Main.GRAPHICS_ENABLED);
        this.lblGraphicsEnabled.setToolTipText("<HTML>If checked, map editing will be enabled.  Requires restart.<BR>Note: the map will take a few more seconds to load than the rest of the BIQ.<BR>It will be grayed out until it finishes loading.</HTML>");
        this.chkHorizontalScrolling.setSelected(Settings.horizontalScrolling);
        this.lblHorizontalScroll.setToolTipText("If selected, you can scroll horizontally on the map by holding down shift and scrolling with the mouse wheel.");
        this.advanced.add(this.lblGraphicsEnabled);
        this.advanced.add(this.chkGraphicsEnabled);
        this.chkSwingLists.setSelected(Main.settings.useSwing);
        if (Main.settings.forceSwing) {
            this.chkSwingLists.setSelected(true);
            this.chkSwingLists.setEnabled(false);
            if (Main.settings.forceSwingDueToJavaBug) {
                this.chkSwingLists.setToolTipText("Force-enabled due to bug on XP with recent Java update.");
            } else {
                this.chkSwingLists.setToolTipText("Force-enabled due to old Java version.");
            }
        }
        this.lblSwingLists.setToolTipText("<HTML>Use the old pre-1.10 lists on tabs such as TECH.  Note this is a temporary option,<br>which will eventually be removed.  Requires restart.</HTML>");
        this.advanced.add(this.lblSwingLists);
        this.advanced.add(this.chkSwingLists);
        this.advanced.add(this.lblHorizontalScroll);
        this.advanced.add(this.chkHorizontalScrolling);
        this.advanced.add(this.lblBiqLanguage);
        this.advanced.add(this.cmbBiqLanguage);
        this.advanced.add(this.lblEditorLanguage);
        this.advanced.add(this.cmbEditorLanguage);
        this.advanced.add(this.lblFontSize);
        this.advanced.add(this.cmbFontSizes);
        this.advanced.add(this.lblLookAndFeel);
        this.advanced.add(this.cmbLAF);
    }

    private void initializeValidationSection() {
        this.biqValidation.setBorder(new TitledBorder("BIQ Validation"));
        this.biqValidation.setLayout(new GridLayout(3, 1));
        JLabel lblBIQValidation = new JLabel("<html>The editor can validate BIQs upon save for certain types of bugs.<br/>These checks can be enabled or disabled from this section.<br/></html>");
        this.chkInfiniteUpgrade.setToolTipText("Upgrade loops for units will cause infinite AI turn times.");
        this.chkPhantomResources.setToolTipText("If two strategic/luxury resources are spaced 32 resources apart, odd behavior occurs in-game.  See Help for full details.");
        this.chkInfiniteUpgrade.setSelected(this.settings.validateInfiniteUnitUpgrade);
        this.chkPhantomResources.setSelected(this.settings.validatePhantomResourceBug);
        this.biqValidation.add(lblBIQValidation);
        this.biqValidation.add(this.chkInfiniteUpgrade);
        this.biqValidation.add(this.chkPhantomResources);
    }
}

