/*
 * Decompiled with CFR 0.152.
 */
package com.civfanatics.civ3.xplatformeditor;

import com.civfanatics.civ3.biqFile.IO;
import com.civfanatics.civ3.xplatformeditor.Main;
import com.civfanatics.civ3.xplatformeditor.UnitTab;
import com.civfanatics.civ3.xplatformeditor.download.RenameUnitWindowController;
import com.civfanatics.civ3.xplatformeditor.utils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.concurrent.Task;
import javafx.concurrent.WorkerStateEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.fxml.LoadException;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.stage.Stage;
import javafx.util.Duration;
import org.apache.log4j.Logger;
import webbrowserfx.WebBrowserFX;

public class UnitDownloadWindowController
implements Initializable {
    static Logger logger = Logger.getLogger("UnitDownloadWindowController");
    @FXML
    private TextField txtDecompressionMethod;
    @FXML
    private TextArea txtDescription;
    private IO biq;
    private UnitTab unitTab;

    public void initialize(URL url, ResourceBundle rb) {
        this.txtDescription.setText("Welcome to the Unit Download Area.  This area uses a customized web browser to allow you to download units from the CFC downloads database, and have them automatically added to your scenario (while being optionally renamed).  All you have to do is find a unit you'd like to add on the Downloads Database, click the download button, and the editor will take care of adding it to your scenario.\n\nTo help with decompression, the editor will call 7-Zip to perform decompression.  You can test that it is available with the Test 7-Zip button below, and on Windows, the editor can automatically download it if need be.  Then click the Browse for Units button to begin downloading units.\n\nAfter 7-Zip is verified to be working, on future uses of the editor you'll be taken directly to the Downloads Database.");
        if (Main.settings.sevenZipVerified) {
            this.browse();
        }
    }

    @FXML
    protected void browse() {
        Stage browserStage = new Stage();
        WebBrowserFX browser = new WebBrowserFX();
        browser.setMaster(this);
        browser.setHomepage("https://forums.civfanatics.com/resources/categories/civ3-unit-graphics.23/");
        browser.start(browserStage);
        Timeline timeline = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)10.0), ev -> {
            Stage stage;
            Scene scene = this.txtDescription.getScene();
            if (scene != null && (stage = (Stage)this.txtDescription.getScene().getWindow()) != null) {
                stage.close();
            }
        }, new KeyValue[0])});
        timeline.play();
        browserStage.show();
    }

    @FXML
    protected void test7z() {
        boolean sevenZResult = RenameUnitWindowController.test7Zip();
        if (sevenZResult) {
            Alert a = new Alert(Alert.AlertType.INFORMATION, "7-zip testing successful; you may download units.", new ButtonType[]{ButtonType.OK});
            a.setTitle("7-Zip Testing");
            a.setHeaderText("");
            a.showAndWait();
            Main.settings.sevenZipVerified = true;
        } else if (Main.os.name.toLowerCase().contains("windows")) {
            ButtonType type;
            Alert b = new Alert(Alert.AlertType.CONFIRMATION, "Would you like to download 7-Zip (1.3 MB download) so the editor can download units?", new ButtonType[]{ButtonType.YES, ButtonType.NO});
            b.setTitle("7-Zip Testing");
            b.setHeaderText("7-Zip Not Detected");
            Optional button = b.showAndWait();
            if (button.isPresent() && (type = (ButtonType)button.get()).equals(ButtonType.YES)) {
                try {
                    File folder = new File("bin/7z");
                    if (!folder.exists()) {
                        Files.createDirectory(Paths.get("bin/7z", new String[0]), new FileAttribute[0]);
                    }
                    HttpURLConnection conn = utils.getHttpConnection("http://quintillus.warpmail.net/civ3editor/bin/7zip/7z.exe");
                    utils.downloadFromHttpConnection(conn, "bin/7z/7z.exe");
                    HttpURLConnection conn2 = utils.getHttpConnection("http://quintillus.warpmail.net/civ3editor/bin/7zip/7z.dll");
                    utils.downloadFromHttpConnection(conn2, "bin/7z/7z.dll");
                    Alert y = new Alert(Alert.AlertType.INFORMATION, "7-Zip has been successfully downloaded and you can now download units.", new ButtonType[]{ButtonType.OK});
                    y.setTitle("Successful download");
                    y.setHeaderText("");
                    y.showAndWait();
                    Main.settings.sevenZipVerified = true;
                }
                catch (IOException ex) {
                    logger.error("Exception while downloading 7-zip", ex);
                    Alert e = new Alert(Alert.AlertType.ERROR, "7-zip could not be downloaded.  Check your network connection.  You may also manually place 7z.exe and 7z.dll in the bin/7z folder of the editor.", new ButtonType[]{ButtonType.OK});
                    e.setHeaderText("");
                    e.setTitle("Error Downloading");
                    e.showAndWait();
                }
            }
        } else {
            Alert a = new Alert(Alert.AlertType.INFORMATION, "7-zip testing failed.  7-zip must be available on your command line, or in the editor's bin/7z folder to download units.", new ButtonType[]{ButtonType.OK});
            a.setTitle("7-Zip Testing");
            a.setHeaderText("");
            a.showAndWait();
        }
    }

    public void setBIQLink(IO biq) {
        this.biq = biq;
    }

    public void setUnitTabLink(UnitTab unitTab) {
        this.unitTab = unitTab;
    }

    public void downloadUnit(final String url) {
        try {
            final StringBuffer initialFileName = new StringBuffer();
            Task downloadTask = new Task(){

                protected Integer call() {
                    try {
                        int bytesRead;
                        URL theUrl = new URL(url);
                        HttpURLConnection conn = (HttpURLConnection)theUrl.openConnection();
                        conn.connect();
                        InputStream is = conn.getInputStream();
                        BufferedInputStream reader = new BufferedInputStream(is);
                        long downloadSize = conn.getContentLengthLong();
                        long bytesDownloaded = 0L;
                        this.updateProgress(bytesDownloaded, downloadSize);
                        String contentType = conn.getHeaderField("Content-Disposition");
                        String name = contentType.substring(contentType.indexOf("name=") + 6);
                        int endQuote = name.indexOf("\"");
                        name = name.substring(0, endQuote);
                        File unitsFolder = null;
                        try {
                            File f = new File(Main.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath());
                            unitsFolder = new File(f.getParent() + "/units");
                            if (!Files.exists(unitsFolder.toPath(), new LinkOption[0])) {
                                Files.createDirectory(unitsFolder.toPath(), new FileAttribute[0]);
                            }
                        }
                        catch (URISyntaxException ex) {
                            System.err.println("URISyntaxException: " + ex);
                        }
                        initialFileName.append(unitsFolder.getCanonicalPath() + Main.fileSlash + name);
                        File file = new File(initialFileName.toString());
                        FileOutputStream fos = new FileOutputStream(file);
                        byte[] buffer = new byte[1024];
                        while ((bytesRead = reader.read(buffer)) > -1) {
                            fos.write(buffer, 0, bytesRead);
                            this.updateProgress(bytesDownloaded += (long)bytesRead, downloadSize);
                        }
                        this.updateProgress(1L, 1L);
                        reader.close();
                        fos.close();
                    }
                    catch (IOException ex) {
                        logger.error("IOException while downloading", ex);
                    }
                    return 0;
                }
            };
            FXMLLoader fxmlLoader = new FXMLLoader();
            fxmlLoader.setLocation(Main.class.getResource("/fxml/RenameUnitWindow.fxml"));
            Parent root = (Parent)fxmlLoader.load();
            final RenameUnitWindowController controller = (RenameUnitWindowController)fxmlLoader.getController();
            controller.setDecompressionMethod(Main.settings.decompressionMethod);
            controller.setBiqLink(this.biq);
            controller.setUnitTab(this.unitTab);
            String firstFolder = "";
            if (this.biq.scenarioProperty.get(0).getSearchFolderLength() > 0) {
                firstFolder = this.biq.scenarioProperty.get(0).getSearchFolder(0);
            }
            String testing = this.biq.fileName;
            String scenarioFolder = utils.getConquestsFolder(Main.settings.civInstallDir);
            scenarioFolder = scenarioFolder + "Scenarios" + Main.fileSlash + firstFolder + Main.fileSlash;
            controller.setScenarioFolder(scenarioFolder);
            root.setVisible(true);
            Stage stage = new Stage();
            Scene scene = new Scene(root);
            stage.setScene(scene);
            stage.setTitle("Add Unit to Scenario");
            stage.show();
            downloadTask.setOnSucceeded((EventHandler)new EventHandler<WorkerStateEvent>(){

                public void handle(WorkerStateEvent event) {
                    controller.setFileName(initialFileName.toString());
                }
            });
            controller.setDownloadTask(downloadTask);
            ExecutorService es = Executors.newFixedThreadPool(1);
            es.execute((Runnable)downloadTask);
        }
        catch (LoadException ex) {
            logger.error("Whoops!" + (Object)((Object)ex));
        }
        catch (MalformedURLException ex) {
            logger.error("Whoops!" + ex);
        }
        catch (IOException ex) {
            logger.error("Whoops! " + ex);
        }
    }
}

