/*
 * Decompiled with CFR 0.152.
 */
package com.civfanatics.civ3.xplatformeditor;

import com.civfanatics.civ3.biqFile.PRTO;
import com.civfanatics.civ3.xplatformeditor.IconPanel;
import com.civfanatics.civ3.xplatformeditor.Main;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.LineBorder;

public class UnitSelectionWindow
extends JDialog {
    GridBagConstraints gbc = new GridBagConstraints();
    private final int MAX_WIDTH = 6;
    private final BufferedImage units32;
    private BufferedImage currentIcon;
    int currentIconIndex = 0;
    private final BufferedImage[][] unitIcons;
    private int maxInRow = 0;
    IconPanel units32Panel = new IconPanel();
    IconPanel currentIconPanel = new IconPanel();
    JButton cmdCancel = new JButton("Cancel");
    JButton cmdApply = new JButton("Apply");
    PRTO unit;
    Thread animator;

    public UnitSelectionWindow(BufferedImage units32, BufferedImage currentIcon, BufferedImage[][] unitIcons, PRTO unit) {
        this.units32 = units32;
        this.currentIcon = currentIcon;
        this.unitIcons = unitIcons;
        this.maxInRow = (units32.getWidth() - 1) / 33;
        this.unit = unit;
    }

    public void initComponents() {
        this.setTitle("Select Unit Icon");
        this.setIconImage(Main.icon);
        this.setSize(500, 900);
        this.setLayout(new GridBagLayout());
        this.gbc.gridheight = 1;
        this.gbc.gridwidth = 1;
        this.gbc.fill = 1;
        this.gbc.weightx = 0.1;
        this.gbc.weighty = 0.0;
        JTextArea txtInstructions = new JTextArea("Select the icon for the unit here.  Click on an icon to choose it, and then click Apply\n to confirm your choice, or Cancel to revert to the icon selected when this window\n was opened.");
        txtInstructions.setEditable(false);
        txtInstructions.setRows(2);
        txtInstructions.setWrapStyleWord(true);
        this.gbc.gridwidth = 6;
        this.add((Component)txtInstructions, this.gbc);
        this.gbc.weighty = 0.01;
        JLabel lblCurrentIcon = new JLabel("Current icon:");
        this.gbc.gridwidth = 1;
        this.gbc.gridy += 2;
        this.gbc.gridx = 1;
        this.add((Component)lblCurrentIcon, this.gbc);
        ++this.gbc.gridx;
        this.gbc.fill = 0;
        this.gbc.insets = new Insets(5, 5, 5, 5);
        this.currentIconPanel.setMinimumSize(new Dimension(33, 33));
        this.currentIconPanel.setPreferredSize(new Dimension(33, 33));
        this.currentIconPanel.setBorder(new LineBorder(Color.BLACK));
        this.add((Component)this.currentIconPanel, this.gbc);
        this.gbc.fill = 1;
        ++this.gbc.gridy;
        this.gbc.gridx = 0;
        this.gbc.gridwidth = 6;
        this.gbc.weighty = 1.0;
        JScrollPane scrUnits = new JScrollPane(this.units32Panel);
        scrUnits.setPreferredSize(new Dimension(525, 600));
        this.add((Component)scrUnits, this.gbc);
        ++this.gbc.gridy;
        this.gbc.gridx = 4;
        this.gbc.gridwidth = 1;
        this.gbc.weighty = 0.01;
        this.add((Component)this.cmdApply, this.gbc);
        ++this.gbc.gridx;
        this.add((Component)this.cmdCancel, this.gbc);
        this.cmdApply.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UnitSelectionWindow.this.unit.setIconIndex(UnitSelectionWindow.this.currentIconIndex);
                UnitSelectionWindow.this.closeWindow();
            }
        });
        this.cmdCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UnitSelectionWindow.this.closeWindow();
            }
        });
        this.units32Panel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int x = e.getX() - 1;
                int y = e.getY() - 1;
                int xDiv33 = x / 33;
                int xMod33 = x % 33;
                int yDiv33 = y / 33;
                int yMod33 = y % 33;
                if (xMod33 == 32 || yMod33 == 32) {
                    return;
                }
                UnitSelectionWindow.this.selectIcon(xDiv33, yDiv33);
            }
        });
        this.setLocationRelativeTo(null);
    }

    private void closeWindow() {
        this.dispose();
    }

    private void selectIcon(int xGrid, int yGrid) {
        if (xGrid < this.unitIcons.length && yGrid < this.unitIcons[0].length) {
            this.currentIcon = this.unitIcons[xGrid][yGrid];
            this.currentIconIndex = yGrid * this.maxInRow + xGrid;
            this.drawCurrentIcon();
        }
    }

    public void drawStuff() {
        this.drawCurrentIcon();
        this.units32Panel.setPreferredSize(new Dimension(500, this.units32.getHeight()));
        this.units32Panel.setVisible(true);
        this.units32Panel.setImage(this.units32);
        Graphics panelGraphics = this.units32Panel.getGraphics();
        this.units32Panel.update(panelGraphics);
        panelGraphics.dispose();
    }

    private void drawCurrentIcon() {
        this.currentIconPanel.setVisible(true);
        this.currentIconPanel.setImage(this.currentIcon);
        Graphics iconGraphics = this.currentIconPanel.getGraphics();
        this.currentIconPanel.update(iconGraphics);
        iconGraphics.dispose();
    }
}

