/*
 * Decompiled with CFR 0.152.
 */
package com.civfanatics.civ3.xplatformeditor.download;

import com.civfanatics.civ3.biqFile.IO;
import com.civfanatics.civ3.xplatformeditor.Main;
import com.civfanatics.civ3.xplatformeditor.UnitTab;
import com.civfanatics.civ3.xplatformeditor.utils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.DosFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.util.Iterator;
import java.util.ResourceBundle;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Task;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.TextField;
import javafx.scene.layout.AnchorPane;
import javafx.stage.Stage;
import javafx.util.Duration;
import org.apache.log4j.Logger;

public class RenameUnitWindowController
implements Initializable {
    @FXML
    private AnchorPane anchorPane;
    @FXML
    private TextField txtName;
    @FXML
    private ProgressBar prgDownload;
    @FXML
    private Button cmdAddToScenario;
    @FXML
    private Label lblDownloadStatus;
    private String decompressionMethod = "";
    private String initialFileName = "";
    private String sevenZFolderName = "";
    private String scenarioFolder = "";
    private IO biq;
    private UnitTab unitTab;
    static Logger logger = Logger.getLogger("RenameUnitWindowController");
    public static boolean sevenZipBin = false;

    public void setDecompressionMethod(String string) {
        this.decompressionMethod = string;
    }

    public void setFileName(String fileName) {
        this.initialFileName = fileName;
        int dot = fileName.lastIndexOf(".");
        String unitName = fileName.substring(fileName.lastIndexOf(Main.fileSlash) + 1, dot);
        this.sevenZFolderName = unitName = unitName.substring(0, 1).toUpperCase() + unitName.substring(1);
        if (this.txtName.getText().isEmpty()) {
            this.txtName.setText(unitName);
        }
        this.cmdAddToScenario.setDisable(false);
        this.lblDownloadStatus.setText("The unit has been successfully downloaded.  Enter the name for your unit below, and it will be added to your scenario folder.");
    }

    public void setScenarioFolder(String fileName) {
        this.scenarioFolder = fileName;
        File file = new File(fileName);
        if (!file.exists()) {
            file.mkdirs();
        }
    }

    public void setBiqLink(IO biq) {
        this.biq = biq;
    }

    public void setUnitTab(UnitTab unitTab) {
        this.unitTab = unitTab;
    }

    public void initialize(URL url, ResourceBundle rb) {
    }

    @FXML
    private void addToScenario(ActionEvent event) {
        String name = this.txtName.getText();
        String folderName = "";
        try {
            folderName = this.decompressDownload();
        }
        catch (Exception ex) {
            this.lblDownloadStatus.setText("An unexpected error, " + ex.getMessage() + " occurred while downloading.  The log will have details.  Please report the error and which unit you were trying to download to the CFC thread.");
            logger.error("Blew up while adding to scenario", ex);
        }
        this.copyToScenarioFolder(name, folderName);
        this.unitTab.addItem(name, true);
        this.lblDownloadStatus.setText("The unit has been successfully added.  This window will close in 3 seconds.");
        Timeline timeline = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)3000.0), ev -> {
            Stage stage = (Stage)this.lblDownloadStatus.getScene().getWindow();
            stage.close();
        }, new KeyValue[0])});
        timeline.play();
    }

    public void setDownloadTask(Task task) {
        this.prgDownload.progressProperty().bind((ObservableValue)task.progressProperty());
    }

    public static boolean test7Zip() {
        try {
            Process sevenZipTest = null;
            try {
                sevenZipTest = Runtime.getRuntime().exec("7z");
            }
            catch (IOException ex) {
                logger.info("Could not run 7-Zip from path; trying from bin folder");
                try {
                    sevenZipTest = Runtime.getRuntime().exec("bin/7z/7z");
                    sevenZipBin = true;
                    Main.settings.decompressionMethod = "bin/7z/7z x [filename] -y -o";
                }
                catch (IOException ex2) {
                    logger.warn("Could not run 7-zip from path or bin folder");
                    return false;
                }
            }
            InputStream decompressResults = sevenZipTest.getInputStream();
            sevenZipTest.waitFor();
            int bytes = decompressResults.available();
            byte[] decompressBytes = new byte[bytes];
            decompressResults.read(decompressBytes);
            String decompressionResults = new String(decompressBytes, "ISO-8859-1");
            if (decompressionResults.contains("not recognized as an internal or external command")) {
                return false;
            }
            return decompressionResults.contains("7-Zip");
        }
        catch (IOException | InterruptedException ex) {
            logger.error("Error while testing 7zip", ex);
            return false;
        }
    }

    private String decompressDownload() throws Exception {
        String[] commands = this.decompressionMethod.split(" ");
        String full7zFolder = "";
        for (int i = 0; i < commands.length; ++i) {
            if (commands[i].equals("[filename]")) {
                commands[i] = this.initialFileName;
                continue;
            }
            if (!commands[i].equals("-o")) continue;
            if (Main.os.name.toLowerCase().contains("windows")) {
                full7zFolder = this.scenarioFolder + "art" + Main.fileSlash + "Units" + Main.fileSlash + this.sevenZFolderName + Main.fileSlash;
                File fileFolder = new File(full7zFolder);
                if (!fileFolder.exists()) {
                    fileFolder.mkdirs();
                }
                commands[i] = commands[i] + "\"\"" + full7zFolder + "\"\"";
                continue;
            }
            full7zFolder = this.scenarioFolder + "art" + Main.fileSlash + "Units" + Main.fileSlash + this.sevenZFolderName + Main.fileSlash;
            commands[i] = commands[i] + "\"" + full7zFolder + "\"";
        }
        logger.debug("Full 7-Zip folder: " + full7zFolder);
        try {
            Process decompression = Runtime.getRuntime().exec(commands, null, null);
            InputStream decompressResults = decompression.getInputStream();
            decompression.waitFor();
            int bytes = decompressResults.available();
            byte[] decompressBytes = new byte[bytes];
            decompressResults.read(decompressBytes);
            String decompressionResults = new String(decompressBytes, "ISO-8859-1");
            System.out.println("Decompression command: ");
            System.out.println(commands[0] + " " + commands[1] + " " + commands[2] + " " + commands[3]);
            System.out.println("Decompression results: " + decompressionResults);
            return full7zFolder;
        }
        catch (IOException ex) {
            this.lblDownloadStatus.setText("An IO error, " + ex.getMessage() + " occurred while decompressing the download.  The log will have details.  Please report the error and which unit you were trying to download to the CFC thread.");
            logger.error("Blew up while decompressing", ex);
            throw ex;
        }
        catch (InterruptedException ex) {
            this.lblDownloadStatus.setText("An Interrupted Exception, " + ex.getMessage() + " occurred while decompressing the download.  The log will have details.  Please report the error and which unit you were trying to download to the CFC thread.");
            logger.error("Interrupted exception while decompressing", ex);
            throw ex;
        }
    }

    private void copyToScenarioFolder(String name, String folderName) {
        try {
            Path desiredPath = Paths.get(this.scenarioFolder + "art" + Main.fileSlash + "Units" + Main.fileSlash + name + Main.fileSlash, new String[0]);
            Path tempPath = Paths.get(folderName, new String[0]);
            Path toCopy = null;
            FileTime mostRecentModified = FileTime.fromMillis(0L);
            DirectoryStream<Path> stream = Files.newDirectoryStream(tempPath);
            Iterator<Path> i = stream.iterator();
            int count = 0;
            boolean nestedFolder = true;
            while (i.hasNext()) {
                Path file = i.next();
                ++count;
                if (!Files.isDirectory(file, new LinkOption[0])) continue;
                nestedFolder = true;
                toCopy = file;
            }
            if (count != 1 || !nestedFolder) {
                toCopy = tempPath;
            }
            if (toCopy == null) {
                logger.error("Was not able to find extracted unit, decompression may have failed");
                return;
            }
            if (toCopy.equals(desiredPath)) {
                return;
            }
            if (!desiredPath.toFile().exists()) {
                Files.createDirectory(desiredPath, new FileAttribute[0]);
            }
            String originalUnitName = toCopy.getFileName().toString();
            String originalINI = originalUnitName + ".ini";
            DirectoryStream<Path> copyStream = Files.newDirectoryStream(toCopy);
            for (Path file : copyStream) {
                Path target;
                if (!file.toFile().isDirectory()) {
                    if (file.getFileName().toString().toLowerCase().equals(originalINI.toLowerCase())) {
                        target = Paths.get(desiredPath.toString() + Main.fileSlash + name + ".ini", new String[0]);
                        if (Files.isDirectory(file, new LinkOption[0])) continue;
                        if (!target.toFile().exists()) {
                            Files.copy(file, target, new CopyOption[0]);
                        }
                        Files.delete(file);
                        continue;
                    }
                    target = Paths.get(desiredPath.toString() + Main.fileSlash + file.getFileName(), new String[0]);
                    if (Files.isDirectory(file, new LinkOption[0])) continue;
                    if (!target.toFile().exists()) {
                        Files.copy(file, target, new CopyOption[0]);
                    }
                    try {
                        Files.delete(file);
                    }
                    catch (IOException ex) {
                        DosFileAttributes dosAttributes = Files.readAttributes(file, DosFileAttributes.class, new LinkOption[0]);
                        if (!dosAttributes.isReadOnly()) continue;
                        Files.setAttribute(file, "dos:readonly", false, new LinkOption[0]);
                        Files.delete(file);
                    }
                    continue;
                }
                target = Paths.get(desiredPath.toString() + Main.fileSlash + file.getFileName(), new String[0]);
                utils.copy(file.toString(), target.toString(), true);
            }
            copyStream.close();
            if (count == 1 && nestedFolder) {
                Files.delete(toCopy);
                Files.delete(toCopy.getParent());
            } else {
                Files.delete(toCopy);
            }
        }
        catch (IOException ex) {
            this.lblDownloadStatus.setText("An IO error, " + ex.getMessage() + " occurred while copying files to the scenario folder.  The log will have details.  Please report the error and which unit you were trying to download to the CFC thread.");
            logger.error("Error when copying files", ex);
        }
    }
}

