/*
 * Decompiled with CFR 0.152.
 */
package com.civfanatics.civ3.xplatformeditor.imageSupport;

import java.awt.Color;

public class Bitmap {
    int[][] map;
    int xsize;
    int ysize;
    int xindex;
    int yindex;
    int yStep;

    public Bitmap(int xsize, int ysize, boolean startAtTop) {
        if (startAtTop) {
            this.yindex = 0;
            this.yStep = 1;
        } else {
            this.yindex = ysize - 1;
            this.yStep = -1;
        }
        this.xsize = xsize;
        this.ysize = ysize;
        this.xindex = 0;
        this.map = new int[ysize][xsize];
    }

    public Bitmap(int xsize, int ysize) {
        this(xsize, ysize, true);
    }

    public void add(Color color) {
        this.add(color, true);
    }

    private void add(Color color, boolean goToNextLine) {
        this.map[this.yindex][this.xindex] = color.getRGB();
        ++this.xindex;
        if (this.xindex >= this.xsize && goToNextLine) {
            this.goToNextScanLine();
        }
    }

    public void goToNextScanLine() {
        if (this.xindex == 0) {
            return;
        }
        for (int x = this.xindex; x < this.xsize; ++x) {
            this.add(Color.BLACK, false);
        }
        this.xindex = 0;
        this.yindex += this.yStep;
    }

    public int addRepeats(int repeats, Color color) {
        int count = 0;
        for (int i = 0; i < repeats; ++i) {
            this.map[this.yindex][this.xindex] = color.getRGB();
            ++this.xindex;
            if (this.xindex >= this.xsize) {
                this.goToNextScanLine();
            }
            ++count;
        }
        return count;
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        for (int i = 0; i < this.xsize; ++i) {
            str.append("[");
            for (int j = 0; j < this.ysize; ++j) {
                str.append("[");
                str.append(this.map[j][i]);
                str.append("]");
            }
            str.append("]\n");
        }
        return str.toString();
    }

    public int[][] getMap() {
        return this.map;
    }

    public Color getPixel(int x, int y) {
        return new Color(this.map[y][x]);
    }

    public int getPixelRed(int x, int y) {
        return new Color(this.map[y][x]).getRed();
    }

    public int getPixelGreen(int x, int y) {
        return new Color(this.map[y][x]).getGreen();
    }

    public int getPixelBlue(int x, int y) {
        return new Color(this.map[y][x]).getBlue();
    }

    public int getPixelRGB(int x, int y) {
        return this.map[y][x];
    }
}

