/*
 * Decompiled with CFR 0.152.
 */
package com.civfanatics.civ3.xplatformeditor.imageSupport;

import com.civfanatics.civ3.biqFile.util.LittleEndianDataInputStream;
import com.civfanatics.civ3.xplatformeditor.imageSupport.PCXFilter;
import com.civfanatics.civ3.xplatformeditor.imageSupport.Palette256;
import java.awt.Color;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;

public class Civ3PCXFilter
extends PCXFilter {
    private String fileName = "";
    public boolean civ3TransparencyEnabled = true;
    public List<Short> transparents;

    public Civ3PCXFilter(String string) {
        super(string);
        this.fileName = string;
        this.transparents = new LinkedList<Short>();
        this.transparents.add(Short.parseShort("254"));
        this.transparents.add(Short.parseShort("255"));
    }

    public String getFileName() {
        return this.fileName;
    }

    public void resetTransparents() {
        this.transparents = new LinkedList<Short>();
    }

    public void addTransparent(Short num) {
        this.transparents.add(num);
    }

    @Override
    protected void importPalette(LittleEndianDataInputStream in) {
        try {
            int i;
            this.palette = new Palette256();
            for (i = 0; i < 256; ++i) {
                byte red = in.readByte();
                byte green = in.readByte();
                byte blue = in.readByte();
                this.palette.addColor(red, green, blue);
            }
            for (i = 0; i < this.transparents.size(); ++i) {
                this.palette.setColor(this.transparents.get(i).shortValue(), new Color(0, 0, 0, 0));
            }
        }
        catch (IOException e) {
            logger.error("IOException", e);
        }
    }

    @Override
    public void setColor(int paletteIndex, Color color) {
        Color oldColor = this.palette.getColor((byte)(0xFF & paletteIndex));
        this.palette.setColor(paletteIndex, color);
        for (int y = 0; y < this.bitmap.ysize; ++y) {
            for (int x = 0; x < this.bitmap.xsize; ++x) {
                if (this.bitmap.map[y][x] != oldColor.getRGB()) continue;
                this.bitmap.map[y][x] = color.getRGB();
            }
        }
    }
}

