/*
 * Decompiled with CFR 0.152.
 */
package com.civfanatics.civ3.xplatformeditor.imageSupport;

import com.civfanatics.civ3.xplatformeditor.imageSupport.Bitmap;
import com.civfanatics.civ3.xplatformeditor.imageSupport.Palette256;

public class IndexedBitmap
extends Bitmap {
    Palette256 palette;
    byte[][] colorIndices;

    public IndexedBitmap(int xsize, int ysize, boolean startAtTop) {
        super(xsize, ysize, startAtTop);
        this.colorIndices = new byte[ysize][xsize];
    }

    public IndexedBitmap(int xsize, int ysize) {
        super(xsize, ysize, true);
        this.colorIndices = new byte[ysize][xsize];
    }

    public int addRepeats(int repeats, int index) {
        int count = 0;
        int rgb = this.palette.getColor((byte)index).getRGB();
        byte idx = (byte)index;
        for (int i = 0; i < repeats; ++i) {
            this.map[this.yindex][this.xindex] = rgb;
            this.colorIndices[this.yindex][this.xindex] = idx;
            ++this.xindex;
            if (this.xindex >= this.xsize) {
                this.goToNextScanLine();
            }
            ++count;
        }
        return count;
    }

    public void add(int index) {
        this.map[this.yindex][this.xindex] = this.palette.getColor((byte)index).getRGB();
        this.colorIndices[this.yindex][this.xindex] = (byte)index;
        ++this.xindex;
        if (this.xindex >= this.xsize) {
            this.goToNextScanLine();
        }
    }

    public byte getPixelIndex(int x, int y) {
        return this.colorIndices[y][x];
    }
}

