/*
 * Decompiled with CFR 0.152.
 */
package com.civfanatics.civ3.xplatformeditor.imageSupport;

import com.civfanatics.civ3.biqFile.util.LittleEndianDataInputStream;
import com.civfanatics.civ3.biqFile.util.LittleEndianDataOutputStream;
import com.civfanatics.civ3.xplatformeditor.imageSupport.Bitmap;
import com.civfanatics.civ3.xplatformeditor.imageSupport.ImageFilter;
import com.civfanatics.civ3.xplatformeditor.imageSupport.IndexedBitmap;
import com.civfanatics.civ3.xplatformeditor.imageSupport.Palette256;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class PCXFilter
implements ImageFilter {
    static long readTime = 0L;
    static long parseTime = 0L;
    static long bufferedTime = 0L;
    static final boolean printPalette = false;
    static final boolean printBitmap = false;
    boolean civ3TransparencyEnabled = false;
    BufferedImage thisBufferedImage;
    boolean[] rowEnds;
    static Logger logger = Logger.getLogger("pcxFilter");
    String newline = "\n";
    boolean printDiagnostics = false;
    File pcxFile;
    byte[] buffer;
    byte manufacturer;
    byte version;
    byte encoding;
    byte bitsPerPixel;
    short xmin;
    short ymin;
    short xmax;
    short ymax;
    short horizontalResolution;
    short verticalResolution;
    byte[] EGA_Colormap = new byte[48];
    byte reserved;
    byte numColorPlanes;
    short bytesPerLine;
    short paletteInfo;
    short hScreenSize;
    short vScreenSize;
    short xsize;
    public short ysize;
    Bitmap bitmap;
    public Palette256 palette;

    public PCXFilter(String string) {
        logger.setLevel(Level.INFO);
        this.pcxFile = new File(string);
    }

    @Override
    public void processFile() {
        this.readFile();
        this.parse();
        this.createBufferedImage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readFile() {
        long start = System.nanoTime();
        FilterInputStream inFile = null;
        try {
            inFile = new LittleEndianDataInputStream(new BufferedInputStream(new FileInputStream(this.pcxFile)));
            this.buffer = new byte[(int)this.pcxFile.length()];
            ((LittleEndianDataInputStream)inFile).readFully(this.buffer);
        }
        catch (IOException e) {
            logger.error("IO exception while reading", e);
        }
        finally {
            try {
                inFile.close();
            }
            catch (IOException e) {
                logger.error("IO exception while closing", e);
            }
        }
        readTime += System.nanoTime() - start;
    }

    public void parse() {
        long start = System.nanoTime();
        LittleEndianDataInputStream in = new LittleEndianDataInputStream(new ByteArrayInputStream(this.buffer));
        try {
            this.manufacturer = in.readByte();
            this.version = in.readByte();
            this.encoding = in.readByte();
            this.bitsPerPixel = in.readByte();
            this.xmin = in.readShort();
            this.ymin = in.readShort();
            this.xmax = in.readShort();
            this.ymax = in.readShort();
            this.xsize = (short)(this.uminus(this.xmax, this.xmin) + 1);
            this.ysize = (short)(this.uminus(this.ymax, this.ymin) + 1);
            this.horizontalResolution = in.readShort();
            this.verticalResolution = in.readShort();
            in.read(this.EGA_Colormap, 0, 48);
            this.reserved = in.readByte();
            this.numColorPlanes = in.readByte();
            this.bytesPerLine = in.readShort();
            this.paletteInfo = in.readShort();
            this.hScreenSize = in.readShort();
            this.vScreenSize = in.readShort();
            if (this.printDiagnostics) {
                logger.info("manufacturer: " + this.manufacturer);
                logger.info("version: " + this.version);
                logger.info("encoding: " + this.encoding);
                logger.info("bits per pixel: " + this.bitsPerPixel);
                logger.info("xmin: " + this.xmin);
                logger.info("ymin: " + this.ymin);
                logger.info("xmax: " + this.xmax);
                logger.info("ymax: " + this.ymax);
                logger.info("xsize: " + this.xsize);
                logger.info("ysize: " + this.ysize);
            }
            in.skip(54L);
            in.mark(this.buffer.length);
            if (this.version == 5 && this.bitsPerPixel == 8 && this.numColorPlanes == 1) {
                this.import256ColorPCX(in);
            } else if (this.version == 5 && this.bitsPerPixel == 8 && this.numColorPlanes == 3) {
                this.import24BitPCX(in);
            } else if (this.version == 5 && this.bitsPerPixel == 1 && this.numColorPlanes == 1) {
                this.import1BitPCX(in);
            }
        }
        catch (IOException e) {
            logger.error("Error caught: ", e);
        }
        parseTime += System.nanoTime() - start;
    }

    public void createBufferedImage() {
        long start = System.nanoTime();
        this.thisBufferedImage = new BufferedImage(this.xsize, this.ysize, 2);
        for (int y = 0; y < this.ysize; ++y) {
            this.thisBufferedImage.setRGB(0, y, this.xsize, 1, this.bitmap.getMap()[y], 0, this.xsize);
        }
        bufferedTime += System.nanoTime() - start;
    }

    public BufferedImage getSubimage(int xStart, int yStart, int width, int height) {
        BufferedImage subimage = new BufferedImage(width, height, 2);
        int[] rgbArray = new int[width * height];
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                rgbArray[y * width + x] = this.bitmap.getPixelRGB(x + xStart, y + yStart);
            }
        }
        subimage.setRGB(0, 0, width, height, rgbArray, 0, width);
        return subimage;
    }

    @Override
    public BufferedImage getBufferedImage() {
        return this.thisBufferedImage;
    }

    @Override
    public int getWidth() {
        return this.xsize;
    }

    @Override
    public int getHeight() {
        return this.ysize;
    }

    public String toString() {
        StringBuffer toStr = new StringBuffer(1000);
        toStr.append("Manufacturer: " + PCXFilter.toString(this.manufacturer) + this.newline);
        toStr.append("Version: " + PCXFilter.toString(this.version) + this.newline);
        toStr.append("Encoding: " + PCXFilter.toString(this.encoding) + this.newline);
        toStr.append("BitsPerPixel: " + PCXFilter.toString(this.bitsPerPixel) + this.newline);
        toStr.append("Xmin: " + PCXFilter.toString(this.xmin) + this.newline);
        toStr.append("Ymin: " + PCXFilter.toString(this.ymin) + this.newline);
        toStr.append("Xmax: " + PCXFilter.toString(this.xmax) + this.newline);
        toStr.append("Ymax: " + PCXFilter.toString(this.ymax) + this.newline);
        toStr.append("XSize: " + PCXFilter.toString(this.xsize) + this.newline);
        toStr.append("YSize: " + PCXFilter.toString(this.ysize) + this.newline);
        toStr.append("horizontalResolution: " + PCXFilter.toString(this.horizontalResolution) + this.newline);
        toStr.append("verticalResolution: " + PCXFilter.toString(this.verticalResolution) + this.newline);
        toStr.append("numColorPlanes: " + PCXFilter.toString(this.numColorPlanes) + this.newline);
        toStr.append("bytesPerScanLine: " + PCXFilter.toString(this.bytesPerLine) + this.newline);
        toStr.append("paletteInfo: " + PCXFilter.toString(this.paletteInfo) + this.newline);
        toStr.append("hScreenSize: " + PCXFilter.toString(this.hScreenSize) + this.newline);
        toStr.append("vScreenSize: " + PCXFilter.toString(this.vScreenSize) + this.newline);
        return toStr.toString();
    }

    private int uminus(int one, int two) {
        if (two > one) {
            return 0;
        }
        long oneI = 0xFFFFFFFFL & (long)one;
        long twoI = 0xFFFFFFFFL & (long)two;
        long aI = oneI - twoI;
        int toReturn = aI > Integer.MAX_VALUE ? (int)(aI - 0x100000000L) : (int)aI;
        return toReturn;
    }

    private short uminus(short one, short two) {
        if (two > one) {
            return 0;
        }
        int oneI = one & 0xFFFF;
        int twoI = two & 0xFFFF;
        int aI = oneI - twoI;
        short toReturn = aI > Short.MAX_VALUE ? (short)(aI - 65536) : (short)aI;
        return toReturn;
    }

    private byte uminus(byte one, byte two) {
        if (two > one) {
            return 0;
        }
        int oneI = one & 0xFF;
        int twoI = two & 0xFF;
        int aI = oneI - twoI;
        byte toReturn = aI > 127 ? (byte)(aI - 256) : (byte)aI;
        return toReturn;
    }

    private static String toString(int uint) {
        if (uint >= 0) {
            return Integer.toString(uint);
        }
        return Long.toString((long)uint + 0x100000000L);
    }

    private static String toString(short ushort) {
        if (ushort >= 0) {
            return Short.toString(ushort);
        }
        return Integer.toString(ushort + 65536);
    }

    private static String toString(byte ubyte) {
        if (ubyte >= 0) {
            return Byte.toString(ubyte);
        }
        return Short.toString((short)(ubyte + 256));
    }

    protected void import256ColorPCX(LittleEndianDataInputStream in) {
        try {
            in.skip(this.buffer.length - 128 - 769);
            byte check = in.readByte();
            if (check == 12) {
                this.importPalette(in);
            } else {
                logger.error("Incorrect byte prior to expected 256 color palette");
                logger.error("Byte is " + PCXFilter.toString(check));
                logger.error("Jumped " + (this.buffer.length - 128 - 769) + " bytes after header");
            }
            in.reset();
            int pixelCount = 0;
            int numPixelsFromRepeats = 0;
            this.bitmap = new IndexedBitmap(this.bytesPerLine, this.ysize);
            ((IndexedBitmap)this.bitmap).palette = this.palette;
            this.rowEnds = new boolean[this.ysize];
            int maxSize = this.bytesPerLine * this.ysize;
            while (pixelCount < maxSize) {
                byte temp = in.readByte();
                int stemp = temp & 0xFF;
                if (stemp >= 192) {
                    int repeats = stemp & 0x3F;
                    if (logger.isDebugEnabled()) {
                        logger.debug("Processed " + pixelCount + " pixels.");
                        logger.debug("To repeat " + repeats + " times.");
                    }
                    byte color = in.readByte();
                    repeats = ((IndexedBitmap)this.bitmap).addRepeats(repeats, color);
                    pixelCount += repeats;
                    numPixelsFromRepeats += repeats;
                } else {
                    ((IndexedBitmap)this.bitmap).add(temp);
                    ++pixelCount;
                }
                if (!logger.isDebugEnabled() || pixelCount <= 1400000) continue;
                logger.debug("Processed " + pixelCount + " pixels.");
            }
            if (this.printDiagnostics) {
                // empty if block
            }
            if (logger.isDebugEnabled()) {
                for (int i = 0; i < this.rowEnds.length; ++i) {
                    logger.info(i + ": " + this.rowEnds[i]);
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug(this.toString());
            }
        }
        catch (IOException e) {
            logger.error("IOException", e);
        }
    }

    private void import24BitPCX(LittleEndianDataInputStream in) {
        try {
            int pixelCount = 0;
            int numPixelsFromRepeats = 0;
            int row = 0;
            this.bitmap = new Bitmap(this.bytesPerLine, this.ysize);
            this.rowEnds = new boolean[this.ysize];
            while (pixelCount < this.bytesPerLine * this.ysize * 3) {
                int xCount = 0;
                int rgbArray = 0;
                Bitmap[] rgbBitmaps = new Bitmap[]{new Bitmap(this.bytesPerLine, 1), new Bitmap(this.bytesPerLine, 1), new Bitmap(this.bytesPerLine, 1)};
                while (xCount < this.bytesPerLine * 3) {
                    byte temp = in.readByte();
                    int stemp = temp & 0xFF;
                    if (stemp >= 192) {
                        int repeats = stemp & 0x3F;
                        if (logger.isDebugEnabled()) {
                            logger.debug("Processed " + pixelCount + " pixels.");
                            logger.debug("To repeat " + repeats + " times.");
                        }
                        byte color = in.readByte();
                        int sColor = color & 0xFF;
                        if (rgbArray == 0) {
                            repeats = rgbBitmaps[0].addRepeats(repeats, new Color(sColor, 0, 0));
                        } else if (rgbArray == 1) {
                            repeats = rgbBitmaps[1].addRepeats(repeats, new Color(0, sColor, 0));
                        } else if (rgbArray == 2) {
                            repeats = rgbBitmaps[2].addRepeats(repeats, new Color(0, 0, sColor));
                        }
                        pixelCount += repeats;
                        xCount += repeats;
                        numPixelsFromRepeats += repeats;
                    } else {
                        if (rgbArray == 0) {
                            try {
                                rgbBitmaps[0].add(new Color(stemp, 0, 0));
                            }
                            catch (IllegalArgumentException e) {
                                logger.error("red: " + stemp, e);
                                System.exit(1);
                            }
                        } else if (rgbArray == 1) {
                            rgbBitmaps[1].add(new Color(0, stemp, 0));
                        } else if (rgbArray == 2) {
                            rgbBitmaps[2].add(new Color(0, 0, stemp));
                        }
                        ++pixelCount;
                        ++xCount;
                    }
                    if (pixelCount % this.bytesPerLine != 0) continue;
                    ++rgbArray;
                }
                for (int i = 0; i < this.bytesPerLine; ++i) {
                    Color color = new Color(rgbBitmaps[0].getPixelRed(i, 0), rgbBitmaps[1].getPixelGreen(i, 0), rgbBitmaps[2].getPixelBlue(i, 0));
                    this.bitmap.add(color);
                }
                System.out.println("row: " + row);
                ++row;
            }
            if (this.printDiagnostics) {
                logger.info("Processed " + pixelCount + " pixels");
                logger.info(numPixelsFromRepeats + " pixels were from repeats");
            }
            if (logger.isDebugEnabled()) {
                for (int i = 0; i < this.rowEnds.length; ++i) {
                    logger.info(i + ": " + this.rowEnds[i]);
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug(this.toString());
            }
        }
        catch (IOException e) {
            logger.error("IOException", e);
        }
    }

    private void import1BitPCX(LittleEndianDataInputStream in) {
        try {
            int pixelCount = 0;
            int numPixelsFromRepeats = 0;
            boolean row = false;
            this.bitmap = new Bitmap(this.bytesPerLine * 8, this.ysize);
            this.rowEnds = new boolean[this.ysize];
            System.out.println(this.bytesPerLine * this.ysize);
            while (pixelCount < this.bytesPerLine * this.ysize * 8) {
                byte temp = in.readByte();
                int stemp = temp & 0xFF;
                if (stemp >= 192) {
                    int repeats = stemp & 0x3F;
                    repeats <<= 3;
                    if (logger.isDebugEnabled()) {
                        logger.debug("Processed " + pixelCount + " pixels.");
                        logger.debug("To repeat " + repeats + " times.");
                    }
                    byte color = in.readByte();
                    int color256 = color * 255;
                    Color nextColor = new Color(color256, color256, color256);
                    for (int j = 0; j < repeats; ++j) {
                        this.bitmap.add(nextColor);
                    }
                    pixelCount += repeats;
                    numPixelsFromRepeats += repeats;
                } else {
                    byte color = in.readByte();
                    int color256 = color * 255;
                    Color nextColor = new Color(color256, color256, color256);
                    this.bitmap.add(nextColor);
                    ++pixelCount;
                }
                if (pixelCount % (this.bytesPerLine * 8) == 0) {
                    this.rowEnds[pixelCount / (this.bytesPerLine * 8) - 1] = true;
                }
                if (!logger.isInfoEnabled() || pixelCount <= 1400000) continue;
                logger.info("Processed " + pixelCount + " pixels.");
            }
            if (this.printDiagnostics) {
                logger.info("Processed " + pixelCount + " pixels");
                logger.info(numPixelsFromRepeats + " pixels were from repeats");
            }
            if (logger.isDebugEnabled()) {
                for (int i = 0; i < this.rowEnds.length; ++i) {
                    logger.info(i + ": " + this.rowEnds[i]);
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug(this.toString());
            }
        }
        catch (IOException e) {
            logger.error("IOException", e);
        }
    }

    public void saveExistingPCX(String filename) {
        File file = new File(filename);
        try {
            int i;
            LittleEndianDataOutputStream dos = new LittleEndianDataOutputStream(new FileOutputStream(file));
            dos.writeByte(this.manufacturer);
            dos.writeByte(this.version);
            dos.writeByte(this.encoding);
            dos.writeByte(this.bitsPerPixel);
            dos.writeShort(this.xmin);
            dos.writeShort(this.ymin);
            dos.writeShort(this.xmax);
            dos.writeShort(this.ymax);
            dos.writeShort(this.horizontalResolution);
            dos.writeShort(this.verticalResolution);
            dos.write(this.EGA_Colormap, 0, 48);
            dos.writeByte(this.reserved);
            dos.writeByte(this.numColorPlanes);
            dos.writeShort(this.bytesPerLine);
            dos.writeShort(this.paletteInfo);
            dos.writeShort(this.hScreenSize);
            dos.writeShort(this.vScreenSize);
            for (i = 0; i < 54; ++i) {
                dos.writeByte(0);
            }
            for (int y = 0; y < this.bitmap.ysize; ++y) {
                int repeats;
                for (int x = 0; x < this.bitmap.xsize; x += repeats) {
                    byte firstByte;
                    byte color = ((IndexedBitmap)this.bitmap).getPixelIndex(x, y);
                    repeats = 0;
                    for (int xx = x + 1; xx < this.bitmap.xsize && xx < 63 + x && ((IndexedBitmap)this.bitmap).getPixelIndex(xx, y) == color; ++xx) {
                        ++repeats;
                    }
                    if (repeats > 0) {
                        ++repeats;
                    }
                    byte colorInPalette = color;
                    byte secondByte = 0;
                    boolean writeTwoBytes = false;
                    if (repeats > 0) {
                        firstByte = (byte)(0xC0 | repeats);
                        secondByte = colorInPalette;
                        writeTwoBytes = true;
                    } else {
                        byte toCompare = -65;
                        if (colorInPalette < 0 && colorInPalette > toCompare) {
                            firstByte = -63;
                            secondByte = colorInPalette;
                            writeTwoBytes = true;
                        } else {
                            firstByte = colorInPalette;
                        }
                    }
                    dos.writeByte(firstByte);
                    if (writeTwoBytes) {
                        dos.writeByte(secondByte);
                    }
                    ++x;
                    if (repeats <= 0) continue;
                    --x;
                }
            }
            dos.writeByte(12);
            for (i = 0; i < 256; ++i) {
                dos.writeByte(this.palette.palette[i].getRed());
                dos.writeByte(this.palette.palette[i].getGreen());
                dos.writeByte(this.palette.palette[i].getBlue());
            }
            dos.close();
        }
        catch (FileNotFoundException e) {
            logger.error("File not found", e);
        }
        catch (IOException e) {
            logger.error("IOException", e);
        }
    }

    private byte findInPalette(int color) {
        for (int i = 0; i < this.palette.paletteSize; ++i) {
            if (color != this.palette.palette[i].getRGB()) continue;
            return (byte)(0xFF & i);
        }
        return -1;
    }

    public void setColor(int index, Color color) {
        Color oldColor = this.palette.palette[index];
        this.palette.palette[index] = color;
        for (int x = 0; x < this.bitmap.xsize; ++x) {
            for (int y = 0; y < this.bitmap.ysize; ++y) {
                if (this.bitmap.map[x][y] != color.getRGB()) continue;
                this.bitmap.map[x][y] = color.getRGB();
            }
        }
    }

    protected void importPalette(LittleEndianDataInputStream in) {
        try {
            this.palette = new Palette256();
            for (int i = 0; i < 256; ++i) {
                byte red = in.readByte();
                byte green = in.readByte();
                byte blue = in.readByte();
                this.palette.addColor(red, green, blue);
            }
        }
        catch (IOException e) {
            logger.error("IOException", e);
        }
    }

    public Color getColorAt(int x, int y) {
        return this.bitmap.getPixel(x, y);
    }

    public static void printStats() {
        System.out.println("Read time : " + readTime / 1000000L + " ms");
        System.out.println("Parse time : " + parseTime / 1000000L + " ms");
        System.out.println("Buffered time : " + bufferedTime / 1000000L + " ms");
    }
}

